<?php

/*ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);*/

// No direct access
defined('_JEXEC') or die;
require JPATH_BASE . '/vendor/autoload.php';

use yidas\googleMaps\Client;

/**

 * @author 

 */
class AuditModelGps extends JModelLegacy {

    public function __construct() {
        parent::__construct();

        $this->db = &JFactory::getDBO();
        $this->app = JFactory::getApplication();
        $this->doc = JFactory::getDocument();
        $this->server_path = $_SERVER['DOCUMENT_ROOT'];
        $this->user = & JFactory::getUser();
        $this->lang = & JFactory::getLanguage();
        $this->config = &JFactory::getConfig();
        
        $this->dev_n_tools_table = '#__devices_n_tools';
        $this->popup_field_list = [
            'manual_time' => [
               'field_name' => JText::_('COM_AUDIT_TASK_MANAGER_NEW_DEVICES_N_TOOLS_PAGE_FIELDS_POPUP_MANUAL_TIME'),
               'field_value' => 'manual_time'
            ],
            'manual_text' => [
               'field_name' => JText::_('COM_AUDIT_TASK_MANAGER_NEW_DEVICES_N_TOOLS_PAGE_FIELDS_POPUP_MANUAL_TEXT'),
               'field_value' => 'manual_text'
            ],
            'auto_col_text' => [
               'field_name' => JText::_('COM_AUDIT_TASK_MANAGER_NEW_DEVICES_N_TOOLS_PAGE_FIELDS_POPUP_AUTO_COL_TEXT'),
               'field_value' => 'auto_col_text'
            ],
            'numbers' => [
               'field_name' => JText::_('COM_AUDIT_TASK_MANAGER_NEW_DEVICES_N_TOOLS_PAGE_FIELDS_POPUP_NUMBERS'),
               'field_value' => 'numbers'
            ],
            'total' => [
               'field_name' => JText::_('COM_AUDIT_TASK_MANAGER_NEW_DEVICES_N_TOOLS_PAGE_FIELDS_POPUP_TOTAL'),
               'field_value' => 'total'
            ]
           /*[
               'field_name' => 'Date',
               'field_value' => 'date'
           ],
           [
               'field_name' => 'Clock in',
               'field_value' => 'clock_in'
           ],
           [
               'field_name' => 'Clock out',
               'field_value' => 'clock_out'
           ],*/
           ,/*
           [
               'field_name' => 'Task manager',
               'field_value' => 'task_manager'
           ],
           [
               'field_name' => 'From',
               'field_value' => 'from'
           ],
           [
               'field_name' => 'To',
               'field_value' => 'to'
           ],
           [
               'field_name' => 'Request ID',
               'field_value' => 'request_id'
           ],
           [
               'field_name' => 'Container',
               'field_value' => 'container'
           ],
           [
               'field_name' => 'Trailer',
               'field_value' => 'trailer'
           ],
           [
               'field_name' => 'KM',
               'field_value' => 'km'
           ],
           [
               'field_name' => 'Number',
               'field_value' => 'number'
           ],
           [
               'field_name' => 'Lyftari vid komu',
               'field_value' => 'lyftari'
           ],
           [
               'field_name' => 'Lyftari afhending',
               'field_value' => 'lyftaria'
           ],
           [
               'field_name' => 'Onnur vinn',
               'field_value' => 'onnur'
           ],
           [
               'field_name' => 'Samtals',
               'field_value' => 'samtals'
           ],
           [
               'field_name' => 'Kaelvel i lagi ja Nei',
               'field_value' => 'kaelvel'
           ],
           [
               'field_name' => 'Losad i gati Samh.',
               'field_value' => 'losad'
           ],
           [
               'field_name' => 'Athugasemdir og skyringar',
               'field_value' => 'athug'
           ],
           [
               'field_name' => 'Map',
               'field_value' => 'map'
           ],*/
          
        ];
        $this->custom_fields = [
            'custom_column_name',
            'custom_column_value',
            'custom_column_type',
            'custom_column_visibility',
            //'custom_column_order'
        ];
        
        $this->users_table = '#__users';
        $this->enable_load_total_from_pp = 1;
        
        if ($this->lang->getName() == "Íslenska (Ísland)") {
            $l2 = 'is';
        } else {
            $l2 = 'en';
        }
        $this->l2 = $l2;
        
        $this->enable_autocollect_type_of_load_for_api = 1;
        $this->gmaps = new \yidas\googleMaps\Client(['key' => 'AIzaSyCqyCP48wsmm8wwMm77mwfDBQJbnbqTzrU']);
        $this->calculate_custom_total = 1;
        $this->enable_sortable_custom_headers = 1;
       
        
        $this->enable_period_on_dev_n_tools = $this->config->get('enable_period_on_dev_n_tools');
    }

    public function prepareUsersListInReportHtml(array $res, string $lang, object $user, string $mode) {

            
        if ($mode === 'for_devices_n_tools') {
            $html = '<div class="one_option" data-option-value="all">';
            $url = ($mode == 'for_route_map') ? 'route-map' : 'devices-and-tools';
            if ($lang == 'is') {
                $link = '/is/' . $url . '?user_id=all';
            } else {
                $link = '/' . $url . '?user_id=all';
            }
            $html .= '<a href="' . $link . '"><span>' . JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_SHOW_ALL') . '</span></a>';
            $html .= '</div>';
        }
        
        foreach ($res as $one_user) {
            $username_final = $this->getFinalUsername($one_user);
            $url = ($mode == 'for_route_map') ?  'route-map' : 'devices-and-tools';
             
            if ($lang == 'is') {
                $link = '/is/' . $url . '?user_id=' . $one_user->id;
            } else {
                $link = '/' . $url . '?user_id=' . $one_user->id;
            }

            unset($class);

            $html .= '';
            if ($user->id == $one_user->id) {
                $class = ' selected_option_active';
            } 
            
                $html .= ''
                    . '<div class="one_option' . $class . '" data-option-value="' . $one_user->id . '">'
                    . '<a href="' . $link . '"><span>' . $username_final . '</span></a>'
                    //. '<i class="fa fa-circle-thin" aria-hidden="true"></i>'
                    . '</div>';
        }

        return $html;
    }

    public function getFinalUsername(object $user_obj) {
        $user_from_request_name = '';
        if (!empty($user_obj->username0)) {
            $user_from_request_name = $user_obj->username0;
        } elseif (!empty($user_obj->username)) {
            $user_from_request_name = $user_obj->username;
        } elseif (!empty($user_obj->name)) {
            $user_from_request_name = $user_obj->name;
        } else {
            $user_from_request_name = 'empty_username';
        }

        return $user_from_request_name;
    }
    
    public function addRoute(string $lang, int $user_id, $date = null) {
        $item = new stdClass();
        
        $item->id = null;
        $item->user_id = $user_id;
        $item->created_at = date('Y-m-d H:i:s');
        $item->updated_at = null;
        $item->created_timestamp = time();
        $item->updated_timestamp = null;
        
        if(empty($date)){
            $final_date = date('d.m.Y H:i:s');
        } else{
            $final_date = date('d.m.Y H:i:s', strtotime($date . date('H:i:s')));
        }
        
        $item->date = $final_date;
        $item->clock_in = '00:00';
        $item->clock_out = '00:00';
        $item->total = '00:00';
        $item->task_manager = '';
        $item->from_t = '';
        $item->to_t = '';
        $item->km = 0;
        $item->map = '';
        $item->descr = '------';
        $item->who_added = 'manager';
       
        
        $item->column_order = $this->getLastColumnOrder($user_id);
        
        $this->db->insertObject($this->dev_n_tools_table, $item);
        $this->updateCustomColumnsForNewRoute($item, $user_id, $lang, $this->db->insertid());
    }
    
    private function loadUserWhoHaveSimilarCustomHeaders($route_custom, int $user_id) {
        $all_user_id = $this->loadCompanyUsersId($user_id);

        //get last row for current user
        $query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` IN(" . implode(",", $all_user_id) . ") AND ";
        
        foreach ($route_custom as $one_custom) {
            $filtered = [];
            $filtered_i = 0;

            foreach ($one_custom as $k => $v) {
                //echo $k . PHP_EOL;
                $arr_name = explode('custom_column_name', $k);
                $arr_val = explode('custom_column_value', $k);
                $arr_type = explode('custom_column_type', $k);
                $arr_visibility = explode('custom_column_visibility', $k);
               
                if (count($arr_name) == 2) {
                    //$filtered[$filtered_i][$k] = $v;
                    $final_field_n = 'custom_column_name' . $arr_name[1];
                    $query .= "`$final_field_n` !='' AND ";
                }
               
                if (count($arr_type) == 2) {
                    //$filtered[$filtered_i - 2][$k] = $v;
                    $final_field_t = 'custom_column_type' . $arr_type[1];
                    
                    $query .= "`$final_field_t` !='' AND ";
                }
                if (count($arr_visibility) == 2) {
                    //$filtered[$filtered_i - 3][$k] = $v;
                    $final_field_v = 'custom_column_visibility' . $arr_visibility[1];
                    //$query .= "`$final_field_v` ='1' AND ";
                    //echo $final_field;
                }

                $filtered_i++;
            }
        }
        $query = chop($query, ' AND');//remove last OR
        $query .= " ORDER BY `id` DESC LIMIT 0,1";
       
        $this->db->setQuery($query);
        $route = $this->db->loadObject();
        
        return $route;
    }
    
    private function updateCustomColumnsForNewRoute(stdClass $item, int $user_id, string $lang, $inserted_route_id) {
        
        $date = DateTime::createFromFormat('d.m.Y H:i:s', $item->date)->format('Y-m-d');
        $routes = $this->getRoutes($user_id, $date);
        $route_custom = $routes['custom'];

        if (!empty($route_custom)) {
            
            $last_user_with_customs = $this->loadUserWhoHaveSimilarCustomHeaders($route_custom, $user_id);
           
            if(empty($last_user_with_customs)){//no routes in company
                return false;
            }
           
            $query = "UPDATE $this->dev_n_tools_table SET ";       
            foreach ($route_custom as $one_custom) {
                $filtered = [];
                $filtered_i = 0;

                foreach ($one_custom as $k => $v) {
                    $arr_name = explode('custom_column_name', $k);
                    $arr_val = explode('custom_column_value', $k);
                    $arr_type = explode('custom_column_type', $k);
                    $arr_visibility = explode('custom_column_visibility', $k);

                    if (count($arr_name) == 2) {
                        $final_field_n = 'custom_column_name' . $arr_name[1];
                        $last_user_custom_name = $last_user_with_customs->$final_field_n;
                        $query .= "`$final_field_n` = '$last_user_custom_name', ";
                    }
                    
                    
                    if (count($arr_type) == 2) {
                        $final_field_t = 'custom_column_type' . $arr_type[1];
                        $last_user_custom_type = $last_user_with_customs->$final_field_t;
                        $query .= "`$final_field_t` = '$last_user_custom_type', ";
                    }
                    if (count($arr_visibility) == 2) {
                        $final_field_v = 'custom_column_visibility' . $arr_visibility[1];
                        $last_user_custom_visibility = $last_user_with_customs->$final_field_v;
                        /*echo '<pre>$last_user_custom_visibility';
                        print_r($last_user_custom_visibility);
                        echo '</pre>';*/
                        $query .= "`$final_field_v` = '$last_user_custom_visibility', ";
                    }

                    $filtered_i++;
                }
            }
            $query = chop($query, ' ,');//remove last OR
            $query .= " WHERE `user_id` = '$user_id'";
            
            $this->db->setQuery($query);
            $this->db->query(); 
        }
    }
    
    public function getLastColumnOrder(int $user_id) {

        $all_user_id = $this->loadCompanyUsersId($user_id);
        $query = "SELECT `column_order` FROM $this->dev_n_tools_table WHERE `column_order` != '' AND `user_id` IN(" . implode(",", $all_user_id) . ") ORDER BY `id` DESC LIMIT 0,1";
        $this->db->setQuery($query);
        $data = $this->db->loadObject()->column_order; 
        
        if(empty($data)){
            $data = '[]';
        }
        
        return $data;
    }
    
    public function getRoutes(string $user_id, $date = null, $from = null, $to = null) {
       
        if($user_id == 'all'){
            $all_user_id = $this->loadCompanyUsersId($this->user->id);
            $query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` IN(" . implode(",", $all_user_id) . ")";
        } else{
            $query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` = '".$user_id."'";
        }
        
        if(!empty($date) && empty($from) && empty($to)){
           $converted_date = DateTime::createFromFormat('Y-m-d', $date)->format('d.m.Y');
           $query .= " AND `date` LIKE '$converted_date%'";
        } elseif(empty($date) && !empty($from) && !empty($to) && $this->enable_period_on_dev_n_tools == '1'){
            
        } else{
            $converted_date = date('d.m.Y');
            $query .= " AND `date` LIKE '$converted_date%'";
        }
        
         /*if (!empty($date)) {
            if (empty($from) && empty($to)) {
                $converted_date = DateTime::createFromFormat('Y-m-d', $date)->format('d.m.Y');
                $query .= " AND `date` LIKE '$converted_date%'";
            } else {
                
            }
        } else {
            $converted_date = date('d.m.Y');
            $query .= " AND `date` LIKE '$converted_date%'";
        }*/
        $query .= " ORDER BY `id` DESC";
        //echo $query;
        $this->db->setQuery($query); 
        $data = $this->db->loadObjectList();
        
     
        if(empty($date) && !empty($from) && !empty($to) && $this->enable_period_on_dev_n_tools == '1'){
            $converted_from_obj = DateTime::createFromFormat('d.m.Y', $from);
            $converted_to_obj = DateTime::createFromFormat('d.m.Y', $to);
            $to_plus1 = clone $converted_to_obj;
            $to_plus1->modify('+1day');
            $data_filtered = [];
            
            
                
            foreach($data as $one_route){
                $route_date_obj = DateTime::createFromFormat('d.m.Y H:i:s', $one_route->date);
                //echo $route_date_obj->format('d.m.Y') . PHP_EOL;
                
                $interval = new DateInterval('P1D');
                $daterange = new DatePeriod($converted_from_obj, $interval, $to_plus1);
                $dates_array = [];
                
                foreach($daterange as $date1) {
                    $dates_array[] = $date1->format('d.m.Y');
                }
                if(in_array($route_date_obj->format('d.m.Y'), $dates_array)){
                    $data_filtered[] = $one_route;
                }
                
                //if($route_date_obj->format('U') >= $converted_from_obj->format('U') && $route_date_obj->format('U') <= $converted_to_obj->format('U')){
                /*if(in_array($daterange, $route_date_obj)){
                    echo 'dd';
                    $data_filtered[] = $one_route;
                }*/
            }
        }
        
        /*echo '<pre>$data_filtered';
        print_r($data_filtered);
        echo '</pre>';*/
        if($this->enable_load_total_from_pp === 1){
            foreach($data_filtered as $one_route){
                $pp_id = $one_route->pp_id;
                $user_id = $one_route->user_id;
                $date_obj = DateTime::createFromFormat('d.m.Y H:i:s', $one_route->date);
                $date = $date_obj->format('d.m.Y');
                $saved_total = $one_route->total;
                $confirm_id = $one_route->confirm_id;
                
                
                if(!empty($pp_id) && empty($saved_total)){
                    $calc_total = $this->loadSyncTotalValue($pp_id, $user_id, $date, 'pp');
                    $one_route->total = $calc_total;
                } if(empty($pp_id) && empty($saved_total) && !empty($confirm_id)){
                    $calc_total = $this->loadSyncTotalValue($confirm_id, $user_id, $date_obj->format('Y-m-d'), 'confirm');
                    $one_route->total = $calc_total;
                } 
            }       
        } 

        //filter custom columns to 1 array. You need select all items because customs not working correct with date
        $query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` = '".$user_id."'";
        $query .= " ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $data_for_custom = $this->db->loadObjectList();
        
        $custom = [];
        $i = 0;
        foreach($data_for_custom as $route){
            $j = 0;
            foreach($route as $k => $v){
               $exp_key = explode('-', $k);

               //get max value in key of custom columns
               if(count($exp_key) == 2 && in_array($exp_key[0], $this->custom_fields)){
                  $custom[$k] = $v; 
               }
               $j++;
            }
            $i++;
        }
        
        //filter custom columns to separate arrays, group by column number in key(custom_column_name-1, custom_column_value-1 should be in 1 array)
        $filtered = [];
        $filtered_i = 0;
        foreach($custom as $k => $v){
            $arr_name = explode('custom_column_name', $k);
            $arr_val = explode('custom_column_value', $k);
            $arr_type = explode('custom_column_type', $k);
            $arr_visibility = explode('custom_column_visibility', $k);
            
            if(count($arr_name) == 2 ){
                $filtered[$filtered_i][$k] = $v;
            }
            if(count($arr_val) == 2){
                $filtered[$filtered_i-1][$k] = $v;
            }
            if(count($arr_type) == 2){
                $filtered[$filtered_i-2][$k] = $v; 
            }
            if(count($arr_visibility) == 2){
                $filtered[$filtered_i-3][$k] = $v;
            }
            
            $filtered_i++;
        }
      
       
        $final = [];
        foreach($filtered as $one_custom){
            $final[] = $one_custom;
        }
        
        if($this->enable_sortable_custom_headers === 1){
            if(!empty($data) && !empty($data[0]->column_order)){
                $final = $this->reorderPropsCustom($final, json_decode($data[0]->column_order, true));
            } else{
                if( !empty($this->routes['custom'])){
                    $order = $this->getLastColumnOrder($u->id);
                    $final = $this->reorderPropsCustom($final, json_decode($order, true));
                }
            }
        }
        
        if($this->enable_period_on_dev_n_tools == 1 && !empty($from) && !empty($to)){
            return [
                'standart' => $data_filtered,
                'custom' => $final
            ];
        } else{
            return [
                'standart' => $data,
                'custom' => $final
            ];
        }
        
    }
    
    private function getArray($order_item, $obj) {

        foreach ($obj as $k => $v) {
            if (array_key_exists($order_item, $v)) {
                return $obj[$k];
            }
        }
    }
    
    private function getArrayForApi($order_item, $obj) {

        foreach ($obj as $k => $v) {
            /*if (in_array($order_item, $v)) {
                return $obj[$k];
            }*/
            if ($order_item === $v['cell_name']) {
                return $obj[$k];
            }
        }
    }

    private function reorderPropsCustom($obj, array $order) {
        $new_obj = new stdClass();
        $i = 0;
        foreach ($order as $prop) {
            //$new_obj->$prop = getArray($prop, $obj);
            $new_obj->$i = $this->getArray($prop, $obj);

            $i++;
        }
        return (array) $new_obj;
    }
    
    private function reorderPropsCustomForApi($obj, array $order) {
        $new_obj = new stdClass();
        $i = 0;
        foreach ($order as $prop) {
            //$new_obj->$prop = getArray($prop, $obj);
            $new_obj->$i = $this->getArrayForApi($prop, $obj);

            $i++;
        }
        return (array) $new_obj;
    }

    private function autocompletion($valueField)
    {
       
        if(strlen($valueField) === 5){//if 00:00 pattern
            $arr = explode(':', $valueField);
            $count = count($arr);
            if($count === 2){
                if($arr[0] > 23 || $arr[1] > 59){
                    $valueField = '23:59';
                }
            }
        }
        //echo strlen($valueField);
        switch (strlen($valueField)) {
            case 0:

                break;
            case 1:
                $valueField = '0' . $valueField . ':00';
                break;
            case 2:
                $valueField0 = str_split($valueField, 1);

                if ($valueField0[0] == '0') {
                    $valueField = '0' . $valueField0[1] . ':00';
                } else {
                    $valueField = $valueField0[0] . $valueField0[1] . ':00';
                }
                break;
            case 3:
                $valueField0 = str_split($valueField, 1);
                $valueField = $valueField0[0] . $valueField0[1] . ':00';
                break;
            case 4:
                $valueField0 = str_split($valueField, 1);
                /*echo '<pre>$valueField0';
                print_r($valueField0);
                echo '</pre>';*/
                
                if($valueField0[0] > 0 && $valueField0[1] == ':' ){
                     $valueField = '0' . $valueField0[0] . ':' . $valueField0[2] . $valueField0[3];
                } else{
                     $valueField = $valueField0[0] . $valueField0[1] . ':' . $valueField0[3] . '0';
                }
               
                break;
        }
        
        if($valueField == '24:00'){
            $valueField = '23:59';
        }
        
        return $valueField;
    }
    
    private function loadSyncTotalValue(int $pp_id, int $user_id, string $date, string $mode) {
        if ($mode === 'pp') {
            $protocol = 'https://';
            $pay_period_load_mode = 'api_front';
            $link = $protocol . $_SERVER['SERVER_NAME'] . '/index.php?task=getTimeByPeriodApiPP4OneDate&lang=' . $this->l2 . '&row_id=' . $pp_id . '&u_id=' . $user_id . '&date=' . $date . '&submode=api_html&mode=pdf&pay_period_load_mode=' . $pay_period_load_mode . '&load_for_holidays_percent=1';
            $html = file_get_contents($link);
            $total = 0;

            if (!empty($html)) {
                $model = JModelLegacy::getInstance('Custom_pay_period', 'AuditModel');
                $final_res = $model->prepareOneDateOfHtmlWithText($html, $user_id, $this->l2, $date, $pp_id);
                $total = $final_res['0']['total'];
            } else {
                $final_res = 'User timesheet is empty';
            }
        } elseif($mode === 'confirm'){
            $protocol = 'https://';
            $pay_period_load_mode = 'api_front';
            $link = $protocol . $_SERVER['SERVER_NAME'] . '/index.php?task=getUserConfirmRows&lang=' . $this->l2 . '&row_id=' . $pp_id . '&u_id=' . $user_id . '&date1=' . $date . '&submode=api_html&mode=pdf&pay_period_load_mode=' . $pay_period_load_mode . '&load_for_holidays_percent=1';
            $html = file_get_contents($link);
            $total = 0;
    
            if (!empty($html)) {
                $model = JModelLegacy::getInstance('Custom_pay_period', 'AuditModel');
                $final_res = $model->prepareConfirmHtml($html, $user_id, $this->l2, $date, $pp_id);
                $total = $final_res[0]['total'];
            } else {
                $final_res = 'User confirm is empty';
            }
            //echo $html;
            
        }

        return $total;
    }
    
    private function loadCompanyUsersId(int $user_id) {
        $owner_id = & JFactory::getUser($user_id)->owner_id;
        
        //load users of manager
        $query = "SELECT `id` FROM $this->users_table WHERE `owner_id` = '".$owner_id."' ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $manager_users = $this->db->loadObjectList();
        $all_user_id = array_column($manager_users, 'id');
        
        return $all_user_id;
    }
    
    public function addColumn(string $lang, int $user_id, string $column_type) {

        $all_user_id = $this->loadCompanyUsersId($user_id);

        //get last row for current user
        $query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` = '".$user_id."' ORDER BY `id` DESC LIMIT 0,1";
        $this->db->setQuery($query);
        $routes = $this->db->loadObjectList();
        if(empty($routes)){
            throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_ADD_COLUMN_ERROR_EMPTY_ROUTES'));
        }
       
        foreach($routes as $route){
            foreach($route as $k => $v){
               $exp_key = explode('-', $k);

               //get max value in key of custom columns
               if(count($exp_key) == 2 && in_array($exp_key[0], $this->custom_fields)){
                  $last_column_index[$exp_key[0]] = $exp_key[1];
               }
            }
        }
        
        //get current value in key of custom columns
        $custom_column_name_last_index = $last_column_index['custom_column_name'] + 1;
        $custom_column_value_last_index = $last_column_index['custom_column_value'] + 1;
        $custom_column_type_last_index = $last_column_index['custom_column_type'] + 1;
        $custom_сolumn_visibility_last_index = $last_column_index['custom_column_visibility'] + 1;
        //$custom_сolumn_order_last_index = $last_column_index['custom_column_order'] + 1;
        
        //add columns
        //$query = "ALTER TABLE $this->dev_n_tools_table ADD `custom_column_name-$custom_column_name_last_index` TEXT CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL, ADD `custom_column_value-$custom_column_value_last_index` VARCHAR(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL, ADD `custom_column_type-$custom_column_type_last_index` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL, ADD `custom_column_visibility-$custom_сolumn_visibility_last_index` INT(1) UNSIGNED NOT NULL; ";
        //$query = "ALTER TABLE $this->dev_n_tools_table ADD `custom_column_name-$custom_column_name_last_index` TEXT CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL, ADD `custom_column_value-$custom_column_value_last_index` TEXT CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL, ADD `custom_column_type-$custom_column_type_last_index` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL, ADD `custom_column_visibility-$custom_сolumn_visibility_last_index` INT(1) UNSIGNED NOT NULL, ADD `custom_column_order-$custom_сolumn_order_last_index` INT(1) UNSIGNED NOT NULL; ";
        $query = "ALTER TABLE $this->dev_n_tools_table ADD `custom_column_name-$custom_column_name_last_index` TEXT CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL, ADD `custom_column_value-$custom_column_value_last_index` TEXT CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL, ADD `custom_column_type-$custom_column_type_last_index` VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL, ADD `custom_column_visibility-$custom_сolumn_visibility_last_index` INT(1) UNSIGNED NOT NULL; ";
        $this->db->setQuery($query);
        $this->db->query();
        
        //get text for custom column name from prepared field list
        $name = $this->popup_field_list[$column_type]['field_name'];
       
        //save values for custom column in current company
        //$query = "UPDATE $this->dev_n_tools_table SET `custom_column_name-$custom_column_name_last_index` = '$name', `custom_column_value-$custom_column_value_last_index` = '', `custom_column_type-$custom_column_type_last_index` = '$column_type', `custom_column_visibility-$custom_сolumn_visibility_last_index` = '1' WHERE `user_id` = '" . $user_id . "'";    
       
        
        $old_column_order = json_decode($this->getLastColumnOrder($user_id));
        /*echo '<pre> $old_column_order';
        print_r( $old_column_order);
        echo '</pre>';*/
        $old_column_order[] = "custom_column_name-$custom_column_name_last_index";
        
        $final_order = json_encode($old_column_order);
        
        $query = "UPDATE $this->dev_n_tools_table SET `column_order` = '$final_order', `custom_column_name-$custom_column_name_last_index` = '$name', `custom_column_value-$custom_column_value_last_index` = '', `custom_column_type-$custom_column_type_last_index` = '$column_type', `custom_column_visibility-$custom_сolumn_visibility_last_index` = '1' WHERE `user_id` IN(" . implode(",",$all_user_id) . ")";       
        $this->db->setQuery($query);
        $this->db->query(); 
        
    } 

    public function removeColumn(string $lang, int $user_id, string $column_type, string $value) {
        $all_user_id = $this->loadCompanyUsersId($user_id);
         
        //$query = "UPDATE $this->dev_n_tools_table SET `$value` = '0', ".$this->db->quoteName('updated_at')." = '" . date('Y-m-d H:i:s') . "', ".$this->db->quoteName('updated_timestamp')." = '" . time() . "' WHERE `user_id` = '" . $user_id . "'";  
        $query = "UPDATE $this->dev_n_tools_table SET `$value` = '0', ".$this->db->quoteName('updated_at')." = '" . date('Y-m-d H:i:s') . "', ".$this->db->quoteName('updated_timestamp')." = '" . time() . "' WHERE `user_id` IN(" . implode(",", $all_user_id) . ")";       
        $this->db->setQuery($query);
        return $this->db->query();
    }
    
    public function editColumn(string $lang, int $user_id, string $column_type, string $value, string $name) {
        $all_user_id = $this->loadCompanyUsersId($user_id);
        
        //$query = "UPDATE $this->dev_n_tools_table SET `$value` = '" . $this->db->escape($name) . "', ".$this->db->quoteName('updated_at')." = '" . date('Y-m-d H:i:s') . "', ".$this->db->quoteName('updated_timestamp')." = '" . time() . "' WHERE `user_id` = '" . $user_id . "'";
        $query = "UPDATE $this->dev_n_tools_table SET `$value` = '" . $this->db->escape($name) . "', ".$this->db->quoteName('updated_at')." = '" . date('Y-m-d H:i:s') . "', ".$this->db->quoteName('updated_timestamp')." = '" . time() . "' WHERE `user_id` IN(" . implode(",", $all_user_id) . ")";
        $this->db->setQuery($query);
        return $this->db->query();
    }
    
    public function attachTaskToRoute(string $lang, int $user_id, string $task_text, int $route_id) {
        $query = "UPDATE $this->dev_n_tools_table SET `task_manager` = '" . $this->db->escape($task_text) . "', ".$this->db->quoteName('updated_at')." = '" . date('Y-m-d H:i:s') . "', ".$this->db->quoteName('updated_timestamp')." = '" . time() . "' WHERE `user_id` = '" . $user_id . "' AND `id` = '$route_id'";
        $this->db->setQuery($query);
        return $this->db->query();
    }
    
    public function editRoute(string $lang, int $user_id, string $type, string $cell_name, string $value, int $route_id) {
        switch($type){
            case 'coordinates':
                $arr = explode(',', $value);
                $lat = $arr[0];
                $lng = $arr[1];
                $json = json_encode([
                    'lat' => $lat,
                    'lng' => $lng
                ]);

                $query = "UPDATE $this->dev_n_tools_table SET ".$this->db->quoteName($cell_name)." = '" . $json . "', ".$this->db->quoteName('updated_at')." = '" . date('Y-m-d H:i:s') . "', ".$this->db->quoteName('updated_timestamp')." = '" . time() . "' WHERE `user_id` = '" . $user_id . "' AND `id` = '$route_id'";
                break;
            default:
                $query = "UPDATE $this->dev_n_tools_table SET ".$this->db->quoteName($cell_name)." = '" . $this->db->escape($value) . "', ".$this->db->quoteName('updated_at')." = '" . date('Y-m-d H:i:s') . "', ".$this->db->quoteName('updated_timestamp')." = '" . time() . "' WHERE `user_id` = '" . $user_id . "' AND `id` = '$route_id'";
            break;
        }
      
        $this->db->setQuery($query);
        return $this->db->query();
    }

    public function syncPayPeriodWithRoute(array $param, string $mode, string $action, int $pp_id, int $user_id, string $method_mode) {
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/route_sync.html', print_r(func_get_args(), true), FILE_APPEND | LOCK_EX);
        
        $connect_cell_arr = [
            'login_hours' => [
                'cell_name' => 'clock_in',
                'edited' => 'clock_in_edited'
            ],
            'exit_hours' => [
                'cell_name' => 'clock_out',
                'edited' => 'clock_out_edited'
            ],
            'total' => [
                'cell_name' => 'total',
                'edited' => 'total_edited'
            ]
        ];
       
        
        $cell_name = $connect_cell_arr[$mode]['cell_name'];
        $edited_field = $connect_cell_arr[$mode]['edited'];
        $value = $param['value'];
        
        switch($cell_name){
            /*case 'coordinates':
                $arr = explode(',', $value);
                $lat = $arr[0];
                $lng = $arr[1];
                $json = json_encode([
                    'lat' => $lat,
                    'lng' => $lng
                ]);

                $query = "UPDATE $this->dev_n_tools_table SET ".$this->db->quoteName($cell_name)." = '" . $json . "', ".$this->db->quoteName('updated_at')." = '" . date('Y-m-d H:i:s') . "', ".$this->db->quoteName('updated_timestamp')." = '" . time() . "' WHERE `user_id` = '" . $user_id . "' AND `pp_id` = '$pp_id'";
                break;*/
            default:
                if($method_mode === 'pay_period'){
                    $query = "UPDATE $this->dev_n_tools_table SET ".$this->db->quoteName($cell_name)." = '" . $this->db->escape($value) . "', ".$this->db->quoteName($edited_field)." = '1', ".$this->db->quoteName('updated_at')." = '" . date('Y-m-d H:i:s') . "', ".$this->db->quoteName('updated_timestamp')." = '" . time() . "' WHERE `user_id` = '" . $user_id . "' AND `pp_id` = '$pp_id'";
                } else{
                    $query = "UPDATE $this->dev_n_tools_table SET ".$this->db->quoteName($cell_name)." = '" . $this->db->escape($value) . "', ".$this->db->quoteName($edited_field)." = '1', ".$this->db->quoteName('updated_at')." = '" . date('Y-m-d H:i:s') . "', ".$this->db->quoteName('updated_timestamp')." = '" . time() . "' WHERE `user_id` = '" . $user_id . "' AND `confirm_id` = '$pp_id'";
                }
                
            break;
        }
        //echo $query;
        $this->db->setQuery($query);
        return $this->db->query();
    }
    
    
    
    public function syncValueWithTimesheet(string $value, int $user_id, int $route_id, int $pp_id, string $row_date, string $cell_name) {
        $model = JModelLegacy::getInstance('Custom_pay_period', 'AuditModel');
        $row_date_object = DateTime::createFromFormat('d.m.Y', $row_date);
        
        $_REQUEST['task'] = 'emulateNewLoginHours';
        $_REQUEST['value'] = $value;
        
        switch($cell_name){
            case 'clock_in':
                $id = 'date_logged-';
                $action = 'login_hours';
                $edited = 'clock_in_edited';
            break;
            case 'clock_out':
                $id = 'date_exit-';
                $action = 'exit_hours';
                $edited = 'clock_out_edited';
            break;
            case 'total':
                $id = 'new_hours-';
                $action = 'total';
                $edited = 'total_edited';
            break;
        }
        
        $_REQUEST['id'] = $id . $pp_id;
        $_REQUEST['year'] = $row_date_object->format('Y');
        $_REQUEST['date'] = $row_date_object->format('d.m');
       
        if(empty($pp_id)){              
            $sync_mode = 'insert';
            $res = $model->addNewAuditTimeRow($_REQUEST, $action, $sync_mode);  
            $insert_id = $res['last_id'];
            
            //connect pay period row id to route id
            $item->id = $route_id;
            $item->user_id = $user_id;
            $item->updated_at = date('Y-m-d H:i:s');
            $item->updated_timestamp = time();
            $item->pp_id = $insert_id;
            $item->$edited = 1;
            
            //$this->db->updateObject($this->dev_n_tools_table, $item, 'id');
        } else{
            $sync_mode = 'update';
            $res = $model->addNewAuditTimeRow($_REQUEST, $action, $sync_mode);
            
            $item->id = $route_id;
            $item->user_id = $user_id;
            $item->updated_at = date('Y-m-d H:i:s');
            $item->updated_timestamp = time();
      
            $item->$edited = 1;
            
            $this->db->updateObject($this->dev_n_tools_table, $item, 'id');
        }
        
       
        return [
            'sync_mode' => $sync_mode,
            'insert_id' => $insert_id
        ];
    }
    
    public function setRoutePointForApi(object $user_obj, string $lang, int $route_id, array $points) {  
        $query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` = '".$user_obj->id."' AND `id` = '$route_id'";
        $this->db->setQuery($query);
        $route = $this->db->loadObject();
        
        if(empty(json_decode($route->map_points))){
            $json = json_encode($points);
            
        } else{
            $json = json_encode(array_merge(json_decode($route->map_points, true), $points));
        }
        
        $query = "UPDATE $this->dev_n_tools_table SET ".$this->db->quoteName('map_points')." = '" . $json . "', ".$this->db->quoteName('updated_at')." = '" . date('Y-m-d H:i:s') . "', ".$this->db->quoteName('updated_timestamp')." = '" . time() . "' WHERE `user_id` = '" . $user_obj->id . "' AND `id` = '$route_id'";
        $this->db->setQuery($query);
        return $this->db->query();
        
    }
    
    public function getRoutesForApi(object $user_obj, string $lang, string $date) {
        //$query = "SELECT `id`, `user_id`, `date`, `clock_in`, `clock_out`, `total`, `task_manager`, `from_t` AS `from`, `to_t` AS `to`, `km`, `descr` AS `description` FROM $this->dev_n_tools_table WHERE `user_id` = '".$user_obj->id."'";
        //you need load all fields for correct work of custom fields
        $query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` = '".$user_obj->id."'";
        if(!empty($date)){
            $converted_date = DateTime::createFromFormat('Y-m-d', $date)->format('d.m.Y');
            $query .= " AND `date` LIKE '$converted_date%'";
        }
        $query .= " ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $routes = $this->db->loadObjectList();
        
       if($this->enable_load_total_from_pp === 1){
            foreach($routes as $one_route){ 
                $pp_id = $one_route->pp_id;
                $user_id = $one_route->user_id;
                $date_obj = DateTime::createFromFormat('d.m.Y H:i:s', $one_route->date);
                $date = $date_obj->format('d.m.Y');
                $saved_total = $one_route->total;
                $confirm_id = $one_route->confirm_id;
                
                
                if(!empty($pp_id) && empty($saved_total)){
                    $calc_total = $this->loadSyncTotalValue($pp_id, $user_id, $date, 'pp');
                    $one_route->total = $calc_total;
                } if(empty($pp_id) && empty($saved_total) && !empty($confirm_id)){
                    $calc_total = $this->loadSyncTotalValue($confirm_id, $user_id, $date_obj->format('Y-m-d'), 'confirm');
                    $one_route->total = $calc_total;
                } 
            }       
        } 
        
        
        //filter custom columns to 1 array. You need select all items because customs not working correct with date
        $query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` = '".$user_obj->id."'";
        $query .= " ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $data_for_custom = $this->db->loadObjectList();
        
        $custom = [];
        $i = 0;
        foreach($data_for_custom as $route){
            $j = 0;
            foreach($route as $k => $v){
               $exp_key = explode('-', $k);

               //get max value in key of custom columns
               if(count($exp_key) == 2 && in_array($exp_key[0], $this->custom_fields)){
                  $custom[$k] = $v; 
               }
               $j++;
            }
            $i++;
        }
        
        //filter custom columns to separate arrays, group by column number in key(custom_column_name-1, custom_column_value-1 should be in 1 array)
        $filtered = [];
        $filtered_i = 0;
        foreach($custom as $k => $v){
            $arr_name = explode('custom_column_name', $k);
            $arr_val = explode('custom_column_value', $k);
            $arr_type = explode('custom_column_type', $k);
            $arr_visibility = explode('custom_column_visibility', $k);
            
            if(count($arr_name) == 2 ){
                $filtered[$filtered_i][$k] = $v;
            }
            if(count($arr_val) == 2){
                $filtered[$filtered_i-1][$k] = $v;
            }
            if(count($arr_type) == 2){
                $filtered[$filtered_i-2][$k] = $v; 
            }
            if(count($arr_visibility) == 2){
                $filtered[$filtered_i-3][$k] = $v;
            }
            
            $filtered_i++;
        }
      
        //$final_i = 0;
        $final = [];
        foreach($filtered as $one_custom){
            $final[] = $one_custom;
        }
        
        $j = 0;
        foreach ($routes as $route) {
            $i = 0;//1
            $ik = 0;
            foreach ($final as $k => $route_custom) {
                /*$visibility = 'custom_column_visibility-' . $i;
                if ($route_custom[$visibility] != 1) {
                    $i++;
                    continue;
                }
                $type = 'custom_column_type-' . $i;
                $name = 'custom_column_name-' . $i;
                $value = 'custom_column_value-' . $i;*/
                foreach($route_custom as $k1 => $v){
                        $visibility_arr = explode('custom_column_visibility-', $k1);
                        if(count($visibility_arr) == 2){
                            $visibility = 'custom_column_visibility-' . $visibility_arr[1];
                        }
                        
                        $type_arr = explode('custom_column_type-', $k1);
                        if(count($type_arr) == 2){
                            $type = 'custom_column_type-' . $type_arr[1];
                        }

                        $name_arr = explode('custom_column_name-', $k1);
                        if(count($name_arr) == 2){
                            $name = 'custom_column_name-' . $name_arr[1];
                        }
                        
                        $val_arr = explode('custom_column_value-', $k1);
                        if(count($val_arr) == 2){
                            $value = 'custom_column_value-' . $val_arr[1];
                        }

                }
                
                if ($route_custom[$visibility] != 1) {
                    $i++;
                    continue;
                }
                
                $route->custom[$ik]['name'] = $route_custom[$name];//get name of custom columns from custom columns list
                $route->custom[$ik]['value'] = $route->$value;//get value from current route row
                $route->custom[$ik]['cell_name'] = $name;
                $route->custom[$ik]['type'] = $route_custom[$type];
                
                if ($route->custom[$ik]['type'] == 'total') {
                    $ia = 0;//1
                    $total_h = 0;

                    foreach ($final as $k1 => $route_custom1) {

                        /*$visibility1 = 'custom_column_visibility-' . $ia;
                        if ($route_custom1[$visibility1] != 1) {
                            $ia++;
                            continue;
                        }
                        $type1 = 'custom_column_type-' . $ia;
                        $name1 = 'custom_column_name-' . $ia;
                        $value1 = 'custom_column_value-' . $ia;

                        if ($route_custom1[$type1] == 'numbers') {
                            $total_h += $route->$value1;
                        }*/
                        
                        foreach($route_custom1 as $k3 => $v){
                                        $visibility_arr = explode('custom_column_visibility-', $k3);
                                        if(count($visibility_arr) == 2){
                                            $visibility1 = 'custom_column_visibility-' . $visibility_arr[1];
                                        }
                                        
                                        $type_arr = explode('custom_column_type-', $k3);
                                        if(count($type_arr) == 2){
                                            $type1 = 'custom_column_type-' . $type_arr[1];
                                        }

                                        $name_arr = explode('custom_column_name-', $k3);
                                        if(count($name_arr) == 2){
                                            $name1 = 'custom_column_name-' . $name_arr[1];
                                        }
                                        
                                        $val_arr = explode('custom_column_value-', $k3);
                                        if(count($val_arr) == 2){
                                            $value1 = 'custom_column_value-' . $val_arr[1];
                                        }
                        }
                        if ($route_custom1[$visibility1] != 1) {
                            $ia++;
                            continue;
                        }
                        if ($route_custom1[$type1] == 'numbers') {
                            $total_h += $route->$value1;
                        }
                        
                        $ia++;
                    }
                    $route->custom[$ik]['value'] = $total_h;
                }

                $i++;
                $ik++;
            }
            $j++;
        }
        
        //$query = "SELECT `id`, `user_id`, `date`, `clock_in`, `clock_out`, `total`, `task_manager`, `from_t` AS `from`, `to_t` AS `to`, `km`, `descr` AS `description` FROM $this->dev_n_tools_table WHERE `user_id` = '".$user_obj->id."'";
        
        
        //$data=standart; $final=custom
        if($this->enable_sortable_custom_headers === 1){
            $final_arr = [];
            foreach ($routes as $route) {
                if (!empty($route) && !empty($route->column_order)) {
                    $route->custom = $this->reorderPropsCustomForApi($route->custom, json_decode($route->column_order, false));
                } else {
                    if (!empty($route->custom)) {
                        $order = $this->getLastColumnOrder($user_obj->id);
                        $route->custom = $this->reorderPropsCustomForApi($route->custom, json_decode($order, true));
                    }
                }
            }
            
           
        }
       $permitted_fields = [
            'id',
            'user_id',
            'date',
            'clock_in',
            'clock_out',
            'total',
            'task_manager',
            'from',
            'to',
            'km',
            'description',
            'custom',
           // 'column_order'
        ];
        
        //filter cells
        foreach($routes as $route){
            $route->from = $route->from_t;
            $route->to = $route->to_t;
            $route->description = $route->descr;
            
            unset($route->from_t, $route->to_t, $route->descr);
            foreach($route as $k=>$v){
                if(!in_array($k, $permitted_fields)){
                    unset($route->$k);
                }
            }
        }
       
        
        //return $company_routes;
        return $routes;
    }
    
    public function getAutoCollectTextsApi(object $user_obj, string $lang) {
        if($this->enable_autocollect_type_of_load_for_api === 1){
            $all_user_id = $this->loadCompanyUsersId($user_obj->id);
            
            $query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` IN(" . implode(",", $all_user_id) . ") ORDER BY `id` DESC";
            $this->db->setQuery($query);
            $company_routes = $this->db->loadObjectList();
        
          
        
            $custom = [];
            $i = 0;
            
            foreach($company_routes as $route){
                $j = 0;
                
                foreach($route as $k => $v){
                    $exp_key = explode('-', $k);

                    //get max value in key of custom columns
                    if(count($exp_key) == 2 && in_array($exp_key[0], $this->custom_fields)){
                        $custom[$k] = $v; 
                    }
                    $j++;
                }
                
                $i++;
            }
        
            //filter custom columns to separate arrays, group by column number in key(custom_column_name-1, custom_column_value-1 should be in 1 array)
            $filtered = [];
            $filtered_i = 0;
            foreach($custom as $k => $v){
                $arr_name = explode('custom_column_name', $k);
                $arr_val = explode('custom_column_value', $k);
                $arr_type = explode('custom_column_type', $k);
                $arr_visibility = explode('custom_column_visibility', $k);
            
                if(count($arr_name) == 2 ){
                    $filtered[$filtered_i][$k] = $v;
                }
                if(count($arr_val) == 2){
                    $filtered[$filtered_i-1][$k] = $v;
                }
                if(count($arr_type) == 2){
                    $filtered[$filtered_i-2][$k] = $v; 
                }
                if(count($arr_visibility) == 2){
                    $filtered[$filtered_i-3][$k] = $v;
                }
            
                $filtered_i++;
            }
      
            //$final_i = 0;
            $final = [];
            foreach($filtered as $one_custom){
                $final[] = $one_custom;
            }
        
            $j = 0;
            foreach ($company_routes as $route) {
                $i = 1;
                $ik = 0;
                
                foreach ($final as $k => $route_custom) {
                    $visibility = 'custom_column_visibility-' . $i;
                    if ($route_custom[$visibility] != 1) {
                        $i++;
                        continue;
                    }
                    $type = 'custom_column_type-' . $i;
                    $name = 'custom_column_name-' . $i;
                    $value = 'custom_column_value-' . $i;
                  
                
                    $route->custom[$ik]['name'] = $route_custom[$name];//get name of custom columns from custom columns list
                    $route->custom[$ik]['cell_type'] = $route_custom[$type];
                    $route->custom[$ik]['value'] = $route->$value;//get value from current route row
                    $route->custom[$ik]['cell_name'] = $name;
                  
                     
                    $i++;
                    $ik++;
                }
                $j++;
            }
        
        
            $permitted_fields = [
                'id',
                'user_id',
                'date',
                'clock_in',
                'clock_out',
                'total',
                'task_manager',
                'from',
                'to',
                'km',
                'description',
                'custom'
            ];
        
            //filter cells
            foreach($company_routes as $route){
                $route->from = $route->from_t;
                $route->to = $route->to_t;
                $route->description = $route->descr;
            
                unset($route->from_t, $route->to_t, $route->descr);
                foreach($route as $k=>$v){
                    if(!in_array($k, $permitted_fields)){
                        unset($route->$k);
                    }
                }
            }
            
            $final_result = [];
           
            
            $all_customs = array_column($company_routes, 'custom');
            
            $i = 0;
            
            //worked example
            /*foreach($all_customs as $one_array_of_customs){
                foreach($one_array_of_customs as $one_custom_arr){
                    if(in_array('auto_col_text', $one_custom_arr)){
                        //$final_result[$one_custom_arr['cell_name']] = $one_custom_arr;
                        if(!empty($one_custom_arr['value'])){
                            $final_result['group_one'][$i]['name'] = $one_custom_arr['name'];
                            $final_result['group_one'][$i]['key'] = $one_custom_arr['cell_name'];
                            $final_result['group_one'][$i]['val'] = $one_custom_arr['value'];
                            
                            $i++;
                        }
                         
                    }  
                    
                }
            }*/
            
            foreach($all_customs as $one_array_of_customs){
                foreach($one_array_of_customs as $one_custom_arr){
                    if(in_array('auto_col_text', $one_custom_arr)){  
                       
                        if(!empty($one_custom_arr['value'])){
                            $final_result[$i]['name'] = $one_custom_arr['name'];
                            $final_result[$i]['key'] = $one_custom_arr['cell_name'];
                            $final_result[$i]['val'] = $one_custom_arr['value'];
                            
                            $i++;
                        }
                         
                    }  
                    
                }
            }
        }
        
        
        return $this->groupBy($this->super_unique($final_result, 'val'), 'key'); /*[
            //'$final_result' => array_column($this->super_unique($final_result, 'value'), 'value'), 
            //'final_result' => $this->super_unique($final_result, 'val'), 
            'final_result' => $this->groupBy($this->super_unique($final_result, 'val'), 'key'),
            //'final_result' => $final_result,
            //'$all_customs' => $all_customs, 'all' => $company_routes
        ];*/
    }
    
    private function groupBy($array, $key) {
        $return = array();
        foreach($array as $val) {
            $return[$val[$key]][] = $val;
        }
        return $return;
    }

     private function super_unique($array, $key) {
        $temp_array = [];
        foreach ($array as &$v) {
            if (!isset($temp_array[$v[$key]]))
                $temp_array[$v[$key]] = & $v;
        }
        $array = array_values($temp_array);
        return $array;
    }
    
    private function calcDistance(object $from, object $to) {
        $string_from = $from->lat . ',' . $from->lng;
        $string_to = $to->lat . ',' . $to->lng;
       
        $km = 0;
        $distanceMatrixResult = $this->gmaps->distanceMatrix($string_from, $string_to);
          
        if($distanceMatrixResult['rows'][0]['elements'][0]['status'] == 'OK'){
            $km = $distanceMatrixResult['rows'][0]['elements'][0]['distance']['text'];
        }
        
        return $km;
    }
    
    public function setRouteForApi(object $user_obj, $route_id, string $date, $clock_in, $clock_out, $total, $task_manager, $from, $to, $from_coordinates_decoded, $to_coordinates_decoded, $message, string $lang, $custom, $is_enable_confirm_pp, $confirm_id, $route = null) {
         
        //add route
        if(empty($route_id)){
           //echo '$route_id'.$route_id;
            $item->id = null;
            $item->user_id = $user_obj->id;
            $item->created_at = date('Y-m-d H:i:s');
            $item->updated_at = null;
            $item->created_timestamp = time();
            $item->updated_timestamp = null;
        
          
            if(empty($date)){
                $final_date = date('d.m.Y H:i:s');
            } else{
                $final_date = date('d.m.Y H:i:s', strtotime($date . date('H:i:s')));
            }
           
        
            $item->date = $final_date;
            $item->clock_in = $clock_in;
            $item->clock_out = $clock_out;
            $item->total = $total;
            $item->task_manager = $task_manager;
            $item->from_t = $from;
            $item->to_t = $to;
            $item->from_coordinates = json_encode($from_coordinates_decoded);
            $item->to_coordinates = json_encode($to_coordinates_decoded);
            $item->km = $this->calcDistance($from_coordinates_decoded, $to_coordinates_decoded);
            $item->map = '';
            $item->descr = trim($message);
            $item->who_added = 'api';
            
            if(!empty($custom)){
                foreach($custom as $cell){
                    $cell_name_origin = $cell['cell_name'];
                    $cell_arr = explode('-', $cell_name_origin);
                    $cell_value_string = 'custom_column_value-' . $cell_arr[1];
                    $cell_value = str_replace($cell_name_origin, $cell_value_string, $cell_name_origin);
                    
                    $item->$cell_value = strip_tags($this->db->escape($cell['value']));
                }
            }
            
            return $this->db->insertObject($this->dev_n_tools_table, $item);
        } else{//edit route
            $query = "SELECT `id`, `user_id` FROM $this->dev_n_tools_table WHERE `user_id` = '".$user_obj->id."' AND `id` = '$route_id'";
            $this->db->setQuery($query);
            $route_id = $this->db->loadObject()->id;
            
            if(empty($route_id)){
                throw new Exception('You don\'t have permission for edit this route');
            }
            
            $item->id = $route_id;
            $item->user_id = $user_obj->id;
            $item->updated_at = date('Y-m-d H:i:s');
            $item->updated_timestamp = time();
        
          
            if(empty($date)){
                $final_date = date('d.m.Y H:i:s');
            } else{
                $final_date = date('d.m.Y H:i:s', strtotime($date . date('H:i:s')));
            }

            $item->date = $final_date;
            $item->clock_in = $clock_in;
            $item->clock_in_edited = 1;
            $item->clock_out = $clock_out;
            $item->clock_out_edited = 1;
            $item->total = $total;
            $item->total_edited = 1;
            $item->task_manager = $task_manager;
            $item->from_t = $from;
            $item->to_t = $to;
            $item->from_coordinates = json_encode($from_coordinates_decoded);
            $item->to_coordinates = json_encode($to_coordinates_decoded);
            $item->km = $this->calcDistance($from_coordinates_decoded, $to_coordinates_decoded);
            $item->map = '';
            $item->descr = trim($message);
            $item->who_added = 'api';
        
            if(!empty($custom)){
                foreach($custom as $cell){
                    $cell_name_origin = $cell['cell_name'];
                    $cell_arr = explode('-', $cell_name_origin);
                    $cell_value_string = 'custom_column_value-' . $cell_arr[1];
                    $cell_value = str_replace($cell_name_origin, $cell_value_string, $cell_name_origin);
                    
                    $item->$cell_value = strip_tags($this->db->escape($cell['value']));
                }
            }
            
            $res = $this->db->updateObject($this->dev_n_tools_table, $item, 'id');
            $res_sync = $this->syncRoute($item, $user_obj, $route_id, $is_enable_confirm_pp, $confirm_id, $route);
            
            return $res;
        }
    }
    
    private function syncRoute(stdClass $item, object $user_obj, int $route_id, $is_enable_confirm_pp, $confirm_id, $route = null) {
        
        $pp_id = $route->pp_id;
        
        if(!empty($pp_id)){
            $route_date_obj = DateTime::createFromFormat('d.m.Y H:i:s', $route->date);
            
            $final_item = new stdClass();
            $final_item->id = $pp_id;
            
            $final_date_logged_value = date('Y-m-d', strtotime($route_date_obj->format('Y-m-d'))) . ' ' . $item->clock_in;
            $final_item->date_logged = $final_date_logged_value;
            $final_item->date_logged_edit = '1';  
            
            $final_date_exit_value = date('Y-m-d', strtotime($route_date_obj->format('Y-m-d'))) . ' ' . $item->clock_out;
            $final_item->date_exit = $final_date_exit_value;
            $final_item->date_exit_edit = '1'; 
            
            $final_item->new_hours = $item->total;
            
            $res = $this->db->updateObject('#__audit_time', $final_item, 'id');
        
       
            //confirm sync
            if ($is_enable_confirm_pp == '1' && $mode != 'description' && $param['task'] != 'SyncPP01') {
                JLoader::register('AuditModelConfirm_time', JPATH_ROOT . '/components/com_audit/models/confirm_time.php');
                $model_confirm = JModelLegacy::getInstance('Confirm_time', 'AuditModel');
               
                //clone changes to confirm page(sync)
                if (!empty($confirm_id)) {
                    $final_item->id = $confirm_id;
                    $res = $this->db->updateObject('#__audit_time_confirm', $final_item, 'id');  
                }
            }
        } if(empty($route->pp_id) && !empty($confirm_id)){
            $route_date_obj = DateTime::createFromFormat('d.m.Y H:i:s', $route->date);
            
            $final_item = new stdClass();
            $final_item->id = $confirm_id;
            
            $final_date_logged_value = date('Y-m-d', strtotime($route_date_obj->format('Y-m-d'))) . ' ' . $item->clock_in;
            $final_item->date_logged = $final_date_logged_value;
            $final_item->date_logged_edit = '1';  
            
            $final_date_exit_value = date('Y-m-d', strtotime($route_date_obj->format('Y-m-d'))) . ' ' . $item->clock_out;
            $final_item->date_exit = $final_date_exit_value;
            $final_item->date_exit_edit = '1'; 
            
            $final_item->new_hours = $item->total;
            /*echo '<pre>$final_item';
            print_r($final_item);
            echo '</pre>';*/
            $res = $this->db->updateObject('#__audit_time_confirm', $final_item, 'id');
        }
    }
    
    public function startRoute(object $user_obj, int $route_id, string $message) {
        $item->id = $route_id;
        $item->is_started = 1;
        $item->clock_in = date('H:i');
        $item->clock_out = '';
        $item->total = '';
        $item->descr = $this->db->escape($message);
        $item->updated_at = date('Y-m-d H:i:s');
        $item->updated_timestamp = time();
        //$item->pp_id = $pp_id;
        
        $this->db->updateObject($this->dev_n_tools_table, $item, 'id');
    }
    
    public function stopRoute(object $user_obj, int $route_id, string $message) {
        $query = "SELECT `descr` FROM $this->dev_n_tools_table WHERE `user_id` = '".$user_obj->id."' AND `id` = '$route_id'";
        $this->db->setQuery($query);
        $old_descr = $this->db->loadResult();
            
        $item->id = $route_id;
        $item->is_started = 1;
        $item->clock_out = date('H:i');
        $item->descr = $this->db->escape($old_descr . '-' .$message);
        $item->updated_at = date('Y-m-d H:i:s');
        $item->updated_timestamp = time();
            
        $this->db->updateObject($this->dev_n_tools_table, $item, 'id');
    }
    
    public function syncValueWithConfirmOnly(string $value, int $user_id, int $route_id, int $confirm_id, string $row_date, string $cell_name) {
        $model = JModelLegacy::getInstance('Confirm_time', 'AuditModel');
        $row_date_object = DateTime::createFromFormat('d.m.Y', $row_date);
        
        $_REQUEST['task'] = 'emulateNewLoginHoursConfirm';
        $_REQUEST['value'] = $value;
        
        switch($cell_name){
            case 'clock_in':
                $id = 'date_logged-';
                $action = 'login_hours';
                $edited = 'clock_in_edited';
            break;
            case 'clock_out':
                $id = 'date_exit-';
                $action = 'exit_hours';
                $edited = 'clock_out_edited';
            break;
            /*case 'total':
                $id = 'new_hours-';
                $action = 'total';
                $edited = 'total_edited';
            break;*/
        }
        
        $_REQUEST['id'] = $id . $confirm_id;
        $_REQUEST['year'] = $row_date_object->format('Y');
        $_REQUEST['date'] = $row_date_object->format('d.m');
       
        
        $sync_mode = 'update';
        $res = $model->addNewAuditTimeRow($_REQUEST, $action, $sync_mode);//update confirm row
            
            
        $item->id = $route_id;
        $item->user_id = $user_id;
        $item->updated_at = date('Y-m-d H:i:s');
        $item->updated_timestamp = time();
      
        $item->$edited = 1;
            
        $this->db->updateObject($this->dev_n_tools_table, $item, 'id');
        
        
       
        return [
            'sync_mode' => $sync_mode,
            'insert_id' => $insert_id
        ];
    }
    
    public function deleteRouteByPp(int $pp_id, int $confirm_id, int $user_id) {
        if (!empty($pp_id)) {
            $query = "DELETE FROM $this->dev_n_tools_table WHERE `pp_id` = '$pp_id' AND `user_id` = '$user_id';";
            $this->db->setQuery($query);
            $this->db->query();
        } elseif (!empty($confirm_id)) {
            $query = "DELETE FROM $this->dev_n_tools_table WHERE `confirm_id` = '$confirm_id' AND `user_id` = '$user_id';";
            $this->db->setQuery($query);
            $this->db->query();
        }
        //echo $query;
    }
    
    public function getRoute(Joomla\CMS\User\User $user_obj, int $route_id) {
        $query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` = '".$user_obj->id."' AND `id` = '$route_id'";
        $this->db->setQuery($query);
        $route = $this->db->loadObject();
            
        if(empty($route)){
            throw new Exception('You don\'t have permission for edit this route');
        }
        
        return $route;
    }
    
    public function formatCoordinates(array $coordinates_raw) {
        return [
            [
                'Geometry' => [
                    'Latitude' => $coordinates_raw['lat'],
                    'Longitude' => $coordinates_raw['lng']
                ]
            ]
        ];
    }
    
    public function getUserRoutes(Joomla\CMS\User\User $user_obj) {
        $query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` = '".$user_obj->id."' ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $routes = $this->db->loadObjectList();
        
        return $routes;
    }
    
    public function storeMapCenter(string $lang, Joomla\CMS\User\User $user_obj, float $lat, float $lng, string $name) {
        $arr = [
            'lat' => $lat,
            'lng' => $lng,
            'country_name' => $name
        ];
        
        $json = json_encode($arr);
        
        $item = new stdClass();
        $item->id = $user_obj->id;
        $item->routes_map_center = $json;
        
        $this->db->updateObject($this->users_table, $item, 'id');
    }
    
    public function getRoutesListHtml(array $routes, string $lang, Joomla\CMS\User\User $user_obj, int $active_route) {
        
        $html = '';
        foreach($routes as $route){
           if(empty($route->task_manager)) continue;
           
            $url = 'route-map';
            if ($lang == 'is') {
                $link = '/is/' . $url . '?user_id=' . $user_obj->id . '&route_id=' . $route->id;
            } else {
                $link = '/' . $url . '?user_id=' . $user_obj->id . '&route_id=' . $route->id;
            }

            unset($class);

            $html .= '';
            if ($active_route == $route->id) {
                $class = ' selected_option_active';
            } $html .= ''
                    . '<div class="one_option' . $class . '" data-option-value="' . $route->id . '">'
                        . '<a href="' . $link . '"><span>' . $route->task_manager . '</span></a>'
                    . '</div>';
        }
        
        return $html;
    }
    
     public function getUserRouteWithCustom(int $user_id, $id = null) {
       
        $query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` = '".$user_id."'";
        if(!empty($id)){
            $query .= " AND `id` = '$id'";
        }
        $query .= " ORDER BY `id` DESC";
       
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        if($this->enable_load_total_from_pp === 1){
            foreach($data as $one_route){
                $pp_id = $one_route->pp_id;
                $user_id = $one_route->user_id;
                $date_obj = DateTime::createFromFormat('d.m.Y H:i:s', $one_route->date);
                $date = $date_obj->format('d.m.Y');
                $saved_total = $one_route->total;
                $confirm_id = $one_route->confirm_id;
                
                
                if(!empty($pp_id) && empty($saved_total)){
                    $calc_total = $this->loadSyncTotalValue($pp_id, $user_id, $date, 'pp');
                    $one_route->total = $calc_total;
                } if(empty($pp_id) && empty($saved_total) && !empty($confirm_id)){
                    $calc_total = $this->loadSyncTotalValue($confirm_id, $user_id, $date_obj->format('Y-m-d'), 'confirm');
                    $one_route->total = $calc_total;
                } 
            }       
        }
        
        //filter custom columns to 1 array. You need select all items because customs not working correct with date
        $query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` = '".$user_id."'";
        $query .= " ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $data_for_custom = $this->db->loadObjectList();
        
        $custom = [];
        $i = 0;
        foreach($data_for_custom as $route){
            $j = 0;
            foreach($route as $k => $v){
               $exp_key = explode('-', $k);

               //get max value in key of custom columns
               if(count($exp_key) == 2 && in_array($exp_key[0], $this->custom_fields)){
                  $custom[$k] = $v; 
               }
               $j++;
            }
            $i++;
        }
        
        //filter custom columns to separate arrays, group by column number in key(custom_column_name-1, custom_column_value-1 should be in 1 array)
        $filtered = [];
        $filtered_i = 0;
        foreach($custom as $k => $v){
            $arr_name = explode('custom_column_name', $k);
            $arr_val = explode('custom_column_value', $k);
            $arr_type = explode('custom_column_type', $k);
            $arr_visibility = explode('custom_column_visibility', $k);
            
            if(count($arr_name) == 2 ){
                $filtered[$filtered_i][$k] = $v;
            }
            if(count($arr_val) == 2){
                $filtered[$filtered_i-1][$k] = $v;
            }
            if(count($arr_type) == 2){
                $filtered[$filtered_i-2][$k] = $v; 
            }
            if(count($arr_visibility) == 2){
                $filtered[$filtered_i-3][$k] = $v;
            }
            
            $filtered_i++;
        }
      
        //$final_i = 0;
        $final = [];
        foreach($filtered as $one_custom){
            $final[] = $one_custom;
        }
        return [
            'standart' => $data,
            //'custom' => $custom,
            'custom' => $final
        ];
    }
            
    public function loadCell(int $route_id, string $lang, Joomla\CMS\User\User $user_obj, string $cell_name) {
        $one_route = $this->getRoute($user_obj, $route_id);
        
        switch($cell_name){
            case 'total':
                $user_id = $one_route->user_id;
                $pp_id = $one_route->pp_id;
                $date_obj = DateTime::createFromFormat('d.m.Y H:i:s', $one_route->date);
                $date = $date_obj->format('d.m.Y');
                $saved_total = $one_route->total;
                $confirm_id = $one_route->confirm_id;
                
                if(!empty($pp_id) && empty($saved_total)){
                    $calc_total = $this->loadSyncTotalValue($pp_id, $user_id, $date, 'pp');
                } if(empty($pp_id) && empty($saved_total) && !empty($confirm_id)){
                    $calc_total = $this->loadSyncTotalValue($confirm_id, $user_id, $date_obj->format('Y-m-d'), 'confirm');  
                } 
                return $calc_total;
            break;
        }
    }
    
    private function searchForExcel(array $user_ids, string $phrase, string $search_all, string $from, string $to, $additional_user_id = null) {
        $user_id = $user_obj->id;
        $keyword = $phrase;
        
        /*$query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` IN(" . implode(",", $user_ids) . ") ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $routes = $this->db->loadObjectList();*/
        
        if(empty($phrase) && $search_all == 'false' && (!empty($from) && !empty($to))){
            $from_date_obj = DateTime::createFromFormat('d.m.Y', $from);
            $to_date_obj = DateTime::createFromFormat('d.m.Y', $to);
            
           
        }
        
        //filter custom columns to 1 array. You need select all items because customs not working correct with date
        $query = "SELECT * FROM $this->dev_n_tools_table  WHERE `user_id` IN(" . implode(",", $user_ids) . ")";
        $query .= " ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $data_for_custom = $this->db->loadObjectList();
        
        /*echo '<pre>$data_for_custom';
        print_r($data_for_custom);
        echo '</pre>';*/
        
        $custom = [];
        $i = 0;
        foreach($data_for_custom as $route){
            $j = 0;
            foreach($route as $k => $v){
               $exp_key = explode('-', $k);

               //get max value in key of custom columns
               if(count($exp_key) == 2 && in_array($exp_key[0], $this->custom_fields)){
                  $custom[$k] = $v; 
               }
               $j++;
            }
            $i++;
        }
        
        //filter custom columns to separate arrays, group by column number in key(custom_column_name-1, custom_column_value-1 should be in 1 array)
        $filtered = [];
        $filtered_i = 0;
        foreach($custom as $k => $v){
            $arr_name = explode('custom_column_name', $k);
            $arr_val = explode('custom_column_value', $k);
            $arr_type = explode('custom_column_type', $k);
            $arr_visibility = explode('custom_column_visibility', $k);
            
            if(count($arr_name) == 2 ){
                $filtered[$filtered_i][$k] = $v;
            }
            if(count($arr_val) == 2){
                $filtered[$filtered_i-1][$k] = $v;
            }
            if(count($arr_type) == 2){
                $filtered[$filtered_i-2][$k] = $v; 
            }
            if(count($arr_visibility) == 2){
                $filtered[$filtered_i-3][$k] = $v;
            }
            
            $filtered_i++;
        }
      
        //$final_i = 0;
        $final = [];
        foreach($filtered as $one_custom){
            $final[] = $one_custom;
        }
        
        $search_in = [
            'clock_in',
            'clock_out',
            'total',
            'task_manager',
            'from_t',
            'to_t',
            'descr',
        ];
        
        //add custom fields value to search array
        $ia = 1;
        foreach($final as $one_custom){
            $string = 'custom_column_value-' . $ia;
            $v = 'custom_column_visibility-' . $ia;
            $vs = $one_custom[$v];
            
            if($vs == 1){
                $search_in[] = $string;
            }
            $ia++;
        }
        
        $query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` IN(" . implode(",", $user_ids) . ")"; 
        //$query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` = '".$user_id."'";
        
        if(!empty($date)){
            if($search_all == 'false'){
                if(empty($phrase) && (!empty($from) && !empty($to) && ($from != $to)) && $this->enable_period_on_dev_n_tools == '1'){
                    $converted_date = DateTime::createFromFormat('Y-m-d', $date)->format('d.m.Y');
                    $query .= " AND `date` LIKE '$converted_date%'";
                }
            }
        } else{
            if($search_all == 'false'){
                if(empty($phrase) && (!empty($from) && !empty($to) && ($from != $to)) && $this->enable_period_on_dev_n_tools == '1'){
                    
                } else{
                    $converted_date = date('d.m.Y');
                    $query .= " AND `date` LIKE '$converted_date%'";
                }
                    
                
               
            }
        }
        
        $query .= $searh_all == 'true' ? "AND" : "AND(";//search on all dates or not
        foreach($search_in as $search_field){
            $query .= " `$search_field` LIKE '%$keyword%' OR";
        }
        $query = chop($query, ' OR');//remove last OR
        
        $query .= $searh_all == 'true' ? " ORDER BY `id` DESC" : ") ORDER BY `id` DESC";
        //file_put_contents($this->config->get('current_home_path') . '/logs/gps_xls.html', print_r($query . PHP_EOL, true), FILE_APPEND | LOCK_EX);
        
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        $data_filtered = $data;
        
        if(empty($phrase) && $search_all == 'false' && (!empty($from) && !empty($to) && ($from != $to)) && $this->enable_period_on_dev_n_tools == '1'){
            $to_plus1 = clone $to_date_obj;
            $to_plus1->modify('+1day');
            $data_filtered = [];
            //file_put_contents($this->config->get('current_home_path') . '/logs/gps_xls.html', print_r($from_date_obj->format('d.m.Y'), true), FILE_APPEND | LOCK_EX);
            //file_put_contents($this->config->get('current_home_path') . '/logs/gps_xls.html', print_r($to_plus1->format('d.m.Y'), true), FILE_APPEND | LOCK_EX); 
             foreach($data as $one_route){
                $route_date_obj = DateTime::createFromFormat('d.m.Y H:i:s', $one_route->date);
               
                
                $interval = new DateInterval('P1D');
                $daterange = new DatePeriod($from_date_obj, $interval, $to_plus1);
                $dates_array = [];
                
                foreach($daterange as $date1) {
                    $dates_array[] = $date1->format('d.m.Y');
                }
                if(in_array($route_date_obj->format('d.m.Y'), $dates_array)){
                    $data_filtered[] = $one_route;
                }
                
                
            }
        }
        //file_put_contents($this->config->get('current_home_path') . '/logs/gps_xls.html', print_r($data_filtered, true), FILE_APPEND | LOCK_EX); 
        //return false;
        
        if($this->enable_load_total_from_pp === 1){
            foreach($data_filtered as $one_route){
                $pp_id = $one_route->pp_id;
                $user_id = $one_route->user_id;
                $date_obj = DateTime::createFromFormat('d.m.Y H:i:s', $one_route->date);
                $date = $date_obj->format('d.m.Y');
                $saved_total = $one_route->total;
                $confirm_id = $one_route->confirm_id;
                
                
                if(!empty($pp_id) && empty($saved_total)){
                    $calc_total = $this->loadSyncTotalValue($pp_id, $user_id, $date, 'pp');
                    $one_route->total = $calc_total;
                } if(empty($pp_id) && empty($saved_total) && !empty($confirm_id)){
                    $calc_total = $this->loadSyncTotalValue($confirm_id, $user_id, $date_obj->format('Y-m-d'), 'confirm');
                    $one_route->total = $calc_total;
                } 
            }       
        }
        $permitted_fields = [
            'id',
            'user_id',
            'date',
            'clock_in',
            'clock_out',
            'total',
            'task_manager',
            'from',
            'to',
            'km',
            'description',
            'custom',
            'username'
        ];
        
        foreach($data_filtered as $one_route){
            $one_route->from = $one_route->from_t;
            $one_route->to = $one_route->to_t;
            $one_route->description =  $one_route->descr;
            $one_route->username = $this->getFinalUsername(JFactory::getUser($one_route->user_id));
            
            unset($one_route->from_t, $one_route->to_t, $one_route->descr);
            /*foreach($one_route as $k=>$v){
                if(!in_array($k, $permitted_fields)){
                    unset($one_route->$k);
                }
            }*/
         }
         
         ///hh
        //filter custom columns to 1 array. You need select all items because customs not working correct with date
        $query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` IN(" . implode(",", $user_ids) . ") ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $data_for_custom = $this->db->loadObjectList();
        
        $custom = [];
        $i = 0;
        foreach($data_for_custom as $route){
            $j = 0;
            foreach($route as $k => $v){
               $exp_key = explode('-', $k);

               //get max value in key of custom columns
               if(count($exp_key) == 2 && in_array($exp_key[0], $this->custom_fields)){
                  $custom[$k] = $v; 
               }
               $j++;
            }
            $i++;
        }
        
        //filter custom columns to separate arrays, group by column number in key(custom_column_name-1, custom_column_value-1 should be in 1 array)
        $filtered = [];
        $filtered_i = 0;
        foreach($custom as $k => $v){
            $arr_name = explode('custom_column_name', $k);
            $arr_val = explode('custom_column_value', $k);
            $arr_type = explode('custom_column_type', $k);
            $arr_visibility = explode('custom_column_visibility', $k);
            
            if(count($arr_name) == 2 ){
                $filtered[$filtered_i][$k] = $v;
            }
            if(count($arr_val) == 2){
                $filtered[$filtered_i-1][$k] = $v;
            }
            if(count($arr_type) == 2){
                $filtered[$filtered_i-2][$k] = $v; 
            }
            if(count($arr_visibility) == 2){
                $filtered[$filtered_i-3][$k] = $v;
            }
            
            $filtered_i++;
        }
      
        //$final_i = 0;
        $final = [];
        foreach($filtered as $one_custom){
            $final[] = $one_custom;
        }
        
        $j = 0;
        foreach ($data as $route) {
            $i = 1;
            $ik = 0;
            foreach ($final as $k => $route_custom) {
                $visibility = 'custom_column_visibility-' . $i;
                if ($route_custom[$visibility] != 1) {
                    $i++;
                    continue;
                }
                $type = 'custom_column_type-' . $i;
                $name = 'custom_column_name-' . $i;
                $value = 'custom_column_value-' . $i;
                
                $route->custom[$ik]['name'] = $route_custom[$name];//get name of custom columns from custom columns list
                $route->custom[$ik]['value'] = $route->$value;//get value from current route row
                $route->custom[$ik]['cell_name'] = $name;
                $route->custom[$ik]['type'] = $route_custom[$type];
                
                if ($route->custom[$ik]['type'] == 'total') {
                    $ia = 1;
                    $total_h = 0;

                    foreach ($final as $k1 => $route_custom1) {

                        $visibility1 = 'custom_column_visibility-' . $ia;
                        if ($route_custom1[$visibility1] != 1) {
                            $ia++;
                            continue;
                        }
                        $type1 = 'custom_column_type-' . $ia;
                        $name1 = 'custom_column_name-' . $ia;
                        $value1 = 'custom_column_value-' . $ia;

                        if ($route_custom1[$type1] == 'numbers') {
                            $total_h += $route->$value1;
                        }
                        
                        $ia++;
                    }
                    $route->custom[$ik]['value'] = $total_h;
                }

                $i++;
                $ik++;
            }
            $j++;
        } 
        
        
        return [
            'query' => $query,
            'search_in' => $search_in,
            'standart' => $data_filtered, 
            'custom' => $final
        ];
    }
    
    public function search(Joomla\CMS\User\User $user_obj, string $date, string $keyword, string $searh_all) {
        $user_id = $user_obj->id;
        

        //filter custom columns to 1 array. You need select all items because customs not working correct with date
        $query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` = '".$user_id."'";
        $query .= " ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $data_for_custom = $this->db->loadObjectList();
        
        $custom = [];
        $i = 0;
        foreach($data_for_custom as $route){
            $j = 0;
            foreach($route as $k => $v){
               $exp_key = explode('-', $k);

               //get max value in key of custom columns
               if(count($exp_key) == 2 && in_array($exp_key[0], $this->custom_fields)){
                  $custom[$k] = $v; 
               }
               $j++;
            }
            $i++;
        }
        
        //filter custom columns to separate arrays, group by column number in key(custom_column_name-1, custom_column_value-1 should be in 1 array)
        $filtered = [];
        $filtered_i = 0;
        foreach($custom as $k => $v){
            $arr_name = explode('custom_column_name', $k);
            $arr_val = explode('custom_column_value', $k);
            $arr_type = explode('custom_column_type', $k);
            $arr_visibility = explode('custom_column_visibility', $k);
            
            if(count($arr_name) == 2 ){
                $filtered[$filtered_i][$k] = $v;
            }
            if(count($arr_val) == 2){
                $filtered[$filtered_i-1][$k] = $v;
            }
            if(count($arr_type) == 2){
                $filtered[$filtered_i-2][$k] = $v; 
            }
            if(count($arr_visibility) == 2){
                $filtered[$filtered_i-3][$k] = $v;
            }
            
            $filtered_i++;
        }
      
        //$final_i = 0;
        $final = [];
        foreach($filtered as $one_custom){
            $final[] = $one_custom;
        }
        
        $search_in = [
            'clock_in',
            'clock_out',
            'total',
            'task_manager',
            'from_t',
            'to_t',
            'descr',
        ];
        
        //add custom fields value to search array
        $ia = 1;
        foreach($final as $one_custom){
            $string = 'custom_column_value-' . $ia;
            $v = 'custom_column_visibility-' . $ia;
            $vs = $one_custom[$v];
            
            if($vs == 1){
                $search_in[] = $string;
            }
            $ia++;
        }
        
        $query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` = '".$user_id."'";
        if(!empty($date)){
            $converted_date = DateTime::createFromFormat('Y-m-d', $date)->format('d.m.Y');
            $query .= " AND `date` LIKE '$converted_date%'";
        } else{
            $converted_date = date('d.m.Y');
            $query .= " AND `date` LIKE '$converted_date%'";
        }
        
        $query .= $searh_all == 'true' ? "AND" : "AND(";//search on all dates or not
        foreach($search_in as $search_field){
            $query .= " `$search_field` LIKE '%$keyword%' OR";
        }
        $query = chop($query, ' OR');//remove last OR
        $query .= $searh_all == 'true' ? " ORDER BY `id` DESC" : ") ORDER BY `id` DESC";

        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        if($this->enable_load_total_from_pp === 1){
            foreach($data as $one_route){
                $pp_id = $one_route->pp_id;
                $user_id = $one_route->user_id;
                $date_obj = DateTime::createFromFormat('d.m.Y H:i:s', $one_route->date);
                $date = $date_obj->format('d.m.Y');
                $saved_total = $one_route->total;
                $confirm_id = $one_route->confirm_id;
                
                
                if(!empty($pp_id) && empty($saved_total)){
                    $calc_total = $this->loadSyncTotalValue($pp_id, $user_id, $date, 'pp');
                    $one_route->total = $calc_total;
                } if(empty($pp_id) && empty($saved_total) && !empty($confirm_id)){
                    $calc_total = $this->loadSyncTotalValue($confirm_id, $user_id, $date_obj->format('Y-m-d'), 'confirm');
                    $one_route->total = $calc_total;
                } 
            }       
        }
        
        return [
            'query' => $query,
            'search_in' => $search_in,
            'standart' => $data, 
            'custom' => $final
        ];
    }
    
    private function getLetters() {
        return range('A', 'Z');
    }
    
    private function getUsersFromManagerCheckHidden($manager_id)
    {
        $manager_id = (int)$manager_id;
        $query = 'SELECT * FROM #__users WHERE `owner_id`="'.$manager_id.'" AND `is_hide`="0" ORDER by id ASC';
      
        $this->db->setQuery( $query );
        $items = $this->db->loadObjectList(); 
        
        usort($items, [$this, 'compare']);
       
        ksort($items);
     
        return $items;
    }
    
    private function getRoutesForUsers(array $ids, $search = null, $search_all = null) {
        $all_user_id = $ids;

        //hh
        if(!empty($search)){
            /*$routes = $this->search($this->user, date('Y-m-d'), $search, true);
            echo '<pre>$routes';
            print_r($routes);
            echo '</pre>';
            return $routes;*/
        }
        $query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` IN(" . implode(",", $all_user_id) . ") ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $routes = $this->db->loadObjectList();
        
        if($this->enable_load_total_from_pp === 1){
            foreach($routes as $one_route){ 
                $pp_id = $one_route->pp_id;
                $user_id = $one_route->user_id;
                $date_obj = DateTime::createFromFormat('d.m.Y H:i:s', $one_route->date);
                $date = $date_obj->format('d.m.Y');
                $saved_total = $one_route->total;
                $confirm_id = $one_route->confirm_id;
                
                
                if(!empty($pp_id) && empty($saved_total)){
                    $calc_total = $this->loadSyncTotalValue($pp_id, $user_id, $date, 'pp');
                    $one_route->total = $calc_total;
                } if(empty($pp_id) && empty($saved_total) && !empty($confirm_id)){
                    $calc_total = $this->loadSyncTotalValue($confirm_id, $user_id, $date_obj->format('Y-m-d'), 'confirm');
                    $one_route->total = $calc_total;
                } 
            }       
        } 
        
        
        //filter custom columns to 1 array. You need select all items because customs not working correct with date
        $query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` IN(" . implode(",", $all_user_id) . ") ORDER BY `id` DESC";
       
        $this->db->setQuery($query);
        $data_for_custom = $this->db->loadObjectList();
        
        $custom = [];
        $i = 0;
        foreach($data_for_custom as $route){
            $j = 0;
            foreach($route as $k => $v){
               $exp_key = explode('-', $k);

               //get max value in key of custom columns
               if(count($exp_key) == 2 && in_array($exp_key[0], $this->custom_fields)){
                  $custom[$k] = $v; 
               }
               $j++;
            }
            $i++;
        }
        
        //filter custom columns to separate arrays, group by column number in key(custom_column_name-1, custom_column_value-1 should be in 1 array)
        $filtered = [];
        $filtered_i = 0;
        foreach($custom as $k => $v){
            $arr_name = explode('custom_column_name', $k);
            $arr_val = explode('custom_column_value', $k);
            $arr_type = explode('custom_column_type', $k);
            $arr_visibility = explode('custom_column_visibility', $k);
            
            if(count($arr_name) == 2 ){
                $filtered[$filtered_i][$k] = $v;
            }
            if(count($arr_val) == 2){
                $filtered[$filtered_i-1][$k] = $v;
            }
            if(count($arr_type) == 2){
                $filtered[$filtered_i-2][$k] = $v; 
            }
            if(count($arr_visibility) == 2){
                $filtered[$filtered_i-3][$k] = $v;
            }
            
            $filtered_i++;
        }
      
        //$final_i = 0;
        $final = [];
        foreach($filtered as $one_custom){
            $final[] = $one_custom;
        }
        
        $j = 0;
        foreach ($routes as $route) {
            $i = 1;
            $ik = 0;
            foreach ($final as $k => $route_custom) {
                $visibility = 'custom_column_visibility-' . $i;
                if ($route_custom[$visibility] != 1) {
                    $i++;
                    continue;
                }
                $type = 'custom_column_type-' . $i;
                $name = 'custom_column_name-' . $i;
                $value = 'custom_column_value-' . $i;
                
                $route->custom[$ik]['name'] = $route_custom[$name];//get name of custom columns from custom columns list
                $route->custom[$ik]['value'] = $route->$value;//get value from current route row
                $route->custom[$ik]['cell_name'] = $name;
                $route->custom[$ik]['type'] = $route_custom[$type];
                
                if ($route->custom[$ik]['type'] == 'total') {
                    $ia = 1;
                    $total_h = 0;

                    foreach ($final as $k1 => $route_custom1) {

                        $visibility1 = 'custom_column_visibility-' . $ia;
                        if ($route_custom1[$visibility1] != 1) {
                            $ia++;
                            continue;
                        }
                        $type1 = 'custom_column_type-' . $ia;
                        $name1 = 'custom_column_name-' . $ia;
                        $value1 = 'custom_column_value-' . $ia;

                        if ($route_custom1[$type1] == 'numbers') {
                            $total_h += $route->$value1;
                        }
                        
                        $ia++;
                    }
                    $route->custom[$ik]['value'] = $total_h;
                }

                $i++;
                $ik++;
            }
            $j++;
        }
        
        //$query = "SELECT `id`, `user_id`, `date`, `clock_in`, `clock_out`, `total`, `task_manager`, `from_t` AS `from`, `to_t` AS `to`, `km`, `descr` AS `description` FROM $this->dev_n_tools_table WHERE `user_id` = '".$user_obj->id."'";
        $permitted_fields = [
            'id',
            'user_id',
            'date',
            'clock_in',
            'clock_out',
            'total',
            'task_manager',
            'from',
            'to',
            'km',
            'description',
            'custom',
            'username'
        ];
        
        //filter cells
        foreach($routes as $route){
            $route->from = $route->from_t;
            $route->to = $route->to_t;
            $route->description = $route->descr;
            $route->username = $this->getFinalUsername(JFactory::getUser($route->user_id));
            
            unset($route->from_t, $route->to_t, $route->descr);
            foreach($route as $k=>$v){
                if(!in_array($k, $permitted_fields)){
                    unset($route->$k);
                }
            }
        }
        
        //group routes by user id
        foreach($routes as $route){    
            $res[$route->user_id][] = $route;
        }
       
        return $res;
    }
    
    private function reorderProps(object $obj, array $order) {
        $new_obj = new stdClass();
        foreach($order as $prop) {
            $new_obj->$prop = $obj->$prop;
        }
        return $new_obj;
    }
    
    public function createXls() {
        ini_set('memory_limit', '-1');
        set_time_limit(0);
      
        $lang = $this->app->input->getString('lang');
        $filename = $this->app->input->getString('filename');
        $user_id = $this->app->input->getInt('user_id');
        $manager_info = JFactory::getUser($user_id);
        
        $date = $this->app->input->getString('date');
        $phrase = strip_tags($this->app->input->getString('phrase'));
        $search_all = $this->app->input->getString('search_all');
        $from = $this->app->input->getString('from');
        $to = $this->app->input->getString('to');
        $additional_user_id = $this->app->input->getString('additional_user_id');
        
        file_put_contents($this->config->get('current_home_path') . '/logs/gps_xls.html', print_r($_REQUEST, true), FILE_APPEND | LOCK_EX); 
        
            
        if ($lang == "is") {
            $l = 'is';
        } else {
            $l = 'en';
        }

        $order = [
            'id',
            'user_id',
            'date',
            'username',
            'clock_in',
            'clock_out',
            'total',
            'task_manager',
            'from',
            'to',
            'km',
            'description',
            'custom'
        ];

        if (in_array(6, $manager_info->groups) || in_array(10, $manager_info->groups)) {
            if(in_array(6, $manager_info->groups)){
                $manager_users_object = $this->getUsersFromManagerCheckHidden($manager_info->id);//get manager users
            } elseif(in_array(10, $manager_info->groups)){
                $manager_users_object = $this->getUsersFromManagerCheckHidden($manager_info->owner_id);//get manager users
            }

            require_once JPATH_LIBRARIES . '/PHPExcel/Classes/PHPExcel.php';
            require_once JPATH_LIBRARIES . '/PHPExcel/Classes/PHPExcel/Writer/Excel2007.php';

            $xls = new PHPExcel();
            

            //set document info
            $xls->getProperties()->setTitle("Excel user data export");
            $xls->getProperties()->setSubject("Excel user data export");
            $xls->getProperties()->setCreator("Curio time");
            $xls->getProperties()->setManager("UXD");
            $xls->getProperties()->setCompany("UXD");
            $xls->getProperties()->setLastModifiedBy("UXD");
            $xls->getProperties()->setCreated(date('d.m.Y H:i:s'));

            //remove hidden users 
            foreach ($manager_users_object as $one_user) {
                if(in_array($one_user->group_user, $groups_array) || empty($groups_array[0])) {
                    if ($one_user->is_hide == 0 && $manager_info->owner_id != $one_user->id) {
                        $user_list_ids[] = $one_user;
                    }
               }
            }
            
            $aplhabet = $this->getLetters();
           
            $i = 0;
            $default_width = 12;
            
            $user_ids = array_column($user_list_ids, 'id');
            if(!empty($additional_user_id) && $additional_user_id != 'all' && $search_all == 'false'){
                unset($user_ids);
                $user_ids[] = $additional_user_id;
            }
          
            if($search_all == 'false' && empty($phrase)){
                $company_routes = $this->getRoutesForUsers($user_ids);
            }
            
            //fix for correct work of IS lang
            if ($lang === 'is') {
                $lang1 = & JFactory::getLanguage();
                $lang1->setLanguage('is-IS');
                $lang1->load();
                $extension = 'com_audit';
                $base_dir = JPATH_SITE;
                $language_tag = 'is-IS'; 
                $reload = true;
                $lang1->load($extension, $base_dir, $language_tag, $reload);
            }
            
            //store table headers translate
            $table_headers = [
                JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_TABLE_HEADERS_DATE'),
                JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_TABLE_HEADERS_USERNAME'),
                JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_TABLE_HEADERS_CLOCK_IN'),
                JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_TABLE_HEADERS_CLOCK_OUT'),
                JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_TABLE_HEADERS_TOTAL'),
                JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_TABLE_HEADERS_TMANAGER'),
                JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_TABLE_HEADERS_FROM'),
                JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_TABLE_HEADERS_TO'),
                JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_TABLE_HEADERS_KM'),
                JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_TABLE_HEADERS_DESCRIPTION')
            ];
            
            
            if($search_all == 'true' && !empty($phrase)){//search all mode
                
                if(empty($from) && empty($to)){
                    $date = date('Y-m-d');
                    $from = $to = $date;   
                }
                $company_routes = $this->searchForExcel($user_ids, $phrase, $search_all, $from, $to); 
                //file_put_contents($this->config->get('current_home_path') . '/logs/gps_xls.html', print_r($company_routes, true), FILE_APPEND | LOCK_EX); 
               
                
                
                
                //$username = $this->getFinalUsername($one_filter_user);
                $objWorkSheet = $xls->createSheet(1); //Setting index when creating
                
                //set sheet name in bottom
                $objWorkSheet->setTitle('Search result');
               
               /* $user_routes = $company_routes[$one_filter_user->id];*/

                //set columns width
                $objWorkSheet->getColumnDimension('A')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('B')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('C')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('D')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('E')->setWidth(20);
                $objWorkSheet->getColumnDimension('F')->setWidth(60);
                $objWorkSheet->getColumnDimension('G')->setWidth(60);
                $objWorkSheet->getColumnDimension('H')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('I')->setWidth(50);
                $objWorkSheet->getColumnDimension('J')->setWidth($default_width);

                //set headers
              
                $headers_i = 0;
                foreach($table_headers as $header){
                    //$objWorkSheet->getColumnDimension($aplhabet[$headers_i] . "3")->setWidth($default_width);
                     
                    $current_leter_in_headers = $aplhabet[$headers_i] . "3";
                    $objWorkSheet->setCellValue($current_leter_in_headers, $header); 
                    $styleArray = [
                        'font'  => [
                            'bold'  => true,
                            //'color' => array('rgb' => '000000'),
                            //'size'  => 15,
                            //'name'  => 'Verdana'
                        ]
                    ];
                    $objWorkSheet->getStyle($current_leter_in_headers)->applyFromArray($styleArray);
                    
                    $headers_i++;
                }
                
                $first_company_route_custom = $company_routes['standart'][0]->custom;
                
                 //each custom headers
                if (!empty($first_company_route_custom)) {
                    if (!empty($company_routes[0])) { 
                        $order2 = $this->getLastColumnOrder($company_routes['standart'][0]->user_id);
                        $company_routes[0]->custom = $this->reorderPropsCustomForApi($first_company_route_custom, json_decode($order2, true));
                    }

                    foreach ($company_routes['standart'][0]->custom as $header) {
                        $current_leter_in_headers = $aplhabet[$headers_i] . "3";
                        $objWorkSheet->setCellValue($current_leter_in_headers, $header['name']);
                        $styleArray = [
                            'font' => [
                                'bold' => true,
                            ]
                        ];
                        $objWorkSheet->getStyle($current_leter_in_headers)->applyFromArray($styleArray);

                        $headers_i++;
                    }
                }
                //end each custom headers
                

                $userSpaceUsed = 0;

                $default_cell_table_start = 4;//each routes starts from A4
                $tr_i = $default_cell_table_start;
              
              
               
                foreach ($company_routes['standart'] as $tr) {
                    $objWorkSheet->setCellValue('A1', JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EXCEL_SEARCH_RESULT'));
                    $objWorkSheet->setCellValue('B1', $phrase);
                    $styleArray = [
                        'font'  => [
                            'bold'  => true,
                           
                        ]
                    ];
                    $objWorkSheet->getStyle('B1')->applyFromArray($styleArray);
                    $objWorkSheet->setCellValue('C1', JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EXCEL_SEARCH_CREATED') . date('d.m.Y H:i:s'));
                    
                    //to made correct order, similar as in site
                    if (!empty($tr)) {
                        $tr_new = $this->reorderProps($tr, $order);
                    }
                    //file_put_contents($this->config->get('current_home_path') . '/logs/gps_xls.html', print_r($tr, true), FILE_APPEND | LOCK_EX); 
                    $td_i = 0;
                    unset($column_order);
                    $column_order = $tr_new->column_order;
                    
                    foreach ($tr_new as $k => $td) {
                        if (in_array($k, [
                            'id',
                            'user_id'   
                        ])) {
                            continue;
                        }
                        $current_leter = $aplhabet[$td_i] . $tr_i;

                        if($k != 'custom'){
                            $objWorkSheet->setCellValue($current_leter, $td);
                        } else{
                            //custom = []
                            $user_id = $tr->user_id;
                            if (!empty($td) && !empty($column_order)) {
                                $td = $this->reorderPropsCustomForApi($td, json_decode($column_order, false));//custom = ordered custom
                            } else {
                                if (!empty($td)) { 
                                    $order1 = $this->getLastColumnOrder($user_id);
                                    $td = $this->reorderPropsCustomForApi($td, json_decode($order1, true));
                                }
                            }
                            
                            foreach ($td as $k => $route_custom) {
                                $current_leter_custom = $aplhabet[$td_i] . $tr_i;
                                $objWorkSheet->setCellValue($current_leter_custom, $route_custom['value']);

                                $td_i++;     
                            }
                        }

                        $td_i++;
                    }
                    
                    /*if (empty($user_routes)) { 
                        $userSpaceUsed = 1;
                        $xls->removeSheetByIndex(
                                $xls->getIndex(
                                        $xls->getSheetByName($username)
                                )
                        );
                        continue;
                    }*/

                    $i++;
                     $tr_i++;
                }

                $xls->setActiveSheetIndex(0);

                //remove default worksheet
                $xls->removeSheetByIndex(
                    $xls->getIndex(
                        $xls->getSheetByName('Worksheet')
                    )
                );
           
                jimport('joomla.filesystem.folder');
                $folder = 'tmp_xls_dev_n_tools';

                if (!JFolder::exists(JPATH_BASE . DS . $folder)) {
                    JFolder::create(JPATH_BASE . DS . $folder);
                }
            
                $pathFile = JPATH_BASE . DS . $folder . DS . $filename; //true
                $objWriter = new PHPExcel_Writer_Excel2007($xls);
                $objWriter->save($pathFile);
            
                return $filename;
            } elseif($search_all == 'false' && !empty($phrase)){//search one user mode
                if(empty($from) && empty($to)){
                    $date = date('Y-m-d');
                    $from = $to = $date;   
                }
                
                $company_routes = $this->searchForExcel($user_ids, $phrase, $search_all, $from, $to); 
                
                $objWorkSheet = $xls->createSheet(1); //Setting index when creating
                
                //set sheet name in bottom
                $objWorkSheet->setTitle('Search result');
               
               /* $user_routes = $company_routes[$one_filter_user->id];*/

                //set columns width
                $objWorkSheet->getColumnDimension('A')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('B')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('C')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('D')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('E')->setWidth(20);
                $objWorkSheet->getColumnDimension('F')->setWidth(60);
                $objWorkSheet->getColumnDimension('G')->setWidth(60);
                $objWorkSheet->getColumnDimension('H')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('I')->setWidth(50);
                $objWorkSheet->getColumnDimension('J')->setWidth($default_width);

                //set headers
              
                $headers_i = 0;
                foreach($table_headers as $header){
                    //$objWorkSheet->getColumnDimension($aplhabet[$headers_i] . "3")->setWidth($default_width);
                     
                    $current_leter_in_headers = $aplhabet[$headers_i] . "3";
                    $objWorkSheet->setCellValue($current_leter_in_headers, $header); 
                    $styleArray = [
                        'font'  => [
                            'bold'  => true,
                            //'color' => array('rgb' => '000000'),
                            //'size'  => 15,
                            //'name'  => 'Verdana'
                        ]
                    ];
                    $objWorkSheet->getStyle($current_leter_in_headers)->applyFromArray($styleArray);
                    
                    $headers_i++;
                }
                
                $first_company_route_custom = $company_routes['standart'][0]->custom;
                
                 //each custom headers
                if (!empty($first_company_route_custom)) {
                    if (!empty($company_routes[0])) { 
                        $order2 = $this->getLastColumnOrder($company_routes['standart'][0]->user_id);
                        $company_routes[0]->custom = $this->reorderPropsCustomForApi($first_company_route_custom, json_decode($order2, true));
                    }

                    foreach ($company_routes['standart'][0]->custom as $header) {
                        $current_leter_in_headers = $aplhabet[$headers_i] . "3";
                        $objWorkSheet->setCellValue($current_leter_in_headers, $header['name']);
                        $styleArray = [
                            'font' => [
                                'bold' => true,
                            ]
                        ];
                        $objWorkSheet->getStyle($current_leter_in_headers)->applyFromArray($styleArray);

                        $headers_i++;
                    }
                }
                //end each custom headers
                

                $userSpaceUsed = 0;

                $default_cell_table_start = 4;//each routes starts from A4
                $tr_i = $default_cell_table_start;
              
              
               
                foreach ($company_routes['standart'] as $tr) {
                    $objWorkSheet->setCellValue('A1', JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EXCEL_SEARCH_RESULT'));
                    $objWorkSheet->setCellValue('B1', $phrase);
                    $styleArray = [
                        'font'  => [
                            'bold'  => true,
                           
                        ]
                    ];
                    $objWorkSheet->getStyle('B1')->applyFromArray($styleArray);
                    $objWorkSheet->setCellValue('C1', JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EXCEL_SEARCH_CREATED') . date('d.m.Y H:i:s'));
                    $objWorkSheet->setCellValue('D1', JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EXCEL_SEARCH_SELECTED_DATE') .  date('d.m.Y'));
                    
                    //to made correct order, similar as in site
                    if (!empty($tr)) {
                        $tr_new = $this->reorderProps($tr, $order);
                    }
                    //file_put_contents($this->config->get('current_home_path') . '/logs/gps_xls.html', print_r($tr, true), FILE_APPEND | LOCK_EX); 
                    $td_i = 0;
                    unset($column_order);
                    $column_order = $tr_new->column_order;
                    
                    foreach ($tr_new as $k => $td) {
                        if (in_array($k, [
                            'id',
                            'user_id'   
                        ])) {
                            continue;
                        }
                        $current_leter = $aplhabet[$td_i] . $tr_i;

                        if($k != 'custom'){
                            $objWorkSheet->setCellValue($current_leter, $td);
                        } else{
                            //custom = []
                            $user_id = $tr->user_id;
                            if (!empty($td) && !empty($column_order)) {
                                $td = $this->reorderPropsCustomForApi($td, json_decode($column_order, false));//custom = ordered custom
                            } else {
                                if (!empty($td)) { 
                                    $order1 = $this->getLastColumnOrder($user_id);
                                    $td = $this->reorderPropsCustomForApi($td, json_decode($order1, true));
                                }
                            }
                            
                            foreach ($td as $k => $route_custom) {
                                $current_leter_custom = $aplhabet[$td_i] . $tr_i;
                                $objWorkSheet->setCellValue($current_leter_custom, $route_custom['value']);

                                $td_i++;     
                            }
                        }

                        $td_i++;
                    }
                    
                   

                    $i++;
                     $tr_i++;
                }

                $xls->setActiveSheetIndex(0);

                //remove default worksheet
                $xls->removeSheetByIndex(
                    $xls->getIndex(
                        $xls->getSheetByName('Worksheet')
                    )
                );
           
                jimport('joomla.filesystem.folder');
                $folder = 'tmp_xls_dev_n_tools';

                if (!JFolder::exists(JPATH_BASE . DS . $folder)) {
                    JFolder::create(JPATH_BASE . DS . $folder);
                }
            
                $pathFile = JPATH_BASE . DS . $folder . DS . $filename; //true
                $objWriter = new PHPExcel_Writer_Excel2007($xls);
                $objWriter->save($pathFile);
            
                return $filename;
            } elseif($search_all == 'false' && empty($phrase) && $user_id == JFactory::getUser($user_id)->owner_id && (empty($from) && empty($to))){//search all in User list
                if(empty($from) && empty($to)){
                    $date = date('Y-m-d');
                    $from = $to = $date;   
                }
                
                $company_routes = $this->searchForExcel($user_ids, $phrase, $search_all, $from, $to, $additional_user_id); 
                
                $objWorkSheet = $xls->createSheet(1); //Setting index when creating
                
                //set sheet name in bottom
                $objWorkSheet->setTitle('Show all');
               
               /* $user_routes = $company_routes[$one_filter_user->id];*/

                //set columns width
                $objWorkSheet->getColumnDimension('A')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('B')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('C')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('D')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('E')->setWidth(20);
                $objWorkSheet->getColumnDimension('F')->setWidth(60);
                $objWorkSheet->getColumnDimension('G')->setWidth(60);
                $objWorkSheet->getColumnDimension('H')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('I')->setWidth(50);
                $objWorkSheet->getColumnDimension('J')->setWidth($default_width);

                //set headers
              
                $headers_i = 0;
                foreach($table_headers as $header){
                    //$objWorkSheet->getColumnDimension($aplhabet[$headers_i] . "3")->setWidth($default_width);
                     
                    $current_leter_in_headers = $aplhabet[$headers_i] . "3";
                    $objWorkSheet->setCellValue($current_leter_in_headers, $header); 
                    $styleArray = [
                        'font'  => [
                            'bold'  => true,
                            //'color' => array('rgb' => '000000'),
                            //'size'  => 15,
                            //'name'  => 'Verdana'
                        ]
                    ];
                    $objWorkSheet->getStyle($current_leter_in_headers)->applyFromArray($styleArray);
                    
                    $headers_i++;
                }
                
                $first_company_route_custom = $company_routes['standart'][0]->custom;
                
                 //each custom headers
                if (!empty($first_company_route_custom)) {
                    if (!empty($company_routes[0])) { 
                        $order2 = $this->getLastColumnOrder($company_routes['standart'][0]->user_id);
                        $company_routes[0]->custom = $this->reorderPropsCustomForApi($first_company_route_custom, json_decode($order2, true));
                    }

                    foreach ($company_routes['standart'][0]->custom as $header) {
                        $current_leter_in_headers = $aplhabet[$headers_i] . "3";
                        $objWorkSheet->setCellValue($current_leter_in_headers, $header['name']);
                        $styleArray = [
                            'font' => [
                                'bold' => true,
                            ]
                        ];
                        $objWorkSheet->getStyle($current_leter_in_headers)->applyFromArray($styleArray);

                        $headers_i++;
                    }
                }
                //end each custom headers
                

                $userSpaceUsed = 0;

                $default_cell_table_start = 4;//each routes starts from A4
                $tr_i = $default_cell_table_start;
              
              
               
                foreach ($company_routes['standart'] as $tr) {
                    
                    $objWorkSheet->setCellValue('C1', JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EXCEL_SEARCH_CREATED') . date('d.m.Y H:i:s'));
                    $objWorkSheet->setCellValue('D1', JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EXCEL_SEARCH_SELECTED_DATE') .  $from . '-' . $to);
                    
                    //to made correct order, similar as in site
                    if (!empty($tr)) {
                        $tr_new = $this->reorderProps($tr, $order);
                    }
                    //file_put_contents($this->config->get('current_home_path') . '/logs/gps_xls.html', print_r($tr, true), FILE_APPEND | LOCK_EX); 
                    $td_i = 0;
                    unset($column_order);
                    $column_order = $tr_new->column_order;
                    
                    foreach ($tr_new as $k => $td) {
                        if (in_array($k, [
                            'id',
                            'user_id'   
                        ])) {
                            continue;
                        }
                        $current_leter = $aplhabet[$td_i] . $tr_i;

                        if($k != 'custom'){
                            $objWorkSheet->setCellValue($current_leter, $td);
                        } else{
                            //custom = []
                            $user_id = $tr->user_id;
                            if (!empty($td) && !empty($column_order)) {
                                $td = $this->reorderPropsCustomForApi($td, json_decode($column_order, false));//custom = ordered custom
                            } else {
                                if (!empty($td)) { 
                                    $order1 = $this->getLastColumnOrder($user_id);
                                    $td = $this->reorderPropsCustomForApi($td, json_decode($order1, true));
                                }
                            }
                            
                            foreach ($td as $k => $route_custom) {
                                $current_leter_custom = $aplhabet[$td_i] . $tr_i;
                                $objWorkSheet->setCellValue($current_leter_custom, $route_custom['value']);

                                $td_i++;     
                            }
                        }

                        $td_i++;
                    }
                    
                   
                    $i++;
                     $tr_i++;
                }

                $xls->setActiveSheetIndex(0);

                //remove default worksheet
                $xls->removeSheetByIndex(
                    $xls->getIndex(
                        $xls->getSheetByName('Worksheet')
                    )
                );
           
                jimport('joomla.filesystem.folder');
                $folder = 'tmp_xls_dev_n_tools';

                if (!JFolder::exists(JPATH_BASE . DS . $folder)) {
                    JFolder::create(JPATH_BASE . DS . $folder);
                }
            
                $pathFile = JPATH_BASE . DS . $folder . DS . $filename; //true
                $objWriter = new PHPExcel_Writer_Excel2007($xls);
                $objWriter->save($pathFile);
                return false;
            } elseif($search_all == 'false' && empty($phrase) && $user_id == JFactory::getUser($user_id)->owner_id && (!empty($from) && !empty($to))){//search all in User list
           
                //file_put_contents($this->config->get('current_home_path') . '/logs/gps_xls.html', print_r($_REQUEST, true), FILE_APPEND | LOCK_EX); 
                $company_routes = $this->searchForExcel($user_ids, $phrase, $search_all, $from, $to); 
                
                $objWorkSheet = $xls->createSheet(1); //Setting index when creating
                
                //set sheet name in bottom
                $objWorkSheet->setTitle('Show period');
               
               /* $user_routes = $company_routes[$one_filter_user->id];*/

                //set columns width
                $objWorkSheet->getColumnDimension('A')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('B')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('C')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('D')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('E')->setWidth(20);
                $objWorkSheet->getColumnDimension('F')->setWidth(60);
                $objWorkSheet->getColumnDimension('G')->setWidth(60);
                $objWorkSheet->getColumnDimension('H')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('I')->setWidth(50);
                $objWorkSheet->getColumnDimension('J')->setWidth($default_width);

                //set headers
              
                $headers_i = 0;
                foreach($table_headers as $header){
                    //$objWorkSheet->getColumnDimension($aplhabet[$headers_i] . "3")->setWidth($default_width);
                     
                    $current_leter_in_headers = $aplhabet[$headers_i] . "3";
                    $objWorkSheet->setCellValue($current_leter_in_headers, $header); 
                    $styleArray = [
                        'font'  => [
                            'bold'  => true,
                            //'color' => array('rgb' => '000000'),
                            //'size'  => 15,
                            //'name'  => 'Verdana'
                        ]
                    ];
                    $objWorkSheet->getStyle($current_leter_in_headers)->applyFromArray($styleArray);
                    
                    $headers_i++;
                }
                
                $first_company_route_custom = $company_routes['standart'][0]->custom;
                
                 //each custom headers
                if (!empty($first_company_route_custom)) {
                    if (!empty($company_routes[0])) { 
                        $order2 = $this->getLastColumnOrder($company_routes['standart'][0]->user_id);
                        $company_routes[0]->custom = $this->reorderPropsCustomForApi($first_company_route_custom, json_decode($order2, true));
                    }

                    foreach ($company_routes['standart'][0]->custom as $header) {
                        $current_leter_in_headers = $aplhabet[$headers_i] . "3";
                        $objWorkSheet->setCellValue($current_leter_in_headers, $header['name']);
                        $styleArray = [
                            'font' => [
                                'bold' => true,
                            ]
                        ];
                        $objWorkSheet->getStyle($current_leter_in_headers)->applyFromArray($styleArray);

                        $headers_i++;
                    }
                }
                //end each custom headers
                

                $userSpaceUsed = 0;

                $default_cell_table_start = 4;//each routes starts from A4
                $tr_i = $default_cell_table_start;
              
              
               
                foreach ($company_routes['standart'] as $tr) {
                   
                    $objWorkSheet->setCellValue('C1', JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EXCEL_SEARCH_CREATED') . date('d.m.Y H:i:s'));
                    $objWorkSheet->setCellValue('D1', JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EXCEL_SEARCH_SELECTED_DATE') .  $from . '-' . $to);
                    
                    //to made correct order, similar as in site
                    if (!empty($tr)) {
                        $tr_new = $this->reorderProps($tr, $order);
                    }
                    //file_put_contents($this->config->get('current_home_path') . '/logs/gps_xls.html', print_r($tr, true), FILE_APPEND | LOCK_EX); 
                    $td_i = 0;
                    unset($column_order);
                    $column_order = $tr_new->column_order;
                    
                    foreach ($tr_new as $k => $td) {
                        if (in_array($k, [
                            'id',
                            'user_id'   
                        ])) {
                            continue;
                        }
                        $current_leter = $aplhabet[$td_i] . $tr_i;

                        if($k != 'custom'){
                            $objWorkSheet->setCellValue($current_leter, $td);
                        } else{
                            //custom = []
                            $user_id = $tr->user_id;
                            if (!empty($td) && !empty($column_order)) {
                                $td = $this->reorderPropsCustomForApi($td, json_decode($column_order, false));//custom = ordered custom
                            } else {
                                if (!empty($td)) { 
                                    $order1 = $this->getLastColumnOrder($user_id);
                                    $td = $this->reorderPropsCustomForApi($td, json_decode($order1, true));
                                }
                            }
                            
                            foreach ($td as $k => $route_custom) {
                                $current_leter_custom = $aplhabet[$td_i] . $tr_i;
                                $objWorkSheet->setCellValue($current_leter_custom, $route_custom['value']);

                                $td_i++;     
                            }
                        }

                        $td_i++;
                    }

                    $i++;
                    $tr_i++;
                }

                $xls->setActiveSheetIndex(0);

                //remove default worksheet
                $xls->removeSheetByIndex(
                    $xls->getIndex(
                        $xls->getSheetByName('Worksheet')
                    )
                );
           
                jimport('joomla.filesystem.folder');
                $folder = 'tmp_xls_dev_n_tools';

                if (!JFolder::exists(JPATH_BASE . DS . $folder)) {
                    JFolder::create(JPATH_BASE . DS . $folder);
                }
            
                $pathFile = JPATH_BASE . DS . $folder . DS . $filename; //true
                $objWriter = new PHPExcel_Writer_Excel2007($xls);
                $objWriter->save($pathFile);
                return false;
            }
            /*file_put_contents($this->config->get('current_home_path') . '/logs/gps_xls.html', print_r($search_all . PHP_EOL, true), FILE_APPEND | LOCK_EX); 
            file_put_contents($this->config->get('current_home_path') . '/logs/gps_xls.html', print_r($phrase . PHP_EOL, true), FILE_APPEND | LOCK_EX); 
            file_put_contents($this->config->get('current_home_path') . '/logs/gps_xls.html', print_r($user_id . PHP_EOL, true), FILE_APPEND | LOCK_EX); 
            file_put_contents($this->config->get('current_home_path') . '/logs/gps_xls.html', print_r(  (JFactory::getUser($user_id)->owner_id) . PHP_EOL, true), FILE_APPEND | LOCK_EX); 
            */
            foreach ($user_list_ids as $one_filter_user) {
                $username = $this->getFinalUsername($one_filter_user);
                $objWorkSheet = $xls->createSheet($i); //Setting index when creating
                
                //set sheet name in bottom
                $objWorkSheet->setTitle($username);
                $objWorkSheet->setCellValue('A1', $username);
                $user_routes = $company_routes[$one_filter_user->id];
                //file_put_contents($this->config->get('current_home_path') . '/logs/gps_xls.html', print_r($user_routes, true), FILE_APPEND | LOCK_EX); 
                //set columns width
                $objWorkSheet->getColumnDimension('A')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('B')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('C')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('D')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('E')->setWidth(20);
                $objWorkSheet->getColumnDimension('F')->setWidth(60);
                $objWorkSheet->getColumnDimension('G')->setWidth(60);
                $objWorkSheet->getColumnDimension('H')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('I')->setWidth(50);
                $objWorkSheet->getColumnDimension('J')->setWidth($default_width);

                //set headers
                $headers_i = 0;
                foreach($table_headers as $header){
                    //$objWorkSheet->getColumnDimension($aplhabet[$headers_i] . "3")->setWidth($default_width);
                     
                    $current_leter_in_headers = $aplhabet[$headers_i] . "3";
                    $objWorkSheet->setCellValue($current_leter_in_headers, $header); 
                    $styleArray = [
                        'font'  => [
                            'bold'  => true,
                            //'color' => array('rgb' => '000000'),
                            //'size'  => 15,
                            //'name'  => 'Verdana'
                        ]
                    ];
                    $objWorkSheet->getStyle($current_leter_in_headers)->applyFromArray($styleArray);
                    
                    $headers_i++;
                }
               
                //each custom headers
                if (!empty($user_routes[0]->custom)) {
                    if (!empty($user_routes[0])) { 
                        $order2 = $this->getLastColumnOrder($user_id);
                        $user_routes[0]->custom = $this->reorderPropsCustomForApi($user_routes[0]->custom, json_decode($order2, true));
                    }

                    foreach ($user_routes[0]->custom as $header) {
                        $current_leter_in_headers = $aplhabet[$headers_i] . "3";
                        $objWorkSheet->setCellValue($current_leter_in_headers, $header['name']);
                        $styleArray = [
                            'font' => [
                                'bold' => true,
                            ]
                        ];
                        $objWorkSheet->getStyle($current_leter_in_headers)->applyFromArray($styleArray);

                        $headers_i++;
                    }
                }

                $userSpaceUsed = 0;

                $default_cell_table_start = 4;//each routes starts from A4
                $tr_i = $default_cell_table_start;
              
               
                foreach ($user_routes as $tr) {
                    //to made correct order, similar as in site
                    if (!empty($tr)) {
                        $tr_new = $this->reorderProps($tr, $order);
                    }
                   
                    $td_i = 0;
                    unset($column_order);
                    $column_order = $tr_new->column_order;
                    
                    foreach ($tr_new as $k => $td) {
                        if (in_array($k, [
                            'id',
                            //'username',
                            'user_id'   
                        ])) {
                            continue;
                        }
                        $current_leter = $aplhabet[$td_i] . $tr_i;

                        if($k != 'custom'){
                            $objWorkSheet->setCellValue($current_leter, $td);
                        } else{
                            //custom = []
                            
                            if (!empty($td) && !empty($column_order)) {
                                $td = $this->reorderPropsCustomForApi($td, json_decode($column_order, false));//custom = ordered custom
                            } else {
                                if (!empty($td)) { 
                                    $order1 = $this->getLastColumnOrder($user_id);
                                    $td = $this->reorderPropsCustomForApi($td, json_decode($order1, true));
                                }
                            }
                            
                            foreach ($td as $k => $route_custom) {
                                $current_leter_custom = $aplhabet[$td_i] . $tr_i;
                                $objWorkSheet->setCellValue($current_leter_custom, $route_custom['value']);

                                $td_i++;     
                            }
                        }

                        $td_i++;
                    }

                    //sleep(1);
                    $tr_i++;
                }

                if(empty($user_routes)) {
                    $userSpaceUsed = 1;
                    $xls->removeSheetByIndex(
                            $xls->getIndex(
                                    $xls->getSheetByName($username)
                            )
                    );
                    continue;
                }
 
                $i++;
            }

            $xls->setActiveSheetIndex(0);

            //remove default worksheet
            $xls->removeSheetByIndex(
                $xls->getIndex(
                    $xls->getSheetByName('Worksheet')
                )
            );
           
            jimport('joomla.filesystem.folder');
            $folder = 'tmp_xls_dev_n_tools';

            if (!JFolder::exists(JPATH_BASE . DS . $folder)) {
                JFolder::create(JPATH_BASE . DS . $folder);
            }
            
            $pathFile = JPATH_BASE . DS . $folder . DS . $filename; //true
            $objWriter = new PHPExcel_Writer_Excel2007($xls);
            $objWriter->save($pathFile);
            
            return $filename;
        }
    }
    
    public function setCustomHeadersOrdering(int $user_id, string $ordering, array $additional_info) {
        
        $i = 0;
        $final = [];
        foreach ($additional_info as $item) {
            $final[] = $item['id'];

            $i++;
        }
        
       
        $all_user_id = $this->loadCompanyUsersId($user_id);
        
        //reorder columns in company
        $query = "UPDATE $this->dev_n_tools_table SET `column_order` = '".json_encode($final)."' WHERE `user_id` IN(" . implode(",", $all_user_id) . ")";       
        //echo $query;
        $this->db->setQuery($query);
        $this->db->query(); 
    }
}
