<?php

// No direct access
defined('_JEXEC') or die;

/**
 * @author 
 */
class AuditModelDk extends JModelLegacy {

    public function __construct() 
    {
        parent::__construct();

        $this->db = &JFactory::getDBO();
        $this->app = JFactory::getApplication();
        $this->doc = JFactory::getDocument();
        $this->user = & JFactory::getUser();
        
        $this->dk_api_login = 'demo@dkplus.is';
        $this->dk_api_password = 'Demo123';
        
        if(in_array(10, $this->user->groups)){
            $manager = & JFactory::getUser($this->user->owner_id);
            if($manager->id != 0){
                $this->dk_company_token = $manager->dk_token;
            }
            
        } elseif(in_array(6, $this->user->groups)){
            $this->dk_company_token = $this->user->dk_token;
        }
        
        
        $this->dk_task_limit = 50;
        $this->dk_api_company_tasks_url = 'https://api.dkplus.is/api/v1/project/';
        $this->dk_api_company_subtasks_url ='https://api.dkplus.is/api/v1/general/table/PJPHASES/records?fields=DESCRIPTION';
    }
    
    public function getDkTasks() {
       
        $url = $this->dk_api_company_tasks_url;
        $ch = curl_init();
        $authorization = "Authorization: Bearer ".$this->dk_company_token; // Prepare the authorisation token
        
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            //CURLOPT_HTTPAUTH => CURLAUTH_BASIC,
           // CURLOPT_USERPWD => "$this->dk_api_login:$this->dk_api_password",
            /*CURLOPT_POSTFIELDS => [
                'token'=>$this->dk_company_token
            ]*/
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json',
                $authorization
            ]
        ]);
 
        $result = curl_exec($ch);
        curl_close($ch);
        
       
        $res = json_decode($result);
        /*echo '<pre>';
        print_r($res);
        echo '</pre>';*/
        $final = [];
        
        foreach($res as $one_task){
            if($one_task->JobStatus == 1){
                $final[] = $one_task;
            }
        }
        
        return $final;
    }
    
    public function getDkTasksApi($manager_id) {
       
        $url = $this->dk_api_company_tasks_url;
        $manager_obj = JFactory::getUser($manager_id);
        $company_token = $manager_obj->dk_token;
        
        $ch = curl_init();
        $authorization = "Authorization: Bearer ".$company_token; // Prepare the authorisation token
        
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            //CURLOPT_HTTPAUTH => CURLAUTH_BASIC,
           // CURLOPT_USERPWD => "$this->dk_api_login:$this->dk_api_password",
            /*CURLOPT_POSTFIELDS => [
                'token'=>$this->dk_company_token
            ]*/
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json',
                $authorization
            ]
        ]);
 
        $result = curl_exec($ch);
        curl_close($ch);
        
       
        $res = json_decode($result);
        /*echo '<pre>';
        print_r($res);
        echo '</pre>';*/
        $final = [];
        
        foreach($res as $one_task){
            if($one_task->JobStatus == 1){
                $final[] = $one_task;
            }
        }
        
        return $final;
    }
    
    public function getDkSubtasks()
    {
        $url = $this->dk_api_company_subtasks_url;
        $ch = curl_init();
        $authorization = "Authorization: Bearer ".$this->dk_company_token; // Prepare the authorisation token
        
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            //CURLOPT_HTTPAUTH => CURLAUTH_BASIC,
           // CURLOPT_USERPWD => "$this->dk_api_login:$this->dk_api_password",
            /*CURLOPT_POSTFIELDS => [
                'token'=>$this->dk_company_token
            ]*/
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json',
                $authorization
            ]
        ]);
 
        $result = curl_exec($ch);
        curl_close($ch);
        
       
        return json_decode($result);
    }

    public function getDkSubtasksForApi($manager_id)
    {
        $url = $this->dk_api_company_subtasks_url;
        $manager_obj = JFactory::getUser($manager_id);
        $company_token = $manager_obj->dk_token;
        
        $ch = curl_init();
        $authorization = "Authorization: Bearer ".$company_token; // Prepare the authorisation token
        
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            //CURLOPT_HTTPAUTH => CURLAUTH_BASIC,
           // CURLOPT_USERPWD => "$this->dk_api_login:$this->dk_api_password",
            /*CURLOPT_POSTFIELDS => [
                'token'=>$this->dk_company_token
            ]*/
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json',
                $authorization
            ]
        ]);
 
        $result = curl_exec($ch);
        curl_close($ch);
        
        $new_res = array_column(json_decode($result), 'DESCRIPTION');
        
        $final = [];
        foreach($new_res as $subtask){
            $item = new stdClass();
            $item->text = $subtask;
            $item->id_user = (int)$manager_id;
            
            $final[] = $item;
        }
        return $final;
    }
    
    public function getDkSubtasksForHomepage($manager_id)
    {
        $url = $this->dk_api_company_subtasks_url;
        $manager_obj = JFactory::getUser($manager_id);
        $company_token = $manager_obj->dk_token;
        
        $ch = curl_init();
        $authorization = "Authorization: Bearer ".$company_token; // Prepare the authorisation token
        
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            //CURLOPT_HTTPAUTH => CURLAUTH_BASIC,
           // CURLOPT_USERPWD => "$this->dk_api_login:$this->dk_api_password",
            /*CURLOPT_POSTFIELDS => [
                'token'=>$this->dk_company_token
            ]*/
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json',
                $authorization
            ]
        ]);
 
        $result = curl_exec($ch);
        curl_close($ch);
        
        /*$new_res = array_column(json_decode($result), 'DESCRIPTION');
        
        $final = [];
        foreach($new_res as $subtask){
            $item = new stdClass();
            $item->text = $subtask;
            $item->id_user = (int)$manager_id;
            
            $final[] = $item;
        }
        return $final;*/
        return json_decode($result);
    }

}
