<?php
// No direct access
defined('_JEXEC') or die;
/**
 * @author 
 */
class AuditModelCustom_pay_period extends JModelLegacy {

    public function __construct() {
        parent::__construct();

        $this->db = &JFactory::getDBO();
        $this->app = JFactory::getApplication();
        $this->doc = JFactory::getDocument();

        $this->work_day_hours = 8;
        $this->user = & JFactory::getUser(); 
        //$this->lang = & JFactory::getLanguage();
       
        require_once (JPATH_BASE.DS.'components'.DS.'com_audit'.DS.'assets'.DS.'incl'.DS.'simplehtmldom_1_5'.DS.'simple_html_dom.php');
    }

    public function backgroundClassesArray($user_id, $dates) {
        //$dates=json_decode($dates);
        $final_array=[];
        
        foreach($dates as $items){
            $i=0;
            
            foreach ($items as $date){              
                $time_array=explode(':', $date['time']); 
                $hours=$time_array[0];
                               
                //if($hours>=$this->work_day_hours){                     
                    $bckground_class=$this->getBackgroundClass($date['date'], $user_id);
                    
                    //$final_array[]=$hours;
                    $final_array['items'][$i]['user_id']=$user_id;
                    $final_array['items'][$i]['date']=$date['date'];
                    $final_array['items'][$i]['total_time']=$date['time'];
                    $final_array['items'][$i]['class']=$bckground_class;
                    
                    $i++;
                //}                           
            }     
        }
        return $final_array;
    }
    
    public function getBackgroundClass($date, $user_id)
    {
        $user_id=(int)$user_id;
        $date1=explode('.', $date);
        
        $year=date('Y', strtotime($date));
        $month=date('n', strtotime($date));
        $day=date('j', strtotime($date));
       
        //$report_items= json_decode($this->getReportItems($user_id));
        $report_item_status=$this->checkReportItemStatus($user_id, $year, $month, $day);
        
        //foreach($report_items as $item1){
            //if($item1->year===$year && $item1->month===$month && $item1->day===$day){
                //$current_status=$report_item_status;
             if($report_item_status){   
                switch($report_item_status){
                    case '1':
                        $background_class='pay_period_td_background_green';
                    break;
                    case '2':
                        $background_class='pay_period_td_background_yellow';
                    break;
                    case '3':
                        $background_class='pay_period_td_background_red';
                    break;
                    case '4':
                        $background_class='pay_period_td_background_blue';
                    break;
                    case '6':
                        $background_class='pay_period_td_background_gray';
                    break;
                    default:
                        $background_class='';
                    break;
                
                }
            } else{
                $background_class='';
            }
        //}
        
        return $background_class;
    }
    
   /* public function getReportItems($user_id)
    {
        $query='SELECT * FROM #__user_report_items WHERE `id_user`="'.$user_id.'" ORDER by id ASC';
        $this->db->setQuery( $query );
        $items = $this->db->loadObjectList(); 
        return json_encode($items);
    }*/
    
    public function checkReportItemStatus($user_id, $date_year, $date_month, $date_day)
    {
        $query='SELECT * FROM #__user_report_items WHERE `id_user`="'.$user_id.'"  AND `year`="'.$date_year.'" AND `month`="'.$date_month.'" AND `day`="'.$date_day.'"';
        $this->db->setQuery($query);
        $user_report = $this->db->loadObject();
        return $user_report->status;
    }
    
    public function calcColoredDays($user_id, $status, $from, $to)
    {
       // $from='01.03.2018';
       // $to='31.03.2018';
        
        $current_month=date('n', strtotime($from));
        $year=date('Y', strtotime($from));
        
        //$query='SELECT COUNT(id) as count_items FROM #__user_report_items WHERE `id_user`="'.$user_id.'" AND `month`="'.$current_month.'" AND `status`="'.$status.'" AND `year`="'.$year.'"';
        $query='SELECT `day`, `month`, `year` FROM #__user_report_items WHERE `id_user`="'.$user_id.'" AND `month`="'.$current_month.'" AND `status`="'.$status.'" AND `year`="'.$year.'"';
        $this->db->setQuery( $query );
        $all_days_current_month = $this->db->loadObjectList(); 
        
        $prepare_array=[];
        $i=0;
        $count_day_for_audit_time=0;
        
        foreach($all_days_current_month as $k=>$v){      
            $day=$v->day;
            $month=$v->month;
            $year=$v->year;
            
            $prepare_array[$i]['color']=$status;
            $prepare_array[$i]['date']=DateTime::createFromFormat('Y.n.j', $year.'.'.$month.'.'.$day)->format('Y-m-d');
            $query='SELECT COUNT(id) as count_items FROM #__audit_time WHERE `id_user`="'.$user_id.'" AND `date`="'.$prepare_array[$i]['date'].'"';
            $this->db->setQuery( $query );
            $count_items= $this->db->loadObject()->count_items; 
            
            if($count_items>0){
                $prepare_array[$i]['count']=$count_items;
                $count_day_for_audit_time=$prepare_array[$i]['count']; //count number of days if exist day in table audit_time          
            } else{
               $count_day_for_audit_time++;//increment the number of days if the table audit_time does not have a time stamp
            }
     
            $i++;      
        }
  
       // return $shedule_items->count_items;   
        /*echo '<pre>';
        echo 'from-'.$from;
        echo ' to-'.$to.'<br/>';
        //echo 'error-'.$error;
        print_r($prepare_array);
        echo '</pre>';*/
        
        
        return $count_day_for_audit_time;
    }
    
    
    
    public function calcColoredDaysCustomFromTo($user_id, $status, $from, $to)
    {
       // $from='01.05.2018';
       // $to='31.05.2018';
        
        //echo $from.' - '.$to.'<br/>';
        
        $date_from= DateTime::createFromFormat('d.m.Y', $from);
        $current_month=$date_from->format('n');
        $current_year=$date_from->format('Y');
        
        $date_to= DateTime::createFromFormat('d.m.Y', $to);
        $month_to=$date_to->format('n');
        $year_to=$date_to->format('Y');
        
        //make dates array
        $begin = new DateTime( $date_from->format('Y-m-d') );
        $end = new DateTime( $date_to->format('Y-m-d') );
        $end = $end->modify( '+1 day' ); 
        $interval = new DateInterval('P1D');
        $daterange = new DatePeriod($begin, $interval ,$end);

        $query='SELECT * FROM #__user_report_items WHERE `id_user`="'.$user_id.'" AND (';
        
        foreach($daterange as $date){     
            $query.='`month`="'.$date->format('n').'" AND `status`="'.$status.'" AND `year`="'.$date->format('Y').'" AND `day`="'.$date->format('j').'" OR ';
        }
        $query = chop($query, ' OR');
   
        //$query='SELECT `day`, `month`, `year` FROM #__user_report_items WHERE `id_user`="'.$user_id.'" AND `month`>="'.$current_month.'" AND `status`="'.$status.'" AND `year`>="'.$year.'" AND `month`<="'.$month_to.'" AND `year`<="'.$year_to.'"';
        //$query='SELECT `day`, `month`, `year` FROM #__user_report_items WHERE `id_user`="'.$user_id.'" AND `month`="'.$current_month.'" AND `status`="'.$status.'" AND `year`="'.$year.'"';
        $query.=')';
        //echo '<br/>'.$query.'<br/>';
       
        $this->db->setQuery( $query );
        $all_days_current_month = $this->db->loadObjectList(); 
        
        /*echo '<pre>';
        print_r( $all_days_current_month);
        echo '</pre>';*/
        
        $prepare_array=[];
        $i=0;
        $count_day_for_audit_time=0;
       
        foreach($all_days_current_month as $k=>$v){      
            $day=$v->day;
            $month=$v->month;
            $year=$v->year;
            
            $prepare_array[$i]['color']=$status;
            $prepare_array[$i]['date']=DateTime::createFromFormat('Y.n.j', $year.'.'.$month.'.'.$day)->format('Y-m-d');
            //$query='SELECT COUNT(id) as count_items FROM #__audit_time WHERE `id_user`="'.$user_id.'" AND `date`="'.$prepare_array[$i]['date'].'"';
            $query='SELECT * FROM #__audit_time WHERE `id_user`="'.$user_id.'" AND `date`="'.$prepare_array[$i]['date'].'"';
            $this->db->setQuery( $query );
            $count_items_array= $this->db->loadObjectList(); 
            
            if(count($count_items_array)>1){//if there are more than one login for one date
                foreach($count_items_array as $one_item){                  
                    $count_day_for_audit_time++;
                
                    /*if(count($count_items_array)>0){
                        $prepare_array[$i]['count']=count($count_items_array);
                        $count_day_for_audit_time=$prepare_array[$i]['count']; //count number of days if exist day in table audit_time          
                    } else{
                        $count_day_for_audit_time++;//increment the number of days if the table audit_time does not have a time stamp
                    }*/
                }           
            } else{
                $count_day_for_audit_time++;
            }                    
            $i++;                
        }
         
        return $count_day_for_audit_time;
    }
    
    public function getAskGps($user_id)
    {
        $date=date('Y-m-d');
        
        $query = "SELECT `asked_gps` FROM #__audit_time WHERE `id_user` = '$user_id' AND `date` = '$date'";
        $this->db->setQuery($query);
        //get current gps status
        $res = $this->db->loadResult();
        return (string)$res;
    }
    
    public function setCoordinates($lat, $lng, $user_id, $note)
    {
        $lat=(float)$lat;
        $lng=(float)$lng;
        $current_date=date('Y-m-d');
        
        $query = "SELECT `id` FROM #__audit_time WHERE `id_user` = '$user_id' AND `date`='".$current_date."' ORDER BY `id` DESC LIMIT 0, 1";
        $this->db->setQuery($query);
        $res = $this->db->loadObject();
        $last_db_id=$res->id;
        
        $query = "UPDATE #__audit_time SET `lat`='$lat', `lng`='$lng', `asked_gps`='0', `note`='$note' WHERE `id`='".$last_db_id."'";       
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function saveNoteHome($user_id, $note)
    {
        $current_date=date('Y-m-d');
        
        $query = "SELECT `id` FROM #__audit_time WHERE `id_user` = '$user_id' AND `date`='".$current_date."' ORDER BY `id` DESC LIMIT 0, 1";
        $this->db->setQuery($query);
        $res = $this->db->loadObject();
        $last_db_id=$res->id;
        
        $query = "UPDATE #__audit_time SET `note`='$note' WHERE `id`='".$last_db_id."'";       
        $this->db->setQuery($query);
        return $this->db->query();
    }
    
    public function getLatLng($date, $user_id)
    {
        $user_id=(int)$user_id;
        //$user_joomla = JFactory::getUser($user_id);
        $query="SELECT `lat`, `lng` FROM #__audit_time WHERE `date_logged`='$date' AND `id_user`='$user_id'";
        $this->db->setQuery($query);
        $res = $this->db->loadObjectList();
        
        return json_encode($res);
    }
    
    public function getLatLng2($date_start, $date_end, $user_id)
    {
        $user_id=(int)$user_id;
        //$user_joomla = JFactory::getUser($user_id);
        $query="SELECT `date_logged`, `lat`, `lng`, `lat_end`, `lng_end` FROM #__audit_time WHERE `date_logged`>='$date_start' AND `date_logged`<='$date_end' AND `id_user`='$user_id'";
        $this->db->setQuery($query);
        $res = $this->db->loadObjectList();
        
        return json_encode($res);
    }
    
    public function getLatLngEnd($date, $user_id)
    {
        $user_id=(int)$user_id;
        //$user_joomla = JFactory::getUser($user_id);
        $query="SELECT `lat_end`, `lng_end` FROM #__audit_time WHERE `date_logged`='$date' AND `id_user`='$user_id'";
        $this->db->setQuery($query);
        $res = $this->db->loadObjectList();
        
        return json_encode($res);
    }
    
    public function saveInputPayPeriod($user_id, $from, $to, $owner_id)
    {
        //here
        $query="SELECT `id` FROM #__users WHERE `owner_id`='$owner_id'";
        $this->db->setQuery($query);
        $array_manager_users = $this->db->loadObjectList();
        
        foreach ($array_manager_users as $one_user) {
            $query = "SELECT `id` FROM #__pay_period_preserved WHERE `id_user` = '$one_user->id'";
            $this->db->setQuery($query);
            //get current gps status
            $res = $this->db->loadResult();

            if (is_null($res)) {
                //insert into
                $item = new stdClass();
                $item->id_user = $one_user->id;
                $item->from_date = $from;
                $item->to_date = $to;
                $this->db->insertObject('#__pay_period_preserved', $item);
                $res = 'insert';
            } else {
                //update table
                $item = new stdClass();
                $item->id_user = $one_user->id;
                $item->from_date = $from;
                $item->to_date = $to;
                $this->db->updateObject('#__pay_period_preserved', $item, 'id_user');

                $res = 'update';
            }
        }





        return $res;
    }
    
    public function saveInputPayPeriodNewUser($user_id)
    {
        $user= JFactory::getUser($user_id);
        $owner_id=$user->owner_id;
        
        $query = "SELECT `from_date`, `to_date` FROM #__pay_period_preserved WHERE `id_user` = '$owner_id'";
        $this->db->setQuery($query);
        //get current gps status
        $res = $this->db->loadObjectList();

        if (!empty($res)) {
            $from_date=$res[0]->from_date;
            $to_date=$res[0]->to_date;
        } else {
            $from_date='25.'.date('m.Y', strtotime('-1 month'));
            $to_date='24.'.date('m.Y', strtotime('+0 month'));  
        }
        $item = new stdClass();
        $item->id_user = $user_id;
        $item->from_date = $from_date;
        $item->to_date = $to_date;
        $this->db->insertObject('#__pay_period_preserved', $item);




        echo '<pre>';
        print_r($res);
        echo '</pre>';
    }
    
    public function getInputsPayPeriod($u_id)
    {
        $u_id=(int)$u_id;
        $query = "SELECT * FROM #__pay_period_preserved WHERE `id_user` = '$u_id'";
        $this->db->setQuery($query);
        //get current gps status
        $res = $this->db->loadObject();
        
        if(empty($res)){
            $from_date='25.'.date('m.Y', strtotime('-1 month'));
            $to_date='24.'.date('m.Y', strtotime('+0 month')); 
            
            $res['id_user']=$u_id;
            $res['from_date']=$from_date;
            $res['to_date']=$to_date;
            $res=(object)$res;
        }
        return json_encode($res);
    }
    
    public function totalAskedGps($user_id)
    {
        $current_date=date('Y-m-d');
        $query = "SELECT `asked_gps` FROM #__audit_time WHERE `id_user` = '$user_id' AND `date`='".$current_date."' ORDER BY `id` DESC LIMIT 0, 1";
        $this->db->setQuery($query);
        //get current gps status
        $res = $this->db->loadObject();
        return $res->asked_gps;
    }
    
    public function newTotal($param){
       $idField = $param['id'];
       $valueField = $param['value']; 
       $yearField = $param['year']; 
       $dateField = $param['date']; 
      
       $dateField = explode('.', $dateField);
       $idField = explode('-', $idField);
       $field = $idField[0];
       $id = $idField[1];
       

       /*if(empty($id) && !empty($valueField)){
            $db = & JFactory::getDBO();
            $user = & JFactory::getUser(); 
            $id_user = $user->id;  

            if($id_user > 0){
                $item = new stdClass;
                $item->id = NULL;
                $item->id_user = $id_user;
                $item->date_logged = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:00';
                $item->date_exit = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:01';
                $item->date = $yearField.'-'.$dateField[1].'-'.$dateField[0];
                $item->new_hours = $valueField;

                if (!$db->insertObject( '#__audit_time', $item, 'id' )) {
                   echo $db->stderr();
                   return false;
                } else{
                   echo $valueField;
                   return true;
                }
            }
       } else{*/
           //here
            $query = "UPDATE #__audit_time SET $field='$valueField' WHERE id = '$id'";
            $db = & JFactory::getDBO();
            $db->setQuery($query);
            if($db->query()){
                echo $valueField;
            }
      // }    
    }
    
    //old sequrity method. 18.07.2018
    /*public function addNewAuditTimeRow($param, $mode, $action)
    {
       $idField = $param['id'];
       
       $valueField = $param['value']; 
       $valueField=trim($valueField);
       $valueField= strip_tags($valueField);
       
       $yearField = $param['year']; 
       $dateField = $param['date']; 
       $id_user=$param['user_id'];
       $id_user=(int)$id_user;
      //return $param;
      
       $dateField = explode('.', $dateField);
       $idField = explode('-', $idField);
       $field = $idField[0];
       $id = $idField[1];
       
        if(!empty($valueField)){
            $db = $this->db;
            $user_joomla = & JFactory::getUser(); 
            $id_user0 = $user_joomla->id;  
            
            //manager
            if(in_array(6, $user_joomla->groups)){
               //get owner id
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$id_user'";     
                $this->db->setQuery($query);
                $owner_id=$this->db->loadResult();
            
                //if user is in current manager
                if($user_joomla->owner_id==$owner_id && $id_user>0){
                    $item = new stdClass;
                    if($action==='update'){
                        $item->id = $id; 
                    } if($action==='insert'){
                       $item->id = NULL; 
                    }
                    
                    $item->id_user = $id_user;
                    $item->date_logged = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:00';
                    $item->date_exit = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:01';
                    //$item->date_logged='';
                    //$item->date_exit='';
                    $item->date = $yearField.'-'.$dateField[1].'-'.$dateField[0];
                    $item->ip=$_SERVER["REMOTE_ADDR"];
                
                    switch($mode){
                        case 'description':
                            $item->note = $valueField;
                        break;
                        case 'daytime':
                            $item->new_daytime = $valueField;
                            $item->daytime_edit='1';
                            $item->daytime_edited_date=date('Y-m-d H:i:s');
                        break;
                        case 'total':
                            $item->new_hours = $valueField;               
                        break;
                    }      
                    if($action=='update'){
                        $res=$this->db->updateObject('#__audit_time', $item, 'id');
                    } if($action=='insert'){
                        $res=$db->insertObject( '#__audit_time', $item, 'id' );
                    }
                   
                
                    if (!$res) {//db error code
                        $code=4; 
                    } else{//success code
                        $code=0;                
                    }
                    
                } else{//if manager wants to add a record, replacing the user id - return permission denied code
                    $code=1;
                }
            }
            
            //user
            if(in_array(2, $user_joomla->groups)){     
                if($id_user==$user_joomla->id){
                    $item = new stdClass;
                    $item->id = NULL;
                    $item->id_user = $id_user;
                    $item->date_logged = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:00';
                    $item->date_exit = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:01';
                    //$item->date_logged='';
                    //$item->date_exit='';
                    $item->date = $yearField.'-'.$dateField[1].'-'.$dateField[0];
                    $item->ip=$_SERVER["REMOTE_ADDR"];
                
                    switch($mode){
                        case 'description':
                            $item->note = $valueField;
                        break;
                        case 'daytime':
                            $item->new_daytime = $valueField;
                            $item->daytime_edit='1';
                            $item->daytime_edited_date=date('Y-m-d H:i:s');
                        break;
                        case 'total':
                            $item->new_hours = $valueField;               
                        break;
                    }              
                    $res=$db->insertObject( '#__audit_time', $item, 'id' );
                
                    if (!$res) {//db error code
                        $code=4; 
                    } else{//success code
                        $code=0;                
                    }
                } else{//if user replace original user id
                    $code=1;
                }                        
            } 

            
       } else{//field is empty
           $code=3;
       }
       
        switch($mode){
            case 'description':
                $result=[
                    'new_note'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid(),
                    'action'=>$action
                ];     
            break;
            case 'daytime':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'total':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
        }
       
        return $result;
        
    }*/
    
    //not sequrity method
    public function addNewAuditTimeRow($param, $mode, $action)
    {
        JLoader::register('AuditController', JPATH_ROOT . '/components/com_audit/controller.php');
        //$model = JModelLegacy::getInstance('Calc', 'AuditModel');
        
        //JModelLegacy::addIncludePath(JPATH_SITE . '/components/com_audit/controller.php');
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/gps.html', print_r($_REQUEST, true), FILE_APPEND | LOCK_EX); 
        //$app = JFactory::getApplication();
                    
       $idField = $param['id'];
       
       $valueField = $param['value']; 
       $valueField=trim($valueField);
       $valueField= strip_tags($valueField);
       
       $yearField = $param['year']; 
       $dateField = $param['date']; 
       $id_user=$param['user_id'];
       $id_user=(int)$id_user;
       
       $num_overwork=(string)$param['num_overwork'];
      
       $dateField = explode('.', $dateField);
       $idField = explode('-', $idField);
       $field = $idField[0];
       $id = $idField[1];
       
        //if(!empty($valueField)){
            $db = $this->db;
            $user_joomla = & JFactory::getUser(); 
            $id_user0 = $user_joomla->id;  
            
            $item = new stdClass;
            if($action==='update'){
                $item->id = $id; 
            } if($action==='insert'){
                $item->id = NULL; 
            }
                   
            $item->id_user = $id_user;
            if( $action!=='update' && $mode!='login_hours' && $mode!='exit_hours'){
                $item->date_logged = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:00';
                $item->date_exit = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:01';
            }
            
            //$item->date_logged='';
            //$item->date_exit='';
            $item->date = $yearField.'-'.$dateField[1].'-'.$dateField[0];
            $item->ip=$_SERVER["REMOTE_ADDR"];
                
            if($mode!='description'){
                //7=>07:00, 07=>07:00, 07:=>07:00, 07:0=>07:00
                $valueField=$this->autocompletion($valueField);
            }
            
            switch($mode){
                case 'login_hours':
                    //date= date from client request plus new H:i
                    if($action!='update'){
                       // $item->date_exit = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 23:59:00';
                    }
                    $newValue = date('Y-m-d', strtotime($item->date)).' '.$valueField;
       
                    $item->date_logged = $newValue;
                    $item->date_logged_edit='1';                   
                break;
                case 'exit_hours':
                    if($action!='update'){
                        $item->date_logged = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:00';
                    }
                    $newValue = date('Y-m-d', strtotime($item->date)).' '.$valueField;
                     
                    $item->date_exit = $newValue;
                    $item->date_exit_edit='1';                   
                break;
                case 'total':
                    $item->new_hours = $valueField;               
                break;
                case 'daytime':
                    $item->new_daytime = $valueField;
                    $item->daytime_edit='1';
                    $item->daytime_edited_date=date('Y-m-d H:i:s');
                break;
                case 'afterwork':
                    $item->new_afterwork = $valueField;
                    $item->afterwork_edit='1';
                    $item->afterwork_edited_date=date('Y-m-d H:i:s');
                break;
                case 'overwork':
                    if(!empty($num_overwork)){
                        switch($num_overwork){
                            case '01': case '11':
                                $obj_name='new_overwork_1';
                                $item->$obj_name = $valueField;
                                
                                $obj_name='overwork_edit_1';
                                $item->$obj_name='1';
                                
                                $obj_name='overwork_edited_date_1';
                                $item->$obj_name=date('Y-m-d H:i:s');
                                unset($obj_name);
                            break;
                            case '12':
                                $obj_name='new_overwork_2';
                                $item->$obj_name = $valueField;
                                
                                $obj_name='overwork_edit_2';
                                $item->$obj_name='1';
                                
                                $obj_name='overwork_edited_date_2';
                                $item->$obj_name=date('Y-m-d H:i:s');
                                unset($obj_name);
                            break;
                        }
                       
                    }
                   
                break;
                case 'night_time':
                    $item->new_night_time = $valueField;
                    $item->night_time_edit='1';
                    $item->night_time_edited_date=date('Y-m-d H:i:s');
                break;
                case 'weekend':
                    //here
                    //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/edit_weekends.html', print_r($valueField, true), FILE_APPEND | LOCK_EX);
                    $item->new_weekend = $valueField;
                    $item->weekend_edit='1';
                    $item->weekend_edited_date=date('Y-m-d H:i:s');
                break;
                case 'holidays':
                    $item->new_holidays = $valueField;
                    $item->holidays_edit='1';
                    $item->holidays_edited_date=date('Y-m-d H:i:s');
                break;
                case 'description':
                    $item->note = $valueField;
                break;
            }
            
            if($action=='update'){
                $res=$this->db->updateObject('#__audit_time', $item, 'id');
            } if($action=='insert'){
                $res=$this->db->insertObject( '#__audit_time', $item, 'id' );
                $insert_id = $this->db->insertid();
            }
           
        //}  
       
        /*echo '<pre>param pay period';
        print_r($param);
        echo '</pre>';*/
        
        $is_enable_confirm_pp = AuditController::getFinalCombineConfirmAndPpStatus($id_user);
        if($is_enable_confirm_pp == '1' && $mode != 'description' && $param['task'] !='SyncPP01'){
            JLoader::register('AuditModelConfirm_time', JPATH_ROOT . '/components/com_audit/models/confirm_time.php');
            $model_confirm = JModelLegacy::getInstance('Confirm_time', 'AuditModel');
            $confirm_id = $this->getConfirmIdByPpId($id);
           //echo '$confirm_id:' . $confirm_id;
            //clone changes to confirm page(sync)
            if(!empty($confirm_id)){
                $param['id'] = $field.'-'.$confirm_id;
                //$param['date'].= '.'.date('Y');
                $param['task'] = 'SyncConfirm01';
                $model_confirm->addNewAuditTimeRow($param, $mode, $action);
            }
        }
        
        $config = JFactory::getConfig();
        $enable_gps_task_changes = $config->get('enable_gps_task_changes');
        //echo $param['task'];
        
        if($enable_gps_task_changes == '1' && $action == 'update' && $param['task'] != 'emulateNewLoginHours' && in_array($mode, ['login_hours', 'exit_hours', 'total'])){
            JLoader::register('AuditModelGps', JPATH_ROOT . '/components/com_audit/models/gps.php');
            $model = JModelLegacy::getInstance('Gps', 'AuditModel');
            
            $res_sync = $model->syncPayPeriodWithRoute($param, $mode, $action, $id, $id_user, 'pay_period');
        }
       
       
       $code = 0;
       
       //need optimized
        switch($mode){
            case 'login_hours':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$insert_id
                ];        
            break;
            case 'exit_hours':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$this->db->insertid()
                ];        
            break;
            case 'total':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$this->db->insertid()
                ];        
            break;
            case 'daytime':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$this->db->insertid()
                ];        
            break;  
            case 'afterwork':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$this->db->insertid()
                ];        
            break;
            case 'night_time':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$this->db->insertid()
                ];        
            break;
            case 'weekend':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$this->db->insertid()
                ];        
            break;
            case 'holidays':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$this->db->insertid()
                ];        
            break;
            case 'description':
                $result=[
                    'new_note'=>$valueField,//
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$this->db->insertid(),
                    'action'=>$action
                ];  
            case 'overwork':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$this->db->insertid()
                ]; 
            break;
           
        }
       
        return $result;
        
    }
    
    public function addOneRowPayPeriod($row_date, $id_user)
    {
        //here
        $item = new stdClass;
        $item->id = NULL; 
        $item->id_user = $id_user;
        if($_SERVER['SERVER_NAME']=='fagverk.curiotime.com'){
            $date_obj=DateTimeWR::createFromFormat('d.m.Y', $row_date);
        } else{
              $date_obj=DateTime::createFromFormat('d.m.Y', $row_date);
        }
        
        $item->date_logged = $date_obj->format('Y-m-d').' 00:00:00';
        //$item->date_exit = $date_obj->format('Y-m-d').' 00:00:01';
        $item->date_exit = '0000-00-00 00:00:00';
        $item->date = $date_obj->format('Y-m-d');
        $item->ip=$_SERVER["REMOTE_ADDR"];
            
        $res=$this->db->insertObject( '#__audit_time', $item, 'id' );      
        $insert_id=$this->db->insertid();
        setcookie('insert_id_pay_period', $insert_id,  time()+3600 * 24 * 365);
    }
    
    private function autocompletion($valueField)
    {
        switch(strlen($valueField)){
            case 0:
                
                break;
            case 1:
                $valueField='0'.$valueField.':00';
                break;
            case 2:
                $valueField0=str_split($valueField, 1);
                
                if($valueField0[0]=='0'){
                   $valueField='0'.$valueField0[1].':00';
                } else{
                    $valueField=$valueField0[0].$valueField0[1].':00';
                }
                break;
            case 3:
                $valueField0=str_split($valueField, 1);
                $valueField=$valueField0[0].$valueField0[1].':00';
                break;
            case 4:
                $valueField0=str_split($valueField, 1);
                $valueField=$valueField0[0].$valueField0[1].':'.$valueField0[3].'0';
                break;
        }
        
        return $valueField;
    }
    
    public function saveNotePayPeriod($id, $note)
    {
        $app = JFactory::getApplication();
        $act = $app->input->getString('act');
        
        //update table
        $id=(int)$id;
        $user_joomla = JFactory::getUser();
        $code=0;
        //admin
        if(in_array(8, $user_joomla->groups)){
            $item = new stdClass();
            $item->id =$id;
            $item->note = $note;
            $this->db->updateObject('#__audit_time', $item, 'id');
        } 
        //manager
        if(in_array(6, $user_joomla->groups) || in_array(10, $user_joomla->groups)){
            //get user id
            $query = "SELECT `id_user` FROM #__audit_time WHERE `id` = '$id'";     
            $this->db->setQuery($query);
            $id_user=$this->db->loadResult();
            
            //get owner id
            $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$id_user'";     
            $this->db->setQuery($query);
            $owner_id=$this->db->loadResult();
            
            //if user is in current manager
            if($user_joomla->owner_id===$owner_id){
                $item = new stdClass();
                $item->id =$id;
                $item->note = $note;
                $this->db->updateObject('#__audit_time', $item, 'id');
            } else{
                $code=1;
            }            
        } 
        //user
        if(in_array(2, $user_joomla->groups)){   
            $query = "SELECT `id_user` FROM #__audit_time WHERE `id` = '$id'";     
            $this->db->setQuery($query);
            $id_user=$this->db->loadResult();
            
            if($id_user===$user_joomla->id){
                $query = "UPDATE #__audit_time SET `note`='$note' WHERE `id`='".$id."' AND `id_user`='$user_joomla->id'";       
                $this->db->setQuery($query);
                $this->db->query();
            } else{
                $code=2;
            }                        
        } 
         
        $is_enable_confirm_pp = AuditController::getFinalCombineConfirmAndPpStatus($id_user);
        if($is_enable_confirm_pp == '1' && $act !== 'syncPPNote'){
            JLoader::register('AuditModelConfirm_time', JPATH_ROOT . '/components/com_audit/models/confirm_time.php');
            $model_confirm = JModelLegacy::getInstance('Confirm_time', 'AuditModel');
            $confirm_id = $this->getConfirmIdByPpId($id);
           
            //clone changes to confirm page(sync)
            if(!empty($confirm_id)){ 
                $_REQUEST['act'] = 'syncNoteConfirm0';
                $model_confirm->saveNotePayPeriod($confirm_id, $note);
            }
        }
        
        $result=[
            'new_note'=>$note,
            'code'=>(string)$code,
            'id_user'=>$id_user,
            'owner_id'=>$owner_id
            //'user_joomla'=>$user_joomla
        ];
        return $result;
    }
    
    public function convertStringToDateObject($string)
    {
        $test_t2_array=explode(':', $string);
        $test_t2_h=$test_t2_array[0];
        $test_t2_m=$test_t2_array[1];
        
        $res=date("H:i", strtotime($test_t2_h.":".$test_t2_m.":00"));
        return $res;
    }
    
    public function deleteRowId($row_id)
    {
        $app = JFactory::getApplication();
        $act = $app->input->getString('act');
        
        $query = "SELECT `id_user`, `id` FROM `#__audit_time` WHERE `id` = '$row_id';";
        $this->db->setQuery($query);
        $item = $this->db->loadObject();
        
        $query = "DELETE FROM `#__audit_time` WHERE `id` = '".$item->id."';";
        //echo $query;
        $this->db->setQuery($query);
        $this->db->query();
        
        $confirm_id = 0;
        $is_enable_confirm_pp = AuditController::getFinalCombineConfirmAndPpStatus($item->id_user);
        if($is_enable_confirm_pp == '1' && $act != 'syncDelPpRow'){
            $confirm_id = $this->getConfirmIdByPpId($item->id);
            
            if(!empty($confirm_id)){
                $query = "DELETE FROM `#__audit_time_confirm` WHERE `id` = '$confirm_id';";
                $this->db->setQuery($query);
                $this->db->query();
            }
        }
        $config = JFactory::getConfig();
        $enable_gps_task_changes = $config->get('enable_gps_task_changes');

        if ($enable_gps_task_changes == '1') {
            $model = JModelLegacy::getInstance('Gps', 'AuditModel');
            $model->deleteRouteByPp($row_id, $confirm_id, $item->id_user);
        }
    }
    
    public function getPDFdiapason($from_date, $to_date, $lang)
    {
        $final_array=[];
        $months_array=[
            "January"=>"janúar",
            "February"=>"febrúar",
            "March"=>"mars",
            "April"=>"apríl",
            "May"=>"maí",
            "June"=>"júní",
            "July"=>"júlí",
            "August"=>"ágúst",
            "September"=>"September",
            "October"=>"október",
            "November"=>"nóvember",
            "December"=>"desember"
        ];
        $from_date_obj= DateTime::createFromFormat('d.m.Y', $from_date);
        $to_date_obj= DateTime::createFromFormat('d.m.Y', $to_date);
        $current_date_obj=DateTime::createFromFormat('d.m.Y', date('d.m.Y'));
        $current_month=$current_date_obj->format('m'); 
        $i=0;

        function foo($n) {
            /*  Month number outside the range [1 .. 12]
                * Fits in the appropriate number in this range
                *
                * ___][_______][_______][_______][___
                * -12  -11   0  1    12  13   24  25
                *            <  >
                * -inf .. 0      1 .. +inf
                * >>> % 12       >>> - 1
                * -11 .. 0       0 .. +inf
                * >>> + 12       >>> % 12
                * 1 .. 12        0 .. 11
                *                >>> + 1
                *                1 .. 12
            */
            return ($n <= 0) ? $n % 12 + 12 : ($n - 1) % 12 + 1;
        }

        function bar($count) {
            //last month's number
            $last = gmdate('n') ;

            //the first month number from $ count of previous
            $first = $last - $count + 1;

            /*
             * numbers from the first to the previous
              *converted into natural numbers of months
            */
            return array_map("foo", range($first, $last));
        }
        
        $preview_months_array=bar(12);
           
        foreach($preview_months_array as $preview_month){ 
            if($preview_months_array[$i]>$current_month){
              $final_array[$i]['year']=date('Y', strtotime('last Year'));  
              //echo $preview_months_array[$i-1];
            } else{
               //echo $preview_months_array[$i-1];
               $final_array[$i]['year']=date('Y');
            }
            
            $to_year = ($preview_months_array[$i] == 12 && $from_date_obj->format('d')>'01') ? $final_array[$i]['year']+1 : $final_array[$i]['year'];
            $to_month = ($from_date_obj->format('d')>'01') ? $preview_months_array[$i+1] : $preview_months_array[$i];
            $to_day = ($from_date_obj->format('d')=='01') ? date('t', strtotime($from_date_obj->format('d').'.'.$to_month.'.'.$to_year)) : $to_date_obj->format('d');
              
            $preview_month_obj=DateTime::createFromFormat('d.n.Y', date('01.'.$preview_month.'.Y'));   
            $final_array[$i]['from']=date('d.m.Y', strtotime($from_date_obj->format('d').'.'.$preview_months_array[$i].'.'.$final_array[$i]['year']));
            $final_array[$i]['to']=date('d.m.Y', strtotime($to_day.'.'.$to_month.'.'.$to_year));
            
            if($lang == 'is'){
                $final_array[$i]['name'] = $months_array[$preview_month_obj->format('F')];
            } else{
                $final_array[$i]['name']=$preview_month_obj->format('F');
            }
            
            

           $i++;
        } 
        arsort($final_array);
        
        return json_encode([
            'from'=>$from_date,
            'to'=>$to_date,          
            'preview_months_array'=>$preview_months_array,
            'final_array'=>$final_array
        ]);
    }
    
    public function checkBreakItem($break_raw) {
        $arr=explode('+', $break_raw);
        if(count($arr)===1){
            return '0';
        } elseif(count($arr)>1){
            return '1';
        }
    }
    
    public function normalizeBreak($break_raw) {
        if(!empty($break_raw)){
            $arr=explode('+', $break_raw);
            $daytime_break_time = !empty($arr[1]) ? new DateTime($arr[1]) : new DateTime('00:00');
        }
            
        return $daytime_break_time;
    }
    
    public function preparePayPeriodOfHtml($html, $user_id) {
        /*ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);*/

        include_once($_SERVER['DOCUMENT_ROOT'].'/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
        $dom = str_get_html($html);
        $q1  = $dom->find('table[class="pdf_not_width"]');
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/api_pp4_html_fix.html', print_r($dom, true), FILE_APPEND | LOCK_EX);
        
        $totalsJson  =  array();
        if(preg_match("#<!--json-dk-totals--(.*)--json-dk-totals-->#", $html, $arr)) {
            $totalsJson  = json_decode($arr[1],true);
        }
        
        JLoader::register('AuditModelTime_Wages', JPATH_ROOT . '/components/com_audit/models/time_wages.php');
        $model_settings = JModelLegacy::getInstance('Time_Wages', 'AuditModel');
        $user= & JFactory::getUser($user_id);
        $sick_child_state=$model_settings->getSickChildStateAndConfig($user->owner_id);
        $sick_state=$model_settings->getSickState($user->owner_id);
        $config = JFactory::getConfig();
        $enablelimit_for_total_hours_in_all_fields = $config->get('enablelimit_for_total_hours_in_all_fields');
        
        //$result['additional_info']['month_name'] = '';
        //$result['additional_info']['year'] = '';
          
        $result=[];
        foreach($q1 as $table){
            $dates=$table->find('*[class="api_date"]');
            $totals=$table->find('*[class="api_custom_td_1"]');
            $rows_id=$table->find('*[id="hidden_row_id"]');
           
            /*$i_years = 0;
            foreach($table->find('*[class="user_item_year"]') as $year){
                if($i_years != 0){
                    continue;
                }
                $result['additional_info']['year'] = trim($year->value);
               
                
                $i_years++;
            }
            
            $i_months = 0;
            foreach($table->find('*[class="user_item_year"]') as $year){
                if($i_months != 0){
                    continue;
                }
               // $result['additional_info']['year'] = trim($year->value);
               
                
                $i_months++;
            }*/
            
            $i=0;
            foreach($dates as $date){
                //$result[]=htmlspecialchars($date);
                $result[$i]['date']=$date->plaintext;
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/api_pp4_html_fix.html', print_r($result[$i]['date'], true), FILE_APPEND | LOCK_EX);
                
                $result[$i]['total']=trim(strip_tags($totals[$i]));
                //check cell edited or set color
                $total_edited=strripos($totals[$i], 'red-line');
                
                //check colors
                $total_color_red=strripos($totals[$i], 'pay_period_td_background_red');
                $total_color_yellow=strripos($totals[$i], 'pay_period_td_background_yellow');
                $total_color_green=strripos($totals[$i], 'pay_period_td_background_green');
                $total_color_blue=strripos($totals[$i], 'pay_period_td_background_blue');
                $total_color_gray=strripos($totals[$i], 'pay_period_td_background_gray');
                
                //set cell edited
                if($total_edited==true){
                    $result[$i]['total_edited']=1;
                } 
                
                //set colors
                if($total_color_red==true){
                    $result[$i]['total_color']='red';
                } 
                if($total_color_yellow==true){
                    $result[$i]['total_color']='yellow';
                }
                if($total_color_green==true){
                    $result[$i]['total_color']='green';
                }
                if($total_color_blue==true){
                    $result[$i]['total_color']='blue';
                }
                if($total_color_gray==true){
                    $result[$i]['total_color']='gray';
                }
                
                if(!empty($rows_id[$i])){
                    $result[$i]['row_id']=trim($rows_id[$i]->getAttribute('value'));
                } else{
                    $result[$i]['row_id']='';
                    //continue;
                }
                
                $i++;
            }
            
            
           
        }
        //gg2
        $count=count($result);
        
        foreach($dom->find('*[class="total-h"]') as $ee){
           $result['global_totals']['total']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-daytime"]') as $ee){
           $result['global_totals']['daytime']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-afterwork"]') as $ee){
           $result['global_totals']['afterwork']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-night_time"]') as $ee){
           $result['global_totals']['night_time']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-weekend"]') as $ee){
           $result['global_totals']['weekend']= trim($ee->plaintext);
        }
        if($enablelimit_for_total_hours_in_all_fields == '1'){
            foreach($dom->find('*[class="t-overtime"]') as $ee){
                $result['global_totals']['overtime'] = trim($ee->plaintext);
            }
        }
        foreach($dom->find('*[class="t-holidays90"]') as $ee){
           $result['global_totals']['holidays_90']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-holidays45"]') as $ee){
           $result['global_totals']['holidays_45']= trim($ee->plaintext);
        }
        if($sick_state=='1'){
            foreach($dom->find('*[class="t-holidays_sick"]') as $ee){
                $result['global_totals']['sick']= trim($ee->plaintext);
            }
        }
        if($sick_child_state=='1'){
            foreach($dom->find('*[class="t-sick_child"]') as $ee){
                $result['global_totals']['sick_child']= trim($ee->plaintext);
            }
        }
        foreach($dom->find('*[class="t-breaks"]') as $ee){
           $result['global_totals']['break']= trim($ee->plaintext);
        }
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/api_new_breaks.html', print_r($result['global_totals'], true), FILE_APPEND | LOCK_EX);
       
        if(isset($totalsJson['daytime'])) $result['global_totals']['daytime']  = $totalsJson['daytime']['total'];
        if(isset($totalsJson['after_hours'])) $result['global_totals']['afterwork']  = $totalsJson['after_hours']['total'];
        if(isset($totalsJson['night'])) $result['global_totals']['night_time']  = $totalsJson['night']['total'];
        if(isset($totalsJson['weekends'])) $result['global_totals']['weekend']  = $totalsJson['weekends']['total'];
        if(isset($totalsJson['holidays_90'])) $result['global_totals']['holidays_90']  = $totalsJson['holidays_90']['total'];
        if(isset($totalsJson['holidays_45'])) $result['global_totals']['holidays_45']  = $totalsJson['holidays_45']['total'];
        if($sick_state=='1'){
            if(isset($totalsJson['sick'])) $result['global_totals']['sick']  = $totalsJson['sick']['total'];
        }
        if($sick_child_state=='1'){
            if(isset($totalsJson['sick_child'])) $result['global_totals']['sick_child']  = $totalsJson['sick_child']['total'];
        }
        //$result['raw'] = $totalsJson;
        return $result;
    }

    public function prepareOneDateOfHtml($html, $user_id, $row_id) {
        include_once($_SERVER['DOCUMENT_ROOT'].'/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
        $dom = str_get_html($html);
        $q1  = $dom->find('table[class="pdf_not_width"]');
        
        $user= & JFactory::getUser($user_id);
        if(in_array(9, $user->groups)){
            $lock_fields=1;
        }
        
        $result=[];
        foreach($q1 as $table){
            $dates=$table->find('*[class="api_date"]');
            $totals=$table->find('*[class="api_custom_td_1"]');
            
            $time_start=$table->find('*[class="date_login"]');
            $time_end=$table->find('*[class="date_logout"]');
            $daytime=$table->find('*[class="api_daytime"]');
            $afterwork=$table->find('*[class="api_afterwork"]');
            $night=$table->find('*[class="api_night"]');
            $weekends=$table->find('*[class="api_weekends"]');
            $holidays=$table->find('*[class="api_holidays"]');
            $note = $table->find('div[id="new_descr-'.$row_id.'"]', 0);
             
            $i=0;
            foreach($dates as $date){
                //$result[]=htmlspecialchars($date);
                $result[$i]['date']=$date->plaintext;
                
                $result[$i]['total']=trim(strip_tags($totals[$i]));
                
                 //check colors
                $total_color_red=strripos($totals[$i], 'pay_period_td_background_red');
                $total_color_yellow=strripos($totals[$i], 'pay_period_td_background_yellow');
                $total_color_green=strripos($totals[$i], 'pay_period_td_background_green');
                $total_color_blue=strripos($totals[$i], 'pay_period_td_background_blue');
                $total_color_gray=strripos($totals[$i], 'pay_period_td_background_gray');
                
                //check cell edited or set color
                $total_edited=strripos($totals[$i], 'red-line');
                //set cell edited
                if($total_edited==true){
                    $result[$i]['total_edited']=1;
                } 
                
                //set colors
                if($total_color_red==true){
                    $result[$i]['total_color']='red';
                } 
                if($total_color_yellow==true){
                    $result[$i]['total_color']='yellow';
                }
                if($total_color_green==true){
                    $result[$i]['total_color']='green';
                }
                if($total_color_blue==true){
                    $result[$i]['total_color']='blue';
                }
                if($total_color_gray==true){
                    $result[$i]['total_color']='gray';
                }
                
                $result[$i]['in']=trim(strip_tags($time_start[$i]));
                $result[$i]['out']=trim(strip_tags($time_end[$i]));
                $weekends_row=trim(strip_tags($weekends[$i]));
                $holidays_row=trim(strip_tags($holidays[$i]));
                
                //for fix this bug http://prntscr.com/pdwba1- bug fixed
                //if(empty($weekends_row) && empty($holidays_row)){
                    $result[$i]['daytime']=trim(strip_tags($daytime[$i]));
                
                    $daytime_edited_class=strripos($daytime[$i], 'red-line');
                    if($daytime_edited_class==true){
                        $result[$i]['daytime_edited']=1;
                    }
                
                    $result[$i]['afterwork']=trim(strip_tags($afterwork[$i]));
                    $afterwork_edited_class=strripos($afterwork[$i], 'red-line');
                    if($afterwork_edited_class==true){
                        $result[$i]['afterwork_edited']=1;
                    }
                
                    $result[$i]['night_time']=trim(strip_tags($night[$i]));
                    $night_edited_class=strripos($night[$i], 'red-line');
                    if($night_edited_class==true){
                        $result[$i]['night_edited']=1;
                    }
                //}
                
                $result[$i]['weekends']=$weekends_row;
                $weekend_edited_class=strripos($weekends[$i], 'red-line');
                if($weekend_edited_class==true){
                    $result[$i]['weekend_edited']=1;
                }
                
                $result[$i]['holidays']=$holidays_row;
                $holidays_edited_class=strripos($holidays[$i], 'red-line');
                if($holidays_edited_class==true){
                    $result[$i]['holidays_edited']=1;
                }
                
                $result[$i]['message'] = $note->plaintext;
                $result[$i]['lock_fields']=$lock_fields;
                
                $i++;
            }
            
            
           
        }
        //$count=count($result);
        
        foreach($dom->find('*[class="total-h"]') as $ee){
           $result['global_totals']['total']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-daytime"]') as $ee){
           $result['global_totals']['daytime']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-afterwork"]') as $ee){
           $result['global_totals']['afterwork']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-night_time"]') as $ee){
           $result['global_totals']['night_time']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-weekend"]') as $ee){
           $result['global_totals']['weekend']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-holidays90"]') as $ee){
           $result['global_totals']['holidays_90']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-holidays45"]') as $ee){
           $result['global_totals']['holidays_45']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-holidays_sick"]') as $ee){
           $result['global_totals']['sick']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-breaks"]') as $ee){
           $result['global_totals']['break']= trim($ee->plaintext);
        }
        return $result;
    }
    
    private function checkWeekend($date) { 
        return (date('N', strtotime($date)) >= 6);
    }
    
    private function checkHoliday($date) {
        $query_h = "SELECT title,  CONCAT_WS(' ', date, start_time) start, CONCAT_WS(' ', date2, end_time) stop
                    FROM #__holiday WHERE date = '$date' AND published = '1' AND language = 'all'";
        $this->db->setQuery($query_h);
        $holiday_h = $this->db->loadObjectList();
        
        return count($holiday_h)>0;
    }
    
    //for app api only
    public function setOneDatePP4_2($date, $id, $post, $id_user, $client_ip) {        
        // convert date
        $dateArr    =   explode(".", $date);
        $date_raw = $date;
        $date       =   $dateArr[2]."-".$dateArr[1]."-".$dateArr[0];
        $time       =   strtotime($date);
        $date       =   date("Y-m-d",$time);
        
        $id  = intval($id);
        //repeat:
        $query= 'SELECT * FROM #__audit_time WHERE `id` = "'.$id.'"';
        $this->db->setQuery($query);
        $item = $this->db->loadObject();
        
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/fix_weekend_loock.html', print_r($item, true), FILE_APPEND | LOCK_EX);
       
        if($id > 0 && empty($item)) {
            //echo 'dd';
            throw new Exception("Record Audit Time [{$id}] not found.");
           
        }
        if(empty($item)) {
            $item =  new stdClass();
            $item->date  =  $date;
            $item->id_user  =   $id_user;
            $item->date_logged  =   date("Y-m-d 00:00:00",$time);
            $item->date_exit    =   date("Y-m-d 00:00:01",$time);
            $item->ip           =   $client_ip;
        } 
        
        $result_check_weekend = $this->checkWeekend($item->date);
        $result_check_holidays = $this->checkHoliday($item->date);
        
        
       
        
        if(is_array($post)) {
            $is_enable_confirm_pp = self::getFinalCombineConfirmAndPpStatus($id_user);
            JLoader::register('AuditModelConfirm_time', JPATH_ROOT . '/components/com_audit/models/confirm_time.php');
            $model_confirm = JModelLegacy::getInstance('Confirm_time', 'AuditModel');
            
            if($is_enable_confirm_pp == '1'){
                $res_confirm = [];
            }
        
            if($id > 0) {
                $action  =  "update"; 
            } else {
                $action  =  "insert";
            } 
            $confirm_id = $this->getConfirmIdByPpId($id);
            
            foreach ($post as $k=>$v) {
                if($k   !=  'message')  {
                    $v =   $this->autocompletion($v);
                }
                $valueField  = $v;
                
                //repeat:
                if($is_enable_confirm_pp == '1' ){
                    //get confirm row id
                    
         
                    //clone changes to confirm page(sync)
                    if(!empty($confirm_id)){
                       
                        $param['id'] = $k.'-'.$confirm_id;
                        
                        
                        $param['year'] = $dateArr[2];
                        
                        $param['date'] = $date_raw;
                        $param['task'] = 'SyncConfirm01';
                        $param['user_id'] = $id_user;
                        $param['value'] = $valueField;
                        
                        if($k == 'message'){
                            $final_key = 'description';
                        } else{
                            $final_key = $k;
                        }
                        $res_confirm[] = $model_confirm->addNewAuditTimeRow($param, $final_key, $action);
                    } 
                } 
        
                switch($k){
                    case 'login_hours':
                        $newValue = date('Y-m-d', strtotime($item->date)).' '.$valueField;
                        $item->date_logged = $newValue;
                        $item->date_logged_edit='1';                   
                    break;
                    case 'exit_hours':
                        //if($id <=0 ){
                            //$item->date_logged = date("Y-m-d 00:00:00", $time);
                      //  }
                        $newValue = date('Y-m-d', strtotime($item->date)).' '.$valueField;
                        $item->date_exit = $newValue;
                        $item->date_exit_edit='1';                   
                    break;
                    //
                    case 'total':
                        $item->new_hours = $valueField;               
                    break;
                    case 'daytime':
                        if($result_check_weekend!=1 && $result_check_holidays!=1){
                            $item->new_daytime = $valueField;
                            $item->daytime_edit='1';
                            $item->daytime_edited_date=date('Y-m-d H:i:s');
                        }
                    break;
                    case 'afterwork':
                        if($result_check_weekend!=1 && $result_check_holidays!=1){
                            $item->new_afterwork = $valueField;
                            $item->afterwork_edit='1';
                            $item->afterwork_edited_date=date('Y-m-d H:i:s');
                        }
                    break;
                    case 'night_time':
                        if($result_check_weekend!=1 && $result_check_holidays!=1){
                            $item->new_night_time = $valueField;
                            $item->night_time_edit='1';
                            $item->night_time_edited_date=date('Y-m-d H:i:s');
                        }
                    break;
                    case 'weekend':
                        if($result_check_weekend==1){
                            $item->new_weekend = $valueField;
                            $item->weekend_edit='1';
                            $item->weekend_edited_date=date('Y-m-d H:i:s');
                        }
                    break;
                    case 'holidays':
                        if($result_check_holidays==1){
                            $item->new_holidays = $valueField;
                            $item->holidays_edit='1';
                            $item->holidays_edited_date=date('Y-m-d H:i:s');
                        } 
                    break;
                    case 'message':
                        $item->note = $this->db->escape(trim(strip_tags($valueField)));
                    break;
                }
            }
        }
        
        if($id > 0) {
           // $action  =  "update";
            $res    =   $this->db->updateObject('#__audit_time', $item, 'id');
            
            $config = JFactory::getConfig();
            $enable_gps_task_changes = $config->get('enable_gps_task_changes');
            if($enable_gps_task_changes == '1'){
                JLoader::register('AuditModelGps', JPATH_ROOT . '/components/com_audit/models/gps.php');
                $model_gps = JModelLegacy::getInstance('Gps', 'AuditModel');
            
                foreach($post as $k => $v){
                    if(in_array($k, ['total', 'login_hours', 'exit_hours'])){
                        $res_sync[$k] = $model_gps->syncPayPeriodWithRoute(['value' => $v], $k, 'update', $id, $id_user, 'pay_period');
                    }
                    
                }
            }
          
            
           // $res_sync = $model->syncPayPeriodWithRoute($param, $mode, $action, $id, $id_user, 'pay_period');
        } else {//hh4
            //$action  =  "insert";
            $res    =   $this->db->insertObject( '#__audit_time', $item, 'id' );
            $id     =   $this->db->insertid();
            
            if($is_enable_confirm_pp == '1'){
                $res_confirm = $this->updateConfirmRowsForApi($post, $id, $action, $is_enable_confirm_pp, $client_ip, $id_user, $date);
            }
            
        }  

        $code   =   0;
        
        return array    (
            'code'=>(string)$code,
            'local_user_id'=> intval($id_user),
            'action'=>$action,
            'last_id'=>$id,
            'post'=>$post,
            'is_enable_sync_pp_and_confirm' => $is_enable_confirm_pp,
            'confirm_resp' => $res_confirm,
            'res_sync_with_route' => $res_sync
            
        );
        //return $item;
    }
    
    private static function createPpConfirmConnector($confirm_id, $pay_period_id, $user_id)
    {
        $db = & JFactory::getDBO();
        $item = new stdClass;
        $item->id = null;
        $item->user_id = (int)$user_id;
        $item->confirm_id = (int)$confirm_id;
        $item->pp_id = (int)$pay_period_id; 
        $item->timestamp_create = time();
        $item->date_create = date('d.m.Y H:i:s');
        
        $db->insertObject( '#__pp_confirm_connector', $item, 'id' );
    }
   
    //for app api only
    private function updateConfirmRowsForApi($post, $pp_id, $action, $is_enable_confirm_pp, $client_ip, $id_user, $date)
    {
        $pp_id = (int)$pp_id;

        $time = strtotime($date);
        $date = date("Y-m-d", $time);
        
        $item = new stdClass();
        $item->id = null;
        $item->date = $date;
        $item->id_user = $id_user;
        $item->date_logged = date("Y-m-d 00:00:00", $time);
        $item->date_exit = date("Y-m-d 00:00:01", $time);
        $item->ip = $client_ip;
         
        
        $result_check_weekend = $this->checkWeekend($item->date);
        $result_check_holidays = $this->checkHoliday($item->date);
        $final_res_arr = [];
        
        foreach ($post as $k => $v) {
            if ($k != 'message') {
                $v = $this->autocompletion($v);
            } 
            
            $final_key = $k;

            $valueField = $v;
            $final_res_arr[] = [
                'new_value' => $valueField,
                'key' => $final_key,
                'id_user' => $id_user     
            ];
            
            switch ($final_key) {
                case 'total':
                    $item->new_hours = $valueField;
                    break;
                case 'daytime':
                    if ($result_check_weekend != 1 && $result_check_holidays != 1) {
                        $item->new_daytime = $valueField;
                        $item->daytime_edit = '1';
                        $item->daytime_edited_date = date('Y-m-d H:i:s');
                    }
                    break;
                case 'afterwork':
                    if ($result_check_weekend != 1 && $result_check_holidays != 1) {
                        $item->new_afterwork = $valueField;
                        $item->afterwork_edit = '1';
                        $item->afterwork_edited_date = date('Y-m-d H:i:s');
                    }
                    break;
                case 'night_time':
                    if ($result_check_weekend != 1 && $result_check_holidays != 1) {
                        $item->new_night_time = $valueField;
                        $item->night_time_edit = '1';
                        $item->night_time_edited_date = date('Y-m-d H:i:s');
                    }
                    break;
                case 'weekend':
                    if ($result_check_weekend == 1) {
                        $item->new_weekend = $valueField;
                        $item->weekend_edit = '1';
                        $item->weekend_edited_date = date('Y-m-d H:i:s');
                    }
                    break;
                case 'holidays':
                    if ($result_check_holidays == 1) {
                        $item->new_holidays = $valueField;
                        $item->holidays_edit = '1';
                        $item->holidays_edited_date = date('Y-m-d H:i:s');
                    }
                    break;
                case 'message':
                    $item->note = $this->db->escape(trim(strip_tags($valueField)));
                    break;
            }
        }
        
        $this->db->insertObject( '#__audit_time_confirm', $item, 'id' );
        
        //create connector pp-confirm
        self::createPpConfirmConnector($item->id, $pp_id, $id_user);
        
      
        
        return $final_res_arr;
        
    }
    
    private static function getManagerObj($owner_id)
    {
        $db = & JFactory::getDBO();
         
        $query='SELECT * FROM #__users WHERE `id`="'.$owner_id.'"';
        $db->setQuery( $query );
        $managerObj = $db->loadObject();
        
        return $managerObj;
    }
    
    private static function getFinalCombineConfirmAndPpStatus($u_id)
    {
        $config = JFactory::getConfig();
        $db = & JFactory::getDBO();
         
        $query='SELECT `id`,`owner_id` FROM #__users WHERE `id`="'.$u_id.'"';
        $db->setQuery( $query );
        $userObj = $db->loadObject();
        
        if(empty($userObj->id)){
            return 0;
        }
        $managerObj = self::getManagerObj($userObj->owner_id);
        
        /*echo '<pre>';
        print_r($managerObj);
        echo '</pre>';*/
        
        if(empty($managerObj)){
            return 0;
        }

        $combine_confirm_and_pp = $managerObj->combine_confirm_and_pp;
        
        $enable_combine_option_for_confirm_and_pay_period = $config->get('enable_combine_option_for_confirm_and_pay_period');
        $system_mode = self::getSystemModeStatic($userObj->id);
        
        $is_enable_confirm_pp = 0;

        if($system_mode == 'confirm' && $combine_confirm_and_pp == 1 && $enable_combine_option_for_confirm_and_pay_period == '1'){
            $is_enable_confirm_pp = 1;
        }
        //echo '$is_enable_confirm_pp:'.$is_enable_confirm_pp.' $system_mode:'.$system_mode.' $combine_confirm_and_pp:'.$combine_confirm_and_pp.' $enable_combine_option_for_confirm_and_pay_period:'.$enable_combine_option_for_confirm_and_pay_period;
        return $is_enable_confirm_pp;
    }
    
    private static function getSystemModeStatic($company) {
        $path = JPATH_BASE . DS . 'global_functions' . DS . 'global_functions.class.php';
        require_once($path);
        // echo $path;
        //$company= JFactory::getApplication()->input->cookie->getString( 'company' );
        //if(empty($company))
        $system_mode_raw = globalFunctions::globalGetCompanyMods($company, 'confirmation');

        if ($system_mode_raw == '1') {
            $system_mode = 'confirm';
        } elseif ($system_mode_raw == '0') {
            $system_mode = 'pay_period';
        }
        //echo $system_mode.'<br/>';
        return $system_mode;
    }
    
    public function setOneDatePP4($param, $action)
    {
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/pay_period4.html', print_r($param, true), FILE_APPEND | LOCK_EX);
        //exit;

       $valueField = $param['new_value']; 
       $valueField=trim($valueField);
       $valueField= strip_tags($valueField);
       
       //$yearField = $param['year']; 
       $dateField = $param['date']; 
       $id_user=$param['u_id'];
       $id_user=(int)$id_user;
      
       $dateField = explode('.', $dateField);
       $yearField=$dateField[2];
       //$idField = $param['row_id'];
       //$idField = explode('-', $idField);
       
       $field = $param['cell_name'];
       $mode=$field;
       $id = $param['row_id'];
       
        
            $db = $this->db;
            $user_joomla = & JFactory::getUser(); 
            $id_user0 = $user_joomla->id;  
            
            $item = new stdClass;
            if($action==='update'){
                $item->id = $id; 
            } if($action==='insert'){
                $item->id = NULL; 
            }
                   
            $item->id_user = $id_user;
            if( $action!=='update' && $mode!='login_hours' && $mode!='exit_hours'){
                $item->date_logged = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:00';
                $item->date_exit = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:01';
            }
            
            //$item->date_logged='';
            //$item->date_exit='';
            $item->date = $yearField.'-'.$dateField[1].'-'.$dateField[0];
            $item->ip=$param['client_ip'];
                
            if($mode!='description'){
                //7=>07:00, 07=>07:00, 07:=>07:00, 07:0=>07:00
                $valueField=$this->autocompletion($valueField);
            }
            
            switch($mode){
                //this fields (login and hours) locked in app
                /*case 'login_hours':
                    //date= date from client request plus new H:i
                    if($action!='update'){
                       // $item->date_exit = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 23:59:00';
                    }
                    $newValue = date('Y-m-d', strtotime($item->date)).' '.$valueField;
       
                    $item->date_logged = $newValue;
                    $item->date_logged_edit='1';                   
                break;
                case 'exit_hours':
                    if($action!='update'){
                        $item->date_logged = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:00';
                    }
                    $newValue = date('Y-m-d', strtotime($item->date)).' '.$valueField;
                     
                    $item->date_exit = $newValue;
                    $item->date_exit_edit='1';                   
                break;*/
                case 'total':
                    $item->new_hours = $valueField;               
                break;
                case 'daytime':
                    $item->new_daytime = $valueField;
                    $item->daytime_edit='1';
                    $item->daytime_edited_date=date('Y-m-d H:i:s');
                break;
                case 'afterwork':
                    $item->new_afterwork = $valueField;
                    $item->afterwork_edit='1';
                    $item->afterwork_edited_date=date('Y-m-d H:i:s');
                break;
                case 'night_time':
                    $item->new_night_time = $valueField;
                    $item->night_time_edit='1';
                    $item->night_time_edited_date=date('Y-m-d H:i:s');
                break;
                case 'weekend':
                    //here
                    //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/edit_weekends.html', print_r($valueField, true), FILE_APPEND | LOCK_EX);
                    $item->new_weekend = $valueField;
                    $item->weekend_edit='1';
                    $item->weekend_edited_date=date('Y-m-d H:i:s');
                break;
                case 'holidays':
                    $item->new_holidays = $valueField;
                    $item->holidays_edit='1';
                    $item->holidays_edited_date=date('Y-m-d H:i:s');
                break;
                case 'description':
                   // $item->note = $valueField;
                break;
            }
            
            if($action=='update'){
                $res=$this->db->updateObject('#__audit_time', $item, 'id');
            } if($action=='insert'){
                $res=$this->db->insertObject( '#__audit_time', $item, 'id' );
            }
                   
         

       $code=0;

       return [
            'new_value'=>$valueField,
            'code'=>(string)$code,
            'id_user'=>$id_user,
            'action'=>$action,
            'last_id'=>$db->insertid()
        ];         
    }
    
    public function checkID($row_id, $user_id){
        $query='SELECT * FROM #__audit_time WHERE `id_user`="'.$user_id.'" AND `id`="'.$row_id.'"';
        $this->db->setQuery($query);
        $res = $this->db->loadObject();
        
        if(empty($res)){
            return 0;
        } else{
            return 1;
        }
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/pay_period4.html', print_r($res, true), FILE_APPEND | LOCK_EX);
    }
    
    public function getManagerId($user_id){
        $user=& JFactory::getUser((int)$user_id);
        return $user->owner_id;
    }
    
    public function newCalcColoredDays(...$a)
    {
        $args=func_get_args();
        $user_id=$args[0];
        $status=$args[1];
        $from=$args[2];
        $to=$args[3];
        $note=$args[4];
        
    
        $date_from= DateTime::createFromFormat('d.m.Y', $from);
        $current_month=$date_from->format('n');      
        $current_year=$date_from->format('Y');
        
        $date_to= DateTime::createFromFormat('d.m.Y', $to);      
        $month_to=$date_to->format('n');  
        $year_to=$date_to->format('Y');
        
        //make dates array
        $begin = new DateTime( $date_from->format('Y-m-d') );
        $end = new DateTime( $date_to->format('Y-m-d') );
        $end = $end->modify( '+1 day' ); 
        $interval = new DateInterval('P1D');
        $daterange = new DatePeriod($begin, $interval, $end);
        
        if(!empty($note)){
            $note=trim($this->db->escape($note));
        }
       
        $query='SELECT * FROM #__user_report_items WHERE `id_user`='.$user_id.' AND (';

        foreach($daterange as $date){ 
            
            if(!empty($note)){
               
                $query1='SELECT * FROM #__audit_time WHERE `id_user`="'.$user_id.'" AND `date`="'.$date->format('Y-m-d').'" AND `note` LIKE "%'.$note.'%"';
                $this->db->setQuery( $query1 );
                $pay_period_dates= $this->db->loadObjectList(); 

                if(!empty($pay_period_dates)){
                    //echo 'pp';     
                    foreach($pay_period_dates as $one_pp_date_or_item_in_date){
                        if(!empty($one_pp_date_or_item_in_date->note) && $one_pp_date_or_item_in_date->note==$note){
                            $query.='`month`="'.$date->format('n').'" AND `status`="'.$status.'" AND `year`="'.$date->format('Y').'" AND `day`="'.$date->format('j').'" OR ';
                        } 
                    }
                }  
            } else{
                $query.='`month`="'.$date->format('n').'" AND `status`="'.$status.'" AND `year`="'.$date->format('Y').'" AND `day`="'.$date->format('j').'" OR ';
            }
           
        }
        $sql_explode=explode('AND (', $query);//see this screen http://prntscr.com/s41wr8 , we are check generated sql
        /*echo '<pre>';
        print_r($query);
        echo '</pre>';*/
        
        $count_sql_parts=count($sql_explode);
        if($count_sql_parts==1 || empty($sql_explode[1])){
            unset($query);
            $all_days_current_month=[];
        } else{
            $query = rtrim($query, ' OR');
            $query.=')';
            
            $this->db->setQuery( $query );
            $all_days_current_month = $this->db->loadObjectList(); 
        }
        

        $i=0;
        $count_day_for_audit_time=0;
      
        $final_all_days_current_month=$all_days_current_month;

        foreach($final_all_days_current_month as $k=>$v){ 
            $count_day_for_audit_time++;

            $i++;                
        }
         
        return $count_day_for_audit_time;
    }
    
    public function newCalcColoredDaysSearchResult($user_id, $status, $from, $to, $dayNumber)
    {
       $count_day_for_audit_time=0;
       foreach($dayNumber as $one_date){
            $query='SELECT * FROM #__audit_time WHERE `id_user`="'.$user_id.'" AND `date`="'.$one_date->date.'" AND `note`';
           
            //echo $query;
            $this->db->setQuery( $query );
            $count_items_array= $this->db->loadAssocList(); 
            $count_day_for_audit_time++;
       }
       
       return $count_day_for_audit_time;
    }
    
    public function getOverworksForPayPeriod($parent_id)
    {
        $query = "SELECT * FROM #__union_overworks WHERE `parent_rule`='$parent_id' AND `id_user`='".$this->user->id."' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        return $this->db->loadObjectList();
    }
    
    /*public function isOverworkEdited($i, $parent_id)
    {
        $query = "SELECT `overwork_edit` FROM #__union_overworks WHERE `parent_rule`='$parent_id' AND `id_user`='".$this->user->id."' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $overworks= $this->db->loadObjectList();
        
        return $overworks[$i]->overwork_edit;
    }*/
    
    public function normalizeLimit($string, $format)
    {
        if(empty($format)) return 'enter format!';
        
        switch($format){
            case '000:00':
                $reg=preg_match('/^(\d{3}):(\d{2})$/', $string);
                if($reg!=true){
                    $res='incorrect limit format! enter string with 000:00 pattern';
                } else{
                    $res=1;
                    $arr=explode(':', $string);
                    $hours=(int)$arr[0];
                    $min=(int)$arr[1];
            
                    $sec_in_min=$min*60;
                    $sec_in_hour=$hours*60*60;
                    $sec_sum=$sec_in_min+$sec_in_hour;
                    return (float)$sec_sum;
                    //$obj=new DateTime($sec_sum);
                }
            break;
            case '00:00':
                $reg=preg_match('/^(\d{2}):(\d{2})$/', $string);
                if($reg!=true){
                    $res='incorrect limit format! enter string with 00:00 pattern';
                } else{
                    $res=1;
                    $arr=explode(':', $string);
                    $hours=(int)$arr[0];
                    $min=(int)$arr[1];
            
                    $sec_in_min=$min*60;
                    $sec_in_hour=$hours*60*60;
                    $sec_sum=$sec_in_min+$sec_in_hour;
                    return (float)$sec_sum;
                    //$obj=new DateTime($sec_sum);
                }
            break;
        }
       
        /*echo '<br/>'.$string.' preg='.$res.' $hours='.$hours.' $sec_sum=='. $sec_sum;
        echo '<pre>';
        print_r($obj->format('H:i'));
        echo '</pre>';*/
    }
    
    public function secToHours($sec)
    {
         if(empty($sec)) return 'enter sec!';
         $min=$sec/60;
         $formatted_time=$this->calcHours(0, $min, 0, 0);
         $final_time=$this->autocompletion2($formatted_time);
         return $final_time;
    }
            
    private function autocompletion2($valueField)
    {
        //$valueField='01:1';
       // echo strlen($valueField);
        switch(strlen($valueField)){
            case 0:
                
                break;
            case 1:
                $valueField='0'.$valueField.':00';
                break;
            case 2:
                $valueField0=str_split($valueField, 1);
                
                if($valueField0[0]=='0'){
                   $valueField='0'.$valueField0[1].':00';
                } else{
                    $valueField=$valueField0[0].$valueField0[1].':00';
                }
                break;
            case 3: 
                $valueField0=str_split($valueField, 1);
                $valueField=$valueField0[0].$valueField0[1].':00';
                break;
            case 4:
                $valueField0=str_split($valueField, 1);
                //if($valueField0[2]>0){
                     $valueField='0'.$valueField0[0].':'.$valueField0[2].$valueField0[3];
               /* } else{
                     $valueField=$valueField0[0].$valueField0[1].':'.$valueField0[3].'0';
                }*/
                /*echo '<pre>';
                print_r($valueField0);
                echo '</pre>';*/
               
                break;
        }
        
        return $valueField;
    }
    
    private function calcHours($total_h1, $total_m1, $limit = 0, $echo = 1){
      //  file_put_contents('/home/curiotime/app.curiotime.com/logs/collect.html', print_r($total_h1.'-'.$total_m1.'<br/>'.PHP_EOL, true),  FILE_APPEND | LOCK_EX); 
        
        $h = @$total_h1 * 3600;
        $m = @$total_m1 * 60;
        $s = $h + $m;

        $hour = floor($s / 3600);
        $sec = $s - ($hour * 3600);
        $min = ($sec / 60);
        $sec = $sec - ($min * 60);

        if ($min < 10) {
            $min = '0' . $min;
        }

        if($hour >= 8 && $limit != 0){
            if($echo == 1){
                return "08:00";
            } else{
                return "08:00";
            }
        } else{
            if($echo == 1){
                return $hour . ":" . $min;
            } else{
                return $hour . ":" . $min;
            }
        }
    }
    
    private function getSickChildStateAndConfig($user_id) {
        $config=&JFactory::getConfig();
        $u=&JFactory::getUser($user_id);
        $sick_child_state=$u->sick_child_state;
        $sick_child_state_with_config=$config->get('enable_sick_child');
        
        $res=0;
        if($sick_child_state=='1' && $sick_child_state_with_config=='1'){
            $res=1;
        }
        return $res;
    }
    
    private function getStringDate($date, $lang) {
        $date_normal=DateTime::createFromFormat('d.m.Y', $date);
        
        if ($lang == 'is') {
            $days_is = [
                "Monday" => "Mán",
                "Tuesday" => "Þrið",
                "Wednesday" => "Mið",
                "Thursday" => "Fim",
                "Friday" => "Fös",
                "Saturday" => "Lau",
                "Sunday" => "Sun"
            ];
            $user_item_date_row = $days_is[date('l', $date_normal->format('U'))];
            $user_item_date=$user_item_date_row.date(' d.m.Y', $date_normal->format('U'));
        } else {
            $user_item_date = date('D: d.m.Y', $date_normal->format('U'));
        }
        return $user_item_date;
    }

    public function prepareOneDateOfHtmlWithText($html, $user_id, $lang, $date_pp, $row_id) {
        include_once($_SERVER['DOCUMENT_ROOT'].'/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
        $dom = str_get_html($html);
        $q1  = $dom->find('table[class="pdf_not_width"]');
        
        $user= & JFactory::getUser($user_id);
        if(in_array(9, $user->groups)){
            $lock_fields=1;
        }
      
        $result=[];
        foreach ($q1 as $table) {
            $row = $table->find('tr[id="app-api-row-id-' . $row_id . '"]');

            foreach ($row as $item) {
                $dates = $item->find('*[class="api_date"]');
                $totals = $item->find('*[class="api_custom_td_1"]');
                $daytime = $item->find('*[class="api_daytime"]');
                $note = $item->find('div[id="new_descr-'.$row_id.'"]', 0);

                $i = 0;
                if (empty($dates)) {

                    //$result[]=htmlspecialchars($date);
                    $result[$i]['date'] = $this->getStringDate($date_pp, $lang);

                    $result[$i]['total'] = '';

                    //check colors, not delete this code
                    /* $total_color_red=strripos($totals[$i], 'pay_period_td_background_red');
                      $total_color_yellow=strripos($totals[$i], 'pay_period_td_background_yellow');
                      $total_color_green=strripos($totals[$i], 'pay_period_td_background_green');
                      $total_color_blue=strripos($totals[$i], 'pay_period_td_background_blue');
                      $total_color_gray=strripos($totals[$i], 'pay_period_td_background_gray');

                      //check cell edited or set color
                      $total_edited=strripos($totals[$i], 'red-line');
                      //set cell edited
                      if($total_edited==true){
                      $result[$i]['total_edited']=1;
                      }

                      //set colors
                      if($total_color_red==true){
                      $result[$i]['total_color']='red';
                      }
                      if($total_color_yellow==true){
                      $result[$i]['total_color']='yellow';
                      }
                      if($total_color_green==true){
                      $result[$i]['total_color']='green';
                      }
                      if($total_color_blue==true){
                      $result[$i]['total_color']='blue';
                      }
                      if($total_color_gray==true){
                      $result[$i]['total_color']='gray';
                      } */

                    $result[$i]['in'] = '';
                    $result[$i]['out'] = '';
                    $weekends_row = '';
                    $holidays_row = '';



                    $result[$i]['daytime'] = '';

                    /* $daytime_edited_class=strripos($daytime[$i], 'red-line');
                      if($daytime_edited_class==true){
                      $result[$i]['daytime_edited']=1;
                      } */

                    $result[$i]['afterwork'] = '';
                    /* $afterwork_edited_class=strripos($afterwork[$i], 'red-line');
                      if($afterwork_edited_class==true){
                      $result[$i]['afterwork_edited']=1;
                      } */

                    $result[$i]['night_time'] = '';
                    /* $night_edited_class=strripos($night[$i], 'red-line');
                      if($night_edited_class==true){
                      $result[$i]['night_edited']=1;
                      } */


                    $result[$i]['weekends'] = $weekends_row;
                    $weekend_edited_class = strripos($weekends[$i], 'red-line');
                    if ($weekend_edited_class == true) {
                        $result[$i]['weekend_edited'] = 1;
                    }

                    $result[$i]['holidays'] = $holidays_row;
                    $holidays_edited_class = strripos($holidays[$i], 'red-line');
                    if ($holidays_edited_class == true) {
                        $result[$i]['holidays_edited'] = 1;
                    }
                    
                    $result[$i]['message'] = $note->plaintext;
                    
                    $result[$i]['lock_fields'] = $lock_fields;
                } else {

                    //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/one_date_pp4-2.html', print_r(htmlspecialchars($dates), true), FILE_APPEND | LOCK_EX);

                    $time_start = $item->find('*[class="date_login"]');
                    $time_end = $item->find('*[class="date_logout"]');
                    $afterwork = $item->find('*[class="api_afterwork"]');
                    $night = $item->find('*[class="api_night"]');
                    $weekends = $item->find('*[class="api_weekends"]');
                    $holidays = $item->find('*[class="api_holidays"]');
                    $note = $item->find('div[id="new_descr-'.$row_id.'"]', 0);
                    
                    foreach ($dates as $date) {
                        //$result[]=htmlspecialchars($date);
                        $result[$i]['date'] = $date->plaintext;

                        $result[$i]['total'] = trim(strip_tags($totals[$i]));

                        //check colors
                        $total_color_red = strripos($totals[$i], 'pay_period_td_background_red');
                        $total_color_yellow = strripos($totals[$i], 'pay_period_td_background_yellow');
                        $total_color_green = strripos($totals[$i], 'pay_period_td_background_green');
                        $total_color_blue = strripos($totals[$i], 'pay_period_td_background_blue');
                        $total_color_gray = strripos($totals[$i], 'pay_period_td_background_gray');

                        //check cell edited or set color
                        $total_edited = strripos($totals[$i], 'red-line');
                        //set cell edited
                        if ($total_edited == true) {
                            $result[$i]['total_edited'] = 1;
                        }

                        //set colors
                        if ($total_color_red == true) {
                            $result[$i]['total_color'] = 'red';
                        }
                        if ($total_color_yellow == true) {
                            $result[$i]['total_color'] = 'yellow';
                        }
                        if ($total_color_green == true) {
                            $result[$i]['total_color'] = 'green';
                        }
                        if ($total_color_blue == true) {
                            $result[$i]['total_color'] = 'blue';
                        }
                        if ($total_color_gray == true) {
                            $result[$i]['total_color'] = 'gray';
                        }

                        $result[$i]['in'] = trim(strip_tags($time_start[$i]));
                        $result[$i]['out'] = trim(strip_tags($time_end[$i]));
                        $weekends_row = trim(strip_tags($weekends[$i]));
                        $holidays_row = trim(strip_tags($holidays[$i]));
                        $result[$i]['message'] = $note->plaintext;
                        
                        //for fix this bug http://prntscr.com/pdwba1- bug fixed
                        //if(empty($weekends_row) && empty($holidays_row)){
                        $result[$i]['daytime'] = trim(strip_tags($daytime[$i]));

                        $daytime_edited_class = strripos($daytime[$i], 'red-line');
                        if ($daytime_edited_class == true) {
                            $result[$i]['daytime_edited'] = 1;
                        }

                        $result[$i]['afterwork'] = trim(strip_tags($afterwork[$i]));
                        $afterwork_edited_class = strripos($afterwork[$i], 'red-line');
                        if ($afterwork_edited_class == true) {
                            $result[$i]['afterwork_edited'] = 1;
                        }

                        $result[$i]['night_time'] = trim(strip_tags($night[$i]));
                        $night_edited_class = strripos($night[$i], 'red-line');
                        if ($night_edited_class == true) {
                            $result[$i]['night_edited'] = 1;
                        }
                        //}

                        $result[$i]['weekends'] = $weekends_row;
                        $weekend_edited_class = strripos($weekends[$i], 'red-line');
                        if ($weekend_edited_class == true) {
                            $result[$i]['weekend_edited'] = 1;
                        }

                        $result[$i]['holidays'] = $holidays_row;
                        $holidays_edited_class = strripos($holidays[$i], 'red-line');
                        if ($holidays_edited_class == true) {
                            $result[$i]['holidays_edited'] = 1;
                        }

                        $result[$i]['lock_fields'] = $lock_fields;

                        $i++;
                    }
                }
            }
        }
        $count=count($result);
        
        foreach($dom->find('*[class="total-h"]') as $ee){
           $result['global_totals']['total']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-daytime"]') as $ee){
           $result['global_totals']['daytime']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-afterwork"]') as $ee){
           $result['global_totals']['afterwork']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-night_time"]') as $ee){
           $result['global_totals']['night_time']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-weekend"]') as $ee){
           $result['global_totals']['weekend']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-holidays90"]') as $ee){
           $result['global_totals']['holidays_90']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-holidays45"]') as $ee){
           $result['global_totals']['holidays_45']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-holidays_sick"]') as $ee){
           $result['global_totals']['sick']= trim($ee->plaintext);
        }
        
        $sick_child_state = $this->getSickChildStateAndConfig($user->owner_id);
        if ($sick_child_state == '1') {
            foreach ($dom->find('*[class="t-sick_child"]') as $ee) {
                $result['global_totals']['sick_child'] = trim($ee->plaintext);
            }
        }
        
        foreach($dom->find('*[class="t-breaks"]') as $ee){
           $result['global_totals']['break']= trim($ee->plaintext);
        }
        
        
        JLoader::register('AuditModelRules', JPATH_ROOT . '/components/com_audit/models/rules.php');

        $model_rules = JModelLegacy::getInstance('Rules', 'AuditModel');
        $rule_mode=$model_rules->getUserRuleForText($user->id);
        $header_texts_obj=$model_rules->getTexts($rule_mode['mode'], $rule_mode['rule_id'], $lang);
        
        //$result['global_totals']['header_texts_obj']=$header_texts_obj;
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }

        $result['global_totals']['total_txt']=JText::_('COM_AUDIT_OVERVIEW_TIME_TOTAL_LOGIN');
        $result['global_totals']['daytime_txt']=$header_texts_obj->daytime_text;
        $result['global_totals']['afterwork_txt']=$header_texts_obj->after_hours_text;
        $result['global_totals']['night_time_txt']=$header_texts_obj->night_time_text;
        $result['global_totals']['weekend_txt']=$header_texts_obj->weekends_text;
        $result['global_totals']['holidays_90_txt']=JText::_('COM_AUDIT_PAY_PERIOD_HOLIDAYS').' 90%';
        $result['global_totals']['holidays_45_txt']=JText::_('COM_AUDIT_PAY_PERIOD_HOLIDAYS').' 45%';
        $result['global_totals']['sick_txt']=JText::_('COM_AUDIT_TIME_DK_HEADER_SICK');
        $result['global_totals']['sick_child_txt']=JText::_('COM_AUDIT_TIME_DK_HEADER_SICK_CHILD');
        $result['global_totals']['break_txt']=JText::_('COM_AUDIT_PAY_PERIOD_TOTAL_BREAK2');
        
        return $result;
    }
    
    private function loadSubrulesMinutesObj(object $user) {
        $query = "SELECT * FROM #__subrules_minutes WHERE `parent_rule_id` = '$user->rule_number0'";     
        $this->db->setQuery($query);
        $res = $this->db->loadObject();
        
        return $res;
    }
    
    public function preparePayPeriodOfHtmlWithText($html, $user_id, $lang) {
        

        include_once($_SERVER['DOCUMENT_ROOT'].'/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
        $dom = str_get_html($html);
        $q1  = $dom->find('table[class="pdf_not_width"]');
       
        
        $totalsJson  =  array();
        if(preg_match("#<!--json-dk-totals--(.*)--json-dk-totals-->#", $html, $arr)) {
            $totalsJson  = json_decode($arr[1],true);
        }
        
        JLoader::register('AuditModelTime_Wages', JPATH_ROOT . '/components/com_audit/models/time_wages.php');
        $model_settings = JModelLegacy::getInstance('Time_Wages', 'AuditModel');
        $user= & JFactory::getUser($user_id);
        if(!empty($user->rule_number0)){
            $subrules_minutes = $this->loadSubrulesMinutesObj($user); 
            $subrules_minutes_checkbox_overtime_1_state = $subrules_minutes->limit_as_overtime;
            $subrules_minutes_checkbox_overtime_2_state = $subrules_minutes->limit_as_overtime2;
        }
        $sick_child_state=$model_settings->getSickChildStateAndConfig($user->owner_id);
        $sick_state=$model_settings->getSickState($user->owner_id);
        $config = JFactory::getConfig();
        $enablelimit_for_total_hours_in_all_fields = $config->get('enablelimit_for_total_hours_in_all_fields');
        
        $result=[];
        foreach($q1 as $table){
            $dates=$table->find('*[class="api_date"]');
            $totals=$table->find('*[class="api_custom_td_1"]');
            $rows_id=$table->find('*[id="hidden_row_id"]');
           
            
            $i=0;
            foreach($dates as $date){
               
                $result[$i]['date']=$date->plaintext;
               
                
                $result[$i]['total']=trim(strip_tags($totals[$i]));
                //check cell edited or set color
                $total_edited=strripos($totals[$i], 'red-line');
                
                //check colors
                $total_color_red=strripos($totals[$i], 'pay_period_td_background_red');
                $total_color_yellow=strripos($totals[$i], 'pay_period_td_background_yellow');
                $total_color_green=strripos($totals[$i], 'pay_period_td_background_green');
                $total_color_blue=strripos($totals[$i], 'pay_period_td_background_blue');
                $total_color_gray=strripos($totals[$i], 'pay_period_td_background_gray');
                
                //set cell edited
                if($total_edited==true){
                    $result[$i]['total_edited']=1;
                } 
                
                //set colors
                if($total_color_red==true){
                    $result[$i]['total_color']='red';
                } 
                if($total_color_yellow==true){
                    $result[$i]['total_color']='yellow';
                }
                if($total_color_green==true){
                    $result[$i]['total_color']='green';
                }
                if($total_color_blue==true){
                    $result[$i]['total_color']='blue';
                }
                if($total_color_gray==true){
                    $result[$i]['total_color']='gray';
                }
                
                if(!empty($rows_id[$i])){
                    $result[$i]['row_id']=trim($rows_id[$i]->getAttribute('value'));
                } else{
                    $result[$i]['row_id']='';
                    //continue;
                }
                
                $i++;
            }
            
            
           
        }
        $count=count($result);
        
        foreach($dom->find('*[class="total-h"]') as $ee){
           $result['global_totals']['total']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-daytime"]') as $ee){
           $result['global_totals']['daytime']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-afterwork"]') as $ee){
           $result['global_totals']['afterwork']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-night_time"]') as $ee){
           $result['global_totals']['night_time']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-weekend"]') as $ee){
           $result['global_totals']['weekend']= trim($ee->plaintext);
        }
        if($enablelimit_for_total_hours_in_all_fields == '1'){
            foreach($dom->find('*[class="t-overtime"]') as $ee){
                $result['global_totals']['overtime'] = trim($ee->plaintext);
            }
            foreach($dom->find('*[class="t-m_limit"]') as $ee){
                $result['global_totals']['monthly_limit'] = trim($ee->plaintext);
            }
        }
        foreach($dom->find('*[class="t-holidays90"]') as $ee){
           $result['global_totals']['holidays_90']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-holidays45"]') as $ee){
           $result['global_totals']['holidays_45']= trim($ee->plaintext);
        }
        if($sick_state=='1'){
            foreach($dom->find('*[class="t-holidays_sick"]') as $ee){
                $result['global_totals']['sick']= trim($ee->plaintext);
            }
        }
        if($sick_child_state=='1'){
            foreach($dom->find('*[class="t-sick_child"]') as $ee){
                $result['global_totals']['sick_child']= trim($ee->plaintext);
            }
        }
        foreach($dom->find('*[class="t-breaks"]') as $ee){
           $result['global_totals']['break']= trim($ee->plaintext);
        }
        
        
        if(isset($totalsJson['daytime'])) $result['global_totals']['daytime']  = $totalsJson['daytime']['total'];
        if(isset($totalsJson['after_hours'])) $result['global_totals']['afterwork']  = $totalsJson['after_hours']['total'];
        if(isset($totalsJson['night'])) $result['global_totals']['night_time']  = $totalsJson['night']['total'];
        if(isset($totalsJson['weekends'])) $result['global_totals']['weekend']  = $totalsJson['weekends']['total'];
        if(isset($totalsJson['holidays_90'])) $result['global_totals']['holidays_90']  = $totalsJson['holidays_90']['total'];
        if(isset($totalsJson['holidays_45'])) $result['global_totals']['holidays_45']  = $totalsJson['holidays_45']['total'];
        if($sick_state=='1'){
            if(isset($totalsJson['sick'])) $result['global_totals']['sick']  = $totalsJson['sick']['total'];
        }
        if($sick_child_state=='1'){
            if(isset($totalsJson['sick_child'])) $result['global_totals']['sick_child']  = $totalsJson['sick_child']['total'];
        }
        //$result['raw'] = $totalsJson;
        
        JLoader::register('AuditModelRules', JPATH_ROOT . '/components/com_audit/models/rules.php');

        $model_rules = JModelLegacy::getInstance('Rules', 'AuditModel');
        $rule_mode=$model_rules->getUserRuleForText($user->id);
        $header_texts_obj=$model_rules->getTexts($rule_mode['mode'], $rule_mode['rule_id'], $lang);
        
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }

        $result['global_totals']['total_txt'] = JText::_('COM_AUDIT_OVERVIEW_TIME_TOTAL_LOGIN');
        $result['global_totals']['daytime_txt'] = $header_texts_obj->daytime_text;
        $result['global_totals']['afterwork_txt'] = $header_texts_obj->after_hours_text;
        $result['global_totals']['night_time_txt'] = $header_texts_obj->night_time_text;
        $result['global_totals']['weekend_txt'] = $header_texts_obj->weekends_text;
        $result['global_totals']['holidays_90_txt'] = JText::_('COM_AUDIT_PAY_PERIOD_HOLIDAYS') . ' 90%';
        $result['global_totals']['holidays_45_txt'] = JText::_('COM_AUDIT_PAY_PERIOD_HOLIDAYS') . ' 45%';
        $result['global_totals']['sick_txt'] = JText::_('COM_AUDIT_TIME_DK_HEADER_SICK');
        $result['global_totals']['sick_child_txt'] = JText::_('COM_AUDIT_TIME_DK_HEADER_SICK_CHILD');
        $result['global_totals']['break_txt'] = JText::_('COM_AUDIT_PAY_PERIOD_TOTAL_BREAK2');
        $result['global_totals']['monthly_limit_txt'] = JText::_('COM_AUDIT_PAY_PERIOD_NEW_LIM_FOR_ALL_FIELDS_TXT');

        if($enablelimit_for_total_hours_in_all_fields == '1' && !empty($result['global_totals']['overtime']) && ($subrules_minutes_checkbox_overtime_1_state == 1 || $subrules_minutes_checkbox_overtime_2_state == 1)){
            if($subrules_minutes_checkbox_overtime_1_state == 1){
                $text = JText::_('COM_AUDIT_PAY_PERIOD_NEW_LIM_FOR_ALL_FIELDS_H');
            } if($subrules_minutes_checkbox_overtime_2_state == 1){
                //$text = JText::_('COM_AUDIT_PAY_PERIOD_NEW_LIM_FOR_ALL_FIELDS_H') . ' ' . 2;
                $text = JText::_('COM_AUDIT_PAY_PERIOD_NEW_LIM_FOR_ALL_FIELDS_H');
            }
            
            $result['global_totals']['overtime_txt'] = $text;
        }
            
        
        return $result;
    }
    
	
    public function tempSaveApiPayPeriod($html, $token, $user_id)
    {
        $item=new stdClass();
        $item->id=null;
        $item->token=trim($token);
        $item->html= json_encode($html);
        //$item->datetime=date('d.m.Y H:i:s');
        //$item->timestamp=time();
        //$item->date=date('d.m.Y');
        $item->user_id=$user_id;
        
        $this->db->insertObject('#__api_pay_period_temp', $item);
    }
    
    public function filterOneDate($html, $user_id)
    {
        return $html;
    }
    
    public function prepareTotalsForCalc($html, $user_id, $lang) {
        /*ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);*/

        include_once($_SERVER['DOCUMENT_ROOT'].'/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
        $dom = str_get_html($html);
        $q1  = $dom->find('table[class="pdf_not_width"]');
       
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/api_pp4_html_fix.html', print_r($dom, true), FILE_APPEND | LOCK_EX);
        
        /*$totalsJson  =  array();
        if(preg_match("#<!--json-dk-totals--(.*)--json-dk-totals-->#", $html, $arr)) {
            $totalsJson  = json_decode($arr[1], true);
        }*/
        
        JLoader::register('AuditModelTime_Wages', JPATH_ROOT . '/components/com_audit/models/time_wages.php');
        $model_settings = JModelLegacy::getInstance('Time_Wages', 'AuditModel');
        $user= & JFactory::getUser($user_id);
        $sick_child_state=$model_settings->getSickChildStateAndConfig($user->owner_id);
        $sick_state=$model_settings->getSickState($user->owner_id);
        
        $result=[]; 
        
        foreach($q1 as $table){
            $q2 = $table->find('tr[class="tr_bottom"]');
            $i=0;
            
            foreach($q2 as $tr){
                $total=$tr->find('td[class="app_api_tr_bottom_td_total"]', 0);
                $daytime=$tr->find('td[class="app_api_tr_bottom_td_daytime"]', 0);
                $afterwork=$tr->find('td[class="app_api_tr_bottom_td_afterwork"]', 0);
                $night=$tr->find('td[class="app_api_tr_bottom_td_night"]', 0);
                $weekends=$tr->find('td[class="app_api_tr_bottom_td_weekends"]', 0);
                $holidays_90=$tr->find('*[class="app_api_tr_bottom_td_holidays_90"]', 0);
                $holidays_45=$tr->find('*[class="app_api_tr_bottom_td_holidays_45"]', 0);
                
                $result[$i]['total']=trim($total->plaintext);
                $result[$i]['daytime']=trim($daytime->plaintext);
                $result[$i]['afterwork']=trim($afterwork->plaintext);
                $result[$i]['night']=trim($night->plaintext);
                $result[$i]['weekends']=trim($weekends->plaintext);
                $result[$i]['holidays_90']=trim($holidays_90->plaintext);
                $result[$i]['holidays_45']=trim($holidays_45->plaintext);
                
                $i++;
            }
        }
       

        /*if(isset($totalsJson['daytime'])) $result['global_totals']['daytime']  = $totalsJson['daytime']['total'];
        if(isset($totalsJson['after_hours'])) $result['global_totals']['afterwork']  = $totalsJson['after_hours']['total'];
        if(isset($totalsJson['night'])) $result['global_totals']['night_time']  = $totalsJson['night']['total'];
        if(isset($totalsJson['weekends'])) $result['global_totals']['weekend']  = $totalsJson['weekends']['total'];
        if(isset($totalsJson['holidays_90'])) $result['global_totals']['holidays_90']  = $totalsJson['holidays_90']['total'];
        if(isset($totalsJson['holidays_45'])) $result['global_totals']['holidays_45']  = $totalsJson['holidays_45']['total'];
        if($sick_state=='1'){
            if(isset($totalsJson['sick'])) $result['global_totals']['sick']  = $totalsJson['sick']['total'];
        }
        if($sick_child_state=='1'){
            if(isset($totalsJson['sick_child'])) $result['global_totals']['sick_child']  = $totalsJson['sick_child']['total'];
        }*/
        //$result['raw'] = $totalsJson;
        
        /*JLoader::register('AuditModelRules', JPATH_ROOT . '/components/com_audit/models/rules.php');

        $model_rules = JModelLegacy::getInstance('Rules', 'AuditModel');
        $rule_mode=$model_rules->getUserRuleForText($user->id);
        $header_texts_obj=$model_rules->getTexts($rule_mode['mode'], $rule_mode['rule_id'], $lang);
        
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }

        $result['global_totals']['total_txt']=JText::_('COM_AUDIT_OVERVIEW_TIME_TOTAL_LOGIN');
        $result['global_totals']['daytime_txt']=$header_texts_obj->daytime_text;
        $result['global_totals']['afterwork_txt']=$header_texts_obj->after_hours_text;
        $result['global_totals']['night_time_txt']=$header_texts_obj->night_time_text;
        $result['global_totals']['weekend_txt']=$header_texts_obj->weekends_text;
        $result['global_totals']['holidays_90_txt']=JText::_('COM_AUDIT_PAY_PERIOD_HOLIDAYS').' 90%';
        $result['global_totals']['holidays_45_txt']=JText::_('COM_AUDIT_PAY_PERIOD_HOLIDAYS').' 45%';
        $result['global_totals']['sick_txt']=JText::_('COM_AUDIT_TIME_DK_HEADER_SICK');
        $result['global_totals']['sick_child_txt']=JText::_('COM_AUDIT_TIME_DK_HEADER_SICK_CHILD');
        $result['global_totals']['break_txt']=JText::_('COM_AUDIT_PAY_PERIOD_TOTAL_BREAK2');*/
        
        $sum_values = $this->sumValuesToFrontPageCalc($result, $user_id, $lang);
        //$converted_values = $this->convertToFrontPageCalc($sum_values, $user_id, $lang);
        return $sum_values;
    }
    
    private function sumValuesToFrontPageCalc($result, $user_id, $lang)
    {
        $final=[];
        
        $total = $result[0]['total'];
        $daytime = $result[0]['daytime'];
        $afterwork = $result[0]['afterwork'];
        $night = $result[0]['night'];
        $weekends = $result[0]['weekends'];
        $holidays_90 = $result[0]['holidays_90'];
        $holidays_45 = $result[0]['holidays_45'];
        
        $final['total'] = (float)$this->convertToFrontPageCalc($total, $user_id, $lang);
        
        $overwork = $this->convertToFrontPageCalc($afterwork, $user_id, $lang) + 
                $this->convertToFrontPageCalc($night, $user_id, $lang) + 
                $this->convertToFrontPageCalc($weekends, $user_id, $lang);
        $holidays_sum = $this->convertToFrontPageCalc($holidays_90, $user_id, $lang) + 
                $this->convertToFrontPageCalc($holidays_45, $user_id, $lang); 
                
        $final['overwork'] = (float)$overwork;
        $final['holidays'] = (float)$holidays_sum;
        $final['daytime'] = (float)$this->convertToFrontPageCalc($daytime, $user_id, $lang);
        
        $final['not_converted']['total'] = $total;
        $final['not_converted']['daytime'] = $daytime;
        $final['not_converted']['afterwork'] = $afterwork;
        $final['not_converted']['night'] = $night;
        $final['not_converted']['weekends'] = $weekends;
        $final['not_converted']['holidays_90'] = $holidays_90;
        $final['not_converted']['holidays_45'] = $holidays_45;
        
        return $final;
    }
    
    private function convertToFrontPageCalc($result, $user_id, $lang)
    {
        $val_arr = explode(':', $result);
        $hours = $val_arr[0];
        $min = $val_arr[1];
        
        $final = $this->calcHoursOtherFormat($hours, $min, 0, 0);
        
        return $final;
    }
    
    private function calcHoursOtherFormat($total_h, $total_m, $limit = 0, $echo = 1) {
        $h = @$total_h * 3600;
        $m = @$total_m * 60;
        $s = $h + $m;

        $hour = floor($s / 3600);
        $sec = $s - ($hour * 3600);
        $min = ($sec / 60);
        $sec = $sec - ($min * 60);

        if ($min < 10) {
            $min = '0' . $min;
        }

        if ($hour >= 8 && $limit != 0) {
            if ($echo == 1) {
                echo "08:00";
            } else {
                return "08:00";
            }
        } else {
            if ($echo == 1) {
                if ($hour == '0' && $min == '00') {
                    echo '0';
                } else {
                    echo $hour . "." . $min;
                }
            } else {
                if ($hour == '0' && $min == '00') {
                    return '0';
                } else {
                    return $hour . "." . $min;
                }
            }
        }
    }
    
    public function checkActionPermission($type, $individual_params)
    {
        $res='0';
        
        switch($type){
            case 'confirm_row':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                } 
            break;
            case 'setNoteInPayPeriod':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();
                
                $query = "SELECT `id_user` FROM #__audit_time WHERE `id` = '" . $individual_params['id'] . "'";     
                $this->db->setQuery($query);
                $user_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 && $user_id === $user->id){
                    $res = '1';
                } 
            break;
        }
      
       
       return $res;
    }
    
    public function confirmPayPeriodAndConfirmRow($id_user, $id)
    {
        $query = 'SELECT * FROM #__audit_time WHERE `id`="'.$id.'" AND `id_user`="'.$id_user.'"';
        $this->db->setQuery($query);
        $item = $this->db->loadObject();

        if(!empty($item)){
            $item = new stdClass;
            $item->id = $id;
            $item->is_confirm = '1';
                    
            $this->db->updateObject( '#__audit_time', $item, 'id' ); 
                
            $confirm_id = $this->getConfirmIdByPpId($id);
            if(!empty($confirm_id)){
                $this->updateStatusInConfirm($confirm_id);
            }
        }     
    }
    
    public function reConfirmPayPeriodAndConfirmRow($id_user, $id)
    {
        $query = 'SELECT * FROM #__audit_time WHERE `id`="'.$id.'" AND `id_user`="'.$id_user.'"';
        $this->db->setQuery($query);
        $item = $this->db->loadObject();

        if(!empty($item)){
            $item = new stdClass;
            $item->id = $id;
            $item->is_confirm = '0';
                    
            $this->db->updateObject( '#__audit_time', $item, 'id' ); 
                
            $confirm_id = $this->getConfirmIdByPpId($id);
            if(!empty($confirm_id)){
                $this->updateStatusInConfirmRevert($confirm_id);
            }
        }     
    }
    
    private function getConfirmIdByPpId($pp_id)
    {
        $query = "SELECT `id`, `confirm_id` FROM #__pp_confirm_connector WHERE `pp_id` = '".(int)$pp_id."'";
        //echo $query;
        $this->db->setQuery( $query );
        return (int)$this->db->loadObject()->confirm_id;
    }
    
    private function addOneRowConfirm($confirm_object)
    {
        $item = new stdClass;
        foreach($confirm_object as $k=>$v){
            $item->id = NULL;
            if($k!=is_confirm && $k!=audit_time_id && $k!=id && $k!=border_14_hours){
                $item->$k=$v;
            }
            
        }
  
        $res = $this->db->insertObject( '#__audit_time_confirm', $item, 'id' );      
        $insert_id = $this->db->insertid();
        if(!empty($insert_id)){
            return '1';
        }
        else{
            return '0';
        }
       // setcookie('insert_id_pay_period', $insert_id,  time()+3600 * 24 * 365);
    }

    private function updateStatusInConfirm($confirm_id)
    {
        $item = new stdClass;
        $item->id = $confirm_id;
        $item->is_confirm = '1';
                    
        $this->db->updateObject( '#__audit_time_confirm', $item, 'id' );
    }
    
    private function updateStatusInConfirmRevert($confirm_id)
    {
        $item = new stdClass;
        $item->id = $confirm_id;
        $item->is_confirm = '0';
                    
        $this->db->updateObject( '#__audit_time_confirm', $item, 'id' );
    }
    
    public function addDefaultDaytime($date, $user_obj)
    {
        if(!empty($date) && !empty($user_obj)){
            $result_check_date_to_format = self::checkDateFormat($date);
            $app = JFactory::getApplication();
            
            if($result_check_date_to_format == 1){
                $union_rule_id = $user_obj->rule_number0;    
                $model_rules = JModelLegacy::getInstance('Rules', 'AuditModel');
                $union_new_part = $model_rules->getSubrulesTrue($union_rule_id, 'new_part');
                
                /*echo '<pre>';
                print_r($union_new_part);
                echo '</pre>';*/ 
                
                $date_arr = explode('-', $date);
                if(!empty($union_new_part)){
                    $params = [
                        'id' => 'new_daytime-',
                        'value' => $union_new_part[0]->days,
                        'year' => $date_arr[0],
                        'date' => $date_arr[2].'.'.$date_arr[1],
                        'user_id' => (int)$user_obj->id
                    ]; 
                    
                    $this->addNewAuditTimeRow($params, 'daytime', 'insert');
                    $time = strtotime('now + 1day'); // 1 week
                    $app->input->cookie->set('reload_pay_period', '1', $time, $app->get('cookie_path', '/'), $app->get('cookie_domain'), $app->isSSLConnection());
                }
               
            } 
        }
    }
    
    private static function checkDateFormat($date){
        $dt = DateTime::createFromFormat("Y-m-d", $date);
        return $dt !== false && !array_sum($dt::getLastErrors());
    }
    
    public function preparePayPeriodOfHtmlWithTextForFrontApi($html, $user_id, $lang) {
        
        include_once($_SERVER['DOCUMENT_ROOT'] . '/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
        
        $dom = str_get_html($html);
       
        $q1 = $dom->find('table[class="pdf_not_width"]');
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/api_pp4_html_fix.html', print_r($dom, true), FILE_APPEND | LOCK_EX);

        $totalsJson = array();
        if (preg_match("#<!--json-dk-totals--(.*)--json-dk-totals-->#", $html, $arr)) {
            $totalsJson = json_decode($arr[1], true);
        }

        JLoader::register('AuditModelTime_Wages', JPATH_ROOT . '/components/com_audit/models/time_wages.php');
        $model_settings = JModelLegacy::getInstance('Time_Wages', 'AuditModel');
        $user = & JFactory::getUser($user_id);
        $sick_child_state = $model_settings->getSickChildStateAndConfig($user->owner_id);
        $sick_state = $model_settings->getSickState($user->owner_id);

        $result = [];
        $k = 0;
        foreach ($q1 as $table) {
            $dates = $table->find('*[class="api_date"]');
            $starts = $table->find('*[class="date_login"]');
            $stops = $table->find('*[class="date_logout"]');
            $totals = $table->find('*[class="api_custom_td_1"]');
            $rows_id = $table->find('*[id="hidden_row_id"]');
            $daytimes = $table->find('*[class="api_daytime"]');
            $afterworks = $table->find('*[class="api_afterwork"]');
            $nights = $table->find('*[class="api_night"]');
            $weekends = $table->find('*[class="api_weekends"]');
            $holidays = $table->find('*[class="api_holidays"]');
            $descriptions = $table->find('*[class="td_pay_period_note"]');
            $gps_starts = $table->find('*[class="hidden_gps_start"]');
            $gps_ends = $table->find('*[class="hidden_gps_end"]');
            $row_classes = $table->find('*[class="hidden_row_class"]');
            
            //tr_holiday
            $i = 0;
            foreach ($dates as $date) {
                //$result[]=htmlspecialchars($date);
                $result[$i]['date'] = $date->plaintext;
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/api_pp4_html_fix.html', print_r($result[$i]['date'], true), FILE_APPEND | LOCK_EX);
                
                $result[$i]['start'] = trim(strip_tags($starts[$i]));
                
                $start_edited = strripos($starts[$i], 'red-line');
                $result[$i]['start_edited'] = 0;
                if ($start_edited == true) {
                    $result[$i]['start_edited'] = 1;
                }
                $result[$i]['stop'] = trim(strip_tags($stops[$i]));
                $stop_edited = strripos($stops[$i], 'red-line');
                
                $result[$i]['stop_edited'] = 0;
                if ($stop_edited == true) {
                    $result[$i]['stop_edited'] = 1;
                }
                $result[$i]['total'] = trim(strip_tags($totals[$i]));
                //check cell edited or set color
                $total_edited = strripos($totals[$i], 'red-line');

                //check colors
                $total_color_red = strripos($totals[$i], 'pay_period_td_background_red');
                $total_color_yellow = strripos($totals[$i], 'pay_period_td_background_yellow');
                $total_color_green = strripos($totals[$i], 'pay_period_td_background_green');
                $total_color_blue = strripos($totals[$i], 'pay_period_td_background_blue');
                $total_color_gray = strripos($totals[$i], 'pay_period_td_background_gray');
                
                $result[$i]['total_edited'] = 0;
                //set cell edited
                if ($total_edited == true) {
                    $result[$i]['total_edited'] = 1;
                }

                //set colors
                $result[$i]['total_color'] = '';
                
                if ($total_color_red == true) {
                    $result[$i]['total_color'] = '#ED6A56';
                }
                if ($total_color_yellow == true) {
                    $result[$i]['total_color'] = '#FEC34B';
                }
                if ($total_color_green == true) {
                    $result[$i]['total_color'] = '#9BD6C6';
                }
                if ($total_color_blue == true) {
                    $result[$i]['total_color'] = '#26c2f0';
                }
                if ($total_color_gray == true) {
                    $result[$i]['total_color'] = '#b9b9b9';
                }
                
                $result[$i]['daytime'] = trim(strip_tags($daytimes[$i]));
                
                $daytime_edited = strripos($daytimes[$i], 'red-line');
                $result[$i]['daytime_edited'] = 0;
                if ($daytime_edited == true) {
                    $result[$i]['daytime_edited'] = 1;
                }
                
                $result[$i]['afterwork'] = trim(strip_tags($afterworks[$i]));
                
                $afterwork_edited = strripos($afterworks[$i], 'red-line');
                $result[$i]['afterwork_edited'] = 0;
                if ($afterwork_edited == true) {
                    $result[$i]['afterwork_edited'] = 1;
                }
                
                $result[$i]['night'] = trim(strip_tags($nights[$i]));
                
                $night_edited = strripos($nights[$i], 'red-line');
                $result[$i]['night_edited'] = 0;
                if ($night_edited == true) {
                    $result[$i]['night_edited'] = 1;
                }
                
                $result[$i]['weekend'] = trim(strip_tags($weekends[$i]));
                
                $weekend_edited = strripos($weekends[$i], 'red-line');
                $result[$i]['weekend_edited'] = 0;
                if ($weekend_edited == true) {
                    $result[$i]['weekend_edited'] = 1;
                }
                
                $result[$i]['holiday'] = trim(strip_tags($holidays[$i]));
                
                $holiday_edited = strripos($holidays[$i], 'red-line');
                $result[$i]['holiday_edited'] = 0;
                if ($holiday_edited == true) {
                    $result[$i]['holiday_edited'] = 1;
                }
                $result[$i]['description'] = trim(strip_tags($descriptions[$i]));
                
               
                if (!empty($gps_starts[$i])) {
                    $result[$i]['gps_start'] = trim($gps_starts[$i]->getAttribute('value'));
                } else {
                    $result[$i]['gps_start'] = '';
                }
                
                if (!empty($gps_ends[$i])) {
                    $result[$i]['gps_end'] = trim($gps_ends[$i]->getAttribute('value'));
                } else {
                    $result[$i]['gps_end'] = '';
                }

                if (!empty($row_classes[$i])) {
                    $result[$i]['row_class'] = trim($row_classes[$i]->getAttribute('value'));
                } else {
                    $result[$i]['row_class'] = '';
                }
                
                if (!empty($rows_id[$i])) {
                    $result[$i]['row_id'] = trim($rows_id[$i]->getAttribute('value'));
                } else {
                    $result[$i]['row_id'] = '';
                 
                }
                
                

                $i++;
                $k++;
            }
            
           
        }
        $count = count($result);

        foreach ($dom->find('*[class="total-h"]') as $ee) {
            $result['global_totals']['total'] = trim($ee->plaintext);
        }
        foreach ($dom->find('*[class="t-daytime"]') as $ee) {
            $result['global_totals']['daytime'] = trim($ee->plaintext);
        }
        foreach ($dom->find('*[class="t-afterwork"]') as $ee) {
            $result['global_totals']['afterwork'] = trim($ee->plaintext);
        }
        foreach ($dom->find('*[class="t-night_time"]') as $ee) {
            $result['global_totals']['night_time'] = trim($ee->plaintext);
        }
        foreach ($dom->find('*[class="t-weekend"]') as $ee) {
            $result['global_totals']['weekend'] = trim($ee->plaintext);
        }
        foreach ($dom->find('*[class="t-holidays90"]') as $ee) {
            $result['global_totals']['holidays_90'] = trim($ee->plaintext);
        }
        foreach ($dom->find('*[class="t-holidays45"]') as $ee) {
            $result['global_totals']['holidays_45'] = trim($ee->plaintext);
        }
        if ($sick_state == '1') {
            foreach ($dom->find('*[class="t-holidays_sick"]') as $ee) {
                $result['global_totals']['sick'] = trim($ee->plaintext);
            }
        }
        if ($sick_child_state == '1') {
            foreach ($dom->find('*[class="t-sick_child"]') as $ee) {
                $result['global_totals']['sick_child'] = trim($ee->plaintext);
            }
        }
        foreach ($dom->find('*[class="t-breaks"]') as $ee) {
            $result['global_totals']['break'] = trim($ee->plaintext);
        }


        if (isset($totalsJson['daytime']))
            $result['global_totals']['daytime'] = $totalsJson['daytime']['total'];
        if (isset($totalsJson['after_hours']))
            $result['global_totals']['afterwork'] = $totalsJson['after_hours']['total'];
        if (isset($totalsJson['night']))
            $result['global_totals']['night_time'] = $totalsJson['night']['total'];
        if (isset($totalsJson['weekends']))
            $result['global_totals']['weekend'] = $totalsJson['weekends']['total'];
        if (isset($totalsJson['holidays_90']))
            $result['global_totals']['holidays_90'] = $totalsJson['holidays_90']['total'];
        if (isset($totalsJson['holidays_45']))
            $result['global_totals']['holidays_45'] = $totalsJson['holidays_45']['total'];
        if ($sick_state == '1') {
            if (isset($totalsJson['sick']))
                $result['global_totals']['sick'] = $totalsJson['sick']['total'];
        }
        if ($sick_child_state == '1') {
            if (isset($totalsJson['sick_child']))
                $result['global_totals']['sick_child'] = $totalsJson['sick_child']['total'];
        }
        //$result['raw'] = $totalsJson;

        JLoader::register('AuditModelRules', JPATH_ROOT . '/components/com_audit/models/rules.php');

        $model_rules = JModelLegacy::getInstance('Rules', 'AuditModel');
        $rule_mode = $model_rules->getUserRuleForText($user->id);
        $header_texts_obj = $model_rules->getTexts($rule_mode['mode'], $rule_mode['rule_id'], $lang);

        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }

        $result['global_totals']['total_txt'] = JText::_('COM_AUDIT_OVERVIEW_TIME_TOTAL_LOGIN');
        $result['global_totals']['daytime_txt'] = $header_texts_obj->daytime_text;
        $result['global_totals']['afterwork_txt'] = $header_texts_obj->after_hours_text;
        $result['global_totals']['night_time_txt'] = $header_texts_obj->night_time_text;
        $result['global_totals']['weekend_txt'] = $header_texts_obj->weekends_text;
        $result['global_totals']['holidays_90_txt'] = JText::_('COM_AUDIT_PAY_PERIOD_HOLIDAYS') . ' 90%';
        $result['global_totals']['holidays_45_txt'] = JText::_('COM_AUDIT_PAY_PERIOD_HOLIDAYS') . ' 45%';
        $result['global_totals']['sick_txt'] = JText::_('COM_AUDIT_TIME_DK_HEADER_SICK');
        $result['global_totals']['sick_child_txt'] = JText::_('COM_AUDIT_TIME_DK_HEADER_SICK_CHILD');
        $result['global_totals']['break_txt'] = JText::_('COM_AUDIT_PAY_PERIOD_TOTAL_BREAK2');
        return $result;
    }

    public function editTimesheet($id, $post, $id_user, $date) {        
        // convert date
        $dateArr = explode(".", $date);
        $date_raw = $date;
        
        //$date_standart = $dateArr[2]."-".$dateArr[1]."-".$dateArr[0];
        $time = strtotime($date);
        $date = date("Y-m-d", $time);
        
        

        $query = 'SELECT * FROM #__audit_time WHERE `id` = "'.$id.'" AND `id_user` = "'.$id_user.'"';
        $this->db->setQuery($query);
        $item1 = $this->db->loadObject();
       
        //$date = $item->date;
        $client_ip = $_SERVER['REMOTE_ADDR'];
        //$time = strtotime($date);
        //$dateArr = explode('-', $date);
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/fix_weekend_loock.html', print_r($item, true), FILE_APPEND | LOCK_EX);
       
        if($id > 0 && empty($item1)) {
            throw new Exception("Record Audit Time [{$id}] not found.");
        }
        if(empty($item1)) {
            $item = new stdClass();
            $item->id = null;
            $item->date = $date;
            $item->id_user = $id_user;
            $item->date_logged = date("Y-m-d 00:00:00", $time);
            $item->date_exit = date("Y-m-d 00:00:01", $time);
            $item->ip = $client_ip;
        }  else{
            $item->id = $item1->id;
        }
        
        $result_check_weekend = $this->checkWeekend($item->date);
        $result_check_holidays = $this->checkHoliday($item->date);
        
        
       
        
        if(is_array($post)) {
            $is_enable_confirm_pp = self::getFinalCombineConfirmAndPpStatus($id_user);
            JLoader::register('AuditModelConfirm_time', JPATH_ROOT . '/components/com_audit/models/confirm_time.php');
            $model_confirm = JModelLegacy::getInstance('Confirm_time', 'AuditModel');
            
            if($is_enable_confirm_pp == '1'){
                $res_confirm = [];
            }
        
            if($id > 0) {
                $action = "update"; 
            } else {
                $action = "insert";
            } 
            //get confirm row id
            $confirm_id = $this->getConfirmIdByPpId($id);
            
            foreach ($post as $k=>$v) {
                if($k != 'message')  {
                    $v = $this->autocompletion($v);
                }
                $valueField = $v;
                
               
                if($is_enable_confirm_pp == '1' ){

                    //clone changes to confirm page(sync)
                    if(!empty($confirm_id)){
                        $param['id'] = $k.'-'.$confirm_id;
                        $param['year'] = $dateArr[2];
                        
                        $param['date'] = $date;
                        $param['task'] = 'SyncConfirm01';
                        $param['user_id'] = $id_user;
                        $param['value'] = $valueField;
                        
                        if($k == 'message'){
                            $final_key = 'description';
                        } else{
                            $final_key = $k;
                        }
                        $res_confirm[] = $model_confirm->addNewAuditTimeRow($param, $final_key, $action);
                        // return $query;
                        //exit;
                    } 
                } 
                //return $k;
                switch($k){
                    case 'login_hours': 
                       if($id <= 0 ){
                            $item->date_logged = date("Y-m-d H:i:s", $time);
                        }
                        $newValue = date('Y-m-d', strtotime($item->date)).' '.$valueField;
                        $item->date_logged = $newValue;
                     
                        $item->date_logged_edit = '1';  
                             
                    break;
                    case 'exit_hours':
                        if($id <= 0 ){
                            $item->date_logged = date("Y-m-d H:i:s", $time);
                        }
                        $newValue = date('Y-m-d', strtotime($item->date)).' '.$valueField;
                        $item->date_exit = $newValue;
                        $item->date_exit_edit = '1';                  
                    break;
                    case 'total':
                        $item->new_hours = $valueField;               
                    break;
                    case 'daytime':
                        //if($result_check_weekend != 1 && $result_check_holidays != 1){
                            $item->new_daytime = $valueField;
                            $item->daytime_edit = '1';
                            $item->daytime_edited_date = date('Y-m-d H:i:s');
                       // }
                    break;
                    case 'afterwork':
                        //if($result_check_weekend != 1 && $result_check_holidays != 1){
                            $item->new_afterwork = $valueField;
                            $item->afterwork_edit = '1';
                            $item->afterwork_edited_date = date('Y-m-d H:i:s');
                       // }
                    break;
                    case 'night_time':
                        //if($result_check_weekend != 1 && $result_check_holidays != 1){
                            $item->new_night_time = $valueField;
                            $item->night_time_edit = '1';
                            $item->night_time_edited_date = date('Y-m-d H:i:s');
                       // }
                    break;
                    case 'weekend':
                        //if($result_check_weekend == 1){
                            $item->new_weekend = $valueField;
                            $item->weekend_edit = '1';
                            $item->weekend_edited_date = date('Y-m-d H:i:s');
                        //}
                    break;
                    case 'holidays':
                        //if($result_check_holidays == 1){
                            $item->new_holidays = $valueField;
                            $item->holidays_edit = '1';
                            $item->holidays_edited_date = date('Y-m-d H:i:s');
                        //} 
                    break;
                    case 'message':
                        $item->note = $this->db->escape(trim(strip_tags($valueField)));
                    break;
                }
            }
        }
        if($id > 0) {
          
            try{
                $res = $this->db->updateObject('#__audit_time', $item, 'id', false);
                
            } catch (Exception $ex) {
                //return $ex;
            }
           
           
        } else {
             try{
                 $res = $this->db->insertObject( '#__audit_time', $item, 'id' );
                
            } catch (Exception $ex) {
                //return $ex;
            }
           
            $id = $this->db->insertid();
           
            if($is_enable_confirm_pp == '1'){
                $res_confirm = $this->updateConfirmRowsForApi($post, $id, $action, $is_enable_confirm_pp, $client_ip, $id_user, $date);
            }
        }  

        $code = 0;
        
        return [
            /*'code' => (string)$code,
            'local_user_id' => (int)$id_user,
            'action' => $action,
            'last_id' => $id,
            'post' => $post,*/
            'id' => $id,
            'is_enable_sync_pp_and_confirm' => $is_enable_confirm_pp,
            'confirm_resp' => $res_confirm,
            
        ];
    }
    
    /*public function editTimesheet($param, $mode, $action)
    {
       $idField = $param['id'];
       
       $valueField = $param['value']; 
       $valueField=trim($valueField);
       $valueField= strip_tags($valueField);
       
       $yearField = $param['year']; 
       $dateField = $param['date']; 
       $id_user=$param['user_id']; 
       $id_user=(int)$id_user;
       
       $num_overwork=(string)$param['num_overwork'];
      
       $dateField = explode('.', $dateField);
       $idField = explode('-', $idField);
       $field = $idField[0];
       $id = $idField[1];
       
        //if(!empty($valueField)){
            $db = $this->db;
            $user_joomla = & JFactory::getUser(); 
            $id_user0 = $user_joomla->id;  
            
            $item = new stdClass;
            if($action==='update'){
                $item->id = $id; 
            } if($action==='insert'){
                $item->id = NULL; 
            }
                   
            $item->id_user = $id_user;
            if( $action!=='update' && $mode!='login_hours' && $mode!='exit_hours'){
                $item->date_logged = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:00';
                $item->date_exit = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:01';
            }
            
            //$item->date_logged='';
            //$item->date_exit='';
            $item->date = $yearField.'-'.$dateField[1].'-'.$dateField[0];
            $item->ip=$_SERVER["REMOTE_ADDR"];
                
            if($mode!='description'){
                //7=>07:00, 07=>07:00, 07:=>07:00, 07:0=>07:00
                $valueField=$this->autocompletion($valueField);
            }
            
            switch($mode){
                case 'login_hours':
                    //date= date from client request plus new H:i
                    if($action!='update'){
                       // $item->date_exit = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 23:59:00';
                    }
                    $newValue = date('Y-m-d', strtotime($item->date)).' '.$valueField;
       
                    $item->date_logged = $newValue;
                    $item->date_logged_edit='1';                   
                break;
                case 'exit_hours':
                    if($action!='update'){
                        $item->date_logged = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:00';
                    }
                    $newValue = date('Y-m-d', strtotime($item->date)).' '.$valueField;
                     
                    $item->date_exit = $newValue;
                    $item->date_exit_edit='1';                   
                break;
                case 'total':
                    $item->new_hours = $valueField;               
                break;
                case 'daytime':
                    $item->new_daytime = $valueField;
                    $item->daytime_edit='1';
                    $item->daytime_edited_date=date('Y-m-d H:i:s');
                break;
                case 'afterwork':
                    $item->new_afterwork = $valueField;
                    $item->afterwork_edit='1';
                    $item->afterwork_edited_date=date('Y-m-d H:i:s');
                break;
                case 'overwork':
                    if(!empty($num_overwork)){
                        switch($num_overwork){
                            case '01': case '11':
                                $obj_name='new_overwork_1';
                                $item->$obj_name = $valueField;
                                
                                $obj_name='overwork_edit_1';
                                $item->$obj_name='1';
                                
                                $obj_name='overwork_edited_date_1';
                                $item->$obj_name=date('Y-m-d H:i:s');
                                unset($obj_name);
                            break;
                            case '12':
                                $obj_name='new_overwork_2';
                                $item->$obj_name = $valueField;
                                
                                $obj_name='overwork_edit_2';
                                $item->$obj_name='1';
                                
                                $obj_name='overwork_edited_date_2';
                                $item->$obj_name=date('Y-m-d H:i:s');
                                unset($obj_name);
                            break;
                        }
                       
                    }
                   
                break;
                case 'night_time':
                    $item->new_night_time = $valueField;
                    $item->night_time_edit='1';
                    $item->night_time_edited_date=date('Y-m-d H:i:s');
                break;
                case 'weekend':
                    //here
                    //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/edit_weekends.html', print_r($valueField, true), FILE_APPEND | LOCK_EX);
                    $item->new_weekend = $valueField;
                    $item->weekend_edit='1';
                    $item->weekend_edited_date=date('Y-m-d H:i:s');
                break;
                case 'holidays':
                    $item->new_holidays = $valueField;
                    $item->holidays_edit='1';
                    $item->holidays_edited_date=date('Y-m-d H:i:s');
                break;
                case 'description':
                    $item->note = $valueField;
                break;
            }
            
            if($action=='update'){
                $res=$this->db->updateObject('#__audit_time', $item, 'id');
            } if($action=='insert'){
                $res=$this->db->insertObject( '#__audit_time', $item, 'id' );
            }
                   
        //}  
       
        /*echo '<pre>param pay period';
        print_r($param);
        echo '</pre>';*/
        
        /*$is_enable_confirm_pp = AuditController::getFinalCombineConfirmAndPpStatus($id_user);
        if($is_enable_confirm_pp == '1' && $mode != 'description' && $param['task'] !='SyncPP01'){
            JLoader::register('AuditModelConfirm_time', JPATH_ROOT . '/components/com_audit/models/confirm_time.php');
            $model_confirm = JModelLegacy::getInstance('Confirm_time', 'AuditModel');
            $confirm_id = $this->getConfirmIdByPpId($id);
           
            //clone changes to confirm page(sync)
            if(!empty($confirm_id)){
                $param['id'] = $field.'-'.$confirm_id;
                //$param['date'].= '.'.date('Y');
                $param['task'] = 'SyncConfirm01';
                $model_confirm->addNewAuditTimeRow($param, $mode, $action);
            }
        }*//*
       
       
       
       $code=0;
       
       //need optimized
        switch($mode){
            case 'login_hours':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'exit_hours':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'total':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'daytime':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;  
            case 'afterwork':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'night_time':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'weekend':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'holidays':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'description':
                $result=[
                    'new_note'=>$valueField,//
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid(),
                    'action'=>$action
                ];  
            case 'overwork':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ]; 
            break;
           
        }
       
        return $result;
        
    }*/
    
    public function preparePayPeriodOfHtmlWithTextForHolidayPercent(string $html, int $user_id, string $lang) 
    {

        include_once($_SERVER['DOCUMENT_ROOT'] . '/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
        $dom = str_get_html($html);
        $q1 = $dom->find('table[class="pdf_not_width"]');

        $totalsJson = [];
        if (preg_match("#<!--json-dk-totals--(.*)--json-dk-totals-->#", $html, $arr)) {
            $totalsJson = json_decode($arr[1], true);
        }

        JLoader::register('AuditModelTime_Wages', JPATH_ROOT . '/components/com_audit/models/time_wages.php');
        $model_settings = JModelLegacy::getInstance('Time_Wages', 'AuditModel');
        
        $user = & JFactory::getUser($user_id);
        $sick_child_state = $model_settings->getSickChildStateAndConfig($user->owner_id);
        $sick_state = $model_settings->getSickState($user->owner_id);

        $result = [];
        foreach ($q1 as $table) {
            $dates = $table->find('*[class="api_raw_date"]');
            $totals = $table->find('*[class="api_custom_td_1"]');
            $rows_id = $table->find('*[id="hidden_row_id"]');
            $daytimes = $table->find('*[class="api_daytime"]');
            $daytime_sum = $table->find('*[class="app_api_tr_bottom_td_daytime"]', 0);
            
            $i = 0;
            foreach ($dates as $date) {
                $result[$i]['raw_date'] = $date->plaintext;
                //$result[$i]['date'] = $date->plaintext;

              
                $result[$i]['total'] = trim(strip_tags($totals[$i]));
                $result[$i]['daytime'] = trim(strip_tags($daytimes[$i]));
                //check cell edited or set color
                $total_edited = strripos($totals[$i], 'red-line');

                //check colors
                $total_color_red = strripos($totals[$i], 'pay_period_td_background_red');
                $total_color_yellow = strripos($totals[$i], 'pay_period_td_background_yellow');
                $total_color_green = strripos($totals[$i], 'pay_period_td_background_green');
                $total_color_blue = strripos($totals[$i], 'pay_period_td_background_blue');
                $total_color_gray = strripos($totals[$i], 'pay_period_td_background_gray');

                //set cell edited
                if ($total_edited == true) {
                    $result[$i]['total_edited'] = 1;
                }

                //set colors
                if ($total_color_red == true) {
                    $result[$i]['total_color'] = 'red';
                }
                if ($total_color_yellow == true) {
                    $result[$i]['total_color'] = 'yellow';
                }
                if ($total_color_green == true) {
                    $result[$i]['total_color'] = 'green';
                }
                if ($total_color_blue == true) {
                    $result[$i]['total_color'] = 'blue';
                }
                if ($total_color_gray == true) {
                    $result[$i]['total_color'] = 'gray';
                }

                if (!empty($rows_id[$i])) {
                    $result[$i]['row_id'] = trim($rows_id[$i]->getAttribute('value'));
                } else {
                    $result[$i]['row_id'] = '';
                   
                }

                $i++;
            }
        }
        $count = count($result);

        foreach ($dom->find('*[class="total-h"]') as $ee) {
            $result['global_totals']['total'] = trim($ee->plaintext);
        }
        foreach ($dom->find('*[class="t-daytime"]') as $ee) {
            $result['global_totals']['daytime'] = trim($ee->plaintext);
        }
        foreach ($dom->find('*[class="t-afterwork"]') as $ee) {
            $result['global_totals']['afterwork'] = trim($ee->plaintext);
        }
        foreach ($dom->find('*[class="t-night_time"]') as $ee) {
            $result['global_totals']['night_time'] = trim($ee->plaintext);
        }
        foreach ($dom->find('*[class="t-weekend"]') as $ee) {
            $result['global_totals']['weekend'] = trim($ee->plaintext);
        }
        foreach ($dom->find('*[class="t-holidays90"]') as $ee) {
            $result['global_totals']['holidays_90'] = trim($ee->plaintext);
        }
        foreach ($dom->find('*[class="t-holidays45"]') as $ee) {
            $result['global_totals']['holidays_45'] = trim($ee->plaintext);
        }
        if ($sick_state == '1') {
            foreach ($dom->find('*[class="t-holidays_sick"]') as $ee) {
                $result['global_totals']['sick'] = trim($ee->plaintext);
            }
        }
        if ($sick_child_state == '1') {
            foreach ($dom->find('*[class="t-sick_child"]') as $ee) {
                $result['global_totals']['sick_child'] = trim($ee->plaintext);
            }
        }
        foreach ($dom->find('*[class="t-breaks"]') as $ee) {
            $result['global_totals']['break'] = trim($ee->plaintext);
        }


        if (isset($totalsJson['daytime']))
            $result['global_totals']['daytime'] = $totalsJson['daytime']['total'];
        if (isset($totalsJson['after_hours']))
            $result['global_totals']['afterwork'] = $totalsJson['after_hours']['total'];
        if (isset($totalsJson['night']))
            $result['global_totals']['night_time'] = $totalsJson['night']['total'];
        if (isset($totalsJson['weekends']))
            $result['global_totals']['weekend'] = $totalsJson['weekends']['total'];
        if (isset($totalsJson['holidays_90']))
            $result['global_totals']['holidays_90'] = $totalsJson['holidays_90']['total'];
        if (isset($totalsJson['holidays_45']))
            $result['global_totals']['holidays_45'] = $totalsJson['holidays_45']['total'];
        if ($sick_state == '1') {
            if (isset($totalsJson['sick']))
                $result['global_totals']['sick'] = $totalsJson['sick']['total'];
        }
        if ($sick_child_state == '1') {
            if (isset($totalsJson['sick_child']))
                $result['global_totals']['sick_child'] = $totalsJson['sick_child']['total'];
        }
        $result['daytime_sum'] = $daytime_sum->plaintext;
        //$result['raw'] = $totalsJson;

        JLoader::register('AuditModelRules', JPATH_ROOT . '/components/com_audit/models/rules.php');

        $model_rules = JModelLegacy::getInstance('Rules', 'AuditModel');
        $rule_mode = $model_rules->getUserRuleForText($user->id);
        $header_texts_obj = $model_rules->getTexts($rule_mode['mode'], $rule_mode['rule_id'], $lang);

        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }

        $result['global_totals']['total_txt'] = JText::_('COM_AUDIT_OVERVIEW_TIME_TOTAL_LOGIN');
        $result['global_totals']['daytime_txt'] = $header_texts_obj->daytime_text;
        $result['global_totals']['afterwork_txt'] = $header_texts_obj->after_hours_text;
        $result['global_totals']['night_time_txt'] = $header_texts_obj->night_time_text;
        $result['global_totals']['weekend_txt'] = $header_texts_obj->weekends_text;
        $result['global_totals']['holidays_90_txt'] = JText::_('COM_AUDIT_PAY_PERIOD_HOLIDAYS') . ' 90%';
        $result['global_totals']['holidays_45_txt'] = JText::_('COM_AUDIT_PAY_PERIOD_HOLIDAYS') . ' 45%';
        $result['global_totals']['sick_txt'] = JText::_('COM_AUDIT_TIME_DK_HEADER_SICK');
        $result['global_totals']['sick_child_txt'] = JText::_('COM_AUDIT_TIME_DK_HEADER_SICK_CHILD');
        $result['global_totals']['break_txt'] = JText::_('COM_AUDIT_PAY_PERIOD_TOTAL_BREAK2');

        return $result;
    }

    
    public function setNoteInPayPeriod(int $id, $text, int $user_id)
    {
        $query = "SELECT `note` FROM #__audit_time WHERE `id` = '" . $id . "' AND `id_user` = '" . $user_id . "'";     
        $this->db->setQuery($query);
        $old_note = $this->db->loadResult();
                
        $item = new stdClass();
        $item->id = $id;
        $item->note = $old_note . ' ' . $this->db->escape($text);
      
        if($this->db->updateObject('#__audit_time', $item, 'id')){
            $is_enable_confirm_pp = AuditController::getFinalCombineConfirmAndPpStatus($id_user);
        if($is_enable_confirm_pp == '1' && $mode != 'description' && $param['task'] !='SyncPP01'){
            JLoader::register('AuditModelConfirm_time', JPATH_ROOT . '/components/com_audit/models/confirm_time.php');
            $model_confirm = JModelLegacy::getInstance('Confirm_time', 'AuditModel');
            $confirm_id = $this->getConfirmIdByPpId($id);
           
            //clone changes to confirm page(sync)
            if(!empty($confirm_id)){
                $param['id'] = $field.'-'.$confirm_id;
                //$param['date'].= '.'.date('Y');
                $param['task'] = 'SyncConfirm01';
                $model_confirm->addNewAuditTimeRow($param, $mode, $action);
            }
        }
        }         
    }
    
    public function clearRoute(int $pp_id)
    {
        
    }
    
    public function prepareConfirmHtml($html, $user_id, $lang, $date_pp, $row_id)
    {
        include_once($_SERVER['DOCUMENT_ROOT'].'/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
        $dom = str_get_html($html);
        $q0 = $dom->find('div[id="time_user-'.$user_id.'"]');
        //$q1  = $dom->find('table[class="pdf_not_width"]');
        
        $user = & JFactory::getUser($user_id);
        if(in_array(9, $user->groups)){
            $lock_fields=1;
        }
      
        $result=[];
        foreach ($q0 as $user_div) {

            foreach ($user_div->find('table[class="pdf_not_width"]') as $table) {
                $row = $table->find('tr[id="app-api-row-id-' . $row_id . '"]');

                foreach ($row as $item) {
                    $dates = $item->find('*[class="api_date"]');
                    $totals = $item->find('*[class="api_total"]');

                    $i = 0;

                    foreach ($dates as $date) {
                        $result[$i]['confirm_id'] = $row_id;
                        $result[$i]['date'] = $date->plaintext;
                        $result[$i]['total'] = trim(strip_tags($totals[$i]));

                        $i++;
                    }
                }
            }
        }


        return $result;
    }
}
