<?php

/* ini_set('error_reporting', E_ALL);
  ini_set('display_errors', 1);
  ini_set('display_startup_errors', 1); */

defined('_JEXEC') or die;

class AuditModelCtapi extends JModelLegacy {

    private $db;
    private $app;
    private $url = "http://api.curiooffice.com/coapi.json";

    public function __construct() {
        parent::__construct();
        $this->db   =   JFactory::getDBO();
        $this->app  =   JFactory::getApplication();
        $this->user =   JFactory::getUser();
    }
    
    
    
    
    public function getCloudAccessToken() {        
        $user   =   JFactory::getUser();        
        $token  =   $user->api_token;        
        try {
            $data =  $this->call("cloud.getCompanyCloudAccessToken", array($token));
        } catch (Exception $e) {            
            $data   =   array("status"=>0,"error"=>$e->getMessage());
        }
        return $data;
    }
    
    public function setCloudAccessToken($accessToken) {        
        $user   =   JFactory::getUser();        
        $token  =   $user->api_token;        
        try {
            $data =  $this->call("cloud.setCompanyCloudAccessToken", array($token,$accessToken));
        } catch (Exception $e) {            
            $data   =   array("status"=>0,"error"=>$e->getMessage());
        }
        return $data;
    }
    
    public function loadFilesForTask($taskIds) {        
        $files  =  array();        
        $user   =   JFactory::getUser();        
        $token  =   $user->api_token;
        
        $type   =   "ct_task";
        try {
            $data =  $this->call("cloud.getFiles", array($token, $type, $taskIds, 1));
            if(empty($data) == false && is_array($data['list'])) {
                foreach ($data['list'] as $f) {
                    $files[] = $f;
                }
            }
        } catch (Exception $e) {
            
        }
        return $files;
    }
    
    public function loadFilesForDkTask($taskIds) {        
        $files  =  array();        
        $user   =   JFactory::getUser();        
        $token  =   $user->api_token;
        
        $type   =   "ct_task_from_dk";
        try {
            $data =  $this->call("cloud.getFiles", array($token, $type, $taskIds, 1));
            if(empty($data) == false && is_array($data['list'])) {
                foreach ($data['list'] as $f) {
                    $files[] = $f;
                }
            }
        } catch (Exception $e) {
            
        }
        return $files;
    }

    public function __call($name, $arguments) {
        return $this->call($name, $arguments);
    }

    public function cloudUpload($task_id, $file_path) {
        
        $manager=JFactory::getUser($this->user->owner_id);
        $company=$manager->company;
        
        $token = 'caadac9887cbb60cf81820014458087793e1aef1634beef8ce00a4a2b5bbf3979484e284ddfd559916bcaa420d55ca2eea24cebba6a52fd71f46689a5103f870';
        
        $token = (isset($token['token']) && strlen($token['token']) > 1) ? $token['token'] : "";
        echo "<pre>";
        echo "<hr>";
        
        //$filename=JPATH_BASE.DS.'test_app_start_stop_download'.DS.'stop.jpg';
                
        $file= file_get_contents($file_path);
        $fileContent = base64_encode($file);
        $name = "TaskFile-" . date("YmdIs") . ".jpg";
        $type = "ct_task";
        $refId = (int)$task_id;
        $folder = "test";

        $data = $this->call("cloud.uploadFile", array($token, $fileContent, $name, $type, $refId, $folder));
        var_dump($data);

        exit;
        JFactory::getApplication()->close();
    }
    
    public function cloud_upload_image($task_id) {
        //$manager=JFactory::getUser($this->user->owner_id);
        //$company=$manager->company;
        
        //$token  = $this->call("user.auth", array("uxd","800"));
        
        //$token  = (isset($token['token']) && strlen($token['token']) > 1) ? $token['token'] : "";
        echo "<pre>";
        echo "<hr>";
        $token = $this->user->api_token;
        //echo $token.PHP_EOL;
        //exit;
        
        var_dump($token);
        $path  = JPATH_ROOT."/test_app_start_stop_download/stop.jpg";
        $fileContent    =   base64_encode(file_get_contents($path));
        $name = "TaskFile-" . date("YmdIs") . ".jpg";
        $type = "ct_task";
        $refId = (int)$task_id;
        
        $folder         =   "tasks";
        $data  = $this->call("cloud.uploadFile",array($token,$fileContent,$name,$type,$refId,$folder));        
        var_dump($data);
         
        JFactory::getApplication()->close();
    }
    
    public function cloudUploadImageForDk($task_id) {
        //$manager=JFactory::getUser($this->user->owner_id);
        //$company=$manager->company;
        
        //$token  = $this->call("user.auth", array("uxd","800"));
        
        //$token  = (isset($token['token']) && strlen($token['token']) > 1) ? $token['token'] : "";
        echo "<pre>";
        echo "<hr>";
        $token = $this->user->api_token;
        //echo $token.PHP_EOL;
        //exit;
        
        var_dump($token);
        $path  = JPATH_ROOT."/images/chess-wallpaper.jpg";
        $fileContent    =   base64_encode(file_get_contents($path));
        $name = "DkTaskFile-" . date("YmdIs") . ".jpg";
        $type = "ct_task_from_dk";
        $refId = (int)$task_id;
        
        $folder         =   "dk_tasks";
        $data  = $this->call("cloud.uploadFile",array($token, $fileContent, $name, $type, $refId, $folder));        
        var_dump($data);
         
        JFactory::getApplication()->close();
    }

    /**
     * 
     * @param String $method
     * @param Array $params
     */
    public function call($method, $params = array()) {
        if (empty($params))
            $params = array();
        return $this->makeRequest($method, $params);
    }

    private function makeRequest($method, $params) {

        $params2 = array();
        foreach ($params as $p) {
            $params2[] = $p;
        }
        $params = $params2;
        $context = stream_context_create(
                array(
                    "http" => array(
                        "header" => "Content-type: text/json\r\n",
                        "method" => "POST",
                        'max_redirects' => 3,
                        'follow_location' => true,
                        'timeout' => 10,
                        "content" => json_encode(
                                array(
                                    "id" => uniqid(),
                                    "jsonrpc" => '2.0',
                                    "method" => $method,
                                    "params" => $params
                                )
                        )
                    ),
                    'ssl' => array(
                        'verify_peer' => false,
                        'verify_peer_name' => false
                    )
                )
        );
        $data = @file_get_contents($this->url, false, $context);
        $data = json_decode($data, true);
        if (empty($data))
            return null;
        if (isset($data['result']))
            return $data['result'];
        return null;
    }
    
    public function checkData($datatype, $config)
    {
        $global_api_resp  = $this->call("user.auth",[
            $config['company'], 
            $config['password']
        ]);
        if($global_api_resp['status'] == '1'){
            return '0';
        } elseif($global_api_resp['status'] == '0'){
            return '1';
        } 
        //$uid    = (isset($token['uid']) && strlen($token['uid']) > 1) ? $token['uid'] : "";
        //$token  = (isset($token['token']) && strlen($token['token']) > 1) ? $token['token'] : "";
        
        /*echo '<pre>';
        print_r($global_api_resp);
        echo '</pre>';*/
        
        /*$data  = $this->api->call("user.getList", array($token));
        echo "Users List....\r\n";
        foreach ($data['list'] as $user) {
            var_dump($user);
        }*/
       
    }

    public function getFilePreview($file_url)
    {
        
    }
    
    private function resizeImage($path, $name) 
    {
        include $_SERVER['DOCUMENT_ROOT'].'/app_api/php-image-resize-master/lib/ImageResize.php';
         
        $image = new Gumlet\ImageResize($path);
        $image->resizeToWidth(30);
        
        jimport( 'joomla.filesystem.file' );
            
        if (JFile::exists($path)) {
            JFile::delete($path);
        }
           
            
        $image->save($path);
    } 
    
    public function getMessages($user_obj)
    {
        $query = 'SELECT `id`, `user_id`, `text_en`, `text_is`, `is_read`, `timestamp`, `date_create` FROM #__app_api_messages WHERE `user_id` = "'.$user_obj->id.'" AND `is_read` = "0" AND `status` = "1"  AND `message_type` = "shifts_changes" ORDER BY `id` DESC';
        $this->db->setQuery($query);
        $messages = $this->db->loadObjectList();

        return $messages;
    }
    
    public function markMessagesAsRead($user_obj, $marked_messages_arr)
    {
        $query = "UPDATE #__app_api_messages SET `is_read` = '1' WHERE `id` in (".join(",", $marked_messages_arr).") AND `user_id` = '$user_obj->id'";
        $this->db->setQuery($query);
        return $this->db->query();  
    }
    
    public function cloudUploadImageForUnicontaTask($task_id) {

        echo "<pre>";
        echo "<hr>";
        $token = $this->user->api_token;
        //echo $token.PHP_EOL;
        //exit;

        var_dump($token);
        $path = JPATH_ROOT . "/test_app_start_stop_download/stop.jpg";
        $fileContent = base64_encode(file_get_contents($path));
        $name = "TaskFile-" . date("YmdIs") . ".jpg";
        $type = "ct_uniconta_task";
        $refId = (int) $task_id;

        $folder = "taskstest";
        $data = $this->call("cloud.uploadFile", array($token, $fileContent, $name, $type, $refId, $folder));
        var_dump($data);

        JFactory::getApplication()->close();
    }
    
    public function loadFilesForUnicontaTask($taskIds) {        
        $files  =  array();        
        $user   =   JFactory::getUser();        
        $token  =   $user->api_token;
        
        $type   =   "ct_uniconta_task";
        try {
            $data =  $this->call("cloud.getFiles", array($token, $type, $taskIds, 1));
            if(empty($data) == false && is_array($data['list'])) {
                foreach ($data['list'] as $f) {
                    $files[] = $f;
                }
            }
        } catch (Exception $e) {
            
        }
        return $files;
    }

}
