<?php
/*ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);*/
// No direct access

defined('_JEXEC') or die;

/**

 * @author

 */
class AuditModelConfirm_time extends JModelLegacy {

    public function __construct() {
        parent::__construct();

        $this->db = &JFactory::getDBO();
        $this->app = JFactory::getApplication();
        $this->doc = JFactory::getDocument();
        $this->server_path = $_SERVER['DOCUMENT_ROOT'];
        $this->user = & JFactory::getUser();
        $this->lang = & JFactory::getLanguage();
        $this->sitename = empty($_SERVER['HTTPS'])?'http://':'https://'.$_SERVER['SERVER_NAME'];
        $this->config = &JFactory::getConfig();
        $this->enable_task_manager_dk_api = $this->config->get('enable_task_manager_dk_api');
        $this->enable_uniconta_tasks = $this->config->get('enable_uniconta_tasks');
        $this->uniconta_table_name = '#__uniconta_tasks';
        $this->subtask_table_name = '#__uniconta_subtasks';
    }

    public static function getManagerUser($owner_id) {
        $db = & JFactory::getDBO();
        $query = "SELECT `id` FROM #__users WHERE owner_id = '$owner_id'";
        $db->setQuery($query);
        $data = $db->loadObjectList();

        $res='';
        if(!empty($data)){
            foreach($data as $one_user){
               $res.=$one_user->id.',';
            }
        }
        $res=rtrim($res, ',');

        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/confirm_time.html', print_r($res, true), FILE_APPEND | LOCK_EX);
        return $res;
    }

    private function compare($a, $b)
    {
        //$alphabet = 'aąbcćdeęfghijklłmnnoóqprstuvwxyzźż'; // i used polish letters
        $alphabet =  'aábcdðeéfghiíjklmnoópqrstuúvwxyýzþæö';

        $a = mb_strtolower($a->username0);
        $b = mb_strtolower($b->username0);

        for ($i = 0; $i < mb_strlen($a); $i++) {
            if (mb_substr($a, $i, 1) == mb_substr($b, $i, 1)) {
                continue;
            }
            if ($i > mb_strlen($b)) {
                return 1;
            }
            if (mb_strpos($alphabet, mb_substr($a, $i, 1)) > mb_strpos($alphabet, mb_substr($b, $i, 1))) {
                return 1;
            } else {
                return -1;
            }
        }
    }

    public function getManagerUsersObj($mode, $u_id) {
        if($mode!='api_html'){
            $owner_id=$this->user->owner_id;
        } else{
            $user=JFactory::getUser($u_id);
            $owner_id=$user->owner_id;
        }
        $db = & JFactory::getDBO();
        $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id'";
        $db->setQuery($query);
        $data = $db->loadObjectList();

        usort($data, [$this, 'compare']);
        ksort($data);

        return $data;
    }

    public function getAllUsersObj() {

        $query = "SELECT * FROM #__users";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();


        return $data;
    }

    public function getManagerUserObjWithSearch($mode, $u_id, $username_search) {
        if($mode!='api_html'){
            $owner_id=$this->user->owner_id;
        } else{
            $user=JFactory::getUser($u_id);
            $owner_id=$user->owner_id;
        }
        $db = & JFactory::getDBO();

        $search=$db->escape(trim($username_search));
        $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND (`username0`='$search' OR `username`='$search')";


        $db->setQuery($query);
        $data = $db->loadObjectList();
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/confirm_time.html', print_r($data, true), FILE_APPEND | LOCK_EX);

        if(empty($data)){
            return 'code-0';
        }

        return $data;
    }



    //ajax load default2.php
    public static function getTimeByPeriod($id_user) {
        $start = date('Y-m-d');
        $end = date('Y-m-d', strtotime($_REQUEST['to']));
        $current_date=date('Y-m-d');
		$statesql = '';
		if($_REQUEST['state']=='true'){
			$statesql = "AND is_confirm=0";
		}


        $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$id_user' AND `date` = '$current_date' $statesql ORDER BY `date_logged` ASC";
       // $query = "SELECT * FROM #__audit_time_confirm WHERE id_user IN (".$user_list.") AND date= '$current_date' ORDER BY date_logged ASC";
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/confirm_time.html', print_r($query, true), FILE_APPEND | LOCK_EX);
        $db = & JFactory::getDBO();
        $db->setQuery($query);
        $data = $db->loadObjectList();

        if(isset($_REQUEST['dep_obj'])){
	        if($_REQUEST['dep_obj']!='[]'){
	        	$data=self::filterByDep($data, json_decode($_REQUEST['dep_obj']));
	        }
        }

       // file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/confirm_time.html', print_r($query, true), FILE_APPEND | LOCK_EX);

        // Load period
        $from = new DateTime($start);
        $dayN = date('t', strtotime($start));
        $to = new DateTime(date('Y-m-d', strtotime($current_date . ' +' . $dayN . 'day')));
        $period = new DatePeriod($from, new DateInterval('P1D'), $to);
        //return $period;
        //exit;
        return self::mapToDatesConfirmTime($period, $data);
    }

    //ajax load default2.php if select date in calendar
    public static function getTimeByPeriodOneDate($id_user, $date) {
       //file_put_contents($_SERVER['DOCUMENT_ROOT'].'/logs/confirm_time.html', print_r('trigger', true), FILE_APPEND | LOCK_EX);

        $start = date('Y-m-d');
        $end = date('Y-m-d', strtotime($_REQUEST['to']));
        $current_date=date('Y-m-d');

        //$input_date_obj=DateTime::createFromFormat('Y-m-d', $date);
        $db = & JFactory::getDBO();

        $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$id_user' AND `date` = '".$date."' ORDER BY `date_logged` ASC";
        $db->setQuery($query);
        $data = $db->loadObjectList();

        //file_put_contents($_SERVER['DOCUMENT_ROOT'].'/logs/confirm_time.html', print_r($_REQUEST, true), FILE_APPEND | LOCK_EX);

        // Load period
        $from = new DateTime($date);
        $dayN = date('t', strtotime($date));
        $to = new DateTime(date('Y-m-d', strtotime($current_date . ' +' . $dayN . 'day')));
        $period = new DatePeriod($from, new DateInterval('P1D'), $to);
        //return $period;
        //exit;
        return self::mapToDatesConfirmTime($period, $data);
    }

    public static function getTimeByPeriodOneDateWithState($id_user, $date, $state) {
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/confirm_time.html', print_r('one call '.gettype($state), true), FILE_APPEND | LOCK_EX);

        $start = date('Y-m-d');
        $end = date('Y-m-d', strtotime($_REQUEST['to']));
        $current_date=date('Y-m-d');

        //$input_date_obj=DateTime::createFromFormat('Y-m-d', $date);
        $db = & JFactory::getDBO();

        if($state=='0'){
            $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$id_user' AND `date` = '".$date."' AND `is_confirm`='".$state."' ORDER BY `date_logged` ASC";
        } else{
            $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$id_user' AND `date` = '".$date."' ORDER BY `date_logged` ASC";
        }

        $db->setQuery($query);
        $data = $db->loadObjectList();

        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/confirm_time.html', print_r($query, true), FILE_APPEND | LOCK_EX);

        // Load period
        $from = new DateTime($date);
        $dayN = date('t', strtotime($date));
        $to = new DateTime(date('Y-m-d', strtotime($current_date . ' +' . $dayN . 'day')));
        $period = new DatePeriod($from, new DateInterval('P1D'), $to);
        //return $period;
        //exit;
        return self::mapToDatesConfirmTime($period, $data);
    }

    public static function getTimeByPeriodWithDepartament($id_user, $date, $dep) {


        $start = date('Y-m-d');
        $end = date('Y-m-d', strtotime($_REQUEST['to']));
        $current_date=date('Y-m-d');

        //$input_date_obj=DateTime::createFromFormat('Y-m-d', $date);
        $db = & JFactory::getDBO();

        if(empty($date)){
            $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$id_user' AND `date` = '".$current_date."' ORDER BY `date_logged` ASC";
        } else{
            $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$id_user' AND `date` = '".$date."' ORDER BY `date_logged` ASC";
        }
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/confirm_time.html', print_r($query, true), FILE_APPEND | LOCK_EX);

        $db->setQuery($query);
        $data = $db->loadObjectList();


        $filtered_data=self::filterByDep($data, $dep);
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/confirm_time.html', print_r($filtered_data, true), FILE_APPEND | LOCK_EX);

        if(empty($date)){
            $from = new DateTime($start);
            $dayN = date('t', strtotime($start));
            $to = new DateTime(date('Y-m-d', strtotime($current_date . ' +' . $dayN . 'day')));
            $period = new DatePeriod($from, new DateInterval('P1D'), $to);
            //return $period;
            //exit;
            return self::mapToDatesConfirmTime($period, $filtered_data);

        } else{
            $from = new DateTime($date);
            $dayN = date('t', strtotime($date));
            $to = new DateTime(date('Y-m-d', strtotime($current_date . ' +' . $dayN . 'day')));
            $period = new DatePeriod($from, new DateInterval('P1D'), $to);
            //return $period;
            //exit;
            return self::mapToDatesConfirmTime($period, $filtered_data);
        }

    }

    public static function getTimeByPeriodOneDateSearchName($id_user, $date, $incl_all) {
        $start = date('Y-m-d');
        $end = date('Y-m-d', strtotime($_REQUEST['to']));
        $current_date=date('Y-m-d');

        $db = & JFactory::getDBO();

        if($incl_all==='false'){
            $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$id_user' AND `date` = '".$date."' ORDER BY `date_logged` ASC";
        } else{
            $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$id_user' ORDER BY `date_logged` ASC";
        }

        $db->setQuery($query);
        $data = $db->loadObjectList();

        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/confirm_time.html', print_r($data, true), FILE_APPEND | LOCK_EX);

        if($incl_all==='false'){
            // Load period
            $from = new DateTime($date);
            $dayN = date('t', strtotime($date));
            $to = new DateTime(date('Y-m-d', strtotime($current_date . ' +' . $dayN . 'day')));
            $period = new DatePeriod($from, new DateInterval('P1D'), $to);
            //return $period;
            //exit;
            $res=self::mapToDatesConfirmTime($period, $data);
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/confirm_time.html', print_r($res, true), FILE_APPEND | LOCK_EX);
            /*if(empty($res)){
                return 'empty';
            } else{
                return $res;
            }*/
            return $res;
        } else{
            // Load all period
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/confirm_time.html', print_r($date, true), FILE_APPEND | LOCK_EX);
            $from = new DateTime($data[0]->date);
            $dayN = date('t', strtotime($data[0]->date));
            $to = new DateTime(date('Y-m-d', strtotime($current_date . ' +' . $dayN . 'day')));
            $period = new DatePeriod($from, new DateInterval('P1D'), $to);
            //return $period;
            //exit;
            return self::mapToDatesConfirmTime($period, $data);
        }

    }

    public static function getTimeByPeriodOneDateSearchDescr($id_user, $date, $incl_all, $note) {
        $start = date('Y-m-d');
        $end = date('Y-m-d', strtotime($_REQUEST['to']));
        $current_date=date('Y-m-d');

        $db = & JFactory::getDBO();

        if($incl_all==='false'){
            $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$id_user' AND `date` = '".$date."' AND `note` LIKE BINARY '%$note%' ORDER BY `date_logged` ASC";
        } else{
            $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$id_user' AND `note` LIKE BINARY '%$note%' ORDER BY `date_logged` ASC";
        }

        $db->setQuery($query);
        $data = $db->loadObjectList();

        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/confirm_time.html', print_r($data, true), FILE_APPEND | LOCK_EX);

        if($incl_all==='false'){
            // Load period
            $from = new DateTime($date);
            $dayN = date('t', strtotime($date));
            $to = new DateTime(date('Y-m-d', strtotime($current_date . ' +' . $dayN . 'day')));
            $period = new DatePeriod($from, new DateInterval('P1D'), $to);
            //return $period;
            //exit;
            $res=self::mapToDatesConfirmTime($period, $data);
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/confirm_time.html', print_r($res, true), FILE_APPEND | LOCK_EX);
            /*if(empty($res)){
                return 'empty';
            } else{
                return $res;
            }*/
            return $res;
        } else{
            // Load all period
            file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/confirm_time.html', print_r($date, true), FILE_APPEND | LOCK_EX);
            $from = new DateTime($data[0]->date);
            $dayN = date('t', strtotime($data[0]->date));
            $to = new DateTime(date('Y-m-d', strtotime($current_date . ' +' . $dayN . 'day')));
            $period = new DatePeriod($from, new DateInterval('P1D'), $to);
            //return $period;
            //exit;
            return self::mapToDatesConfirmTimeSearch($period, $data);
        }

    }

    private static function mapToDatesConfirmTimeSearch($period, $data) {
        // Load audits
        $audits = array();
        foreach ($data as $val) {
            $d = date('Y-m-d', strtotime($val->date));
            $audits[$d][] = $val;
        }

        // Merge audits and period. Days with no audits will have empty array
        $result = array();
        $arrayOfDates = array();
        foreach ($period as $val)
        {
            $daykey = $val->format('Y-m-d');
            $result[$daykey] = array(); // Default empty
            if (isset($audits[$daykey]))
            {
                // Audit exits for day
                $result[$daykey] = $audits[$daykey];
                foreach ($audits[$daykey] as $val)
                {
                    //file_put_contents('/home/curiotime/ultima.curiotime.com/logs/collect.html', print_r($val, true), FILE_APPEND | LOCK_EX);
                    if(!empty($val->note) || !empty($val->date_logged)){
                       $arrayOfDates[] = array(
                            'date' => $val->date,
                            'data' => $val
                        );
                    }

                }
            }
            else
            {
                // One day
                /*$arrayOfDates[] = array(
                    'date' => $val->format('Y-m-d'),
                    'data' => null
                );*/
            }
        }
        //krsort($arrayOfDates);
        //file_put_contents('/home/curiotime/ultima.curiotime.com/logs/collect.html', print_r($arrayOfDates, true), FILE_APPEND | LOCK_EX);
        return array('dayNumber' => $arrayOfDates);
    }

    public static function getTimeByPeriodWithDepartamentAndState($id_user, $date, $dep, $state) {


        $start = date('Y-m-d');
        $end = date('Y-m-d', strtotime($_REQUEST['to']));
        $current_date=date('Y-m-d');

        //$input_date_obj=DateTime::createFromFormat('Y-m-d', $date);
        $db = & JFactory::getDBO();

        if(empty($date)){
            if($state=='0'){
                $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$id_user' AND `date` = '".$current_date."' AND `is_confirm`='".$state."' ORDER BY `date_logged` ASC";
            } else{
                $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$id_user' AND `date` = '".$current_date."' ORDER BY `date_logged` ASC";
            }

            //old code
            //$query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$id_user' AND `date` = '".$current_date."' ORDER BY `date_logged` ASC";
        } else{
             if($state=='0'){
                $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$id_user' AND `date` = '".$date."' AND `is_confirm`='".$state."' ORDER BY `date_logged` ASC";
            } else{
                $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$id_user' AND `date` = '".$date."' ORDER BY `date_logged` ASC";
            }

            //old code
            //$query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$id_user' AND `date` = '".$date."' ORDER BY `date_logged` ASC";
        }


        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/confirm_time.html', print_r($query, true), FILE_APPEND | LOCK_EX);

        $db->setQuery($query);
        $data = $db->loadObjectList();


        $filtered_data=self::filterByDep($data, $dep);
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/confirm_time.html', print_r($filtered_data, true), FILE_APPEND | LOCK_EX);

        if(empty($date)){
            $from = new DateTime($start);
            $dayN = date('t', strtotime($start));
            $to = new DateTime(date('Y-m-d', strtotime($current_date . ' +' . $dayN . 'day')));
            $period = new DatePeriod($from, new DateInterval('P1D'), $to);
            //return $period;
            //exit;
            return self::mapToDatesConfirmTime($period, $filtered_data);

        } else{
            $from = new DateTime($date);
            $dayN = date('t', strtotime($date));
            $to = new DateTime(date('Y-m-d', strtotime($current_date . ' +' . $dayN . 'day')));
            $period = new DatePeriod($from, new DateInterval('P1D'), $to);
            //return $period;
            //exit;
            return self::mapToDatesConfirmTime($period, $filtered_data);
        }

    }

    private static function filterByDep($data, $dep_arr) {
        $new_data=[];
        $i=0;
       //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/confirm_time.html', print_r($dep_arr, true), FILE_APPEND | LOCK_EX);
        foreach($data as $one_item){
            $user=&JFactory::getUser($one_item->id_user);
            if(in_array($user->group_user, $dep_arr)){
                $new_data[$i]=$one_item;
              /* foreach($one_item as $k=>$v){
                   $new_data[$i]->k=$v;
               }*/
            }
            $i++;
        }

        return $new_data;
    }

    public static function getTime($param, $user_id) {
        $user = & JFactory::getUser();

        if (in_array(8, $user->groups) || in_array(6, $user->groups)) {

            if (!empty($_REQUEST['u_id'])) {

                //$id_user = (int) $_REQUEST['u_id'];
            } else {

                //$id_user = $user->id;
            }
            //$user_list=self::getManagerUser($user->owner_id);
        } else {

            //$id_user = $user->id;
        }

        $date = date('Y-m');
        $start = date('Y-m', strtotime('first day of previous month'));
        $start .= '-25';
        $end = date('Y-m');
        $end .= '-25';

        // Load Audits last 25 days
        $query = "SELECT * FROM #__audit_time WHERE id_user = '$user_id' AND date BETWEEN '$start' AND '$end' ORDER BY date";
        //$query = "SELECT * FROM #__audit_time WHERE id_user IN (".$user_list.") AND date= '$start' ORDER BY date";
        $db = & JFactory::getDBO();
        $db->setQuery($query);
        $data = $db->loadObjectList();

        // Load period
        $from = new DateTime($start);
        $dayN = date('t', strtotime($start));
        $to = new DateTime($end);
        $period = new DatePeriod($from, new DateInterval('P1D'), $to);

        return self::mapToDates($period, $data);
    }

    public function __toString() {
        return 'dd';
    }


    /*public static function getTimeByPeriod3() {

        if ($_REQUEST['u_id'] > 0) {

            $user = & JFactory::getUser($_REQUEST['u_id']);
        } else {

            $user = & JFactory::getUser();
        }

        if (in_array(8, $user->groups) || in_array(6, $user->groups)) {

            if ($_REQUEST['u_id'] > 0) {

                $id_user = (int) $_REQUEST['u_id'];
            } else {

                $id_user = $user->id;
            }
        } else {

            $id_user = $user->id;
        }

//             if(in_array(2, $user->groups)){
//                $id_user = @$user->owner_id;
//            }


        $start = date('Y-m-d', strtotime($_REQUEST['from']));
        $end = date('Y-m-d', strtotime($_REQUEST['to']));
        $note1 = trim($_REQUEST['note']);
        //$note=strip_tags($note1);

        $db = & JFactory::getDBO();
        $note = $db->escape(trim($_REQUEST['note']));

        // Load Audits by date range
        $query = "SELECT * FROM #__audit_time WHERE `id_user` = '$id_user' AND `date` BETWEEN '$start' AND '$end' AND `note`  LIKE BINARY '%$note%' ORDER BY `date_logged` ASC";
        $query1 = $query;



        $db->setQuery($query);
        $data = $db->loadObjectList();





        if (count($data) === 0) {

            return array('dayNumber' => 'no_search_result');
            //echo '<p class="no_result_pp_search">No result found</p>';
            //JFactory::getApplication()->close();
        } else {
            // Load period
            $from = new DateTime($start);
            $dayN = date('t', strtotime($start));
            $to = new DateTime(date('Y-m-d', strtotime($start . ' +' . $dayN . 'day')));
            $period = new DatePeriod($from, new DateInterval('P1D'), $to);
            //return $period;
            //exit;
            $map_array = self::mapToDatesSearch($period, $data);

            $query1 .= ' count_dates=' . count($data) . ' data=' . print_r($data, true) . ' mapArray=' . print_r($map_array, true);
            $query1 .= "\n";
            //file_put_contents('getTimeByPeriod3_log.txt', $query1, FILE_APPEND | LOCK_EX);
        }




        return $map_array;
    }*/





    public static function addLogRow($id_user, $start, $end, $query, $groups) {
        $user = & JFactory::getUser($id_user);
        $db = & JFactory::getDBO();

        $owner_id = $user->owner_id;
        $date = date('d-m-Y H:i:s');

        $item = new stdClass();
        $item->id = null;
        $item->id_user = $id_user;
        $item->owner_id = $owner_id;
        $item->from0 = $start;
        $item->to0 = $end;
        $item->query = $query;
        $item->date = $date;
        $item->selected_group = $groups;

        $db->insertObject('#__audit_collect_from_to_log', $item);
    }

    private static function mapToDatesSearch($period, $data) {
        // Load audits
        $audits = array();
        foreach ($data as $val) {
            $d = date('Y-m-d', strtotime($val->date));
            $audits[$d][] = $val;
        }

        // Merge audits and period. Days with no audits will have empty array
        $result = array();
        $arrayOfDates = array();
        foreach ($period as $val) {
            $daykey = $val->format('Y-m-d');
            $result[$daykey] = array(); // Default empty
            if (isset($audits[$daykey])) {
                // Audit exits for day
                $result[$daykey] = $audits[$daykey];
                foreach ($audits[$daykey] as $val) {
                    //file_put_contents('/home/curiotime/ultima.curiotime.com/logs/collect.html', print_r($val, true), FILE_APPEND | LOCK_EX);
                    if (!empty($val->note)) {
                        $arrayOfDates[] = array(
                            'date' => $val->date,
                            'data' => $val
                        );
                    }
                }
            } else {
                // One day
                /* $arrayOfDates[] = array(
                  'date' => $val->format('Y-m-d'),
                  'data' => null
                  ); */
            }
        }
        //krsort($arrayOfDates);
        //file_put_contents('/home/curiotime/ultima.curiotime.com/logs/collect.html', print_r($arrayOfDates, true), FILE_APPEND | LOCK_EX);
        return array('dayNumber' => $arrayOfDates);
    }

    private static function mapToDatesSearchCollect($period, $data) {
        // Load audits
        $audits = array();
        foreach ($data as $val) {
            $d = date('Y-m-d', strtotime($val->date));
            $audits[$d][] = $val;
        }

        // Merge audits and period. Days with no audits will have empty array
        $result = array();
        $arrayOfDates = array();
        foreach ($period as $val) {
            $daykey = $val->format('Y-m-d');
            $result[$daykey] = array(); // Default empty
            if (isset($audits[$daykey])) {
                // Audit exits for day
                $result[$daykey] = $audits[$daykey];
                foreach ($audits[$daykey] as $val) {
                    //file_put_contents('/home/curiotime/ultima.curiotime.com/logs/collect.html', print_r($val, true), FILE_APPEND | LOCK_EX);
                    if (!empty($val->note) || !empty($val->date_logged)) {
                        $arrayOfDates[] = array(
                            'date' => $val->date,
                            'data' => $val
                        );
                    }
                }
            } else {
                // One day
                /* $arrayOfDates[] = array(
                  'date' => $val->format('Y-m-d'),
                  'data' => null
                  ); */
            }
        }
        //krsort($arrayOfDates);
        //file_put_contents('/home/curiotime/ultima.curiotime.com/logs/collect.html', print_r($arrayOfDates, true), FILE_APPEND | LOCK_EX);
        return array('dayNumber' => $arrayOfDates);
    }

    private static function mapToDatesConfirmTime($period, $data) {
        // Load audits
        $audits = array();
        foreach ($data as $val) {
            $d = date('Y-m-d', strtotime($val->date));
            $audits[$d][] = $val;
        }

        // Merge audits and period. Days with no audits will have empty array
        $result = array();
        $arrayOfDates = array();
        foreach ($period as $val) {
            $daykey = $val->format('Y-m-d');
            $result[$daykey] = array(); // Default empty
            if (isset($audits[$daykey])) {
                // Audit exits for day
                $result[$daykey] = $audits[$daykey];
                foreach ($audits[$daykey] as $val) {
                    //file_put_contents('/home/curiotime/ultima.curiotime.com/logs/collect.html', print_r($val, true), FILE_APPEND | LOCK_EX);
                    if (!empty($val->note) || !empty($val->date_logged)) {
                        $arrayOfDates[] = array(
                            'date' => $val->date,
                            'data' => $val
                        );
                    }
                }
            } else {
                // One day
                /* $arrayOfDates[] = array(
                  'date' => $val->format('Y-m-d'),
                  'data' => null
                  ); */
            }
        }
        //krsort($arrayOfDates);
        //file_put_contents('/home/curiotime/ultima.curiotime.com/logs/collect.html', print_r($arrayOfDates, true), FILE_APPEND | LOCK_EX);
        return array('dayNumber' => $arrayOfDates);
    }

    private static function mapToDates($period, $data) {
        // Load audits
        $audits = array();
        foreach ($data as $val) {
            $d = date('Y-m-d', strtotime($val->date));
            $audits[$d][] = $val;
        }

        // Merge audits and period. Days with no audits will have empty array
        $result = array();
        $arrayOfDates = array();
        foreach ($period as $val) {
            $daykey = $val->format('Y-m-d');
            $result[$daykey] = array(); // Default empty
            if (isset($audits[$daykey])) {
                // Audit exits for day
                $result[$daykey] = $audits[$daykey];
                foreach ($audits[$daykey] as $val) {
                    $arrayOfDates[] = array('date' => $val->date, 'data' => $val);
                }
            } else {
                // One day
                $arrayOfDates[] = array('date' => $val->format('Y-m-d'), 'data' => null);
            }
        }
        //krsort($arrayOfDates);
//
        return array('dayNumber' => $arrayOfDates);
    }

    private static function mapToDatesCollect($period, $data) {
        // Load audits
        $audits = array();
        foreach ($data as $val) {
            $d = date('Y-m-d', strtotime($val->date));
            $audits[$d][] = $val;
        }

        // Merge audits and period. Days with no audits will have empty array
        $result = array();
        $arrayOfDates = array();
        foreach ($period as $val) {
            $daykey = $val->format('Y-m-d');
            $result[$daykey] = array(); // Default empty
            if (isset($audits[$daykey])) {





                // Audit exits for day
                $result[$daykey] = $audits[$daykey];
                foreach ($audits[$daykey] as $val) {
                    $arrayOfDates[] = array('date' => $val->date, 'data' => $val);
                }
            } else {
                // One day
                $arrayOfDates[] = array('date' => $val->format('Y-m-d'), 'data' => null);
            }
        }
        //krsort($arrayOfDates);


        return array('dayNumber' => $arrayOfDates);
    }





    public function getBackgroundClass($date, $year, $user_id, $time, $mode) {
        // return 'pay_period_td_background_yellow';
        //echo 'model date='.$date.' ';
        //echo 'model time='.$time.' ';

        $year1 = date('Y', strtotime($date . '.' . $year));
        $month = date('n', strtotime($date . '.' . $year));
        $day = date('j', strtotime($date . '.' . $year));

        $final_date_string = $year1 . '.' . $month . '.' . $day;

        try {
            $hours = explode(':', $time);
            $hours1 = $hours[0];
        } catch (Exception $ex) {
            $background_class = 'catch';
        }


        if ($hours1 >= 8) {

            $current_status = $this->checkReportItemStatus($user_id, $year1, $month, $day);

            switch ($current_status) {
                case '1':
                    $background_class = 'pay_period_td_background_green';
                    break;
                case '2':
                    $background_class = 'pay_period_td_background_yellow';
                    break;
                case '3':
                    $background_class = 'pay_period_td_background_red';
                    break;
                case '4':
                    $background_class = 'pay_period_td_background_blue';
                    break;
                default:
                    $background_class = '';
                    break;
            }
        } else {
            $background_class = '';
        }

        //echo 'user_id='.$user_id.' '.$year1.'.'.$month.'.'.$day.' class= '.$background_class.'<br/>';
        return $background_class;
    }

    public function checkReportItemStatus($user_id, $date_year, $date_month, $date_day) {
        //echo 'user_id='.$user_id;
        // echo 'year='.$date_year;
        $query = 'SELECT * FROM #__user_report_items WHERE `id_user`="' . $user_id . '"  AND `year`="' . $date_year . '" AND `month`="' . $date_month . '" AND `day`="' . $date_day . '"';
        $this->db->setQuery($query);
        $user_report = $this->db->loadObject();
        // echo 'st='.$user_report->status;
        return $user_report->status;
    }

    public function checkOnline($date_logged, $date_exit, $edited_exit_hours) {
        if(!empty($date_logged) && $date_exit===$date_logged && $edited_exit_hours=='0'){
            return '1';
        } else{
            return '0';
        }
    }

    private function setWhoUpdate(int $confirm_row_id, int $user_id) {
        $user_obj = & JFactory::getUser();
        $time = time();
        $date = date('d.m.Y H:i:s');

        $final_username = '';
        if (!empty($user_obj->username0)) {
            $final_username = $user_obj->username0;
        } elseif (!empty($user_obj->username)) {
            $final_username = $user_obj->username;
        } elseif (!empty($user_obj->name)) {
            $final_username = $user_obj->name;
        }

        if(in_array(6, $user_obj->groups)){
            $group_name = 'company manager';
        } elseif(in_array(10, $user_obj->groups)){
            $group_name = 'project manager';
        }

        $addon_sql = " `checkbox_3_changes` = '".strip_tags($this->db->escape($final_username))."' ";
        $addon_sql .= ", `time_3_changes` = '".$time."' ";
        $addon_sql .= ", `date_3_changes` = '".$date."' ";
        $addon_sql .= ", `checkbox_3_group_name` = '".$group_name."' ";


	$query = "UPDATE #__audit_time_confirm SET $addon_sql WHERE `id` = '".$confirm_row_id."' AND `id_user` = '".$user_id."'";
        //echo $query;

        $this->db->setQuery($query);
        if($this->db->query()){
            return 1;
        } else{
            return 0;
        }
    }

    private function checkPpRowExist(string $row_date, object $confirm_record) {
        $query = 'SELECT COUNT(id) as count_items FROM #__audit_time WHERE `id_user`="'.$confirm_record->id_user.'" AND `date` = "'.$confirm_record->date.'" AND `date_logged` = "'.$confirm_record->date_logged.'" AND `date_exit` = "'.$confirm_record->date_exit.'"';
        $this->db->setQuery($query);
        $items = $this->db->loadObject()->count_items;

        return $items;
    }

    public function confirmPayPeriodRow($row_date, $id_user, $id) {
        if(!empty($row_date) && !empty($id_user) && !empty($id)){
            $query = 'SELECT * FROM #__audit_time_confirm WHERE `id`="'.$id.'"';
            $this->db->setQuery($query);
            $item = $this->db->loadObject();
            $id_user_stored = $item->id_user;

            /*echo '<pre>';
            print_r($item);
            echo '</pre>';*/
           // file_put_contents($_SERVER['DOCUMENT_ROOT'].'/logs/confirm_time.html', print_r($item, true), FILE_APPEND | LOCK_EX);

            if(!empty($item)){
                $is_enable_confirm_pp = AuditController::getFinalCombineConfirmAndPpStatus($id_user);
                //echo '$is_enable_confirm_pp:'.$is_enable_confirm_pp;

                if($is_enable_confirm_pp == '0'){
                    $count_similar_rows = $this->checkPpRowExist($row_date, $item);
                    /*echo '<pre>$result_check';
                    print_r($result_check);
                    echo '</pre>';*/
                    if($count_similar_rows == 0){
                        $res = $this->addOneRowPayPeriod($item);
                    }
                } else{
                    $pp_id = $this->getPpIdByConfirmId($id);
                    if(empty($pp_id)){
                        $res = $this->addOneRowPayPeriod($item);
                    }
                    $res = $this->updateStatusInPayPeriod($pp_id);
                    $this->updatePayPeriodDescription($pp_id, $item);
                }

                if(!empty($res)){
                    $item = new stdClass;
                    $item->id=$id;
                    $item->is_confirm='1';

                    $this->db->updateObject( '#__audit_time_confirm', $item, 'id' );

                }
                $this->setWhoUpdate((int)$id, (int)$id_user_stored);
            }

        }
    }

    private function updatePayPeriodDescription($pp_id, $confirm_object)
    {
        $item = new stdClass;
        $item->id = $pp_id;
        $item->note = $this->db->escape($confirm_object->note);

        $this->db->updateObject( '#__audit_time', $item, 'id' );
    }

    public function reConfirmPayPeriodRow($row_date, $id_user, $id) {
        if(!empty($row_date) && !empty($id_user) && !empty($id)){
            $query = 'SELECT * FROM #__audit_time_confirm WHERE `id`="'.$id.'"';
            $this->db->setQuery($query);
            $item = $this->db->loadObject();
            $id_user_stored = $item->id_user;
           // file_put_contents($_SERVER['DOCUMENT_ROOT'].'/logs/confirm_time.html', print_r($item, true), FILE_APPEND | LOCK_EX);

            if(!empty($item)){
                $is_enable_confirm_pp = AuditController::getFinalCombineConfirmAndPpStatus($id_user);

                if($is_enable_confirm_pp == '0'){
					$count_similar_rows = $this->checkPpRowExist($row_date, $item);
					
					if($count_similar_rows == 0){
						$res = $this->addOneRowPayPeriod($item);
					}
                } else{
                    $pp_id = $this->getPpIdByConfirmId($id);
                    $res = $this->reUpdateStatusInPayPeriod($pp_id);
                }

                if(!empty($res)){
                    $item = new stdClass;
                    $item->id=$id;
                    $item->is_confirm='0';

                    $this->db->updateObject( '#__audit_time_confirm', $item, 'id' );

                }
                $this->setWhoUpdate((int)$id, (int)$id_user_stored);
            }

        }
    }

    private function getPpIdByConfirmId($confirm_id)
    {
        $query = "SELECT `id`, `pp_id` FROM #__pp_confirm_connector WHERE `confirm_id` = '".(int)$confirm_id."'";
        //echo $query;
        $this->db->setQuery( $query );
        return (int)$this->db->loadObject()->pp_id;
    }

    private function updateStatusInPayPeriod($pp_id)
    {
        $item = new stdClass;
        $item->id = $pp_id;
        $item->is_confirm = '1';

        return $this->db->updateObject( '#__audit_time', $item, 'id' );
    }

    private function reUpdateStatusInPayPeriod($pp_id)
    {
        $item = new stdClass;
        $item->id = $pp_id;
        $item->is_confirm = '0';

        return $this->db->updateObject( '#__audit_time', $item, 'id' );
    }

    private function addOneRowPayPeriod($confirm_object)
    {
        $item = new stdClass;
        $not_perm_field = [
            'id',
            'is_confirm',
            'audit_time_id',
            'border_14_hours',

            'checkbox_1_val',
            'checkbox_2_val',

            'checkbox_1_changes',
            'checkbox_2_changes',
            'checkbox_3_changes',

            'time_1_changes',
            'date_1_changes',
            'time_2_changes',
            'date_2_changes',
            'time_3_changes',
            'date_3_changes',

            'checkbox_1_group_name',
            'checkbox_2_group_name',
            'checkbox_3_group_name'

        ];
        foreach($confirm_object as $k=>$v){
            $item->id = NULL;

            if(!in_array($k, $not_perm_field)){
                $item->$k = $v;
            }

        }

        $res=$this->db->insertObject( '#__audit_time', $item, 'id' );
        $insert_id=$this->db->insertid();
        if(!empty($insert_id)){
            return '1';
        }
        else{
            return '0';
        }
       // setcookie('insert_id_pay_period', $insert_id,  time()+3600 * 24 * 365);
    }

    //not sequrity method, is used on site and in app api
    public function addNewAuditTimeRow($param, $mode, $action)
    {
       JLoader::register('AuditController', JPATH_ROOT . '/components/com_audit/controller.php');
       /*echo '<pre>from confirm model:';
       print_r($param);
       echo '</pre>';
       exit;*/

       $idField = $param['id'];

       $valueField = $param['value'];
       $valueField=trim($valueField);
       $valueField= strip_tags($valueField);

       $yearField = $param['year'];
       $dateField = $param['date'];
       $id_user=$param['user_id'];
       $id_user=(int)$id_user;

       $dateField = explode('.', $dateField);
       $idField = explode('-', $idField);
       $field = $idField[0];
       $id = $idField[1];

        //if(!empty($valueField)){
            $db = $this->db;
            $user_joomla = & JFactory::getUser();
            $id_user0 = $user_joomla->id;

            $item = new stdClass;
            if($action==='update'){
                $item->id = $id;
            } if($action==='insert'){
                $item->id = NULL;
            }

            $item->id_user = $id_user;
            if( $action!=='update' && $mode!='login_hours' && $mode!='exit_hours'){
                $item->date_logged = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:00';
                $item->date_exit = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:01';
            }

            //$item->date_logged='';
            //$item->date_exit='';
            $item->date = $yearField.'-'.$dateField[1].'-'.$dateField[0];
            $item->ip=$_SERVER["REMOTE_ADDR"];

            if($mode!='description'){
                //7=>07:00, 07=>07:00, 07:=>07:00, 07:0=>07:00
                $valueField=$this->autocompletion($valueField);
            }

            switch($mode){
                case 'login_hours':
                    //date= date from client request plus new H:i
                    if($action!='update'){
                       // $item->date_exit = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 23:59:00';
                    }
                    $newValue = date('Y-m-d', strtotime($item->date)).' '.$valueField;

                    $item->date_logged = $newValue;
                    $item->date_logged_edit='1';
                break;
                case 'exit_hours':
                    if($action!='update'){
                        $item->date_logged = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:00';
                    }
                    $newValue = date('Y-m-d', strtotime($item->date)).' '.$valueField;

                    $item->date_exit = $newValue;
                    $item->date_exit_edit='1';
                break;
                case 'total':
                    $item->new_hours = $valueField;
                break;
                case 'daytime':
                    $item->new_daytime = $valueField;
                    $item->daytime_edit='1';
                    $item->daytime_edited_date=date('Y-m-d H:i:s');
                break;
                case 'afterwork':
                    $item->new_afterwork = $valueField;
                    $item->afterwork_edit='1';
                    $item->afterwork_edited_date=date('Y-m-d H:i:s');
                break;
                case 'night_time':
                    $item->new_night_time = $valueField;
                    $item->night_time_edit='1';
                    $item->night_time_edited_date=date('Y-m-d H:i:s');
                break;
                case 'weekend':
                    $item->new_weekend = $valueField;
                    $item->weekend_edit='1';
                    $item->weekend_edited_date=date('Y-m-d H:i:s');
                break;
                case 'holidays':
                    $item->new_holidays = $valueField;
                    $item->holidays_edit='1';
                    $item->holidays_edited_date=date('Y-m-d H:i:s');
                break;
                case 'description':
                    $item->note = $valueField;
                break;
            }

            if ($action == 'update') {
                $res = $this->db->updateObject('#__audit_time_confirm', $item, 'id');
            } if ($action == 'insert') {
                $res = $this->db->insertObject('#__audit_time_confirm', $item, 'id');
                $insert_id = $this->db->insertid();
            }

        //}

        if($param['task'] !='SyncConfirm01'){
            $is_enable_confirm_pp = AuditController::getFinalCombineConfirmAndPpStatus($id_user);
        }
        if($is_enable_confirm_pp == '1' && $mode != 'description' && $param['task'] !='SyncConfirm01'){
            JLoader::register('AuditModelCustom_pay_period', JPATH_ROOT . '/components/com_audit/models/custom_pay_period.php');
            $model_pp = JModelLegacy::getInstance('Custom_pay_period', 'AuditModel');
            $pp_id = $this->getPpIdByConfirmId($id);

            //clone changes to pay period page(sync)
            if(!empty($pp_id)){
                $param['id'] = $field.'-'.$pp_id;
                //$param['date'].= '.'.date('Y');
                $param['task'] = 'SyncPP01';
                $model_pp->addNewAuditTimeRow($param, $mode, $action);
            }
        }

        $config = JFactory::getConfig();
        $enable_gps_task_changes = $config->get('enable_gps_task_changes');
        //echo $param['task'];

        if($enable_gps_task_changes == '1' && $param['task'] != 'emulateNewLoginHoursConfirm' && in_array($mode, ['login_hours', 'exit_hours', 'total'])){
            JLoader::register('AuditModelGps', JPATH_ROOT . '/components/com_audit/models/gps.php');
            $model = JModelLegacy::getInstance('Gps', 'AuditModel');

            $res_sync = $model->syncPayPeriodWithRoute($param, $mode, $action, $id, $id_user, 'confirm');
        }
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/confirm_impr_app_api.html', print_r($is_enable_confirm_pp, true), FILE_APPEND | LOCK_EX);
       $code=0;

       //need optimized
        switch($mode){
            case 'login_hours':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$insert_id
                ];
            break;
            case 'exit_hours':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$insert_id
                ];
            break;
            case 'total':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$insert_id
                ];
            break;
            case 'daytime':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$insert_id
                ];
            break;
            case 'afterwork':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$insert_id
                ];
            break;
            case 'night_time':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$insert_id
                ];
            break;
            case 'weekend':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$insert_id
                ];
            break;
            case 'holidays':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$insert_id
                ];
            break;
            case 'description':
                $result=[
                    'new_note'=>$valueField,//
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$insert_id,
                    'action'=>$action
                ];
            break;

        }

        return $result;

    }



    private function autocompletion($valueField)
    {
        switch(strlen($valueField)){
            case 0:

                break;
            case 1:
                $valueField='0'.$valueField.':00';
                break;
            case 2:
                $valueField0=str_split($valueField, 1);

                if($valueField0[0]=='0'){
                   $valueField='0'.$valueField0[1].':00';
                } else{
                    $valueField=$valueField0[0].$valueField0[1].':00';
                }
                break;
            case 3:
                $valueField0=str_split($valueField, 1);
                $valueField=$valueField0[0].$valueField0[1].':00';
                break;
            case 4:
                $valueField0=str_split($valueField, 1);
                $valueField=$valueField0[0].$valueField0[1].':'.$valueField0[3].'0';
                break;
        }

        return $valueField;
    }

    public function saveNotePayPeriod($id, $note)
    {
        $app = JFactory::getApplication();
        $act = $app->input->getString('act');

        //update table
        $id=(int)$id;
        $user_joomla = JFactory::getUser();
        $code=0;
        //admin
        if(in_array(8, $user_joomla->groups)){
            $item = new stdClass();
            $item->id =$id;
            $item->note = $note;
            $this->db->updateObject('#__audit_time_confirm', $item, 'id');
        }
        //manager
        if(in_array(6, $user_joomla->groups)){
            //get user id
            $query = "SELECT `id_user` FROM #__audit_time_confirm WHERE `id` = '$id'";
            $this->db->setQuery($query);
            $id_user=$this->db->loadResult();

            //get owner id
            $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$id_user'";
            $this->db->setQuery($query);
            $owner_id=$this->db->loadResult();

            //if user is in current manager
            if($user_joomla->owner_id===$owner_id){
                $item = new stdClass();
                $item->id =$id;
                $item->note = $note;
                $this->db->updateObject('#__audit_time_confirm', $item, 'id');
            } else{
                $code=1;
            }
        }
        //user
        if(in_array(2, $user_joomla->groups)){
            $query = "SELECT `id_user` FROM #__audit_time_confirm WHERE `id` = '$id'";
            $this->db->setQuery($query);
            $id_user=$this->db->loadResult();

            if($id_user===$user_joomla->id){
                $query = "UPDATE #__audit_time_confirm SET `note`='$note' WHERE `id`='".$id."' AND `id_user`='$user_joomla->id'";
                $this->db->setQuery($query);
                $this->db->query();
            } else{
                $code=2;
            }
        }

        $is_enable_confirm_pp = AuditController::getFinalCombineConfirmAndPpStatus($id_user);
        if($is_enable_confirm_pp == '1' && $act !== 'syncNoteConfirm0'){
            JLoader::register('AuditModelCustom_pay_period', JPATH_ROOT . '/components/com_audit/models/custom_pay_period.php');
            $model_pp = JModelLegacy::getInstance('Custom_pay_period', 'AuditModel');
            $pp_id = $this->getPpIdByConfirmId($id);

            //clone changes to confirm page(sync)
            if(!empty($pp_id)){
                $_REQUEST['act'] = 'syncPPNote';
                $model_pp->saveNotePayPeriod($pp_id, $note);
            }
        }

        $result=[
            'new_note'=>$note,
            'code'=>(string)$code,
            'id_user'=>$id_user,
            'owner_id'=>$owner_id
            //'user_joomla'=>$user_joomla
        ];
        return $result;
    }

    public function getLayoutGroups(...$a)
    {
        $args=func_get_args();
        //$password, $user_id
        $l =  $args[0];

        if($l==='is'){
            $this->lang->setLanguage('is-IS');
            $this->lang->load();
        }

        $db =$this->db;
        $current_user=& JFactory::getUser();
        $owner_id=$current_user->owner_id;

        $query = "SELECT `id`, `group_user` FROM #__users WHERE `owner_id` = '$owner_id'  ORDER BY `id` DESC";
        $db->setQuery($query);
        $res = $db->loadAssocList();


        $final=$this->super_unique($res, 'group_user');
        $html='';
        $html1='';
        $html2='';

        //if(count($final)!=1 && !empty($final[0]['group_user'])){


            foreach($final as $group){
                if(!empty($group['group_user'])){
                    $html.=''
                        . '<div class="one_option" data-option-value="'.$group['group_user'].'">'
                            . '<span>'.$group['group_user'].'</span>'
                            . '<i class="fa fa-circle-thin" aria-hidden="true"></i>'
                        . '</div>';
                }
            }

        //}

        if(!empty($html)){
                 $html1='<div class="one_option one_option_header">include groups:</div>';
                 $html2='<div class="bottom_apply_button_wrapper"><button type="button" class="btn btn-mini btn-primary applyFilteringByDepartment">'.JText::_('COM_AUDIT_CONFIRM_DEP_FILTER').'</button></div>';
                 return $html1.$html.$html2;
            } else{
                return '';
            }
    }

    private function super_unique($array, $key)
    {
        $temp_array = [];
        foreach ($array as &$v) {
            if (!isset($temp_array[$v[$key]]))
                $temp_array[$v[$key]] =& $v;
        }
        $array = array_values($temp_array);
        return $array;
    }

    public function saveTempConfirmData($html, $unical_string)
    {
        $item=new stdClass();
        $item->id=null;
        $item->unical_key=trim($unical_string);
        //$item->html=htmlspecialchars(json_encode($html));
         $item->html=$html;
        $item->datetime=date('d.m.Y H:i:s');
        $item->timestamp=time();
        $item->date=date('d.m.Y');


        $query="DELETE FROM `#__temp_cofirm_page_api_html` WHERE `unical_key` = ".$this->db->quote($item->unical_key);
        $this->db->setQuery($query);
        $this->db->query();
        $this->db->insertObject('#__temp_cofirm_page_api_html', $item);
    }

    public function updateConfirmFilterState($state) {
        $query = "SELECT * FROM #__confirm_filters WHERE `manager_id` = '".$this->user->owner_id."'";
        $this->db->setQuery($query);
        $res = $this->db->loadObject();

        if(empty($res)){
            $item=new stdClass();
            $item->id=null;
            $item->manager_id=$this->user->owner_id;
            $item->filter_state=$state;

            $this->db->insertObject('#__confirm_filters', $item);
        } else{
            $item=new stdClass();
            $item->id=$res->id;

            $item->filter_state=$state;

            $this->db->updateObject('#__confirm_filters', $item, 'id');
        }
        return $state;
    }

    private function getUnicontaSubtasks()
    {
        $query = "SELECT * FROM $this->subtask_table_name WHERE `id_user` = '".$this->user->owner_id."' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        return $this->db->loadObjectList();
    }

    public function getFilterState() {
        $query = "SELECT * FROM #__confirm_filters WHERE `manager_id` = '".$this->user->owner_id."'";
        $this->db->setQuery($query);
        $res = $this->db->loadObject();

        return $res;
    }

    public function getLayoutTaskConfirm() {
        $query = "SELECT * FROM #__audit_task_list WHERE `id_user` = '".$this->user->owner_id."'";
        $this->db->setQuery($query);
        $res = $this->db->loadAssocList();
        $manager = & JFactory::getUser($this->user->owner_id);
        $dk_token = $manager->dk_token;

        if ($this->enable_task_manager_dk_api == '1' && !empty($dk_token) && $manager->sync_dk_tasks == 1 && $manager->sync_uniconta_tasks != '1') {
            $query = "SELECT * FROM #__audit_dk_task_list WHERE `id_user` = '".$this->user->owner_id."' AND `JobStatus` = '1' ORDER BY `id` DESC";
            $this->db->setQuery($query);
            $dk_task_list = $this->db->loadAssocList();

            if(empty($dk_task_list)){
                $dk_task_list_for_api = json_decode($this->getDkTaskList());
            }
        }

        $html='';
        foreach($res as $one_task){
            $html.=''
                . '<div class="one_option" data-option-value="'.$one_task['text'].'">'
                    . '<span>'.$one_task['text'].'</span>'
                    //. '<i class="fa fa-circle-thin" aria-hidden="true"></i>'
                . '</div>';

        } if(!empty($dk_task_list) && $this->enable_task_manager_dk_api == '1' && $manager->sync_uniconta_tasks != '1'){
            foreach( $dk_task_list as $one_task){
               $html.=''
                . '<div class="one_option" data-option-value="'.$one_task['original_id'].' | '.$one_task['text'].'">'
                    . '<span>'.$one_task['original_id'].' | '.$one_task['text'].'</span>'
                    //. '<i class="fa fa-circle-thin" aria-hidden="true"></i>'
                . '</div>';
            }
        } elseif(empty($dk_task_list) && $this->enable_task_manager_dk_api == '1' && $manager->sync_uniconta_tasks != '1'){
            foreach( $dk_task_list_for_api as $one_task){
               $html.=''
                . '<div class="one_option" data-option-value="'.$one_task->Number.' | '.$one_task->Name.'">'
                    . '<span>'.$one_task->Number.' | '.$one_task->Name.'</span>'
                    //. '<i class="fa fa-circle-thin" aria-hidden="true"></i>'
                . '</div>';
            }
        } if ($this->enable_uniconta_tasks == '1' && $manager->sync_uniconta_tasks == '1' && !empty($manager->uniconta_uname) && !empty($manager->uniconta_upassw)) {
            $query = "SELECT * FROM $this->uniconta_table_name WHERE `id_user` = '" . $manager->owner_id . "'  ORDER BY `ordering`";
            $this->db->setQuery($query);
            $uniconta_task_list = $this->db->loadObjectList();

            //$subtasks_list = $this->getUnicontaSubtasks();
            foreach( $uniconta_task_list as $one_task){
               $html.=''
                . '<div class="one_option" data-option-value="'.$one_task->number0 . ' | ' . $one_task->account . ' | ' . $one_task->name.'">'
                    . '<span>'.$one_task->number0 . ' | ' . $one_task->account . ' | ' . $one_task->name.'</span>'
                    //. '<i class="fa fa-circle-thin" aria-hidden="true"></i>'
                . '</div>';
            }
        }

        return $html;
    }

    private function getDkTaskList()
    {
        JLoader::register('AuditModelDk', JPATH_ROOT . '/components/com_audit/models/dk.php');
        $model_dk = JModelLegacy::getInstance('Dk', 'AuditModel');
        $dk_tasks = $model_dk->getDkTasks();

        if($dk_tasks->Message){
            throw new Exception('Error on DK server with text: '.$dk_tasks->Message);
        }

        return json_encode($dk_tasks);
    }

    public function deleteConfirmRow($row_id) {
        $row_id = (int)$row_id;
        $app = JFactory::getApplication();
        $act = $app->input->getString('act');

        $query = "SELECT `id_user`, `id` FROM `#__audit_time_confirm` WHERE `id` = '$row_id';";
        $this->db->setQuery($query);
        $item = $this->db->loadObject();

        $query = "DELETE FROM `#__audit_time_confirm` WHERE `id` = '".$item->id."';";
        $this->db->setQuery($query);
        $this->db->query();

        $pp_id = 0;
        $is_enable_confirm_pp = AuditController::getFinalCombineConfirmAndPpStatus($item->id_user);
        if($is_enable_confirm_pp == '1' ){
            $pp_id = $this->getPpIdByConfirmId($item->id);

            if(!empty($pp_id)){
                $query = "DELETE FROM `#__audit_time` WHERE `id` = '$pp_id';";
                $this->db->setQuery($query);
                $this->db->query();
            }
        }

        $config = JFactory::getConfig();
        $enable_gps_task_changes = $config->get('enable_gps_task_changes');

        if ($enable_gps_task_changes == '1') {
            $model = JModelLegacy::getInstance('Gps', 'AuditModel');
            $model->deleteRouteByPp($pp_id, $item->id, $item->id_user);
        }
    }

    public function getLayoutGroupsNewPsd(...$a)
    {
        $args=func_get_args();
        //$password, $user_id
        $l =  $args[0];

        if($l==='is'){
            $this->lang->setLanguage('is-IS');
            $this->lang->load();
        }

        $db =$this->db;
        $current_user=& JFactory::getUser();
        $owner_id=$current_user->owner_id;

        $query = "SELECT `id`, `group_user` FROM #__users WHERE `owner_id` = '$owner_id'  AND `is_hide`='0' ORDER BY `id` DESC";
        $db->setQuery($query);
        $res = $db->loadAssocList();


        $final=$this->super_unique($res, 'group_user');
        /*echo '<pre>$final';
        print_r($final);
        echo '</pre>';*/
        $html='';
        $html1='';
        $html2='';

        //if(count($final)!=1 && !empty($final[0]['group_user'])){


            foreach($final as $group){
                if(!empty($group['group_user'])){
                    $html.=''
                        . '<div class="one_option" data-option-value="'.$group['group_user'].'">'
                            . '<span>'.$group['group_user'].'</span>'
                            . '<i class="fa fa-circle-thin" aria-hidden="true"></i>'
                        . '</div>';
                }
            }

        //}

        if(!empty($html)){
                 $html1='<div class="one_option one_option_header">'.JText::_('COM_AUDIT_CONFIRM_DEP_FILTER_HEADER').'</div>';
                 $html2='<div class="bottom_apply_button_wrapper"><button type="button" class="btn  btn-primary btn-sm applyFilteringByDepartment button_style_pdf">'.JText::_('COM_AUDIT_CONFIRM_DEP_FILTER').'</button></div>';
                 return $html1.$html.$html2;
            } else{
                return '';
            }
    }

    public function setConfirmCheckboxValue($state, int $id, int $user_id, string $checkbox_type)
    {
        $user_obj = & JFactory::getUser();
        $time = time();
        $date = date('d.m.Y H:i:s');

        if(in_array(6, $user_obj->groups)){
            $group_name = 'company manager';
        } elseif(in_array(10, $user_obj->groups)){
            $group_name = 'project manager';
        }

        $final_username = '';
        if (!empty($user_obj->username0)) {
            $final_username = $user_obj->username0;
        } elseif (!empty($user_obj->username)) {
            $final_username = $user_obj->username;
        } elseif (!empty($user_obj->name)) {
            $final_username = $user_obj->name;
        }

        if($checkbox_type == '1'){
            $field = 'checkbox_1_val';

            $addon_sql = ", `checkbox_1_changes` = '".strip_tags($this->db->escape($final_username))."' ";
            $addon_sql .= ", `time_1_changes` = '".$time."' ";
            $addon_sql .= ", `date_1_changes` = '".$date."' ";
            $addon_sql .= ", `checkbox_1_group_name` = '".$group_name."' ";
        } elseif($checkbox_type == '2'){
            $field = 'checkbox_2_val';

            $addon_sql = ", `checkbox_2_changes` = '".strip_tags($this->db->escape($final_username))."' ";
            $addon_sql .= ", `time_2_changes` = '".$time."' ";
            $addon_sql .= ", `date_2_changes` = '".$date."' ";
            $addon_sql .= ", `checkbox_2_group_name` = '".$group_name."' ";
        }

        if($state == 'true'){
            $auto_report = 1;
        } else{
            $auto_report = 0;
        }

        $query = "UPDATE #__audit_time_confirm SET `".$field."` = '$auto_report' $addon_sql WHERE `id` = '".$id."' AND `id_user` = '".$user_id."'";
        $this->db->setQuery($query);
        if($this->db->query()){
            return 1;
        } else{
            return 0;
        }
    }

    public function checkActionPermission(string $type, array $individual_params)
    {
        $res = '0';

        switch($type){

            case 'setConfirmCheckboxValue':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user;

                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 /*&& ($user_from_request_obj->owner_id == $owner_id)*/){
                    $res = '1';
                }
            break;
            case 'loadConfirmPageFromTo':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user;

                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 /*&& ($user_from_request_obj->owner_id == $owner_id)*/){
                    $res = '1';
                }
            break;
        }


       return $res;
    }

    //ajax load default2.php if select from to in calendar
    public static function getTimeByPeriodFromTo(int $id_user, string $from, string $to, $departments, $search_word, $incl_all) {

        $from_obj = DateTime::createFromFormat('d.m.Y H:i:s', $from . '00:00:00');
        $to_obj = DateTime::createFromFormat('d.m.Y H:i:s', $to . '23:59:59');
        $db = & JFactory::getDBO();
        $search_word_prepared = strip_tags($db->escape($search_word));

        if(!empty($search_word_prepared)){
            if($incl_all === 'false'){
                $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$id_user' AND `date` BETWEEN '".$from_obj->format('Y-m-d')."' AND '".$to_obj->format('Y-m-d')."' AND `note` LIKE BINARY '%$search_word_prepared%' ORDER BY `date_logged` ASC";
            } else{
                 $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$id_user' AND `note` LIKE BINARY '%$search_word_prepared%' ORDER BY `date_logged` ASC";
            }


        } else{
            //$query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$id_user' AND (UNIX_TIMESTAMP(`date_logged`) >= '" . $from_obj->format('U') . "' AND UNIX_TIMESTAMP(`date_exit`) <= '" . $to_obj->format('U') . "' OR UNIX_TIMESTAMP(`date_logged`) >= '" . $from_obj->format('U') . "' AND `date_exit` = '0000-00-00 00:00:00') ORDER BY `date_logged` ASC";
            $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$id_user' AND `date` BETWEEN '".$from_obj->format('Y-m-d')."' AND '".$to_obj->format('Y-m-d')."' ORDER BY `date_logged` ASC";

        }
        $db->setQuery($query);
        $data = $db->loadObjectList();


        if (!empty($search_word_prepared)) {
            if ($incl_all === 'false') {
                $period = new DatePeriod($from_obj, new DateInterval('P1D'), $to_obj);
                if (count($departments) > 0) {
                    $filtered_data = self::filterByDep($data, $departments);
                    return self::mapToDatesConfirmTime($period, $filtered_data);
                } else {
                    return self::mapToDatesConfirmTime($period, $data);
                }
            } else{
                $current_date = date('Y-m-d');
                $from = new DateTime($data[0]->date);
                $dayN = date('t', strtotime($data[0]->date));
                $to = new DateTime(date('Y-m-d', strtotime($current_date . ' +' . $dayN . 'day')));
                $period = new DatePeriod($from, new DateInterval('P1D'), $to);

                return self::mapToDatesConfirmTimeSearch($period, $data);
            }
        } else{
             $period = new DatePeriod($from_obj, new DateInterval('P1D'), $to_obj);
                if (count($departments) > 0) {
                    $filtered_data = self::filterByDep($data, $departments);
                    return self::mapToDatesConfirmTime($period, $filtered_data);
                } else {
                    return self::mapToDatesConfirmTime($period, $data);
                }
        }

    }

    public function getConfirmRowHtml(int $user_id, string $lang, string $date) {
        //getTimeByPeriodOneDate
    }
}
