<?php
/*ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);*/

// No direct access
defined('_JEXEC') or die;

/**

 * @author 

 */
class AuditModelCollect extends JModelLegacy {

    public function __construct() {
        parent::__construct();
                    
        $this->db = &JFactory::getDBO();
        $this->app = JFactory::getApplication();
        $this->doc = JFactory::getDocument();
        $this->server_path = $_SERVER['DOCUMENT_ROOT'];
        $this->user = & JFactory::getUser();
        $this->lang = & JFactory::getLanguage();
        
        if($_SERVER['SERVER_NAME']==='localhost'){
            $this->sitename='http://'.$_SERVER['SERVER_NAME'];
        } else{
            $this->sitename = 'https://'.$_SERVER['SERVER_NAME'];
        }
        
        
        $this->config = &JFactory::getConfig(); 
        
        $this->current_home_path=$this->config->get('current_home_path');
        $this->current_url=$this->config->get('current_url');
        $this->enable_task_manager_dk_api = $this->config->get('enable_task_manager_dk_api');
        
        $this->enable_uniconta_tasks = $this->config->get('enable_uniconta_tasks');
        $this->uniconta_table_name = '#__uniconta_tasks';
        $this->subtask_table_name = '#__uniconta_subtasks';
        $this->enable_separated_column_by_note_on_collect_excel = $this->config->get('enable_separated_column_by_note_on_collect_excel');
    }
    
    
    
    /**
     * Load collect page
     */
    public function getPayPeriods($token, $lang, $user_id, $from, $to, $additional_mode, $note, $groups, $tasks, $json_data, $is_load_for_new_pay_period)
    {
        ini_set('memory_limit', '-1');
        $curr_user=JFactory::getUser($user_id);
        JLoader::register('AuditModelTime_Wages', JPATH_ROOT . '/components/com_audit/models/time_wages.php');
        $model_settings = JModelLegacy::getInstance('Time_Wages', 'AuditModel');

        $this->sick_child_state=$model_settings->getSickChildStateAndConfig($curr_user->owner_id);
        //echo $this->sick_child_state;
        
        if ($lang == 'is') {
            $this->lang->setLanguage('is-IS');
            $this->lang->load();
        }
        
        if(in_array(6, $curr_user->groups)){
            $manager_users_object = $this->getUsersFromManagerCheckHidden($user_id);//get manager users
        } elseif(in_array(10, $curr_user->groups)){
            $manager_users_object = $this->getUsersFromManagerCheckHidden($curr_user->owner_id);//get manager users
        }
        
        $tasks = $json_data['tasks0'];
        
        
        $html=[];
        $i=0;
        $parser_mode='simplehtml';//default or simplehtml

        include_once($this->current_home_path.'/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
 
        if(empty($from) && empty($to)){
            $from_to_obj=$this->getFromTo($user_id);
            $from=$from_to_obj['from'];
            $to=$from_to_obj['to'];
        }
        
        try{
            if($additional_mode=='search'){
                if(!empty($groups)){
                    $groups_array=explode(',', $groups);
                }
                if(!empty($tasks)){
                    $tasks_array=explode(',', $tasks);
                }
            }
        } catch (Exception $ex) {
            $groups_array='';
            $tasks_array='';
        }
        
        
       
        
        
        
        foreach($manager_users_object as $manager_user) {
            
            $u  =  JFactory::getUser($manager_user->id);
            if(count($manager_users_object)>1 && in_array(6, $u->groups)) continue;            
            
            if(in_array($manager_user->group_user, $groups_array) || empty($groups_array[0])) {
                
                $html[$i]['user_info']['id']=$manager_user->id;
                $html[$i]['user_info']['unical_id']=$manager_user->username;
                $html[$i]['user_info']['username']=$manager_user->username0;

                //$lang='en';
          
                //$from='31.08.2018';
                //$to='15.10.2018';

                switch($additional_mode){
                    case 'search':
                        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect.html', print_r($manager_user, true), FILE_APPEND | LOCK_EX);
                        if($manager_user->owner_id != $manager_user->id){
                           // $link='dd';
                            
                            
                            if(empty($tasks_array)){
                                $link=$this->current_url.'/index.php?task=getTimeByPeriodCollectSearch&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1&note='.urlencode($note).'&group='.urlencode($groups).'&is_load_for_new_pay_period='.$is_load_for_new_pay_period;
                            } else{
                               //$link='link';
                                $link=$this->current_url.'/index.php?task=getTimeByPeriodCollectWithTasks&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1&tasks0='.urlencode(implode(',', $tasks_array)).'&is_load_for_new_pay_period='.$is_load_for_new_pay_period;
                            }
                            
                            
                        }
                    break;
                    default:
                        $link=$this->current_url.'/index.php?task=getTimeByPeriodCollect&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1&is_load_for_new_pay_period='.$is_load_for_new_pay_period;
                    break;
                }
                
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_1week_breaks.html', print_r($link . PHP_EOL, true), FILE_APPEND | LOCK_EX);
                
                
                if($parser_mode==='simplehtml'){
                    $html1 = str_get_html(file_get_contents($link));
                } elseif($parser_mode==='default'){
                    $html1 = file_get_contents($link);
                
                    $dom = new DOMDocument;	
                    $dom->validateOnParse = true;
                    $dom->loadHTML(mb_convert_encoding($html1, 'HTML-ENTITIES', 'UTF-8'));	
                    $finder = new DomXPath($dom);
                } 
                if($parser_mode==='simplehtml' && empty($html1) == false){
                    
                    $q1  = $html1->find('table[class="pdf_not_width"]');
                    foreach($q1 as $e){
                        $layout='
                            <div class="big_pay_period_one_item">
                                <div class="big_pay_period_left">'.$manager_user->username.'-'.$manager_user->username0.'-'.$manager_user->group_user.'</div>';
                        
                        if($is_load_for_new_pay_period == '1'){
                             $layout .= '<div class="big_pay_period_right"><div class="table-responsive">'.$e.'</div>';
                        } else{
                             $layout .= '<div class="big_pay_period_right">'.$e;
                        }
                               
                    
                
                        if($additional_mode=='search'){
                            //get total bottom panel(one user)
                            foreach($html1->find('div[class="span4 --offset8 custom_bootstrap_span pdf-35"]') as $ee){
                                $layout.=$ee.'
                                    </div>
                                </div>';
                 
                            }
                        } else{
                            //get total bottom panel(one user)
                            foreach($html1->find('div[class="span4 --offset8 custom_bootstrap_span pdf-35"]') as $ee){
                                $layout.=$ee.'
                                    </div>
                                </div>';
                 
                            }
                        }
                        $html[$i]['pay_period']=htmlspecialchars($layout);
                    }
                    
                } elseif($parser_mode==='default'){
                    
                    
                    $classname="pdf_not_width";
                    $nodes = $finder->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' $classname ')]");
                    //$nodes = $dom->getElementById('table_first_pay_period_table');    
            
                    foreach($nodes as $e){
                        $layout='
                            <div class="big_pay_period_one_item">
                                <div class="big_pay_period_left">'.$manager_user->username.'-'.$manager_user->username0.'-'.$manager_user->group_user.'</div>
                                <div class="big_pay_period_right">'.$e->ownerDocument->saveHTML().'
                        ';
                        $layout.='</div>
                            </div>
                        ';
               
                    }
                    
                    $html[$i]['pay_period']=htmlspecialchars($layout); 

                }   

                $i++;
            }
        }
        
        
        
        $i1=0;
        $global_total_h='';
        $global_total_m='';
        
        $global_daytime_h='';
        $global_daytime_m='';
        
        $global_afterwork_h='';
        $global_afterwork_m='';
        
        $global_night_time_h='';
        $global_night_time_m='';
        
        $global_weekend_time_h='';
        $global_weekend_time_m=''; 
       
        $global_holidays_time_h='';
        $global_holidays_time_m='';
        
        $global_holidays_time_h_45='';
        $global_holidays_time_m_45='';
        
        $global_breaks_time_h='';
        $global_breaks_time_m='';
        
        $total_sick_h='';
        $total_sick_m='';
        
        if($this->sick_child_state==1) {
            $total_sick_child_h='';
            $total_sick_child_m='';
        }
       //unset($manager_user);
       $json=[];
       
        foreach($manager_users_object as $manager_user){
            unset($htmlSrc);
            unset($json);
            unset($arr);
            
            $u  =  JFactory::getUser($manager_user->id);
            if(count($manager_users_object)>1 && in_array(6, $u->groups)) continue;            
               
           if(in_array($manager_user->group_user, $groups_array) || empty($groups_array[0])) {
               //file_put_contents($this->current_home_path.'/logs/collect.html', print_r('6', true), FILE_APPEND | LOCK_EX);
                /*switch($additional_mode){
                    case 'search':
                        $link=$this->current_url.'/index.php?task=getTimeByPeriodCollectSearch&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1&note='.$note; 
                    break;
                    default:
                        $link=$this->current_url.'/index.php?task=getTimeByPeriodCollect&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1';
                    break;
                }*/
               switch($additional_mode){
                    case 'search':
                        
                        
                        if($manager_user->owner_id!=$manager_user->id){
                           // $link='dd';
                            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_fix_totals.html', print_r($manager_user, true), FILE_APPEND | LOCK_EX);
                            if(empty($tasks_array)){
                                $link=$this->current_url.'/index.php?task=getTimeByPeriodCollectSearch&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1&note='. urlencode($note).'&group='.urlencode($groups).'&is_load_for_new_pay_period='.$is_load_for_new_pay_period;
                            } else{
                               //$link='link';
                                $link=$this->current_url.'/index.php?task=getTimeByPeriodCollectWithTasks&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1&tasks0='.urlencode(implode(',', $tasks_array)).'&is_load_for_new_pay_period='.$is_load_for_new_pay_period;
                            }
                            
                            
                        } else{
                            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_fix_totals0.html', print_r($manager_user, true), FILE_APPEND | LOCK_EX);
                            unset($html2);
                            unset($link);
                            //continue;
                        }
                    break;
                    default:
                        $link=$this->current_url.'/index.php?task=getTimeByPeriodCollect&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1'.'&is_load_for_new_pay_period='.$is_load_for_new_pay_period;
                    break;
                }
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_tasks_search.html', print_r($link.PHP_EOL, true), FILE_APPEND | LOCK_EX);
                
                $html2 = str_get_html(file_get_contents($link));
                
                if ($manager_user->owner_id != $manager_user->id) {
                    $htmlSrc = file_get_contents($link);

                    if (preg_match("#<!--json-dk-totals--(.*)--json-dk-totals-->#", $htmlSrc, $arr)) {
                        $json = trim($arr[1]);
                        $json = json_decode($json, true);
                        /* if(empty($json)) 
                          continue; */
                    }
                }
                
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_sick_child1.html', print_r($json, true), FILE_APPEND | LOCK_EX);
               
                //totals array
                if (empty($html2) == false) {
                    foreach ($html2->find('div[class="total-time"]') as $ee) {
                        $users_info_html[$i1] = htmlspecialchars($ee->plaintext);
                        //file_put_contents('/home/curiotime/app.curiotime.com/logs/collect.html', print_r($ee->plaintext.'<br/>', true), FILE_APPEND | LOCK_EX); 
                    }
                    //daytime array
                    /* foreach($html2->find('div[class="daytime_wrapper"]') as $ee){
                      $daytime_info_html[$i1]=htmlspecialchars($ee->plaintext);
                      } */
                    //afterwork array
                    /* foreach($html2->find('div[class="afterwork_wrapper"]') as $ee){
                      $afterwork_info_html[$i1]=htmlspecialchars($ee->plaintext);
                      }
                      //night time array
                      foreach($html2->find('div[class="night_time_wrapper"]') as $ee){
                      $night_time_info_html[$i1]=htmlspecialchars($ee->plaintext);
                      } */
                    //weekends array
                    /* foreach($html2->find('div[class="weekend_wrapper"]') as $ee){
                      $weekend_info_html[$i1]=htmlspecialchars($ee->plaintext);
                      } */
                    //holidays 90 array
                    /* foreach($html2->find('div[class="holidays_wrapper"]') as $ee){
                      $holidays_info_html[$i1]=htmlspecialchars($ee->plaintext);
                      } */
                    //holidays 45 array
                    /*foreach ($html2->find('div[class="holidays_wrapper_45"]') as $ee) {
                        $holidays_info_html_45[$i1] = htmlspecialchars($ee->plaintext);
                    }*/
                    //sick array
                    /*foreach ($html2->find('div[class="sick_wrapper"]') as $ee) {
                        $sick_html[$i1] = htmlspecialchars($ee->plaintext);
                    }*/
                    //sick child array
                    /*if ($this->sick_child_state == 1) {
                        //sick child array
                        foreach ($html2->find('div[class="sick_child_wrapper"]') as $ee) {
                            $sick_child_html[$i1] = htmlspecialchars($ee->plaintext);
                        }
                    }*/
                    //breaks total array
                    foreach ($html2->find('div[class="break_wrapper"]') as $ee) {
                        $breaks_info_html[$i1] = htmlspecialchars($ee->plaintext);
                    }
                }

                //total
                $users_info_html1=[];
                $i2=0;
                foreach($users_info_html as $k=>$v){
                    $total_string=trim($v);
                    $users_info_html1[$i2]['raw']=$total_string;
                    $users_info_html1[$i2]['split']=preg_split('/[\s!?]/u', $total_string, -1, PREG_SPLIT_NO_EMPTY);
       
                    $split_array=explode(':', $users_info_html1[$i2]['split'][1]);
                    $users_info_html1[$i2]['split_array']=$split_array;
                    
                    $users_info_html1[$i2]['total_h']+=$split_array[0];
                    $users_info_html1[$i2]['total_m']+=$split_array[1];
  
                
                    $i2++;
                }
           
            //daytime
            /*$users_info_html2=[];
            $i3=0;
            foreach($daytime_info_html as $k=>$v){
                $total_string=trim($v);
                $users_info_html2[$i3]['raw']=$total_string;
                $users_info_html2[$i3]['split']=preg_split('/[\s!?]/u', $total_string, -1, PREG_SPLIT_NO_EMPTY);
                    
                $split_array=explode(':', $users_info_html2[$i3]['split'][1]);
                $users_info_html2[$i3]['split_array']=$split_array;
                    
                $users_info_html2[$i3]['total_h']+=$split_array[0];
                $users_info_html2[$i3]['total_m']+=$split_array[1];
  
                
                $i3++;
            }*/
            
            
            
            //afterwork
            /*$users_info_html3=[];
            $i4=0;
            foreach($afterwork_info_html as $k=>$v){
                $total_string=trim($v);
                $users_info_html3[$i4]['raw']=$total_string;
                $users_info_html3[$i4]['split']=preg_split('/[\s!?]/u', $total_string, -1, PREG_SPLIT_NO_EMPTY);
                    
                file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_sick_child1.html', print_r($users_info_html3[$i4]['raw'], true), FILE_APPEND | LOCK_EX);
                //because Icelandic words have a different number of spaces, in which we break the string
                if ($lang == 'is') {
                    $split_array=explode(':', $users_info_html3[$i4]['split'][1]);
                } else{
                    $split_array=explode(':', $users_info_html3[$i4]['split'][2]);
                }
               
                $users_info_html3[$i4]['split_array']=$split_array;
                    
                $users_info_html3[$i4]['total_h']+=$split_array[0];
                $users_info_html3[$i4]['total_m']+=$split_array[1];
  
                
                $i4++;
            }*/
            
            $i3=0;
            $i4=0;
            $i5=0;
            $i6=0;
            $i7=0;
            $i9a=0;
            $i10a=0;
            $i15=0;
            
            //foreach arr with these struct http://prntscr.com/riwvnw
            foreach ($json as $k => $item) {
                switch($k){
                    case 'daytime':
                        $users_info_html2[$i3]['total_h']+=$item['h'];
                        $users_info_html2[$i3]['total_m']+=$item['m'];
                
                        $i3++;
                        break;
                    case 'after_hours':
                        $users_info_html3[$i4]['total_h']+=$item['h'];
                        $users_info_html3[$i4]['total_m']+=$item['m'];
                
                        $i4++;
                        break;
                    case 'night':
                        $users_info_html4[$i5]['total_h']+=$item['h'];
                        $users_info_html4[$i5]['total_m']+=$item['m'];
                
                        $i5++;
                        break;
                    case 'weekends':
                        $users_info_html5[$i6]['total_h']+=$item['h'];
                        $users_info_html5[$i6]['total_m']+=$item['m'];
                
                        $i6++;
                        break;
                    case 'holidays_90':
                        $users_info_html6[$i7]['total_h']+=$item['h'];
                        $users_info_html6[$i7]['total_m']+=$item['m'];
                
                        $i7++;
                        break;
                    case 'holidays_45':
                        $users_info_html8a[$i9a]['total_h']+=$item['h'];
                        $users_info_html8a[$i9a]['total_m']+=$item['m'];
                
                        $i9a++;
                        break;
                    case 'sick':
                        $sick_html_0[$i10a]['total_h']+=$item['h'];
                        $sick_html_0[$i10a]['total_m']+=$item['m'];
                
                        $i10a++;
                        break;
                    case 'sick_child':
                        if ($this->sick_child_state == 1) {
                            $users_info_html14[$i15]['total_h']+=$item['h'];
                            $users_info_html14[$i15]['total_m']+=$item['m'];
                
                            $i15++;
                        
                        }
                        break;
                }
               
            }
            //night time
            /*$users_info_html4=[];
            $i5=0;
            foreach($night_time_info_html as $k=>$v){
                $total_string=trim($v);
                $users_info_html4[$i5]['raw']=$total_string;
                $users_info_html4[$i5]['split']=preg_split('/[\s!?]/u', $total_string, -1, PREG_SPLIT_NO_EMPTY);
                
                //because Icelandic words have a different number of spaces, in which we break the string
                if ($lang == 'is') { 
                    $split_array=explode(':', $users_info_html4[$i5]['split'][1]);
                } else{
                    $split_array=explode(':', $users_info_html4[$i5]['split'][2]);
                }
              
                $users_info_html4[$i5]['split_array']=$split_array;
                    
                $users_info_html4[$i5]['total_h']+=$split_array[0];
                $users_info_html4[$i5]['total_m']+=$split_array[1];
  
                
                $i5++;
            }*/
            
            //weekends
            /*$users_info_html5=[];
            $i6=0;
            foreach($weekend_info_html as $k=>$v){
                $total_string=trim($v);
                $users_info_html5[$i6]['raw']=$total_string;
                $users_info_html5[$i6]['split']=preg_split('/[\s!?]/u', $total_string, -1, PREG_SPLIT_NO_EMPTY);
                    
                $split_array=explode(':', $users_info_html5[$i6]['split'][1]);
                $users_info_html5[$i6]['split_array']=$split_array;
                    
                $users_info_html5[$i6]['total_h']+=$split_array[0];
                $users_info_html5[$i6]['total_m']+=$split_array[1];
  
                
                $i6++;
            }*/
            
            //holidays 90
           /* $users_info_html6=[];
            $i7=0;
            foreach($holidays_info_html as $k=>$v){
                $total_string=trim($v);
                $users_info_html6[$i7]['raw']=$total_string;
                $users_info_html6[$i7]['split']=preg_split('/[\s!?]/u', $total_string, -1, PREG_SPLIT_NO_EMPTY);
                    
                $split_array=explode(':',  $users_info_html6[$i7]['split'][2]);
       
                $users_info_html6[$i7]['split_array']=$split_array;             
                $users_info_html6[$i7]['total_h']+=$split_array[0];
                $users_info_html6[$i7]['total_m']+=$split_array[1];
  
                
                $i7++;
            }*/
            
            //holidays 45
            /*$users_info_html8a=[];
            $i9a=0;
            foreach($holidays_info_html_45 as $k=>$v){
                $total_string=trim($v);
                $users_info_html8a[$i9a]['raw']=$total_string;
                $users_info_html8a[$i9a]['split']=preg_split('/[\s!?]/u', $total_string, -1, PREG_SPLIT_NO_EMPTY);
           
                $split_array=explode(':',  $users_info_html8a[$i9a]['split'][2]);
       
                $users_info_html8a[$i9a]['split_array']=$split_array;             
                $users_info_html8a[$i9a]['total_h']+=$split_array[0];
                $users_info_html8a[$i9a]['total_m']+=$split_array[1];
                
                $i9a++;
            }*/
            
            //Sick
            /*$sick_html_0=[];
            $i10a=0;
            foreach($sick_html as $k=>$v){
                $total_string=trim($v);
                $sick_html_0[$i9a]['raw']=$total_string;
                $sick_html_0[$i9a]['split']=preg_split('/[\s!?]/u', $total_string, -1, PREG_SPLIT_NO_EMPTY);
           
                $split_array=explode(':',  $sick_html_0[$i9a]['split'][2]);
       
                $sick_html_0[$i10a]['split_array']=$split_array;             
                $sick_html_0[$i10a]['total_h']+=$split_array[0];
                $sick_html_0[$i10a]['total_m']+=$split_array[1];
                
                $i10a++;
            }*/
            
            //sick child
            /*if($this->sick_child_state==1) {
                
                $users_info_html14=[];
                $i15=0;
                foreach($sick_child_html as $k=>$v){
                    $total_string=trim($v);
                    $users_info_html14[$i15]['raw']=$total_string;
                    $users_info_html14[$i15]['split']=preg_split('/[\s!?]/u', $total_string, -1, PREG_SPLIT_NO_EMPTY);
                
                    //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_sick_child.html', print_r($users_info_html14[$i15]['split'], true), FILE_APPEND | LOCK_EX);
                    //because Icelandic words have a different number of spaces, in which we break the string
                   // if ($lang == 'is') { 
                       // $split_array=explode(':', $users_info_html14[$i15]['split'][2]);
                    //} else{
                        $split_array=explode(':', $users_info_html14[$i15]['split'][2]);
                    //}
              
                    $users_info_html14[$i15]['split_array']=$split_array;
                    
                    $users_info_html14[$i15]['total_h']=trim($split_array[0]);
                    $users_info_html14[$i15]['total_m']=trim($split_array[1]);
  
                
                    $i15++;
                }
            }*/
            
            //breaks
            $users_info_html7=[];
            $i8=0;
            foreach($breaks_info_html as $k=>$v){
                $total_string=trim($v);
                $users_info_html7[$i8]['raw']=$total_string;
                $users_info_html7[$i8]['split']=preg_split('/[\s!?]/u', $total_string, -1, PREG_SPLIT_NO_EMPTY);
                    
                $split_array=explode(':', $users_info_html7[$i8]['split'][2]);
                $users_info_html7[$i8]['split_array']=$split_array;
                    
                $users_info_html7[$i8]['total_h']+=$split_array[0];
                $users_info_html7[$i8]['total_m']+=$split_array[1];
  
                
                $i8++;
            }
            
            
                $i1++;
            }
        }//end manager users foreach
     
        //calc global total hours
        foreach($users_info_html1 as $item){
            $global_total_h+=$item['total_h'];
            $global_total_m+=$item['total_m'];
        }
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_sick_child1.html', print_r($users_info_html2, true), FILE_APPEND | LOCK_EX);
        //calc global daytime hours
        foreach($users_info_html2 as $item){
            $global_daytime_h+=$item['total_h'];
            $global_daytime_m+=$item['total_m'];       
        }
        //calc global afterwork hours
        foreach($users_info_html3 as $item){
            $global_afterwork_h+=$item['total_h'];
            $global_afterwork_m+=$item['total_m'];       
        }
        //calc global night time
        foreach($users_info_html4 as $item){
            $global_night_time_h+=$item['total_h'];
            $global_night_time_m+=$item['total_m'];       
        }
        //calc weekends time
        foreach($users_info_html5 as $item){
            $global_weekend_time_h+=$item['total_h'];
            $global_weekend_time_m+=$item['total_m'];       
        }
        //calc holidays 90 time
        foreach($users_info_html6 as $item){
            $global_holidays_time_h+=$item['total_h'];
            $global_holidays_time_m+=$item['total_m'];       
        }
        //calc holidays 45 time
        foreach($users_info_html8a as $item){
            $global_holidays_time_h_45+=$item['total_h'];
            $global_holidays_time_m_45+=$item['total_m'];       
        }
        //calc Sick time
        foreach($sick_html_0 as $item){
           $total_sick_h+=$item['total_h'];
           $total_sick_m+=$item['total_m'];       
        }
        //calc Sick child time
        if($this->sick_child_state==1) {
            foreach($users_info_html14 as $item){
                $total_sick_child_h+=$item['total_h'];
                $total_sick_child_m+=$item['total_m'];       
            }
        }
        //calc holidays time
        foreach($users_info_html7 as $item){
            $global_breaks_time_h+=$item['total_h'];
            $global_breaks_time_m+=$item['total_m'];       
        }
        
       /* $to1 = 'developer3452@gmail.com';
        $subject = 'Parser';
        $headers = "From: info@curiotime.com\r\n";

        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
                
        $message .= '<pre>'.print_r($holidays_info_html_45, true).'</pre>';
        $message .= '<pre>'.print_r($users_info_html3, true).'</pre>';
        //mail($to1, $subject, $message, $headers);*/
        

       // $final_total=$this->calcHours($global_total_h, $global_total_m);
        
        $layout = "";
        
        $model2 = JModelLegacy::getInstance('Time_Wages', 'AuditModel');
        $sick_state=$model2->getSickState($manager_user->owner_id);
        $special_companies=AuditController::getSpecialCompanies();

        JLoader::register('CtapiModelApi', JPATH_ROOT . '/components/com_audit/models/time_wages.php');
        $model = JModelLegacy::getInstance('Time_Wages', 'AuditModel');
        
        $customTotals = $model->getDkHeadersForTotalWithLang(0, $lang);
        //$layout .= "<pre>".print_r($customTotals,true)."</pre>";
        //$customTotals = $model->getDkHeadersForTotal($manager_user->owner_id);
        
        
        if(!empty($customTotals)) {
            $customTotals["daytime"]['h'] = $global_daytime_h;
            $customTotals["daytime"]['m'] = $global_daytime_m;

            $customTotals["after_hours"]['h'] = $global_afterwork_h;
            $customTotals["after_hours"]['m'] = $global_afterwork_m;
        
            if(!in_array($user->company, $special_companies)) {
                $customTotals["night"]['h'] = $global_night_time_h;
                $customTotals["night"]['m'] = $global_night_time_m;

                $customTotals["weekends"]['h'] = $global_weekend_time_h;
                $customTotals["weekends"]['m'] = $global_weekend_time_m;
            } else {
                unset($customTotals["night"]);
                unset($customTotals["weekends"]);
            }
            $customTotals["holidays_90"]['h'] = $global_holidays_time_h;
            $customTotals["holidays_90"]['m'] = $global_holidays_time_m;

            $customTotals["holidays_45"]['h'] = $global_holidays_time_h_45;
            $customTotals["holidays_45"]['m'] = $global_holidays_time_m_45;
            if($sick_state==1) {
                $customTotals["sick"]['h'] = $total_sick_h;
                $customTotals["sick"]['m'] = $total_sick_m;
            } else {
                unset($customTotals["sick"]);
            }
            
            if($this->sick_child_state==1) {
                $customTotals["sick_child"]['h'] = $total_sick_child_h;
                $customTotals["sick_child"]['m'] = $total_sick_child_m;
            } else {
                unset($customTotals["sick_child"]);
            }
            
            $customTotals  =  $model->sumDkHeadersForTotal($customTotals);        
        }
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_sick_child.html', print_r($users_info_html14, true), FILE_APPEND | LOCK_EX);
        if($is_load_for_new_pay_period == '1'){
            $additional_class = ' d-flex justify-content-between flex-column flex-sm-row flex-md-row flex-lg-row flex-xl-row new_layout_bottom_totals';
        }
        $layout .= '<div class="bottom_global_totals'.$additional_class.'">
                    <div class="span5">
                        <span class="span_bottom_global_total">'.JText::_("COM_AUDIT_COLLECT_TOTAL_TOTALS").'</span>
                    </div>
                    <div class="span4 offset3 custom_bootstrap_span">
                    <div class="row">
                    <div class="total-time">
                        <span class="">'.JText::_("COM_AUDIT_OVERVIEW_TIME_TOTAL_LOGIN").': </span>
                        <span class="total-hours total-h">
                            '.$this->calcHours($global_total_h, $global_total_m).'
               
                        </span>
                    </div>
                </div>';
        
        if(!empty($customTotals)):
            
                ob_start();
                ?>
                <?php  foreach ($customTotals as $key=>$item): ?>
                <div class="row"> 
                    <div class="bottom_time_panel <?php echo $item['c1']?>">
                        <span class="name-hours"><?php echo $item['label']?></span>
                        <span class="value-hours <?php echo $item['c2']?>">
                        <?php
                            $t  = $this->calcHours($item['h'],$item['m'],0,0);
                            $customTotals[$key]['total']  = $t;
                            echo $t;                            
                        ?>
                        </span>
                    </div>
                </div>
                <?php endforeach;  ?>    
                <?php
                
                    $layout .= ob_get_clean();                
            
        else:    
            $layout.=
                    '<div class="row"> 
                        <div class="bottom_time_panel daytime_wrapper">
                            <span class="name-hours">'.JText::_("COM_AUDIT_PAY_PERIOD_DAYTIME").'</span>
                            <span class="value-hours t-hours t-daytime">
                                '.$this->calcHours($global_daytime_h, $global_daytime_m).'
                            </span>
                        </div>
                    </div>';
            $layout.=
                    '<div class="row">   
                        <div class="bottom_time_panel afterwork_wrapper">
                            <span class="name-hours">'.JText::_("COM_AUDIT_PAY_PERIOD_AFTER_WORK").'</span>
                            <span class="value-hours t-afterwork">
                               '.$this->calcHours($global_afterwork_h, $global_afterwork_m).'
                            </span>  
                        </div>
                    </div>';

                    if(!in_array($manager_user->company, $special_companies)){    
                    $layout.='
                    <div class="row">   
                        <div class="bottom_time_panel night_time_wrapper">
                            <span class="name-hours">'.JText::_("COM_AUDIT_TIME_CARD_CALCULATION_NIGHT_TIME").'</span>
                            <span class="value-hours t-night_time">
                                '.$this->calcHours($global_night_time_h, $global_night_time_m).'
                            </span>  
                        </div>
                    </div>
                    <div class="row">
                        <div class="bottom_time_panel weekend_wrapper">
                            <span class="name-hours">'.JText::_("COM_AUDIT_PAY_PERIOD_WEEKEND").'</span>
                            <span class="value-hours t-weekend">
                               '.$this->calcHours($global_weekend_time_h, $global_weekend_time_m).'
                            </span>
                        </div>
                    </div>';
                    }


                    $layout.='
                    <div class="row">
                        <div class="bottom_time_panel holidays_wrapper">
                            <span class="name-hours">'.JText::_("COM_AUDIT_PAY_PERIOD_HOLIDAYS").' 90</span>
                            <span class="value-hours t-holidays">
                               '.$this->calcHours($global_holidays_time_h, $global_holidays_time_m).'
                            </span>
                        </div>
                    </div>
                    <div class="row">
                        <div class="bottom_time_panel holidays_wrapper">
                            <span class="name-hours">'.JText::_("COM_AUDIT_PAY_PERIOD_HOLIDAYS").' 45</span>
                            <span class="value-hours t-holidays">
                               '.$this->calcHours($global_holidays_time_h_45, $global_holidays_time_m_45).'
                            </span>
                        </div>
                    </div>';

                    if($sick_state==1){
                        $layout.='
                            <div class="row">
                                <div class="bottom_time_panel holidays_wrapper">
                                    <span class="name-hours">'.JText::_("COM_AUDIT_PAY_PERIOD_SICK").'</span>
                                    <span class="value-hours t-holidays">
                                        '.$this->calcHours($total_sick_h, $total_sick_m).'
                                    </span>
                                </div>
                            </div>';
                    } 
                    if($this->sick_child_state==1){
                        $layout.='
                            <div class="row">
                                <div class="bottom_time_panel sick_child_wrapper">
                                    <span class="name-hours">'.JText::_("COM_AUDIT_TIME_DK_HEADER_SICK_CHILD").'</span>
                                    <span class="value-hours t-holidays">
                                        '.$this->calcHours($total_sick_child_h, $total_sick_child_m).'
                                    </span>
                                </div>
                            </div>';
                    }
        endif;
                $layout.='
                <div class="row">
                    <div class="bottom_time_panel break_wrapper">
                        <span class="name-hours">'.JText::_("COM_AUDIT_PAY_PERIOD_TOTAL_BREAK").'</span>
                        <span class="value-hours t-breaks">
                            '.$this->calcHours($global_breaks_time_h, $global_breaks_time_m).'
                        </span>
                    </div>
                </div>
               
               
                
                
           
        </div>';
        
                
                
        $html[$i]['pay_period'].=htmlspecialchars($layout); 
        
        if($parser_mode==='simplehtml'){
            //clean memory
            $html1->clear(); 
            unset($html1);
        }
        
        
        //temporary save pay periods
        $this->savePayPeriod(strip_tags($token), $html);
        
    }
    
    private function calcHours($total_h1, $total_m1, $limit = 0, $echo = 1){
      //  file_put_contents('/home/curiotime/app.curiotime.com/logs/collect.html', print_r($total_h1.'-'.$total_m1.'<br/>'.PHP_EOL, true),  FILE_APPEND | LOCK_EX); 
        
        $h = @$total_h1 * 3600;
        $m = @$total_m1 * 60;
        $s = $h + $m;

        $hour = floor($s / 3600);
        $sec = $s - ($hour * 3600);
        $min = ($sec / 60);
        $sec = $sec - ($min * 60);

        if ($min < 10) {
            $min = '0' . $min;
        }

        if($hour >= 8 && $limit != 0){
            if($echo == 1){
                return "08:00";
            } else{
                return "08:00";
            }
        } else{
            if($echo == 1){
                return $hour . ":" . $min;
            } else{
                return $hour . ":" . $min;
            }
        }
    }
    
    private function savePayPeriod($token, $html)
    {
        $item=new stdClass();
        $item->id=null;
        $item->unical_key=trim($token);
        $item->html= json_encode($html);
        $item->datetime=date('d.m.Y H:i:s');
        $item->timestamp=time();
        $item->date=date('d.m.Y');
        
        $this->db->insertObject('#__temp_collect', $item);
        
    }
    
    public function getCollectStatus($token)
    {
        ini_set('memory_limit', '-1');
        $query='SELECT `html` FROM #__temp_collect WHERE `unical_key`="'.$token.'"';
        $this->db->setQuery( $query );
        $res = $this->db->loadObject()->html; 
        
        return $res;
    }
    
    public function deleteTempData($token)
    {
        $query = "DELETE FROM `#__temp_collect` WHERE `unical_key` = '$token';";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function getInputsPayPeriod($u_id)
    {
        $user_obj = & JFactory::getUser($u_id);
        
        //$u_id=(int)$u_id;
        $query = "SELECT * FROM #__pay_period_preserved WHERE `id_user` = '$user_obj->owner_id'";
        $this->db->setQuery($query);
        //get current gps status
        $res = $this->db->loadObject();
        
        //file_put_contents('/home/curiotime/app.curiotime.com/logs/collect.html', print_r($query.PHP_EOL, true),  FILE_APPEND | LOCK_EX); 
         
        if(empty($res)){
            $from_date='25.'.date('m.Y', strtotime('-1 month'));
            $to_date='24.'.date('m.Y', strtotime('+0 month')); 
            
            $res['id_user']=$u_id;
            $res['from_date']=$from_date;
            $res['to_date']=$to_date;
            $res=(object)$res;
        }
       // return json_encode($res);
        return $res;
    }
    
    public function getFromTo($u_id) {
        $from_to = $this->getInputsPayPeriod($u_id);
        
        //file_put_contents('/home/curiotime/app.curiotime.com/logs/collect.html', print_r($from_to.PHP_EOL, true), FILE_APPEND | LOCK_EX); 
         
        $current_date = date('d.m.Y');

        $from_date1 = DateTime::createFromFormat('d.m.Y', $from_to->from_date);
        $from_date2 = $from_date1->format('d');
        $from_date = $from_date2 . date('.m.Y');

        $to_date1 = DateTime::createFromFormat('d.m.Y', $from_to->to_date);
        $to_date2 = $to_date1->format('d');

        if ($from_date2 == '01')
            $to_date = $to_date2 . date('.m.Y');
        else
            $to_date = $to_date2 . date('.m.Y', strtotime('+1month'));

        //echo '<br/>'.$from_date;

        if ($current_date < $from_date) {
            //echo 'попали';
            $from_date_row = DateTime::createFromFormat('d.m.Y', $from_date)->format('Y-m-d');

            $from_date_strtotime = strtotime($from_date_row . '-1months');
            //$from_date_strtotime1=strtotime("$from_date_strtotime -1 month");
            $from_date = date('d.m.Y', $from_date_strtotime);
            $from_date00 = date('Y-m-d', $from_date_strtotime);
            $count_days_in_month = date('t', strtotime($from_date00));

            if ($count_days_in_month == 31) {
                $from_date_strtotime = strtotime($from_date_row . '-1months');
                $from_date = date('d.m.Y', $from_date_strtotime);
            }


            $to_date_row = DateTime::createFromFormat('d.m.Y', $from_date)->format('Y-m-d');
            $to_date_strtotime = strtotime($to_date_row . '+1months -1days');
            $to_date = date('d.m.Y', $to_date_strtotime);
        }
        if (empty($from_date) && empty($to_date)) {
            $from_final = '25' . date('m.Y', strtotime('-1 month'));
            $to_final = '24' . date('m.Y', strtotime('+0 month'));
        } else {
            $from_final=$from_date;
            $to_final=$to_date;
        }
        
        return [
            'from'=>$from_final,
            'to'=>$to_final
        ];
    }
    
    private function getUsersFromManager($manager_id)
    {
        $manager_id=(int)$manager_id;
        $query='SELECT * FROM #__users WHERE `owner_id`="'.$manager_id.'" ORDER by id ASC';
        //ORDER BY `username0` ASC
        //$query='SELECT * FROM #__users WHERE `owner_id`="'.$manager_id.'" ORDER BY `username0` ASC';
        $this->db->setQuery( $query );
        $items = $this->db->loadObjectList(); 
        
        //ksort($items);
        return $items;
    }
    
    private function compare($a, $b)
    {
        //$alphabet = 'aąbcćdeęfghijklłmnnoóqprstuvwxyzźż'; // i used polish letters
        $alphabet =  'aábcdðeéfghiíjklmnoópqrstuúvwxyýzþæö';
        
        $a = mb_strtolower($a->username0);
        $b = mb_strtolower($b->username0);

        for ($i = 0; $i < mb_strlen($a); $i++) {
            if (mb_substr($a, $i, 1) == mb_substr($b, $i, 1)) {
                continue;
            }
            if ($i > mb_strlen($b)) {
                return 1;
            }
            if (mb_strpos($alphabet, mb_substr($a, $i, 1)) > mb_strpos($alphabet, mb_substr($b, $i, 1))) {
                return 1;
            } else {
                return -1;
            }
        }
    }

    private function getUsersFromManagerCheckHidden($manager_id)
    {
        $manager_id = (int)$manager_id;
        $query = 'SELECT * FROM #__users WHERE `owner_id`="'.$manager_id.'" AND `is_hide`="0" ORDER by id ASC';
      
        $this->db->setQuery( $query );
        $items = $this->db->loadObjectList(); 
        
        usort($items, [$this, 'compare']);
       
        ksort($items);
     
        return $items;
    }
    
    //here0
    public function createCsvCollect($lang, $filename, $from, $to, $user_id, $additional_mode, $note, $is_load_for_new_pay_period) { 
        ini_set('memory_limit', '-1');
        
        $manager_info = JFactory::getUser($user_id);
      
        if($lang=="is"){
            $l = 'is';
        } else{
            $l = 'en';
        }
        $model = JModelLegacy::getInstance('Time_Wages', 'AuditModel');
        $sick_state = $model->getSickState($manager_info->owner_id); 
        
        if(in_array(6, $manager_info->groups) || in_array(10, $manager_info->groups)) {//from manager
            $csv_array=[];
            $i=0;
            if($l==='is'){
               $this->lang->setLanguage('is-IS');
               $this->lang->load();
            } 
            
           
            if(in_array(6, $manager_info->groups)){
                $manager_users_object = $this->getUsersFromManagerCheckHidden($manager_info->id);//get manager users
            } elseif(in_array(10, $manager_info->groups)){
                $manager_users_object = $this->getUsersFromManagerCheckHidden($manager_info->owner_id);//get manager users
            }
            //$manager_users_object=$this->getUsersFromManagerCheckHidden($manager_info->id);//get manager users
            $space='                                                        ';
            
            $csv_array[]=[JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS').date('d.m.Y').$space];
            $csv_array[]=[JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_PAY_PERIOD').$space];
            $csv_array[]=[JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_FROM').$from.$space];
            $csv_array[]=[JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_TO').$to.$space];
           
            if($additional_mode=='search'){        
                $prepare_note=$this->db->escape(trim($note));
                $csv_array[]=[JText::_('COM_AUDIT_COLLECT_CSV_SEARCH_RESULT').' '.$prepare_note.$space];
            }
            
            $csv_array[]=[$space];
            $csv_array[]=[$space];

            include_once($this->current_home_path.'/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
      
            $j=0;
            $count=count($manager_users_object);
            $special_companies=AuditController::getSpecialCompanies();
            
            $totals  =  array();
            
            JLoader::register('AuditModelRules', JPATH_ROOT . '/components/com_audit/models/rules.php');
            $model_rules = JModelLegacy::getInstance('Rules', 'AuditModel');
           
            $uCount =   0;
            foreach($manager_users_object as $manager_user) {
                $u  =  JFactory::getUser($manager_user->id);
                if(in_array(6, $u->groups)) 
                    continue;
                
                $uCount ++;
            }
            $userSpaceUsed  = 0;
            foreach($manager_users_object as $manager_user) {
                
                unset($htmlSrc);
                unset($json);
                unset($arr);
                unset($link);
                
              
                
                $u  =  JFactory::getUser($manager_user->id);
                if(in_array(6, $u->groups)) continue;      
                
                
                $userSpaceUsed  = 0;
                
                $rule_mode=$model_rules->getUserRuleForText($manager_user->id);
                $header_texts_obj=$model_rules->getTexts($rule_mode['mode'], $rule_mode['rule_id'], $lang);
            
                switch($additional_mode){
                    case 'search':
                        /*$link = $this->current_url.'index.php?task=getTimeByPeriodCollectSearch'
                            . '&totals2=1'
                            . '&from=' . $from . ''
                            . '&to=' . $to . ''
                            . '&u_id='.$manager_user->id.''
                            . '&lang=' . $lang . ''
                            . '&mode=pdf'
                            . '&mode_all_user=1'
                            . '&note='.$note.''
                            . '&is_load_for_new_pay_period='.$is_load_for_new_pay_period; */
                        
                        $link = $this->current_url.'index.php?task=getTimeByPeriodCollectSearch';
                        $post = [
                            'totals2' => '1',
                            'from' => $from,
                            'to' => $to,
                            'u_id' => $manager_user->id,
                            'lang' => $lang, 
                            'mode' => 'pdf',
                            'mode_all_user' => 1,
                            'note' => $note,
                            'is_load_for_new_pay_period' => $is_load_for_new_pay_period
                        ];
                        
                    break;
                    default:
                        //$link = $this->current_url.'index.php?task=getTimeByPeriodCollect&totals2=1&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1&is_load_for_new_pay_period='.$is_load_for_new_pay_period; 
                        $link = $this->current_url.'index.php?task=getTimeByPeriodCollect';
                        $post = [
                            'totals2' => '1',
                            'from' => $from,
                            'to' => $to,
                            'u_id' => $manager_user->id,
                            'lang' => $lang, 
                            'mode' => 'pdf',
                            'mode_all_user' => 1,
                            'note' => $note,
                            'is_load_for_new_pay_period' => $is_load_for_new_pay_period
                        ];
                    break;
                }
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_s_fix.html', print_r($post, true), FILE_APPEND | LOCK_EX);
                //echo $link.PHP_EOL;
                
                //echo $additional_mode."\r\n";    
               
               
                /*try{
                    $htmlSrc0  = file_get_contents($link);
                } catch (Exception $ex) {
                    echo $ex;
                }
               $htmlSrc = urlencode($htmlSrc0);*/
                
                
               // file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_s_fix.html', print_r($post, true), FILE_APPEND | LOCK_EX);
                
                if( $curl = curl_init() ) {
                    curl_setopt($curl, CURLOPT_URL, $link);
                    curl_setopt($curl, CURLOPT_RETURNTRANSFER,true);
                    curl_setopt($curl, CURLOPT_POST, true);
                    curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($post));
                    $out = curl_exec($curl);
                    $htmlSrc =  $out;
                    //exit;
                    curl_close($curl);
                }
                
                //echo '$htmlSrc:'.$htmlSrc;
               // echo json_decode($htmlSrc);
                //$html = str_get_html($htmlSrc);//simple html
                //$html = file_get_html($link);//simple html
                /*echo '<pre>';
                print_r(htmlspecialchars($htmlSrc));
                echo '</pre>';*/
               
                $mode=$this->getSelectedModeItemNumber($manager_user->id, $l);
                
              
                $k0=0;
                
                
                
                
                
                if(preg_match("#<!--json-dk-totals--(.*)--json-dk-totals-->#", $htmlSrc, $arr)) {
                   // echo 'match';
                
                    $csv_array[]=[
                        $manager_user->username0.' - '.$manager_user->username,
                        '',
                        $mode,
                        JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_TOTAL')
                    ];
                    
                    $json  =  trim($arr[1]);
                    $json  = json_decode($json, true);
                    /*echo '<pre>';
                    print_r($json);
                    echo '</pre>';*/
                    if(empty($json)) 
                        continue;
                } else {
                    $userSpaceUsed  = 1;
                }
                /*
                foreach ($json as $k=>$item) {
                    if(!in_array($item['pos'], $csvHeaders)) {
                        $csvHeaders[$item['pos']]  = $item['pos'];
                    }
                    //$json[$k]['total'] = $this->formatTime($item['total']);
                }
                */
                
                
                if(isset($json['break'])) {
                    $json['break']['label'] = JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_BREAKS');
                }               
                if(isset($json['total'])) {
                    $json['total']['label'] = JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_TOTAL');
                }
                
                
                foreach ($json as $k => $item) {
                    if($k=='after_hours'){
                     
                        $csv_array[]=[
                            '',
                            $header_texts_obj->after_hours_text,
                            '',
                            $item['total']
                        ];
                    } elseif($k=='night'){
                        
                        $csv_array[]=[
                            '',
                            $header_texts_obj->night_time_text,
                            '',
                            $item['total']
                        ];
                    } elseif($k == 'weekends'){
                        
                        $csv_array[]=[
                            '',
                            $header_texts_obj->weekends_text,
                            '',
                            $item['total']
                        ];
                    } else{
                        if($k != 'total'){
                            $csv_array[]=[
                                '',
                                $item['label'],
                                '',
                                $item['total']
                            ];
                        }
                    }
                                
                    
                    
                    if(!isset($totals[$k]['h']))
                        $totals[$k]['h']  = 0;                    
                    if(!isset($totals[$k]['m']))
                        $totals[$k]['m']  = 0;
                    
                    if(!isset($totals[$k]['label']))
                        $totals[$k]['label']  = $item['label'];
                    
                    $t  = explode(":", $item['total']);
                    
                    $totals[$k]['h'] += intval($t[0]);
                    $totals[$k]['m'] += intval($t[1]);
                }
                
                
                $i1++;
                if(strlen(trim($note)) < 1 && $userSpaceUsed == 0) {                
                    $userSpaceUsed ++;
                    $csv_array[]=[' '.$space];
                    $csv_array[]=[' '.$space];
                }
                if($uCount > 1 && $userSpaceUsed == 0) {
                    $userSpaceUsed ++;
                    $csv_array[]=[' '.$space];
                    $csv_array[]=[' '.$space];
                }
            }
            $csv_array[]=[
                '-----------------------'
            ];
            
           
           
            //if($manager_user->id == 3890){
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_new_breaks.html', print_r($totals, true), FILE_APPEND | LOCK_EX);
           // }
            if(isset($totals['new_breaks'])){
                //$global_totals_break_arr = explode(':', $totals['breaks']);
                $global_totals_break_h = $totals['break']['h'];
                $global_totals_break_m = $totals['break']['m'];
                
                //$global_totals_break_new_arr = explode(':', $totals['new_breaks']);
                $global_totals_break_new_h = $totals['new_breaks']['h'];
                $global_totals_break_new_m = $totals['new_breaks']['m'];
                
                
                $global_totals_break_new_h += $global_totals_break_h;
                $global_totals_break_new_m += $global_totals_break_m;
                
                $totals['new_breaks']['h'] = $global_totals_break_new_h;
                $totals['new_breaks']['m'] = $global_totals_break_new_m;
                
                unset($totals['break']);
            }
            
            foreach ($totals as $key=>$item) {
                if($key == 'total'){
                    continue;
                }
                    
                $h  =  $item['h'] * 60 * 60;
                $m  =  $item['m'] * 60;
                $total  =  $h + $m;
                
                $hours = floor($total / 3600);
                $minutes = floor(($total / 60) % 60);
                $seconds = $total % 60;        
                if($minutes < 10)
                    $minutes =  "0".$minutes;
                if($seconds < 10)
                    $seconds =  "0".$seconds;
                $total =    "{$hours}:{$minutes}";
                $item['total'] =  $total;
                
                
                
                $csv_array[]=[
                    $item['label'],
                    $item['total']
                ];
            }
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_csv_s.html', print_r( $csv_array, true), FILE_APPEND | LOCK_EX);
            
            $pathFile = JPATH_BASE.DS.'tmp_csv_collect'.DS.$filename; 
            $fp = fopen($pathFile, 'w');//open file
            fwrite($fp,b"\xEF\xBB\xBF");//write special iceland symbols
            
            foreach ($csv_array as $fields) {
                fputcsv($fp, $fields, ';');
            }       
            fclose($fp);  
        }
    }
    
    public function createCsvCollect_old2($lang, $filename, $from, $to, $user_id, $additional_mode, $note)
    { 
        $manager_info= JFactory::getUser($user_id);
      
        if($lang=="is"){
            $l = 'is';
        } else{
            $l = 'en';
        }
        $model = JModelLegacy::getInstance('Time_Wages', 'AuditModel');
        $sick_state=$model->getSickState($manager_info->owner_id); 
        
        if(in_array(6, $manager_info->groups)) {//from manager
            $csv_array=[];
            $i=0;
            if($l==='is'){
               $this->lang->setLanguage('is-IS');
               $this->lang->load();
            } 
            
           
            
            $manager_users_object=$this->getUsersFromManagerCheckHidden($manager_info->id);//get manager users
            $space='                                                        ';
            
            $csv_array[]=[JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS').date('d.m.Y').$space];
            $csv_array[]=[JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_PAY_PERIOD').$space];
            $csv_array[]=[JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_FROM').$from.$space];
            $csv_array[]=[JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_TO').$to.$space];
           
            if($additional_mode=='search'){        
                $prepare_note=$this->db->escape(trim($note));
                $csv_array[]=[JText::_('COM_AUDIT_COLLECT_CSV_SEARCH_RESULT').' '.$prepare_note.$space];
            }
            
            $csv_array[]=[$space];
            $csv_array[]=[$space];

            include_once($this->current_home_path.'/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
      
            $j=0;
            $count=count($manager_users_object);
            $special_companies=AuditController::getSpecialCompanies();
            
            foreach($manager_users_object as $manager_user){
               
                switch($additional_mode){
                    case 'search':
                        $link=$this->current_url.'/index.php?task=getTimeByPeriodCollectSearch&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1&note='.$note;         
                    break;
                    default:
                        $link=$this->current_url.'/index.php?task=getTimeByPeriodCollect&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1';
                    break;
                }
                
                
                
                
                $html = file_get_html($link);//simple html
                
               
                $mode=$this->getSelectedModeItemNumber($manager_user->id, $l);
                
             
                $users_info_html=[];
                $i=0;
                foreach($html->find('div[class="span4 offset8 custom_bootstrap_span"] div span') as $e){                 
                    $users_info_html[]=$e->plaintext;
                }  
               
                $k0=0;
                
                $csv_array[]=[
                    $manager_user->username0.' - '.$manager_user->username,
                    '',
                    $mode,
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_TOTAL')
                ];
                
                if($l==='is'){
                    $sick_text='Veikindi';
                } else{
                    $sick_text='Sick time';
                }
                //standart companies
                if(!in_array($manager_user->company, $special_companies)){
                    if($sick_state==1){
                        $items_name_array=[
                            1=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_TOTAL'),
                            3=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_DAYTIME'),
                            5=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_AFTER_WORK'),
                            7=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_NIGHT_TIME'),
                            9=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_WEEKENDS'),
                    
                            11=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_HOLIDAYS'),
                            13=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_HOLIDAYS_45'),
                            15=>$sick_text,
                            17=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_BREAKS')
                        ];
                    } else{
                        $items_name_array=[
                            1=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_TOTAL'),
                            3=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_DAYTIME'),
                            5=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_AFTER_WORK'),
                            7=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_NIGHT_TIME'),
                            9=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_WEEKENDS'),
                    
                            11=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_HOLIDAYS'),
                            13=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_HOLIDAYS_45'),
                            //15=>$sick_text,
                            15=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_BREAKS')
                        ];
                    }
                } else{//special companies
                    if($sick_state==1){
                        $items_name_array=[
                            1=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_TOTAL'),
                            3=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_DAYTIME'),
                            5=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_AFTER_WORK'),
                            7=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_HOLIDAYS'),
                            9=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_HOLIDAYS_45'),
                            11=>$sick_text,
                            13=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_BREAKS')
                        ];
                    } else{
                        $items_name_array=[
                            1=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_TOTAL'),
                            3=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_DAYTIME'),
                            5=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_AFTER_WORK'),
                            7=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_HOLIDAYS'),
                            9=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_HOLIDAYS_45'),
                            //11=>$sick_text,
                            11=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_BREAKS')
                        ];
                    }
                }
                
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_csv_s.html', print_r($items_name_array, true), FILE_APPEND | LOCK_EX);
                 
                foreach($users_info_html as $k=>$v){
                    
                    if($k0%2!=0){
                       $total_string=trim($v);
                        $csv_array[]=[
                            '',
                            $items_name_array[$k],
                            '',
                            (string)$total_string
                        ];
                    }
                    
                    $k0++;
                }
               //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_csv_s.html', print_r($items_name_array, true), FILE_APPEND | LOCK_EX);

                $csv_array[]=[' '.$space];
                $csv_array[]=[' '.$space];
                
               
            
                $j++;
            }
            
           
            
            ////////////global total
            $csv_array[]=[
                '-----------------------'
            ];
            $i1=0;
            $global_total_h='';
            $global_total_m='';
        
            $global_daytime_h='';
            $global_daytime_m='';
        
            $global_afterwork_h='';
            $global_afterwork_m='';
        
            $global_night_time_h='';
            $global_night_time_m='';
        
            $global_weekend_time_h='';
            $global_weekend_time_m=''; 
       
            $global_holidays_time_h='';
            $global_holidays_time_m='';
            
            $global_holidays_time_h_45='';
            $global_holidays_time_m_45='';
        
            $global_breaks_time_h='';
            $global_breaks_time_m='';
            
            $total_sick_h='';
            $total_sick_m='';
        
            foreach($manager_users_object as $manager_user){
                switch($additional_mode){
                    case 'search':
                        $link=$this->current_url.'/index.php?task=getTimeByPeriodCollectSearch&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1&note='.$note; 
                    break;
                    default:
                        $link=$this->current_url.'/index.php?task=getTimeByPeriodCollect&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1';
                    break;
                }
           
                $html2 = file_get_html($link);
            
                //total array
                foreach($html2->find('div[class="total-time"]') as $ee){
                    //$users_info_html[$i1]=htmlspecialchars($ee->plaintext); 
                    $total_info_html[$i1]=htmlspecialchars($ee->plaintext);  // fix 1 of 2, total in csv 23.09.19
                }
                //daytime array
                foreach($html2->find('div[class="daytime_wrapper"]') as $ee){
                    $daytime_info_html[$i1]=htmlspecialchars($ee->plaintext);          
                }
                //afterwork array
                foreach($html2->find('div[class="afterwork_wrapper"]') as $ee){
                    $afterwork_info_html[$i1]=htmlspecialchars($ee->plaintext);          
                }
                //night time array
                foreach($html2->find('div[class="night_time_wrapper"]') as $ee){
                    $night_time_info_html[$i1]=htmlspecialchars($ee->plaintext);          
                }
                //weekends array
                foreach($html2->find('div[class="weekend_wrapper"]') as $ee){
                    $weekend_info_html[$i1]=htmlspecialchars($ee->plaintext);          
                }
                //holidays 90 array
                foreach($html2->find('div[class="holidays_wrapper"]') as $ee){
                    $holidays_info_html[$i1]=htmlspecialchars($ee->plaintext);          
                }
                //holidays 45 array
                foreach($html2->find('div[class="holidays_wrapper_45"]') as $ee){
                    $holidays_info_html_45[$i1]=htmlspecialchars($ee->plaintext);
                }
                //sick array
                foreach($html2->find('div[class="sick_wrapper"]') as $ee){
                    $sick_html[$i1]=htmlspecialchars($ee->plaintext);          
                }
                //breaks total array
                foreach($html2->find('div[class="break_wrapper"]') as $ee){
                    $breaks_info_html[$i1]=htmlspecialchars($ee->plaintext);          
                }

                //total 
                $users_info_html1=[];
                $i2=0;
                //foreach($users_info_html as $k=>$v){
                  foreach($total_info_html as $k=>$v){  // fix 2 of 2, total in csv 23.09.19
                    $total_string=trim($v);
                    $users_info_html1[$i2]['raw']=$total_string;
                    $users_info_html1[$i2]['split']=preg_split('/[\s!?]/u', $total_string, -1, PREG_SPLIT_NO_EMPTY);
                    
                    $split_array=explode(':', $users_info_html1[$i2]['split'][1]);
                    $users_info_html1[$i2]['split_array']=$split_array;
                    
                    $users_info_html1[$i2]['total_h']+=$split_array[0];
                    $users_info_html1[$i2]['total_m']+=$split_array[1];
  
                
                    $i2++;
                }
            
                //daytime
                $users_info_html2=[];
                $i3=0;
                foreach($daytime_info_html as $k=>$v){
                    $total_string=trim($v);
                    $users_info_html2[$i3]['raw']=$total_string;
                    $users_info_html2[$i3]['split']=preg_split('/[\s!?]/u', $total_string, -1, PREG_SPLIT_NO_EMPTY);
                    
                    $split_array=explode(':', $users_info_html2[$i3]['split'][1]);
                    $users_info_html2[$i3]['split_array']=$split_array;
                    
                    $users_info_html2[$i3]['total_h']+=$split_array[0];
                    $users_info_html2[$i3]['total_m']+=$split_array[1];
  
                
                    $i3++;
                }
            
                //afterwork
                $users_info_html3=[];
                $i4=0;
                foreach($afterwork_info_html as $k=>$v){
                    $total_string=trim($v);
                    $users_info_html3[$i4]['raw']=$total_string;
                    $users_info_html3[$i4]['split']=preg_split('/[\s!?]/u', $total_string, -1, PREG_SPLIT_NO_EMPTY);
                
                    //because Icelandic words have a different number of spaces, in which we break the string
                    if ($lang == 'is') {
                        $split_array=explode(':', $users_info_html3[$i4]['split'][1]);
                    } else{
                        $split_array=explode(':', $users_info_html3[$i4]['split'][2]);
                    }
               
                    $users_info_html3[$i4]['split_array']=$split_array;
                    
                    $users_info_html3[$i4]['total_h']+=$split_array[0];
                    $users_info_html3[$i4]['total_m']+=$split_array[1];
  
                
                    $i4++;
                }
            
                //night time
                $users_info_html4=[];
                $i5=0;
                foreach($night_time_info_html as $k=>$v){
                    $total_string=trim($v);
                    $users_info_html4[$i5]['raw']=$total_string;
                    $users_info_html4[$i5]['split']=preg_split('/[\s!?]/u', $total_string, -1, PREG_SPLIT_NO_EMPTY);
                
                    //because Icelandic words have a different number of spaces, in which we break the string
                    if ($lang == 'is') { 
                        $split_array=explode(':', $users_info_html4[$i5]['split'][1]);
                    } else{
                        $split_array=explode(':', $users_info_html4[$i5]['split'][2]);
                    }
              
                    $users_info_html4[$i5]['split_array']=$split_array;
                    
                    $users_info_html4[$i5]['total_h']+=$split_array[0];
                    $users_info_html4[$i5]['total_m']+=$split_array[1];
  
                
                    $i5++;
                }
            
                //weekends
                $users_info_html5=[];
                $i6=0;
                foreach($weekend_info_html as $k=>$v){
                    $total_string=trim($v);
                    $users_info_html5[$i6]['raw']=$total_string;
                    $users_info_html5[$i6]['split']=preg_split('/[\s!?]/u', $total_string, -1, PREG_SPLIT_NO_EMPTY);
                    
                    $split_array=explode(':', $users_info_html5[$i6]['split'][1]);
                    $users_info_html5[$i6]['split_array']=$split_array;
                    
                    $users_info_html5[$i6]['total_h']+=$split_array[0];
                    $users_info_html5[$i6]['total_m']+=$split_array[1];
  
                
                    $i6++;
                }
            
                //holidays 90
                $users_info_html6=[];
                $i7=0;
                foreach($holidays_info_html as $k=>$v){
                    $total_string=trim($v);
                    $users_info_html6[$i7]['raw']=$total_string;
                    $users_info_html6[$i7]['split']=preg_split('/[\s!?]/u', $total_string, -1, PREG_SPLIT_NO_EMPTY);

                    $split_array=explode(':',  $users_info_html6[$i7]['split'][2]);

                    $users_info_html6[$i7]['split_array']=$split_array;
                    $users_info_html6[$i7]['total_h']+=$split_array[0];
                    $users_info_html6[$i7]['total_m']+=$split_array[1];


                    $i7++;
                }
                
                //holidays 45
                $users_info_html8a=[];
                $i9a=0;
                foreach($holidays_info_html_45 as $k=>$v){
                    $total_string=trim($v);
                    $users_info_html8a[$i9a]['raw']=$total_string;
                    $users_info_html8a[$i9a]['split']=preg_split('/[\s!?]/u', $total_string, -1, PREG_SPLIT_NO_EMPTY);

                    $split_array=explode(':',  $users_info_html8a[$i9a]['split'][2]);
       
                    $users_info_html8a[$i9a]['split_array']=$split_array;
                    $users_info_html8a[$i9a]['total_h']+=$split_array[0];
                    $users_info_html8a[$i9a]['total_m']+=$split_array[1];
                    
                    $i9a++;
                }
                
                //Sick
                $sick_html_0=[];
                $i10a=0;
                foreach($sick_html as $k=>$v){
                    $total_string=trim($v);
                    $sick_html_0[$i10a]['raw']=$total_string;
                    $sick_html_0[$i10a]['split']=preg_split('/[\s!?]/u', $total_string, -1, PREG_SPLIT_NO_EMPTY);

                    $split_array=explode(':',  $sick_html_0[$i10a]['split'][2]);
       
                    $sick_html_0[$i10a]['split_array']=$split_array;
                    $sick_html_0[$i10a]['total_h']+=$split_array[0];
                    $sick_html_0[$i10a]['total_m']+=$split_array[1];
                    
                    $i10a++;
                }
                
                //breaks
                $users_info_html7=[];
                $i8=0;
                foreach($breaks_info_html as $k=>$v){
                    $total_string=trim($v);
                    $users_info_html7[$i8]['raw']=$total_string;
                    $users_info_html7[$i8]['split']=preg_split('/[\s!?]/u', $total_string, -1, PREG_SPLIT_NO_EMPTY);
                    
                    $split_array=explode(':', $users_info_html7[$i8]['split'][2]);
                    $users_info_html7[$i8]['split_array']=$split_array;
                    
                    $users_info_html7[$i8]['total_h']+=$split_array[0];
                    $users_info_html7[$i8]['total_m']+=$split_array[1];
  
                
                    $i8++;
                }
            
            
            $i1++;
        }
        
        //calc global total hours
        foreach($users_info_html1 as $item){
            $global_total_h+=$item['total_h'];
            $global_total_m+=$item['total_m'];
        }
        //calc global daytime hours
        foreach($users_info_html2 as $item){
            $global_daytime_h+=$item['total_h'];
            $global_daytime_m+=$item['total_m'];       
        }
        //calc global afterwork hours
        foreach($users_info_html3 as $item){
            $global_afterwork_h+=$item['total_h'];
            $global_afterwork_m+=$item['total_m'];       
        }
        //calc global night time
        foreach($users_info_html4 as $item){
            $global_night_time_h+=$item['total_h'];
            $global_night_time_m+=$item['total_m'];       
        }
        //calc weekends time
        foreach($users_info_html5 as $item){
            $global_weekend_time_h+=$item['total_h'];
            $global_weekend_time_m+=$item['total_m'];       
        }
        //calc holidays 90 time
        foreach($users_info_html6 as $item){
            $global_holidays_time_h+=$item['total_h'];
            $global_holidays_time_m+=$item['total_m'];       
        }
        //calc holidays 45 time
        foreach($users_info_html8a as $item){
            $global_holidays_time_h_45+=$item['total_h'];
            $global_holidays_time_m_45+=$item['total_m'];       
        }
        //calc Sick time
        foreach($sick_html_0 as $item){
           $total_sick_h+=$item['total_h'];
           $total_sick_m+=$item['total_m'];       
        }
        //calc breaks time
        foreach($users_info_html7 as $item){
            $global_breaks_time_h+=$item['total_h'];
            $global_breaks_time_m+=$item['total_m'];       
        }
            
            //standart companies
            if(!in_array($manager_info->company, $special_companies)){
                if($sick_state==1){//Include sick time enabled
                    $csv_array[]=[
                        $items_name_array[1].' '.$this->calcHours($global_total_h, $global_total_m)
                    ];
                    $csv_array[]=[
                        $items_name_array[3].' '.$this->calcHours($global_daytime_h, $global_daytime_m)  
                    ];
                    $csv_array[]=[
                        $items_name_array[5].' '.$this->calcHours($global_afterwork_h, $global_afterwork_m) 
                    ];
                    $csv_array[]=[
                        $items_name_array[7].' '.$this->calcHours($global_night_time_h, $global_night_time_m)
                    ];
                    $csv_array[]=[
                        $items_name_array[9].' '.$this->calcHours($global_weekend_time_h, $global_weekend_time_m)
                    ];
                    $csv_array[]=[
                        $items_name_array[11].' '.$this->calcHours($global_holidays_time_h, $global_holidays_time_m)
                    ];
                    $csv_array[]=[
                        $items_name_array[13].' '.$this->calcHours($global_holidays_time_h_45, $global_holidays_time_m_45)
                    ];
                    //sick
                    $csv_array[]=[
                        $items_name_array[15].' '.$this->calcHours($total_sick_h, $total_sick_m)
                    ];
                    $csv_array[]=[
                        $items_name_array[17].' '.$this->calcHours($global_breaks_time_h, $global_breaks_time_m)
                    ];
                } else{//Include sick time disabled
                    $csv_array[]=[
                        $items_name_array[1].' '.$this->calcHours($global_total_h, $global_total_m)
                    ];
                    $csv_array[]=[
                        $items_name_array[3].' '.$this->calcHours($global_daytime_h, $global_daytime_m)  
                    ];
                    $csv_array[]=[
                        $items_name_array[5].' '.$this->calcHours($global_afterwork_h, $global_afterwork_m) 
                    ];
                    $csv_array[]=[
                        $items_name_array[7].' '.$this->calcHours($global_night_time_h, $global_night_time_m)
                    ];
                    $csv_array[]=[
                        $items_name_array[9].' '.$this->calcHours($global_weekend_time_h, $global_weekend_time_m)
                    ];
                    $csv_array[]=[
                        $items_name_array[11].' '.$this->calcHours($global_holidays_time_h, $global_holidays_time_m)
                    ];
                    $csv_array[]=[
                        $items_name_array[13].' '.$this->calcHours($global_holidays_time_h_45, $global_holidays_time_m_45)
                    ];
                    //sick
                    /*$csv_array[]=[
                        $items_name_array[15].' '.$this->calcHours($total_sick_h, $total_sick_m)
                    ];*/
                    $csv_array[]=[
                        $items_name_array[15].' '.$this->calcHours($global_breaks_time_h, $global_breaks_time_m)
                    ];
                }
            } else{//special companies
                if($sick_state==1){//Include sick time enabled
                    $csv_array[]=[
                        $items_name_array[1].' '.$this->calcHours($global_total_h, $global_total_m)
                    ];
                    $csv_array[]=[
                        $items_name_array[3].' '.$this->calcHours($global_daytime_h, $global_daytime_m)  
                    ];
                    $csv_array[]=[
                        $items_name_array[5].' '.$this->calcHours($global_afterwork_h, $global_afterwork_m) 
                    ];
                    /* $csv_array[]=[
                        $items_name_array[7].' '.$this->calcHours($global_night_time_h, $global_night_time_m)
                    ];
                    $csv_array[]=[
                        $items_name_array[9].' '.$this->calcHours($global_weekend_time_h, $global_weekend_time_m)
                    ];*/
                    $csv_array[]=[
                        $items_name_array[7].' '.$this->calcHours($global_holidays_time_h, $global_holidays_time_m)
                    ];
                    $csv_array[]=[
                        $items_name_array[9].' '.$this->calcHours($global_holidays_time_h_45, $global_holidays_time_m_45)
                    ];
                    //sick
                    $csv_array[]=[
                        $items_name_array[11].' '.$this->calcHours($total_sick_h, $total_sick_m)
                    ];
                    $csv_array[]=[
                        $items_name_array[13].' '.$this->calcHours($global_breaks_time_h, $global_breaks_time_m)
                    ];
                } else{//Include sick time disabled
                    $csv_array[]=[
                        $items_name_array[1].' '.$this->calcHours($global_total_h, $global_total_m)
                    ];
                    $csv_array[]=[
                        $items_name_array[3].' '.$this->calcHours($global_daytime_h, $global_daytime_m)  
                    ];
                    $csv_array[]=[
                        $items_name_array[5].' '.$this->calcHours($global_afterwork_h, $global_afterwork_m) 
                    ];
                    /* $csv_array[]=[
                        $items_name_array[7].' '.$this->calcHours($global_night_time_h, $global_night_time_m)
                    ];
                    $csv_array[]=[
                        $items_name_array[9].' '.$this->calcHours($global_weekend_time_h, $global_weekend_time_m)
                    ];*/
                    $csv_array[]=[
                        $items_name_array[7].' '.$this->calcHours($global_holidays_time_h, $global_holidays_time_m)
                    ];
                    $csv_array[]=[
                        $items_name_array[9].' '.$this->calcHours($global_holidays_time_h_45, $global_holidays_time_m_45)
                    ];
                    //sick
                    /*$csv_array[]=[
                        $items_name_array[11].' '.$this->calcHours($total_sick_h, $total_sick_m)
                    ];*/
                    $csv_array[]=[
                        $items_name_array[11].' '.$this->calcHours($global_breaks_time_h, $global_breaks_time_m)
                    ];
                }
            }
           
            file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_csv_s.html', print_r($manager_users_object, true), FILE_APPEND | LOCK_EX);
            /*file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_csv_s.html', print_r($global_total_h.' '.$global_total_m, true), FILE_APPEND | LOCK_EX);
            file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_csv_s.html', print_r($special_companies, true), FILE_APPEND | LOCK_EX);*/
            //////////////////////////////////////////////////////////////////////////////////////
            
            $pathFile = JPATH_BASE.DS.'tmp_csv_collect'.DS.$filename; 
            $fp = fopen($pathFile, 'w');//open file
            fwrite($fp,b"\xEF\xBB\xBF");//write special iceland symbols
            
            foreach ($csv_array as $fields) {
                fputcsv($fp, $fields, ';');
            }       
            fclose($fp);  
        }
    }
    
    public function getSelectedSpecNumber($user_id) {
        $user_with_request = JFactory::getUser($user_id);
        $user_rule_number = $user_with_request->spec_number;
        if ($user_rule_number == 0) {
            //$user_rule_number = 1;
            $mode = 1;
        }

        return json_encode([
            'spec_number' => $user_rule_number,
            'is_default_value' => $mode
        ]);
    }
    
    //method is purely for app
    /*public function createCsvCollectDK($lang, $filename, $from, $to, $user_id, $additional_mode, $note)
    { 
        $manager_info= JFactory::getUser($user_id);
      
        if($lang=="is"){
            $l = 'is';
        } else{
            $l = 'en';
        }
               
        if(in_array(6, $manager_info->groups)) {//from manager
            $csv_array=[];
            $i=0;
            if($l==='is'){
               $this->lang->setLanguage('is-IS');
               $this->lang->load();
            } 

            $manager_users_object=$this->getUsersFromManager($manager_info->id);//get manager users
            $space='                                                        ';
            
          
            
            $csv_array[]=[
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_ID'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_DEP'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_NAME'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_DAYTIME'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_AFTERW'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_NIGHT_WEEKENDS'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_HOLIDAYS'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_MONTHLY'),
                102
            ];

            include_once('/home/curiotime/app.curiotime.com/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
      
            $j=0;
            $count=count($manager_users_object);
            
            foreach($manager_users_object as $manager_user){
                if($manager_info->id===$manager_user->owner_id){
                   // unset($csv_array);
                   // continue;
                } else{
                   /*$csv_array=[];
                    $csv_array[]=[
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_ID'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_DEP'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_NAME'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_DAYTIME'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_AFTERW'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_NIGHT_WEEKENDS'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_HOLIDAYS'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_MONTHLY'),
                102
            ];*//*
                }
                
                switch($additional_mode){
                    case 'search':
                        //$note='dd';
                        $link='https://app.curiotime.com/index.php?task=getTimeByPeriodCollectSearch&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1&note='.$note; 
                    break;
                    default:
                        $link='https://app.curiotime.com/index.php?task=getTimeByPeriodCollect&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1';
                    break;
                }
                
                $html = file_get_html($link);//simple html

                $users_info_html=[];
                $i=0;
                foreach($html->find('div[class="span4 offset8 custom_bootstrap_span"] div span') as $e){                 
                    $users_info_html[]=$e->plaintext;
                }  
               
                $k0=0;
                
                //if selected monthly rule in loop
                if($manager_user->spec_number>0){
                    $monthly_rule=$this->getSpecRule($manager_user->id, $manager_user->spec_number)->spec_rule; //173:10           
                    $total=trim($users_info_html[1]);

                    
                    //$monthly_rule_modify=$this->modifyTime($monthly_rule, 'spec', '');
                    $monthly_rule_modify=$monthly_rule;
                    
                    //$total_modify=$this->modifyTime($total, 'total', '');
                    $total_modify=$total;
                    
                    $monthly_rule_modify_arr=explode(':', $monthly_rule_modify);
                    $monthly_rule_modify_arr_min=$monthly_rule_modify_arr[0]*60+$monthly_rule_modify_arr[1];
                    
                    $total_modify_arr=explode(':', $total_modify);
                    $total_modify_arr_min=$total_modify_arr[0]*60+$total_modify_arr[1];
                    
                   
                    $diff=null;
                    
                    if($total_modify_arr_min<$monthly_rule_modify_arr_min){
                        $mode0='<';
                        $result=$total_modify;
                    } elseif($total_modify_arr_min>$monthly_rule_modify_arr_min){
                        $mode0='>';
                        $result=$monthly_rule_modify;
                        $diff=$total_modify_arr_min-$monthly_rule_modify_arr_min;
                    } else{
                        $mode0='==';
                        $result=$total_modify;
                    }
                    //It ispossible the error  not cast to format '00:00', row type '98.75:00'
                    $final_diff=$this->formatTime($this->modifyTime(($diff/60).':00', 'diff', ''));
                  
                    if($monthly_rule_modify!='00,00' || $final_diff!='00,00'){
                        $csv_array[]=[
                            $manager_user->username,
                            $manager_user->group_user,
                            $manager_user->username0,            
                            '', //daytime  
                            '',//afterwork  
                            '',//night+weekend
                            '',//holidays
                            //'Final Result: '.$result.' Total='.$total_modify.' Pr.month='.$monthly_rule_modify.' Diff mode: '.$mode0.' Diff: '.$diff,
                            //'Total='.$total_modify.' Pr.month='.$monthly_rule_modify
                            $this->formatTime($monthly_rule_modify),
                            $final_diff
                        ];
                    }
                } else{
                   $daytime=$this->formatTime($this->modifyTime(trim($users_info_html[3]), 'daytime', ''));
                   $afterwork=$this->formatTime($this->modifyTime(trim($users_info_html[5]), 'afterwork', ''));
                   $night_plus_weekends=$this->formatTime($this->modifyTime(trim($users_info_html[7]), 'combo', trim($users_info_html[9])));
                   $holidays=$this->formatTime($this->modifyTime(trim($users_info_html[11]), 'holidays', ''));
                   
                   if($daytime!='00,00' || $afterwork!='00,00' || $night_plus_weekends!='00,00' || $holidays!='00,00'){
                        $csv_array[]=[
                            $manager_user->username,
                            $manager_user->group_user,
                            $manager_user->username0,
                            $daytime,//daytime
                            $afterwork,//afterwork
                            $night_plus_weekends,//night+weekends
                            $holidays,//holidays
                            '',  
                        ];
                    }
                }
                
                $j++;
            }

            //////////////////////////////////////////////////////////////////////////////////////
            $to1 = 'developer3452@gmail.com';
            $subject = 'CSV collect DK';
            $headers = "From: info@curiotime.com\r\n";
            $headers .= "MIME-Version: 1.0\r\n";
            $headers .= "Content-Type: text/html; charset=UTF-8\r\n"; 
            $message='<pre>'.print_r($csv_array, true).'</pre>';
            //mail($to1, $subject, $message, $headers);
                
            unset($csv_array[1]);//delete second row with manager
            
            $pathFile = JPATH_BASE.DS.'tmp_csv_collect'.DS.$filename; 
            $fp = fopen($pathFile, 'w');//open file
            fwrite($fp,b"\xEF\xBB\xBF");//write special iceland symbols
            
            foreach ($csv_array as $fields) {
                fputcsv($fp, $fields, ';');
            }       
            fclose($fp);  
        }
    }*/
    
    private function isHoliday() {
        $date=date('Y-m-d');
        //$date='2019-05-01';
        $time=date('H:i');
        
        $query='SELECT `date`, `start_time` FROM #__holiday WHERE `date`="'.$date.'"';
        $this->db->setQuery( $query );
        $res=$this->db->loadObjectList();
        
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/dk_collect.html', print_r($res, true), FILE_APPEND | LOCK_EX);
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/dk_collect.html', print_r($date, true), FILE_APPEND | LOCK_EX);
        
        if(count($res>0)){
            return 1;
        } else{
            return 0;
        }
       
    }
    
    /**
     * Create DK csv old(before custom headers text.Not delete this
     *
     * 
     */
    /*public function createCsvCollectDK($lang, $filename, $from, $to, $user_id, $additional_mode, $note, $groups)
    { 
        setlocale(LC_CTYPE, "en_US.UTF-8");
        $manager_info= JFactory::getUser($user_id);
      
        if($lang=="is"){
            $l = 'is';
        } else{
            $l = 'en';
        }
               
        if(in_array(6, $manager_info->groups)) {//from manager
            $csv_array=[];
            $i=0;
            if($l==='is'){
               $this->lang->setLanguage('is-IS');
               $this->lang->load();
            } 

            $manager_users_object=$this->getUsersFromManagerCheckHidden($manager_info->id);//get manager users
            $space='';
            
          
            $csv_array[]=[
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_ID'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_DEP'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_NAME'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_DAYTIME'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_AFTERW'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_NIGHT_WEEKENDS'),//111
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_HOLIDAYS'),//112
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_MONTHLY'),
                102,
                103,
                104,
                ''
            ];

            include_once($this->server_path.'/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
      
            $j=0;
            $count=count($manager_users_object);
            file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect.html', print_r($additional_mode, true), FILE_APPEND | LOCK_EX);
           
            try{
                if($additional_mode=='search'){
                    $groups_array=explode(',', $groups);
                }
            } catch (Exception $ex) {
                $groups_array='';
            }
        
            foreach($manager_users_object as $manager_user){
                if(in_array($manager_user->group_user, $groups_array) || empty($groups_array[0])) { 
                    
                switch($additional_mode){
                    case 'search':
                        //$note='dd';
                        $link=$this->sitename.'/index.php?task=getTimeByPeriodCollectSearch&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1&note='.$note; 
                    break;
                    default:
                        $link=$this->sitename.'/index.php?task=getTimeByPeriodCollect&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1';
                    break;
                }
                
                
                $html = file_get_html($link);//simple html
                
                if(empty($html) == false){
                    $users_info_html=[];
                    $i=0;
                    foreach($html->find('div[class="span4 offset8 custom_bootstrap_span"] div span') as $e){                 
                        $users_info_html[]=$e->plaintext;
                    }  
                }
                
                
                $k0=0;
                //$is_holiday=$this->isHoliday();
                 
                //if selected monthly rule in loop
                if($manager_user->spec_number>0){   
                    $monthly_rule_obj=$this->getSpecRuleObj($manager_user->id, $manager_user->spec_number);
                    $monthly_rule=$monthly_rule_obj->spec_rule; //173:10  
                             
                    //$monthly_rule='20:00'; //173:10           
                    $total=trim($users_info_html[1]);

                    
                   
                    $monthly_rule_modify=$monthly_rule;
                    
                   
                    $total_modify=$total;
                    
                    $monthly_rule_modify_arr=explode(':', $monthly_rule_modify);
                    $monthly_rule_modify_arr_min=$monthly_rule_modify_arr[0]*60+$monthly_rule_modify_arr[1];
                    
                    $total_modify_arr=explode(':', $total_modify);
                    $total_modify_arr_min=$total_modify_arr[0]*60+$total_modify_arr[1];
                    
                   
                    $diff=null;
                  
                     
                    if($total_modify_arr_min<$monthly_rule_modify_arr_min){
                        $mode0='<';
                        $result=$total_modify;
                    } elseif($total_modify_arr_min>$monthly_rule_modify_arr_min){
                        $mode0='>';
                        $result=$monthly_rule_modify;
                        $diff=$total_modify_arr_min-$monthly_rule_modify_arr_min;
                        //file_put_contents('/home/curiotime/dk.curiotime.com/logs/test_csv_log.html', print_r($this->convertToHoursMins($diff), true), FILE_APPEND | LOCK_EX); 
                    } else{
                        $mode0='==';
                        $result=$total_modify;
                    }
                    //It ispossible the error  not cast to format '00:00', row type '98.75:00'
                    //$final_diff=$this->modifyTime(($diff/60).':00', 'diff', '');
                    $final_diff=$this->convertToHoursMins($diff);
                         
                    $username01=$manager_user->username0;
                    $encoding=mb_detect_encoding($username01);
                   
                    
                    if($encoding==='ASCII'){
                        $username01 = mb_convert_encoding($username01, "UTF-8", "ASCII");
                    }
                    $encoding1=mb_detect_encoding($username01);
                    
                    
                    if($mode0==='<'){
                        $result=$this->formatTime($result);
                        $final_diff=$this->formatTime($final_diff);
                        
                        if($result!='00,00' || $final_diff!='00,00' && ($result!='0,00' || $final_diff!='0,00')){
                            //modify current app code
                            $daytime=$this->formatTime($this->modifyTime(trim($users_info_html[3]), 'daytime', ''));
                            $afterwork=$this->formatTime($this->modifyTime(trim($users_info_html[5]), 'afterwork', ''));
                            $night_plus_weekends=$this->formatTime(
                                    //see this array http://prntscr.com/nky240
                                    $this->modifyTime(
                                            trim($users_info_html[7]), //night time
                                            'combo', //mode
                                            trim($users_info_html[9]),//weekend
                                            trim($users_info_html[13]) //holidays 45
                                    )
                            );
                            $holidays=$this->formatTime($this->modifyTime(trim($users_info_html[11]), 'holidays', ''));
                            
                            if($daytime!='00,00' || $afterwork!='00,00' || $night_plus_weekends!='00,00' || $holidays!='00,00'){
                                if($daytime!='0,00' || $afterwork!='0,00' || $night_plus_weekends!='0,00' || $holidays!='0,00'){
                                    //$csv_array[0]+=[103,104];
                                    
                                    $csv_array[]=[
                                        $manager_user->username,
                                        $manager_user->group_user,
                                        $username01,            
                                        $daytime, //daytime  
                                        $afterwork,//afterwork  
                                        $night_plus_weekends,//night+weekend-111
                                        $holidays,//holidays-112
                                        
                                        $result,
                                        $final_diff,
                                        
                                        $this->calc103Cell($monthly_rule_obj, $daytime, $afterwork, $night_plus_weekends, $holidays),//103
                                        $this->calc104Cell($monthly_rule_obj, $daytime, $afterwork, $night_plus_weekends, $holidays),//104
                                        
                                        $manager_user->id
                                    ];
                                }
                            }
                        }
                    } else{
                        $monthly_rule_modify=$this->formatTime($monthly_rule_modify);
                        $final_diff=$this->formatTime($final_diff);
                        
                        if($monthly_rule_modify!='00,00' || $final_diff!='00,00' && ($monthly_rule_modify!='0,00' || $final_diff!='0,00')){
                            //modify current app code
                            $daytime=$this->formatTime($this->modifyTime(trim($users_info_html[3]), 'daytime', ''));
                            $afterwork=$this->formatTime($this->modifyTime(trim($users_info_html[5]), 'afterwork', ''));
                            $night_plus_weekends=$this->formatTime(
                                    //see this array http://prntscr.com/nky240
                                    $this->modifyTime(
                                            trim($users_info_html[7]), //night time
                                            'combo', //mode
                                            trim($users_info_html[9]),//weekend
                                            trim($users_info_html[13]) //holidays 45
                                    )
                            );
                            $holidays=$this->formatTime($this->modifyTime(trim($users_info_html[11]), 'holidays', ''));
                            
                            if($daytime!='00,00' || $afterwork!='00,00' || $night_plus_weekends!='00,00' || $holidays!='00,00'){
                                if($daytime!='0,00' || $afterwork!='0,00' || $night_plus_weekends!='0,00' || $holidays!='0,00'){
                                    $csv_array[]=[
                                        $manager_user->username,
                                        $manager_user->group_user,
                                        $username01,            
                                        $daytime, //daytime  
                                        $afterwork,//afterwork  
                                        $night_plus_weekends,//night+weekend - 111
                                        $holidays,//holidays-112
                                        $monthly_rule_modify,
                                        $final_diff,
                                        $this->calc103Cell($monthly_rule_obj, $daytime, $afterwork, $night_plus_weekends, $holidays),//103
                                        $this->calc104Cell($monthly_rule_obj, $daytime, $afterwork, $night_plus_weekends, $holidays),//104
                                        
                                        $manager_user->id
                                    ];
                                }
                            }
                        }
                    }
                } else{     
                    $username01=$manager_user->username0;
                    $encoding=mb_detect_encoding($username01);
                   
                    
                    if($encoding==='ASCII'){
                        $username01 = mb_convert_encoding($username01, "UTF-8", "ASCII");
                    }
                    $encoding1=mb_detect_encoding($username01);
                    
                   
                    
                    //modify current app code
                    $daytime=$this->formatTime($this->modifyTime(trim($users_info_html[3]), 'daytime', ''));
                    $afterwork=$this->formatTime($this->modifyTime(trim($users_info_html[5]), 'afterwork', ''));
                    $night_plus_weekends=$this->formatTime(
                            $this->modifyTime(
                                //see this array http://prntscr.com/nky240
                                trim($users_info_html[7]),//night time 
                                'combo', //mode
                                trim($users_info_html[9]),//weekend 
                                trim($users_info_html[13]) //holidays 45
                            )
                    );
                    $holidays=$this->formatTime($this->modifyTime(trim($users_info_html[11]), 'holidays', ''));
                   
                    if($daytime!='00,00' || $afterwork!='00,00' || $night_plus_weekends!='00,00' || $holidays!='00,00'){
                        if($daytime!='0,00' || $afterwork!='0,00' || $night_plus_weekends!='0,00' || $holidays!='0,00'){
                            $csv_array[]=[
                                $manager_user->username,
                                $manager_user->group_user,
                                $username01,
                                $daytime,//daytime
                                $afterwork,//afterwork
                                $night_plus_weekends,//night+weekends+holidays 45 - 111 cell
                                //trim($users_info_html[7]).'+'.trim($users_info_html[9]),//night+weekends test
                                $holidays,//holidays 112
                                '',  
                                '',
                                
                                '',//103
                                '',//104
                                $manager_user->id
                                
                            ];
                        }
                    }
                }

                $j++;
            }
            }//end foreach

            //////////////////////////////////////////////////////////////////////////////////////
            //unset($csv_array[1]);//delete second row with manager-old
            
            $to1 = 'developer3452@gmail.com';
            $subject = 'CSV collect DK';
            $headers = "From: info@curiotime.com\r\n";
            $headers .= "MIME-Version: 1.0\r\n";
            $headers .= "Content-Type: text/html; charset=UTF-8\r\n"; 
            $message='<pre>'.print_r($users_info_html, true).'</pre>';
            //mail($to1, $subject, $message, $headers);
            
                
            $pathFile = JPATH_BASE.DS.'tmp_csv_collect'.DS.$filename; 
            $fp = fopen($pathFile, 'w');//open file
            fprintf($fp, chr(0xEF).chr(0xBB).chr(0xBF));
            fwrite($fp,b"\xEF\xBB\xBF");//write special iceland symbols
            
            foreach($csv_array as $k=>$v){
                $user_id=$v[11];
                
                if($user_id==$manager_info->owner_id){
                    //delete manager row in csv
                    unset($csv_array[$k]);
                } 
                
                $iteration_user=JFactory::getUser($user_id);
                $monthly_rule_obj=$this->getSpecRuleObj($user_id, $iteration_user->spec_number);
                
                if($monthly_rule_obj->checkbox_after=='1' || $monthly_rule_obj->checkbox_night=='1'){
                    $csv_array[$k][3]='00,00';
                    $csv_array[$k][4]='00,00';
                    $csv_array[$k][5]='00,00';
                    $csv_array[$k][6]='00,00';
                    //$csv_array[$k][7]='00,00';
                    //$csv_array[$k][8]='00,00';
                }
                
                unset($csv_array[$k][11]);//delete user id cell in csv
            }
            
            foreach ($csv_array as $fields) {
                //fputcsv($fp, $fields, ';');
                fputs($fp, implode(";", $fields)."\r\n");
            }                     
            fclose($fp);  
        }
        
    } */
    
    /**
     * Create DK csv for standart company(not exist in controller.php getSpecialCompanies() methid, Not delete this.
     * State is Before unification of the same cell and before editable headers.
     * 
     */
    public function createCsvCollectDKStandartCompany($lang, $filename, $from, $to, $user_id, $additional_mode, $note, $groups, $is_load_for_new_pay_period, $csv_dk_mode = null)
    { 
        ini_set('memory_limit', '-1');
        
        setlocale(LC_CTYPE, "en_US.UTF-8");
        $manager_info = JFactory::getUser($user_id);
      
        if($lang=="is"){
            $l = 'is';
        } else{
            $l = 'en';
        }
               
        if(in_array(6, $manager_info->groups) || in_array(10, $manager_info->groups)) {//from manager
            $csv_array = [];
            $i = 0;
            
            if($l === 'is'){
               $this->lang->setLanguage('is-IS');
               $this->lang->load();
            } 
            if(in_array(6, $manager_info->groups)){
                $manager_users_object = $this->getUsersFromManagerCheckHidden($manager_info->id);//get manager users
            } elseif(in_array(10, $manager_info->groups)){
                $manager_users_object = $this->getUsersFromManagerCheckHidden($manager_info->owner_id);//get manager users
            }
            //$manager_users_object = $this->getUsersFromManagerCheckHidden($manager_info->id);//get manager users
            /*echo '<pre>';
            print_r($manager_users_object);
            echo '</pre>';*/
            $space='';
          
            
            
            $csvHeaders =  [
                'id' => JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_ID'),
                'name' => JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_DEP'),
                'name2' => JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_NAME')
            ];
          
            $j=0;
            $count = count($manager_users_object);
           // file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect.html', print_r($additional_mode, true), FILE_APPEND | LOCK_EX);
           
            try{
                if($additional_mode=='search'){
                    $groups_array=explode(',', $groups);
                }
            } catch (Exception $ex) {
                $groups_array='';
            }
        
            
            $index  = 0;
            $csvRows  =  array();
            $userSpaceUsed  = 0;
            
            foreach($manager_users_object as $manager_user) {
                unset($htmlSrc);
                unset($json);
                unset($arr);
                unset($link);
                
                if(in_array($manager_user->group_user, $groups_array) || empty($groups_array[0])) { 
                    
                    
                    $u  =  JFactory::getUser($manager_user->id);
                    if(in_array(6, $u->groups)) continue;            
                    $userSpaceUsed  = 0;
                    
                    $csvData =  array();
                    
                    switch($additional_mode){
                        case 'search':
                            //$note='dd';
                            /*$link=$this->sitename.'/index.php?task=getTimeByPeriodCollectSearch'
                                . '&from=' . $from . ''
                                . '&to=' . $to . ''
                                . '&u_id='.$manager_user->id.''
                                . '&lang=' . $lang . ''
                                . '&mode=pdf'
                                . '&mode_all_user=1'
                                . '&note='. urlencode($note); */
                            
                            $link = $this->sitename.'/index.php?task=getTimeByPeriodCollectSearch';
                            $post = [
                                //'totals2' => '1',
                                'from' => $from,
                                'to' => $to,
                                'u_id' => $manager_user->id,
                                'lang' => $lang, 
                                'mode' => 'pdf',
                                'mode_all_user' => 1,
                                'note' => $note,
                                'is_load_for_new_pay_period' => $is_load_for_new_pay_period
                            ];
                        break;
                        default:
                            /*$link=$this->sitename.'/index.php?task=getTimeByPeriodCollect'
                                . '&from=' . $from . ''
                                . '&to=' . $to . ''
                                . '&u_id='.$manager_user->id.''
                                . '&lang=' . $lang . ''
                                . '&mode=pdf'
                                . '&mode_all_user=1';*/
                            
                            $link = $this->sitename.'/index.php?task=getTimeByPeriodCollect';
                            $post = [
                                //'totals2' => '1',
                                'from' => $from,
                                'to' => $to,
                                'u_id' => $manager_user->id,
                                'lang' => $lang, 
                                'mode' => 'pdf',
                                'mode_all_user' => 1,
                                //'note' => $note,
                                //'is_load_for_new_pay_period' => $is_load_for_new_pay_period
                            ];
                        break;
                    }
                    
                    //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_s_fix.html', print_r($post, true), FILE_APPEND | LOCK_EX);
                    
                    $csvData['id'] = $manager_user->username;
                    $csvData['name'] = $manager_user->group_user;
                    $csvData['name'] = ""; // disable dep
                    $username01 =   $manager_user->username0;
                    $encoding   =   mb_detect_encoding($username01);
                    if($encoding==='ASCII'){
                        $username01 = mb_convert_encoding($username01, "UTF-8", "ASCII");
                    }
                
                    $csvData['name2'] = $username01;
                
                    //echo "Link:". $link."\r\n";
                    
                    //$htmlSrc  = file_get_contents($link);
                    
                    if( $curl = curl_init() ) {
                        curl_setopt($curl, CURLOPT_URL, $link);
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER,true);
                        curl_setopt($curl, CURLOPT_POST, true);
                        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($post));
                        $out = curl_exec($curl);
                        $htmlSrc =  $out;
                        //exit;
                        curl_close($curl);
                    }
                    
                    if(preg_match("#<!--json-dk-totals--(.*)--json-dk-totals-->#", $htmlSrc, $arr)) {
                        $json  =  trim($arr[1]);
                        $json  = json_decode($json,true);
                        if(empty($json)) 
                            continue;
                    } else {
                        $userSpaceUsed  = 1;
                        continue;
                    }
                    
                    foreach ($json as $k=>$item) {
                        if(!in_array($item['pos'], $csvHeaders)) {
                            $csvHeaders[$item['pos']]  = $item['pos'];
                        }
                        $csvData[$item['pos']] = $this->formatTime($item['total'], $csv_dk_mode);
                    }
                    
                    $csvRows[]  = $csvData;
                    $j++;
                }
                
                $i1++;
                if(strlen(trim($note)) < 1 && $userSpaceUsed == 0) {                
                    $userSpaceUsed ++;
                    $csv_array[]=[' '.$space];
                    $csv_array[]=[' '.$space];
                }
                if($uCount > 1 && $userSpaceUsed == 0) {
                    $userSpaceUsed ++;
                    $csv_array[]=[' '.$space];
                    $csv_array[]=[' '.$space];
                }
            }
            
            

            //////////////////////////////////////////////////////////////////////////////////////
            //unset($csv_array[1]);//delete second row with manager-old
            
         
            
                
            $pathFile = JPATH_BASE.DS.'tmp_csv_collect'.DS.$filename; 
            $fp = fopen($pathFile, 'w');//open file            
            //$fp = fopen('php://output', 'w');           
            //add UTF-8 BOM 
            //fprintf($fp, chr(0xEF).chr(0xBB).chr(0xBF));            
            fputcsv($fp, $csvHeaders,";");
            foreach ($csvRows as $csv) {
                $data  =  array();
                foreach ($csvHeaders as $k=>$v) {
                    $data[] = isset($csv[$k]) ? $csv[$k] : "";
                }                
                fputcsv($fp,$data,";");
            }
            fclose($fp);  
        }
        
    }
    
    
    public function createCsvCollectDKStandartCompany_old1($lang, $filename, $from, $to, $user_id, $additional_mode, $note, $groups)
    { 
        setlocale(LC_CTYPE, "en_US.UTF-8");
        $manager_info= JFactory::getUser($user_id);
      
        if($lang=="is"){
            $l = 'is';
        } else{
            $l = 'en';
        }
               
        if(in_array(6, $manager_info->groups)) {//from manager
            $csv_array=[];
            $i=0;
            if($l==='is'){
               $this->lang->setLanguage('is-IS');
               $this->lang->load();
            } 

            $manager_users_object=$this->getUsersFromManagerCheckHidden($manager_info->id);//get manager users
            $space='';
            
          
            $csv_array[]=[
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_ID'),
                //JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_DEP'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_NAME'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_DAYTIME'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_AFTERW'),
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_NIGHT_WEEKENDS'),//111
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_HOLIDAYS'),//112
                JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_MONTHLY'),
                102,
                103,
                104,
                ''
            ];

            include_once($this->server_path.'/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
      
            $j=0;
            $count=count($manager_users_object);
           // file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect.html', print_r($additional_mode, true), FILE_APPEND | LOCK_EX);
           
            try{
                if($additional_mode=='search'){
                    $groups_array=explode(',', $groups);
                }
            } catch (Exception $ex) {
                $groups_array='';
            }
        
            foreach($manager_users_object as $manager_user){
                if(in_array($manager_user->group_user, $groups_array) || empty($groups_array[0])) { 
                    
                switch($additional_mode){
                    case 'search':
                        //$note='dd';
                        $link=$this->sitename.'/index.php?task=getTimeByPeriodCollectSearch&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1&note='.$note; 
                    break;
                    default:
                        $link=$this->sitename.'/index.php?task=getTimeByPeriodCollect&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1';
                    break;
                }
                
                /*
                echo $link."\r\n";
                $htmlSrc  = file_get_contents($link);
                echo $htmlSrc;
                continue;
                 * 
                 */
                $html = file_get_html($link);//simple html
                
                if(empty($html) == false){
                    $users_info_html=[];
                    $i=0;
                    foreach($html->find('div[class="span4 offset8 custom_bootstrap_span"] div span') as $e){                 
                        $users_info_html[]=$e->plaintext;
                    }  
                }
                
                
                $k0=0;
                //$is_holiday=$this->isHoliday();
                 
                //if selected monthly rule in loop
                if($manager_user->spec_number>0){   
                    $monthly_rule_obj=$this->getSpecRuleObj($manager_user->id, $manager_user->spec_number);
                    $monthly_rule=$monthly_rule_obj->spec_rule; //173:10  
                             
                    //$monthly_rule='20:00'; //173:10           
                    $total=trim($users_info_html[1]);

                    
                   
                    $monthly_rule_modify=$monthly_rule;
                    
                   
                    $total_modify=$total;
                    
                    $monthly_rule_modify_arr=explode(':', $monthly_rule_modify);
                    $monthly_rule_modify_arr_min=$monthly_rule_modify_arr[0]*60+$monthly_rule_modify_arr[1];
                    
                    $total_modify_arr=explode(':', $total_modify);
                    $total_modify_arr_min=$total_modify_arr[0]*60+$total_modify_arr[1];
                    
                   
                    $diff=null;
                  
                     
                    if($total_modify_arr_min<$monthly_rule_modify_arr_min){
                        $mode0='<';
                        $result=$total_modify;
                    } elseif($total_modify_arr_min>$monthly_rule_modify_arr_min){
                        $mode0='>';
                        $result=$monthly_rule_modify;
                        $diff=$total_modify_arr_min-$monthly_rule_modify_arr_min;
                        //file_put_contents('/home/curiotime/dk.curiotime.com/logs/test_csv_log.html', print_r($this->convertToHoursMins($diff), true), FILE_APPEND | LOCK_EX); 
                    } else{
                        $mode0='==';
                        $result=$total_modify;
                    }
                    //It ispossible the error  not cast to format '00:00', row type '98.75:00'
                    //$final_diff=$this->modifyTime(($diff/60).':00', 'diff', '');
                    $final_diff=$this->convertToHoursMins($diff);
                         
                    $username01=$manager_user->username0;
                    $encoding=mb_detect_encoding($username01);
                   
                    
                    if($encoding==='ASCII'){
                        $username01 = mb_convert_encoding($username01, "UTF-8", "ASCII");
                    }
                    $encoding1=mb_detect_encoding($username01);
                    
                    
                    if($mode0==='<'){
                        $result=$this->formatTime($result);
                        $final_diff=$this->formatTime($final_diff);
                        
                        if($result!='00,00' || $final_diff!='00,00' && ($result!='0,00' || $final_diff!='0,00')){
                            //modify current app code
                            $daytime=$this->formatTime($this->modifyTime(trim($users_info_html[3]), 'daytime', ''));
                            $afterwork=$this->formatTime($this->modifyTime(trim($users_info_html[5]), 'afterwork', ''));
                            $night_plus_weekends=$this->formatTime(
                                    //see this array http://prntscr.com/nky240
                                    $this->modifyTime(
                                            trim($users_info_html[7]), //night time
                                            'combo', //mode
                                            trim($users_info_html[9]),//weekend
                                            trim($users_info_html[13]) //holidays 45
                                    )
                            );
                            $holidays=$this->formatTime($this->modifyTime(trim($users_info_html[11]), 'holidays', ''));
                            
                            if($daytime!='00,00' || $afterwork!='00,00' || $night_plus_weekends!='00,00' || $holidays!='00,00'){
                                if($daytime!='0,00' || $afterwork!='0,00' || $night_plus_weekends!='0,00' || $holidays!='0,00'){
                                    //$csv_array[0]+=[103,104];
                                    
                                    $csv_array[]=[
                                        $manager_user->username,
                                        //$manager_user->group_user,
                                        $username01,            
                                        $daytime, //daytime  
                                        $afterwork,//afterwork  
                                        $night_plus_weekends,//night+weekend-111
                                        $holidays,//holidays-112
                                        
                                        $result,
                                        $final_diff,
                                        
                                        $this->calc103Cell($monthly_rule_obj, $daytime, $afterwork, $night_plus_weekends, $holidays),//103
                                        $this->calc104Cell($monthly_rule_obj, $daytime, $afterwork, $night_plus_weekends, $holidays),//104
                                        
                                        $manager_user->id
                                    ];
                                }
                            }
                        }
                    } else{
                        $monthly_rule_modify=$this->formatTime($monthly_rule_modify);
                        $final_diff=$this->formatTime($final_diff);
                        
                        if($monthly_rule_modify!='00,00' || $final_diff!='00,00' && ($monthly_rule_modify!='0,00' || $final_diff!='0,00')){
                            //modify current app code
                            $daytime=$this->formatTime($this->modifyTime(trim($users_info_html[3]), 'daytime', ''));
                            $afterwork=$this->formatTime($this->modifyTime(trim($users_info_html[5]), 'afterwork', ''));
                            $night_plus_weekends=$this->formatTime(
                                    //see this array http://prntscr.com/nky240
                                    $this->modifyTime(
                                            trim($users_info_html[7]), //night time
                                            'combo', //mode
                                            trim($users_info_html[9]),//weekend
                                            trim($users_info_html[13]) //holidays 45
                                    )
                            );
                            $holidays=$this->formatTime($this->modifyTime(trim($users_info_html[11]), 'holidays', ''));
                            
                            if($daytime!='00,00' || $afterwork!='00,00' || $night_plus_weekends!='00,00' || $holidays!='00,00'){
                                if($daytime!='0,00' || $afterwork!='0,00' || $night_plus_weekends!='0,00' || $holidays!='0,00'){
                                    $csv_array[]=[
                                        $manager_user->username,
                                        //$manager_user->group_user,
                                        $username01,            
                                        $daytime, //daytime  
                                        $afterwork,//afterwork  
                                        $night_plus_weekends,//night+weekend - 111
                                        $holidays,//holidays-112
                                        $monthly_rule_modify,
                                        $final_diff,
                                        $this->calc103Cell($monthly_rule_obj, $daytime, $afterwork, $night_plus_weekends, $holidays),//103
                                        $this->calc104Cell($monthly_rule_obj, $daytime, $afterwork, $night_plus_weekends, $holidays),//104
                                        
                                        $manager_user->id
                                    ];
                                }
                            }
                        }
                    }
                } else{     
                    $username01=$manager_user->username0;
                    $encoding=mb_detect_encoding($username01);
                   
                    
                    if($encoding==='ASCII'){
                        $username01 = mb_convert_encoding($username01, "UTF-8", "ASCII");
                    }
                    $encoding1=mb_detect_encoding($username01);
                    
                   
                    
                    //modify current app code
                    $daytime=$this->formatTime($this->modifyTime(trim($users_info_html[3]), 'daytime', ''));
                    $afterwork=$this->formatTime($this->modifyTime(trim($users_info_html[5]), 'afterwork', ''));
                    $night_plus_weekends=$this->formatTime(
                            $this->modifyTime(
                                //see this array http://prntscr.com/nky240
                                trim($users_info_html[7]),//night time 
                                'combo', //mode
                                trim($users_info_html[9]),//weekend 
                                trim($users_info_html[13]) //holidays 45
                            )
                    );
                    $holidays=$this->formatTime($this->modifyTime(trim($users_info_html[11]), 'holidays', ''));
                   
                    if($daytime!='00,00' || $afterwork!='00,00' || $night_plus_weekends!='00,00' || $holidays!='00,00'){
                        if($daytime!='0,00' || $afterwork!='0,00' || $night_plus_weekends!='0,00' || $holidays!='0,00'){
                            $csv_array[]=[
                                $manager_user->username,
                                //$manager_user->group_user,
                                $username01,
                                $daytime,//daytime
                                $afterwork,//afterwork
                                $night_plus_weekends,//night+weekends+holidays 45 - 111 cell
                                //trim($users_info_html[7]).'+'.trim($users_info_html[9]),//night+weekends test
                                $holidays,//holidays 112
                                '',  
                                '',
                                
                                '',//103
                                '',//104
                                $manager_user->id
                                
                            ];
                        }
                    }
                }

                $j++;
            }
            }//end foreach

            //////////////////////////////////////////////////////////////////////////////////////
            //unset($csv_array[1]);//delete second row with manager-old
            
            $to1 = 'developer3452@gmail.com';
            $subject = 'CSV collect DK';
            $headers = "From: info@curiotime.com\r\n";
            $headers .= "MIME-Version: 1.0\r\n";
            $headers .= "Content-Type: text/html; charset=UTF-8\r\n"; 
            $message='<pre>'.print_r($users_info_html, true).'</pre>';
            //mail($to1, $subject, $message, $headers);
            
                
            $pathFile = JPATH_BASE.DS.'tmp_csv_collect'.DS.$filename; 
            $fp = fopen($pathFile, 'w');//open file
            fprintf($fp, chr(0xEF).chr(0xBB).chr(0xBF));
            fwrite($fp,b"\xEF\xBB\xBF");//write special iceland symbols
            
            foreach($csv_array as $k=>$v){
                $user_id=$v[11];
                
                if($user_id==$manager_info->owner_id){
                    //delete manager row in csv
                    unset($csv_array[$k]);
                } 
                
                $iteration_user=JFactory::getUser($user_id);
                $monthly_rule_obj=$this->getSpecRuleObj($user_id, $iteration_user->spec_number);
                
                if($monthly_rule_obj->checkbox_after=='1' || $monthly_rule_obj->checkbox_night=='1'){
                    $csv_array[$k][3]='00,00';
                    $csv_array[$k][4]='00,00';
                    $csv_array[$k][5]='00,00';
                    $csv_array[$k][6]='00,00';
                    //$csv_array[$k][7]='00,00';
                    //$csv_array[$k][8]='00,00';
                }
                
                unset($csv_array[$k][11]);//delete user id cell in csv
            }
            
            foreach ($csv_array as $fields) {
                //fputcsv($fp, $fields, ';');
                fputs($fp, implode(";", $fields)."\r\n");
            }                     
            fclose($fp);  
        }
        
    }
    
    
    private function getDkHeaders($manager_id)
    {
        $query = "SELECT * FROM #__dk_headers WHERE id_manager = '$manager_id'"; 
        
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/dk_headers.html', print_r($data, true), FILE_APPEND | LOCK_EX);
        $final_obj=[];
        foreach($data as $k=>$v){
            if($k!='id' && $k!='id_manager'){
                $final_obj[$k]=$v;
            }
        }
        return (object)$final_obj;
    }
    
    /**
     * Create DK csv new(after custom headers text). Not delete this.
     * Before unification of the same cell.
     * 
     
    public function createCsvCollectDK($lang, $filename, $from, $to, $user_id, $additional_mode, $note, $groups)
    { 
        setlocale(LC_CTYPE, "en_US.UTF-8");
        $manager_info= JFactory::getUser($user_id);
      
        if($lang=="is"){
            $l = 'is';
        } else{
            $l = 'en';
        }
               
        if(in_array(6, $manager_info->groups)) {//from manager
            $csv_array=[];
            $i=0;
            if($l==='is'){
               $this->lang->setLanguage('is-IS');
               $this->lang->load();
            } 

            $manager_users_object=$this->getUsersFromManagerCheckHidden($manager_info->id);//get manager users
            $space='';
            
            $custom_headers=$this->getDkHeaders($manager_info->id);
          
            if(empty($custom_headers)){
                $csv_array[]=[
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_ID'),
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_DEP'),
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_NAME'),
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_DAYTIME'),//101
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_AFTERW'),//110
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_NIGHT_WEEKENDS'),//111
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_HOLIDAYS'),//112
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_MONTHLY'),//100
                    102,
                    103,
                    104,
                    ''
                ];
           } else{
                $csv_array[]=[
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_ID'),
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_DEP'),
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_NAME'),
                    $custom_headers->daytime_pos_header,//101
                    $custom_headers->after_hours_pos_header,//110
                    $custom_headers->night_pos_header ,//111
                    $custom_headers->weekends_pos_header,//112
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_MONTHLY'),//100
                    102,
                    $custom_headers->holidays_45_pos_header,
                    $custom_headers->holidays_90_pos_header,
                    ''
                ];
            }

            include_once($this->server_path.'/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
      
            $j=0;
            $count=count($manager_users_object);
            file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect.html', print_r($additional_mode, true), FILE_APPEND | LOCK_EX);
           
            try{
                if($additional_mode=='search'){
                    $groups_array=explode(',', $groups);
                }
            } catch (Exception $ex) {
                $groups_array='';
            }
        
            foreach($manager_users_object as $manager_user){
                if(in_array($manager_user->group_user, $groups_array) || empty($groups_array[0])) { 
                    
                switch($additional_mode){
                    case 'search':
                        //$note='dd';
                        $link=$this->sitename.'/index.php?task=getTimeByPeriodCollectSearch&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1&note='.$note; 
                    break;
                    default:
                        $link=$this->sitename.'/index.php?task=getTimeByPeriodCollect&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1';
                    break;
                }
                
                
                $html = file_get_html($link);//simple html
                
                if(empty($html) == false){
                    $users_info_html=[];
                    $i=0;
                    foreach($html->find('div[class="span4 offset8 custom_bootstrap_span"] div span') as $e){                 
                        $users_info_html[]=$e->plaintext;
                    }  
                }
                
                
                $k0=0;
                //$is_holiday=$this->isHoliday();
                 
                //if selected monthly rule in loop
                if($manager_user->spec_number>0){   
                    $monthly_rule_obj=$this->getSpecRuleObj($manager_user->id, $manager_user->spec_number);
                    $monthly_rule=$monthly_rule_obj->spec_rule; //173:10  
                             
                    //$monthly_rule='20:00'; //173:10           
                    $total=trim($users_info_html[1]);

                    
                   
                    $monthly_rule_modify=$monthly_rule;
                    
                   
                    $total_modify=$total;
                    
                    $monthly_rule_modify_arr=explode(':', $monthly_rule_modify);
                    $monthly_rule_modify_arr_min=$monthly_rule_modify_arr[0]*60+$monthly_rule_modify_arr[1];
                    
                    $total_modify_arr=explode(':', $total_modify);
                    $total_modify_arr_min=$total_modify_arr[0]*60+$total_modify_arr[1];
                    
                   
                    $diff=null;
                  
                     
                    if($total_modify_arr_min<$monthly_rule_modify_arr_min){
                        $mode0='<';
                        $result=$total_modify;
                    } elseif($total_modify_arr_min>$monthly_rule_modify_arr_min){
                        $mode0='>';
                        $result=$monthly_rule_modify;
                        $diff=$total_modify_arr_min-$monthly_rule_modify_arr_min;
                        //file_put_contents('/home/curiotime/dk.curiotime.com/logs/test_csv_log.html', print_r($this->convertToHoursMins($diff), true), FILE_APPEND | LOCK_EX); 
                    } else{
                        $mode0='==';
                        $result=$total_modify;
                    }
                    //It ispossible the error  not cast to format '00:00', row type '98.75:00'
                    //$final_diff=$this->modifyTime(($diff/60).':00', 'diff', '');
                    $final_diff=$this->convertToHoursMins($diff);
                         
                    $username01=$manager_user->username0;
                    $encoding=mb_detect_encoding($username01);
                   
                    
                    if($encoding==='ASCII'){
                        $username01 = mb_convert_encoding($username01, "UTF-8", "ASCII");
                    }
                    $encoding1=mb_detect_encoding($username01);
                    
                    
                    if($mode0==='<'){
                        $result=$this->formatTime($result);
                        $final_diff=$this->formatTime($final_diff);
                        
                        if($result!='00,00' || $final_diff!='00,00' && ($result!='0,00' || $final_diff!='0,00')){
                            //modify current app code
                            $daytime=$this->formatTime($this->modifyTime(trim($users_info_html[3]), 'daytime', ''));
                            $afterwork=$this->formatTime($this->modifyTime(trim($users_info_html[5]), 'afterwork', ''));
                            $night_plus_weekends=$this->formatTime(
                                    //see this array http://prntscr.com/nky240
                                    $this->modifyTime(
                                            trim($users_info_html[7]), //night time
                                            'combo', //mode
                                            trim($users_info_html[9]),//weekend
                                            trim($users_info_html[13]) //holidays 45
                                    )
                            );
                            $holidays=$this->formatTime($this->modifyTime(trim($users_info_html[11]), 'holidays', ''));
                            
                            if($daytime!='00,00' || $afterwork!='00,00' || $night_plus_weekends!='00,00' || $holidays!='00,00'){
                                if($daytime!='0,00' || $afterwork!='0,00' || $night_plus_weekends!='0,00' || $holidays!='0,00'){
                                    //$csv_array[0]+=[103,104];
                                    
                                    $csv_array[]=[
                                        $manager_user->username,
                                        $manager_user->group_user,
                                        $username01,            
                                        $daytime, //daytime  
                                        $afterwork,//afterwork  
                                        $night_plus_weekends,//night+weekend-111
                                        $holidays,//holidays-112
                                        
                                        $result,
                                        $final_diff,
                                        
                                        $this->calc103Cell($monthly_rule_obj, $daytime, $afterwork, $night_plus_weekends, $holidays),//103
                                        $this->calc104Cell($monthly_rule_obj, $daytime, $afterwork, $night_plus_weekends, $holidays),//104
                                        
                                        $manager_user->id
                                    ];
                                }
                            }
                        }
                    } else{
                        $monthly_rule_modify=$this->formatTime($monthly_rule_modify);
                        $final_diff=$this->formatTime($final_diff);
                        
                        if($monthly_rule_modify!='00,00' || $final_diff!='00,00' && ($monthly_rule_modify!='0,00' || $final_diff!='0,00')){
                            //modify current app code
                            $daytime=$this->formatTime($this->modifyTime(trim($users_info_html[3]), 'daytime', ''));
                            $afterwork=$this->formatTime($this->modifyTime(trim($users_info_html[5]), 'afterwork', ''));
                            $night_plus_weekends=$this->formatTime(
                                    //see this array http://prntscr.com/nky240
                                    $this->modifyTime(
                                            trim($users_info_html[7]), //night time
                                            'combo', //mode
                                            trim($users_info_html[9]),//weekend
                                            trim($users_info_html[13]) //holidays 45
                                    )
                            );
                            $holidays=$this->formatTime($this->modifyTime(trim($users_info_html[11]), 'holidays', ''));
                            
                            if($daytime!='00,00' || $afterwork!='00,00' || $night_plus_weekends!='00,00' || $holidays!='00,00'){
                                if($daytime!='0,00' || $afterwork!='0,00' || $night_plus_weekends!='0,00' || $holidays!='0,00'){
                                    $csv_array[]=[
                                        $manager_user->username,
                                        $manager_user->group_user,
                                        $username01,            
                                        $daytime, //daytime  
                                        $afterwork,//afterwork  
                                        $night_plus_weekends,//night+weekend - 111
                                        $holidays,//holidays-112
                                        $monthly_rule_modify,
                                        $final_diff,
                                        $this->calc103Cell($monthly_rule_obj, $daytime, $afterwork, $night_plus_weekends, $holidays),//103
                                        $this->calc104Cell($monthly_rule_obj, $daytime, $afterwork, $night_plus_weekends, $holidays),//104
                                        
                                        $manager_user->id
                                    ];
                                }
                            }
                        }
                    }
                } else{     
                    $username01=$manager_user->username0;
                    $encoding=mb_detect_encoding($username01);
                   
                    
                    if($encoding==='ASCII'){
                        $username01 = mb_convert_encoding($username01, "UTF-8", "ASCII");
                    }
                    $encoding1=mb_detect_encoding($username01);
                    
                   
                    
                    //modify current app code
                    $daytime=$this->formatTime($this->modifyTime(trim($users_info_html[3]), 'daytime', ''));
                    $afterwork=$this->formatTime($this->modifyTime(trim($users_info_html[5]), 'afterwork', ''));
                    $night_plus_weekends=$this->formatTime(
                            $this->modifyTime(
                                //see this array http://prntscr.com/nky240
                                trim($users_info_html[7]),//night time 
                                'combo', //mode
                                trim($users_info_html[9]),//weekend 
                                trim($users_info_html[13]) //holidays 45
                            )
                    );
                    $holidays=$this->formatTime($this->modifyTime(trim($users_info_html[11]), 'holidays', ''));
                   
                    if($daytime!='00,00' || $afterwork!='00,00' || $night_plus_weekends!='00,00' || $holidays!='00,00'){
                        if($daytime!='0,00' || $afterwork!='0,00' || $night_plus_weekends!='0,00' || $holidays!='0,00'){
                            $csv_array[]=[
                                $manager_user->username,
                                $manager_user->group_user,
                                $username01,
                                $daytime,//daytime
                                $afterwork,//afterwork
                                $night_plus_weekends,//night+weekends+holidays 45 - 111 cell
                                //trim($users_info_html[7]).'+'.trim($users_info_html[9]),//night+weekends test
                                $holidays,//holidays 112
                                '',  
                                '',
                                
                                '',//103
                                '',//104
                                $manager_user->id
                                
                            ];
                        }
                    }
                }

                $j++;
            }
            }//end foreach

            //////////////////////////////////////////////////////////////////////////////////////
            //unset($csv_array[1]);//delete second row with manager-old
            
            $to1 = 'developer3452@gmail.com';
            $subject = 'CSV collect DK';
            $headers = "From: info@curiotime.com\r\n";
            $headers .= "MIME-Version: 1.0\r\n";
            $headers .= "Content-Type: text/html; charset=UTF-8\r\n"; 
            $message='<pre>'.print_r($users_info_html, true).'</pre>';
            //mail($to1, $subject, $message, $headers);
            
                
            $pathFile = JPATH_BASE.DS.'tmp_csv_collect'.DS.$filename; 
            $fp = fopen($pathFile, 'w');//open file
            fprintf($fp, chr(0xEF).chr(0xBB).chr(0xBF));
            fwrite($fp,b"\xEF\xBB\xBF");//write special iceland symbols
            
            foreach($csv_array as $k=>$v){
                $user_id=$v[11];
                
                if($user_id==$manager_info->owner_id){
                    //delete manager row in csv
                    unset($csv_array[$k]);
                } 
                
                $iteration_user=JFactory::getUser($user_id);
                $monthly_rule_obj=$this->getSpecRuleObj($user_id, $iteration_user->spec_number);
                
                if($monthly_rule_obj->checkbox_after=='1' || $monthly_rule_obj->checkbox_night=='1'){
                    $csv_array[$k][3]='00,00';
                    $csv_array[$k][4]='00,00';
                    $csv_array[$k][5]='00,00';
                    $csv_array[$k][6]='00,00';
                    //$csv_array[$k][7]='00,00';
                    //$csv_array[$k][8]='00,00';
                }
                
                unset($csv_array[$k][11]);//delete user id cell in csv
            }
            
            foreach ($csv_array as $fields) {
                //fputcsv($fp, $fields, ';');
                fputs($fp, implode(";", $fields)."\r\n");
            }                     
            fclose($fp);  
        }
        
    }*/
    
    function pc_permute($items, $perms = array( )) { 
        if (empty($items)) { 
            print join(' ', $perms) . "\n"; 
            
        } else { 
            for ($i = count($items) - 1; $i >= 0; --$i) { 
                $newitems = $items; $newperms = $perms; 
                list($foo) = array_splice($newitems, $i, 1); 
                array_unshift($newperms, $foo); pc_permute($newitems, $newperms);    
            }   
        } 
    } 
    
    private function getAllCombinations ($words) {
        $result = [];
      
        $n = count($words);
        
        //get factorial
        $f = 1;
        for ($i = 1; $i <= $n; $i++) $f = $f * $i;
        for($i=0;$i < $f; $i++) {
            $pos = $i % ($n-1);
            if($pos == 0) $first = array_shift($words);
            $result[$i] = [];
            for($j = 0; $j < $n-1; $j++ ) {
                if($j == $pos) $result[$i][]=$first;
                $result[$i][] = $words[$j];
            }
            if($pos==($n-2)) {
                $words[]=$first;
            }
        }
        return ($result);
    }       
    
    /**
     * Create DK csv new(after custom headers text). Not delete this.
     * After unification of the same cell. OLD. Canceled
     * 
    */ 
    public function createCsvCollectDK0($lang, $filename, $from, $to, $user_id, $additional_mode, $note, $groups)
    { 
        setlocale(LC_CTYPE, "en_US.UTF-8");
        $manager_info= JFactory::getUser($user_id);
      
        if($lang=="is"){
            $l = 'is';
        } else{
            $l = 'en';
        }
               
        if(in_array(6, $manager_info->groups)) {//from manager
            $csv_array=[];
            $i=0;
            if($l==='is'){
               $this->lang->setLanguage('is-IS');
               $this->lang->load();
            } 

            $manager_users_object=$this->getUsersFromManagerCheckHidden($manager_info->id);//get manager users
            $space='';
            
            $custom_headers=$this->getDkHeaders($manager_info->id);
          
            if(empty($custom_headers)){
                $csv_array[]=[
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_ID'),
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_DEP'),
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_NAME'),
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_DAYTIME'),//101
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_AFTERW'),//110
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_NIGHT_WEEKENDS'),//111
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_HOLIDAYS'),//112
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_MONTHLY'),//100
                    102,
                    103,
                    104,
                    ''
                ];
           } else{
                $all_combinations=$this->getAllCombinations(array_values((array)$custom_headers));                                                                          
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_dk_unification.html', print_r(array_values((array)$custom_headers), true), FILE_APPEND | LOCK_EX);
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_dk_unification.html', print_r($all_combinations, true), FILE_APPEND | LOCK_EX);
                
             
              // $ij=0;
              /*  foreach($all_combinations as $one_combination){
                    echo '<pre>';
                    print_r($one_combination);
                    echo '</pre>';
					
                    foreach($one_combination as $k=>$v){
                       
                        
                        if(in_array($v, $one_combination)){
                            file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_dk_unification.html', print_r($v.'=>'.$one_combination[$ij], true), FILE_APPEND | LOCK_EX);
                        }
                        
                      
                    }
                    $ij++;
                }*/
               
                $all_coincidences=array_count_values((array)$custom_headers);
                file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_dk_unification.html', print_r($all_coincidences, true), FILE_APPEND | LOCK_EX);
                
                $csv_array[]=[
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_ID'),
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_DEP'),
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_NAME'),
                    $custom_headers->daytime_pos_header,//101
                    $custom_headers->after_hours_pos_header,//110
                    $custom_headers->night_pos_header ,//111
                    $custom_headers->weekends_pos_header,//112
                    JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_MONTHLY'),//100
                    102,
                    $custom_headers->holidays_45_pos_header,
                    $custom_headers->holidays_90_pos_header,
                    ''
                ];
            }

            include_once($this->server_path.'/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
      
            $j=0;
            $count=count($manager_users_object);
           // file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect.html', print_r($additional_mode, true), FILE_APPEND | LOCK_EX);
           
            try{
                if($additional_mode=='search'){
                    $groups_array=explode(',', $groups);
                }
            } catch (Exception $ex) {
                $groups_array='';
            }
        
            foreach($manager_users_object as $manager_user){
                if(in_array($manager_user->group_user, $groups_array) || empty($groups_array[0])) { 
                    
                switch($additional_mode){
                    case 'search':
                        //$note='dd';
                        $link=$this->sitename.'/index.php?task=getTimeByPeriodCollectSearch&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1&note='.$note; 
                    break;
                    default:
                        $link=$this->sitename.'/index.php?task=getTimeByPeriodCollect&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1';
                    break;
                }
                
                
                $html = file_get_html($link);//simple html
                
                if(empty($html) == false){
                    $users_info_html=[];
                    $i=0;
                    foreach($html->find('div[class="span4 offset8 custom_bootstrap_span"] div span') as $e){                 
                        $users_info_html[]=$e->plaintext;
                    }  
                }
                
                
                $k0=0;
                //$is_holiday=$this->isHoliday();
                 
                //if selected monthly rule in loop
                if($manager_user->spec_number>0){   
                    $monthly_rule_obj=$this->getSpecRuleObj($manager_user->id, $manager_user->spec_number);
                    $monthly_rule=$monthly_rule_obj->spec_rule; //173:10  
                             
                    //$monthly_rule='20:00'; //173:10           
                    $total=trim($users_info_html[1]);

                    
                   
                    $monthly_rule_modify=$monthly_rule;
                    
                   
                    $total_modify=$total;
                    
                    $monthly_rule_modify_arr=explode(':', $monthly_rule_modify);
                    $monthly_rule_modify_arr_min=$monthly_rule_modify_arr[0]*60+$monthly_rule_modify_arr[1];
                    
                    $total_modify_arr=explode(':', $total_modify);
                    $total_modify_arr_min=$total_modify_arr[0]*60+$total_modify_arr[1];
                    
                   
                    $diff=null;
                  
                     
                    if($total_modify_arr_min<$monthly_rule_modify_arr_min){
                        $mode0='<';
                        $result=$total_modify;
                    } elseif($total_modify_arr_min>$monthly_rule_modify_arr_min){
                        $mode0='>';
                        $result=$monthly_rule_modify;
                        $diff=$total_modify_arr_min-$monthly_rule_modify_arr_min;
                       
                    } else{
                        $mode0='==';
                        $result=$total_modify;
                    }
                    //It ispossible the error  not cast to format '00:00', row type '98.75:00'
                    //$final_diff=$this->modifyTime(($diff/60).':00', 'diff', '');
                    $final_diff=$this->convertToHoursMins($diff);
                         
                    $username01=$manager_user->username0;
                    $encoding=mb_detect_encoding($username01);
                   
                    
                    if($encoding==='ASCII'){
                        $username01 = mb_convert_encoding($username01, "UTF-8", "ASCII");
                    }
                    $encoding1=mb_detect_encoding($username01);
                    
                    
                    if($mode0==='<'){
                        $result=$this->formatTime($result);
                        $final_diff=$this->formatTime($final_diff);
                        
                        if($result!='00,00' || $final_diff!='00,00' && ($result!='0,00' || $final_diff!='0,00')){
                            //modify current app code
                            $daytime=$this->formatTime($this->modifyTime(trim($users_info_html[3]), 'daytime', ''));
                            $afterwork=$this->formatTime($this->modifyTime(trim($users_info_html[5]), 'afterwork', ''));
                            $night_plus_weekends=$this->formatTime(
                                    //see this array http://prntscr.com/nky240
                                    $this->modifyTime(
                                            trim($users_info_html[7]), //night time
                                            'combo', //mode
                                            trim($users_info_html[9]),//weekend
                                            trim($users_info_html[13]) //holidays 45
                                    )
                            );
                            $holidays=$this->formatTime($this->modifyTime(trim($users_info_html[11]), 'holidays', ''));
                            
                            if($daytime!='00,00' || $afterwork!='00,00' || $night_plus_weekends!='00,00' || $holidays!='00,00'){
                                if($daytime!='0,00' || $afterwork!='0,00' || $night_plus_weekends!='0,00' || $holidays!='0,00'){
                                    //$csv_array[0]+=[103,104];
                                   
                                    
                                    $csv_array[]=[
                                        $manager_user->username,
                                        $manager_user->group_user,
                                        $username01,            
                                        $daytime, //daytime  
                                        $afterwork,//afterwork  
                                        $night_plus_weekends,//night+weekend-111
                                        $holidays,//holidays-112
                                        
                                        $result,
                                        $final_diff,
                                        
                                        $this->calc103Cell($monthly_rule_obj, $daytime, $afterwork, $night_plus_weekends, $holidays),//103
                                        $this->calc104Cell($monthly_rule_obj, $daytime, $afterwork, $night_plus_weekends, $holidays),//104
                                        
                                        $manager_user->id
                                    ];
                                    
                                    /*$final_coincidence_arr=[];
                                    
                                    foreach($all_coincidences as $k=>$v){
                                        if($v>1){
                                            $final_coincidence_arr[$k]=$v;
                                        }
                                    }
                                    $final_coincidence_arr['mode']=1;
                                    file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_dk_unification.html', print_r($final_coincidence_arr, true), FILE_APPEND | LOCK_EX);*/
                                }
                            }
                        }
                    } else{
                        $monthly_rule_modify=$this->formatTime($monthly_rule_modify);
                        $final_diff=$this->formatTime($final_diff);
                        
                        if($monthly_rule_modify!='00,00' || $final_diff!='00,00' && ($monthly_rule_modify!='0,00' || $final_diff!='0,00')){
                            //modify current app code
                            $daytime=$this->formatTime($this->modifyTime(trim($users_info_html[3]), 'daytime', ''));
                            $afterwork=$this->formatTime($this->modifyTime(trim($users_info_html[5]), 'afterwork', ''));
                            $night_plus_weekends=$this->formatTime(
                                    //see this array http://prntscr.com/nky240
                                    $this->modifyTime(
                                            trim($users_info_html[7]), //night time
                                            'combo', //mode
                                            trim($users_info_html[9]),//weekend
                                            trim($users_info_html[13]) //holidays 45
                                    )
                            );
                            $holidays=$this->formatTime($this->modifyTime(trim($users_info_html[11]), 'holidays', ''));
                            
                            if($daytime!='00,00' || $afterwork!='00,00' || $night_plus_weekends!='00,00' || $holidays!='00,00'){
                                if($daytime!='0,00' || $afterwork!='0,00' || $night_plus_weekends!='0,00' || $holidays!='0,00'){
                                    $csv_array[]=[
                                        $manager_user->username,
                                        $manager_user->group_user,
                                        $username01,            
                                        $daytime, //daytime  
                                        $afterwork,//afterwork  
                                        $night_plus_weekends,//night+weekend - 111
                                        $holidays,//holidays-112
                                        $monthly_rule_modify,
                                        $final_diff,
                                        $this->calc103Cell($monthly_rule_obj, $daytime, $afterwork, $night_plus_weekends, $holidays),//103
                                        $this->calc104Cell($monthly_rule_obj, $daytime, $afterwork, $night_plus_weekends, $holidays),//104
                                        
                                        $manager_user->id
                                    ];
                                    /*$final_coincidence_arr=[];
                                    
                                    foreach($all_coincidences as $k=>$v){
                                        if($v>1){
                                            $final_coincidence_arr[$k]=$v;
                                        }
                                    }
                                    $final_coincidence_arr['mode']=2;
                                    file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_dk_unification.html', print_r($final_coincidence_arr, true), FILE_APPEND | LOCK_EX);*/
                                }
                            }
                        }
                    }
                } else{     
                    $username01=$manager_user->username0;
                    $encoding=mb_detect_encoding($username01);
                   
                    
                    if($encoding==='ASCII'){
                        $username01 = mb_convert_encoding($username01, "UTF-8", "ASCII");
                    }
                    $encoding1=mb_detect_encoding($username01);
                    
                   
                    
                    //modify current app code
                    $daytime=$this->formatTime($this->modifyTime(trim($users_info_html[3]), 'daytime', ''));
                    $afterwork=$this->formatTime($this->modifyTime(trim($users_info_html[5]), 'afterwork', ''));
                    $night_plus_weekends=$this->formatTime(
                            $this->modifyTime(
                                //see this array http://prntscr.com/nky240
                                trim($users_info_html[7]),//night time 
                                'combo', //mode
                                trim($users_info_html[9]),//weekend 
                                trim($users_info_html[13]) //holidays 45
                            )
                    );
                    $holidays=$this->formatTime($this->modifyTime(trim($users_info_html[11]), 'holidays', ''));
                   
                    if($daytime!='00,00' || $afterwork!='00,00' || $night_plus_weekends!='00,00' || $holidays!='00,00'){
                        if($daytime!='0,00' || $afterwork!='0,00' || $night_plus_weekends!='0,00' || $holidays!='0,00'){
                            $csv_array[]=[
                                $manager_user->username,
                                $manager_user->group_user,
                                $username01,
                                $daytime,//daytime
                                $afterwork,//afterwork
                                $night_plus_weekends,//night+weekends+holidays 45 - 111 cell
                                //trim($users_info_html[7]).'+'.trim($users_info_html[9]),//night+weekends test
                                $holidays,//holidays 112
                                '',  
                                '',
                                
                                '',//103
                                '',//104
                                $manager_user->id
                            ];
                            
                           
                        }
                    }
                }

                $j++;
            }
            }//end foreach

            //////////////////////////////////////////////////////////////////////////////////////
            //unset($csv_array[1]);//delete second row with manager-old
            
            $to1 = 'developer3452@gmail.com';
            $subject = 'CSV collect DK';
            $headers = "From: info@curiotime.com\r\n";
            $headers .= "MIME-Version: 1.0\r\n";
            $headers .= "Content-Type: text/html; charset=UTF-8\r\n"; 
            $message='<pre>'.print_r($users_info_html, true).'</pre>';
            //mail($to1, $subject, $message, $headers);
            
                
            $pathFile = JPATH_BASE.DS.'tmp_csv_collect'.DS.$filename; 
            $fp = fopen($pathFile, 'w');//open file
            fprintf($fp, chr(0xEF).chr(0xBB).chr(0xBF));
            fwrite($fp,b"\xEF\xBB\xBF");//write special iceland symbols
            
            foreach($csv_array as $k=>$v){
                $user_id=$v[11];
                
                if($user_id==$manager_info->owner_id){
                    //delete manager row in csv
                    unset($csv_array[$k]);
                } 
                
                $iteration_user=JFactory::getUser($user_id);
                $monthly_rule_obj=$this->getSpecRuleObj($user_id, $iteration_user->spec_number);
                
                if($monthly_rule_obj->checkbox_after=='1' || $monthly_rule_obj->checkbox_night=='1'){
                    $csv_array[$k][3]='00,00';
                    $csv_array[$k][4]='00,00';
                    $csv_array[$k][5]='00,00';
                    $csv_array[$k][6]='00,00';
                    //$csv_array[$k][7]='00,00';
                    //$csv_array[$k][8]='00,00';
                }
                
                unset($csv_array[$k][11]);//delete user id cell in csv
            }
            
            
            
            $csv_new_array=$this->getCsvArrayWithUnification($csv_array, $all_coincidences, $all_combinations);
            file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_dk_unification.html', print_r($csv_array, true), FILE_APPEND | LOCK_EX);
            file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_dk_unification.html', print_r($csv_new_array, true), FILE_APPEND | LOCK_EX);
            
            
            
            foreach ($csv_array as $fields) {
                //fputcsv($fp, $fields, ';');
                fputs($fp, implode(";", $fields)."\r\n");
            }                     
            fclose($fp);  
        }
        
    }
    
    /**
     * Create DK csv new(after custom headers text). Not delete this.
     * After unification of the same cell.
     * 
    */
    public function createCsvCollectDK($lang, $filename, $from, $to, $user_id, $additional_mode, $note, $groups)
    { 
        setlocale(LC_CTYPE, "en_US.UTF-8");
        $manager_info= JFactory::getUser($user_id);
      
        if($lang=="is"){
            $l = 'is';
        } else{
            $l = 'en';
        }
               
        if(in_array(6, $manager_info->groups)) {//from manager
            $csv_array=[];
            $i=0;
            if($l==='is'){
               $this->lang->setLanguage('is-IS');
               $this->lang->load();
            } 

            $manager_users_object=$this->getUsersFromManagerCheckHidden($manager_info->id);//get manager users
            $space='';
            
            $custom_headers=$this->getDkHeaders($manager_info->id);
            $model = JModelLegacy::getInstance('Time_Wages', 'AuditModel');
            $sick_state=$model->getSickState($manager_info->owner_id);
        
            if(empty($custom_headers->daytime_pos_header)){
                $custom_headers->daytime_pos_header=JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_DAYTIME');
            }
            if(empty($custom_headers->after_hours_pos_header)){
                $custom_headers->after_hours_pos_header=JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_AFTERW');
            }
            if(empty($custom_headers->night_pos_header)){
                $custom_headers->night_pos_header=JText::_('NIGHT_TIME');
            }
            if(empty($custom_headers->weekends_pos_header)){
                $custom_headers->weekends_pos_header=JText::_('WEEKENDS');
            }
            if(empty($custom_headers->holidays_45_pos_header)){
                $custom_headers->holidays_45_pos_header=JText::_('HOLIDAYS_45');
            }
            if(empty($custom_headers->holidays_90_pos_header)){
                $custom_headers->holidays_90_pos_header=JText::_('HOLIDAYS_90');
            }
            if(empty($custom_headers->sick_pos_header) && $sick_state==1){
                $custom_headers->sick_pos_header=JText::_('COM_AUDIT_PAY_PERIOD_SICK');
            }
            
            if($sick_state==1){     
                $csv_array_header=[
                    'id'=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_ID'),
                    //'dep'=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_DEP'),
                    'name'=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_NAME'),
                    'daytime'=>$custom_headers->daytime_pos_header,//101
                    'after'=>$custom_headers->after_hours_pos_header,//110
                    'night'=>$custom_headers->night_pos_header ,//111
                    'weekend'=>$custom_headers->weekends_pos_header,//112
                    'holiday45'=>$custom_headers->holidays_45_pos_header,
                    'holiday90'=>$custom_headers->holidays_90_pos_header,
                    'sick'=>$custom_headers->sick_pos_header,
                    'user_id'=>''
                ];
            } else{
                $csv_array_header=[
                    'id'=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_ID'),
                    //'dep'=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_DEP'),
                    'name'=>JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_REPORTS_DK_NAME'),
                    'daytime'=>$custom_headers->daytime_pos_header,//101
                    'after'=>$custom_headers->after_hours_pos_header,//110
                    'night'=>$custom_headers->night_pos_header ,//111
                    'weekend'=>$custom_headers->weekends_pos_header,//112
                    'holiday45'=>$custom_headers->holidays_45_pos_header,
                    'holiday90'=>$custom_headers->holidays_90_pos_header,
                    //'sick'=>$custom_headers->sick_pos_header,
                    'user_id'=>''
                ];
            }
            $csv_array[0] = array_unique($csv_array_header);
                        
            include_once($this->server_path.'/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
      
            $j=0;
            $count=count($manager_users_object);
           
            try{
                if($additional_mode=='search'){
                    $groups_array=explode(',', $groups);
                }
            } catch (Exception $ex) {
                $groups_array='';
            }
            
            foreach($manager_users_object as $manager_user){
                if(in_array($manager_user->group_user, $groups_array) || empty($groups_array[0])) { 
                    
                switch($additional_mode){
                    case 'search':
                        //$note='dd';
                        $link=$this->sitename.'/index.php?task=getTimeByPeriodCollectSearch&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1&note='.$note; 
                    break;
                    default:
                        $link=$this->sitename.'/index.php?task=getTimeByPeriodCollect&from=' . $from . '&to=' . $to . '&u_id='.$manager_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1';
                    break;
                }
                
                
                $html = file_get_html($link);//simple html
                
                if(empty($html) == false){
                    $users_info_html=[];
                    $i=0;
                    foreach($html->find('div[class="span4 offset8 custom_bootstrap_span"] div span') as $e){                 
                        $users_info_html[]=$e->plaintext;
                    }  
                }
                
                
                $k0=0;
                
                //if selected monthly rule in loop
                    $username01=$manager_user->username0;
                    $encoding=mb_detect_encoding($username01);
                   
                    
                    if($encoding==='ASCII'){
                        $username01 = mb_convert_encoding($username01, "UTF-8", "ASCII");
                    }
                    $encoding1=mb_detect_encoding($username01);
                    
                    //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_dk_unification.html', print_r($users_info_html, true), FILE_APPEND | LOCK_EX);   
                    
                    //modify current app code
                    $daytime=$this->formatTime($this->modifyTime(trim($users_info_html[3]), 'daytime', ''));
                    $afterwork=$this->formatTime($this->modifyTime(trim($users_info_html[5]), 'afterwork', ''));
                    $holidays=$this->formatTime($this->modifyTime(trim($users_info_html[7]), 'holidays', ''));
                    $holidays2 = $this->formatTime($this->modifyTime(trim($users_info_html[9]), 'holidays2', '')); 
                    if($sick_state==1){
                        $sick_time= $this->formatTime($this->modifyTime(trim($users_info_html[11]), 'sick', '')); 
                    }
                   
                    //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_dk_unification.html', print_r($daytime.'-'.$afterwork.'-'.$night.'-'.$weekend.'-'.$holidays2.'-'.$holidays, true), FILE_APPEND | LOCK_EX);   
                     
                   
                    if($daytime!='00,00' || $afterwork!='00,00' /*|| $night_plus_weekends!='00,00'*/ || $holidays!='00,00'){
                        if($daytime!='0,00' || $afterwork!='0,00' /*|| $night_plus_weekends!='0,00'*/ || $holidays!='0,00'){
                            if($sick_state==1){
                                $user_row = [
                                    'id'=>$manager_user->username,
                                    //'dep'=>$manager_user->group_user,
                                    'dep'=>'',
                                    'name'=>$username01,
                                    'daytime'=>$daytime,
                                    'after'=>$afterwork,
                                    'holiday45'=>$holidays2,
                                    'holiday90'=>$holidays,
                                    'sick'=>$sick_time,
                                    'user_id'=>$manager_user->id
                                ];
                            } else{
                                $user_row = [
                                    'id'=>$manager_user->username,
                                    //'dep'=>$manager_user->group_user,
                                    'dep'=>'',
                                    'name'=>$username01,
                                    'daytime'=>$daytime,
                                    'after'=>$afterwork,
                                    'holiday45'=>$holidays2,
                                    'holiday90'=>$holidays,
                                    //'sick'=>$sick_time,
                                    'user_id'=>$manager_user->id
                                ];
                            }
                           //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect2.html', print_r($user_row,true));
                           
                           $row = array();  $array_key = array();
                           
                           foreach($csv_array_header as $k=>$value){
                               $current = $user_row[$k];
                               
                               foreach($csv_array_header as $k2=>$value2){
                                    if($value == $value2 && $k!=$k2 && !(in_array($k2, $array_key))){
                                        $current = str_replace('.',',',str_replace(',', '.', $current)+str_replace(',', '.', $user_row[$k2]));
                                       
                                        array_push($array_key,$k2);
                                        
                                        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_dk_unification.html', print_r('match: current= '.$current.', $user_row[$k2]= '.$user_row[$k2],true), FILE_APPEND | LOCK_EX);   
                                    }    
                               }
                               
                               if(!(in_array($k, $array_key))){
                                array_push($row,$current);    
                               }
                               array_push($array_key,$k);
                               
                           }
                           
                           $final_row=[];
                           foreach($row as $row_item){
                               //$row_item='0';
                               if($row_item=='0'){
                                   $row_item='00,00';
                               }
                               $final_row[]=$row_item;
                           }
                           $csv_array[]=$final_row; 
                           //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_fix_0.html', print_r($row, true), FILE_APPEND | LOCK_EX);
                        }
                    }
                

                $j++;
            }
            }//end foreach
           
            //////////////////////////////////////////////////////////////////////////////////////
           
            
            $to1 = 'developer3452@gmail.com';
            $subject = 'CSV collect DK';
            $headers = "From: info@curiotime.com\r\n";
            $headers .= "MIME-Version: 1.0\r\n";
            $headers .= "Content-Type: text/html; charset=UTF-8\r\n"; 
            $message='<pre>'.print_r($users_info_html, true).'</pre>';
            //mail($to1, $subject, $message, $headers);
            
                
            $pathFile = JPATH_BASE.DS.'tmp_csv_collect'.DS.$filename; 
            $fp = fopen($pathFile, 'w');//open file
            fprintf($fp, chr(0xEF).chr(0xBB).chr(0xBF));
            fwrite($fp,b"\xEF\xBB\xBF");//write special iceland symbols
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_dk_unification.html', print_r(array_search('user_id', array_keys($csv_array[0])), true), FILE_APPEND | LOCK_EX);
            $index_user_id = array_search('user_id', array_keys($csv_array[0]));  // user_id index - need to remove user_id from array               
            foreach($csv_array as $k=>$v){
                $user_id=$v[$index_user_id];
                
                if($user_id==$manager_info->owner_id){
                    //delete manager row in csv
                    unset($csv_array[$k]);
                } 
                
                $iteration_user=JFactory::getUser($user_id);
                $monthly_rule_obj=$this->getSpecRuleObj($user_id, $iteration_user->spec_number);
                
                if($monthly_rule_obj->checkbox_after=='1' || $monthly_rule_obj->checkbox_night=='1'){
                    $csv_array[$k][3]='00,00';
                    $csv_array[$k][4]='00,00';
                    $csv_array[$k][5]='00,00';
                    $csv_array[$k][6]='00,00';
                    //$csv_array[$k][7]='00,00';
                    //$csv_array[$k][8]='00,00';
                }
                
                unset($csv_array[$k][$index_user_id]);//delete user id cell in csv
            }
            
            
            foreach ($csv_array as $fields) {
                //fputcsv($fp, $fields, ';');
                fputs($fp, implode(";", $fields)."\r\n");
            }                     
            fclose($fp);  
        }
        
    }
    
    /**
     * Сonverting one string to another.
     *
     * @param  string  $string
     * @param string $format_from
     * @param string $format_to
     * @return string
     */
    private function convertFormat($string, $format_from, $format_to)
    {
        $arr=explode($format_from, $string);   
        $final_string="'".$arr[0].$format_to.$arr[1]."'";
        return $final_string;
    }
    
    private function getCsvArrayWithUnification($csv_old_array, $all_coincidences, $all_combinations)
    {
        if(!empty($csv_old_array)){
            $final_coincidence_arr=[]; 
            foreach($all_coincidences as $k=>$v){
                if($v>1){
                    $final_coincidence_arr[$k]=$v;
                }
            }
            $final_coincidence_arr['mode']=3;   
            file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/collect_dk_unification.html', print_r($final_coincidence_arr, true), FILE_APPEND | LOCK_EX);
            
            foreach($csv_old_array as $k=>$v)
            {
                if($k>0){
                    if($v[$k][3]){
                        
                    }
                }
            } 
            
            foreach($all_combinations as $one_combination){
                    echo '<pre>';
                    print_r($one_combination);
                    echo '</pre>';
					
                    foreach($one_combination as $k=>$v){
                       
                        
                        if(in_array($v, $one_combination)){
                           print_r('Finded '.$v.'=>'.$one_combination);
                        }
                        
                      
                    }
                      $ij++;
                }
            
        }
    }
    
    private function calc103Cell($monthly_rule, $daytime, $afterwork, $night_plus_weekends, $holidays)
    {
        if($monthly_rule->checkbox_after=='1'){
            $daytime_arr=explode(',', $daytime);
            $afterwork_arr=explode(',', $afterwork);
            $night_plus_weekends_arr=explode(',', $night_plus_weekends);
            $holidays_arr=explode(',', $holidays);
        
            $final_summ_h=$daytime_arr[0]+$afterwork_arr[0]+$night_plus_weekends_arr[0]+$holidays_arr[0];
            $final_summ_m=$daytime_arr[1]+$afterwork_arr[1]+$night_plus_weekends_arr[1]+$holidays_arr[1];
            
            //test
            //$final_summ_h='25';
            //$final_summ_m='136';
            
            //file_put_contents('/home/curiotime/app.curiotime.com/logs/test_csv_log.html', print_r($monthly_rule, true), FILE_APPEND | LOCK_EX);
            if($final_summ_m>=100){
                $final_summ_h++;
                $final_summ_m=$final_summ_m-100;
            }
            $final_summ= $final_summ_h.','.$final_summ_m;
            return $final_summ; 
        }
        
    }
    
    private function calc104Cell($monthly_rule, $daytime, $afterwork, $night_plus_weekends, $holidays)
    {
        if($monthly_rule->checkbox_night=='1'){
            $daytime_arr=explode(',', $daytime);
            $afterwork_arr=explode(',', $afterwork);
            $night_plus_weekends_arr=explode(',', $night_plus_weekends);
            $holidays_arr=explode(',', $holidays);
        
            $final_summ_h=$daytime_arr[0]+$afterwork_arr[0]+$night_plus_weekends_arr[0]+$holidays_arr[0];
            $final_summ_m=$daytime_arr[1]+$afterwork_arr[1]+$night_plus_weekends_arr[1]+$holidays_arr[1];
            
            //test
           // $final_summ_h='25';
           // $final_summ_m='136';
            
            //file_put_contents('/home/curiotime/app.curiotime.com/logs/test_csv_log.html', print_r($monthly_rule, true), FILE_APPEND | LOCK_EX);
            if($final_summ_m>=100){
                $final_summ_h++;
                $final_summ_m=$final_summ_m-100;
            }
            $final_summ= $final_summ_h.','.$final_summ_m;
            return $final_summ; 
        }
        
    }
    
    private function convertToHoursMins($time/*, $format = '%02d:%02d'*/) {
        if ($time < 1) { 
            return '00:00';
        }
        $hours = floor($time / 60);
        $minutes = ($time % 60);
        
        return  $hours.':'.$minutes;
    } 
    
    private function formatTime($time, $csv_dk_mode = null)
    {
        $res = str_replace(':', ',', $time);
        if($csv_dk_mode == true){
            $time_arr = explode(',', $res);
            $min = $time_arr[1];
            $minutes = ($min / 60);
        
            $final =  preg_replace('/(\..{2}).*/', '$1', ($time_arr[0] + $minutes));
            $res = str_replace('.', ',', $final);
            return  $res;
          
        }
        
        return $res;
    }
    
    private function getSpecRule($user_id, $rule_id)
    {
        $query='SELECT `spec_rule` FROM #__audit_spec_rules WHERE `id`="'.$rule_id.'"';
        $this->db->setQuery( $query );
        $res=$this->db->loadObject();
       
        return $res;
    }
    
    private function getSpecRuleObj($user_id, $rule_id)
    {
        $query='SELECT * FROM #__audit_spec_rules WHERE `id`="'.$rule_id.'"';
        $this->db->setQuery( $query );
        $res=$this->db->loadObject();
      
        return $res;
    }
    
    private function modifyTime($time, $mode, $two_time, $holidays_45) 
    {

        $time_arr=explode(':', $time);
        
        
        switch($mode){
            case 'combo':
                if(!empty($two_time)){
                    $two_time_arr=explode(':', $two_time);
                    $holidays_45_arr=explode(':', $holidays_45);

                    $time_arr[0]=$time_arr[0]+$two_time_arr[0]+$holidays_45_arr[0];
                    $time_arr[1]=$time_arr[1]+$two_time_arr[1]+$holidays_45_arr[1];
                 }
                break;
            case 'combo2':
                if(!empty($two_time)){
                    $two_time_arr=explode(':', $two_time);
                    //$holidays_45_arr=explode(':', $holidays_45);

                    $time_arr[0]=$time_arr[0]+$two_time_arr[0];
                    $time_arr[1]=$time_arr[1]+$two_time_arr[1];
                 }
                break;
        }

      
      
      
        if($time_arr[0]<=24){
            $h=$time_arr[0];
            $i=$time_arr[1];

           
            if($mode=='combo'){
                if($i>59){
                    $h++;
                    $i-=60; 
                }
                 
            }
            if($mode=='combo2'){
                if($i>59){
                    $h++;
                    $i-=60; 
                }
                 
            }
            
            if($i<10){
               $i='0'.$i;
            } 
            if($h>=24){
                goto mode_hours_larger_24;
            }
            
            $time_str=$h.':'.$i;
            //file_put_contents('/home/curiotime/dk.curiotime.com/logs/test_csv_log.html', print_r($time_str.' ', true), FILE_APPEND | LOCK_EX); 
            if($mode=='combo'){
                //file_put_contents('/home/curiotime/dk.curiotime.com/logs/test_csv_log.html', print_r($time_str, true), FILE_APPEND | LOCK_EX);
                $time_obj=DateTime::createFromFormat('H:i', $time_str);
            } elseif($mode=='combo2'){
                //file_put_contents('/home/curiotime/dk.curiotime.com/logs/test_csv_log.html', print_r($time_str, true), FILE_APPEND | LOCK_EX);
                $time_obj=DateTime::createFromFormat('H:i', $time_str);
            } else{
                $time_obj=DateTime::createFromFormat('H:i', $time);
            }
            
            $minutes_raw=($time_obj->format('H')*60+$time_obj->format('i'))/60;
            $minutes=round($minutes_raw, 2, PHP_ROUND_HALF_UP);
            $minutes_arr=explode('.', $minutes);
            $part2=$minutes_arr[1];

            if($minutes_arr[0]=='0' && empty($part2)){
                $minutes='00:00';
            } elseif($minutes_arr[0]=='0' && !empty($part2)){
                if((string)$part2<10){
                    $part2=$part2.'0';
                }
                if(strlen((string)$part2)==3){
                    $part2=substr($part2, 0, -1);
                }
                $minutes='00:'.$part2;
            } elseif($minutes_arr[0]>0 && $minutes_arr[0]<10 && empty($part2)){
                $minutes='0'.$minutes_arr[0].':00';
            } elseif($minutes_arr[0]>0 && $minutes_arr[0]<10 && !empty($part2)){
                if((string)$part2<10){
                    $part2=$part2.'0';
                }
                if(strlen((string)$part2)==3){
                    $part2=substr($part2, 0, -1);
                }
                $minutes='0'.$minutes_arr[0].':'.$part2;
            } elseif($minutes_arr[0]>=10 && empty($part2)){
                $minutes=$minutes_arr[0].':00';
            } elseif($minutes_arr[0]>=10 && !empty($part2)){
                //file_put_contents($_SERVER['DOCUMENT_ROOT'].'/logs/test_csv_log.html', print_r('mode0'.$minutes_arr[0].' '.$part2.'<br/>', true), FILE_APPEND | LOCK_EX); 
                if((string)$part2<10){
                    $part2=$part2.'0';
                }
                if(strlen((string)$part2)==3){
                    $part2=substr($part2, 0, -1);
                }
                $minutes=$minutes_arr[0].':'.$part2;
            } else{
                $minutes='';
            }
            //return $time_obj->format('H:i').' '.$minutes_raw.' '.$minutes;
            return $minutes;

        } elseif($time_arr[0]>24){
           
            mode_hours_larger_24:
            if($mode=='combo'){
                $h=$time_arr[0];
                $i=$time_arr[1];

                if($i<10){
                    $i='0'.$i;
                }
              
            
                $time_str=[
                    0=>$h,
                    1=>$i
                ];
                $time_obj=$time_str;
            } elseif($mode=='combo2'){
                $h=$time_arr[0];
                $i=$time_arr[1];

                
               
                if($i<10){
                    $i='0'.$i;
                }
              
            
                $time_str=[
                    0=>$h,
                    1=>$i
                ];
                $time_obj=$time_str;
            } else{
                $time_obj=$time_arr;
            }
            $minutes_raw=($time_obj[0]*60+$time_obj[1])/60;
            $minutes=round($minutes_raw, 2, PHP_ROUND_HALF_UP);
            $minutes_arr=explode('.', $minutes);

            $part2=$minutes_arr[1];

            if($minutes_arr[0]=='0' && empty($part2)){
                $minutes='00:00';
            } elseif($minutes_arr[0]=='0' && !empty($part2)){
                if((string)$part2<10){
                    $part2=$part2.'0';
                }
                if(strlen((string)$part2)==3){
                    $part2=substr($part2, 0, -1);
                }
                $minutes='00:'.$part2;
            } elseif($minutes_arr[0]>0 && $minutes_arr[0]<10 && empty($part2)){
                $minutes='0'.$minutes_arr[0].':00';
            } elseif($minutes_arr[0]>0 && $minutes_arr[0]<10 && !empty($part2)){
                if((string)$part2<10){
                    $part2=$part2.'0';
                }
                if(strlen((string)$part2)==3){
                    $part2=substr($part2, 0, -1);
                }
                $minutes='0'.$minutes_arr[0].':'.$part2;
            } elseif($minutes_arr[0]>=10 && empty($part2)){
                $minutes=$minutes_arr[0].':00';
            } elseif($minutes_arr[0]>=10 && !empty($part2)){
                //file_put_contents($_SERVER['DOCUMENT_ROOT'].'/logs/test_csv_log.html', print_r('mode0'.$minutes_arr[0].' '.$part2.'<br/>', true), FILE_APPEND | LOCK_EX); 
               
                if((string)$part2<10){
                    $part2=$part2.'0';
                }
                if(strlen((string)$part2)==3){
                    $part2=substr($part2, 0, -1);
                }
                $minutes=$minutes_arr[0].':'.$part2;
                
            } else{
                $minutes='';
            }

            //return $time.' '.$minutes_raw.' '.$minutes;
            return $minutes;
        }

    }
    
    public function getSelectedRuleNumber($user_id) {
        $user_with_request = JFactory::getUser($user_id);
        $user_rule_number = $user_with_request->rule_number;
        if ($user_rule_number == 0) {
            //$user_rule_number = 1;
            $mode = 1;
        }

        return json_encode([
            'rule_number' => $user_rule_number,
            'is_default_value' => $mode
        ]);
    }
    
    public function getSelectedShiftNumber($user_id) {
        $user_with_request = JFactory::getUser($user_id);
        $user_rule_number = $user_with_request->shift_number;

        if ($user_rule_number == 0) {
            //$user_rule_number=1;
            $mode = 1;
        }

        return json_encode([
            'shift_number' => $user_rule_number,
            'is_default_value' => $mode
        ]);
    }
    
    public function getSelectedLoopNumber($user_id) {
        //here
        $user_with_request = JFactory::getUser($user_id);
        $user_rule_number = $user_with_request->loop_number;

        if ($user_rule_number == 0) {
            //$user_rule_number=1;
            $mode = 1;
        }

        return json_encode([
            'loop_number' => $user_rule_number,
            'is_default_value' => $mode
        ]);
    }
    
   
    
    public function getSelectedModeItemNumber($user_id, $lang)
    {
       if($lang=='is'){
           return JFactory::getUser($user_id)->rule_text_is;
       } else{
           return JFactory::getUser($user_id)->rule_text;
       }   
    }
    
    public function sendMail1($message, $subject)
    {
        $to1 = 'developer3452@gmail.com';
        //$subject = 'CSV collect test';

        $headers = "From: info@curiotime.com\r\n";
        //$headers .= "Reply-To: ". strip_tags($_POST['req-email']) . "\r\n";
        //$headers .= "CC: susan@example.com\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=UTF-8\r\n";      
    
   
        
        mail($to1, $subject, $message, $headers);
    }
    
    public function getLayoutGroups()
    {
        $db =$this->db;
        $current_user=& JFactory::getUser();
        $owner_id=$current_user->owner_id;
        
        $query = "SELECT `id`, `group_user` FROM #__users WHERE `owner_id` = '$owner_id'  ORDER BY `id` DESC";
        $db->setQuery($query);
        $res = $db->loadAssocList();

        $final=$this->super_unique($res, 'group_user');
        //file_put_contents($_SERVER['DOCUMENT_ROOT'].'/logs/test_csv_log.html', print_r($final, true), FILE_APPEND | LOCK_EX); 
        $html='';
        $html1='';
        
        //if(count($final)!=1 && !empty($final[0]['group_user'])){
           
            foreach($final as $group){
                if(!empty($group['group_user'])){
                    $html.=''
                        . '<div class="one_option" data-option-value="'.$group['group_user'].'">' 
                            . '<span>'.$group['group_user'].'</span>'
                            . '<i class="fa fa-circle-thin" aria-hidden="true"></i>'
                        . '</div>';
                }
            } 
            if(!empty($html)){
                 $html1='<div class="one_option one_option_header">include groups:</div>';
                 return $html1.$html;
            } else{
                return '';
            }
       // }
        
       
    }
    
    public function getLayoutGroups1($l) {
        $db = $this->db;
        $current_user = & JFactory::getUser();
        $owner_id = $current_user->owner_id;
        $config = JFactory::getConfig();
         
        $enable_subtasks_in_standart_tasks_on_collect = $config->get('enable_subtasks_in_standart_tasks_on_collect');
        
        $query = "SELECT `id`, `group_user` FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0' ORDER BY `id` DESC";
        $db->setQuery($query);
        $res = $db->loadAssocList();

        $final = $this->super_unique($res, 'group_user');
      
        $html = '';
        $html1 = '';

        //if(count($final)!=1 && !empty($final[0]['g roup_user'])){
        $html1 = '<div class="one_option one_option_header">' . JText::_("COM_AUDIT_COLLECT_INCL_GROUPS") . '</div>';
        foreach ($final as $group) {
            if (!empty($group['group_user'])) {
                $html .= ''
                        . '<div class="one_option ww" data-option-value="' . $group['group_user'] . '">'
                            . '<i class="fa fa-circle-thin js_event_toggle" aria-hidden="true"></i>'
                            . '<span>' . $group['group_user'] . '</span>'
                        . '</div>';
            }
        }
        //if(!empty($html)){
        if ($l == 'is') {
            $lang = JFactory::getLanguage();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        $manager = JFactory::getUser($this->user->owner_id);
        $dk_token = $manager->dk_token;
        
        if ($this->enable_task_manager_dk_api == '1' && !empty($dk_token) && $manager->sync_dk_tasks == 1 && $manager->sync_uniconta_tasks != '1') {
            $html2 = '<div class="one_option one_option_header">' . JText::_("COM_AUDIT_COLLECT_NEW_SYNCED_TASK") . '</div>';
            $html2 .= $this->getDkTaskListHtml();
        }
        if ($this->enable_uniconta_tasks == '1' && $manager->sync_uniconta_tasks == '1' && !empty($manager->uniconta_uname) && !empty($manager->uniconta_upassw)) {
            $html2 .= '<div class="one_option one_option_header">' . JText::_("Uniconta tasks:") . '</div>';
            $html2 .= $this->getUnicontaTaskListHtml();
        }
       
        $html2 .= '<div class="one_option one_option_header">' . JText::_("COM_AUDIT_COLLECT_INCL_TASK") . '</div>';
        $html2 .= $this->getTaskList();
        //if($enable_subtasks_in_standart_tasks_on_collect == '1'){
           // $html2 .= $this->getSubtaskTaskList();
       // }

        return $html1 . $html . $html2;
       
    }
    
    private function getSubtaskTaskList(int $parent_id)
    {
       
        $query = "SELECT * FROM #__audit_subtasks_list WHERE `parent_id` = '".$parent_id."' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $list = $this->db->loadObjectList();
        
        return $list;
    }
    
    public function checkActionPermission($type, $individual_params)
    {
        $res='0';
        
        switch($type){
            
            case 'getTasksListForShifts':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $user_id_from_request = $individual_params['user_from_request'];
                //$user_id_for_clone = $individual_params['user_for_clone_obj'];
                
                $user_from_request_obj = & JFactory::getUser($user_id_from_request);
                //$user_id_for_clone_obj = & JFactory::getUser($user_id_for_clone);
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 /*& ($user_from_request_obj->owner_id == $owner_id)*/){
                    $res = '1';
                }
            break;
            case 'getAttachedTasksListForShifts':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $user_id_from_request = $individual_params['user_from_request'];
                //$user_id_for_clone = $individual_params['user_for_clone_obj'];
                
                $user_from_request_obj = & JFactory::getUser($user_id_from_request);
                //$user_id_for_clone_obj = & JFactory::getUser($user_id_for_clone);
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 /*& ($user_from_request_obj->owner_id == $owner_id)*/){
                    $res = '1';
                }
            break;
            case 'getTasksListForPayPeriod':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $user_id_from_request = $individual_params['user_from_request'];
                //$user_id_for_clone = $individual_params['user_for_clone_obj'];
                
                $user_from_request_obj = & JFactory::getUser($user_id_from_request);
                //$user_id_for_clone_obj = & JFactory::getUser($user_id_for_clone);
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 /*& ($user_from_request_obj->owner_id == $owner_id)*/){
                    $res = '1';
                }
            break;
            
        }
      
       
       return $res;
    }
    
    public function getTasksListForShifts($l) {
       

       
        $html = '';
        $html1 = '';

        
        if ($l == 'is') {
            $lang = JFactory::getLanguage();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        $manager = & JFactory::getUser($this->user->owner_id);
        $dk_token = $manager->dk_token;
        
        if ($this->enable_task_manager_dk_api == '1' && !empty($dk_token) && $manager->sync_dk_tasks == 1) {
            $html2 = '<div class="one_option one_option_header">' . JText::_("COM_AUDIT_COLLECT_NEW_SYNCED_TASK") . '</div>';
            $html2 .= $this->getDkTaskListHtml();
        }
       
        $html2 .= '<div class="one_option one_option_header">' . JText::_("COM_AUDIT_COLLECT_INCL_TASK") . '</div>';
        $html2 .= $this->getTaskListForShifts();

        return $html1 . $html . $html2;
       
    }
    
    public function getTasksListForPayPeriod($l) {
        $html = '';
        $html1 = '';

        
        if ($l == 'is') {
            $lang = JFactory::getLanguage();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        $manager = & JFactory::getUser($this->user->owner_id);
        $dk_token = $manager->dk_token;
        
        if ($this->enable_task_manager_dk_api == '1' && !empty($dk_token) && $manager->sync_dk_tasks == 1 && $manager->sync_uniconta_tasks != '1') {
            $html2 = '<div class="one_option one_option_header">' . JText::_("COM_AUDIT_COLLECT_NEW_SYNCED_TASK") . '</div>';
            $html2 .= $this->getDkTaskListHtml();
        }
        if ($this->enable_uniconta_tasks == '1' && $manager->sync_uniconta_tasks == '1' && !empty($manager->uniconta_uname) && !empty($manager->uniconta_upassw)) {
            $html2 .= '<div class="one_option one_option_header">' . JText::_("Uniconta tasks") . '</div>';
            $html2 .= $this->getUnicontaTaskListHtml();
        }
       
        $html2 .= '<div class="one_option one_option_header">' . JText::_("COM_AUDIT_COLLECT_INCL_TASK") . '</div>';
        $html2 .= $this->getTaskListForPP();

        return $html1 . $html . $html2;
    }
    
    //point
    public function getAttachedTasksListForShifts($l, $shedule_id, $user_id, $mode) {
       
        $html = '';
        $html2 = '';
        $html1 = '';
        $html3 = '';
        $dk_part_html = '';
        $standart_tasks_html = '';
        
        if ($l == 'is') {
            $lang = JFactory::getLanguage();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        $manager = & JFactory::getUser($this->user->owner_id);
        $dk_token = $manager->dk_token;

        if ($this->enable_task_manager_dk_api == '1' && !empty($dk_token) && $manager->sync_dk_tasks == 1) {
            $html = '<div class="one_option one_option_header">' . JText::_("COM_AUDIT_COLLECT_NEW_SYNCED_TASK") . '</div>';
            //$html2 = '';
            
            try{
                $html3 .= $this->getDkTaskListHtmlAndAttached($shedule_id, $user_id, $mode);
            } catch (Exception $ex) {

            }
           
            if(!empty($html3)){
                $dk_part_html = $html.$html3;
            }  
        }
       
       
       
        $html_st = '<div class="one_option one_option_header">' . JText::_("COM_AUDIT_COLLECT_INCL_TASK") . '</div>';
        
        try{
            $html2 .= $this->getAttachedTaskListForShifts($shedule_id, $user_id, $mode);
        } catch (Exception $ex) {

        }
        //echo '$html2:'.$html2.PHP_EOL;
        //echo $html2.PHP_EOL;
        if(!empty($html2)){
            $standart_tasks_html =  $html_st.$html2;
        }

        return $dk_part_html . $standart_tasks_html;
       
    }
    
    public function getAttachedTasksListForShiftsForAppApi($l, $shedule_id, $user_id, $mode) {
      
       
        
        
        if ($l == 'is') {
            $lang = JFactory::getLanguage();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        
        $user_by_token = JFactory::getUser($user_id);
        $manager = JFactory::getUser($user_by_token->owner_id);
        
      
        
        if ($this->enable_task_manager_dk_api == '1' && !empty($manager->dk_token)) {

            try{
                $html3 = $this->getAttachedDkTasksForAppApi($shedule_id, $user_id, $mode);
            } catch (Exception $ex) {

            }
           
           
        }

        try{
            $html2 = $this->getAttachedTasksForShiftsAppApi($shedule_id, $user_id, $mode);
        } catch (Exception $ex) {

        }
      
        return [
            'attached_dk_tasks'=> $html3,
            'attached_standart_tasks' => $html2
        ];

       
       
    }
    
    private function getDkSubtasks()
    {
        JLoader::register('AuditModelDk', JPATH_ROOT . '/components/com_audit/models/dk.php');
        $model_dk = JModelLegacy::getInstance('Dk', 'AuditModel');
        $dk_tasks = $model_dk->getDkSubtasks();
        
        if($dk_tasks->Message){
            throw new Exception('Error on DK server with text: '.$dk_tasks->Message);
        }
        
        return json_encode($dk_tasks);
    }
    
    private function getDkTaskListHtmlAndAttached($shedule_id, $user_id, $mode)
    {
        $query = "SELECT * FROM #__com_shifts_reservations WHERE `room_id` = '".$user_id."' AND `id` = '".$shedule_id."'";
        $this->db->setQuery($query);
        $shedule_object = $this->db->loadObject();
        $query = '';
        $attached_dk_tasks = $shedule_object->tasks_ids;
        
        
        if(!empty( $attached_dk_tasks)){
          $attached_dk_tasks_arr = explode(',', $attached_dk_tasks);
        } else{
            $attached_dk_tasks_arr = [];
            //$html = '';
            //return $html;
        }
        
        /*echo '<pre>$attached_dk_tasks_arr:';
        print_r($attached_dk_tasks_arr);
        echo '</pre>';*/
        /*echo '<pre>$shedule_object:';
        print_r($shedule_object);
        echo '</pre>';  
        
        echo '<pre>$attached_dk_tasks_arr:';
        print_r($attached_dk_tasks_arr);
        echo '</pre>';*/
        //point
        if($this->enable_task_manager_dk_api == '1'){
            if($mode == 'only_attached' && !empty($attached_dk_tasks_arr)){
                $query = "SELECT * FROM #__audit_dk_task_list WHERE `id` IN(".implode(',', $attached_dk_tasks_arr).") OR `original_id` IN('".implode(',', $attached_dk_tasks_arr)."') ORDER BY `id` DESC";
            } else{
                if($mode != 'only_attached'){
                    $query = "SELECT * FROM #__audit_dk_task_list WHERE `id_user` = '".$this->user->owner_id."' ORDER BY `id` DESC";
                }
            }
            //echo $query;
            $this->db->setQuery($query);
            $dk_task_list = $this->db->loadAssocList();
            
            /*echo '<pre>';
            print_r($dk_task_list);
            echo '</pre>';*/
            
            if(empty($dk_task_list)){
               // $dk_task_list_for_api = json_decode($this->getDkTaskList());
            }
            
            $subtasks_dk_list = json_decode($this->getDkSubtasks());
        }
        
        if(!empty($dk_task_list) && $this->enable_task_manager_dk_api == '1'){ 
            foreach( $dk_task_list as $one_task){
                unset($active_class);
                unset($icon_class);
                
                if ($mode != 'only_attached') {
                    if (in_array($one_task['id'], $attached_dk_tasks_arr)) {
                        $active_class = ' selected_option_active';
                        $icon_class = 'fa js_event_toggle fa-check-circle-o';
                    } else {
                        $icon_class = 'fa fa-circle-thin js_event_toggle';
                    }
                } else{
                     $active_class = ' selected_option_active';
                     $icon_class = 'fa fa-check-circle-o';
                }

                $html .= ''
                    . '<div class="one_option_task'.$active_class.'" data-dk-task-id="'.$one_task['id'].'" data-option-value="'.$one_task['original_id'].' | '.$one_task['text'].'">' 
                        . '<i class="'.$icon_class.'" aria-hidden="true"></i>'
                        . '<span class="js_event_task_text">'.$one_task['original_id'].' | '.$one_task['text'].'</span>'
                        . '<i class="fa fa-caret-down i_dk_collect_plus js_event_open_dk_subtasks" aria-hidden="true"></i>';
                
                $html .= '<div class="dk_subtasks_wrapper d-none">'; 
                    foreach ($subtasks_dk_list as $one_subtask) {
                        $html .= '<div class="one_subtask d-flex">          
                            <div class="dk_subtask_content"><i class="fa fa-circle-thin js_event_toggle_dk" aria-hidden="true"></i>' .$one_task['original_id'].' | '.$one_task['text'] .' | '.$one_subtask->DESCRIPTION. '</div>';
                        $html .= '</div>';
                    }
                    $html .= '</div>';
                
               $html .= '</div>';  
            }
           
        } elseif(empty($dk_task_list) && $this->enable_task_manager_dk_api == '1'){
            foreach( $dk_task_list_for_api as $one_task){
                $html.=''
                    . '<div class="one_option_task" data-dk-task-id="'.$one_task->Number.'" data-option-value="'.$one_task->Number.' | '.$one_task->Name.'">' 
                        . '<i class="fa fa-circle-thin js_event_toggle" aria-hidden="true"></i>'
                        . '<span class="js_event_task_text">'.$one_task->Number.' | '.$one_task->Name.'</span>'
                        . '<i class="fa fa-caret-down i_dk_collect_plus js_event_open_dk_subtasks" aria-hidden="true"></i>';    
                
                 $html .= '<div class="dk_subtasks_wrapper d-none">'; 
                    foreach ($subtasks_dk_list as $one_subtask) {
                        $html .= '<div class="one_subtask d-flex">          
                            <div class="dk_subtask_content"><i class="fa fa-circle-thin js_event_toggle_dk" aria-hidden="true"></i>' .$one_task->Number.' | '.$one_task->Name .' | '.$one_subtask->DESCRIPTION. '</div>';
                        $html .= '</div>';
                    }
                    $html .= '</div>'
              . '</div>';  
            }
        }
        
        return $html;
    }
    
    private function getAttachedDkTasksForAppApi($shedule_id, $user_id, $mode)
    {
        $query = "SELECT * FROM #__com_shifts_reservations WHERE `room_id` = '".$user_id."' AND `id` = '".$shedule_id."'";
        $this->db->setQuery($query);
        $shedule_object = $this->db->loadObject();
        
        $query = '';
        $attached_dk_tasks = $shedule_object->tasks_ids;
        
        $final = [];
        
        if(!empty( $attached_dk_tasks)){
          $attached_dk_tasks_arr = explode(',', $attached_dk_tasks);
        } else{
            $attached_dk_tasks_arr = [];
        }
        
       
        
        if($this->enable_task_manager_dk_api == '1'){
            if($mode == 'only_attached' && !empty($attached_dk_tasks_arr)){
                $query = "SELECT `id`,`text`,`original_id` FROM #__audit_dk_task_list WHERE `id` IN(".implode(',', $attached_dk_tasks_arr).") OR `original_id` IN('".implode(',', $attached_dk_tasks_arr)."') ORDER BY `id` DESC";
            } else{
                if($mode != 'only_attached'){
                    $query = "SELECT `id`,`text`,`original_id` FROM #__audit_dk_task_list WHERE `id_user` = '".$this->user->id."' ORDER BY `id` DESC";
                }
            }
          
            $this->db->setQuery($query);
            $dk_task_list = $this->db->loadObjectList();  
        }
        
        if(!empty($dk_task_list) && $this->enable_task_manager_dk_api == '1'){ 
            $i = 0;
            
            foreach( $dk_task_list as $k => $one_task){
                
               
                $final[$i] = $one_task;
                $final[$i]->text = $one_task->original_id . ' | ' . $one_task->text;
                unset($final[$i]->original_id);
                
                $i++;
            }
           
        } 
        
        return $final;
    }
    
    private function compareFromSort($a, $b)
    {
        //$alphabet = 'aąbcćdeęfghijklłmnnoóqprstuvwxyzźż'; // i used polish letters
        $alphabet =  'aábcdðeéfghiíjklmnoópqrstuúvwxyýzþæö';
        
        $a = mb_strtolower($a['text']);
        $b = mb_strtolower($b['text']);
            
        for ($i = 0; $i < mb_strlen($a); $i++) {
            if (mb_substr($a, $i, 1) == mb_substr($b, $i, 1)) {
                continue;
            }
            if ($i > mb_strlen($b)) {
                return 1;
            }
            if (mb_strpos($alphabet, mb_substr($a, $i, 1)) > mb_strpos($alphabet, mb_substr($b, $i, 1))) {
                return 1;
            } else {
                return -1;
            }
        }
    } 
    
    private function getDkTaskListHtml()
    {
        if($this->enable_task_manager_dk_api == '1'){
            $query = "SELECT * FROM #__audit_dk_task_list WHERE `id_user` = '".$this->user->owner_id."' AND `JobStatus` = '1' ORDER BY `id` DESC";
            $this->db->setQuery($query);
            $dk_task_list = $this->db->loadAssocList();
            usort($dk_task_list, [$this, 'compareFromSort']);
             
            if(empty($dk_task_list)){
                $dk_task_list_for_api = json_decode($this->getDkTaskList());
            }
            
            $subtasks_dk_list = json_decode($this->getDkSubtasks());
            //usort($subtasks_dk_list, [$this, 'compareFromSort']);
        }
        
        if(!empty($dk_task_list) && $this->enable_task_manager_dk_api == '1'){ 
            foreach( $dk_task_list as $one_task){
                $html.=''
                    . '<div class="one_option_task" data-dk-task-id="'.$one_task['id'].'" data-option-value="'.$one_task['original_id'].' | '.$one_task['text'].'">' 
                        . '<i class="fa fa-circle-thin js_event_toggle" aria-hidden="true"></i>'
                        . '<span class="js_event_task_text">'.$one_task['original_id'].' | '.$one_task['text'].'</span>'
                        . '<i class="fa fa-caret-down i_dk_collect_plus js_event_open_dk_subtasks" aria-hidden="true"></i>';
                
                $html .= '<div class="dk_subtasks_wrapper d-none">'; 
                    foreach ($subtasks_dk_list as $one_subtask) {
                        $html .= '<div class="one_subtask d-flex">          
                            <div class="dk_subtask_content"><i class="fa fa-circle-thin js_event_toggle_dk" aria-hidden="true"></i>' .$one_task['original_id'].' | '.$one_task['text'] .' | '.$one_subtask->DESCRIPTION. '</div>';
                        $html .= '</div>';
                    }
                    $html .= '</div>'
              . '</div>';  
            }
           
        } elseif(empty($dk_task_list) && $this->enable_task_manager_dk_api == '1'){
            foreach( $dk_task_list_for_api as $one_task){
                $html.=''
                    . '<div class="one_option_task" data-dk-task-id="'.$one_task->Number.'" data-option-value="'.$one_task->Number.' | '.$one_task->Name.'">' 
                        . '<i class="fa fa-circle-thin js_event_toggle" aria-hidden="true"></i>'
                        . '<span class="js_event_task_text">'.$one_task->Number.' | '.$one_task->Name.'</span>'
                        . '<i class="fa fa-caret-down i_dk_collect_plus js_event_open_dk_subtasks" aria-hidden="true"></i>';    
                
                 $html .= '<div class="dk_subtasks_wrapper d-none">'; 
                    foreach ($subtasks_dk_list as $one_subtask) {
                        $html .= '<div class="one_subtask d-flex">          
                            <div class="dk_subtask_content"><i class="fa fa-circle-thin js_event_toggle_dk" aria-hidden="true"></i>' .$one_task->Number.' | '.$one_task->Name .' | '.$one_subtask->DESCRIPTION. '</div>';
                        $html .= '</div>';
                    }
                    $html .= '</div>'
              . '</div>';  
            }
        }
        
        return $html;
    }
    
    private function getAttachedTaskListForShifts($shedule_id, $user_id, $mode) {
        $table_tasks = '#__audit_task_list';
        $table_shifts = '#__com_shifts_reservations';
        $html = '';
        $query = '';
        
        $query = "SELECT * FROM `$table_shifts` WHERE `room_id` = '".$user_id."' AND `id` = '".$shedule_id."'";
        $this->db->setQuery($query);
        $shedule_object = $this->db->loadObject();
        //echo $query;
        unset($query);
        $attached_standart_tasks = $shedule_object->standart_tasks_ids;
        
        if(!empty($attached_standart_tasks)){
            $attached_standart_tasks_arr = explode(',', $attached_standart_tasks);
        } else{
            $attached_standart_tasks_arr = [];
            //$html = '';
            //return $html;
        }
       
        /*echo '<pre>$attached_standart_tasks_arr';
        print_r($attached_standart_tasks_arr);
        echo '</pre>';*/
       
        if($mode == 'only_attached' && !empty($attached_standart_tasks_arr)){
            $query = "SELECT * FROM `$table_tasks` WHERE `id` IN(".implode(',', $attached_standart_tasks_arr).") ORDER BY `id` DESC";
        } else{
            if($mode != 'only_attached'){
                $query = "SELECT * FROM `$table_tasks` WHERE `id_user` = '".$this->user->owner_id."' ORDER BY `id` DESC";
            }
        }
        //echo $query.PHP_EOL;
        $this->db->setQuery($query);
        $dk_task_list = $this->db->loadAssocList();
        /*echo '<pre>$query:';
        print_r($query);
        echo '</pre>';
        
        echo '<pre>$dk_task_list:';
        print_r($dk_task_list);
        echo '</pre>';*/
        
        if(!empty($dk_task_list)){ 
            foreach( $dk_task_list as $one_task){
                unset($active_class);
                unset($icon_class);
                //point
                if ($mode != 'only_attached') {
                    if (in_array($one_task['id'], $attached_standart_tasks_arr)) {
                        $active_class = ' selected_option_active';
                        $icon_class = 'fa js_event_toggle fa-check-circle-o';
                    } else {
                        $icon_class = 'fa fa-circle-thin js_event_toggle';
                    }
                } else{
                     $active_class = ' selected_option_active';
                     $icon_class = 'fa fa-check-circle-o';
                }
            
                $html .= ''
                    . '<div class="one_option_task'.$active_class.' is_standart_task" data-task-id="'.$one_task['id'].'" data-option-value="'.$one_task['text'].'">' 
                        . '<i class="'.$icon_class.'" aria-hidden="true"></i>'
                        . '<span class="js_event_task_text">'.$one_task['text'].'</span>'
                        . '<i class="fa fa-caret-down i_dk_collect_plus js_event_open_dk_subtasks" aria-hidden="true"></i>';
                
                $html .= '<div class="dk_subtasks_wrapper d-none">'; 
                    /*foreach ($subtasks_dk_list as $one_subtask) {
                        $html .= '<div class="one_subtask d-flex">          
                            <div class="dk_subtask_content"><i class="fa fa-circle-thin js_event_toggle_dk" aria-hidden="true"></i>' .$one_task['original_id'].' | '.$one_task['text'] .' | '.$one_subtask->DESCRIPTION. '</div>';
                        $html .= '</div>';
                    }*/
                    $html .= '</div>';
                
               $html .= '</div>';   
            }
           
        }
        
        return $html;   
 
        //old
        /*$query = "SELECT * FROM #__audit_task_list WHERE `id_user` = '".$this->user->id."' ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $res = $this->db->loadAssocList();
        
        
        
        $html = '';
        foreach($res as $one_task){ 
            $html.=''
                . '<div class="one_option_task is_standart_task" data-task-id="'.$one_task['id'].'" data-option-value="'.$one_task['text'].'">' 
                    . '<i class="fa fa-circle-thin js_event_toggle" aria-hidden="true"></i>'
                    . '<span class="js_event_task_text">'.$one_task['text'].'</span>'
                   
                . '</div>';
            
        } 
        
        return $html;*/
    }
    
    private function getAttachedTasksForShiftsAppApi($shedule_id, $user_id, $mode) {
        $table_tasks = '#__audit_task_list';
        $table_shifts = '#__com_shifts_reservations';
      
        $query = '';
        
        $query = "SELECT * FROM `$table_shifts` WHERE `room_id` = '".$user_id."' AND `id` = '".$shedule_id."'";
        $this->db->setQuery($query);
        $shedule_object = $this->db->loadObject();
        unset($query);
        $attached_standart_tasks = $shedule_object->standart_tasks_ids;
        
        if(!empty($attached_standart_tasks)){
            $attached_standart_tasks_arr = explode(',', $attached_standart_tasks);
        } else{
            $attached_standart_tasks_arr = [];
          
        }

        if($mode == 'only_attached' && !empty($attached_standart_tasks_arr)){
            $query = "SELECT `id`,`text` FROM `$table_tasks` WHERE `id` IN(".implode(',', $attached_standart_tasks_arr).") ORDER BY `id` DESC";
        } else{
            if($mode != 'only_attached'){
                $query = "SELECT `id`,`text` FROM `$table_tasks` WHERE `id_user` = '".$this->user->id."' ORDER BY `id` DESC";
            }
        }
      
        $this->db->setQuery($query);
        $standart_task_list = $this->db->loadObjectList();

        return $standart_task_list;   

    }
    
    private function getTaskListForPP() {
        
        $enable_sortable_in_task_manager_and_api = $this->config->get('enable_sortable_in_task_manager_and_api');
        
        if($enable_sortable_in_task_manager_and_api == '1'){
            $order_by='`ordering`';
        } else{
            $order_by='`id` DESC';
        }
        
        $query = "SELECT * FROM #__audit_task_list WHERE `id_user` = '".$this->user->id."' ORDER BY $order_by";
        $this->db->setQuery($query);
        $res = $this->db->loadAssocList();
        
        $config = JFactory::getConfig();
         
        $enable_subtasks_in_standart_tasks_on_collect = $config->get('enable_subtasks_in_standart_tasks_on_collect');
        $checkbox_sync_with_main_tasks_state = $this->getSyncWithMainTasksState();
        $all_submenu_tasks = json_decode($this->getSubmenuTaskList());
       
        
        $html = '';
        foreach($res as $one_task){ 
            unset($subtasks_list);
            if($checkbox_sync_with_main_tasks_state == 1 || $one_task['sync_with_submenu'] == 1){
                $subtasks_list = $all_submenu_tasks;
            } else{
                $subtasks_list = $this->getSubtasks($one_task['id']);
            }
            
            /*echo '<pre>$subtasks_list:';
            print_r($subtasks_list);
            echo '</pre>';*/
            
            $html.='';
              if($enable_subtasks_in_standart_tasks_on_collect == '1'){
                    $html .=  '<div class="one_option_task is_standart_task" data-option-value="'.$one_task['text'].'">'; 
              } else{
                    $html .=  '<div class="one_option_task" data-option-value="'.$one_task['text'].'">';
                    
              }  
              
          
          
                  $html .= 
                     '<i class="fa fa-circle-thin js_event_toggle" aria-hidden="true"></i>'
                    . '<span class="js_event_task_text">'.$one_task['text'].'</span>';
            
                    if($enable_subtasks_in_standart_tasks_on_collect == '1'){
                            if(!empty( $subtasks_list)){
                                $html .= '<i class="fa fa-caret-down i_dk_collect_plus js_event_open_subtasks" aria-hidden="true"></i>';
                       
                                $html .= '<div class="subtasks_wrapper d-none">'; 
                                foreach ($subtasks_list as $one_subtask) {
                                    $html .= '<div class="one_subtask1 d-flex">          
                                        <div class="dk_subtask_content"><i class="fa fa-circle-thin js_event_toggle_subtask1" aria-hidden="true"></i>' . $one_subtask->text . '</div>';
                                    $html .= '</div>';
                                }
                                $html .= ''
                                . '</div>'; 
                            }
                    }
                  
           
            
            $html.=''      
                . '</div>';
            
        } 
        
        return $html;
    }
    
    private function getTaskListForShifts() {
        $query = "SELECT * FROM #__audit_task_list WHERE `id_user` = '".$this->user->owner_id."' ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $res = $this->db->loadAssocList();
        
        /*if($this->enable_task_manager_dk_api == '1'){
            $query = "SELECT * FROM #__audit_dk_task_list WHERE `id_user` = '".$this->user->id."' ORDER BY `id` DESC";
            $this->db->setQuery($query);
            $dk_task_list = $this->db->loadAssocList();
            
            if(empty($dk_task_list)){
                $dk_task_list_for_api = json_decode($this->getDkTaskList());
            }
        }*/
        
        $html = '';
        foreach($res as $one_task){ 
            $html.=''
                . '<div class="one_option_task is_standart_task" data-task-id="'.$one_task['id'].'" data-option-value="'.$one_task['text'].'">' 
                    . '<i class="fa fa-circle-thin js_event_toggle" aria-hidden="true"></i>'
                    . '<span class="js_event_task_text">'.$one_task['text'].'</span>'
                   
                . '</div>';
            
        } /*if(!empty($dk_task_list) && $this->enable_task_manager_dk_api == '1'){ 
            foreach( $dk_task_list as $one_task){
                $html.=''
                    . '<div class="one_option_task" data-option-value="'.$one_task['original_id'].' | '.$one_task['text'].'">' 
                        . '<i class="fa fa-circle-thin" aria-hidden="true"></i>'
                        . '<span>'.$one_task['original_id'].' | '.$one_task['text'].'</span>'
                   
                    . '</div>';       
            }
        } elseif(empty($dk_task_list) && $this->enable_task_manager_dk_api == '1'){
            foreach( $dk_task_list_for_api as $one_task){
                $html.=''
                    . '<div class="one_option_task" data-option-value="'.$one_task->Number.' | '.$one_task->Name.'">' 
                        . '<i class="fa fa-circle-thin" aria-hidden="true"></i>'
                        . '<span>'.$one_task->Number.' | '.$one_task->Name.'</span>'
                   
                    . '</div>';       
            }
        }*/
        
        return $html;
    }
    
   

    private function getSyncWithMainTasksState()
    {
        $table_name = '#__task_manager_main_tasks_sync_state';
         
        $query = "SELECT * FROM $table_name WHERE `manager_id` = '".$this->user->owner_id."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        $state = $data[0]->state;
        if(is_null($state)){
            $state = 0;
        }
        
        return $state;
    }
    
    private function getSubmenuTaskList()
    {
        
        $enable_sortable_in_task_manager_and_api = '1';
        if($enable_sortable_in_task_manager_and_api=='1'){
            $order_by='`ordering`';
        } else{
            $order_by='`id` DESC';
        }
        
        $query = "SELECT * FROM #__audit_submenu_task_list WHERE `id_user` = '".$this->user->owner_id."' ORDER BY $order_by";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        return json_encode($data);
    }
    
    private function getSubtasks($parent_id)
    {
        $parent_id = (int) $parent_id;
        $query = "SELECT * FROM #__audit_subtasks_list WHERE `parent_id` = '".$parent_id."' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $list = $this->db->loadObjectList();
        
        return $list;
    }
    
    private function getTaskList() {
         //$enable_subtask_delete = $config->get('enable_subtask_delete');
        $enable_sortable_in_task_manager_and_api = $this->config->get('enable_sortable_in_task_manager_and_api');
        
        if($enable_sortable_in_task_manager_and_api == '1'){
            $order_by='`ordering`';
        } else{
            $order_by='`id` DESC';
        }
        
        $query = "SELECT * FROM #__audit_task_list WHERE `id_user` = '".$this->user->id."' ORDER BY $order_by";
        $this->db->setQuery($query);
        $res = $this->db->loadAssocList();
        
        $config = JFactory::getConfig();
         
        $enable_subtasks_in_standart_tasks_on_collect = $config->get('enable_subtasks_in_standart_tasks_on_collect');
        $checkbox_sync_with_main_tasks_state = $this->getSyncWithMainTasksState();
        $all_submenu_tasks = json_decode($this->getSubmenuTaskList());
       
        
        $html = '';
        foreach($res as $one_task){ 
            unset($subtasks_list);
            if($checkbox_sync_with_main_tasks_state == 1 || $one_task['sync_with_submenu'] == 1){
                $subtasks_list = $all_submenu_tasks;
            } else{
                $subtasks_list = $this->getSubtasks($one_task['id']);
            }
            
            /*echo '<pre>$subtasks_list:';
            print_r($subtasks_list);
            echo '</pre>';*/
            
            $html.='';
              if($enable_subtasks_in_standart_tasks_on_collect == '1'){
                    $html .=  '<div class="one_option_task one_standart_tasks" data-option-value="'.$one_task['text'].'">'; 
              } else{
                    $html .=  '<div class="one_option_task" data-option-value="'.$one_task['text'].'">';
                    
              }  
              
          
          
                  $html .= 
                     '<i class="fa fa-circle-thin js_event_toggle" aria-hidden="true"></i>'
                    . '<span class="js_event_task_text">'.$one_task['text'].'</span>';
            
                    if($enable_subtasks_in_standart_tasks_on_collect == '1'){
                            if(!empty( $subtasks_list)){
                                $html .= '<i class="fa fa-caret-down i_dk_collect_plus js_event_open_subtasks" aria-hidden="true"></i>';
                       
                                $html .= '<div class="subtasks_wrapper d-none">'; 
                                foreach ($subtasks_list as $one_subtask) {
                                    $html .= '<div class="one_subtask1 d-flex">          
                                        <div class="dk_subtask_content"><i class="fa fa-circle-thin js_event_toggle_subtask1" aria-hidden="true"></i>' . $one_subtask->text . '</div>';
                                    $html .= '</div>';
                                }
                                $html .= '</div>'
                                . '</div>'; 
                            }
                    }
                  
           
            
            $html.=''      
                . '</div>';
            
        } 
        
        return $html;
    }
    
    private function getDkTaskList()
    {
        JLoader::register('AuditModelDk', JPATH_ROOT . '/components/com_audit/models/dk.php');
        $model_dk = JModelLegacy::getInstance('Dk', 'AuditModel');
        $dk_tasks = $model_dk->getDkTasks();
        
        if($dk_tasks->Message){
            throw new Exception('Error on DK server with text: '.$dk_tasks->Message);
        }
        
        return json_encode($dk_tasks);
    }
    
    private function super_unique($array, $key)
    {
        $temp_array = [];
        foreach ($array as &$v) {
            if (!isset($temp_array[$v[$key]]))
                $temp_array[$v[$key]] =& $v;
        }
        $array = array_values($temp_array);
        return $array;
    }
    
    private function getLetters()
    {
       return range('A', 'Z');
    }
    
    private function getFinalUsername($user_obj) {
        $user_from_request_name = '';
        if (!empty($user_obj->username0)) {
            $user_from_request_name = $user_obj->username0;
        } elseif (!empty($user_obj->username)) {
            $user_from_request_name = $user_obj->username;
        } elseif (!empty($user_obj->name)) {
            $user_from_request_name = $user_obj->name;
        } else{
            $user_from_request_name = 'empty_username';
        }
        
        return $user_from_request_name;
    }
    
    private function validateDate($date, $format = 'Y-m-d') {
        $d = DateTime::createFromFormat($format, $date);
        return $d && $d->format($format) === $date;
    }
    
    private function getMonthNameByNumber($number_of_month, $lang) {
        $relations = [
           '01' =>  'Jan',
           '02' => 'Feb',
           '03' => 'Mar',
           '04' => 'Apr',
           '05' => 'Mai',
           '06' => 'Jun',
           '07' => 'Jul',
           '08' => 'Aug',
           '09' => 'Sep',
           '10' => 'Okt',
           '11' => 'Nov',
           '12' => 'Dec'
        ];
        
        /*$relations_is = [
           '01' =>  'janúar',
           '02' => 'febrúar',
           '03' => 'mars',
           '04' => 'apríl',
           '05' => 'maí',
           '06' => 'júní',
           '07' => 'júlí',
           '08' => 'ágúst',
           '09' => 'september',
           '10' => 'október',
           '11' => 'nóvember',
           '12' => 'desember'                          
        ];*/
        
        switch($lang){
            case 'is':
                return $relations[$number_of_month];
            default:
                return $relations[$number_of_month];
        }
        
    }
    
    public function createXlsCollect($lang, $filename, $from, $to, $user_id, $additional_mode, $note, $json_data, $type = null) 
    {
        ini_set('memory_limit', '-1');
      
        
        $manager_info = JFactory::getUser($user_id);

        if ($lang == "is") {
            $l = 'is';
        } else {
            $l = 'en';
        }
        
        $model = JModelLegacy::getInstance('Time_Wages', 'AuditModel');
        JLoader::register('AuditModelRules', JPATH_ROOT . '/components/com_audit/models/rules.php');
        $model_rules = JModelLegacy::getInstance('Rules', 'AuditModel');
            
        $sick_state = $model->getSickState($manager_info->owner_id);
        $tasks = $json_data['tasks0'];
        $groups = $json_data['groups'];
        
        try {
            if ($additional_mode == 'search') {
                if (!empty($groups)) {
                    $groups_array = explode(',', $groups);
                }
                if (!empty($tasks)) {
                    $tasks_array = explode(',', $tasks);
                }
            }
        } catch (Exception $ex) {
            $groups_array = '';
            $tasks_array = '';
        }

        if (in_array(6, $manager_info->groups) || in_array(10, $manager_info->groups)) {
             
             if(in_array(6, $manager_info->groups)){
                $manager_users_object = $this->getUsersFromManagerCheckHidden($manager_info->id);//get manager users
            } elseif(in_array(10, $manager_info->groups)){
                $manager_users_object = $this->getUsersFromManagerCheckHidden($manager_info->owner_id);//get manager users
            }
            
           
            require_once JPATH_LIBRARIES . '/PHPExcel/Classes/PHPExcel.php';
            require_once JPATH_LIBRARIES . '/PHPExcel/Classes/PHPExcel/Writer/Excel2007.php';

            $xls = new PHPExcel();
            

            //set document info
            $xls->getProperties()->setTitle("Excel user data export");
            $xls->getProperties()->setSubject("Excel user data export");
            $xls->getProperties()->setCreator("Curio time");
            $xls->getProperties()->setManager("UXD");
            $xls->getProperties()->setCompany("UXD");
            $xls->getProperties()->setLastModifiedBy("UXD");
            $xls->getProperties()->setCreated(date('d.m.Y H:i:s'));

            //remove hidden users 
            foreach ($manager_users_object as $one_user) {
                if(in_array($one_user->group_user, $groups_array) || empty($groups_array[0])) {
                   
                    
                    if ($one_user->is_hide == 0 && $manager_info->owner_id != $one_user->id) {
                        $user_list_ids[] = $one_user;
                    }
               }
            }

            $aplhabet = $this->getLetters();
            include_once($this->current_home_path . '/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');

            $i = 0;
            $default_width = 12;
             
            foreach ($user_list_ids as $one_filter_user) {
                //if($one_filter_user->id != 3629) continue;
                unset($htmlSrc);
                unset($json);
                unset($arr);
               
                
                $username = $this->getFinalUsername($one_filter_user);
                $objWorkSheet = $xls->createSheet($i); //Setting index when creating
                
                //set sheet name in bottom
                $objWorkSheet->setTitle($username);

                $objWorkSheet->setCellValue('A1', $username);//username
                $objWorkSheet->setCellValue('A2', $one_filter_user->username);//user id
                $objWorkSheet->setCellValue('A3', $from . '-' . $to);//period
                
                $objWorkSheet->getColumnDimension('A')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('B')->setWidth(30);
                $objWorkSheet->getColumnDimension('C')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('D')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('E')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('F')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('G')->setWidth($default_width);
                $objWorkSheet->getColumnDimension('H')->setWidth($default_width);
                
                $objWorkSheet->getColumnDimension('I')->setWidth(40);
                $objWorkSheet->getColumnDimension('J')->setWidth(80);

                ///begin new
                $userSpaceUsed = 0;

                $rule_mode = $model_rules->getUserRuleForText($one_filter_user->id);
                $header_texts_obj = $model_rules->getTexts($rule_mode['mode'], $rule_mode['rule_id'], $lang);

                switch ($additional_mode) {
                    case 'search':
                        $link = $this->current_url.'index.php?task=getTimeByPeriodCollectSearch';

                        if(!empty($tasks_array)){ 
                           $link = $this->current_url.'/index.php?task=getTimeByPeriodCollectWithTasks&from=' . $from . '&to=' . $to . '&u_id='.$one_filter_user->id.'&lang=' . $lang . '&mode=pdf&mode_all_user=1&tasks0='.urlencode(implode(',', $tasks_array)).'&is_load_for_new_pay_period='.$is_load_for_new_pay_period;
                        } else{
                            $post = [
                                'totals2' => '1',
                                'from' => $from,
                                'to' => $to,
                                'u_id' => $one_filter_user->id,
                                'lang' => $lang, 
                                'mode' => 'pdf',
                                'mode_all_user' => 1, 
                                'note' => $note,
                            ];
                        }
                       
                        break;
                    default:
                        /*$link = $this->current_url . '/index.php?task=getTimeByPeriodCollect'
                            . '&totals2=1'
                            . '&from=' . $from . ''
                            . '&to=' . $to . ''
                            . '&u_id=' . $one_filter_user->id . ''
                            . '&lang=' . $lang . ''
                            . '&mode=pdf'
                            . '&mode_all_user=1';*/
                        
                        $link = $this->current_url.'index.php?task=getTimeByPeriodCollect';
                        $post = [
                            'totals2' => '1',
                            'from' => $from,
                            'to' => $to,
                            'u_id' => $one_filter_user->id,
                            'lang' => $lang, 
                            'mode' => 'pdf',
                            'mode_all_user' => 1,
                           
                        ];
                        break;
                }
               
                if( $curl = curl_init() ) {
                    curl_setopt($curl, CURLOPT_URL, $link);
                    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($curl, CURLOPT_POST, false);
                    curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($post));
                    $out = curl_exec($curl);
                    $htmlSrc =  $out;
                 
                    curl_close($curl);
                }
                
                $html = str_get_html($htmlSrc); //simple html
              
               
                
                $default_cell_table_start = 5;//table rows starts from A5
              
                
                //Don't iterate over the table if no results are found, go to next user. Nessesary fix for excel opening
                if( count($html->find('.trigger_no_result')) == 1){
                    continue(1);
                }
                
               
                foreach($html->find('table.pdf_not_width') as $table){
                    $tr_i = $default_cell_table_start;
                    
                    foreach($table->find('tr') as $tr){
                        $td_i = 0;
                        
                        foreach($tr->find('td') as $td){
                            if($td_i === 0){
                                $td_text = trim($td->find('div[class="selectDayUser"]', 0)->plaintext);
                                if($tr_i === $default_cell_table_start){
                                    $td_text = trim($td->plaintext);
                                }
                            } else{
                                $td_text = trim($td->plaintext);
                            }
                            
                            $current_leter = $aplhabet[$td_i].$tr_i;
                            
                            //file_put_contents($this->current_home_path . '/logs/collect_replace_to_comas.html', print_r($td_text . PHP_EOL, true), FILE_APPEND | LOCK_EX); 
                            if($type == 'coma'){
                                $td_text = str_replace(':', ',', $td_text);
                                
                            }
                            $td_text = str_replace('Holidays', '', $td_text);
                            //$td_text = str_replace('45%', '\n45%', $td_text);
                            $xls->getActiveSheet()->getStyle('I37')->getAlignment()->setWrapText(true);
                            
                            //check date string and replace date format
                            $is_date = $this->validateDate($td_text, 'd.m');
                            if($is_date == 1){
                                $string_arr = explode('.', $td_text);
                                
                                if(count($string_arr) == 2){
                                    $td_text = $string_arr[0] . '.' . $this->getMonthNameByNumber($string_arr[1], $lang);
                                }
                            }
                            
                            //file_put_contents($this->current_home_path . '/logs/collect_replace_to_comas.html', print_r('$is_date:' . $is_date . PHP_EOL, true), FILE_APPEND | LOCK_EX); 
                             
                            if($this->enable_separated_column_by_note_on_collect_excel == '1'){
                                $text_arr = explode('|', $td_text);
                                $count_text_arr = count($text_arr);
                                
                                if($count_text_arr > 1){
                                    $td_text = '';
                                    
                                    for($i = 0; $i <= $count_text_arr; $i++){
                                        if($i == 0) continue;
                                        
                                        $td_text .= ' | ' . $text_arr[$i];
                                    }
                                    
                                    $td_text = ltrim($td_text, ' | ');
                                    $td_text = chop($td_text, ' | ');
                                    
                                  
                                   
                                }
                                //file_put_contents($this->current_home_path . '/logs/collect_replace_to_comas.html', print_r($text_arr, true), FILE_APPEND | LOCK_EX); 
                            }
                            $objWorkSheet->setCellValue($current_leter, $td_text); 
                            
                            //store to next column
                            if($this->enable_separated_column_by_note_on_collect_excel == '1' && $count_text_arr > 1){
                                $td_i += 1;
                                
                                $current_leter = $aplhabet[$td_i].$tr_i;
                                $td_text = $text_arr[0];
                                
                                $objWorkSheet->setCellValue('K'.$default_cell_table_start, JText::_('COM_AUDIT_COLLECT_NEW_XLS_HEADER_K3'));
                                $objWorkSheet->setCellValue($current_leter, $td_text); 
                                $objWorkSheet->getColumnDimension('K')->setWidth(80);
                                
                                $styleArray = [
                                    'font'  => [
                                        'bold'  => true
                                    ]
                                ];

                                $objWorkSheet->getStyle('K'.$default_cell_table_start)->applyFromArray($styleArray);
                                
                                $td_i -= 1;   
                            }
                            
                            //cet bold headers
                            if($tr_i == $default_cell_table_start){
                                $styleArray = [
                                    'font'  => [
                                        'bold'  => true,
                                        //'color' => array('rgb' => '000000'),
                                        //'size'  => 15,
                                        //'name'  => 'Verdana'
                                    ]
                                ];

                                $objWorkSheet->getStyle($current_leter)->applyFromArray($styleArray);
                            }
                            
                            $td_i++;
                        }
                        
                        $tr_i++;
                    }
                }
                
              
                
                if (preg_match("#<!--json-dk-totals--(.*)--json-dk-totals-->#", $htmlSrc, $arr)) {
                    $json = trim($arr[1]);
                    $json = json_decode($json, true);
                    if (empty($json))
                        continue;
                } else {
                    $userSpaceUsed = 1;
                    $xls->removeSheetByIndex(
                        $xls->getIndex(
                            $xls->getSheetByName($username)
                        )
                    );
                    continue;
                }
                
                

                if (isset($json['break'])) {
                    $json['break']['label'] = JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_BREAKS');
                }
                if (isset($json['total'])) {
                    $json['total']['label'] = JText::_('COM_AUDIT_EMPL_STAFF_BIG_CSV_TOTAL');
                }
                
               
               
                
                foreach ($json as $k => $item) {
                    if ($k == 'after_hours') {

                       /* $csv_array[] = [
                            '',
                            $header_texts_obj->after_hours_text,
                            '',
                            $item['total']
                        ];*/
                        
                        //new
                        $current_leter = 'A'.($tr_i);
                        $objWorkSheet->setCellValue($current_leter, $header_texts_obj->after_hours_text); 
                        
                        $current_leter = 'B'.($tr_i++);
                        $objWorkSheet->setCellValue($current_leter, $item['total']);
                        //end new
                    } elseif ($k == 'night') {

                        /*$csv_array[] = [
                            '',
                            $header_texts_obj->night_time_text,
                            '',
                            $item['total']
                        ];*/
                        
                        //new
                        $current_leter = 'A'.($tr_i);
                        $objWorkSheet->setCellValue($current_leter, $header_texts_obj->night_time_text); 
                        
                        $current_leter = 'B'.($tr_i++);
                        $objWorkSheet->setCellValue($current_leter, $item['total']);
                        //end new
                    } elseif ($k == 'weekends') {

                        /*$csv_array[] = [
                            '',
                            $header_texts_obj->night_time_text,
                            '',
                            $item['total']
                        ];*/
                        
                        //new
                        $current_leter = 'A'.($tr_i);
                        $objWorkSheet->setCellValue($current_leter, $header_texts_obj->weekends_text); 
                        
                        $current_leter = 'B'.($tr_i++);
                        $objWorkSheet->setCellValue($current_leter, $item['total']);
                        //end new
                    } else {
                        if ($k != 'total') {
                            

                            //new
                            $current_leter = 'A' . ($tr_i);
                            $objWorkSheet->setCellValue($current_leter, $item['label']);

                            $current_leter = 'B' . ($tr_i++);
                            $objWorkSheet->setCellValue($current_leter, $item['total']);
                            //end new
                        }
                    }



                    if (!isset($totals[$k]['h']))
                        $totals[$k]['h'] = 0;
                    if (!isset($totals[$k]['m']))
                        $totals[$k]['m'] = 0;

                    if (!isset($totals[$k]['label']))
                        $totals[$k]['label'] = $item['label'];

                    $t = explode(":", $item['total']);

                    $totals[$k]['h'] += intval($t[0]);
                    $totals[$k]['m'] += intval($t[1]);
                }


              
                $i++;
            }

            $xls->setActiveSheetIndex(0);

            //remove default worksheet
            $xls->removeSheetByIndex(
                    $xls->getIndex(
                        $xls->getSheetByName('Worksheet')
                    )
            );
            //$pathFile = JPATH_BASE . DS . 'tmp_xls_collect' . DS . $filename;//old
            //$filename = 'XLS_collect-' . time() . '.xls';//new
            jimport('joomla.filesystem.folder');

            $folder = 'tmp_xls_collect';


            if (!JFolder::exists(JPATH_BASE . DS . $folder)) {
                JFolder::create(JPATH_BASE . DS . $folder);
            }

            $pathFile = JPATH_BASE . DS . $folder . DS . $filename; //true

            $objWriter = new PHPExcel_Writer_Excel2007($xls);
            $objWriter->save($pathFile);
            
            return $filename;
        }

    }

    private function unicontaSort($a, $b)
    {
        //$alphabet = 'aąbcćdeęfghijklłmnnoóqprstuvwxyzźż'; // i used polish letters
        $alphabet =  'aábcdðeéfghiíjklmnoópqrstuúvwxyýzþæö';
        
        $a = mb_strtolower($a['name']);
        $b = mb_strtolower($b['name']);
            
        for ($i = 0; $i < mb_strlen($a); $i++) {
            if (mb_substr($a, $i, 1) == mb_substr($b, $i, 1)) {
                continue;
            }
            if ($i > mb_strlen($b)) {
                return 1;
            }
            if (mb_strpos($alphabet, mb_substr($a, $i, 1)) > mb_strpos($alphabet, mb_substr($b, $i, 1))) {
                return 1;
            } else {
                return -1;
            }
        }
    }
    
    private function getUnicontaSubtasks()
    {
        $query = "SELECT * FROM $this->subtask_table_name WHERE `id_user` = '".$this->user->owner_id."' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        return $this->db->loadObjectList();
    }
    
    public function getUnicontaTaskListHtml()
    {
       
        $query = "SELECT * FROM $this->uniconta_table_name WHERE `id_user` = '" . $this->user->owner_id . "' ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $uniconta_task_list = $this->db->loadAssocList();

        usort($uniconta_task_list, [$this, 'unicontaSort']);
        $subtasks_list = $this->getUnicontaSubtasks();
        
        $html = '';
        foreach ($uniconta_task_list as $one_task) {
            $html .= ''
                    . '<div class="one_option_task" data-dk-task-id="' . $one_task['id'] . '" data-option-value="' . $one_task['number0'] . ' | ' . $one_task['account'] . ' | ' . $one_task['name'] . '">'
                    . '<i class="fa fa-circle-thin js_event_toggle" aria-hidden="true"></i>'
                    . '<span class="js_event_task_text">' . $one_task['number0'] . ' | ' . $one_task['account'] . ' | ' . $one_task['name'] . '</span>';
            
            $enable_uniconta_subtasks = 0;
            foreach ($subtasks_list as $one_subtask) {
                if($one_subtask->parent_id === $one_task['id']){
                    $enable_uniconta_subtasks = 1;
                }
            }
            if(!empty($subtasks_list) && $enable_uniconta_subtasks === 1){
                $html .= '<i class="fa fa-caret-down i_dk_collect_plus js_event_open_dk_subtasks" aria-hidden="true"></i>';
            }
            
            $html .= '<div class="dk_subtasks_wrapper d-none">'; 
            foreach ($subtasks_list as $one_subtask) {
                if($one_subtask->parent_id === $one_task['id']){
                    $html .= '<div class="one_subtask d-flex">
                        <div class="dk_subtask_content"><i class="fa fa-circle-thin js_event_toggle_dk" aria-hidden="true"></i>' .$one_subtask->name. '</div>';
                    $html .= '</div>';
                }
            }
              
            $html .= '</div>'; 
            $html .= '</div>';
        }


        return $html;
    }
}
