<?php
/*ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);*/
// No direct access

defined( '_JEXEC' ) or die;

/**
 *@author
 */

class AuditModelCalc extends JModelLegacy{
    
    public function __construct() 
    {
        parent::__construct();

        $this->db = &JFactory::getDBO();
        $this->app = JFactory::getApplication();
        $this->doc = JFactory::getDocument();
        $this->server_path = $_SERVER['DOCUMENT_ROOT'];
        $this->user = & JFactory::getUser();
        $this->lang = JFactory::getLanguage();
        $this->config = &JFactory::getConfig();
        
        
        $this->lang->load('mod_selectcalc', JPATH_SITE,$this->lang->getTag(),true);
        $this->eincome_new_module_table = '#__calculator_earning_income_for_new_module';
        $this->eincome_period_saves_new_module = '#__earned_income_period_saves_for_new_module';
        $this->pp_calc_relation_table = '#__pp_calc_relations';
        $this->salary_auto_save_table = '#__calc_new_module_salary_saves';
        
        $this->enable_see_all_in_new_module_ei_page = 1;
    }
    
    
    public function isRegisterUserFormCalcFieldsEnabled() {
        return intval($this->config->get("enable_register_calc_fields",0));
    }
    
    public function getFieldJobDescription() {
        mb_internal_encoding("UTF-8");
        $jsonFile   =   __DIR__."/json/calc/FieldJobDescription.json";
        $json       =   file_get_contents($jsonFile);
        $json       =   json_decode($json,true);
        foreach ($json as $key=>$items) {
            foreach ($items as $k=>$obj) {
                $json[$key][$k]['label']  = $json[$key][$k]['text'];
                if(mb_strlen($json[$key][$k]['label']) > 50) {
                    $json[$key][$k]['label']  = mb_substr($json[$key][$k]['label'],0,50)."...";
                }
                $json[$key][$k]['value']    =   json_encode(array(
                    array("text"=>$obj['text'],"hours"=>$obj['hours'],"laun"=>$obj['laun']),$key
                ));
            }
        }
        return $json;
    }
    
    public function getFieldSelectWorkDescription() {
        $fieldWorkDescription =  array(
            'customcalc6'=>JText::_('MOD_SELECTCALC_SELECT3_PAGE4'),
            'customcalc4'=>JText::_('MOD_SELECTCALC_SELECT1_PAGE4'),
            'customcalc5'=>JText::_('MOD_SELECTCALC_SELECT2_PAGE4'),
        );
        return $fieldWorkDescription;
        
        
    }
    
   public function getFieldChoosePage3pselect() {
        $fieldAge  =  array(        
                0 => array ("title"=>JText::_('MOD_SELECTCALC_MENUTITLE_SELECT_PAGE3_C0'),'type'=>"first_block",
                    'items'=>array(
                        "1"=>JText::_('MOD_SELECTCALC_OPTION1_PAGE3_C0')
                    )
                ),            
                1 => array ("title"=>JText::_('MOD_SELECTCALC_MENUTITLE_SELECT_PAGE3_C1'),'type'=>"second_block",
                    'items'=>array(
                        "1"=>JText::_('MOD_SELECTCALC_OPTION0_PAGE3_C1'),
                        "2"=>JText::_('MOD_SELECTCALC_OPTION1_PAGE3_C1'),
                        "3"=>JText::_('MOD_SELECTCALC_OPTION2_PAGE3_C1'),
                        "4"=>JText::_('MOD_SELECTCALC_OPTION3_PAGE3_C1'),
                        "5"=>JText::_('MOD_SELECTCALC_OPTION4_PAGE3_C1'),
                        "6"=>JText::_('MOD_SELECTCALC_OPTION5_PAGE3_C1'),
                        "7"=>JText::_('MOD_SELECTCALC_OPTION6_PAGE3_C1'),
                        "8"=>JText::_('MOD_SELECTCALC_OPTION7_PAGE3_C1'),
                        "9"=>JText::_('MOD_SELECTCALC_OPTION8_PAGE3_C1'),
                    )
                ),
                2 => array ("title"=>JText::_('MOD_SELECTCALC_MENUTITLE_SELECT_PAGE3_C2'),'type'=>"third_block",
                    'items'=>array(
                        "1"=>JText::_('MOD_SELECTCALC_OPTION1_PAGE3_C2'),
                        "2"=>JText::_('MOD_SELECTCALC_OPTION2_PAGE3_C2'),
                        "3"=>JText::_('MOD_SELECTCALC_OPTION3_PAGE3_C2'),
                        "4"=>JText::_('MOD_SELECTCALC_OPTION4_PAGE3_C2'),
                        //"lt22"=>JText::_('MOD_SELECTCALC_SELECT5_PAGE7'),
                        
                    )
                ),
                3 => array ("title"=>JText::_('MOD_SELECTCALC_MENUTITLE_SELECT_PAGE3_C3'),'type'=>"fourth_block",
                    'items'=>array(
                        
                        "1"=>JText::_('MOD_SELECTCALC_OPTION1_PAGE3_C3'),
                        "2"=>JText::_('MOD_SELECTCALC_OPTION2_PAGE3_C3'),
                        "3"=>JText::_('MOD_SELECTCALC_OPTION3_PAGE3_C3'),
                        "4"=>JText::_('MOD_SELECTCALC_OPTION4_PAGE3_C3'),
                        "5"=>JText::_('MOD_SELECTCALC_OPTION5_PAGE3_C3'),
                        "6"=>JText::_('MOD_SELECTCALC_OPTION6_PAGE3_C3'),
                        
                    )
                ),
            
            
        );
        return $fieldAge;
    }
    
    public function getFieldUnions() {
        $fieldUnions  =  array(        
            //array('value'=>"",'title'=>"",'enabled'=>false),        
            array('value'=>1,'title'=>"AFL Starfsgreinafélag"),
            array('value'=>4,'title'=>"Drífandi stéttarfélag"),
            array('value'=>7,'title'=>"Framsýn stéttarfélag"),
            array('value'=>10,'title'=>"Verkalýðsfélag Akraness"),
            array('value'=>13,'title'=>"Verkalýðs- og sjómannafélag Bolungarvíkur"),
            array('value'=>16,'title'=>"Verkalýðsfélag Snæfellinga"),
            array('value'=>19,'title'=>"Verkalýðsfélag Þórshafnar"),

            array('value'=>"",'title'=>"",'enabled'=>false),

            array('value'=>2,'title'=>"Aldan stéttarfélag",'enabled'=>false),
            array('value'=>5,'title'=>"Efling stéttarfélag"),
            array('value'=>8,'title'=>"Stéttarfélagið Samstaða"),
            array('value'=>11,'title'=>"Verkalýðsfélag Grindavíkur"),
            array('value'=>14,'title'=>"Verkalýðs- og sjómannafél. Keflavíkur og nágr."),
            array('value'=>17,'title'=>"Verkalýðsfélag Suðurlands"),

            array('value'=>"",'title'=>"",'enabled'=>false),

            array('value'=>3,'title'=>"Báran stéttarfélag"),
            array('value'=>6,'title'=>"Eining-Iðja"),
            array('value'=>9,'title'=>"Stéttarfélag Vesturlands"),
            array('value'=>12,'title'=>"Verkalýðsfélagið Hlíf"),
            array('value'=>15,'title'=>"Verkalýðs- og sjómannafélag Sandgerðis"),
            array('value'=>18,'title'=>"Verkalýðsfélag Vestfirðinga"),	
        );
        
        $auto_union =   intval($this->config->get("enable_home_register_company_form_auto_union",0));
        if($auto_union > 0) {
            $arr  =  array();
            foreach ($fieldUnions as $u) {
                if($u['value'] == $auto_union) {
                    $arr = array($u);
                    return $arr;
                }
            }
            
        }
        return $fieldUnions;
    }
    
    public function getFieldContract() {
        $fieldContracts  =  array(        
            array('value'=>0,'title'=>JText::_('MOD_SELECTCALC_SELECT1_PAGE1')),
            array('value'=>1,'title'=>JText::_('MOD_SELECTCALC_SELECT2_PAGE1')),
            array('value'=>2,'title'=>JText::_('MOD_SELECTCALC_SELECT3_PAGE1')),
        );
        return $fieldContracts;
    }
    
    public function validateRegisteredUser() {
        $calc  = isset($_REQUEST['calc']) ? $_REQUEST['calc'] : array();
        if(empty($calc))
            return false;
        
        if(!$this->isRegisterUserFormCalcFieldsEnabled())
            return false;
        
        if(isset($calc['first_page_union_val']) && intval($calc['first_page_union_val']) >= 0) {
            
            
            if(isset($calc['contract']) == false || $calc['contract'] == "-1") {
                throw new Exception(JText::_('COM_AUDIT_PLEASE_SELECT').": ".JText::_('MOD_SELECTCALC_TITLE_TAB1'));
            }            
            if(isset($calc['title']) == false) {
                throw new Exception(JText::_('COM_AUDIT_PLEASE_SELECT').": ".JText::_('MOD_SELECTCALC_TITLE_TAB2'));
            }                        
            if(isset($calc['module']) == false || empty($calc['module']) || $calc['module']  == "-1") {
                throw new Exception(JText::_('COM_AUDIT_PLEASE_SELECT').": ".JText::_('MOD_SELECTCALC_TEXT_TAB4'));
            }
            
            if(isset($calc['year'])) {
                $years  = intval(date("Y")) - intval($calc['year']);
                if($years < 14) 
                    throw new Exception(JText::_('MOD_SELECTCALC_TEXTYOUNGER14_PAGE7'));
            }
            
        }
        
    }
    
    public function validateForRegister() {
        $retData  =  array(
            'message'=>"",
            'field'=>"",
        );
        
        $calc  = isset($_REQUEST['calc']) ? $_REQUEST['calc'] : array();
        if(empty($calc))
            return $retData;
        
        if(!$this->isRegisterUserFormCalcFieldsEnabled())
            return $retData;
        
        if(isset($calc['first_page_union_val']) && intval($calc['first_page_union_val']) >= 0) {
            if(isset($calc['contract']) == false || $calc['contract'] == "-1") {
                $retData['message'] =   JText::_('COM_AUDIT_PLEASE_SELECT').": ".JText::_('MOD_SELECTCALC_TITLE_TAB1');
                $retData['field'] =   "#registerUserCalcFormContract";
                return $retData;
            }            
            if(isset($calc['title']) == false || empty($calc['title']))  {                
                $retData['message'] =  JText::_('COM_AUDIT_PLEASE_SELECT').": ".JText::_('MOD_SELECTCALC_TITLE_TAB2').$calc['title'];
                $retData['field'] =   "#work_description";
                return $retData;
            }                        
            
            if(isset($calc['checkbox_value']) == false || empty($calc['checkbox_value']) || $calc['checkbox_value']  == "-1") {                
                $retData['message'] =  JText::_('COM_AUDIT_PLEASE_SELECT').": ".JText::_('MOD_SELECTCALC_MENUTITLE_SELECT_PAGE3_C2');
                $retData['field'] =   "#registerUserCalcFormType";
                return $retData;
            }
            
            
            if(isset($calc['module']) == false || empty($calc['module']) || $calc['module']  == "-1") {                
                $retData['message'] =  JText::_('COM_AUDIT_PLEASE_SELECT').": ".JText::_('MOD_SELECTCALC_TEXT_TAB4');
                $retData['field'] =   "#registerUserCalcFormModule";
                return $retData;
            }
            
            if(isset($calc['year'])) {
                $years  = intval(date("Y")) - intval($calc['year']);
                if($years < 14)  {                    
                    $retData['message'] =  JText::_('MOD_SELECTCALC_TEXTYOUNGER14_PAGE7');
                    $retData['field'] =   "#registerUserCalcFormYear";
                    return $retData;
                }
            }
            
        }
        
    }
    
    public function saveRegisteredUser($userId) {
        if(!$this->isRegisterUserFormCalcFieldsEnabled())
            return false;
        
        $userId  = intval($userId);
        if($userId <=0)
            return false;
        //$calc  =  JRequest::getVar('calc',array());
        $calc  = isset($_REQUEST['calc']) ? $_REQUEST['calc'] : array();
        if(empty($calc))
            return false;
        
        
        if(isset($calc['day']) && isset($calc['month']) && isset($calc['year'])) {
            $calc['birthday'] =  $calc['day'].'.'.$calc['month'].'.'.$calc['year'];
            unset($calc['day']);
            unset($calc['month']);
            unset($calc['year']);
        }
        
        $calc['user_id']    =   $userId;
        $calc['timestamp_create']   =   time();
        $calc['date_create']        =   date("Y-m-d H:i:s");
        
        $item = new stdClass();
        foreach ($calc as $k=>$v) {
            $item->$k  = $v;
        }
        $this->db->insertObject("#__calculator_saves",$item, 'id' );
    }
    
    public function saveRegisteredUserWidgetLink(int $userId, string $link) {
        if(!$this->isRegisterUserFormCalcFieldsEnabled())
            return false;
        
        $item = new stdClass();
        $item->id = null;
        $item->user_id = $userId;
        $item->link = $this->db->escape($link);
        
        $this->db->insertObject("#__widget_link_saves", $item, 'id' );
    }
    
    public function drawAddons($type)
    {
        $u_id = $this->app->input->getInt('u_id');
        
        $from_to = $this->getFromToForCalc($u_id);
        /*echo '<pre>';
        print_r($from_to);
        echo '</pre>';*/
        
        ob_start();?>
        <script src="/components/com_audit/assets/scripts/calc_live.js?time=<?=time()?>" type="text/javascript"></script>
        <div class="calc_addons_top <?=$type?>">
            <div class="right_addons"> 
                <div class="calc_addons_from_to_wr">
                    <input type="text" id="from" name="from" class="hasDatepicker2" value="<?=$from_to['from']?>">
                    <input type="text" id="to" name="to" class="hasDatepicker2" disabled="disabled" value="<?=$from_to['to']?>">
                    <button type="button" class="btn btn-standart btn-primary" id="add_total"><?= JText::_('COM_AUDIT_CALC_ADD_TOTAL_BUTTON') ?></button>
                </div>
                <button type="button" class="btn btn-standart btn-primary" id="open_earned_income"><?= JText::_('COM_AUDIT_CALC_SAVE_BUTTON') ?></button>
                <a href="/index.php?option=com_audit&view=calc&task=calc.pdf&download=1&u_id=<?php echo $u_id;?>" type="button" class="btn btn-standart btn-primary" id="generate-calc-pdf"><?= JText::_('COM_AUDIT_CALC_SAVE_PDF_BUTTON') ?></a>                
            </div>
        </div>
        <?php ob_end_flush();
    }
    
    public function drawAddonsNewPsd($type)
    {
        $u_id = $this->app->input->getInt('u_id');
        
        $from_to = $this->getFromToForCalc($u_id);
        /*echo '<pre>';
        print_r($from_to);
        echo '</pre>';*/
        
        ob_start();?>
        <script src="/components/com_audit/assets/scripts/calc_live.js?time=<?=time()?>" type="text/javascript"></script>
        <div class="calc_addons_top <?=$type?>">
            <div class="right_addons"> 
                <div class="calc_addons_from_to_wr">
                    <input type="text" id="from" name="from" class="form-control hasDatepicker2" value="<?=$from_to['from']?>">
                    <input type="text" id="to" name="to" class="form-control hasDatepicker2" disabled="disabled" value="<?=$from_to['to']?>">
                    <button type="button" class="btn btn-standart btn-primary" id="add_total"><?= JText::_('COM_AUDIT_CALC_ADD_TOTAL_BUTTON') ?></button>
                </div>
                <button type="button" class="btn btn-default" id="open_earned_income"><?= JText::_('COM_AUDIT_CALC_SAVE_BUTTON') ?></button>
                <a type="button" class="btn btn-default" href="/index.php?option=com_audit&view=calc&task=calc.pdf&download=1&u_id=<?php echo $u_id;?>" id="generate-calc-pdf"><?= JText::_('COM_AUDIT_CALC_SAVE_PDF_BUTTON') ?></a>                
            </div>
        </div>
        <?php ob_end_flush();
    }
    
   public function getFromToForCalc($user_id)
   {
        /*ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);*/
        
        JLoader::register('AuditModelCustom_pay_period', JPATH_ROOT . '/components/com_audit/models/custom_pay_period.php');

        $model_pay_period = JModelLegacy::getInstance('Custom_pay_period', 'AuditModel');
        $from_to = json_decode($model_pay_period->getInputsPayPeriod($user_id));
    
        $current_date=DateTime::createFromFormat('d.m.Y H:i:s', date('d.m.Y').' 00:00:00')->format('U');
        $from_date1 = DateTime::createFromFormat('d.m.Y', $from_to->from_date);
        $from_date2 = $from_date1->format('d');
        
        $from_date = $from_date2 . date('.m.Y');
        $from_date_unix=DateTime::createFromFormat('d.m.Y', $from_date)->format('U');
        
        $to_date1 = DateTime::createFromFormat('d.m.Y', $from_to->to_date);
        $to_date2 = $to_date1->format('d');

        if ($from_date2 == '01'){
            $to_date = $to_date2 . date('.m.Y');
        }  else{
            $to_date = $to_date2 . date('.m.Y', strtotime('+1month'));
        }

        if ($current_date < $from_date_unix) {
            $from_date_row = DateTime::createFromFormat('d.m.Y', $from_date)->format('Y-m-d');

            $from_date_strtotime = strtotime($from_date_row . '-1months');
            //$from_date_strtotime1=strtotime("$from_date_strtotime -1 month");
            $from_date = date('d.m.Y', $from_date_strtotime);
            $from_date00 = date('Y-m-d', $from_date_strtotime);
            $count_days_in_month = date('t', strtotime($from_date00));

            if ($count_days_in_month == 31) {
                $from_date_strtotime = strtotime($from_date_row . '-1months');
                $from_date = date('d.m.Y', $from_date_strtotime);
            }

            $to_date_row = DateTime::createFromFormat('d.m.Y', $from_date)->format('Y-m-d');
            $to_date_strtotime = strtotime($to_date_row . '+1months -1days');
            $to_date = date('d.m.Y', $to_date_strtotime);
        }
       
        if(empty($from_date) && empty($to_date)){
            $final_res=[
                'from'=>'25.'.date('m.Y', strtotime('-1 month')),
                'to'=>'24.'.date('m.Y', strtotime('+0 month'))
            ];
        } else{
            $final_res=[
               'from'=>$from_date,
               'to'=>$to_date
            ];
        }
         
        return $final_res;
    }
    
    private function createNewRecordInEarnedIncome($from_to_arr, $user, $lang, $calc_params)
    {
        $item = new stdClass();
        $item->user_id = $user->id;
        $item->timestamp_create = time();
        $item->date_create = date('d.m.Y H:i:s');
        $item->period = json_encode($from_to_arr);
        
        foreach($calc_params as $k=>$v){
            $item->$k = $this->prepareRawData($v);
        }
        
        $this->db->insertObject('#__calculator_earning_income', $item);
        $id = $this->db->insertid();
        
        return $id;
    }
    
    public function saveDataForEarnedIncome($from_to_arr, $user, $lang, $calc_params)
    {
        $res = $this->checkExistingPeriod($from_to_arr, $user);
        
        if($res == '0'){
            $this->createNewRecordInEarnedIncome($from_to_arr, $user, $lang, $calc_params);
        } else{
            $this->updateRecordInEarnedIncome($from_to_arr, $user, $lang, $calc_params);
        }
    }
    
    public function saveDataForEarnedIncomeForNewModule($from_to_arr, $user, $lang, $calc_params)
    {
        $res = $this->checkExistingPeriodForNewModule($from_to_arr, $user);
        
        if($res == '0'){
            return $this->createNewRecordInEarnedIncomeForNewModule($from_to_arr, $user, $lang, $calc_params);
        } else{
            return $this->updateRecordInEarnedIncomeForNewModule($from_to_arr, $user, $lang, $calc_params);
        }
    }
    
    private function prepareRawData($item)
    {
        return trim($this->db->escape($item));
    }
    
    private function createNewRecordInEarnedIncomeForNewModule($from_to_arr, $user, $lang, $calc_params)
    {
        $item = new stdClass();
        $item->user_id = $user->id;
        $item->timestamp_create = time();
        $item->date_create = date('d.m.Y H:i:s');
        $item->period = json_encode($from_to_arr);
        
        foreach($calc_params as $k=>$v){
            $item->$k = $this->prepareRawData($v);
        }
        
        $this->db->insertObject($this->eincome_new_module_table, $item);
        $id = $this->db->insertid();
        
        return $id;
    }
    
    private function updateRecordInEarnedIncomeForNewModule($from_to_arr, $user, $lang, $calc_params) {
        $timestamp_last_update = time();
        $date_last_update = date('d.m.Y H:i:s'); 

        $query = "UPDATE " . $this->db->quoteName($this->eincome_new_module_table) . " SET " . $this->db->quoteName('timestamp_last_update') . " = '$timestamp_last_update', " . $this->db->quoteName('date_last_update') . " = '$date_last_update', ";

        foreach ($calc_params as $k => $v) {
            $query .= $this->db->quoteName($k) . " = " . $this->db->quote($v) . ", ";
        }
        $query = rtrim($query, ', ');

        $query .= " WHERE " . $this->db->quoteName('user_id') . " = '$user->id' AND JSON_VALUE(`period`, '$.from') = '" . $from_to_arr['from'] . "' AND JSON_VALUE(`period`, '$.to') = '" . $from_to_arr['to'] . "'";
        $this->db->setQuery($query);
        return $this->db->query();
    }

    private function checkExistingPeriodForNewModule($from_to_arr, $user)
    {
        $query = "SELECT COUNT(id) as count_items FROM $this->eincome_new_module_table WHERE `user_id` = '$user->id' AND JSON_VALUE(`period`, '$.from') = '".$from_to_arr['from']."' AND JSON_VALUE(`period`, '$.to') = '".$from_to_arr['to']."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject()->count_items;

        if($data>0){
            return '1';
        } else{
            return '0';
        } 
    }
    
    private function checkExistingPeriod($from_to_arr, $user)
    {
        $query = "SELECT COUNT(id) as count_items FROM #__calculator_earning_income WHERE `user_id` = '$user->id' AND JSON_VALUE(`period`, '$.from') = '".$from_to_arr['from']."' AND JSON_VALUE(`period`, '$.to') = '".$from_to_arr['to']."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject()->count_items;

        if($data>0){
            return '1';
        } else{
            return '0';
        } 
    }
    
    private function updateRecordInEarnedIncome($from_to_arr, $user, $lang, $calc_params)
    {
        $timestamp_last_update = time();
        $date_last_update = date('d.m.Y H:i:s');
        
        $query = "UPDATE #__calculator_earning_income SET `timestamp_last_update`='$timestamp_last_update', `date_last_update`='$date_last_update', ";   
        
        foreach($calc_params as $k=>$v){
            $query.="`{$k}`='{$v}', ";
        }
        $query = rtrim($query, ', ');
        
        $query.=" WHERE `user_id` = '$user->id' AND JSON_VALUE(`period`, '$.from') = '".$from_to_arr['from']."' AND JSON_VALUE(`period`, '$.to') = '".$from_to_arr['to']."'";
        //echo $query;
        
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function getAllEarnedIncomeRecords($from_to_arr, $user)
    {
        if($from_to_arr!=0){
            $query = "SELECT * FROM #__calculator_earning_income WHERE `user_id` = '$user->id' AND JSON_VALUE(`period`, '$.from') = '".$from_to_arr['from']."' AND JSON_VALUE(`period`, '$.to') = '".$from_to_arr['to']."' ORDER BY `id` ASC";
        } else{
            $query = "SELECT * FROM #__calculator_earning_income WHERE `user_id` = '$user->id' ORDER BY `id` ASC";
        }
        //echo $query
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        return $data;        
    }

    public function prepareTotalsForCalc($html, $user_id, $lang) {
        
        require_once($_SERVER['DOCUMENT_ROOT'].'/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
        $dom = str_get_html($html);
        $q1  = $dom->find('table[class="pdf_not_width"]');

        JLoader::register('AuditModelTime_Wages', JPATH_ROOT . '/components/com_audit/models/time_wages.php');
        $model_settings = JModelLegacy::getInstance('Time_Wages', 'AuditModel');
        $user= & JFactory::getUser($user_id);
        $sick_child_state=$model_settings->getSickChildStateAndConfig($user->owner_id);
        $sick_state=$model_settings->getSickState($user->owner_id);
        
        $result=[]; 
        
        foreach($q1 as $table){
            $q2 = $table->find('tr[class="tr_bottom"]');
            $i=0;
            
            foreach ($q2 as $tr) {
                $total = $tr->find('td[class="app_api_tr_bottom_td_total"]', 0);
                $daytime = $tr->find('td[class="app_api_tr_bottom_td_daytime"]', 0);
                $afterwork = $tr->find('td[class="app_api_tr_bottom_td_afterwork"]', 0);
                $night = $tr->find('td[class="app_api_tr_bottom_td_night"]', 0);
                $weekends = $tr->find('td[class="app_api_tr_bottom_td_weekends"]', 0);
                $holidays_90 = $tr->find('*[class="app_api_tr_bottom_td_holidays_90"]', 0);
                $holidays_45 = $tr->find('*[class="app_api_tr_bottom_td_holidays_45"]', 0);

                $result[$i]['total'] = trim($total->plaintext);
                $result[$i]['daytime'] = trim($daytime->plaintext);
                $result[$i]['afterwork'] = trim($afterwork->plaintext);
                $result[$i]['night'] = trim($night->plaintext);
                $result[$i]['weekends'] = trim($weekends->plaintext);
                $result[$i]['holidays_90'] = trim($holidays_90->plaintext);
                $result[$i]['holidays_45'] = trim($holidays_45->plaintext);

                $i++;
            }
        }
        $sum_values = $this->sumValuesToFrontPageCalc($result, $user_id, $lang);
        
        return $sum_values;
    }
    
    public function prepareTotalsForCalcNewModule($html, $user_id, $lang) {
        
        require_once($_SERVER['DOCUMENT_ROOT'].'/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
        $dom = str_get_html($html);
        $q1  = $dom->find('.holidays-box');

        JLoader::register('AuditModelTime_Wages', JPATH_ROOT . '/components/com_audit/models/time_wages.php');
        $model_settings = JModelLegacy::getInstance('Time_Wages', 'AuditModel');
        
        
        $user = & JFactory::getUser($user_id);
        $sick_child_state=$model_settings->getSickChildStateAndConfig($user->owner_id);
        $sick_state = $model_settings->getSickState($user->owner_id);
        $date_of_hired = $user->work_start_timestamp;
        
        $result=[]; 
        
        foreach($q1 as $table){
            $q2 = $table->find('.pdf-35');
            $i=0;
            
            foreach ($q2 as $tr) {
                //$total = $tr->find('td[class="app_api_tr_bottom_td_total"]', 0);
                $daytime = $tr->find('.t-daytime', 0);
                $afterwork = $tr->find('.t-afterwork', 0);
                $night = $tr->find('.t-night_time', 0);
                $weekends = $tr->find('.t-weekend', 0);
                $holidays_90 = $tr->find('.t-holidays90', 0);
                $holidays_45 = $tr->find('.t-holidays45', 0);
                $sick = $tr->find('.t-holidays_sick', 0);
                $sick_child = $tr->find('.t-sick_child', 0);
                $breaks = $tr->find('.t-breaks', 0);
                $monthly_limit = $tr->find('.t-m_limit', 0);
                
                //$result[$i]['total'] = trim($total->plaintext);
                $result[$i]['daytime'] = trim($daytime->plaintext);
                $result[$i]['afterwork'] = trim($afterwork->plaintext);
                $result[$i]['night'] = trim($night->plaintext);
                $result[$i]['weekends'] = trim($weekends->plaintext);
                $result[$i]['holidays_90'] = trim($holidays_90->plaintext);
                $result[$i]['holidays_45'] = trim($holidays_45->plaintext);
                $result[$i]['sick'] = trim($sick->plaintext);
                $result[$i]['sick_child'] = trim($sick_child->plaintext);
                $result[$i]['breaks'] = trim($breaks->plaintext);
                $result[$i]['monthly_limit'] = trim($monthly_limit->plaintext);
                
                $result[$i]['date_of_hired'] = trim($date_of_hired);
                $i++;
            }
        }
        
        /*echo '<pre>$result';
        print_r($result);
        echo '</pre>';*/
        
        $sum_values = $this->sumValuesForNewCalcModule($result, $user_id, $lang);
        
        return $sum_values;
    }
    
    public function prepareTotalsForCalcNew($html, $user_id, $lang) {

        require_once($_SERVER['DOCUMENT_ROOT'] . '/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
        $dom = str_get_html($html);
        $q1 = $dom->find('table[class="pdf_not_width"]');

        JLoader::register('AuditModelTime_Wages', JPATH_ROOT . '/components/com_audit/models/time_wages.php');
        $model_settings = JModelLegacy::getInstance('Time_Wages', 'AuditModel');
        $user = & JFactory::getUser($user_id);
        $sick_child_state = $model_settings->getSickChildStateAndConfig($user->owner_id);
        $sick_state = $model_settings->getSickState($user->owner_id);

        $result = [];

        foreach ($q1 as $table) {
            $q2 = $table->find('tr[class="tr_bottom"]');
            $i = 0;

            foreach ($q2 as $tr) {
                $total = $tr->find('td[class="app_api_tr_bottom_td_total"]', 0);
                $daytime = $tr->find('td[class="app_api_tr_bottom_td_daytime"]', 0);
                $afterwork = $tr->find('td[class="app_api_tr_bottom_td_afterwork"]', 0);
                $night = $tr->find('td[class="app_api_tr_bottom_td_night"]', 0);
                $weekends = $tr->find('td[class="app_api_tr_bottom_td_weekends"]', 0);
                $holidays_90 = $tr->find('*[class="app_api_tr_bottom_td_holidays_90"]', 0);
                $holidays_45 = $tr->find('*[class="app_api_tr_bottom_td_holidays_45"]', 0);

                $result[$i]['total'] = trim($total->plaintext);
                $result[$i]['daytime'] = trim($daytime->plaintext);
                $result[$i]['afterwork'] = trim($afterwork->plaintext);
                $result[$i]['night'] = trim($night->plaintext);
                $result[$i]['weekends'] = trim($weekends->plaintext);
                $result[$i]['holidays_90'] = trim($holidays_90->plaintext);
                $result[$i]['holidays_45'] = trim($holidays_45->plaintext);

                $i++;
            }
        }
        $sum_values = $this->sumValuesToFrontPageCalcNew($result, $user_id, $lang);

        return $sum_values;
    }

    private function sumValuesToFrontPageCalcNew($result, $user_id, $lang)
    {
        $final = [];
        
        $total = $result[0]['total'];
        $daytime = $result[0]['daytime'];
        $afterwork = $result[0]['afterwork'];
        $night = $result[0]['night'];
        $weekends = $result[0]['weekends'];
        $holidays_90 = $result[0]['holidays_90'];
        $holidays_45 = $result[0]['holidays_45'];
        
        //$final['total'] = (float)$this->convertToFrontPageCalc1($total, $user_id, $lang);
       
        $total_h_sum = explode(':', $total)[0];
        $total_min_sum = explode(':', $total)[1];
        
        if($total_min_sum >= 60){
            $total_h_sum++;
            $total_min_sum-=60;      
        }
        $total_sum = $total_h_sum.'.'. $total_min_sum;
       
       
        //overtime1
        //$ov_h_sum_arr = explode(':', $afterwork)[0] + explode(':', $night)[0]  + explode(':', $weekends)[0];
        //$ov_h_min_arr = explode(':', $afterwork)[1] + explode(':', $night)[1]  + explode(':', $weekends)[1];
        $ov_h_sum_arr = explode(':', $afterwork)[0] + explode(':', $weekends)[0];
        $ov_h_min_arr = explode(':', $afterwork)[1] + explode(':', $weekends)[1];
        
        //overtime2
        $ov_h_sum_arr2 = explode(':', $night)[0];
        $ov_h_min_arr2 = explode(':', $night)[1];
        
        //overtime1
        if($ov_h_min_arr >= 60){
            $ov_h_sum_arr++;
            $ov_h_min_arr -= 60;      
        }
        //overtime2
        if($ov_h_min_arr2 >= 60){
            $ov_h_sum_arr2++;
            $ov_h_min_arr2 -= 60;      
        }
        
        $overwork1 = $ov_h_sum_arr.'.'.$ov_h_min_arr;
        $overwork2 = $ov_h_sum_arr2.'.'.$ov_h_min_arr2;

        $holidays_h_sum = explode(':', $holidays_90)[0] + explode(':', $holidays_45)[0];
        $holidays_m_sum = explode(':', $holidays_90)[1] + explode(':', $holidays_45)[1];
        if($holidays_m_sum >= 60){
            $holidays_h_sum++;
            $holidays_m_sum-=60;      
        }
        $holidays_sum = $holidays_h_sum.'.'.$holidays_m_sum;
        
        $daytime_h_sum = explode(':', $daytime)[0];
        $daytime_m_sum = explode(':', $daytime)[1];
        if($daytime_m_sum >= 60){
            $daytime_h_sum++;
            $daytime_m_sum-=60;      
        }
        $daytime_sum =$daytime_h_sum.'.'.$daytime_m_sum;
        
        $final['total'] =  (float)$total_sum;
        $final['daytime'] = (float)$daytime_sum;
        $final['overtime1'] = (float)$overwork1;
        $final['overtime2'] = (float)$overwork2;
        $final['holidays'] = (float)$holidays_sum;
        
        
        $final['not_converted']['total'] = $total;
        $final['not_converted']['daytime'] = $daytime;
        $final['not_converted']['afterwork'] = $afterwork;
        $final['not_converted']['night'] = $night;
        $final['not_converted']['weekends'] = $weekends;
        $final['not_converted']['holidays_90'] = $holidays_90;
        $final['not_converted']['holidays_45'] = $holidays_45;
        
        return $final;
    }
    
    private function sumValuesToFrontPageCalc($result, $user_id, $lang)
    {
        $final=[];
        
        $total = $result[0]['total'];
        $daytime = $result[0]['daytime'];
        $afterwork = $result[0]['afterwork'];
        $night = $result[0]['night'];
        $weekends = $result[0]['weekends'];
        $holidays_90 = $result[0]['holidays_90'];
        $holidays_45 = $result[0]['holidays_45'];
        
        //$final['total'] = (float)$this->convertToFrontPageCalc1($total, $user_id, $lang);
       
        $total_h_sum = explode(':', $total)[0];
        $total_min_sum = explode(':', $total)[1];
        
        if($total_min_sum >= 60){
            $total_h_sum++;
            $total_min_sum-=60;      
        }
        $total_sum = $total_h_sum.'.'. $total_min_sum;
       
       
        $ov_h_sum_arr = explode(':', $afterwork)[0] + explode(':', $night)[0]  + explode(':', $weekends)[0];
        $ov_h_min_arr = explode(':', $afterwork)[1] + explode(':', $night)[1]  + explode(':', $weekends)[1];
        
        if($ov_h_min_arr >= 60){
            $ov_h_sum_arr++;
            $ov_h_min_arr-=60;      
        }
        $overwork = $ov_h_sum_arr.'.'.$ov_h_min_arr;

        $holidays_h_sum = explode(':', $holidays_90)[0] + explode(':', $holidays_45)[0];
        $holidays_m_sum = explode(':', $holidays_90)[1] + explode(':', $holidays_45)[1];
        if($holidays_m_sum >= 60){
            $holidays_h_sum++;
            $holidays_m_sum-=60;      
        }
        $holidays_sum = $holidays_h_sum.'.'.$holidays_m_sum;
        
        $daytime_h_sum = explode(':', $daytime)[0];
        $daytime_m_sum = explode(':', $daytime)[1];
        if($daytime_m_sum >= 60){
            $daytime_h_sum++;
            $daytime_m_sum-=60;      
        }
        $daytime_sum = $daytime_h_sum.'.'.$daytime_m_sum;
        
        $final['total'] =  (float)$total_sum;
        $final['overwork'] = (float)$overwork;
        $final['holidays'] = (float)$holidays_sum;
        $final['daytime'] = (float)$daytime_sum;
        
        $final['not_converted']['total'] = $total;
        $final['not_converted']['daytime'] = $daytime;
        $final['not_converted']['afterwork'] = $afterwork;
        $final['not_converted']['night'] = $night;
        $final['not_converted']['weekends'] = $weekends;
        $final['not_converted']['holidays_90'] = $holidays_90;
        $final['not_converted']['holidays_45'] = $holidays_45;
        
      
        
        return $final;
    }
    
    private function sumValuesForNewCalcModule($result, $user_id, $lang)
    {
        $final = [];
        
        $total = $result[0]['total'];
        $daytime = $result[0]['daytime'];
        $afterwork = $result[0]['afterwork'];
        $night = $result[0]['night'];
        $weekends = $result[0]['weekends'];
        $holidays_90 = $result[0]['holidays_90'];
        $holidays_45 = $result[0]['holidays_45'];
        $sick = $result[0]['sick'];
        $sick_child = $result[0]['sick_child'];
        $breaks = $result[0]['breaks'];
        $monthly_limit = $result[0]['monthly_limit'];
        
        $total_h_sum = explode(':', $total)[0];
        $total_min_sum = explode(':', $total)[1];
        
        if($total_min_sum >= 60){
            $total_h_sum++;
            $total_min_sum-=60;      
        }
        $total_sum = $total_h_sum.'.'. $total_min_sum;
       
       
        $ov_h_sum_arr = explode(':', $afterwork)[0] + explode(':', $night)[0]  + explode(':', $weekends)[0];
        $ov_h_min_arr = explode(':', $afterwork)[1] + explode(':', $night)[1]  + explode(':', $weekends)[1];
        
        if($ov_h_min_arr >= 60){
            $ov_h_sum_arr++;
            $ov_h_min_arr-=60;      
        }
        $overwork = $ov_h_sum_arr.'.'.$ov_h_min_arr;

        $holidays_h_sum = explode(':', $holidays_90)[0] + explode(':', $holidays_45)[0];
        $holidays_m_sum = explode(':', $holidays_90)[1] + explode(':', $holidays_45)[1];
        if($holidays_m_sum >= 60){
            $holidays_h_sum++;
            $holidays_m_sum-=60;      
        }
        $holidays_sum = $holidays_h_sum.'.'.$holidays_m_sum;
        
        $daytime_h_sum = explode(':', $daytime)[0];
        $daytime_m_sum = explode(':', $daytime)[1];
        if($daytime_m_sum >= 60){
            $daytime_h_sum++;
            $daytime_m_sum-=60;      
        }
        $daytime_sum = $daytime_h_sum . '.' . $daytime_m_sum;
        
        ///new
        $holidays_45h_sum = explode(':', $holidays_45)[0];
        $holidays_45m_sum = explode(':', $holidays_45)[1];
        if($holidays_45m_sum >= 60){
            $holidays_45h_sum++;
            $holidays_45m_sum -= 60;      
        }
        $holidays_45sum = $holidays_45h_sum . '.' . $holidays_45m_sum;
        
        $holidays_90h_sum = explode(':', $holidays_90)[0];
        $holidays_90m_sum = explode(':', $holidays_90)[1];
        if($holidays_90m_sum >= 60){
            $holidays_90h_sum++;
            $holidays_90m_sum -= 60;      
        }
        $holidays_90sum = $holidays_90h_sum . '.' . $holidays_90m_sum;
        
        
        $afterwork_h_sum = explode(':', $afterwork)[0];
        $afterwork_m_sum = explode(':', $afterwork)[1];
        if($afterwork_m_sum >= 60){
            $afterwork_h_sum++;
            $afterwork_m_sum -= 60;      
        }
        $afterwork_sum = $afterwork_h_sum . '.' . $afterwork_m_sum;
        
        $sick_h_sum = explode(':', $sick)[0];
        $sick_m_sum = explode(':', $sick)[1];
        if($sick_m_sum >= 60){
            $sick_h_sum++;
            $sick_m_sum -= 60;      
        }
        $sick_sum = $sick_h_sum . '.' . $sick_m_sum;
        
        $sick_child_h_sum = explode(':', $sick_child)[0];
        $sick_child_m_sum = explode(':', $sick_child)[1];
        if($sick_child_m_sum >= 60){
            $sick_child_h_sum++;
            $sick_child_m_sum -= 60;      
        }
        $sick_child_sum = $sick_child_h_sum . '.' . $sick_child_m_sum;
        
        $breaks_h_sum = explode(':', $breaks)[0];
        $breaks_m_sum = explode(':', $breaks)[1];
        if($breaks_m_sum >= 60){
            $breaks_h_sum++;
            $breaks_m_sum -= 60;      
        }
        $breaks_sum = $breaks_h_sum . '.' . $breaks_m_sum;
        
        $monthly_limit_h_sum = explode(':', $monthly_limit)[0];
        $monthly_limit_m_sum = explode(':', $monthly_limit)[1];
        if($breaks_m_sum >= 60){
            $monthly_limit_h_sum++;
            $monthly_limit_m_sum -= 60;      
        }
        $monthly_limit_sum = $monthly_limit_h_sum . '.' . $monthly_limit_m_sum;
        
        $night_h_sum = explode(':', $night)[0];
        $night_m_sum = explode(':', $night)[1];
        if($night_m_sum >= 60){
            $night_h_sum++;
            $night_m_sum -= 60;      
        }
        $night_sum = $night_h_sum . '.' . $night_m_sum;
        
        
        
        $weekends_h_sum = explode(':', $weekends)[0];
        $weekends_m_sum = explode(':', $weekends)[1];
        if($weekends_m_sum >= 60){
            $weekends_h_sum++;
            $weekends_m_sum -= 60;      
        }
        $weekends_sum = $weekends_h_sum . '.' . $weekends_m_sum;
        
        //end new
        
        $final['total'] =  (float)$total_sum;
        $final['overwork'] = (float)$overwork;
        $final['holidays'] = (float)$holidays_sum;
        $final['daytime'] = (float)$daytime_sum;
        $final['holidays_45'] = (float)$holidays_45sum;
        $final['holidays_90'] = (float)$holidays_90sum;
        $final['after_work'] = (float)$afterwork_sum;
        $final['sick'] = (float)$sick_sum;
        $final['sick_child'] = (float)$sick_child_sum;
        $final['breaks'] = (float)$breaks_sum;
        $final['monthly_limit'] = (float)$monthly_limit_sum;
        $final['date_of_hired'] = $result[0]['date_of_hired'];
        $final['night'] = (float)$night_sum;
        $final['weekends'] = (float)$weekends;
        
        return $final;
    }
    
    /*private function convertTime($dec)
{
    // start by converting to seconds
    $seconds = ($dec * 3600);
    // we're given hours, so let's get those the easy way
    $hours = floor($dec);
    // since we've "calculated" hours, let's remove them from the seconds variable
    $seconds -= $hours * 3600;
    // calculate minutes left
    $minutes = floor($seconds / 60);
    // remove those from seconds as well
    $seconds -= $minutes * 60;
    // return the time formatted HH:MM:SS
    return $this->lz($hours).":".$this->lz($minutes).":".$this->lz($seconds);
}

private function lz($num)
{
    return (strlen($num) < 2) ? "0{$num}" : $num;
}*/


    private function convertToFrontPageCalc1($result)
    {
        return date('H.i', strtotime($result));
    }
    
    private function convertToFrontPageCalc($result, $user_id, $lang)
    {
        $val_arr = explode(':', $result);
        
        $hours = $val_arr[0];
        $min = $val_arr[1];
       
        
        $sec = $hours*60*60 + $min*60;
        $minutes =  floor($sec / 60);
        
        $hours = floor($minutes / 60); // Считаем количество полных часов
	$minutes = $minutes - ($hours * 60);  // Считаем количество оставшихся минут

	$final = $hours.'.'.$minutes; // Получаем время 1:40
       
        //$final = $this->calcHoursOtherFormat($hours, $min, 0, 0);
        
        return $final;
    }
    
    private function calcHoursOtherFormat($total_h, $total_m, $limit = 0, $echo = 1) {
        $h = @$total_h * 3600;
        $m = @$total_m * 60;
        $s = $h + $m;

        $hour = floor($s / 3600);
        //echo '$hour'.$hour;
        
        $sec = $s - ($hour * 3600);
        $min = ($sec / 60);
        //echo '$min'.$min;
        
        $sec = $sec - ($min * 60);

        if ($min < 10) {
            $min = '0' . $min;
        }

        if ($hour >= 8 && $limit != 0) {
            if ($echo == 1) {
                echo "08:00";
            } else {
                return "08:00";
            }
        } else {
            if ($echo == 1) {  
                if ($hour == '0' && $min == '00') {
                    echo '0';
                } else {
                    echo $hour . "." . $min;
                }
            } else {
                if ($hour == '0' && $min == '00') {
                    return '0';
                } else {
                    return $hour . "." . $min;
                }
            }
        }
    }
    
    function convertTimeToMin($time) {
    if(empty($time)){
        return 0;
    }
    
    $time_minutes_arr = explode(':', $time);
    $minutes = $time_minutes_arr[0] * 60 + $time_minutes_arr[1];  
    
    return $minutes;
}

    public function calcEarnedIncomeTotals($rows, $not_permitted_field_array)
    {
        if(!empty($rows) && !empty($not_permitted_field_array)){
            $totals = []; 
            $i = 0;
            
            foreach($rows as $one_row){
                $row_pay_period = json_decode($one_row->period);
                
                foreach ($one_row as $k => $v) {
                    if (!in_array($k, $not_permitted_field_array)) {
                        $totals[$i][$k] = $totals[$i - 1][$k] + $v;
                    }
                }
                $i++;
            }
            
            return $totals;
        }
    }
    
    public function calcEarnedIncomeTotalsNewModule($rows, $not_permitted_field_array)
    {
        if(!empty($rows) && !empty($not_permitted_field_array)){
            $totals = []; 
            $i = 0;
            
           
            foreach($rows[0] as $k=>$v){
                if (!in_array($k, $not_permitted_field_array)) {
                    $totals[$k] = array_sum(array_column($rows, $k));
                }
            }
            
            return $totals;
        }
    }
    
    /*private function toFixed($num, $decimals)
    {
        $number = $num;
        $expo = pow(10, $decimals);
        $number = intval($number*$expo)/$expo; 
        echo $number;
        
        return $number;
    }*/
    
    public function FloatToStrCalc($a)
    {
        //setlocale(LC_NUMERIC, 'is_IS');
        return $a;
    }
    
    public function loadEarnedIncomeTable($convert_from, $user, $lang, $type = null)
    {
        $not_permitted_field_array = AuditController::getNotPermittedEarnedIncomeKeys();
        $this->all_items_user = $this->getAllEarnedIncomeRecords2($convert_from, $user);
        $this->totals = $this->calcEarnedIncomeTotals($this->all_items_user, $not_permitted_field_array);
        $this->count_totals = count($this->totals);
        
        ob_start();
        /*echo '<pre>';
        print_r($_REQUEST);
        echo '</pre>';*/
        if(!empty($this->all_items_user)){?>
            <table class="table_earned_income">
                <tbody>
                    <tr class="tr_calc_header">
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_MONTH') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PENSION_EMPLOYED') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PRIVATE_PENS') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_COMPANY_PENS') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_COMPANY_PRIVATE_PENS') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_INSURARCE') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_UNION') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_C_UNION') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_HOLIDAY') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_INCOME_MUNIC_TAX') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PERSONAL_TASK') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_SALARIES') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TAKE_HOME_PAY') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TOTAL_COST') ?></td>
                        <td></td>
                        <td></td>
                    </tr> 
                    <?php $i=0; foreach($this->all_items_user as $one_row){?>
                        <tr>
                            <?php
                                $row_pay_period = json_decode($one_row->period); 
                                $from = date('d.m.Y', strtotime($row_pay_period->from));
                                $to = date('d.m.Y', strtotime($row_pay_period->to));
                            ?>
                                <td><?=$from.' - '.$to?></td>
                                <?php foreach($one_row as $k=>$v){?>
                                    <?php if(!in_array($k, $not_permitted_field_array)){?>
                                        <td class="js_event_td_calc"><?=$this->floatToStrCalcTrue($v)?></td>
                                    <?php } ?>                                  
                                <?php
                                    } 
                                    $calc_link = '/calc';
                                    if($type == 'new_psd'){
                                        $calc_link = '/calc-new';
                                    }
                                ?>
                                <td class="earned_income_plus"><a href="<?=$calc_link?>?u_id=<?=$user->id?>&ein_id=<?=$one_row->id?>&from_p=<?=$from?>&to_p=<?=$to?>"><i class="fa fa-plus" aria-hidden="true"></i></a></td>
                                <td><div class="delete_table_row" id="row_id-<?=$one_row->id?>"><i class="fa fa-window-close" aria-hidden="true"></i></div></td>
                        </tr>
                        <?php $i++; } ?>
                        <tr>
                            <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TOTAL') ?></td>
                            <?php foreach($this->totals[$this->count_totals-1] as $k=>$v){?>
                                <td class="js_event_td_earned_income_total"><?=$this->floatToStrCalcTrue($v)?></td>
                            <?php } ?>
                            <td></td>
                            <td></td>
                        </tr>
                </tbody>
            </table>
            <?php
        } else{?> 
            <div class="alert alert-info alert-custom-0">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <div class="alert_info">
                    <?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_NO_DATA') ?>   
                </div>
            </div>
        <?php }
        $html=ob_get_contents();
          
        ob_end_clean(); 
        return $html;
    }
    
    public function loadEarnedIncomeTableDefault($convert_from, $user, $lang, $type = null)
    {
        $not_permitted_field_array = AuditController::getNotPermittedEarnedIncomeKeys();
        $this->all_items_user = $this->getAllEarnedIncomeRecords(0, $user);
        $this->totals = $this->calcEarnedIncomeTotals($this->all_items_user, $not_permitted_field_array);
        $this->count_totals = count($this->totals);
        
        ob_start();
        if(!empty($this->all_items_user)){?>
            <table class="table_earned_income">
                <tbody>
                    <tr class="tr_calc_header">
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_MONTH') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PENSION_EMPLOYED') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PRIVATE_PENS') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_COMPANY_PENS') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_COMPANY_PRIVATE_PENS') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_INSURARCE') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_UNION') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_C_UNION') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_HOLIDAY') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_INCOME_MUNIC_TAX') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PERSONAL_TASK') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_SALARIES') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TAKE_HOME_PAY') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TOTAL_COST') ?></td>
                        <td></td>
                        <td></td>
                    </tr> 
                    <?php $i=0; foreach($this->all_items_user as $one_row){?>
                        <tr>
                           <?php
                                $row_pay_period = json_decode($one_row->period); 
                                $from = date('d.m.Y', strtotime($row_pay_period->from));
                                $to = date('d.m.Y', strtotime($row_pay_period->to));
                            ?>
                                <td><?=$from.' - '.$to?></td>
                                <?php foreach($one_row as $k=>$v){?>
                                    <?php if(!in_array($k, $not_permitted_field_array)){?>
                                        <td class="js_event_td_calc"><?=$this->floatToStrCalcTrue($v)?></td>
                                    <?php } ?>                                  
                                <?php
                                    } 
                                    $calc_link = '/calc';
                                    if($type == 'new_psd'){
                                        $calc_link = '/calc-new';
                                    }
                                ?>
                                <td class="earned_income_plus"><a href="<?=$calc_link?>?u_id=<?=$user->id?>&ein_id=<?=$one_row->id?>&from_p=<?=$from?>&to_p=<?=$to?>"><i class="fa fa-plus" aria-hidden="true"></i></a></td>
                                <td><div class="delete_table_row" id="row_id-<?=$one_row->id?>"><i class="fa fa-window-close" aria-hidden="true"></i></div></td>
                        </tr>
                        <?php $i++; } ?>
                        <tr>
                            <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TOTAL') ?></td>
                            <?php foreach($this->totals[$this->count_totals-1] as $k=>$v){?>
                                <td class="js_event_td_earned_income_total"><?=$this->floatToStrCalcTrue($v)?></td>
                            <?php } ?>
                            <td></td>
                            <td></td>
                        </tr>
                </tbody>
            </table>
            <?php
        } else{?> 
            <div class="alert alert-info alert-custom-0">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <div class="alert_info">
                    <?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_NO_DATA') ?>   
                </div>
            </div>
        <?php }
        $html=ob_get_contents();
          
        ob_end_clean(); 
        return $html;
    }
    
    public function getAllEarnedIncomeRecords2($from_to_arr, $user) 
    {
        $from_timestamp = strtotime($from_to_arr['from']);
        //$to_timestamp = strtotime($from_to_arr['to']);
        $next_year_to_timestamp = date('U', strtotime($from_to_arr['from'].' +1year -1day'));
        
        //echo date('d.m.Y', $next_year_to_timestamp);

        $query = "SELECT * FROM #__calculator_earning_income WHERE `user_id` = '$user->id' ORDER BY `id` ASC";
        //$query = "SELECT * FROM #__calculator_earning_income WHERE `user_id` = '$user->id' AND JSON_VALUE(`period`, '$.from') = '".$from_to_arr['from']."' AND JSON_VALUE(`period`, '$.to') = '".$from_to_arr['to']."' ORDER BY `id` ASC";
        //$query = "SELECT * FROM #__calculator_earning_income WHERE `user_id` = '$user->id' AND UNIX_TIMESTAMP(JSON_VALUE(`period`, '$.from')+' 00:00:00') >= '".$from_timestamp."' AND UNIX_TIMESTAMP(JSON_VALUE(`period`, '$.to')+' 00:00:00') <= '".$next_year_to_timestamp."' ORDER BY `id` ASC";
       
        //echo $query;
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        $final=[];
        
        foreach($data as $one_row){
            $row_pay_period = json_decode($one_row->period);    
           
            $row_from_stamp = strtotime($row_pay_period->from);
            $row_to_stamp = strtotime($row_pay_period->to);
            
            //echo '$from_timestamp '.date('d.m.Y H:i:s', $from_timestamp).' $row_from_stamp '.date('d.m.Y H:i:s', $row_from_stamp).' $row_to_stamp '.date('d.m.Y H:i:s', $row_to_stamp).' $next_year_to_timestamp '.date('d.m.Y H:i:s', $next_year_to_timestamp).PHP_EOL;
            if($from_timestamp <= $row_from_stamp && $row_to_stamp <= $next_year_to_timestamp){
                $final[] = $one_row;
            }
        }
 
        return $final;        
    }
    
    public function convertPayPeriodFromTo($pay_period)
    {
        $date_arr=[];
        
        
        if(!empty($pay_period)){
            $date_to_modify = date('Y-m-d', strtotime($pay_period['to'].' +1year'));
            
            $dateArr_from = explode("-", $pay_period['from']);
            $dateArr_to = explode("-", $date_to_modify);
            
            
            $date_arr['from'] = $dateArr_from[2].".".$dateArr_from[1].".".$dateArr_from[0];
            $date_arr['to'] = $dateArr_to[2].".".$dateArr_to[1].".".$dateArr_to[0];
        }
        
        return $date_arr;
    }
    
    public function convertPayPeriodFromTo4($pay_period)
    {
        $date_arr=[];
        
        
        if(!empty($pay_period)){
            //$date_to_modify = date('Y-m-d', strtotime($pay_period['to'].' +1year'));
            
            $dateArr_from = explode("-", $pay_period['from']);
            $dateArr_to = explode("-", $pay_period['to']);
            
            
            $date_arr['from'] = $dateArr_from[2].".".$dateArr_from[1].".".$dateArr_from[0];
            $date_arr['to'] = $dateArr_to[2].".".$dateArr_to[1].".".$dateArr_to[0];
        }
        
        return $date_arr;
    }
    
    public function checkPermission($type, $individual_params)
    {
        $res='0';
        
        
        $downloadPdf        =   intval(JRequest::getVar('download-pdf',0));
        $authHash           =   trim(JRequest::getVar('authHash',""));

        if($downloadPdf && strlen($authHash) > 3) {
            $res='1';
            return $res;
        }
        
        switch($type){
            case 'delete':
                $user = $individual_params['user_obj'];
                $id = $individual_params['id'];
                
                $manager = JFactory::getUser($user->owner_id);

                $query = "SELECT * FROM #__calculator_earning_income WHERE `user_id` = '$user->id' AND `id` = '$id' ORDER BY `id` ASC";
                $this->db->setQuery($query);
                $data = $this->db->loadObject();
        
                if($manager->id === $user->owner_id && count($data)>0){
                    $res = '1';
                }
            break;
            case 'saving_user_selection':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();
            
                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                }
               
            break;
            case 'getting_earned_income_row':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();
                
                /*$query = "SELECT `id`, `user_id` FROM #__calculator_earning_income WHERE `id` = '".$individual_params["row_id"]."' AND `user_id` = '$user->id'";     
                $this->db->setQuery($query);
                $records = $this->db->loadObjectList();*/
            
                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 /*&& $records[0]->id == $individual_params["row_id"]*/){
                    $res = '1';
                }
               
            break;
            case 'saveEIPeriod':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                } 
            break;
            case 'createCsvEarnedIncome':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                } 
            break;
            case 'openCalcPage':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                } 
            break;
            case 'openEIPage':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                } 
            break;
            case 'createExcelEarnedIncome':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                $config = &JFactory::getConfig();
                $enable_excel_button_in_ei_page = $config->get('enable_excel_button_in_ei_page');
        
                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 && $enable_excel_button_in_ei_page == '1'){
                    $res = '1';
                } 
            break;
            case 'getFieldsForRelationWithPayPeriod':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                $config = &JFactory::getConfig();
                $mod_calc_load_type = $config->get('mod_calc_load_type');
        
                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 && $mod_calc_load_type == '1'){
                    $res = '1';
                } 
            break;
            case 'storeFieldRelationWithCalc':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                $config = &JFactory::getConfig();
                $mod_calc_load_type = $config->get('mod_calc_load_type');
        
                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 && $mod_calc_load_type == '1'){
                    $res = '1';
                } 
            break;
            case 'deleteNew':
                $user = $individual_params['user_obj'];
                $id = $individual_params['id'];
                
                $manager = JFactory::getUser($user->owner_id);

                $query = "SELECT * FROM " . $this->db->quoteName($this->eincome_new_module_table) . " WHERE `user_id` = '$user->id' AND `id` = '$id' ORDER BY `id` ASC";
                $this->db->setQuery($query);
                $data = $this->db->loadObject();
        
                if($manager->id === $user->owner_id && count($data)>0){
                    $res = '1';
                }
            break;
        }
      
       
       return $res;
    }
    
    public function deleteEarnIncomeRow($row_id)
    {
        $row_id=(int)$row_id;
        $query="DELETE FROM `#__calculator_earning_income` WHERE `id` = '$row_id';";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    private function saveUserSelectionInCookie($saveType, $special_params, $user)
    {
        $app = JFactory::getApplication();
        $item = new stdClass();
        
        switch($saveType){
            case 'first_page_union':
                $item->first_page_union_val = $this->db->escape($special_params['data_attr']);
                $item->first_page_union_type = $this->db->escape($special_params['type']);
                $item->union0 = (int)$special_params['union'];
            break;
            case 'second_page':   
                $item->contract = $this->db->escape($special_params['contract']);
                $item->page5select = $this->db->escape($special_params['page5select']);
                $item->subcontract = $this->db->escape($special_params['subcontract']);
                $item->salaries = $this->db->escape($special_params['salaries']);  
            break;    
            case 'third_page_autocomplete':
                $item->page5select = $this->db->escape($special_params['page5select']);
                $item->params = json_encode($special_params['params']);
            break;
            case 'fourth_page':
                $item->age = $this->db->escape($special_params['age']);
                $item->hours300 = $this->db->escape($special_params['hours300']);
            break;
            case 'fourth_page_standart':
                $item->checkbox_value = $this->db->escape($special_params['checkbox_value']);
                $item->type = $this->db->escape($special_params['type']);
            break;
            
        }
        
        foreach($item as $k=>$v){
            // Set the cookie
            $value = $v;
            $time = strtotime('now + 1year'); // 1 week
            $app->input->cookie->set($k, $value, $time, $app->get('cookie_path', '/'), $app->get('cookie_domain'), $app->isSSLConnection());
        }
        
    }
    
    public function saveUserSelection($saveType, $special_params, $user)
    {       
        /*ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);*/

        $calculator_run_saves = [
            'third_page_new_contract',
            'third_page',
            'fifth_page_standart'
        ];
        
        if(!in_array($saveType, $calculator_run_saves)){
           $table = '#__calculator_saves_temp';
        } else{
           $table = '#__calculator_saves';
        }
        
        $item = new stdClass();
        $type = 'update';
                
        $query = "SELECT * FROM $table WHERE `user_id` = '$user->id'";     
        $this->db->setQuery($query);
        $saves = $this->db->loadObjectList();
                
        if(count($saves) === 0){
            $type = 'insert';
            $item->id = null;
        } elseif(count($saves) === 1){
            $item->id = $saves[0]->id;
        } else{
            throw new Exception('Error saving user selection: There are more than 1 records in the database per current user. It is unacceptable!');
        }
                
        $item->user_id = $user->id;
                
        $not_permitted_copy_array = [
            'id',
            'user_id',
            'timestamp_create',
            'date_create',
            'last_revision_timestamp',
            'last_revision_date'
        ];
        switch($saveType){
            case 'first_page_union':
                $item->first_page_union_val = $this->db->escape($special_params['data_attr']);
                $item->first_page_union_type = $this->db->escape($special_params['type']);
                $item->union0 = (int)$special_params['union'];
            break;
            case 'second_page':   
                $item->contract = $this->db->escape($special_params['contract']);
                $item->page5select = $this->db->escape($special_params['page5select']);
                $item->subcontract = $this->db->escape($special_params['subcontract']);
                $item->salaries = $this->db->escape($special_params['salaries']);  
            break;
            case 'third_page':   
                $query = "SELECT * FROM #__calculator_saves_temp WHERE `user_id` = '$user->id'";     
                $this->db->setQuery($query);
                $saves_temp = $this->db->loadObjectList();
                
                
                $query = "SELECT * FROM #__calculator_saves WHERE `user_id` = '$user->id'";     
                $this->db->setQuery($query);
                $saves_basic = $this->db->loadObjectList();
                
                unset($item);
                $item = new stdClass();
                
                if(count($saves_basic) === 0){
                    $type = 'insert';
                    $item->id = null;
                } elseif(count($saves_basic) === 1){
                    $item->id = $saves_basic[0]->id;
                } else{
                    throw new Exception('Error saving user selection: There are more than 1 records in the database per current user. It is unacceptable!');
                }
        
               
                //set basic calculator saves from temp calc saves
                foreach($saves_temp[0] as $k=>$v){
                    $item->user_id = $user->id;
                    
                    if(!in_array($k, $not_permitted_copy_array)){
                        $item->$k = $v;
                    }
                }
                
                //add new field to basic save
                $item->typecalc = $this->db->escape($special_params['typecalc']);
                $item->newowertime = $this->db->escape($special_params['newowertime']);
                $item->page2input3 = $this->db->escape($special_params['page2input3']);
                $item->page2input4 = $this->db->escape($special_params['page2input4']);
                $item->page3input2 = $this->db->escape($special_params['page3input2']); 
                $item->page3input3 = $this->db->escape($special_params['page3input3']); 
                $item->salaries = $this->db->escape($special_params['salaries']);  
                $item->union0 = (int)$special_params['union'];
                $item->module = $this->db->escape($special_params['module']);
                $item->calculator = $this->db->escape($special_params['calculator']);
            break;
            case 'third_page_autocomplete':
                $item->page5select = $this->db->escape($special_params['page5select']);
                $item->params = json_encode($special_params['params']);
            break;
            case 'fourth_page':
                $item->age = $this->db->escape($special_params['age']);
                $item->hours300 = $this->db->escape($special_params['hours300']);
            break;
            case 'third_page_new_contract':   
                $query = "SELECT * FROM #__calculator_saves_temp WHERE `user_id` = '$user->id'";     
                $this->db->setQuery($query);
                $saves_temp = $this->db->loadObjectList();
                
                
                $query = "SELECT * FROM #__calculator_saves WHERE `user_id` = '$user->id'";     
                $this->db->setQuery($query);
                $saves_basic = $this->db->loadObjectList();
                
                unset($item);
                $item = new stdClass();
                
                if(count($saves_basic) === 0){
                    $type = 'insert';
                    $item->id = null;
                } elseif(count($saves_basic) === 1){
                    $item->id = $saves_basic[0]->id;
                } else{
                    throw new Exception('Error saving user selection: There are more than 1 records in the database per current user. It is unacceptable!');
                }
        
               
                //set basic calculator saves from temp calc saves
                foreach($saves_temp[0] as $k=>$v){
                    $item->user_id = $user->id;
                    
                    if(!in_array($k, $not_permitted_copy_array)){
                        $item->$k = $v;
                    }
                }
                
                //add new field to basic save
                $item->hpm = $this->db->escape($special_params['hpm']);
                $item->salaries = $this->db->escape($special_params['salaries']);  
                $item->title = $this->db->escape($special_params['title']);
                $item->starfsaldur = $this->db->escape($special_params['starfsaldur']);
                $item->birthday = $this->db->escape($special_params['birthday']);
                $item->contract = $this->db->escape($special_params['contract']);
                $item->union0 = (int)$special_params['union'];
                $item->module = $this->db->escape($special_params['module']);
            break;
            case 'fourth_page_standart':
                $item->checkbox_value = $this->db->escape($special_params['checkbox_value']);
                $item->type = $this->db->escape($special_params['type']);
            break;
            case 'fifth_page_standart':  
                $query = "SELECT * FROM #__calculator_saves_temp WHERE `user_id` = '$user->id'";     
                $this->db->setQuery($query);
                $saves_temp = $this->db->loadObjectList();
                
                
                $query = "SELECT * FROM #__calculator_saves WHERE `user_id` = '$user->id'";     
                $this->db->setQuery($query);
                $saves_basic = $this->db->loadObjectList();
                
                unset($item);
                $item = new stdClass();
                
                if(count($saves_basic) === 0){
                    $type = 'insert';
                    $item->id = null;
                } elseif(count($saves_basic) === 1){
                    $item->id = $saves_basic[0]->id;
                } else{
                    throw new Exception('Error saving user selection: There are more than 1 records in the database per current user. It is unacceptable!');
                }
        
               
                //set basic calculator saves from temp calc saves
                foreach($saves_temp[0] as $k=>$v){
                    $item->user_id = $user->id;
                    
                    if(!in_array($k, $not_permitted_copy_array)){
                        $item->$k = $v;
                    }
                }
                
                //add new field to basic save
                $item->hpm = $this->db->escape($special_params['hpm']);
                $item->salaries = $this->db->escape($special_params['salaries']);  
                $item->title = $this->db->escape($special_params['title']);     
                $item->birthday = $this->db->escape($special_params['birthday']);
                $item->contract = $this->db->escape($special_params['contract']);
                $item->union0 = (int)$special_params['union'];
                $item->module = $this->db->escape($special_params['module']);
            break;
        }
        
        $time = time();
        $date = date('d.m.Y H:i:s');
                

        if($type=='insert'){
            $item->timestamp_create = $time;
            $item->date_create = $date;
            $this->db->insertObject( $table, $item, 'id' );
        } else{
            $item->last_revision_timestamp = $time;
            $item->last_revision_date = $date;
            $this->db->updateObject( $table, $item, 'id' );
        }
    }
    
    public function loadCurrentUserSave($user)
    {
        $query = "SELECT * FROM #__calculator_saves WHERE `user_id` = '$user->id'";     
        $this->db->setQuery($query);
        $save = $this->db->loadObject();
        
        return $save;
    }
    
    public function loadCurrentUserSaveApi($user)
    {
        $query = "SELECT * FROM #__calculator_saves WHERE `user_id` = '$user->id'";     
        $this->db->setQuery($query);
        $save = $this->db->loadObject();
        
        return $save;
    }
    
    public function convertPayPeriodFromTo2($pay_period)
    {
        $date_arr=[];
        
        
        if(!empty($pay_period)){
            $date_to_modify = date('Y-m-d', strtotime($pay_period['to'].' +1year'));
            
            $dateArr_from = explode("-", $pay_period['from']);
            $dateArr_to = explode("-", $date_to_modify);
            
            
            $date_arr['from'] = $dateArr_from[0]."-".$dateArr_from[1]."-".$dateArr_from[2];
            $date_arr['to'] = $dateArr_to[0]."-".$dateArr_to[1]."-".$dateArr_to[2];
        }
        
        return $date_arr;
    }
    
    public function loadEarnedIncomeRecord($row_id, $user, $lang)
    {
        $query = "SELECT * FROM #__calculator_earning_income WHERE `id` = '".$row_id."' AND `user_id` = '$user->id'";     
        $this->db->setQuery($query);
        $records = $this->db->loadObjectList();
        
        if(count($records) === 0){
           throw new Exception('Error loading earned income data to calculator: record was deleted from database while it was being opened!');
        } elseif(count($records) === 1){
          return $records[0];
        } else{
           throw new Exception('Error loading earned income data to calculator: There is more than one entry per user in the database!');
        }
    }
    
    public function saveEIPeriod($period, $user, $lang)
    {
        $table = '#__earned_income_period_saves';
        
        $query = "SELECT * FROM $table WHERE `user_id` = '$user->id'";     
        $this->db->setQuery($query);
        $saves = $this->db->loadObjectList();
	
        $item = new stdClass();
	if(count($saves) === 0){
            $type = 'insert';
            $item->id = null;
        } elseif(count($saves) === 1){
            $item->id = $saves[0]->id;
        } else{
            throw new Exception(JText::_('COM_AUDIT_EARNED_INCOME_SAVE_EI_PERIOD_ERROR_DB_COUNT_SAVES'));
        }
         
        $item->user_id = $user->id;
        $item->period = $this->convertPayPeriodFromTo3($period);
        
        if($type=='insert'){
            $this->db->insertObject( $table, $item, 'id' );
        } else{          
            $this->db->updateObject( $table, $item, 'id' );
        }
    }
    
    private function convertPayPeriodFromTo3($period)
    {
        $arr = explode('.', $period);
        return '-'.$arr[1].'-'.$arr[0];
    }
    
    public function loadEIPeriod($user_obj)
    {
        $table = '#__earned_income_period_saves';
        
        $query = "SELECT * FROM $table WHERE `user_id` = '$user_obj->id'";     
        $this->db->setQuery($query);
        $saves = $this->db->loadAssocList();

	if(count($saves) === 0){
            return [];
        } elseif(count($saves) === 1){
           
        } else{
            throw new Exception(JText::_('COM_AUDIT_EARNED_INCOME_LOAD_EI_PERIOD_ERROR_DB_COUNT_SAVES'));
        }
        
        //$to_arr = explode('-', $pay_period);
        $from = date('Y').$saves[0]['period'];
        
        $final = [
            'from'=>$from,
            'to'=>date('Y-m-d', strtotime($from.'+1year +1month -1day'))
        ];
        
        return $final;
    }
    
    public function getNextUser($current_user_id, $lang)
    {
        JLoader::register('AuditModelRegistered_Users', JPATH_ROOT . '/components/com_audit/models/registered_users.php');
        $model_reg = JModelLegacy::getInstance('Registered_Users', 'AuditModel');
        $users_list=$model_reg->getRegistredUser();
        $user_list_ids=[];
        
        //remove hide users
        foreach($users_list as $one_user){
            if($one_user->is_hide==0){
                $user_list_ids[]=$one_user;
            }
        }
        
        $next_user=[];
        $i=0;
        foreach($user_list_ids as $one_filter_user){
            if($one_filter_user->id==$current_user_id){
                $next_user=$user_list_ids[$i+1];
               
            }
            $i++;
        }
     
        
        if($lang == 'is'){
            $lang_prefix = 'is';
        } 
        if(!empty($next_user->id)){
            if( $lang_prefix == 'is'){
                $link='https://'.$_SERVER['SERVER_NAME'].'/'.$lang_prefix.'/calc?u_id='.$next_user->id.'&show=true';
            } else{
                $link='https://'.$_SERVER['SERVER_NAME'].'/calc?u_id='.$next_user->id.'&show=true';
            }
            
        } else{
            $link='javascript:void(0);';
        }
        
        return $link;
    }
    
    public function createCsvEarnedIncome($period, $user, $lang, $get_all_mode)
    { 
        /*ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);*/

        if($get_all_mode == 0){
            $all_items_user = $this->getAllEarnedIncomeRecords2((array)$period, $user);
        } else{
            $all_items_user = $this->getAllEarnedIncomeRecords(0, $user);
        }
            
        if(empty($all_items_user)){
            throw new Exception(JText::_('COM_AUDIT_EARNED_INCOME_CREATE_CSV_ERROR_EMPTY_DATA'));
        }
        
        $filename = 'earned_income_export-' . time() . '.csv';
        jimport( 'joomla.filesystem.folder');
            
        $folder = 'tmp_ei_csv';
        $ind_folder = 'individual';
        $company_folder = 'company';
        
        if(!JFolder::exists(JPATH_BASE . DS . $folder)){
            JFolder::create(JPATH_BASE . DS . $folder);
        } if(!JFolder::exists(JPATH_BASE . DS . $folder . DS . $ind_folder)){
            JFolder::create(JPATH_BASE . DS . $folder . DS . $ind_folder);
        } if(!JFolder::exists(JPATH_BASE . DS . $folder . DS . $company_folder)){
            JFolder::create(JPATH_BASE . DS . $folder . DS . $company_folder);
        }
        
        $pathFile = JPATH_BASE . DS . $folder . DS . $ind_folder . DS . $filename;
        $path_for_browser = 'https://' . $_SERVER['SERVER_NAME'] . DS . $folder . DS . $ind_folder . DS . $filename;
            
       
         
        $username = $this->getFinalUsername($user);
        
        $csv_array[0] = [$username];
        $csv_array[1] = [
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_MONTH')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PENSION_EMPLOYED')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PRIVATE_PENS')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_COMPANY_PENS')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_COMPANY_PRIVATE_PENS')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_INSURARCE')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_UNION')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_C_UNION')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_HOLIDAY')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_INCOME_MUNIC_TAX')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PERSONAL_TASK')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_SALARIES')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TAKE_HOME_PAY')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TOTAL_COST'))
        ];   
        
        $i = 2;
        $j = 0;
        $csv_array[$i] = [];
        $not_permitted_field_array = AuditController::getNotPermittedEarnedIncomeKeys();
        
        foreach($all_items_user as $one_row){
            $row_pay_period=json_decode($one_row->period); 
            
            $from = date('d.m.Y', strtotime($row_pay_period->from));
            $to = date('d.m.Y', strtotime($row_pay_period->to));
            $csv_array[$i][$j] = $from.' - '.$to;
            
            foreach($one_row as $k=>$v){
                if(!in_array($k, $not_permitted_field_array)){
                    $csv_array[$i][$j] = $this->floatToStrCalcTrue($v);     
                } 
                
                $j++;
            } 
                                            
            $i++; 
        }
        
        $i++;
        $ai = 0;
        $csv_array[$i][$ai] = JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TOTAL');
        $totals = $this->calcEarnedIncomeTotals($all_items_user, $not_permitted_field_array);
        $ai++;
        
        foreach($totals[count($totals)-1] as $k=>$v){
            $csv_array[$i][$ai] = $this->floatToStrCalcTrue($v);
            
            $ai++;
        }
        
        $fp = fopen($pathFile, 'w');
        fwrite($fp, b"\xEF\xBB\xBF");//add special iceland symbols
            
        foreach ($csv_array as $fields) {
            fputcsv($fp, $fields, ';');
        }       
        fclose($fp);
        
        return $filename;
    }
    
    private function getFinalUsername($user_obj) {
        $user_from_request_name = '';
        if (!empty($user_obj->username0)) {
            $user_from_request_name = $user_obj->username0;
        } elseif (!empty($user_obj->username)) {
            $user_from_request_name = $user_obj->username;
        } elseif (!empty($user_obj->name)) {
            $user_from_request_name = $user_obj->name;
        } else{
            $user_from_request_name = 'empty_username';
        }
        
        return $user_from_request_name;
    }

    public function createCsvAllUsersEarnedIncome($period, $user, $lang, $get_all_mode)
    { 
        /*ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);*/
        
        JLoader::register('AuditModelRegistered_Users', JPATH_ROOT . '/components/com_audit/models/registered_users.php');
        $model_reg = JModelLegacy::getInstance('Registered_Users', 'AuditModel');
        $users_list = $model_reg->getRegistredUser();
        $user_list_ids = [];
        
        //remove hide users
        foreach($users_list as $one_user){
            if($one_user->is_hide == 0 && $user->owner_id != $one_user->id){
                $user_list_ids[] = $one_user;
            }
        }
        
       
        $csv_array = [];
        
        $filename = 'earned_income_export-' . time() . '.csv';
        jimport( 'joomla.filesystem.folder');
        
        $folder = 'tmp_ei_csv';
        $ind_folder = 'individual';
        $company_folder = 'company';
        
        if(!JFolder::exists(JPATH_BASE . DS . $folder)){
            JFolder::create(JPATH_BASE . DS . $folder);
        } if(!JFolder::exists(JPATH_BASE . DS . $folder . DS . $ind_folder)){
            JFolder::create(JPATH_BASE . DS . $folder . DS . $ind_folder);
        } if(!JFolder::exists(JPATH_BASE . DS . $folder . DS . $company_folder)){
            JFolder::create(JPATH_BASE . DS . $folder . DS . $company_folder);
        }
        
        $pathFile = JPATH_BASE . DS . $folder . DS . $company_folder . DS . $filename;
        $path_for_browser = 'https://' . $_SERVER['SERVER_NAME'] . DS . $folder . DS . $company_folder . DS . $filename;
        $users_iterator = 0;
        $not_permitted_field_array = AuditController::getNotPermittedEarnedIncomeKeys();
         
        foreach ($user_list_ids as $one_filter_user) {
            $username = $this->getFinalUsername($one_filter_user);
        
            $csv_array[$users_iterator] = [$username];
            $users_iterator++;
            
            $csv_array[$users_iterator] = [
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_MONTH')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PENSION_EMPLOYED')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PRIVATE_PENS')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_COMPANY_PENS')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_COMPANY_PRIVATE_PENS')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_INSURARCE')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_UNION')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_C_UNION')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_HOLIDAY')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_INCOME_MUNIC_TAX')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PERSONAL_TASK')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_SALARIES')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TAKE_HOME_PAY')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TOTAL_COST')) 
            ];   
            $users_iterator++;

            if($get_all_mode == 0){
                $all_items_user = $this->getAllEarnedIncomeRecords2((array)$period, $one_filter_user);
            } else{
                $all_items_user = $this->getAllEarnedIncomeRecords(0, $one_filter_user);
            }

            $totals = $this->calcEarnedIncomeTotals($all_items_user, $not_permitted_field_array);
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/ei_csv_company.html', print_r( $totals, true), FILE_APPEND | LOCK_EX);
            
            $i = 2;
            $j = 0;

            foreach($all_items_user as $one_row){
                $row_pay_period=json_decode($one_row->period); 
            
                $from = date('d.m.Y', strtotime($row_pay_period->from));
                $to = date('d.m.Y', strtotime($row_pay_period->to));
                $csv_array[$users_iterator][$j] = $from.' - '.$to;

                foreach($one_row as $k=>$v){
                    if(!in_array($k, $not_permitted_field_array)){
                        $csv_array[$users_iterator][$j] = $this->floatToStrCalcTrue($v); 
                        //$users_iterator++;  
                    } 
                
                    $j++;
                }  
               
                $users_iterator++;

                $i++;      
            }
            
        
            $users_iterator++;   
                
            //totals:
            $csv_array[$users_iterator][0] = JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TOTAL');
            $tmp_total = $totals[count($totals)-1];
            
            if(empty($tmp_total)){
                $tmp_total = [];
            }
   
            foreach($tmp_total as $k=>$v){        
                $csv_array[$users_iterator][] = $this->floatToStrCalcTrue($v);
            }
            //end totals
            
            $users_iterator++;
            
            $csv_array[$users_iterator] = [];
            $users_iterator++;
        }

        $fp = fopen($pathFile, 'w');
        fwrite($fp, b"\xEF\xBB\xBF");//add special iceland symbols
            
        foreach ($csv_array as $fields) {
            fputcsv($fp, $fields, ';');
        }       
        fclose($fp);
        
        return $filename;
    } 

    public function floatToStrCalcTrue($a){ 
        //first variant(converter)
	/*$bc = (float)$a;
        $b = $this->toFixed($bc, 3);
	$result = []; 
        $strlen = strlen($b);
        
        if($strlen > 0){
            for($i = 0; $i <= $strlen; $i++){
                if(($strlen - $i) % 3 == 0 && (($strlen - $i) > 5 && $i > 0)){
                    $result[] = '.';
                } if(str_split($b)[$i] == '.'){
                    $result[] = ',';
                } else{
                    $result[] = str_split($b)[$i];
                }
            }
        }
  
	return implode($result, ""); */
        
        //second variant
        $arr = explode('.', $a);
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/ei_csv_company.html', print_r( $arr, true), FILE_APPEND | LOCK_EX);
        if($arr[0] != 0){
            $final = $arr[0].'.'.$arr[1];
        } else{
            return 0;
        }
        
        if(count($arr) == 1){
            $final = $arr[0];
        } elseif(count($arr) == 2){
            $strlen = strlen($arr[1]);
            if($strlen == 2){
                $final = $arr[0].'.'.$arr[1].'0';
            } if($strlen == 1){
                $final = $arr[0].'.'.$arr[1].'00';
            }
        }
        return $final;
    }
    
    private function toFixed($number, $decimals) {
        return number_format(round($number, $decimals), $decimals, '.', "");
    }

    public function createCsvAllUsersEarnedIncomeExcel($period, $user, $lang, $get_all_mode)
    { 
        JLoader::register('AuditModelRegistered_Users', JPATH_ROOT . '/components/com_audit/models/registered_users.php');
        $model_reg = JModelLegacy::getInstance('Registered_Users', 'AuditModel');
        $users_list = $model_reg->getRegistredUser();
        $user_list_ids = [];
        $not_permitted_field_array = AuditController::getNotPermittedEarnedIncomeKeys();
        
        require_once JPATH_LIBRARIES . '/PHPExcel/Classes/PHPExcel.php';
        require_once JPATH_LIBRARIES . '/PHPExcel/Classes/PHPExcel/Writer/Excel2007.php';
        
        $xls = new PHPExcel();
        
        //set document info
        $xls->getProperties()->setTitle("Excel user data export");
        $xls->getProperties()->setSubject("Excel user data export");
        $xls->getProperties()->setCreator("Curio time");
        $xls->getProperties()->setManager("UXD");
        $xls->getProperties()->setCompany("UXD");
        $xls->getProperties()->setLastModifiedBy("UXD");
        $xls->getProperties()->setCreated(date('d.m.Y H:i:s'));
        
        //remove hide users 
        foreach($users_list as $one_user){
            if($one_user->is_hide == 0 && $user->owner_id != $one_user->id){
                $user_list_ids[] = $one_user;
            }
        }
        
        $aplhabet = $this->getLetters();
        
        $i=0;
       // $i2 = 0;
        foreach ($user_list_ids as $one_filter_user) {
            $username = $this->getFinalUsername($one_filter_user);
            $objWorkSheet = $xls->createSheet($i); //Setting index when creating
            
            //set sheet name in bottom
            $objWorkSheet->setTitle($username);
            
            $objWorkSheet->setCellValue('A1', $username)
                ->setCellValue('A2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_MONTH')));
            
            if($get_all_mode == 0){
                $objWorkSheet->setCellValue('B1', $period['from'].'-'.$period['to']);
            } else{
                $objWorkSheet->setCellValue('B1', JText::_('COM_AUDIT_CALC_EARNED_INCOME_EXCELL_ALL_MODE'));
            }

            $objWorkSheet->setCellValue('B2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PENSION_EMPLOYED')))
                    ->setCellValue('C2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PRIVATE_PENS')))
                    ->setCellValue('D2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_COMPANY_PENS')))
                    ->setCellValue('E2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_COMPANY_PRIVATE_PENS')))
                    ->setCellValue('F2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_INSURARCE')))
                    ->setCellValue('G2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_UNION')))
                    ->setCellValue('H2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_C_UNION')))
                    ->setCellValue('I2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_HOLIDAY')))
                    ->setCellValue('J2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_INCOME_MUNIC_TAX')))
                    ->setCellValue('K2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PERSONAL_TASK')))
                    ->setCellValue('L2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_SALARIES')))
                    ->setCellValue('M2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TAKE_HOME_PAY')))
                    ->setCellValue('N2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TOTAL_COST')));
            
            if($get_all_mode == 0){
                $all_items_user = $this->getAllEarnedIncomeRecords2((array)$period, $one_filter_user);
            } else{
                $all_items_user = $this->getAllEarnedIncomeRecords(0, $one_filter_user);
            }
          
            
            $i0 = 3;
            $i2 = 3;

            foreach($all_items_user as $one_row){
                $j = 1;//0=>A, 1=>B etc.
                $row_pay_period=json_decode($one_row->period); 
            
                $from = date('d.m.Y', strtotime($row_pay_period->from));
                $to = date('d.m.Y', strtotime($row_pay_period->to));
               
                
                $objWorkSheet->setCellValue('A'.$i2, $from.' - '.$to);
               
                //echo $aplhabet[$i].PHP_EOL;
              
                
                foreach($one_row as $k=>$v){                   
                    if(!in_array($k, $not_permitted_field_array)){ 
                        $row_letter = $aplhabet[$j].$i2;
                        
                        if(!empty($aplhabet[$j])){
                            $objWorkSheet->setCellValue($row_letter, $this->floatToStrCalcTrue($v));
                        } 
                        $j++; 
                    } 

                    $i0++;
                    
                }  
                
               $i2++;
            
            }
            
            //totals:
            $totals = $this->calcEarnedIncomeTotals($all_items_user, $not_permitted_field_array);
            $total_header_cell = 'A'.$i2++;
            $objWorkSheet->setCellValue($total_header_cell, JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TOTAL'));
            $tmp_total = $totals[count($totals)-1];
            
            if(empty($tmp_total)){
                $tmp_total = [];
            }
            
            $j++;

            $l = 1;
            $i2--;
            foreach($tmp_total as $k=>$v){    
                $row_letter1 = $aplhabet[$l].$i2;
                
                if(!empty($aplhabet[$l]) && !empty($row_letter1)){
                    //echo $row_letter1.PHP_EOL;
                    $objWorkSheet->setCellValue($row_letter1, $this->floatToStrCalcTrue($v));
                }
                
                $l++;
            }
            //end totals

            $i++;
        }   
        
        $xls->setActiveSheetIndex(0);
        
        //remove default worksheet
        $xls->removeSheetByIndex(
            $xls->getIndex(
                $xls->getSheetByName('Worksheet')
            )
        );

        $filename = 'earned_income_export-' . time() . '.xlsx';
        jimport( 'joomla.filesystem.folder');
        
        $folder = 'tmp_ei_excel';
       
        
        if(!JFolder::exists(JPATH_BASE . DS . $folder)){
            JFolder::create(JPATH_BASE . DS . $folder);
        } 
        
        $pathFile = JPATH_BASE . DS . $folder . DS .$filename;
        // $path_for_browser = 'https://' . $_SERVER['SERVER_NAME'] . DS . $folder . DS . $filename;
        $objWriter = new PHPExcel_Writer_Excel2007($xls);
        $objWriter->save($pathFile);
        
        
        return $filename;
    } 
    
    public function getLetters()
    {
       $alhpabet = range('A', 'Z');
       $last_i = count($alhpabet);
            
       $alhpabet[$last_i++] = 'AA';
       $alhpabet[$last_i++] = 'AB';
       $alhpabet[$last_i++] = 'AC';
       $alhpabet[$last_i++] = 'AD';
       $alhpabet[$last_i++] = 'AE';
       $alhpabet[$last_i++] = 'AF';
       $alhpabet[$last_i++] = 'AG';
       $alhpabet[$last_i++] = 'AH';
       $alhpabet[$last_i++] = 'AI';
       $alhpabet[$last_i++] = 'AK';
       $alhpabet[$last_i++] = 'AL';
      
       return $alhpabet;
    }
    
    private function createColumnsArray($end_column, $first_letters = '')
{
  $columns = array();
  $length = strlen($end_column);
  $letters = range('A', 'Z');

  // Iterate over 26 letters.
  foreach ($letters as $letter) {
      // Paste the $first_letters before the next.
      $column = $first_letters . $letter;

      // Add the column to the final array.
      $columns[] = $column;

      // If it was the end column that was added, return the columns.
      if ($column == $end_column)
          return $columns;
  }

  // Add the column children.
  foreach ($columns as $column) {
      // Don't itterate if the $end_column was already set in a previous itteration.
      // Stop iterating if you've reached the maximum character length.
      if (!in_array($end_column, $columns) && strlen($column) < $length) {
          $new_columns = createColumnsArray($end_column, $column);
          // Merge the new columns which were created with the final columns array.
          $columns = array_merge($columns, $new_columns);
      }
  }

  return $columns;
}
    
    public function getFieldForNewTypeForm()
    {
        /*$fieldUnions  =  array(        
            //array('value'=>"",'title'=>"",'enabled'=>false),        
            array('value'=>1,'title'=>"AFL Starfsgreinafélag"),
            array('value'=>4,'title'=>"Drífandi stéttarfélag"),
            array('value'=>7,'title'=>"Framsýn stéttarfélag"),
            array('value'=>10,'title'=>"Verkalýðsfélag Akraness"),
            array('value'=>13,'title'=>"Verkalýðs- og sjómannafélag Bolungarvíkur"),
            array('value'=>16,'title'=>"Verkalýðsfélag Snæfellinga"),
            array('value'=>19,'title'=>"Verkalýðsfélag Þórshafnar"),

            array('value'=>"",'title'=>"",'enabled'=>false),

            array('value'=>2,'title'=>"Aldan stéttarfélag",'enabled'=>false),
            array('value'=>5,'title'=>"Efling stéttarfélag"),
            array('value'=>8,'title'=>"Stéttarfélagið Samstaða"),
            array('value'=>11,'title'=>"Verkalýðsfélag Grindavíkur"),
            array('value'=>14,'title'=>"Verkalýðs- og sjómannafél. Keflavíkur og nágr."),
            array('value'=>17,'title'=>"Verkalýðsfélag Suðurlands"),

            array('value'=>"",'title'=>"",'enabled'=>false),

            array('value'=>3,'title'=>"Báran stéttarfélag"),
            array('value'=>6,'title'=>"Eining-Iðja"),
            array('value'=>9,'title'=>"Stéttarfélag Vesturlands"),
            array('value'=>12,'title'=>"Verkalýðsfélagið Hlíf"),
            array('value'=>15,'title'=>"Verkalýðs- og sjómannafélag Sandgerðis"),
            array('value'=>18,'title'=>"Verkalýðsfélag Vestfirðinga"),	
        );*/
        
        /*$auto_union =   intval($this->config->get("enable_home_register_company_form_auto_union",0));
        if($auto_union > 0) {
            $arr  =  array();
            foreach ($fieldUnions as $u) {
                if($u['value'] == $auto_union) {
                    $arr = array($u);
                    return $arr;
                }
            }
            
        }*/
        
        $fieldUnions  = [
            [
                'value' => 'hourly',
                'title' => JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY_POPUP_SELECT')
            ],
            [
                'value' => 'monthly',
                'title' => JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY_POPUP_SELECT1')
            ],
            [
                'value' => 'self_empl',
                'title' => JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY_POPUP_SELECT2')
            ]
        ];
        
        return $fieldUnions;
    }
    
    public function saveRegisteredUserNewCalc($userId) {
        //if(!$this->isRegisterUserFormCalcFieldsEnabled())
            //return false;
        
        $userId  = intval($userId);
        if($userId <=0)
            return false;
        //$calc  =  JRequest::getVar('calc',array());
        $calc =  $this->app->input->getObject('calc_new_type');
        
        $calc['hourly_rate'] = str_replace('.', '', $calc['hourly_rate']);
        $calc['count_hours_pr_month'] = str_replace('.', '', $calc['count_hours_pr_month']);
        $calc['monthly_wage'] = str_replace('.', '', $calc['monthly_wage']);
        $calc['extra_h'] = str_replace('.', '', $calc['extra_h']);
        
        if(empty($calc)){
            return false;
        }
          
        
        
     
        
        $calc['user_id']    =   $userId;
        $calc['timestamp_create']   =   time();
        $calc['date_create']        =   date("Y-m-d H:i:s");
        
        $item = new stdClass();
        foreach ($calc as $k => $v) {
            if($v == 'on' ){
                $v = 1;
            }
            $item->$k = $v;
        }
        $this->db->insertObject("#__calculator_saves_new_type", $item, 'id' );
    }
    
     public function validateForRegisterNewType() {
        $retData = [
            "message" => "",
            "field" => "",
        ];
        
        $calc =  $this->app->input->getObject('calc_new_type');
        if(empty($calc)){
            return $retData;
        }
       
           
        if(empty($calc['union0']) || $calc['union0'] == '-1'){
            $retData['message'] =   JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY_POPUP_ERROR_EPTY_CALCULATOR_FIELDS_TYPE_OF_WORK');
            $retData['field'] =   "#select_type_of_work";
            return $retData;
        } 
        if ($calc['union0'] == 'hourly') {
            if (empty($calc['hourly_rate'])) {
                $retData['message'] = JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY_POPUP_ERROR_EPTY_CALCULATOR_FIELDS_HOURLY_RATE');
                $retData['field'] = "#input_hourly_rate";
                return $retData;
            } /*if (empty($calc['count_hours_pr_month'])) {
                $retData['message'] = JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY_POPUP_ERROR_EPTY_CALCULATOR_FIELDS_H_PR_MONTH');
                $retData['field'] = "#input_h_pr_month";
                return $retData;
            }*/
        } if ($calc['union0'] == 'monthly' || $calc['union0'] == 'self_empl') {
            if (empty($calc['monthly_wage'])) {
                $retData['message'] = JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY_POPUP_ERROR_EPTY_CALCULATOR_FIELDS_MONTHLY_WAGE');
                $retData['field'] = "#input_monthly_wage1";
                return $retData;
            } /*if (empty($calc['extra_h'])) {
                $retData['message'] = JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY_POPUP_ERROR_EPTY_CALCULATOR_FIELDS_EXTRA_H');
                $retData['field'] = "#input_extra_h1";
                return $retData;
            }*/
        }

        //if(!$this->isRegisterUserFormCalcFieldsEnabled())
           // return $retData;
        
        /*if(isset($calc['first_page_union_val']) && intval($calc['first_page_union_val']) >= 0) {
            if(isset($calc['contract']) == false || $calc['contract'] == "-1") {
                $retData['message'] =   JText::_('COM_AUDIT_PLEASE_SELECT').": ".JText::_('MOD_SELECTCALC_TITLE_TAB1');
                $retData['field'] =   "#registerUserCalcFormContract";
                return $retData;
            }            
            if(isset($calc['title']) == false || empty($calc['title']))  {                
                $retData['message'] =  JText::_('COM_AUDIT_PLEASE_SELECT').": ".JText::_('MOD_SELECTCALC_TITLE_TAB2').$calc['title'];
                $retData['field'] =   "#work_description";
                return $retData;
            }                        
            
            if(isset($calc['checkbox_value']) == false || empty($calc['checkbox_value']) || $calc['checkbox_value']  == "-1") {                
                $retData['message'] =  JText::_('COM_AUDIT_PLEASE_SELECT').": ".JText::_('MOD_SELECTCALC_MENUTITLE_SELECT_PAGE3_C2');
                $retData['field'] =   "#registerUserCalcFormType";
                return $retData;
            }
            
            
            if(isset($calc['module']) == false || empty($calc['module']) || $calc['module']  == "-1") {                
                $retData['message'] =  JText::_('COM_AUDIT_PLEASE_SELECT').": ".JText::_('MOD_SELECTCALC_TEXT_TAB4');
                $retData['field'] =   "#registerUserCalcFormModule";
                return $retData;
            }
            
            if(isset($calc['year'])) {
                $years  = intval(date("Y")) - intval($calc['year']);
                if($years < 14)  {                    
                    $retData['message'] =  JText::_('MOD_SELECTCALC_TEXTYOUNGER14_PAGE7');
                    $retData['field'] =   "#registerUserCalcFormYear";
                    return $retData;
                }
            }
            
        }*/
        
    }
    
    public function loadUserCalcNewSave(object $user_obj)
    {
        $query = "SELECT * FROM #__calculator_saves_new_type WHERE `user_id` = '$user_obj->id'";     
        $this->db->setQuery($query);
        $save = $this->db->loadObjectList();
        $count_saves = count($save);
        
        if($count_saves == 1){
            return $save[0];
        } elseif($count_saves > 1){
            throw new Exception(JText::_('COM_AUDIT_APP_API_LOAD_CALC_NEW_SAVE_ERROR_DB'));
        }
        
        
    }
    
    public function loadWidgetLink(object $user_obj)
    {
        $query = "SELECT * FROM #__widget_link_saves WHERE `user_id` = '$user_obj->id'";     
        $this->db->setQuery($query);
        $save = $this->db->loadObjectList();
        $count_saves = count($save);
        
        if($count_saves == 1){
            return $save[0];
        } elseif($count_saves > 1){
            throw new Exception(JText::_('COM_AUDIT_APP_API_LOAD_CALC_NEW_SAVE_ERROR_DB'));
        }   
    }
    
    public function getAllEarnedIncomeRecordsForNewModule($from_to_arr, $user, $all_users_mode = null)
    {
        /*echo '<pre>';
        print_r(func_get_args());
        echo '</pre>';*/
        if ($all_users_mode == 'all') {
            //echo 'all';
            if ($from_to_arr != 0) {
                $query = "SELECT * FROM " . $this->db->quoteName($this->eincome_new_module_table) . " WHERE JSON_VALUE(`period`, '$.from') = '" . $from_to_arr['from'] . "' AND JSON_VALUE(`period`, '$.to') = '" . $from_to_arr['to'] . "' ORDER BY " . $this->db->quoteName('id') . " DESC";
            } else {
                $query = "SELECT * FROM " . $this->db->quoteName($this->eincome_new_module_table) . " ORDER BY " . $this->db->quoteName('id') . " DESC";
            }
        } else {
            if ($from_to_arr != 0) {
                $query = "SELECT * FROM " . $this->db->quoteName($this->eincome_new_module_table) . " WHERE " . $this->db->quoteName('user_id') . " = '$user->id' AND JSON_VALUE(`period`, '$.from') = '" . $from_to_arr['from'] . "' AND JSON_VALUE(`period`, '$.to') = '" . $from_to_arr['to'] . "' ORDER BY " . $this->db->quoteName('id') . " ASC";
            } else {
                $query = "SELECT * FROM " . $this->db->quoteName($this->eincome_new_module_table) . " WHERE " . $this->db->quoteName('user_id') . " = '$user->id' ORDER BY " . $this->db->quoteName('id') . " ASC";
            }
        }
        //echo $query . PHP_EOL;
        
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        if ($all_users_mode == 'all') {
             foreach($data as $one_row){
                 $one_row->username = $this->getFinalUsername( JFactory::getUser($one_row->user_id));
             }
        }
        
        return $data;        
    }
    
    public function loadEIPeriodForNewModule($user_obj)
    {
        $query = "SELECT * FROM " . $this->db->quoteName($this->eincome_period_saves_new_module) . "  WHERE " . $this->db->quoteName('user_id') . " = '$user_obj->id'";     
        $this->db->setQuery($query);
        $saves = $this->db->loadAssocList();

	if(count($saves) === 0){
            return [];
        } elseif(count($saves) === 1){
           
        } else{
            throw new Exception(JText::_('COM_AUDIT_EARNED_INCOME_LOAD_EI_PERIOD_ERROR_DB_COUNT_SAVES'));
        }
        
        //$to_arr = explode('-', $pay_period);
        $from = date('Y').$saves[0]['period'];
        
        $final = [
            'from'=>$from,
            'to'=>date('Y-m-d', strtotime($from.'+1year +1month -1day'))
        ];
        
        return $final;
    }
    
    public function loadEarnedIncomeRecordForNewModule($row_id, $user, $lang)
    {
        $query = "SELECT * FROM " . $this->db->quoteName($this->eincome_new_module_table) . " WHERE " . $this->db->quoteName('id') . " = '".$row_id."' AND " . $this->db->quoteName('user_id') . " = '$user->id'";     
        $this->db->setQuery($query);
        $records = $this->db->loadObjectList();
        
        if(count($records) === 0){
           throw new Exception('Error while load stored values for calculator: record was deleted from database while it was being opened!');
        } elseif(count($records) === 1){
          return $records[0];
        } else{
           throw new Exception('Error while load stored values for calculator: There is more than one entry per user in the database!');
        }
    }
    
    public function loadEarnedIncomeTableForNewModule($convert_from, $user, $lang, $type = null)
    {
        $not_permitted_field_array = AuditControllerCalc::getNotPermittedEarnedIncomeKeys();
        $this->all_items_user = $this->getAllEarnedIncomeRecordsForNewModuleWithPeriod($convert_from, $user);
        $this->totals = $this->calcEarnedIncomeTotals($this->all_items_user, $not_permitted_field_array);
        $this->count_totals = count($this->totals);
        
        $from_arr = explode('-', $convert_from['from'] );
        $global_year = $from_arr[0];

        ob_start();
        /*echo '<pre>';
        print_r($_REQUEST);
        echo '</pre>';*/
        if(!empty($this->all_items_user)){?>
            <table class="table_earned_income table table-striped">
                <tbody>
                    <tr class="tr_calc_header">
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_MONTH') ?><br/><?=$global_year?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PENSION_EMPLOYED') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PRIVATE_PENS') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_COMPANY_PENS') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_COMPANY_PRIVATE_PENS') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_INSURARCE') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_UNION') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_C_UNION') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_HOLIDAY') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_INCOME_MUNIC_TAX') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PERSONAL_TASK') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_SALARIES') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TAKE_HOME_PAY') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TOTAL_COST') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Statutory pension fund: Employee’s premium') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Statutory pension fund: Employers matching grant') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Statutory pension fund: Rehabilitation fund') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Private pension fund: Employee’s premium') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Private pension fund: Employers matching grant') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Insurance fee: General insurance fee') ?></td>
                                
                                <td data-soft-remove="1"><?= JText::_('Your personal tax allowance') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Spouses’ tax allowance') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Untapped personal tax allowance') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Untapped spouses’ tax allowance') ?></td>
                                
                                <td data-soft-remove="1"><?= JText::_('Vehicle Allowance person') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Vehicle Allowance') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Car benefit person') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Car benefit') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Food person') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Food') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Life Insurance person') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Life Insurance') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Housing person') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Housing') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Transportation Costs person') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Transportation Costs') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Physical fitness person') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Physical fitness') ?></td>
                               
                                <td></td>
                                <td></td>
                    </tr> 
                    <?php $i=0; foreach($this->all_items_user as $one_row){?>
                        <tr>
                            <?php
                                $row_pay_period = json_decode($one_row->period); 
                                $from = date('d.m', strtotime($row_pay_period->from));
                                $to = date('d.m', strtotime($row_pay_period->to));
                            ?>
                                <td><?=$from.' - '.$to?></td>
                                <?php foreach($one_row as $k=>$v){?>
                                    <?php if(!in_array($k, $not_permitted_field_array)){?>
                                        <td class="js_event_td_calc" data-k="<?=$k?>"><?=$this->floatToStrCalcTrue($v)?></td>
                                    <?php } ?>                                  
                                <?php
                                    } 
                                    $calc_link = '/calc-for-new-module';
                                   
                                ?>
                                <td class="earned_income_plus"><a href="<?=$calc_link?>?u_id=<?=$user->id?>&ein_id=<?=$one_row->id?>&from_p=<?=$from?>&to_p=<?=$to?>"><i class="fa fa-plus" aria-hidden="true"></i></a></td>
                                <td><div class="delete_table_row" id="row_id-<?=$one_row->id?>"><i class="fa fa-window-close" aria-hidden="true"></i></div></td>
                        </tr>
                        <?php $i++; } ?>
                        <tr>
                            <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TOTAL') ?></td>
                            <?php foreach($this->totals[$this->count_totals-1] as $k=>$v){?>
                                <td class="js_event_td_earned_income_total" data-k="<?=$k?>"><?=$this->floatToStrCalcTrue($v)?></td>
                            <?php } ?>
                            <td></td>
                            <td></td>
                        </tr>
                </tbody>
            </table>
            <?php
        } else{?> 
            <div class="alert alert-info alert-custom-0">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <div class="alert_info">
                    <?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_NO_DATA') ?>   
                </div>
            </div>
        <?php }
        $html=ob_get_contents();
          
        ob_end_clean(); 
        return $html;
    }
    
    public function getAllEarnedIncomeRecordsForNewModuleWithPeriod($from_to_arr, $user) {
        $from_timestamp = strtotime($from_to_arr['from']);

        $next_year_to_timestamp = date('U', strtotime($from_to_arr['from'] . ' +1year -1day'));
        $query = "SELECT * FROM " . $this->db->quoteName($this->eincome_new_module_table) . " WHERE " . $this->db->quoteName('user_id') . " = '$user->id' ORDER BY " . $this->db->quoteName('id') . " ASC";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        $final = [];

        foreach ($data as $one_row) {
            $row_pay_period = json_decode($one_row->period);

            $row_from_stamp = strtotime($row_pay_period->from);
            $row_to_stamp = strtotime($row_pay_period->to);

           
            if ($from_timestamp <= $row_from_stamp && $row_to_stamp <= $next_year_to_timestamp) {
                $final[] = $one_row;
            }
        }

        return $final;
    }
    
    public function loadEarnedIncomeTableDefaultForNewModule($convert_from, $user, $lang, $type = null, $original_period = null)
    {
        $not_permitted_field_array = AuditControllerCalc::getNotPermittedEarnedIncomeKeys();
        $this->all_items_user = $this->getAllEarnedIncomeRecordsForNewModule(0, $user);
        $this->totals = $this->calcEarnedIncomeTotals($this->all_items_user, $not_permitted_field_array);
        $this->count_totals = count($this->totals);
        
       
        if(!empty($original_period)){
            $from_arr = explode('-', $original_period['from'] );
            $global_year = $from_arr[0];
        }
        
        ob_start();
        if(!empty($this->all_items_user)){?>
        
            <table class="table_earned_income table table-striped">
                <tbody>
                    <tr class="tr_calc_header">
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_MONTH') ?><br/><?=$global_year?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PENSION_EMPLOYED') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PRIVATE_PENS') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_COMPANY_PENS') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_COMPANY_PRIVATE_PENS') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_INSURARCE') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_UNION') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_C_UNION') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_HOLIDAY') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_INCOME_MUNIC_TAX') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PERSONAL_TASK') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_SALARIES') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TAKE_HOME_PAY') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TOTAL_COST') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Statutory pension fund: Employee’s premium') ?></td>
                        
                        <td data-soft-remove="1"><?= JText::_('Statutory pension fund: Employers matching grant') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Statutory pension fund: Rehabilitation fund') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Private pension fund: Employee’s premium') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Private pension fund: Employers matching grant') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Insurance fee: General insurance fee') ?></td>
                                
                        <td data-soft-remove="1"><?= JText::_('Your personal tax allowance') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Spouses’ tax allowance') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Untapped personal tax allowance') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Untapped spouses’ tax allowance') ?></td>
                                
                        <td data-soft-remove="1"><?= JText::_('Vehicle Allowance person') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Vehicle Allowance') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Car benefit person') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Car benefit') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Food person') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Food') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Life Insurance person') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Life Insurance') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Housing person') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Housing') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Transportation Costs person') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Transportation Costs') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Physical fitness person') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Physical fitness') ?></td>
                               
                               
                        <td></td>
                        <td></td>
                    </tr> 
                    <?php $i=0; foreach($this->all_items_user as $one_row){?>
                        <tr>
                           <?php
                                $row_pay_period = json_decode($one_row->period); 
                                $from = date('d.m', strtotime($row_pay_period->from));
                                $to = date('d.m', strtotime($row_pay_period->to));
                            ?>
                                <td><?=$from.' - '.$to?></td>
                                <?php foreach($one_row as $k=>$v){?>
                                    <?php if(!in_array($k, $not_permitted_field_array)){?>
                                        <td class="js_event_td_calc" data-k="<?=$k?>"><?=$this->floatToStrCalcTrue($v)?></td>
                                    <?php } ?>                                  
                                <?php
                                    } 
                                    $calc_link = '/calc-for-new-module';
                                    
                                ?>
                                <td class="earned_income_plus"><a href="<?=$calc_link?>?u_id=<?=$user->id?>&ein_id=<?=$one_row->id?>&from_p=<?=$from?>&to_p=<?=$to?>"><i class="fa fa-plus" aria-hidden="true"></i></a></td>
                                <td><div class="delete_table_row" id="row_id-<?=$one_row->id?>"><i class="fa fa-window-close" aria-hidden="true"></i></div></td>
                        </tr>
                        <?php $i++; } ?>
                        <tr>
                            <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TOTAL') ?></td>
                            <?php foreach($this->totals[$this->count_totals-1] as $k=>$v){?>
                                <td class="js_event_td_earned_income_total" data-k="<?=$k?>"><?=$this->floatToStrCalcTrue($v)?></td>
                            <?php } ?>
                            <td></td>
                            <td></td>
                        </tr>
                </tbody>
            </table>
            <?php
        } else{?> 
            <div class="alert alert-info alert-custom-0">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <div class="alert_info">
                    <?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_NO_DATA') ?>   
                </div>
            </div>
        <?php }
        $html=ob_get_contents();
          
        ob_end_clean(); 
        return $html;
    }
    
    public function createCsvAllUsersEarnedIncomeForNewModule($period, $user, $lang, $get_all_mode)
    { 
        /*ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);*/
        
        JLoader::register('AuditModelRegistered_Users', JPATH_ROOT . '/components/com_audit/models/registered_users.php');
        $model_reg = JModelLegacy::getInstance('Registered_Users', 'AuditModel');
        $users_list = $model_reg->getRegistredUser();
        $user_list_ids = [];
        
        //remove hide users
        foreach($users_list as $one_user){
            if($one_user->is_hide == 0 && $user->owner_id != $one_user->id){
                $user_list_ids[] = $one_user;
            }
        }
        
       
        $csv_array = [];
        
        $filename = 'earned_income_export-' . time() . '.csv';
        jimport( 'joomla.filesystem.folder');
        
        $folder = 'tmp_ei_csv';
        $ind_folder = 'individual';
        $company_folder = 'company';
        
        if(!JFolder::exists(JPATH_BASE . DS . $folder)){
            JFolder::create(JPATH_BASE . DS . $folder);
        } if(!JFolder::exists(JPATH_BASE . DS . $folder . DS . $ind_folder)){
            JFolder::create(JPATH_BASE . DS . $folder . DS . $ind_folder);
        } if(!JFolder::exists(JPATH_BASE . DS . $folder . DS . $company_folder)){
            JFolder::create(JPATH_BASE . DS . $folder . DS . $company_folder);
        }
        
        $pathFile = JPATH_BASE . DS . $folder . DS . $company_folder . DS . $filename;
        $path_for_browser = 'https://' . $_SERVER['SERVER_NAME'] . DS . $folder . DS . $company_folder . DS . $filename;
        $users_iterator = 0;
        $not_permitted_field_array = AuditControllerCalc::getNotPermittedEarnedIncomeKeys();
         
        foreach ($user_list_ids as $one_filter_user) {
            $username = $this->getFinalUsername($one_filter_user);
        
            $csv_array[$users_iterator] = [$username];
            $users_iterator++;
            
            $csv_array[$users_iterator] = [
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_MONTH')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PENSION_EMPLOYED')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PRIVATE_PENS')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_COMPANY_PENS')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_COMPANY_PRIVATE_PENS')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_INSURARCE')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_UNION')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_C_UNION')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_HOLIDAY')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_INCOME_MUNIC_TAX')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PERSONAL_TASK')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_SALARIES')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TAKE_HOME_PAY')),
                strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TOTAL_COST')),
                
                strip_tags(JText::_('Statutory pension fund: Employee’s premium')),
                strip_tags(JText::_('Statutory pension fund: Employers matching grant')),
                strip_tags(JText::_('Statutory pension fund: Rehabilitation fund')),
                strip_tags(JText::_('Private pension fund: Employee’s premium')),
                strip_tags(JText::_('Private pension fund: Employers matching grant')),
                strip_tags(JText::_('Insurance fee: General insurance fee')),
                                
                strip_tags(JText::_('Your personal tax allowance')),
                strip_tags(JText::_('Spouses’ tax allowance')),
                strip_tags(JText::_('Untapped personal tax allowance')),
                strip_tags(JText::_('Untapped spouses’ tax allowance')),
                                
                strip_tags(JText::_('Vehicle Allowance person')),
                strip_tags(JText::_('Vehicle Allowance')),
                strip_tags(JText::_('Car benefit person')),
                strip_tags(JText::_('Car benefit')),
                strip_tags(JText::_('Food person')),
                strip_tags(JText::_('Food')),
                strip_tags(JText::_('Life Insurance person')),
                strip_tags(JText::_('Life Insurance')),
                strip_tags(JText::_('Housing person')),
                strip_tags(JText::_('Housing')),
                strip_tags(JText::_('Transportation Costs person')),
                strip_tags(JText::_('Transportation Costs')),
                strip_tags(JText::_('Physical fitness person')),
                strip_tags(JText::_('Physical fitness'))
            ];   
            $users_iterator++;

            if($get_all_mode == 0){
                $all_items_user = $this->getAllEarnedIncomeRecordsForNewModuleWithPeriod((array)$period, $one_filter_user);
            } else{
                $all_items_user = $this->getAllEarnedIncomeRecordsForNewModule(0, $one_filter_user);
            }
            
            /*echo '<pre>';
            print_r($all_items_user);
            echo '</pre>';*/
            $totals = $this->calcEarnedIncomeTotals($all_items_user, $not_permitted_field_array);
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/ei_csv_company.html', print_r( $all_items_user, true), FILE_APPEND | LOCK_EX);
            
            $i = 2;
            $j = 0;

            foreach($all_items_user as $one_row){
                $row_pay_period=json_decode($one_row->period); 
            
                $from = date('d.m.Y', strtotime($row_pay_period->from));
                $to = date('d.m.Y', strtotime($row_pay_period->to));
                $csv_array[$users_iterator][$j] = $from.' - '.$to;

                foreach($one_row as $k=>$v){
                    if(!in_array($k, $not_permitted_field_array)){
                        $csv_array[$users_iterator][$j] = $this->floatToStrCalcTrue($v); 
                        //$users_iterator++;  
                    } 
                
                    $j++;
                }  
               
                $users_iterator++;

                $i++;      
            }
            
        
            $users_iterator++;   
                
            //totals:
            $csv_array[$users_iterator][0] = JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TOTAL');
            $tmp_total = $totals[count($totals)-1];
            
            if(empty($tmp_total)){
                $tmp_total = [];
            }
   
            foreach($tmp_total as $k=>$v){        
                $csv_array[$users_iterator][] = $this->floatToStrCalcTrue($v);
            }
            //end totals
            
            $users_iterator++;
            
            $csv_array[$users_iterator] = [];
            $users_iterator++;
        }

        $fp = fopen($pathFile, 'w');
        fwrite($fp, b"\xEF\xBB\xBF");//add special iceland symbols
            
        foreach ($csv_array as $fields) {
            fputcsv($fp, $fields, ';');
        }       
        fclose($fp);
        
        return $filename;
    }
    
    public function createCsvEarnedIncomeForNewModule($period, $user, $lang, $get_all_mode) {
        /*ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);*/

        if($get_all_mode == 0){
            $all_items_user = $this->getAllEarnedIncomeRecordsForNewModuleWithPeriod((array)$period, $user);
        } else{
            $all_items_user = $this->getAllEarnedIncomeRecordsForNewModule(0, $user);
        }
            
        if(empty($all_items_user)){
            throw new Exception(JText::_('Error while create csv: no data found'));
        }
        
        $filename = 'earned_income_export-' . time() . '.csv';
        jimport( 'joomla.filesystem.folder');
            
        $folder = 'tmp_ei_csv';
        $ind_folder = 'individual';
        $company_folder = 'company';
        
        if(!JFolder::exists(JPATH_BASE . DS . $folder)){
            JFolder::create(JPATH_BASE . DS . $folder);
        } if(!JFolder::exists(JPATH_BASE . DS . $folder . DS . $ind_folder)){
            JFolder::create(JPATH_BASE . DS . $folder . DS . $ind_folder);
        } if(!JFolder::exists(JPATH_BASE . DS . $folder . DS . $company_folder)){
            JFolder::create(JPATH_BASE . DS . $folder . DS . $company_folder);
        }
        
        $pathFile = JPATH_BASE . DS . $folder . DS . $ind_folder . DS . $filename;
        $path_for_browser = 'https://' . $_SERVER['SERVER_NAME'] . DS . $folder . DS . $ind_folder . DS . $filename;
            
       
         
        $username = $this->getFinalUsername($user);
        
        $csv_array[0] = [$username];
        $csv_array[1] = [
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_MONTH')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PENSION_EMPLOYED')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PRIVATE_PENS')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_COMPANY_PENS')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_COMPANY_PRIVATE_PENS')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_INSURARCE')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_UNION')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_C_UNION')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_HOLIDAY')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_INCOME_MUNIC_TAX')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PERSONAL_TASK')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_SALARIES')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TAKE_HOME_PAY')),
            strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TOTAL_COST')),
            
            strip_tags(JText::_('Statutory pension fund: Employee’s premium')),
            strip_tags(JText::_('Statutory pension fund: Employers matching grant')),
            strip_tags(JText::_('Statutory pension fund: Rehabilitation fund')),
            strip_tags(JText::_('Private pension fund: Employee’s premium')),
            strip_tags(JText::_('Private pension fund: Employers matching grant')),
            strip_tags(JText::_('Insurance fee: General insurance fee')),
                                
            strip_tags(JText::_('Your personal tax allowance')),
            strip_tags(JText::_('Spouses’ tax allowance')),
            strip_tags(JText::_('Untapped personal tax allowance')),
            strip_tags(JText::_('Untapped spouses’ tax allowance')),
                                
            strip_tags(JText::_('Vehicle Allowance person')),
            strip_tags(JText::_('Vehicle Allowance')),
            strip_tags(JText::_('Car benefit person')),
            strip_tags(JText::_('Car benefit')),
            strip_tags(JText::_('Food person')),
            strip_tags(JText::_('Food')),
            strip_tags(JText::_('Life Insurance person')),
            strip_tags(JText::_('Life Insurance')),
            strip_tags(JText::_('Housing person')),
            strip_tags(JText::_('Housing')),
            strip_tags(JText::_('Transportation Costs person')),
            strip_tags(JText::_('Transportation Costs')),
            strip_tags(JText::_('Physical fitness person')),
            strip_tags(JText::_('Physical fitness'))
        ];   
        
        $i = 2;
        $j = 0;
        $csv_array[$i] = [];
        $not_permitted_field_array = AuditControllerCalc::getNotPermittedEarnedIncomeKeys();
        
        foreach($all_items_user as $one_row){
            $row_pay_period=json_decode($one_row->period); 
            
            $from = date('d.m.Y', strtotime($row_pay_period->from));
            $to = date('d.m.Y', strtotime($row_pay_period->to));
            $csv_array[$i][$j] = $from.' - '.$to;
            
            foreach($one_row as $k=>$v){
                if(!in_array($k, $not_permitted_field_array)){
                    $csv_array[$i][$j] = $this->floatToStrCalcTrue($v);     
                } 
                
                $j++;
            } 
                                            
            $i++; 
        }
        
        $i++;
        $ai = 0;
        $csv_array[$i][$ai] = JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TOTAL');
        $totals = $this->calcEarnedIncomeTotals($all_items_user, $not_permitted_field_array);
        $ai++;
        
        foreach($totals[count($totals)-1] as $k=>$v){
            $csv_array[$i][$ai] = $this->floatToStrCalcTrue($v);
            
            $ai++;
        }
        
        $fp = fopen($pathFile, 'w');
        fwrite($fp, b"\xEF\xBB\xBF");//add special iceland symbols
            
        foreach ($csv_array as $fields) {
            fputcsv($fp, $fields, ';');
        }       
        fclose($fp);
        
        return $filename;
    }

    public function createXlsAllUsersEarnedIncomeForNewModule($period, $user, $lang, $get_all_mode)
    { 
        JLoader::register('AuditModelRegistered_Users', JPATH_ROOT . '/components/com_audit/models/registered_users.php');
        $model_reg = JModelLegacy::getInstance('Registered_Users', 'AuditModel');
        $users_list = $model_reg->getRegistredUser();
        $user_list_ids = [];
        $not_permitted_field_array = AuditControllerCalc::getNotPermittedEarnedIncomeKeys();
        
        require_once JPATH_LIBRARIES . '/PHPExcel/Classes/PHPExcel.php';
        require_once JPATH_LIBRARIES . '/PHPExcel/Classes/PHPExcel/Writer/Excel2007.php';
        
        $xls = new PHPExcel();
        
        //set document info
        $xls->getProperties()->setTitle("Excel user data export");
        $xls->getProperties()->setSubject("Excel user data export");
        $xls->getProperties()->setCreator("Curio time");
        $xls->getProperties()->setManager("UXD");
        $xls->getProperties()->setCompany("UXD");
        $xls->getProperties()->setLastModifiedBy("UXD");
        $xls->getProperties()->setCreated(date('d.m.Y H:i:s'));
        
        //remove hide users 
        foreach($users_list as $one_user){
            if($one_user->is_hide == 0 && $user->owner_id != $one_user->id){
                $user_list_ids[] = $one_user;
            }
        }
        
        $aplhabet = $this->getLetters();
        //$alphabet = $this->createColumnsArray('A', 'AL');
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/calc_xls77.html', print_r($aplhabet . PHP_EOL, true), FILE_APPEND | LOCK_EX); 
        $i=0;
       // $i2 = 0;
        foreach ($user_list_ids as $one_filter_user) {
            $username = $this->getFinalUsername($one_filter_user);
            $objWorkSheet = $xls->createSheet($i); //Setting index when creating
            
            //set sheet name in bottom
            $objWorkSheet->setTitle($username);
            
            $objWorkSheet->setCellValue('A1', $username)
                ->setCellValue('A2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_MONTH')));
            
            if($get_all_mode == 0){
                $objWorkSheet->setCellValue('B1', $period['from'].'-'.$period['to']);
            } else{
                $objWorkSheet->setCellValue('B1', JText::_('COM_AUDIT_CALC_EARNED_INCOME_EXCELL_ALL_MODE'));
            }

            $objWorkSheet->setCellValue('B2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PENSION_EMPLOYED')))
                    ->setCellValue('C2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PRIVATE_PENS')))
                    ->setCellValue('D2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_COMPANY_PENS')))
                    ->setCellValue('E2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_COMPANY_PRIVATE_PENS')))
                    ->setCellValue('F2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_INSURARCE')))
                    ->setCellValue('G2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_UNION')))
                    ->setCellValue('H2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_C_UNION')))
                    ->setCellValue('I2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_HOLIDAY')))
                    ->setCellValue('J2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_INCOME_MUNIC_TAX')))
                    ->setCellValue('K2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PERSONAL_TASK')))
                    ->setCellValue('L2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_SALARIES')))
                    ->setCellValue('M2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TAKE_HOME_PAY')))
                    ->setCellValue('N2', strip_tags(JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TOTAL_COST')))
                    
                    ->setCellValue('O2', strip_tags(JText::_('Statutory pension fund: Employee’s premium')))
                    ->setCellValue('P2', strip_tags(JText::_('Statutory pension fund: Employers matching grant')))
                    ->setCellValue('Q2', strip_tags(JText::_('Statutory pension fund: Rehabilitation fund')))
                    ->setCellValue('R2', strip_tags(JText::_('Private pension fund: Employee’s premium')))
                    ->setCellValue('S2', strip_tags(JText::_('Private pension fund: Employers matching grant')))
                    ->setCellValue('T2', strip_tags(JText::_('Insurance fee: General insurance fee')))
                                
                    ->setCellValue('U2', strip_tags(JText::_('Your personal tax allowance')))
                    ->setCellValue('V2', strip_tags(JText::_('Spouses’ tax allowance')))
                    ->setCellValue('W2', strip_tags(JText::_('Untapped personal tax allowance')))
                    ->setCellValue('X2', strip_tags(JText::_('Untapped spouses’ tax allowance')))
                                
                    ->setCellValue('Y2', strip_tags(JText::_('Vehicle Allowance person')))
                    ->setCellValue('Z2', strip_tags(JText::_('Vehicle Allowance')))
                    ->setCellValue('AA2', strip_tags(JText::_('Car benefit person')))
                    ->setCellValue('AB2', strip_tags(JText::_('Car benefit')))
                    ->setCellValue('AC2', strip_tags(JText::_('Food person')))
                    ->setCellValue('AD2', strip_tags(JText::_('Food')))
                    ->setCellValue('AE2', strip_tags(JText::_('Life Insurance person')))
                    ->setCellValue('AF2', strip_tags(JText::_('Life Insurance')))
                    ->setCellValue('AG2', strip_tags(JText::_('Housing person')))
                    ->setCellValue('AH2', strip_tags(JText::_('Housing')))
                    ->setCellValue('AI2', strip_tags(JText::_('Transportation Costs person')))
                    ->setCellValue('AJ2', strip_tags(JText::_('Transportation Costs')))
                    ->setCellValue('AK2', strip_tags(JText::_('Physical fitness person')))
                    ->setCellValue('AL2', strip_tags(JText::_('Physical fitness')));
            
            if($get_all_mode == 0){
                $all_items_user = $this->getAllEarnedIncomeRecordsForNewModuleWithPeriod((array)$period, $one_filter_user);
            } else{
                $all_items_user = $this->getAllEarnedIncomeRecordsForNewModule(0, $one_filter_user);
            }
          
            
            $i0 = 3;
            $i2 = 3;

            foreach($all_items_user as $one_row){
                $j = 1;//0=>A, 1=>B etc.
                $row_pay_period=json_decode($one_row->period); 
            
                $from = date('d.m.Y', strtotime($row_pay_period->from));
                $to = date('d.m.Y', strtotime($row_pay_period->to));
               
                
                $objWorkSheet->setCellValue('A'.$i2, $from.' - '.$to);
               
                //echo $aplhabet[$i].PHP_EOL;
              
                
                foreach($one_row as $k=>$v){                   
                    if(!in_array($k, $not_permitted_field_array)){ 
                        $row_letter = $aplhabet[$j].$i2;
                        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/calc_xls77.html', print_r($row_letter . PHP_EOL, true), FILE_APPEND | LOCK_EX); 
                        if(!empty($aplhabet[$j])){
                            $objWorkSheet->setCellValue($row_letter, $this->floatToStrCalcTrue($v));
                        } 
                        $j++; 
                    } 

                    $i0++;
                    
                }  
                
               $i2++;
            
            }
            
            //totals:
            $totals = $this->calcEarnedIncomeTotals($all_items_user, $not_permitted_field_array);
            $total_header_cell = 'A'.$i2++;
            $objWorkSheet->setCellValue($total_header_cell, JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TOTAL'));
            $tmp_total = $totals[count($totals)-1];
            
            if(empty($tmp_total)){
                $tmp_total = [];
            }
            
            $j++;

            $l = 1;
            $i2--;
            foreach($tmp_total as $k=>$v){    
                $row_letter1 = $aplhabet[$l].$i2;
                
                if(!empty($aplhabet[$l]) && !empty($row_letter1)){
                    //echo $row_letter1.PHP_EOL;
                    $objWorkSheet->setCellValue($row_letter1, $this->floatToStrCalcTrue($v));
                }
                
                $l++;
            }
            //end totals

            $i++;
        }   
        
        $xls->setActiveSheetIndex(0);
        
        //remove default worksheet
        $xls->removeSheetByIndex(
            $xls->getIndex(
                $xls->getSheetByName('Worksheet')
            )
        );

        $filename = 'earned_income_export-' . time() . '.xlsx';
        jimport( 'joomla.filesystem.folder');
        
        $folder = 'tmp_ei_excel';
       
        
        if(!JFolder::exists(JPATH_BASE . DS . $folder)){
            JFolder::create(JPATH_BASE . DS . $folder);
        } 
        
        $pathFile = JPATH_BASE . DS . $folder . DS .$filename;
        
        $objWriter = new PHPExcel_Writer_Excel2007($xls);
        $objWriter->save($pathFile);
        
        
        return $filename;
    } 

    /*private function clearOldSimilarItems(Joomla\CMS\User\User $user, string $lang, string $value, string $relation_key) {
        $query = "DELETE FROM " . $this->db->quoteName($this->pp_calc_relation_table) . " WHERE " . $this->db->quoteName('calc_field') . " = '$value' AND " . $this->db->quoteName('user_id') . " = '" . $user->id . "';";
        $this->db->setQuery($query);
        $this->db->query();
    }*/
    
    private function clearOldSimilarItems(array $user_ids, string $lang, string $value, string $relation_key) {
        $query = "DELETE FROM " . $this->db->quoteName($this->pp_calc_relation_table) . " WHERE (" . $this->db->quoteName('pp_field') . " = '$relation_key' OR " . $this->db->quoteName('calc_field') . " = '$value') AND " . $this->db->quoteName('user_id') . " IN(". implode(',', $user_ids) . ");";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    private function loadUsersWithSimilarRules(Joomla\CMS\User\User $user) {
        $rules_strings = [
            'rule_number',
            'rule_number0',
            'shift_number',
            'loop_number',
            'loop4_number',
            'spec_number'
        ];
        
        if($user->rule_number > 0){
            $rule_field = $rules_strings[0];
        } elseif($user->rule_number0 > 0){
            $rule_field = $rules_strings[1];
        } elseif($user->shift_number > 0){
            $rule_field = $rules_strings[2]; 
        } elseif($user->loop_number > 0){
            $rule_field = $rules_strings[3];
        } elseif($user->loop4_number > 0){
            $rule_field = $rules_strings[4];   
        } elseif($user->spec_number > 0){
            $rule_field = $rules_strings[5]; 
        } 
        
        if($user->rule_number != 0 || $user->rule_number0 != 0 || $user->shift_number != 0 || $user->loop_number != 0 || $user->loop4_number != 0 || $user->spec_number != 0){
            $query = "SELECT * FROM " . $this->db->quoteName('#__users') . " WHERE " . $this->db->quoteName('owner_id') . " = '" . $user->owner_id . "' AND " . $this->db->quoteName($rule_field) . " in (select " . $this->db->quoteName($rule_field) . " from `#__users` WHERE " . $this->db->quoteName($rule_field) . " != 0 group by " . $this->db->quoteName($rule_field) . " having count(*) > 0)"; 
            $this->db->setQuery($query);
            $users = $this->db->loadObjectList(); 
        } elseif($user->rule_number == 0 && $user->rule_number0 == 0 && $user->shift_number == 0 && $user->loop_number == 0 && $user->loop4_number == 0 && $user->spec_number == 0){
            $query = "SELECT * FROM " . $this->db->quoteName('#__users') . " WHERE " . $this->db->quoteName('owner_id') . " = '" . $user->owner_id . "' AND ("; 
            
            for($i = 0; $i < count($rules_strings); $i++){
                $query .= $this->db->quoteName($rules_strings[$i]) . " = 0 AND ";
            }
            
            $query = chop($query, ' AND');
            $query .= ")";
            
            $this->db->setQuery($query);
            $users = $this->db->loadObjectList();
        }
        
       
        return array_column($users, 'id');
    }
    
    public function storeFieldRelationWithCalcTemp(Joomla\CMS\User\User $user, string $lang, string $value, string $relation_key) {
      
        //load array of user ids with similar rule
        $all_users_with_similar_rules = $this->loadUsersWithSimilarRules($user);
        
        //clear similar relation records for arr of users
        $this->clearOldSimilarItems($all_users_with_similar_rules, $lang, $value, $relation_key);
        
        /*$query = "SELECT * FROM " . $this->db->quoteName($this->pp_calc_relation_table) . " WHERE " . $this->db->quoteName('user_id') . " IN(". implode(',', $all_users_with_similar_rules) . ")  AND " . $this->db->quoteName('pp_field') . " = '$relation_key'"; 
        $this->db->setQuery($query);
        $rows = $this->db->loadObjectList(); */
        
       
        $query = "INSERT INTO " . $this->db->quoteName($this->pp_calc_relation_table) . " (id, user_id, pp_field, calc_field, created_at) VALUES ";    
       
        foreach($all_users_with_similar_rules as $one_user_id){
            $query .= "(null, " . $this->db->quote($one_user_id) . ", " . $this->db->quote($relation_key) . ", " . $this->db->quote($value) . ", " . $this->db->quote(date('Y-m-d H:i:s')) . "),";
        }
        $query = chop($query, ',');
        $query .= ";";
        
        $this->db->setQuery($query);	 
        $this->db->query();
        
        
        
        
        /*$count = count($rows);
        
        $item = new stdClass();
       

        if($count === 0){
            $item->id = null;
            $item->user_id = $user->id;
            $item->pp_field = $relation_key;
            $item->calc_field = $value;
            $item->created_at = date('Y-m-d H:i:s');
        
            $res = $this->db->insertObject($this->pp_calc_relation_table, $item, 'id');
            
        } elseif($count === 1){
            $item->id = $rows[0]->id;
            $item->calc_field = $value;
            $item->updated_at = date('Y-m-d H:i:s');
        
            $res = $this->db->updateObject($this->pp_calc_relation_table, $item, 'id');
            
       
        } else{
            throw new Exception(JText::_('Error while store field for relation with calculator: Error in DB'));
        }*/
        
        return $res;
    }
    
    public function storeFieldRelationWithCalc(Joomla\CMS\User\User $user, string $lang, string $value, string $relation_key) {
      
        //load array of user ids with similar rule
        $all_users_with_similar_rules = $this->loadUsersWithSimilarRules($user);
        
        //clear similar relation records for arr of users
        $this->clearOldSimilarItems($all_users_with_similar_rules, $lang, $value, $relation_key);

       
        $query = "INSERT INTO " . $this->db->quoteName($this->pp_calc_relation_table) . " (id, user_id, pp_field, calc_field, created_at) VALUES ";    
       
        foreach($all_users_with_similar_rules as $one_user_id){
            $query .= "(null, " . $this->db->quote($one_user_id) . ", " . $this->db->quote($relation_key) . ", " . $this->db->quote($value) . ", " . $this->db->quote(date('Y-m-d H:i:s')) . "),";
        }
        $query = chop($query, ',');
        $query .= ";";
        
        $this->db->setQuery($query);	 
        $this->db->query();

        return $res;
    }
    
    public function getActiveRelation(Joomla\CMS\User\User $user, string $lang, string $relation_key) {
        $query = "SELECT * FROM " . $this->db->quoteName($this->pp_calc_relation_table) . " WHERE " . $this->db->quoteName('user_id') . " = '" . $user->id . "' AND " . $this->db->quoteName('pp_field') . " = '$relation_key'"; 
        $this->db->setQuery($query);
        $rows = $this->db->loadObjectList(); 
        
        $count = count($rows);
        
        if($count > 1){
            throw new Exception(JText::_('Error while load fields for relation with calculator: Error in DB'));
        }
        
        $active_field = $rows[0]->calc_field;
        
        return $active_field;
    }
    
    public function loadRelationsBetweenCalcAndPayPeriod(int $user_id, string $lang) {
        $query = "SELECT " . $this->db->quoteName('id') . ", " . $this->db->quoteName('user_id') . ", " . $this->db->quoteName('pp_field') . ", " . $this->db->quoteName('calc_field') . " FROM " . $this->db->quoteName($this->pp_calc_relation_table) . " WHERE " . $this->db->quoteName('user_id') . " = '" . $user_id . "' ORDER BY " . $this->db->quoteName('id') . " ASC"; 
        $this->db->setQuery($query);
        $user_relations = $this->db->loadObjectList();
        
        return $user_relations;
    }
    
    public function prepareUsersListInReportHtml(array $res, string $lang, object $user, $mode = null, $open_ei = null, $u_id_get = null) {
        $url = 'calc-for-new-module';
        $html .= '';
          
        if ($this->enable_see_all_in_new_module_ei_page === 1 && $mode == 'ei') {
            if($open_ei == '1' && $u_id_get == 'all'){
                //$class = ' selected_option_active';
            }
            $html = '<div class="one_option' . $class . '" data-option-value="all">';
        
            if ($lang == 'is') {
                $link = '/is/' . $url . '?u_id=all&open_ei=1';
            } else {
                $link = '/' . $url . '?u_id=all&open_ei=1';
            }
            
            $html .= '<a href="' . $link . '"><span>' . JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_SHOW_ALL') . '</span></a>';
            $html .= '</div>';
        }
        
        foreach ($res as $one_user) {
            $username_final = $this->getFinalUsername($one_user);
          
             
            if ($lang == 'is') {
                $link = '/is/' . $url . '?u_id=' . $one_user->id;
            } else {
                $link = '/' . $url . '?u_id=' . $one_user->id;
            }
            
            if ($this->enable_see_all_in_new_module_ei_page === 1 && $mode == 'ei' /*&& $open_ei == '1' && $u_id_get != 'all'*/){
                $link .= '&open_ei=1';
            }
            unset($class);

            
            if ($user->id == $one_user->id) {
                $class = ' selected_option_active';
            } 
            
                $html .= ''
                    . '<div class="one_option' . $class . '" data-option-value="' . $one_user->id . '">'
                    . '<a href="' . $link . '"><span>' . $username_final . '</span></a>'
                    //. '<i class="fa fa-circle-thin" aria-hidden="true"></i>'
                    . '</div>';
        }

        return $html;
    }
    
    
    
    public function saveSalary(Joomla\CMS\User\User $user, string $lang, $monthly_salaries) {
       
        $query = "SELECT `id` FROM " . $this->db->quoteName($this->salary_auto_save_table) . " WHERE " . $this->db->quoteName('user_id') . " = '" . $user->id . "'"; 
        $this->db->setQuery($query);
        $rows = $this->db->loadObjectList(); 
        
        $count = count($rows);
      
        $item = new stdClass();
        
        if($count === 0){
            $item->id = null;
            $item->user_id = $user->id;
            $item->salary = strip_tags($monthly_salaries);
            $item->created_at = date('Y-m-d H:i:s');
        
            $res = $this->db->insertObject($this->salary_auto_save_table, $item);
        } elseif($count === 1){
            $item->id = $rows[0]->id;
            $item->user_id = $user->id;
            $item->salary = strip_tags($monthly_salaries);
            $item->updated_at = date('Y-m-d H:i:s');

            $res = $this->db->updateObject($this->salary_auto_save_table, $item, 'id');
        } else{
            throw new Exception(JText::_('Error while store salary: Error in DB'));
        }
    }
    
    public function getStoredSalary(Joomla\CMS\User\User $user, string $lang) {
        $query = "SELECT `salary` FROM " . $this->db->quoteName($this->salary_auto_save_table) . " WHERE " . $this->db->quoteName('user_id') . " = '$user->id' ORDER BY " . $this->db->quoteName('id') . " DESC LIMIT 0,1";
        $this->db->setQuery($query);
        $salary = $this->db->loadResult();
       
        return $salary;  
    }
    
    private function filterArrayByKeys(array $input, array $column_keys) {
        $result = array();
        $column_keys = array_flip($column_keys); // getting keys as values
        foreach ($input as $key => $val) {
            // getting only those key value pairs, which matches $column_keys
            $result[$key] = array_intersect_key($val, $column_keys);
        }
        return $result;
    }

    //temp commented
    /*public function loadLastSave(Joomla\CMS\User\User $user, string $lang) {
        // $query = "SELECT MAX(CAST(JSON_VALUE(`period`, '$.to') AS date)) AS max_date_to FROM " . $this->db->quoteName($this->eincome_new_module_table) . " WHERE " . $this->db->quoteName('user_id') . " = '$user->id' ORDER BY " . $this->db->quoteName('id') . " DESC";
        //$query = "SELECT id, MAX(CAST(JSON_VALUE(`period`, '$.to') AS date)) AS `max_date_to` FROM " . $this->db->quoteName($this->eincome_new_module_table) . " WHERE " . $this->db->quoteName('user_id') . " = '$user->id' GROUP BY `id`";
        $query = "SELECT * FROM " . $this->db->quoteName($this->eincome_new_module_table) . " WHERE " . $this->db->quoteName('user_id') . " = '$user->id' ORDER BY " . $this->db->quoteName('id') . " ASC";
        //$query = "SELECT B.* FROM (select id, MAX(CAST(JSON_VALUE(`period`, '$.to') AS date)) date from " . $this->db->quoteName($this->eincome_new_module_table) . " group by id ) A INNER JOIN " . $this->db->quoteName($this->eincome_new_module_table) . " B USING (id, MAX(CAST(JSON_VALUE(`period`, '$.to') AS date));";
        
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
       
        /*usort($data, function($a, $b) {
            $dateTimestamp1 = strtotime(json_decode($data->period)['from']);
            $dateTimestamp2 = strtotime(json_decode($data->period)['to']);

            return $dateTimestamp1 < $dateTimestamp2 ? -1: 1;
        });
        $max = $date_arr[count($date_arr) - 1];*//*
        
       // return $max;
       
        $next = [];
        $i = 0;
        foreach($data as $one_row){
            $period = json_decode($one_row->period, true);
            $to = $period['to'];
            
           
            //$next[$one_row->id]->id = $one_row->id;
            $next[$one_row->id]['period_to'] = $to;
            
            $i++;
        }
        
        //return $data;
        //return max($this->filterArrayByKeys($next, ['period_to']));
        //return array_keys($next, max(array_column((array)$next, 'period_to')));
        $max = max(array_column((array)$next, 'period_to'));
        $keys = array_keys(  [
            27=>[
            'period_to' => '2023-03-01',
            
            ],
            25=>[
            'period_to' => '2023-05-28',
            
            ]
        ], $max, true);
        
        
        return $keys;
    }*/
    
    public function loadLastSave(Joomla\CMS\User\User $user, string $lang) {
        //$query = "SELECT MAX(CAST(JSON_VALUE(`period`, '$.to') AS date)) AS max_date_to FROM " . $this->db->quoteName($this->eincome_new_module_table) . " WHERE " . $this->db->quoteName('user_id') . " = '$user->id' ORDER BY " . $this->db->quoteName('id') . " DESC";
        $query = "SELECT MAX(CAST(`timestamp_last_update` AS integer)) AS max_date_to FROM " . $this->db->quoteName($this->eincome_new_module_table) . " WHERE " . $this->db->quoteName('user_id') . " = '$user->id' ORDER BY " . $this->db->quoteName('id') . " DESC";
        $this->db->setQuery($query);
        $max_date_to = $this->db->loadResult();
        
        $column_for_select = 'timestamp_last_update';
        
        if(empty($max_date_to)){
            //throw new Exception(JText::_('Error while load last Earned income record: No records found in DB'));
            
            $query = "SELECT MAX(CAST(`timestamp_create` AS integer)) AS max_date_to FROM " . $this->db->quoteName($this->eincome_new_module_table) . " WHERE " . $this->db->quoteName('user_id') . " = '$user->id' ORDER BY " . $this->db->quoteName('id') . " DESC";
            $this->db->setQuery($query);
            $max_date_to = $this->db->loadResult();
            
            if(empty($max_date_to)){
                //throw new Exception(JText::_('Error while load last Earned income record: No records found in DB'));
                return false;
            }
            
            $column_for_select = 'timestamp_create';
        }
        
        
        //$query = "SELECT * FROM " . $this->db->quoteName($this->eincome_new_module_table) . " WHERE " . $this->db->quoteName('user_id') . " = '$user->id' AND JSON_VALUE(" . $this->db->quoteName('period') . ", '$.to') = '$max_date_to' ORDER BY " . $this->db->quoteName('id') . " DESC";
        $query = "SELECT * FROM " . $this->db->quoteName($this->eincome_new_module_table) . " WHERE " . $this->db->quoteName('user_id') . " = '$user->id' AND " . $this->db->quoteName($column_for_select) . " = '$max_date_to' ORDER BY " . $this->db->quoteName('id') . " DESC";
        $this->db->setQuery($query);
        $record = $this->db->loadObjectList();
        
        return $record[0];
    }
    
    public function deleteEarnIncomeRowNew($row_id) {
        $query = "DELETE FROM " . $this->db->quoteName($this->eincome_new_module_table) . " WHERE " . $this->db->quoteName('id') . " = '$row_id';";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    private function getAllEarnedIncomeRecordsForNewModuleWithNewTypeOfPeriod(array $from_to_arr, string $user_id) {
        //old code
        /*$from_timestamp = strtotime($from_to_arr['from']);

        $next_year_to_timestamp = date('U', strtotime($from_to_arr['from'] . ' +1year -1day'));
        $query = "SELECT * FROM " . $this->db->quoteName($this->eincome_new_module_table) . " WHERE " . $this->db->quoteName('user_id') . " = '$user->id' ORDER BY " . $this->db->quoteName('id') . " ASC";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        $final = [];

        foreach ($data as $one_row) {
            $row_pay_period = json_decode($one_row->period);

            $row_from_stamp = strtotime($row_pay_period->from);
            $row_to_stamp = strtotime($row_pay_period->to);

           
            /*if ($from_timestamp <= $row_from_stamp && $row_to_stamp <= $next_year_to_timestamp) {
                $final[] = $one_row;
            }*//*
        }*/
        /*echo '<pre>$from_to_arr';
        print_r($from_to_arr);
        echo '</pre>';*/
        
        $from_timestamp = strtotime($from_to_arr['from'] . '00:00:01');
        $to_timestamp = strtotime($from_to_arr['to'] . '23:59:59');
        
        $from_date_obj = DateTime::createFromFormat('U', $from_timestamp);
        $from_date_obj_cloned = clone $from_date_obj;
        $to_date_obj = DateTime::createFromFormat('U', $to_timestamp);
        $to_date_obj_cloned = clone $to_date_obj;
        
        $interval = new DateInterval('P1D');
        $period = new DatePeriod($from_date_obj_cloned->modify('+1day'), $interval, $to_date_obj_cloned->modify('+1day'));
        $array_of_dates_in_period = [];

        foreach($period as $date){
            $array_of_dates_in_period[] = $date->format('d.m.Y');
        }

        if($user_id === 'all'){
            $query = "SELECT * FROM " . $this->db->quoteName($this->eincome_new_module_table) . " ORDER BY " . $this->db->quoteName('id') . " ASC";
            $this->db->setQuery($query);
            $data = $this->db->loadObjectList();
        } else{
            $query = "SELECT * FROM " . $this->db->quoteName($this->eincome_new_module_table) . " WHERE " . $this->db->quoteName('user_id') . " = '$user_id' ORDER BY " . $this->db->quoteName('id') . " ASC";
            $this->db->setQuery($query);
            $data = $this->db->loadObjectList();
        }
        
        foreach ($data as $one_row) {
            $row_pay_period = json_decode($one_row->period);

            $row_from_stamp = strtotime($row_pay_period->from . '00:00:00');
            $row_to_stamp = strtotime($row_pay_period->to . '23:59:59');

            $row_from_date_obj = DateTime::createFromFormat('U', $row_from_stamp);
            $row_from_date_obj_cloned = clone $row_from_date_obj;
            $row_to_date_obj = DateTime::createFromFormat('U', $row_to_stamp);
            $row_to_date_obj_cloned = clone $row_to_date_obj;

            /*  $row_interval = new DateInterval('P1D');
                $row_period = new DatePeriod($row_from_date_obj_cloned->modify('+1day'), $row_interval, $row_to_date_obj_cloned->modify('+1day'));
                $row_array_of_dates_in_period = [];

                foreach($row_period as $date){
                $row_array_of_dates_in_period[] = $date->format('d.m.Y');
              } */
             //echo $row_from_date_obj_cloned->modify('+1day')->format('d.m.Y') . PHP_EOL;
             //echo $row_to_date_obj_cloned->modify('+1day')->format('d.m.Y') . PHP_EOL;

            if (in_array($row_from_date_obj_cloned->modify('+1day')->format('d.m.Y'), $array_of_dates_in_period) || in_array($row_to_date_obj_cloned->format('d.m.Y'), $array_of_dates_in_period)) {
                $one_row->username = $this->getFinalUsername(JFactory::getUser($one_row->user_id));
                
                $final[] = $one_row;
            }
        }
        
        return $final;
    }
    
    public function loadEarnedIncomeTableForNewModuleWithNewTypeOfPeriod(array $convert_from, string $user_id, string $lang) {
        $not_permitted_field_array = AuditControllerCalc::getNotPermittedEarnedIncomeKeys();
        $this->all_items_user = $this->getAllEarnedIncomeRecordsForNewModuleWithNewTypeOfPeriod($convert_from, $user_id);
        
        $this->totals = $this->calcEarnedIncomeTotals($this->all_items_user, $not_permitted_field_array);
        $this->count_totals = count($this->totals);
        
        $from_arr = explode('-', $convert_from['from'] );
        $global_year = $from_arr[0];

        ob_start();
        /*echo '<pre>$from_arr';
        print_r($from_arr);
        echo '</pre>';*/
        if(!empty($this->all_items_user)){?>
            <table class="table_earned_income table table-striped">
                <tbody>
                    <tr class="tr_calc_header">
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_MONTH') ?><br/><?=$global_year?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PENSION_EMPLOYED') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PRIVATE_PENS') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_COMPANY_PENS') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_COMPANY_PRIVATE_PENS') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_INSURARCE') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_UNION') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_C_UNION') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_HOLIDAY') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_INCOME_MUNIC_TAX') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_PERSONAL_TASK') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_SALARIES') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TAKE_HOME_PAY') ?></td>
                        <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TOTAL_COST') ?></td>
                        <td data-soft-remove="1"><?= JText::_('Statutory pension fund: Employee’s premium') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Statutory pension fund: Employers matching grant') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Statutory pension fund: Rehabilitation fund') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Private pension fund: Employee’s premium') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Private pension fund: Employers matching grant') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Insurance fee: General insurance fee') ?></td>
                                
                                <td data-soft-remove="1"><?= JText::_('Your personal tax allowance') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Spouses’ tax allowance') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Untapped personal tax allowance') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Untapped spouses’ tax allowance') ?></td>
                                
                                <td data-soft-remove="1"><?= JText::_('Vehicle Allowance person') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Vehicle Allowance') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Car benefit person') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Car benefit') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Food person') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Food') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Life Insurance person') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Life Insurance') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Housing person') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Housing') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Transportation Costs person') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Transportation Costs') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Physical fitness person') ?></td>
                                <td data-soft-remove="1"><?= JText::_('Physical fitness') ?></td>
                               
                                <td></td>
                                <td></td>
                    </tr> 
                    <?php $i=0; foreach($this->all_items_user as $one_row){?>
                        <tr>
                            <?php
                                $row_pay_period = json_decode($one_row->period); 
                                
                                $from = date('d.m', strtotime($row_pay_period->from));
                                $to = date('d.m', strtotime($row_pay_period->to));
                                
                                $row_from_stamp = strtotime($row_pay_period->from . '00:00:00');
                                $row_to_stamp = strtotime($row_pay_period->to . '23:59:59');
                                
                                $from_date_obj = DateTime::createFromFormat('U', $row_from_stamp);
                                $from_date_obj_cloned = clone $from_date_obj;
                                $to_date_obj = DateTime::createFromFormat('U', $row_to_stamp);
                                $to_date_obj_cloned = clone $to_date_obj;
                                
                                $from_date_obj_cloned->modify('+1day');
                            ?>
                                <td>
                                    <?=$from.' - '.$to?>
                                    <?='<br/><strong>' . $one_row->username . '</strong>';?>
                                </td>
                                <?php foreach($one_row as $k=>$v){?>
                                    <?php if(!in_array($k, $not_permitted_field_array)){?>
                                        <td class="js_event_td_calc" data-k="<?=$k?>"><?=$this->floatToStrCalcTrue($v)?></td>
                                    <?php } ?>                                  
                                <?php
                                    } 
                                    $calc_link = '/calc-for-new-module';
                                   
                                ?>
                                <td class="earned_income_plus"><a href="<?=$calc_link?>?u_id=<?=$one_row->user_id?>&ein_id=<?=$one_row->id?>&from_p=<?=$from_date_obj_cloned->format('d.m.Y')?>&to_p=<?=$to_date_obj->format('d.m.Y')?>"><i class="fa fa-plus" aria-hidden="true"></i></a></td>
                                <td><div class="delete_table_row" id="row_id-<?=$one_row->id?>"><i class="fa fa-window-close" aria-hidden="true"></i></div></td>
                        </tr>
                        <?php $i++; } ?>
                        <tr>
                            <td><?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_TABLE_TOTAL') ?></td>
                            <?php foreach($this->totals[$this->count_totals-1] as $k=>$v){?>
                                <td class="js_event_td_earned_income_total" data-k="<?=$k?>"><?=$this->floatToStrCalcTrue($v)?></td>
                            <?php } ?>
                            <td></td>
                            <td></td>
                        </tr>
                </tbody>
            </table>
            <?php
        } else{?> 
            <div class="alert alert-info alert-custom-0">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <div class="alert_info">
                    <?= JText::_('COM_AUDIT_CALC_EARNED_INCOME_NO_DATA') ?>   
                </div>
            </div>
        <?php }
        $html=ob_get_contents();
          
        ob_end_clean(); 
        return $html;
    }
    
}