<?php

// No direct access
defined('_JEXEC') or die;

/**
 * Controller
 * @author 
 */
class AuditControllerTime_Wages extends JControllerLegacy {

    public function setLimitOfUsers() {
        $app = JFactory::getApplication();
        $lang = $app->input->getString('lang0');
        $value = abs($app->input->getInt('value'));
        
        try {
            $data['errors'] = "";

            if (!JSession::checkToken('request')) {//new correct checking token
                throw new Exception(JText::_('COM_AUDIT_NEW_SET_LIMIT_OF_USERS_ERROR_INVALID_FORM_TOKEN'));
            } if (empty($lang)) {
                throw new Exception(JText::_('COM_AUDIT_NEW_SET_LIMIT_OF_USERS_ERROR_EMPTY_LANG'));
            } 

            JLoader::register('AuditModelTime_Wages', JPATH_ROOT . '/components/com_audit/models/time_wages.php');
            $model = JModelLegacy::getInstance('Time_Wages', 'AuditModel');

            $res = $model->setLimitOfUsers($lang, $value);

            $data['res'] = $res;
            $data['value'] = $value; //necessary
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }

        echo json_encode($data);

        JFactory::getApplication()->close();
    }
    
    public function setDisableSubscription()
    {
        $app = JFactory::getApplication();
        $lang = $app->input->getString('lang0');
        $value = $app->input->getString('value');
        
        try {
            $data['errors'] = "";

            if (!JSession::checkToken('request')) {//new correct checking token
                throw new Exception(JText::_('COM_AUDIT_NEW_SET_COMPANY_SUBSCRIPTION_ERROR_INVALID_FORM_TOKEN'));
            } if (empty($lang)) {
                throw new Exception(JText::_('COM_AUDIT_NEW_SET_COMPANY_SUBSCRIPTION_ERROR_EMPTY_LANG'));
            } 

            JLoader::register('AuditModelTime_Wages', JPATH_ROOT . '/components/com_audit/models/time_wages.php');
            $model = JModelLegacy::getInstance('Time_Wages', 'AuditModel');

            $res = $model->setDisableSubscription($lang, $value);

            $data['res'] = $res;
            $data['value'] = $value; 
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }

        echo json_encode($data);

        JFactory::getApplication()->close();
    }

}
