<?php

// No direct access
defined('_JEXEC') or die;

/**
 * Controller
 * @author 
 */
class AuditControllerTask_manager extends JControllerLegacy {

    public function attachTaskToDevicesnTools() {
        $app = JFactory::getApplication();
        $lang = $app->input->getString('lang0');
        $task_id = $app->input->getInt('task_id');
        $mode = $app->input->getString('mode');

        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }

        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('COM_AUDIT_NEW_TASK_MANAGER_UNICONTA_TASKS_ORDER_ERROR_INVALID_FORM_TOKEN'));
            } if (empty($lang)) {
                throw new Exception(JText::_('COM_AUDIT_NEW_TASK_MANAGER_UNICONTA_TASKS_ORDER_ERROR_EMPTY_LANG'));
            } if (empty($task_id)) {
                throw new Exception(JText::_('COM_AUDIT_NEW_TASK_MANAGER_UNICONTA_TASKS_ORDER_ERROR_EMPTY_TASK_ID'));
            }

            //JLoader::register('AuditModelTask_manager', JPATH_ROOT . '/components/com_audit/models/task_manager.php');
            $model_task_manager = JModelLegacy::getInstance('Task_manager', 'AuditModel');

            $res = $model_task_manager->attachTaskToDevicesnTools($lang, $task_id, $mode);
            $html = $model_task_manager->loadTaskListNewPsd($lang);

            $data = [
                'res' => $res,
                'html' => $html,
                'mode' => $mode
            ];
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }

        echo json_encode($data);
        JFactory::getApplication()->close();
    }
    
    public function storeGpsRadius() {
        $app = JFactory::getApplication();
        $lang = $app->input->getString('lang0');
        $radius = $app->input->getInt('radius');
     

        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }

        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error saving radius: Invalid security token. Reload page please'));
            } if (empty($lang)) {
                throw new Exception(JText::_('Error saving radius: Empty lang'));
            } if ($radius > 10000) {
                throw new Exception(JText::_('Error saving radius: Enter a number <= 10000'));
            }

            //JLoader::register('AuditModelTask_manager', JPATH_ROOT . '/components/com_audit/models/task_manager.php');
            $model_task_manager = JModelLegacy::getInstance('Task_manager', 'AuditModel');

            $res = $model_task_manager->storeGpsRadius($lang, $radius);
            

            $data = [
                'res' => $res,
               
            ];
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }

        echo json_encode($data);
        JFactory::getApplication()->close();
    }

    public function setTaskTypeAsGps() {
        $app = JFactory::getApplication();
        $lang = $app->input->getString('lang0');
        $task_id = $app->input->getInt('task_id');
        $mode = $app->input->getString('mode');

        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }

        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error when setting task as gps: Invalid security token. Reload page please'));
            } if (empty($lang)) {
                throw new Exception(JText::_('Error when setting task as gps: Empty lang'));
            } if (empty($task_id)) {
                throw new Exception(JText::_('Error when setting task as gps: Empty task id'));
            }

            //JLoader::register('AuditModelTask_manager', JPATH_ROOT . '/components/com_audit/models/task_manager.php');
            $model_task_manager = JModelLegacy::getInstance('Task_manager', 'AuditModel');
            $res = $model_task_manager->setTaskTypeAsGps($lang, $task_id, $mode);
            

            $data = [
                'res' => $res
            ];
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }

        echo json_encode($data);
        JFactory::getApplication()->close();
    }
    
    public function storeGpsTaskPlace() {
        $app = JFactory::getApplication();
        $lang = $app->input->getString('lang0');
        $task_id = $app->input->getInt('task_id');
        $place = $app->input->getString('place');
        $lat = $app->input->getFloat('lat');
        $lng = $app->input->getFloat('lng');
        
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }

        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error when saving location and coordinates: Invalid security token. Reload page please'));
            } if (empty($lang)) {
                throw new Exception(JText::_('Error when saving location and coordinates: Empty lang'));
            } if (empty($task_id)) {
                throw new Exception(JText::_('Error when saving location and coordinates: Empty task id'));
            } if(empty($lat)){
                throw new Exception(JText::_('Error when saving location and coordinates: Empty lat'));
            } if(empty($lng)){
                throw new Exception(JText::_('Error when saving location and coordinates: Empty lng'));
            } if(empty($place)){
                throw new Exception(JText::_('Error when saving location and coordinates: Empty place name'));
            }

            //JLoader::register('AuditModelTask_manager', JPATH_ROOT . '/components/com_audit/models/task_manager.php');
            $model_task_manager = JModelLegacy::getInstance('Task_manager', 'AuditModel');
            $res = $model_task_manager->storeGpsTaskPlace($lang, $task_id, $place, $lat, $lng);
            

            $data = [
                'res' => $res
            ];
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }

        echo json_encode($data);
        JFactory::getApplication()->close();
    }
    
    public function getTaskAddressesForMap() {
        $app = JFactory::getApplication();
        $lang = $app->input->getString('lang0');
        
        
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }

        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error when loading addresses: Invalid security token. Reload page please'));
            } if (empty($lang)) {
                throw new Exception(JText::_('Error when loading addresses: Empty lang'));
            } 

            //JLoader::register('AuditModelTask_manager', JPATH_ROOT . '/components/com_audit/models/task_manager.php');
            $model_task_manager = JModelLegacy::getInstance('Task_manager', 'AuditModel');
            $res = $model_task_manager->getTaskAddressesForMap($lang);
            

            $data = $res;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }

        echo json_encode($data);
        JFactory::getApplication()->close();
    }
    
    public function seAutoClockInTask() {
        $app = JFactory::getApplication();
        $lang = $app->input->getString('lang0');
        $task_id = $app->input->getInt('task_id');
        $mode = $app->input->getString('mode');

        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }

        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error saving auto clock in: Invalid security token. Reload page please'));
            } if (empty($lang)) {
                throw new Exception(JText::_('Error saving auto clock in: Empty lang'));
            } if (empty($task_id)) {
                throw new Exception(JText::_('Error saving auto clock in: Empty task id'));
            }

            //JLoader::register('AuditModelTask_manager', JPATH_ROOT . '/components/com_audit/models/task_manager.php');
            $model_task_manager = JModelLegacy::getInstance('Task_manager', 'AuditModel');
            $res = $model_task_manager->seAutoClockInTask($lang, $task_id, $mode);
            

            $data = [
                'res' => $res
            ];
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }

        echo json_encode($data);
        JFactory::getApplication()->close();
    }
}
