<?php
// No direct access
defined( '_JEXEC' ) or die;
jimport( 'joomla.application.module.helper' );

class AuditControllerSubscription extends JControllerLegacy  {
    private $db;
    protected $default_view = 'default';        
    protected $model  =  null;
    

    
    public function __construct(array $config = array()) {
        parent::__construct($config);
        $this->db   =   JFactory::getDBO();        
        $this->model = JModelLegacy::getInstance('subscription', 'AuditModel');
    }    
    
    /**
     * index.php?option=com_audit&task=subscription.index
     */
    
    public function display()  {
        
        //var_dump($this->model->getAccessToken());
        //exit;
        //$view  =  $this->getView("offers","html");
        //$view->clients = $this->getClients();
        //$view->setLayout('default');
        //$view->display();
    }
    
    
    public function success()  {
        $id                 =   intval(JRequest::getVar('id',"0"));
        $subscription_id    =   trim(JRequest::getVar('subscription_id',""));        
        $params  =  array(
            'subscription'=>1,
        );
        try {
            $subscription = $this->model->confirmSubscription($id,$subscription_id);
            if(empty($subscription) || $subscription->status != 1) {
                throw new Exception("Can't approve Subscription");
            }
        } catch (\Exception $e) {
            $params['error'] = 1;
            $params['message'] =    JText::sprintf('COM_AUDIT_SETTINGS_NEW_SUBSCR_ERROR');
        }
        $app = JFactory::getApplication();        
        //$app->redirect("/settings-new?subscription-approva=1");
        $app->redirect("/settings-new?". http_build_query($params));
        JFactory::getApplication()->close();
    }
    
    public function cancel()  {
        $params  =  array(
            'subscription'=>1,
        );
        $app = JFactory::getApplication();
        $params['error'] = 1;
        $params['message'] =    JText::sprintf('COM_AUDIT_SETTINGS_NEW_SUBSCR_CANCELED');
        //$app->redirect("/settings-new?canceled=1"JRoute::_('index.php?option=com_config&controller=config.display.templates', false), $message, 'error');
        $app->redirect("/settings-new?". http_build_query($params), $message, 'error');
        JFactory::getApplication()->close();
    }
    
    
    public function submit()  {
        header('Content-Type: application/json');
        $data  =  array('status'=>0,'message'=>"");        
        $data['ApprovalLink']   =   "";
        try {
            $subscriptionObj  =  new stdClass();
            
            $plans   =   (array) JRequest::getVar('plan',array());
            if(empty($plans)) 
                $plans  =  array();

            
            $user = JFactory::getUser();
            if(empty($user))
                throw new Exception("You must login first.");
            if ($user->guest) {
                Exception('You must login first.');
            }
            if(empty($user))
                throw new Exception("Error auth");
                
            $subscriptionObj->user_id   =   $user->owner_id;
            $subscriptionObj->company   =   $user->company;
            
            $plansText  =  array();
            foreach ($plans as $key=>$plan) {
                if(isset($plan['checked'])) {
                    $plansText[]    =   $plan['label'];
                    $subscriptionObj->$key  =   1;
                }
            }
            if(empty($plansText)) {
                throw new Exception("Please select plan.");
            }
            
            $subscriptionObj->plan      = $_SERVER['HTTP_HOST'].": ".  join(", ",$plansText);
            $subscriptionObj->discount  = number_format(floatval(JRequest::getVar('discount',0)),2,'.','');
            $subscriptionObj->price     = number_format(floatval(JRequest::getVar('price',0)),2,'.','');
            $subscriptionObj->total     = number_format(floatval(JRequest::getVar('total',0)),2,'.','');
            $subscriptionObj->subscr_users  = intval(JRequest::getVar('users',0));
            
            $subscription   =   $this->model->submitSubscription($subscriptionObj);
            if(!empty($subscription)) {
                if($subscription->status == "APPROVAL_PENDING") {
                    foreach ($subscription->links as $link) {
                        if($link->rel == "approve") {
                            $data['ApprovalLink']   = $link->href;
                        }
                    }
                }
            }
            $data['status']     =   1;
            $data['message']    =   "";
            
        } catch (Exception $e) {
            $data['status']     =   0;
            $data['message']    =   $e->getMessage();
            $data['ApprovalLink']   =   "";
        }
        
                
        echo json_encode($data,JSON_PRETTY_PRINT);
        JFactory::getApplication()->close();
    }
    
    
}