<?php
// No direct access
defined( '_JEXEC' ) or die;

/**
 * Controller
 * @author 
 */
class AuditControllerRules extends JControllerLegacy{
    
   public function prefillRule()
   {
        $app = JFactory::getApplication();
        $lang = $app->input->getString('lang0');
        $rule_id = $app->input->getInt('rule_id');
        $type_of_rule = $app->input->getString('type_of_rule');
        $value = $app->input->getInt('value');
        $subrules_id = $app->input->getInt('subrules_id');
        
        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('COM_AUDIT_NEW_PREFILL_UNION_RULE_ERROR_INVALID_FORM_TOKEN'));
            } if(empty($lang)){
                throw new Exception(JText::_('COM_AUDIT_NEW_PREFILL_UNION_RULE_ERROR_EMPTY_LANG'));
            } if(empty($rule_id)){
                throw new Exception(JText::_('COM_AUDIT_NEW_PREFILL_UNION_RULE_ERROR_EMPTY_RULE_ID'));
            } if(empty($type_of_rule)){
                throw new Exception(JText::_('COM_AUDIT_NEW_PREFILL_UNION_RULE_ERROR_EMPTY_TYPE_OF_RULE'));
            } if(empty($value)){
                throw new Exception(JText::_('COM_AUDIT_NEW_PREFILL_UNION_RULE_ERROR_EMPTY_VALUE'));
            } if(empty($subrules_id)){
                throw new Exception(JText::_('COM_AUDIT_NEW_PREFILL_UNION_RULE_ERROR_EMPTY_SUBRULES_ID'));
            }
            
            JLoader::register('AuditModelRules', JPATH_ROOT . '/components/com_audit/models/rules.php');
            $model = JModelLegacy::getInstance('Rules', 'AuditModel');
          
            $res = $model->prefillRule($lang, $rule_id, $type_of_rule, $value, $subrules_id);
          
            $data['res'] = $res;
            $data['value'] = $value;//necessary
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }  

        echo json_encode($data);
        
        JFactory::getApplication()->close();
   }
}