<?php

// No direct access
defined('_JEXEC') or die;

/**
 * Controller
 * @author 
 */
class AuditControllerReseller extends JControllerLegacy {

    public function __construct() {
        parent::__construct();
        $this->user = & JFactory::getUser();
        $this->app = JFactory::getApplication();
        $this->db = & JFactory::getDBO();
    }
    
    private function validateDate($date, $format = 'Y-m-d H:i:s') {
        $d = DateTime::createFromFormat($format, $date);
        return $d && $d->format($format) == $date;
    }
    
    public function checkResellerData() {
        
        $login = $this->app->input->getUsername('login');
        $password = trim($_REQUEST['password']);
        $lang = $this->app->input->getString('lang');
        
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS'; 
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }

        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error while check reseller data: Invalid security token. Pls., reload page'));
            } if (empty($login)) {
                throw new Exception(JText::_('Error while check reseller data: Empty login'));
            } if(empty($password)){
                throw new Exception(JText::_('Error while check reseller data: Empty password'));
            }

            JLoader::register('AuditModelReseller', JPATH_ROOT . '/components/com_audit/models/reseller.php');
            $model = JModelLegacy::getInstance('Reseller', 'AuditModel');
            $res = $model->checkResellerData($login, $password);
           
            $data['res'] = $res;
            //$data['passw'] = $password;
            //$data['login'] = $login;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 
            
        echo json_encode($data); 
        JFactory::getApplication()->close();
    }
    
    public function updateCompanies() {
       
        
        JLoader::register('CtapiModelApi', JPATH_ADMINISTRATOR . '/components/com_ctapi/models/api.php');
        $model = JModelLegacy::getInstance('Api', 'CtapiModel');
            
        $companies_new = (array) JRequest::getVar('company', array());
        $mods  = $model->allMods();
        if(empty($companies_new))
            $companies_new  =  array();        
        $companies =  $model->getCompanies(0);
        foreach ($companies as $company=>$arr) {
            foreach ($arr as $m=>$v) {
                $companies[$company][$m] = 0;
            }
        }
        foreach ($companies_new as $company=>$arr) {
            foreach ($arr as $m=>$v) {
                if(isset($companies[$company]))
                    $companies[$company][$m] = intval($v);
            }            
        }
        $model->resetCompanies();
        foreach ($companies as $company=>$mods) {
            foreach ($mods as $m=>$v) {
                $obj  =  new stdClass();
                $obj->company   =   $company;
                $obj->mod       =   $m;
                $obj->enabled   =   intval($v);                
                $this->db->insertObject($model->companyModsTableName,$obj, 'id');
            }
        }
        
        //$this->setRedirect(\Joomla\CMS\Router\Route::_('index.php?option=com_audit&view=company_mods'));
        $this->setRedirect('/' . $this->app->input->getString('lang0') . '/reseller');
    }
    
    public function getStoredUsersTotal() {
        $lang = $this->app->input->getString('lang0');
        $date = $this->app->input->getString('date');
        $css_class = $this->app->input->getString('class');
        
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS'; 
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }

        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error while get stored total: Invalid security token. Pls., reload page'));
            } if (empty($lang)) {
                throw new Exception(JText::_('Error while get stored total: Empty lang'));
            } if((!empty($date) && $this->validateDate($date, 'd.m.Y') === false) || empty($date)){
                throw new Exception(JText::_('Error while get stored total: Incorrect date'));
            } if(empty($css_class)){
                throw new Exception(JText::_('Error while get stored total: Empty class'));
            }

            JLoader::register('AuditModelReseller', JPATH_ROOT . '/components/com_audit/models/reseller.php');
            $model = JModelLegacy::getInstance('Reseller', 'AuditModel');
            $res = $model->getStoredUsersTotal($lang, $date, $css_class);
           
            $data['res'] = $res; 
            
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 
            
        echo json_encode($data); 
        JFactory::getApplication()->close();
    }

    public function storeDefaultPrice() {
        $lang = $this->app->input->getString('lang0');
        $date = $this->app->input->getString('date');
        $val = $this->app->input->getString('val');
        
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS'; 
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }

        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error while store default price: Invalid security token. Pls., reload page'));
            } if (empty($lang)) {
                throw new Exception(JText::_('Error while store default price: Empty lang'));
            } if((!empty($date) && $this->validateDate($date, 'd.m.Y') === false) || empty($date)){
                throw new Exception(JText::_('Error while store default price: Incorrect date'));
            } if(empty($val)){
                throw new Exception(JText::_('Error while store default price: Empty price value'));
            }

            JLoader::register('AuditModelReseller', JPATH_ROOT . '/components/com_audit/models/reseller.php');
            $model = JModelLegacy::getInstance('Reseller', 'AuditModel');
            $res = $model->storeDefaultPrice($lang, $date, $val);
           
            $data['res'] = $res; 
            
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 
            
        echo json_encode($data); 
        JFactory::getApplication()->close();
    }
}
