<?php

// No direct access
defined('_JEXEC') or die;

/**
 * Controller
 * @author 
 */
class AuditControllerGps extends JControllerLegacy {

    public function __construct() {
        parent::__construct();
        $this->user = & JFactory::getUser();
        
        
    }
    
    private function validateDate($date, $format = 'Y-m-d H:i:s') {
        $d = DateTime::createFromFormat($format, $date);
        return $d && $d->format($format) == $date;
    }
    
    public function loadGpsPage() {
        $app = JFactory::getApplication();
        $lang = $app->input->getString('lang0');
        $date = $app->input->getString('date');
        $from = $app->input->getString('from');
        $to = $app->input->getString('to');
        /*echo '<pre>';
        print_r($_REQUEST);
        echo '</pre>';*/
        try {
            $data['errors'] = "";
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('COM_AUDIT_TASK_MANAGER_NEW_LOAD_GPS_PAGE_ERROR_INVALID_FORM_TOKEN'));
            } if(empty($lang)){
                throw new Exception(JText::_('COM_AUDIT_TASK_MANAGER_NEW_LOAD_GPS_PAGE_ERROR_EMPTY_LANG'));
            } /*if(!empty($date) && empty($from) && empty($to) && $this->validateDate($date, 'Y-m-d') === false){
                throw new Exception(JText::_('COM_AUDIT_TASK_MANAGER_NEW_LOAD_GPS_PAGE_ERROR_INVALID_DATE'));
            } if((empty($date) && !empty($from) && !empty($to)) && ($this->validateDate($from, 'd.m.Y') === false) || $this->validateDate($to, 'd.m.Y') === false){
                throw new Exception(JText::_('COM_AUDIT_TASK_MANAGER_NEW_LOAD_GPS_PAGE_ERROR_INVALID_FROM_OR_TO'));
            }*/
            if(!empty($date)){
                if(empty($from) && empty($to)){
                    if($this->validateDate($date, 'Y-m-d') === false){
                        throw new Exception(JText::_('COM_AUDIT_TASK_MANAGER_NEW_LOAD_GPS_PAGE_ERROR_INVALID_DATE'));
                    }
                } else{
                    if($this->validateDate($from, 'd.m.Y') === false || $this->validateDate($to, 'd.m.Y') === false){
                        throw new Exception(JText::_('COM_AUDIT_TASK_MANAGER_NEW_LOAD_GPS_PAGE_ERROR_INVALID_FROM_OR_TO'));
                    }
                  
                }
            }
            //JLoader::register('AuditModelTask_manager', JPATH_ROOT . '/components/com_audit/models/task_manager.php');
            //$model_task_manager = JModelLegacy::getInstance('Task_manager', 'AuditModel');
           
           
       
            $view = $this->getView("gps_task_manager", "html");
            $view->assignRef('date', $date);
            $view->assignRef('from', $from);
            $view->assignRef('to', $to);
            
            
            $view->setLayout('default');
            $view->display();
        
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
            echo json_encode($data);
        }
        
        JFactory::getApplication()->close();
    }
    
    public function addRoute() {
        $app = JFactory::getApplication();
        $lang = $app->input->getString('lang0');
        $user_id = $app->input->getInt('user_id');
        $date = $app->input->getString('date');
        
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }

        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('COM_AUDIT_TASK_MANAGER_NEW_DEVICES_N_TOOLS_PAGE_ADD_NEW_ROUTE_ERROR_INVALID_FORM_TOKEN'));
            } if (empty($lang)) {
                throw new Exception(JText::_('COM_AUDIT_TASK_MANAGER_NEW_DEVICES_N_TOOLS_PAGE_ADD_NEW_ROUTE_ERROR_EMPTY_LANG'));
            } if (empty($user_id)) {
                throw new Exception(JText::_('COM_AUDIT_TASK_MANAGER_NEW_DEVICES_N_TOOLS_PAGE_ADD_NEW_ROUTE_ERROR_EMPTY_USER_ID'));
            } if(!empty($date) && $this->validateDate($date, 'Y-m-d') === false){
                throw new Exception(JText::_('COM_AUDIT_TASK_MANAGER_NEW_DEVICES_N_TOOLS_PAGE_ADD_NEW_ROUTE_ERROR_INCORRECT_DATE'));
            }

          
            $model = JModelLegacy::getInstance('Gps', 'AuditModel');

            $res = $model->addRoute($lang, $user_id, $date);
            /*echo '<pre>';
            print_r($_REQUEST);
            echo '</pre>';*/
            $html = file_get_contents(self::loadGpsPage());

            $data = [
                'res' => $res,
                'html' => $html,
               
            ];
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }

        echo json_encode($data);
        JFactory::getApplication()->close();
    }
    
    public function getUsersList() {
        $app = JFactory::getApplication();
        $user_id = $app->input->getString('u_id');
        $lang = $app->input->getString('lang');
        $mode = $app->input->getString('mode');
        
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS'; 
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }
        
        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('COM_AUDIT_TASK_MANAGER_NEW_DEVICES_N_TOOLS_PAGE_GET_USER_LIST_ERROR_INVALID_FORM_TOKEN'));
            } if (empty($lang)) {
                throw new Exception(JText::_('COM_AUDIT_TASK_MANAGER_NEW_DEVICES_N_TOOLS_PAGE_GET_USER_LIST_ERROR_LANG'));
            } if(empty($user_id)){
                throw new Exception(JText::_('COM_AUDIT_TASK_MANAGER_NEW_DEVICES_N_TOOLS_PAGE_GET_USER_LIST_ERROR_USER_ID'));
            }

            $user = JFactory::getUser($user_id);
            
            JLoader::register('AuditModelCalc', JPATH_ROOT . '/components/com_audit/models/registered_users.php');
            $model = JModelLegacy::getInstance('Registered_Users', 'AuditModel');

            $res = $model->getUsersListInPayPeriod($user, $lang);
            if(empty($res)){
                throw new Exception(JText::_('COM_AUDIT_TASK_MANAGER_NEW_DEVICES_N_TOOLS_PAGE_GET_USER_LIST_ERROR_EMPTY_LIST'));
            }
            $model_gps = JModelLegacy::getInstance('Gps', 'AuditModel');
            $html = $model_gps->prepareUsersListInReportHtml($res, $lang, $user, $mode);
            
            //$data['mode'] = $mode;
            $data['res'] = $res;
            $data['html'] = $html;
          
            //$data['request'] = $_REQUEST;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 
            
        echo json_encode($data); 
        JFactory::getApplication()->close();
    }

    public function addColumn() {
        $app = JFactory::getApplication();
        $column_type = $app->input->getString('column_type');
        $lang = $app->input->getString('lang');
        $user_id = $app->input->getInt('user_id');

        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS'; 
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }
        
        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_ADD_COLUMN_ERROR_INVALID_FORM_TOKEN'));
            } if (empty($lang)) {
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_ADD_COLUMN_ERROR_LANG'));
            } if(empty($column_type)){
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_ADD_COLUMN_ERROR_COLUMN_TYPE'));
            } if(empty($user_id)){
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_ADD_COLUMN_ERROR_USER_ID'));
            }

            $user = JFactory::getUser($user_id);
            if($user->owner_id != $this->user->owner_id){
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_ADD_COLUMN_ERROR_PERMISSION'));
            }
            $model = JModelLegacy::getInstance('Gps', 'AuditModel');

            $res = $model->addColumn($lang, $user_id, $column_type);
            $html = file_get_contents(self::loadGpsPage());

            $data = [
                'res' => $res,
                'html' => $html,
               
            ];
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 
            
        echo json_encode($data); 
        JFactory::getApplication()->close();
    }
    
    public function removeColumn() {
        $app = JFactory::getApplication();
        $column_type = $app->input->getString('type');
        $lang = $app->input->getString('lang');
        $user_id = $app->input->getInt('user_id');
        $val = $app->input->getString('val');
        
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS'; 
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }
        
        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_REMOVE_COLUMN_ERROR_INVALID_FORM_TOKEN'));
            } if (empty($lang)) {
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_REMOVE_COLUMN_ERROR_LANG'));
            } if(empty($column_type)){
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_REMOVE_COLUMN_ERROR_COLUMN_TYPE'));
            } if(empty($user_id)){
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_REMOVE_COLUMN_ERROR_USER_ID'));
            } if(empty($val)){
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_REMOVE_COLUMN_ERROR_VALUE'));
            } 
            
            $val_arr = explode('-', $val);
            if($val_arr[0] != 'custom_column_visibility'){
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_REMOVE_COLUMN_ERROR_INCORRECT_VALUE'));
            }

            $user = JFactory::getUser($user_id);
            if($user->owner_id != $this->user->owner_id){
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_REMOVE_COLUMN_ERROR_PERMISSION'));
            }
            $model = JModelLegacy::getInstance('Gps', 'AuditModel');

            $res = $model->removeColumn($lang, $user_id, $column_type, $val);
            $html = file_get_contents(self::loadGpsPage());

            $data = [
                'res' => $res,
                'html' => $html
            ];
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 
            
        echo json_encode($data); 
        JFactory::getApplication()->close();
    }
    
    public function editColumn() {
        $app = JFactory::getApplication();
        $column_type = $app->input->getString('type');
        $lang = $app->input->getString('lang');
        $user_id = $app->input->getInt('user_id');
        $val = strip_tags($app->input->getString('val'));
        $name = strip_tags($app->input->getString('name'));
        
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS'; 
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }
        
        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EDIT_COLUMN_ERROR_INVALID_FORM_TOKEN'));
            } if (empty($lang)) {
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EDIT_COLUMN_ERROR_LANG'));
            } if(empty($column_type)){
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EDIT_COLUMN_ERROR_COLUMN_TYPE'));
            } if(empty($user_id)){
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EDIT_COLUMN_ERROR_USER_ID'));
            } if(empty($val)){
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EDIT_COLUMN_ERROR_VALUE'));
            } if(empty($name)){
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EDIT_COLUMN_ERROR_COLUMN_NAME'));
            }
            
            $val_arr = explode('-', $val);
            if($val_arr[0] != 'custom_column_name'){
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EDIT_COLUMN_ERROR_INCORRECT_VALUE'));
            }

            $user = JFactory::getUser($user_id);
            if($user->owner_id != $this->user->owner_id){
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_REMOVE_COLUMN_ERROR_PERMISSION'));
            }
            $model = JModelLegacy::getInstance('Gps', 'AuditModel');

            $res = $model->editColumn($lang, $user_id, $column_type, $val, $name);
            $html = file_get_contents(self::loadGpsPage());

            $data = [
                'res' => $res,
                'html' => $html
            ];
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 
            
        echo json_encode($data); 
        JFactory::getApplication()->close();
    }
    
    public function attachTaskToRoute() {
        $app = JFactory::getApplication();
        $lang = $app->input->getString('lang0');
        $user_id = $app->input->getInt('user_id');
        $task_text = strip_tags($app->input->getString('task_text'));
        $route_id = $app->input->getInt('route_id');
        
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }

        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_LOAD_TASK_SELECT_ERROR_INVALID_FORM_TOKEN'));
            } if (empty($lang)) {
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_LOAD_TASK_SELECT_ERROR_EMPTY_LANG'));
            } if (empty($user_id)) {
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_LOAD_TASK_SELECT_ERROR_EMPTY_USER_ID'));
            } if(empty($task_text)){
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_LOAD_TASK_SELECT_ERROR_EMPTY_TASK_TEXT'));
            } if(empty($route_id)){
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_LOAD_TASK_SELECT_ERROR_EMPTY_ID'));
            }
            
            $user = JFactory::getUser($user_id);
            if($user->owner_id != $this->user->owner_id){
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_LOAD_TASK_SELECT_ERROR_PERMISSION'));
            }
            
          
            $model = JModelLegacy::getInstance('gps', 'AuditModel');
            $res = $model->attachTaskToRoute($lang, $user_id, $task_text, $route_id);
           

            $data = [
                'res' => $res
            ];
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }

        echo json_encode($data);
        JFactory::getApplication()->close();
    }
    
    public function editRoute() {
        $app = JFactory::getApplication();
        $lang = $app->input->getString('lang0');
        $user_id = $app->input->getInt('user_id');
        $type = $app->input->getString('type');
        $cell_name = $app->input->getString('cell_name');
        $value = strip_tags($app->input->getString('value'));
        $route_id = $app->input->getInt('route_id');
        
        $pp_id = $app->input->getInt('pp_id');
        $confirm_id = $app->input->getInt('confirm_id');
        $row_date = $app->input->getString('row_date');
        
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS'; 
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }
        
        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EDIT_ROUTE_ERROR_INVALID_FORM_TOKEN'));
            } if (empty($lang)) {
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EDIT_ROUTE_ERROR_LANG'));
            } if(empty($user_id)){
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EDIT_ROUTE_ERROR_USER_ID'));
            } if(empty($cell_name)){
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EDIT_ROUTE_ERROR_CELL_NAME'));
            } if(empty($route_id)){
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EDIT_ROUTE_ERROR_ID'));
            } if(in_array($cell_name, ['clock_in', 'clock_out', 'total']) && !empty($row_date) && $this->validateDate($row_date, 'd.m.Y') === false){
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EDIT_ROUTE_ERROR_ROW_DATE'));
            }
            
            if($type === 'number_box'){
                JLoader::register('AuditModelRules', JPATH_ROOT . '/components/com_audit/models/rules.php');
                $model_rules = JModelLegacy::getInstance('Rules', 'AuditModel');
                $autocompleted_value = $model_rules->autocompletion($value);
            
                if(!empty($autocompleted_value) && $this->validateDate($autocompleted_value, 'H:i') === false){
                    throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EDIT_ROUTE_ERROR_VALUE'));
                }
            } elseif($type === 'text'){
                $autocompleted_value = $value;
            } elseif($type === 'numbers_only'){
                $autocompleted_value = (int)$value;
            } elseif($type === 'coordinates'){
                $autocompleted_value = $value;
            }
            
            $user = JFactory::getUser($user_id);
            $manager_obj = JFactory::getUser($user->owner_id);
            
            if($user->owner_id != $this->user->owner_id){
                throw new Exception(JText::_('COM_AUDIT_DEVICES_N_TOOLS_PAGE_EDIT_ROUTE_ERROR_PERMISSION'));
            }
            $model = JModelLegacy::getInstance('Gps', 'AuditModel');

            $res = $model->editRoute($lang, $user_id, $type, $cell_name, $autocompleted_value, $route_id);
            if(!empty($pp_id) && $res === true && in_array($cell_name, ['clock_in', 'clock_out', 'total'])){
                $sync_res = $model->syncValueWithTimesheet($autocompleted_value, $user_id, $route_id, $pp_id, $row_date, $cell_name);
                $sync_type = 'pp_and_confirm';
            } elseif(!empty($confirm_id) && $manager_obj->combine_confirm_and_pp == 0){
                $sync_res = $model->syncValueWithConfirmOnly($autocompleted_value, $user_id, $route_id, $confirm_id, $row_date, $cell_name);
                $sync_type = 'confirm_only';
            }
            if(in_array($cell_name, ['clock_in', 'clock_out'])){
                $total = $model->loadCell($route_id, $lang, $user, "total");
            }
            
            /*if($res === true && $type == 'numbers_only' && explode('-', $cell_name)[0] == 'custom_column_value'){
                //echo 'dd';
                //$data['custom_total'] = 1;
                $custom_total = 0;
                //$html = file_get_contents(self::loadGpsPage());
            }*/
            //$html = file_get_contents(self::loadGpsPage());

            $data = [
                'res' => $res,
                'value' => $autocompleted_value,
                'sync_res' => $sync_res,
                'sync_type' => $sync_type,
                'total' => $total,
               // 'temp' => explode('-', $cell_name)[0],
               // 'temp_type' => $type,
               // 'custom_total' => $custom_total
            ];
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 
            
        echo json_encode($data); 
        JFactory::getApplication()->close();
    }
    
    public function storeMapCenter() {
        $app = JFactory::getApplication();
        $lang = $app->input->getString('lang0');
        $user_id = $app->input->getInt('user_id');
        $lat = $app->input->getFloat('lat');
        $lng = $app->input->getFloat('lng');
        $name = $app->input->getString('country_name');
        $country_code = $app->input->getString('country_code');
        
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS'; 
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }
        
        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error while store map center: Invalid security token. Pls., reload page'));
            } if (empty($lang)) {
                throw new Exception(JText::_('Error while store map center: Empty lang'));
            } if(empty($user_id)){
                throw new Exception(JText::_('Error while store map center: Empty user id'));
            } if(empty($lat)){
                throw new Exception(JText::_('Error while store map center: Empty lat'));
            } if(empty($lng)){
                throw new Exception(JText::_('Error while store map center: Empty lng'));
            } if(empty($name)){
                throw new Exception(JText::_('Error while store map center: Empty name of country'));
            } if(empty($country_code)){
                throw new Exception(JText::_('Error while store map center: Empty country code'));
            }
            
           
            
            $user = JFactory::getUser($user_id);
            $manager_obj = JFactory::getUser($user->owner_id);
            
            if($user->owner_id != $this->user->owner_id){
                throw new Exception(JText::_('Error while store map center: Permission denied!'));
            }
            $model = JModelLegacy::getInstance('Gps', 'AuditModel');

            $res = $model->storeMapCenter($lang, $user, $lat, $lng, $name, $country_code);
            
            

            $data = [
                'res' => $res,
                'value' => $autocompleted_value,
                'sync_res' => $sync_res,
                'sync_type' => $sync_type
            ];
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 
            
        echo json_encode($data); 
        JFactory::getApplication()->close();
    }
    
    public function getUserRoutes() {
        $app = JFactory::getApplication();
        $lang = $app->input->getString('lang0');
        $user_id = $app->input->getInt('u_id');
        $date = $app->input->getString('date');
        $active_route = $app->input->getInt('active_route');
        
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS'; 
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }
        
        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error while load user routes: Invalid security token. Pls., reload page'));
            } if (empty($lang)) {
                throw new Exception(JText::_('Error while load user routes: Empty lang'));
            } if(empty($user_id)){
                throw new Exception(JText::_('Error while load user routes: Empty user id'));
            } if(!empty($date) && $this->validateDate($date, 'd.m.Y') === false){
                throw new Exception(JText::_('Error while load user routes: Incorrect date format'));
            } 

            $user = JFactory::getUser($user_id);
            $manager_obj = JFactory::getUser($user->owner_id);
            
            if($user->owner_id != $this->user->owner_id){
                throw new Exception(JText::_('Error while load user routes: Permission denied!'));
            }
            $model = JModelLegacy::getInstance('Gps', 'AuditModel');
            if(empty($active_route)){
                $last_user_route = $model->getUserRoutes($user)[0];
                if(empty($last_user_route)){
                    throw new Exception("User don't have routes");
                }
                $active_route = $last_user_route->id;
               
            }
            $converted_date = DateTime::createFromFormat('d.m.Y', $date)->format('Y-m-d');
            $routes = $model->getRoutes($user->id, $converted_date);
            $html = $model->getRoutesListHtml($routes['standart'], $lang, $user, $active_route);
            

            $data = [
                'res' => $res,
                'routes' => $routes,
                'html' => $html
            ];
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 
            
        echo json_encode($data); 
        JFactory::getApplication()->close();
    }
    
    public function search() {
        $app = JFactory::getApplication();
        $lang = $app->input->getString('lang0');
        $date = $app->input->getString('date');
        $phrase = strip_tags($app->input->getString('phrase'));
        $search_all = $app->input->getString('search_all');
        
        try {
            $data['errors'] = "";
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error while make search: Invalid security token. Pls., reload page'));
            } if(empty($lang)){
                throw new Exception(JText::_('Error while make search: Empty lang'));
            } if(!empty($date) && $this->validateDate($date, 'd.m.Y') === false){
                throw new Exception(JText::_('Error while make search: Invalid date format'));
            }
            //JLoader::register('AuditModelTask_manager', JPATH_ROOT . '/components/com_audit/models/task_manager.php');
            //$model_task_manager = JModelLegacy::getInstance('Task_manager', 'AuditModel');
           
            $date_obj = DateTime::createFromFormat('d.m.Y', $date);
            $converted_date = $date_obj->format('Y-m-d');
            
            $search_mode = 1;
            $view = $this->getView("gps_task_manager", "html");
            $view->assignRef('date', $converted_date);
            $view->assignRef('search_mode', $search_mode);
            $view->assignRef('phrase', $phrase);
            $view->assignRef('search_all', $search_all);
            
            $view->setLayout('default');
            $view->display(); 
        
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
            echo json_encode($data);
        }
        
        JFactory::getApplication()->close();
    }
    
    public function createXls() {
        set_time_limit(0);
        /*echo '<pre>';
        print_r($_REQUEST);
        echo '</pre>';*/
        
        $model = JModelLegacy::getInstance('Gps', 'AuditModel');
         
        $res = $model->createXls();
      
        echo $res;
        
        JFactory::getApplication()->close();
    }

    public function isXlsExist() {
        $filename = $_SERVER['DOCUMENT_ROOT'] . '/tmp_xls_dev_n_tools/' . $_REQUEST['filename'];
        if (file_exists($filename)) {
            echo json_encode([
                'res' => '1',
                'filename' => $filename
            ]);
        } else {
            echo json_encode([
                'res' => '0',
                'filename' => $filename
            ]);
        }

        JFactory::getApplication()->close();
    }
    
    public function setCustomHeadersOrdering() {
        $app = JFactory::getApplication();
        $ordering = $app->input->getString('ordering');
        $lang = $app->input->getString('lang0');
        $additional_info = $app->input->getObject('additional_info');
        $user_id = $app->input->getInt('user_id');
        
        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error while custom column reorder: Invalid security token. Pls., reload page'));
            } if (empty($lang)) {
                throw new Exception(JText::_('Error while custom column reorder: Empty lang'));
            } if (empty($ordering)) {
                throw new Exception(JText::_('Error while custom column reorder: Empty ordering'));
            } if (empty($additional_info)) {
                throw new Exception(JText::_('Error while custom column reorder: Empty additional info'));
            } if(empty($user_id)) {
                throw new Exception(JText::_('Error while custom column reorder: Empty user id'));
            }
            
            $user = JFactory::getUser($user_id);
            if($user->owner_id != $this->user->owner_id){
                throw new Exception(JText::_('Error while custom column reorder: Permission denied!'));
            }
            
            $model = JModelLegacy::getInstance('Gps', 'AuditModel');
           
            $res = $model->setCustomHeadersOrdering($user_id, $ordering, $additional_info);
            $html = file_get_contents(self::loadGpsPage());
            
            $data['res'] = $res;
            $data['html'] = $html;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();   
        }  

        echo json_encode($data);
        
        JFactory::getApplication()->close();
    }
}
