<?php
// No direct access
defined( '_JEXEC' ) or die;

/**
 * Controller
 * @author 
 */
jimport( 'joomla.application.module.helper' );
class AuditControllerCalc extends JControllerLegacy {
    
    public function pdf() {
        /*ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);*/
        
        $db         =   JFactory::getDBO();
        $uid         =   (int) JRequest::getVar('u_id',0);
        $download         =   (int) JRequest::getVar('download',0);
        $view  =  $this->getView("calc","html");
        $view->setLayout('pdf');
        
        $config = & JFactory::getConfig();
        
        $timestamp  =   date("d.m.Y");
        
        $user = JFactory::getUser($uid);
        JLoader::register('AuditModelCalc', JPATH_ROOT . '/components/com_audit/models/calc.php');
        require_once( JPATH_BASE . DS . "mpdf/mpdf.php");
        require_once JPATH_BASE . DS . 'components/com_audit/assets/incl/PHPMailer-master/PHPMailerAutoload.php';
        
        /*
        $model = JModelLegacy::getInstance('Calc', 'AuditModel');
        $user_save = $model->loadCurrentUserSave($user);
        
        
        $params  =   json_decode($user_save->params,true);
        $post = array(
            'hpm'           =>  $user_save->hpm,
            'salaries'      =>  $user_save->salaries,
            'module'        =>  $user_save->module,
            'union'         =>  $user_save->first_page_union_val,
            'contract'      =>  $user_save->contract,
            'subcontract'   =>  $user_save->subcontract,
            'birthday'      =>  $user_save->birthday,
            'title'         =>  $params[0]['text'],
            'u_id'          =>  $uid,
            'task'          =>  'draw',
            
        );
        
        $view->post  =  $post;
        */
        
        /*
        
        'hpm': init_params.hpm,
                        'salaries': init_params.salaries,
                        'title': jQuery("#example").val(),
                        'birthday': birthday,
                        'contract': jQuery("input[name='contract']").val(),
                        'union': jQuery("input[name='union']").val(),
                        'module': init_params.module,
                        'u_id': u_id
        
        */
        
        $var        =   "calculatorHtml";
        //$uid        =   "2918";        
        $query = "SELECT * FROM #__save_data WHERE var=".$db->quote($var)." AND uid=".$db->quote($uid)."  limit 1";
        $db->setQuery($query);
        $obj = $db->loadObject();        
        
        $html  =  "";
        if(!empty($obj)) {
            $html  =  $obj->value;
        }
        
        $view->pdfHtml  =  $html;
        $html   =     $view->loadTemplate();
        
        if(preg_match_all("#<input([^>])+>#uUs", $html,$arr) ) {
            
        }
        
        
        if(preg_match_all("#<input([^>])+>#uUs", $html,$arr) ) {
            if(is_array($arr) && count($arr) > 0) {                
                foreach ($arr[0] as $input) {                    
                    if(preg_match('#type="hidden"#i', $input)) {
                        $html = str_replace($input, "", $html);
                        continue;
                    }
                    $class  =   "";
                    $value  =   "";
                    
                    if(preg_match('#class="([^"]+)"#i', $input,$tArr)) {
                        $class  =   $tArr[0];
                    }
                    if(preg_match('# value="([^"]+)"#i', $input,$tArr)) {
                        $value  =   $tArr[1];
                    }                    
                    if(preg_match('#data-value="([^"]+)"#i', $input,$tArr)) {
                        $value  =   $tArr[1];
                    }                    
                    if(preg_match('#data-saved-value="([^"]+)"#i', $input,$tArr)) {
                        $value  =   $tArr[1];
                    }
                    $input2 =  '<div class="input-wrap" >'.$value.'</div>';
                    $html = str_replace($input, $input2, $html);
                }
            }
        }
        if(preg_match_all("#<select.*>.*</select>#iUus", $html,$arr) ) {
            if(is_array($arr) && count($arr) > 0) {                
                foreach ($arr[0] as $input) {                    
                    $class  =   "";
                    $value  =   "";
                    if(preg_match('#data-saved-value="([^"]+)"#i', $input,$tArr)) {
                        $value  =   $tArr[1];
                    }
                    $input2 =  '<div class="input-wrap" >'.$value.'</div>';
                    $html = str_replace($input, $input2, $html);
                }
            }
        }
        if(preg_match_all("#<a.*>.*</a>#iUus", $html,$arr) ) {
            if(is_array($arr) && count($arr) > 0) {                
                foreach ($arr[0] as $input) {                    
                    $value  =   strip_tags($input);
                    $input2 =  '<div class="a-text" >'.$value.'</div>';
                    $html = str_replace($input, $input2, $html);
                }
            }
        }
        if(preg_match_all("#<label>(.*)</label>#iUus", $html,$arr) ) {
            if(is_array($arr) && count($arr) > 0) {                
                foreach ($arr[0] as $input) {    
                    $value  =   strip_tags($input);
                    $input2 =  '<div class="label-text" >'.$value.'</div>';
                    $html = str_replace($input, $input2, $html);
                }
            }
        }
        if(preg_match('#<span class="header_title">([^<]+)</span>#i',$html,$tArr)) {
            $html = str_replace($tArr[0], '<div class="title">'.$tArr[1].'</div>', $html);
        }
        $html = str_replace("input-group-addon", "input-group-addon-wrap", $html);
        $css  = file_get_contents(JPATH_ROOT."/components/com_audit/assets/styles/calc-pdf.css");
        $html = str_replace("<!--CSS-->", $css, $html);
        if(isset($_REQUEST['html'])) { // html
            echo $html;
            JFactory::getApplication()->close();
        }
        $mpdf = new mPDF();
        //$html   =     $view->loadTemplate();
        $mpdf->WriteHTML($html);
        //$mpdf->Output();
        //
        if($download) {
            $mpdf->Output('Calc.pdf', 'D');
            JFactory::getApplication()->close();
        }
        ////$mpdf->Output('Calc.pdf', 'D');
        //$mpdf->Output(JPATH_BASE . DS . 'tmp_mpdf/Pay Period_' . $time . '.pdf', 'F');
        
        $time = $timestamp;        
        $final_username = '';
        if (!empty($user->username0)) {
            $final_username = $user->username0;
        } elseif (!empty($user->username)) {
            $final_username = $user->username;
        } elseif (!empty($user->name)) {
            $final_username = $user->name;
        }
        
        $mail = new PHPMailer;  
        $mail->isMail(true);
        $mail->CharSet = "UTF-8";        
        $mail->setFrom($config->get('mailfrom'), $config->get('fromname'));
        $mail->Subject = JText::_('COM_AUDIT_CALC_MAIL_SUBJECT');
        $mail->addAddress($user->email, $final_username);
        $mail->isHTML(true);
        $mail->msgHTML(JText::_('COM_AUDIT_CALC_MAIL_MESSAGE'));
        $pathFile = JPATH_BASE . DS .'tmp_mpdf_email/' . $uid . '_Calc_' . $time . '.pdf';        
        @unlink($pathFile);
        $mpdf->Output($pathFile, 'F');                
        
        /*
        $mailer = JFactory::getMailer();
        $config = JFactory::getConfig();
        $sender = array( 
            $config->get( 'mailfrom' ),
            $config->get( 'fromname' ) 
        );
        $mailer->setSender($sender);        
        $mailer->addRecipient($user->email);
        $mailer->setSubject(JText::_('COM_AUDIT_CALC_MAIL_SUBJECT')." NEW");
        $mailer->setBody(JText::_('COM_AUDIT_CALC_MAIL_MESSAGE'));
         */
        // Optional file attached
        
        $data  =  array();
        $data['status']     =  0;
        
        try{
            
            //$mailer->addAttachment($pathFile);            
            $mail->addStringAttachment(file_get_contents($pathFile), $final_username . ' Calc_' . $time . '.pdf');
            if($mail->send()){
            //if($mailer->Send()){
                @unlink($pathFile);
                $data['status']     =  1;
                $data['message']    =  "";
            } else {
                throw new Exception("Mail not sent");
            }
            
        } catch (Exception $ex) {
            $data['status']     =  0;
            $data['message']    =  $ex->getMessage();
            $data['email']      =  $user->email;
            
        }
        
        echo json_encode($data,JSON_PRETTY_PRINT);
        JFactory::getApplication()->close();
    }
    
    public function saveDataForEarnedIncomeNewCalcModule()
    {
        $app = JFactory::getApplication();
        $user_id = $app->input->getInt('u_id');
        $lang = $app->input->getString('lang');
        $calc_params = $app->input->getObject('calc_params');
        $from_to_req = $app->input->getObject('from_to');
        
        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error while saving values to Earned income page: Invalid security token. Pls., reload page'));
            } if (empty($user_id)) {
                throw new Exception('Error while saving values to Earned income page: Enter user_id!');
            } if (empty($lang)) {
                throw new Exception('Error while saving values to Earned income page: Enter lang!');
            } if (empty($calc_params)) {
                throw new Exception('Error while saving values to Earned income page: Enter calc_params!');
            } if (empty($from_to_req)) {
                throw new Exception('Error while saving values to Earned income page: enter from to!');
            }
            
            $user = JFactory::getUser($user_id);
            if(empty($from_to_req)){
                $from_to = (array)$this->getFromToForCalc($user->id);
            } else{
                $from_to = (array)$from_to_req;
            }

            if (empty($from_to)) {
                throw new Exception('Error while saving values to Earned income page: Error while getting from to');
            }
            $convert_from = $this->convertDateFormat($from_to);
            
            if (empty($convert_from)) { 
                throw new Exception('Error while saving values to Earned income page: Error in convert from to value');
            }
            foreach($calc_params as $k=>$param){
                if(!in_array($k, [
                    'employee_st_pension_fund',
                    'employee_private_pension_fund',
                    'company_pension_fund',
                    'company_private_pension_fund',
                    'insurance_fee',
                    'employee_union',
                    'company_union',
                    'holiday',
                    'income_municipal_tax',
                    'personal_tax',
                    'salaries',
                    'take_home_pay',
                    'total_cost',
                    
                    'hours_of_contract',
                    'monthly_salaries',
                    'shift_work33',
                    'shift_work45',
                    'shift_work90',
                    'total_daytime_units',
                    'other_salary',
                    'job_percentage',
                    'overtime1_units', 
                    'overtime2_units',
                    'holiday_units',
                    'total_overtime',
                    'type_of_calc',
                    'salary_for_daytime',
                    
                    'empl_st_premium',
                    'empl_match_grand',
                    'reh_fund',
                    
                    'empl_premium',
                    'empl_match_grand1',
                    
                    'general_insurance_fee',
                    
                    'union_id',
                    
                    'no_holidays_chk',
                    'count_days_radio',
                    'holiday1',
                    'holiday2',
                    'holiday3',
                    'holiday4',
                    'holiday5', 
                    
                    'child_tax_rate',
                    
                    'personal_tax_allow',
                    'spouses_tax_allow',
                    'untapped_personal_tax_allow',
                    'untapped_spouses_tax_allow',
                    
                    'december_bonus_state',
                    'holiday_bonus_state',
                    
                    'pension_fund',
                    
                    //Benefits
                    'vehicle_allowance_tax',
                    'car_benefit_tax',
                    'food_tax',
                    'life_insurance_tax',
                    'housing_tax',
                    'transportation_costs_tax',
                    'physical_fitness_tax',
                    
                    //Benefits inputs
                    'vehicle_allowance_p',
                    'vehicle_allowance_e',
                
                    'car_benefit_p',
                    'car_benefit_e',
                
                    'food_tax_p',
                    'food_tax_e',
                
                    'life_insurance_p',
                    'life_insurance_e',
                
                    'housing_p',
                    'housing_e',
                
                    'transportation_costs_p',
                    'transportation_costs_e',
                
                    'physical_fitness_p',
                    'physical_fitness_e',
                    
                    'pension_fund_priv',
                    'pension_fund2_priv',
                    
                    'empl_premium1',
                    'empl_match_grand2'
                ])){ 
                    throw new Exception('Error while saving values to Earned income page: Error calc params. Has found not permitted field.');
                }
            }
            //for test
            /*$convert_from=[
                'from'=>'2020-06-25',
                'to'=>'2020-07-24' 
            ];*/
            
            JLoader::register('AuditModelCalc', JPATH_ROOT . '/components/com_audit/models/calc.php');
            $model = JModelLegacy::getInstance('Calc', 'AuditModel');
            $final_res = $model->saveDataForEarnedIncomeForNewModule($convert_from, $user, $lang, $calc_params);
            $salary_save_res = $model->saveSalary($user, $lang, $calc_params['monthly_salaries']);
            
            $data['final_res'] = $final_res;
            $data['pay_period'] = $convert_from;
            $data['salary_save_res'] = $salary_save_res;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
            $data['calc_params'] = $calc_params;
        }
            
        echo json_encode($data); 
        JFactory::getApplication()->close();
    }
    
    public function getFromToForCalc($user_id)
    {
        $model_pay_period = JModelLegacy::getInstance('Custom_pay_period', 'AuditModel');
        $from_to = json_decode($model_pay_period->getInputsPayPeriod($user_id));
       
       // $current_date = date('d.m.Y');
        $current_date=DateTime::createFromFormat('d.m.Y H:i:s', date('d.m.Y').' 00:00:00')->format('U');
        $from_date1 = DateTime::createFromFormat('d.m.Y', $from_to->from_date);
        $from_date2 = $from_date1->format('d');
        
        $from_date = $from_date2 . date('.m.Y');
        $from_date_unix=DateTime::createFromFormat('d.m.Y', $from_date)->format('U');
        
        $to_date1 = DateTime::createFromFormat('d.m.Y', $from_to->to_date);
        $to_date2 = $to_date1->format('d');

        if ($from_date2 == '01'){
            $to_date = $to_date2 . date('.m.Y');
        }  else{
            $to_date = $to_date2 . date('.m.Y', strtotime('+1month'));
        }


        if ($current_date < $from_date_unix) {
            //echo 'попали';
            $from_date_row = DateTime::createFromFormat('d.m.Y', $from_date)->format('Y-m-d');

            $from_date_strtotime = strtotime($from_date_row . '-1months');
            //$from_date_strtotime1=strtotime("$from_date_strtotime -1 month");
            $from_date = date('d.m.Y', $from_date_strtotime);
            $from_date00 = date('Y-m-d', $from_date_strtotime);
            $count_days_in_month = date('t', strtotime($from_date00));

            if ($count_days_in_month == 31) {
                $from_date_strtotime = strtotime($from_date_row . '-1months');
                $from_date = date('d.m.Y', $from_date_strtotime);
            }


            $to_date_row = DateTime::createFromFormat('d.m.Y', $from_date)->format('Y-m-d');
            $to_date_strtotime = strtotime($to_date_row . '+1months -1days');
            $to_date = date('d.m.Y', $to_date_strtotime);
        }
       
        if(empty($from_date) && empty($to_date)){
            $final_res=[
                'from'=>'25.'.date('m.Y', strtotime('-1 month')),
                'to'=>'24.'.date('m.Y', strtotime('+0 month'))
            ];
        } else{
            $final_res=[
               'from'=>$from_date,
               'to'=>$to_date
            ];
        }
         
        return $final_res;
    }
    
    private function convertDateFormat($arr)
    {
        $date_arr=[];
        
        if(!empty($arr)){
            $dateArr_from = explode(".", $arr['from']);
            $dateArr_to = explode(".", $arr['to']);
            
            
            $date_arr['from'] = $dateArr_from[2]."-".$dateArr_from[1]."-".$dateArr_from[0];
            $date_arr['to'] = $dateArr_to[2]."-".$dateArr_to[1]."-".$dateArr_to[0];
        }
        
        return $date_arr;
    }
    
    public function viewEarnedIncomeNewPsdNewCalcModule()
    {
        $view = $this->getView("earned_income_for_new_module", "html");
        $view->setLayout('default');
	$view->display();
        
        JFactory::getApplication()->close(); 
    }
    
    public function getNotPermittedEarnedIncomeKeys()
    {
        return [
            'id',
            'user_id',
            'timestamp_create',
            'date_create',
            'period',
            'timestamp_last_update',
            'date_last_update',
            
            'hours_of_contract',
            'monthly_salaries',
            'shift_work33',
            'shift_work45',
            'shift_work90',
            'total_daytime_units',
            'other_salary',
            'job_percentage',
            'overtime1_units',
            'overtime2_units',
            'holiday_units',
            'total_overtime',
            'type_of_calc',
            'salary_for_daytime',
            'union_id',
            'no_holidays_chk',
            'count_days_radio',
            'holiday1',
            'holiday2',
            'holiday3',
            'holiday4',
            'holiday5',
            'child_tax_rate',
            'holiday_bonus_state',
            'december_bonus_state',
            'pension_fund',
            
            //Benefits
            'vehicle_allowance_tax',
            'car_benefit_tax',
            'food_tax',
            'life_insurance_tax',
            'housing_tax',
            'transportation_costs_tax',
            'physical_fitness_tax',
            
            'pension_fund_priv',
            'pension_fund2_priv',
            
            'empl_premium1',
            'empl_match_grand2',
            
            'username'
        ];
    }
    
    public function loadEarnedIncomeRecordForNewModule()
    {
        $app = JFactory::getApplication();
        $user_id = $app->input->getInt('u_id');
        $lang = $app->input->getString('lang');
        $row_id = $app->input->getInt('id');
         
        //nesessary lang fix
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }
        
        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error while load stored values for calculator: Invalid security token. Pls., reload page'));
            } if (empty($user_id)) {
                throw new Exception(JText::_('Error while load stored values for calculator: Empty user id'));
            } if (empty($lang)) {
                throw new Exception(JText::_('Error while load stored values for calculator: Empty lang'));
            } if (empty($row_id)){
                throw new Exception(JText::_('Error while load stored values for calculator: Empty id'));
            }

            $user = JFactory::getUser($user_id);
            
            JLoader::register('AuditModelCalc', JPATH_ROOT . '/components/com_audit/models/calc.php');
            $model = JModelLegacy::getInstance('Calc', 'AuditModel');
            
            $individual_params=[
                'user_obj'=>$user,
                'row_id'=>$row_id
            ];
            $permission_check = $model->checkPermission('getting_earned_income_row', $individual_params);
            
            if($permission_check=='0'){
                throw new Exception(JText::_('Error while load stored values for calculator: Permission denied'));
            }
            
            
            $earning_income_row = $model->loadEarnedIncomeRecordForNewModule($row_id, $user, $lang);
                
            $data['row'] = $earning_income_row;
            //$data['pay_period'] = $convert_from;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }
            
        echo json_encode($data); 
        JFactory::getApplication()->close();
    }
    
    public function loadBottomTotalsNewCalcModule()
    {
        /*ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);*/
        
        $app = JFactory::getApplication();
        $user_id = $app->input->getInt('u_id');
        $lang = $app->input->getString('lang');
        $from_to_req = $app->input->getObject('from_to');
        
        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error while load values from pay period: Invalid security token. Pls., reload page'));
            } if (empty($user_id)) {
                throw new Exception('Error while load values from pay period: enter user_id!');
            } if (empty($lang)) {
                throw new Exception('Error while load values from pay period: enter lang!');
            } if (empty($from_to_req)) {
                throw new Exception('Error while load values from pay period: enter pay period from to!');
            }
            
            $user = JFactory::getUser($user_id);
            if(empty($from_to_req)){
                $from_to = (array)$this->getFromToForCalc($user->id);
            } else{
                $from_to = (array)$from_to_req;
            }
            //$from_to='';
            if (empty($from_to)) {
                throw new Exception('Error while load values from pay period: Error in getting from to');
            }

            $convert_from = $this->convertDateFormat($from_to);
           
            if (empty($convert_from)) { 
                throw new Exception('Error while load values from pay period: Error in convert from to value');
            }
            $from = $convert_from['from'];
            $to = $convert_from['to'];
                
            //$from = $from_to['from']; 
            //$to = $from_to['to'];
        
            $pay_period_load_mode = 'api_front';
             
            $link = 'https://'.$_SERVER['SERVER_NAME'].'/index.php?task=getTimeByPeriod&lang='.$lang.'&u_id='.$user_id.'&from='.$from.'&to='.$to.'&submode=api_html&mode=pdf&pay_period_load_mode='.$pay_period_load_mode . '&load_type=calendar';
            
            $html = file_get_contents($link);
            //$data['link'] = $link;
            if(!empty($html)){
                //JLoader::register('AuditModelCalc', JPATH_ROOT . '/components/com_audit/models/calc.php');
                $model = JModelLegacy::getInstance('Calc', 'AuditModel');

                $final_res = $model->prepareTotalsForCalcNewModule($html, $user_id, $lang);
                $data['final_res'] = $final_res; 
                $data['relations'] = $model->loadRelationsBetweenCalcAndPayPeriod($user_id, $lang);
                $data['stored_salary'] = $model->getStoredSalary($user, $lang);
                $data['last_save'] = $model->loadLastSave($user, $lang);
            } else{
                throw new Exception('Error while load values from pay period: User timesheet is empty');
            }
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }
            
        echo json_encode($data); 
        JFactory::getApplication()->close();
    }
    
    public function loadEarnedIncomeTableNewModule()
    {
        $app = JFactory::getApplication();
        $user_id = $app->input->getInt('u_id');
        $lang = $app->input->getString('lang');
        $from_to_req = $app->input->getObject('from_to');
        $type = $app->input->getString('type');
        
        /*echo '<pre>';
        print_r($_REQUEST);
        echo '</pre>';*/
        
        try {
            $data['errors'] = "";
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error during load Earned income page with period: Invalid security token. Pls., reload page'));
            } if (empty($user_id)) {
                throw new Exception('Error during load Earned income page with period: Enter user_id!');
            } if (empty($lang)) {
                throw new Exception('Error during load Earned income page with period: Enter lang!');
            } if (empty($from_to_req)) {
                throw new Exception('Error during load Earned income page with period: Enter pay period from to!');
            }
            
            $user = JFactory::getUser($user_id);
            if(empty($from_to_req)){
                $from_to = (array)$this->getFromToForCalc($user->id);
            } else{
                $from_to = (array)$from_to_req;
            }
            
            if (empty($from_to)) {
                throw new Exception('Error during load Earned income page with period: Error in getting from to');
            }
            $convert_from = $this->convertDateFormat($from_to);
            
            if (empty($convert_from)) { 
                throw new Exception('Error during load Earned income page with period: Error in convert from to value');
            }
         
            JLoader::register('AuditModelCalc', JPATH_ROOT . '/components/com_audit/models/calc.php');
            $model = JModelLegacy::getInstance('Calc', 'AuditModel');
            
            $html = $model->loadEarnedIncomeTableForNewModule($convert_from, $user, $lang, $type);
                
            $data['html'] = $html;
            $data['pay_period'] = $convert_from;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }
            
        echo json_encode($data); 
        JFactory::getApplication()->close();
    }

    public function loadEarnedIncomeTableDefaultNewModule()
    {
        $app = JFactory::getApplication();
        $user_id = $app->input->getInt('u_id');
        $lang = $app->input->getString('lang');
        $type = $app->input->getString('type');
        $from_to_req = $app->input->getObject('from_to');
        
        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error during load Earned income page: Invalid security token. Pls., reload page'));
            } if (empty($user_id)) {
                throw new Exception('Error during load Earned income page: Enter user_id!');
            } if (empty($lang)) {
                throw new Exception('Error during load Earned income page: Enter lang!');
            }  
            
            $user = JFactory::getUser($user_id);
            if(empty($from_to_req)){
                $from_to = (array)$this->getFromToForCalc($user->id);
            } else{
                $from_to = (array)$from_to_req;
            }
            if (empty($from_to)) {
                throw new Exception('Error during load Earned income page: Error in getting from to');
            }
            $convert_from = $this->convertDateFormat($from_to);
            
            if (empty($convert_from)) { 
                throw new Exception('Error during load Earned income page: Error in convert from to value');
            }
            
            JLoader::register('AuditModelCalc', JPATH_ROOT . '/components/com_audit/models/calc.php');
            $model = JModelLegacy::getInstance('Calc', 'AuditModel');
            $html = $model->loadEarnedIncomeTableDefaultForNewModule(0, $user, $lang, $type, $convert_from);
                
            $data['html'] = $html;
            $data['pay_period'] = null;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }
            
        echo json_encode($data); 
        JFactory::getApplication()->close();
    }
    
    public function createCsvAllUsersEarnedIncomeForNewModule()
    {
        $app = JFactory::getApplication();
        $user_id = $app->input->getInt('u_id');
        $lang = $app->input->getString('lang');
        $period = $app->input->getObject('period');
        $get_all_mode = $app->input->getInt('get_all_mode');
        
        //nesessary lang fix
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS'; 
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }
        
        try {
            $data['errors'] = "";
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error while create csv: Invalid security token. Pls., reload page'));
            } if (empty($user_id)) {
                throw new Exception(JText::_('Error while create csv: Empty user id'));
            } if (empty($lang)) {
                throw new Exception(JText::_('Error while create csv: Empty lang'));
            } if (empty($period) && $get_all_mode == 0){
                throw new Exception(JText::_('Error while create csv: Empty period'));
            }

            $user = JFactory::getUser($user_id);
            
            JLoader::register('AuditModelCalc', JPATH_ROOT . '/components/com_audit/models/calc.php');
            $model = JModelLegacy::getInstance('Calc', 'AuditModel');
            
            $individual_params = [
                'user_obj'=>$user,
            ];
            $permission_check = $model->checkPermission('createCsvEarnedIncome', $individual_params);
            
            if($permission_check == '0'){
                throw new Exception(JText::_('Error while create csv: Permission denied'));
            }
            
            
            $res = $model->createCsvAllUsersEarnedIncomeForNewModule($period, $user, $lang, $get_all_mode);
                
            $data['res'] = $res;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 
            
        echo json_encode($data); 
        JFactory::getApplication()->close();
    }
    
    public function createCsvEarnedIncomeForNewModule()
    {
        $app = JFactory::getApplication();
        $user_id = $app->input->getInt('u_id');
        $lang = $app->input->getString('lang');
        $period = $app->input->getObject('period');
        $get_all_mode = $app->input->getInt('get_all_mode');
        
        //nesessary lang fix
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS'; 
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }
        
        try {
            $data['errors'] = "";
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error while create csv: Invalid security token. Pls., reload page'));
            } if (empty($user_id)) {
                throw new Exception(JText::_('Error while create csv: Empty user id'));
            } if (empty($lang)) {
                throw new Exception(JText::_('Error while create csv: Empty lang'));
            } if (empty($period) && $get_all_mode == 0){
                throw new Exception(JText::_('Error while create csv: Empty period'));
            }

            $user = JFactory::getUser($user_id);
            
            JLoader::register('AuditModelCalc', JPATH_ROOT . '/components/com_audit/models/calc.php');
            $model = JModelLegacy::getInstance('Calc', 'AuditModel');
            
            $individual_params = [
                'user_obj'=>$user,
            ];
            $permission_check = $model->checkPermission('createCsvEarnedIncome', $individual_params);
            
            if($permission_check == '0'){
                throw new Exception(JText::_('Error while create csv: Permission denied'));
            }

            $res = $model->createCsvEarnedIncomeForNewModule($period, $user, $lang, $get_all_mode);
                
            $data['res'] = $res;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }
            
        echo json_encode($data); 
        JFactory::getApplication()->close();
    }
    
    public function createXlsAllUsersEarnedIncomeForNewModule()
    {
        $app = JFactory::getApplication();
        $user_id = $app->input->getInt('u_id');
        $lang = $app->input->getString('lang');
        $period = $app->input->getObject('period');
        $get_all_mode = $app->input->getInt('get_all_mode');
        
        //nesessary lang fix
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS'; 
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }
        
        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error while create csv: Invalid security token. Pls., reload page'));
            } if (empty($user_id)) {
                throw new Exception(JText::_('Error while create xls: Empty user id'));
            } if (empty($lang)) {
                throw new Exception(JText::_('Error while create xls: Empty lang'));
            } if (empty($period) && $get_all_mode == 0){
                throw new Exception(JText::_('Error while create xls: Empty period'));
            }

            $user = JFactory::getUser($user_id);
            
            JLoader::register('AuditModelCalc', JPATH_ROOT . '/components/com_audit/models/calc.php');
            $model = JModelLegacy::getInstance('Calc', 'AuditModel');
            
            $individual_params = [
                'user_obj'=>$user,
            ];
            $permission_check = $model->checkPermission('createExcelEarnedIncome', $individual_params);
            
            if($permission_check == '0'){
                throw new Exception(JText::_('Error while create xls: Permission denied'));
            }
            
            
            $res = $model->createXlsAllUsersEarnedIncomeForNewModule($period, $user, $lang, $get_all_mode);
                
            $data['res'] = $res;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 
            
        echo json_encode($data); 
        JFactory::getApplication()->close();
    }
    
    public function getFieldsForRelationWithPayPeriod() {
        $app = JFactory::getApplication();
        $user_id = $app->input->getInt('u_id');
        $lang = $app->input->getString('lang');
        $relation_key = $app->input->getString('relation_key');
        
        //nesessary lang fix
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS'; 
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }
        
        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error while load fields for relation with calculator: Invalid security token. Pls., reload page'));
            } if (empty($user_id)) {
                throw new Exception(JText::_('Error while load fields for relation with calculator: Empty user id'));
            } if (empty($lang)) {
                throw new Exception(JText::_('Error while load fields for relation with calculator: Empty lang'));
            } if(empty($relation_key)){
                throw new Exception(JText::_('Error while load fields for relation with calculator: Empty relation key'));
            }

            $user = JFactory::getUser($user_id);
            
            JLoader::register('AuditModelCalc', JPATH_ROOT . '/components/com_audit/models/calc.php');
            $model = JModelLegacy::getInstance('Calc', 'AuditModel');
            
            $individual_params = [
                'user_obj' => $user,
            ]; 
            $permission_check = $model->checkPermission('getFieldsForRelationWithPayPeriod', $individual_params);
            
            if($permission_check == '0'){
                throw new Exception(JText::_('Error while load fields for relation with calculator: Permission denied'));
            }
            
            $res = [
                0 => JText::_('COM_AUDIT_CALC_RELATIONS_HEADER'),//header, not clickable
                't_daytime' => JText::_('COM_AUDIT_CALC_RELATION_DAYTIME'),
                'shift_33' => JText::_('COM_AUDIT_CALC_RELATION_SHIFT33'),
                'shift_45' => JText::_('COM_AUDIT_CALC_RELATION_SHIFT45'),
                'shift_90' => JText::_('COM_AUDIT_CALC_RELATION_SHIFT90'),
                'overtime' => JText::_('COM_AUDIT_CALC_RELATION_OVERTIME'),
                'overtime_1' => JText::_('COM_AUDIT_CALC_RELATION_OVERTIME1'),
                'overtime_2' => JText::_('COM_AUDIT_CALC_RELATION_OVERTIME2'),
                'holidays' => JText::_('COM_AUDIT_CALC_RELATION_HOLIDAYS'),
                'sick_days' => JText::_('COM_AUDIT_CALC_RELATION_SD'),
                'sick_child' => JText::_('COM_AUDIT_CALC_RELATION_SCH')
            ];
            
            $active = $model->getActiveRelation($user, $lang, $relation_key);
                
            $data['res'] = $res;
            $data['active'] = $active;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 
            
        echo json_encode($data, true); 
        JFactory::getApplication()->close();
    }
    
    public function storeFieldRelationWithCalc() {
        $app = JFactory::getApplication();
        $user_id = $app->input->getInt('u_id');
        $lang = $app->input->getString('lang');
        $value = $app->input->getString('value');
        $relation_key = $app->input->getString('relation_key');
        
        //nesessary lang fix
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS'; 
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }
        
        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error while store field for relation with calculator: Invalid security token. Pls., reload page'));
            } if (empty($user_id)) {
                throw new Exception(JText::_('Error while store field for relation with calculator: Empty user id'));
            } if (empty($lang)) {
                throw new Exception(JText::_('Error while store field for relation with calculator: Empty lang'));
            } if(empty($value)){
                throw new Exception(JText::_('Error while store field for relation with calculator: Empty value'));
            } if(empty($relation_key)){
                throw new Exception(JText::_('Error while store field for relation with calculator: Empty relation key'));
            }

            $user = JFactory::getUser($user_id);
            
            JLoader::register('AuditModelCalc', JPATH_ROOT . '/components/com_audit/models/calc.php');
            $model = JModelLegacy::getInstance('Calc', 'AuditModel');
            
            $individual_params = [
                'user_obj' => $user,
            ]; 
            $permission_check = $model->checkPermission('storeFieldRelationWithCalc', $individual_params);
            
            if($permission_check == '0'){
                throw new Exception(JText::_('Error while store field for relation with calculator: Permission denied'));
            }
            
           
            
            $res = $model->storeFieldRelationWithCalc($user, $lang, $value, $relation_key);
                
            $data['res'] = $res;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 
            
        echo json_encode($data, true); 
        JFactory::getApplication()->close();
    }
    
    public function getUsersList() {
        $app = JFactory::getApplication();
        $user_id = $app->input->getString('u_id');
        $lang = $app->input->getString('lang');
        $mode = $app->input->getString('mode');
        $open_ei = $app->input->getString('open_ei');
        $u_id_get = $app->input->getString('u_id_get');
        
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS'; 
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }
        
        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){
                throw new Exception(JText::_('Error until loading user list: Invalid security token. Pls., reload page'));
            } if (empty($lang)) {
                throw new Exception(JText::_('Error until loading user list: Empty lang'));
            } if(empty($user_id)){
                throw new Exception(JText::_('Error until loading user list: Empty user id'));
            } if(empty($mode)){
                throw new Exception(JText::_('Error until loading user list: Empty mode'));
            }

            $user = JFactory::getUser($user_id);
            
            JLoader::register('AuditModelCalc', JPATH_ROOT . '/components/com_audit/models/registered_users.php');
            $model = JModelLegacy::getInstance('Registered_Users', 'AuditModel');

            $res = $model->getUsersListInPayPeriod($user, $lang);
            if(empty($res)){
                throw new Exception(JText::_('Error until loading user list: Empty user list'));
            }
            $model_calc = JModelLegacy::getInstance('Calc', 'AuditModel');
            $html = $model_calc->prepareUsersListInReportHtml($res, $lang, $user, $mode, $open_ei, $u_id_get);

            $data['res'] = $res;
            $data['html'] = $html;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 
            
        echo json_encode($data); 
        JFactory::getApplication()->close();
    }
    
    public function pdfNewCalc() {
        /*ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);*/
        
        $db         =   JFactory::getDBO();
        $uid         =   (int) JRequest::getVar('u_id',0);
        $download         =   (int) JRequest::getVar('download',0);
        $view  =  $this->getView("calc_for_new_module","html");
        $view->setLayout('pdf');
         
        $config = & JFactory::getConfig();
        
        $timestamp  =   date("d.m.Y");
        
        $user = JFactory::getUser($uid);
        JLoader::register('AuditModelCalc', JPATH_ROOT . '/components/com_audit/models/calc.php');
        require_once( JPATH_BASE . DS . "mpdf/mpdf.php");
        require_once JPATH_BASE . DS . 'components/com_audit/assets/incl/PHPMailer-master/PHPMailerAutoload.php';

        $var        =   "calculatorHtmlNewModule";
          
        $query = "SELECT * FROM #__save_data WHERE var=".$db->quote($var)." AND uid=".$db->quote($uid)." limit 1";
        $db->setQuery($query);
        $obj = $db->loadObject();        
        /*echo '<pre>$obj';
        print_r($obj);
        echo '</pre>';
        exit;*/
        $html  =  "";
        if(!empty($obj)) {
            $html  =  $obj->value;
        }
        
        $view->pdfHtml  =  $html;
        $html   =     $view->loadTemplate();
        
        if(preg_match_all("#<input([^>])+>#uUs", $html,$arr) ) {
            
        }
        
        
        if(preg_match_all("#<input([^>])+>#uUs", $html,$arr) ) {
            if(is_array($arr) && count($arr) > 0) {                
                foreach ($arr[0] as $input) {                    
                    if(preg_match('#type="hidden"#i', $input)) {
                        $html = str_replace($input, "", $html);
                        continue;
                    }
                    $class  =   "";
                    $value  =   "";
                    
                    if(preg_match('#class="([^"]+)"#i', $input,$tArr)) {
                        $class  =   $tArr[0];
                    }
                    if(preg_match('# value="([^"]+)"#i', $input,$tArr)) {
                        $value  =   $tArr[1];
                    }                    
                    if(preg_match('#data-value="([^"]+)"#i', $input,$tArr)) {
                        $value  =   $tArr[1];
                    }                    
                    if(preg_match('#data-saved-value="([^"]+)"#i', $input,$tArr)) {
                        $value  =   $tArr[1];
                    }
                    $input2 =  '<div class="input-wrap" >'.$value.'</div>';
                    $html = str_replace($input, $input2, $html);
                }
            }
        }
        if(preg_match_all("#<select.*>.*</select>#iUus", $html,$arr) ) {
            if(is_array($arr) && count($arr) > 0) {                
                foreach ($arr[0] as $input) {                    
                    $class  =   "";
                    $value  =   "";
                    if(preg_match('#data-saved-value="([^"]+)"#i', $input,$tArr)) {
                        $value  =   $tArr[1];
                    }
                    $input2 =  '<div class="input-wrap" >'.$value.'</div>';
                    $html = str_replace($input, $input2, $html);
                }
            }
        }
        if(preg_match_all("#<a.*>.*</a>#iUus", $html,$arr) ) {
            if(is_array($arr) && count($arr) > 0) {                
                foreach ($arr[0] as $input) {                    
                    $value  =   strip_tags($input);
                    $input2 =  '<div class="a-text" >'.$value.'</div>';
                    $html = str_replace($input, $input2, $html);
                }
            }
        }
        if(preg_match_all("#<label>(.*)</label>#iUus", $html,$arr) ) {
            if(is_array($arr) && count($arr) > 0) {                
                foreach ($arr[0] as $input) {    
                    $value  =   strip_tags($input);
                    $input2 =  '<div class="label-text" >'.$value.'</div>';
                    $html = str_replace($input, $input2, $html);
                }
            }
        }
        if(preg_match('#<span class="header_title">([^<]+)</span>#i',$html,$tArr)) {
            $html = str_replace($tArr[0], '<div class="title">'.$tArr[1].'</div>', $html);
        }
        $html = str_replace("input-group-addon", "input-group-addon-wrap", $html);
        $css  = file_get_contents(JPATH_ROOT."/components/com_audit/assets/styles/calc-pdf.css");
        $html = str_replace("<!--CSS-->", $css, $html);
        if(isset($_REQUEST['html'])) { // html
            echo $html;
            JFactory::getApplication()->close();
        }
        $mpdf = new mPDF();
      
        $mpdf->WriteHTML($html);
      
        //
        if($download) {
            $mpdf->Output('Calc.pdf', 'D');
            JFactory::getApplication()->close();
        }
       
        $time = $timestamp;        
        $final_username = '';
        if (!empty($user->username0)) {
            $final_username = $user->username0;
        } elseif (!empty($user->username)) {
            $final_username = $user->username;
        } elseif (!empty($user->name)) {
            $final_username = $user->name;
        }
        
        $mail = new PHPMailer;  
        $mail->isMail(true);
        $mail->CharSet = "UTF-8";        
        $mail->setFrom($config->get('mailfrom'), $config->get('fromname'));
        $mail->Subject = JText::_('COM_AUDIT_CALC_MAIL_SUBJECT');
        $mail->addAddress($user->email, $final_username);
        $mail->isHTML(true);
        $mail->msgHTML(JText::_('COM_AUDIT_CALC_MAIL_MESSAGE'));
        $pathFile = JPATH_BASE . DS .'tmp_mpdf_email/' . $uid . '_Calc_' . $time . '.pdf';        
        @unlink($pathFile);
        $mpdf->Output($pathFile, 'F');                
        
        
        $data  =  array();
        $data['status']     =  0;
        
        try{
            
            //$mailer->addAttachment($pathFile);            
            $mail->addStringAttachment(file_get_contents($pathFile), $final_username . ' Calc_' . $time . '.pdf');
            if($mail->send()){
            //if($mailer->Send()){
                @unlink($pathFile);
                $data['status']     =  1;
                $data['message']    =  "";
            } else {
                throw new Exception("Mail not sent");
            }
            
        } catch (Exception $ex) {
            $data['status']     =  0;
            $data['message']    =  $ex->getMessage();
            $data['email']      =  $user->email;
            
        }
        
        echo json_encode($data,JSON_PRETTY_PRINT);
        JFactory::getApplication()->close();
    }
    
    public function deleteEarnIncomeRowNewModule() {
        $app = JFactory::getApplication();
        $id = $app->input->getInt('id');
        $lang = $app->input->getString('lang');
        $user_id = $app->input->getInt('u_id');
        
        try {
            $data['errors'] = "";
            if(!JSession::checkToken('request')){
                throw new Exception(JText::_('Error while deleting row: Invalid security token. Pls., reload page'));
            } if (empty($id)) {
                throw new Exception('Error while deleting row: enter id!');
            } if (empty($lang)) {
                throw new Exception('Error while deleting row: enter lang!');
            } if (empty($user_id)) {
                throw new Exception('Error while deleting row: enter user_id!');
            }
            
            $user = JFactory::getUser($user_id);
                    
            JLoader::register('AuditModelCalc', JPATH_ROOT . '/components/com_audit/models/calc.php');
            $model = JModelLegacy::getInstance('Calc', 'AuditModel'); 
            
            $individual_params=[
                'user_obj'=>$user,
                'id'=>$id
            ];
            
            $permission_check = $model->checkPermission('deleteNew', $individual_params);
            
            if($permission_check=='0'){
                throw new Exception('Error while deleting row: Permission denied!');
            }
            $model->deleteEarnIncomeRowNew($id);
          
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }
            
        echo json_encode($data); 
        JFactory::getApplication()->close();
    }
    
    public function loadEarnedIncomeTableWithNewTypeOfPeriod() {
        $app = JFactory::getApplication();
        $user_id = $app->input->getString('u_id');
        $lang = $app->input->getString('lang');
        $from_to_req = $app->input->getObject('from_to');

        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error during load Earned income page with period: Invalid security token. Pls., reload page'));
            } if (empty($user_id)) {
                throw new Exception('Error during load Earned income page with period: Enter user_id!');
            } if (empty($lang)) {
                throw new Exception('Error during load Earned income page with period: Enter lang!');
            } if (empty($from_to_req)) {
                throw new Exception('Error during load Earned income page with period: Enter pay period from to!');
            }
            
            /*if($user_id != 'all'){
                $user = JFactory::getUser($user_id);
            } else{
                $user = JFactory::getUser();
            }*/
           /*$from_to_req = null;
            if(empty($from_to_req)){
                $from_to = (array)$this->getFromToForCalc($user->id);
            } else{
                $from_to = (array)$from_to_req;
            }
            echo '<pre>$from_to';
            print_r($from_to);
            echo '</pre>';
            
            if (empty($from_to)) {
                throw new Exception('Error during load Earned income page with period: Error in getting from to');
            }*/
            $from_to = (array)$from_to_req;
            $convert_from = $this->convertDateFormat($from_to);
            
            if (empty($convert_from)) { 
                throw new Exception('Error during load Earned income page with period: Error in convert from to value');
            }
         
            JLoader::register('AuditModelCalc', JPATH_ROOT . '/components/com_audit/models/calc.php');
            $model = JModelLegacy::getInstance('Calc', 'AuditModel');
            
            $html = $model->loadEarnedIncomeTableForNewModuleWithNewTypeOfPeriod($convert_from, $user_id, $lang);
                
            $data['html'] = $html;
            $data['pay_period'] = $convert_from;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }
            
        echo json_encode($data); 
        JFactory::getApplication()->close();
    }
    
}  