(function($) {
    function subscriptionCalc() {
        try {
            var lang    =   $('form.form-subscription-calc').attr('data-lang');
            var price   =   0;
            var total   =   0;
            $('form.form-subscription-calc input[type="checkbox"]:checked').each(function(index,input) {
                var local   =   $(input).attr('data-price');
                local       =   parseFloat(local);
                price   =   price + local;
            });
            
            var users   =   $('form.form-subscription-calc .subscr_users').val();
            users       =   parseInt(users);
            
            var discount=   $('form.form-subscription-calc .subscr_discount').val();
            discount    =   parseFloat(discount).toFixed(2);            
            total   =   price;
            
            if(discount > 0) {
            } else {
                discount  = 0;
            }
            if(users > 0) {
            } else {
                users  = 0;
            }
            
            //var percent =   discount * users / 100;    
            //total  = total - (total * percent);
            
            $('form.form-subscription-calc .subscription-submit').hide();
            if(total > 0) {
                $('form.form-subscription-calc .subscription-submit').show();
            }
            
            price   =   parseFloat(price).toFixed(2);
            total   =   parseFloat(total).toFixed(2);
            
            var priceStr    =   new Intl.NumberFormat(lang).format(price);
            var totalStr    =   new Intl.NumberFormat(lang).format(total);
            $('form.form-subscription-calc input.subscription-price').val(price);
            $('form.form-subscription-calc input.subscription-total').val(total);
            $('form.form-subscription-calc input.subscr_price').val(priceStr);
            $('form.form-subscription-calc input.subscr_total').val(totalStr);
            
        } catch (e) {
            console.log("Error: function subscriptionCalc: " + e);
        }
        
    }
    
    function subscriptionSubmit() {
        $('form.form-subscription-calc .subscription-submit').prop( "disabled", true );
        //$('form.form-subscription-calc').submit();       return true;
        
        var post  =  $('form.form-subscription-calc').serialize();
        $.ajax({
            type:   "POST",
            url:    $('form.form-subscription-calc').attr('action'),
            data:   post,            
            dataType:   "json",
            success: function(data) {
                if(data.status != 1) {
                    alert("Error: " + data.message); 
                    return false;
                }
                
                var link  =  data.ApprovalLink;
                if(link != undefined && link.length > 1) {
                    location.href  =  link;
                }
                //$('form.form-subscription-calc .subscription-submit').prop( "disabled", false );
            },
            error: function(XMLHttpRequest, textStatus, errorThrown) {                 
                $('form.form-subscription-calc .subscription-submit').prop( "disabled", false );
                alert("Error: " + errorThrown); 
            }
        });
    }    
    
    $(document).on('change input','form.form-subscription-calc input.subscr_users',function()  {
        subscriptionCalc();
    });    
    $(document).on('change','form.form-subscription-calc input[type="checkbox"]',function()  {
        subscriptionCalc();
    });
    $(document).on('click','form.form-subscription-calc .subscription-submit',function()  {
        subscriptionSubmit();
    });
    $(document).ready(function() {
        $('form.form-subscription-calc .subscription-submit').hide();
        
        $('form.form-subscription-calc input.subscr_users').mask("000", {
            translation: {
                'r': {
                  pattern: /[\/]/,
                  fallback: '/'
                },
                placeholder: "000"
            }
        });
        
        subscriptionCalc();
    });                         
})(jQuery);

