'use strict';
(function($) {       
    function saveHtmlCalculator() {        
        if($(".saveDataWrap .moduletable #Calculator").length > 0) {            
            $(".saveDataWrap .moduletable #Calculator input").each(function(index,input) {
                $(input).attr("data-saved-value",$(input).val());
            });
            $(".saveDataWrap .moduletable #Calculator select").each(function(index,input) {                
                $(input).attr("data-saved-value",$("option:selected",input).text());
            });
            var html  = $(".saveDataWrap .moduletable #Calculator").html();
            
            $(".input-group-addon",html).each(function(index,addon) {
                var formGroup       =   $(addon).closest(".input-group");                
                var formGroupStr    =   $(formGroup).html();
                var tmpTable    =   "<table class='input_union'><tr><td class='td_input'>"+$("input",formGroup).attr("data-saved-value")+"</td><td class='td_union'>"+$(addon).text()+"</td></table>";
                html =  html.replace(formGroupStr,tmpTable);                
            });
            
            $('input[type="radio"]',html).each(function(index,input) {
                var label       =   $(input).closest("label");
                if($(input).is(":checked")) {
                    var text  =  $(label).text();
                    var input2 =  '<div class="input-wrap" >'+text+'</div>';
                    html =  html.replace($(label).html(),input2);                
                } else {
                    var text  =  $(label).text();
                    var input2 =  '<div class="input_wrap_not_selected" >'+text+'</div>';
                    html =  html.replace($(label).html(),input2);                
                }
            });
            
            var tableResults    = $("table.table-results",html).html();
            html =  html.replace(tableResults,"");                
            
            /*
            $(".input-group-addon",html).each(function(index,addon) {
                var formGroup       =   $(addon).closest(".form-group");                
                var formGroupStr    =   $(formGroup).html();
                var tmpTable    =   "<table class='input_union'><tr><td class='td_input'>"+$("input",formGroup).attr("data-saved-value")+"</td><td class='td_union'>"+$(addon).text()+"</td><tr></table>";
                html =  html.replace(formGroupStr,tmpTable);                
            });
            */
            var uid   = $(".saveDataWrap").attr("data-uid");
            window.dataSave.save("calculatorHtml",html,uid,function()   {                
                
                try {
                    if(window.afterSaveCalculatorHtml != undefined) {
                        window.afterSaveCalculatorHtml(uid);
                    }
                } catch (e) {
                    alert(e);
                }
                
            });
        }
    }
    
    window.saveHtmlCalculator  = saveHtmlCalculator;
    
    var saveFuncId = null;
    document.addEventListener("calculator_draw_complete", function(e) {    
        
        console.log("Save HTML [0]");
        
        clearTimeout(saveFuncId);
        saveFuncId = setTimeout(function(){
            console.log("Save HTML");
            saveHtmlCalculator();
        },3000);
    });
})(jQuery);

jQuery(document).ready(function ($) {
    
    let js = $;
      
    js('.home_h3_checkbox a').live('mouseover', function(){
       let this0=js(this);
       
       this0.find('span').addClass('js_mouseover');
    });
    js('.home_h3_checkbox a').live('mouseout', function(){
       let this0=js(this);
       
       this0.find('span').removeClass('js_mouseover');
    });
    let interval=setInterval(function(){
        js('.icon-caret-right').removeClass('icon-caret-right').addClass('fa').addClass('fa-caret-right');
    }, 100);
    
    
    
    js('#add_total').live('click', function(){
        console.log('load totals');
        
        let 
            item = js(this),
            url = new Url(),
            u_id = url.query.u_id,
            path=url.path.split('/'),
            lang,
            from_to={
                'from': js('#from').val(),
                'to':   js('#to').val()
            };
       
        item.attr('disabled', 'disabled');
        console.log(url);
        console.log(path); 
        console.log(from_to);
        
        if(path[1]=='is'){
            lang='is';
        } else{
            lang='en';
        }
        //u_id='';
        //lang='';
        
        js.ajax({
            type: "POST",
            url: '/index.php?task=loadBottomTotals',
            async: true,
            data: ({"u_id": u_id, "lang": lang, "from_to": from_to}),
            dataType: "json",
            success: function(data){
                console.log(data);
                item.removeAttr('disabled');
                
                if(data.errors != null && data.errors.length>0){
                    alert(data.errors);         
                } 
                    
                setNewValuesToCalc(data);
            }
        });
    });
    
    
    js('#open_earned_income').live('click', function(){
        console.log('open Earned income');
        
        let 
            item = js(this),
            url = new Url(),
            u_id = url.query.u_id,
            path=url.path.split('/'),
            lang,
            calc_params=getCalcParams(),
            from_to={
                'from': js('#from').val(),
                'to':   js('#to').val()
            },
            new_url = url.path+'?u_id='+url.query.u_id,//build clear url
            state = { },
            title = ''; 
                    

        item.attr('disabled', 'disabled');
        console.log(url);
        console.log(path);
        
        if(path[1]=='is'){
            lang='is';
        } else{
            lang='en';
        }
        //u_id='';
        //lang='';
        
        js.ajax({
            type: "POST",
            url: '/index.php?task=saveDataForEarnedIncome',
            async: true,
            data: ({"u_id": u_id, "lang": lang, "calc_params": calc_params, "from_to": from_to}),
            dataType: "json",
            success: function(data){
                console.log(data);
               
                
                if(data.errors != null && data.errors.length>0){
                    alert(data.errors);
                    return false;
                } 

                //return false;
                
                js('.js_event_load_earned_income').load('/index.php?task=viewEarnedIncomeNewPsd', {
                    "u_id": u_id,
                    "lang": lang,
                    "calc_params": calc_params,
                    "pay_period": data.pay_period
                }, function(){
                    js('#right-body').addClass('earned_income');   
                    item.removeAttr('disabled');
                    history.pushState(state, title, '');
                    history.pushState(state, title, new_url);
                    js('body').addClass('view-earned_income');
                }); 
            }
        });
    });
   
    
    
    js('#get_earned_income_period').live('click', function(){
        console.log('get Earned income as period');
        
        let 
            item = js(this),
            url = new Url(),
            u_id = url.query.u_id,
            path=url.path.split('/'),
            lang,
            
            from_to={
                'from': js('#from_e').val(),
                'to':   js('#to_e').val()
            };
        ;
       
        item.attr('disabled', 'disabled');
        console.log(url);
        console.log(path);
        
        if(path[1]=='is'){
            lang='is';
        } else{
            lang='en';
        }
       
        
       js.ajax({
            type: "POST",
            url: '/index.php?task=loadEarnedIncomeTable',
            async: false,
            data: ({"u_id": u_id, "lang": lang,  "from_to": from_to, "type": "new_psd"}),
            dataType: "json",
            success: function(data){
                console.log(data);
               
                
                if(data.errors != null && data.errors.length>0){
                    alert(data.errors);
                    return false;
                } 
                //js('.earned_income_wrapper').html($("<div>").html(data.html).text());
                js('.earned_income_wrapper').html(data.html);
                js('.item-page-body.calc_new .container:eq(0)').removeClass('container').addClass('container-fluid');
                /*js('.js_event_td_earned_income_total, .js_event_td_calc').each(function(e,i){
                    let item = js(i);
            
                    item.text(FloatToStrCalc(item.text().trim()));
            
                });*/
                item.removeAttr('disabled');
                js('#csv_all_mode').val(0);
            }
        });
    });
    
    js('.pseudo_str_wrapper .pseudo_str_prev').live('click', function(){
        let input_from=js('#from_e').val();

        js.ajax({
            type: "POST",
            url: '/index.php?task=calcPrevMonthForEarnedIncome',
            async: true,
            beforeSend: function(){
                js('.miniloader_wrapper').css('display', 'block');
            },
            data: ({"from": input_from, "mode": '1'}), 
            dataType: "html",
            success: function(data){          
                let  
                    custom_from=data,
                    custom_to=js('#to_e').val();
                
                console.log('from: '+custom_from+' to: '+custom_to);             
                js('#from_e').val(custom_from);                              
                    
                js.ajax({
                    type: "POST",
                    url: '/index.php?task=calcPrevMonthForEarnedIncome',
                    async: false,
                    data: ({"from": custom_from, "mode": '2'}), 
                    dataType: "html",
                    success: function(data){
                        let                                 
                            custom_to1=data;

                        js('#to_e').val(custom_to1); 
                        js('#get_earned_income_period').trigger('click'); 
                        js('.miniloader_wrapper').css('display', 'none');
                    }
                });
                     
            }
        });      
    });
    
    js('.pseudo_str_wrapper .pseudo_str_next').live('click', function(){
        let input_from=js('#from_e').val();
           
        js.ajax({
            type: "POST",
            url: '/index.php?task=calcNextMonthForEarnedIncome',
            async: true,
            beforeSend: function(){
                js('.miniloader_wrapper').css('display', 'block');
            },
            data: ({"from": input_from, "mode": '1'}), 
            dataType: "html",
            success: function(data){
                let           
                    custom_from=data,
                    custom_to=js('#to_e').val();
                
                console.log('from: '+custom_from+' to: '+custom_to);
                    
                js('#from_e').val(custom_from);
                    
                js.ajax({
                    type: "POST",
                    url: '/index.php?task=calcNextMonthForEarnedIncome',
                    async: false,
                    data: ({"from": custom_from, "mode": '2'}), 
                    dataType: "html",
                    success: function(data){
                        let                                 
                            custom_to1=data;

                        js('#to_e').val(custom_to1);
                        js('#get_earned_income_period').trigger('click');
                        js('.miniloader_wrapper').css('display', 'none');
                    }
                });      
            }
        });
    });
    
    
    js('#default_period').live('click', function(){
        console.log('get default period');
        
        let 
            item = js(this),
            url = new Url(),
            u_id = url.query.u_id,
            path=url.path.split('/'),
            lang
            
            /*from_to={
                'from': js('#from_e').val(),
                'to':   js('#to_e').val()
            };*/
        ;
       
        item.attr('disabled', 'disabled');
        console.log(url);
        console.log(path); 
        
        if(path[1]=='is'){
            lang='is';
        } else{
            lang='en';
        }
       
        
       js.ajax({
            type: "POST",
            url: '/index.php?task=loadEarnedIncomeTableDefault',
            async: false,
            data: ({"u_id": u_id, "lang": lang, "type": "new_psd"}),
            dataType: "json",
            success: function(data){
                console.log(data);
               
                
                if(data.errors != null && data.errors.length>0){
                    alert(data.errors);
                    return false;
                } 
          
                js('.earned_income_wrapper').html(data.html);
                js('.item-page-body.calc_new .container').removeClass('container').addClass('container-fluid');
                /*js('.js_event_td_earned_income_total, .js_event_td_calc').each(function(e,i){
                    let item = js(i);
            
                    item.text(FloatToStrCalc(item.text().trim()));
            
                });*/
                item.removeAttr('disabled');
                js('#csv_all_mode').val(1);
            }
        });
    });
    
    js('.js_event_close_earned_income').live('click', function(){
        let 
            url = new Url(),
            new_url = url.path+'?u_id='+url.query.u_id;
            
                    
        console.log(new_url);
        //return false;
        //document.location.reload(true);
        document.location.href = new_url;
       
    });
    
    
    
    //test load calculator, emulate saved data
    /*let 
        url = new Url(),
        u_id = url.query.u_id;
             
    jQuery.ajax({ 
        type: 'POST',
        cache: false,
        dataType: "html",
        url: 'index.php?option=com_ajax&format=raw&task=draw',
        data: {
            'hpm': 173.33,
            'salaries': 328711,
            'title': 'Launaflokkur nr. 4',
            'birthday': '',
            'contract': 0,
            'union': 1,
            'module': 'customcalc4',
            'u_id': u_id
        },
        success: function (data) {
            jQuery("#load_calculator").html(data);
            jQuery("#lipage6").removeClass("disable");
            jQuery("#apage6").click();
        }
    });*/
    
    document.addEventListener("calculator_draw_complete", function(e) {
        console.log('calculator_draw_complete event listener');
        console.log(e);
        
        let 
            url = new Url(),
            u_id = url.query.u_id,
            show = url.query.show,
            earned_income_row_id = url.query.ein_id,
            path = url.path.split('/'),
            lang,
            
            from = url.query.from_p,
            to = url.query.to_p
        ;

        if(path[1] == 'is'){
            lang = 'is';
        } else{
            lang = 'en';
        }
       
        js('#add_total').trigger('click');
        if(from != null && from.length>0 && to != null && to.length>0){
            console.log('add period to inputs with from='+from+' and to='+to);
            
            js('#from').val(from);
            js('#to').val(to);
            
            
            //my_calc();
        
        
            //dont remove next:
            console.log('earned_income_row_id='+earned_income_row_id);
            js.ajax({
                type: "POST",
                url: '/index.php?task=loadEarnedIncomeRecord',
                async: false,
                data: ({"u_id": u_id, "lang": lang, "id": earned_income_row_id}),
                dataType: "json",
                success: function(data){
                    console.log(data);
               
                
                    if(data.errors != null && data.errors.length>0){
                        alert(data.errors);
                        return false;
                    } 
                    setTimeout(function(){
                        let 
                        results = data.row,
                        daytime = results.c_daytime,
                        overwork = results.c_owerwork,
                        holidays = results.c_holidays,
                        
                        p_lif = results.p_lif,
                        p_lif_match = results.p_lif_match,
                        p_lif_r = results.p_lif_r,
                        p_ser = results.p_ser, 
                        p_ser_match = results.p_ser_match,
                        in_g = results.in_g,
                        u_membership = results.u_membership,
                        u_healthcare = results.u_healthcare,
                        u_vacation = results.u_vacation,
                        u_education = results.u_education,
 
                        holiday1 = results.holiday1,
                        holiday2 = results.holiday2, 
                        holiday3 = results.holiday3,
                        holiday4 = results.holiday4,
                        holiday5 = results.holiday5,
                        value_step1 = results.value_step1, 
                        value_step2 = results.value_step2,
                        value_step3 = results.value_step3,
                        ch = results.ch,
                        td_self = results.td_self,
                        td_spouse = results.td_spouse,
                        td_unused = results.td_unused,
                        td_unused_spouse = results.td_unused_spouse,
                        
                        //
                        v_night = results.v_night,
                        unit_shift1 = results.unit_shift1,
                        unit_shift2 = results.unit_shift2,
                        unit_shift3 = results.unit_shift3,
                        shift_work = results.shift_work,
                        proc_shift1 = results.proc_shift1,
                        proc_shift2 = results.proc_shift2,
                        v_daytime = results.v_daytime,                        
                        other_salary1 = results.other_salary1,
                        other_salary2 = results.other_salary2,
                        other_salary3 = results.other_salary3,
                        other_salary4 = results.other_salary4,
                        red_checkboxes = results.red_checkboxes;
        
                    if(overwork != null){
                        js('input[name="c_owerwork"]').val(overwork);
                    } if(holidays != null){
                        js('input[name="c_holidays"]').val(holidays);
                    } if(daytime != null){
                        js('input[name="c_daytime"]').val(daytime);
                    } if(p_lif != null){
                       js('input[name="p_lif"]').val(p_lif);
                    } if(p_lif_match != null){
                        js('input[name="p_lif_match"]').val(p_lif_match);
                    } if(p_lif_r != null){
                        js('input[name="p_lif_r"]').val(p_lif_r);
                    } if(p_ser != null){
                        js('input[name="p_ser"]').val(p_ser);
                    } if(p_ser_match != null){
                        js('input[name="p_ser_match"]').val(p_ser_match);
                    } if(in_g != null){
                        js('input[name="in_g"]').val(in_g);
                    } if(u_membership != null){
                        js('input[name="u_membership"]').val(u_membership);
                    } if(u_healthcare!= null){
                        js('input[name="u_healthcare"]').val(u_healthcare);
                    } if(u_vacation != null){
                        js('input[name="u_vacation"]').val(u_vacation);
                    } if(u_education != null){
                        js('input[name="u_education"]').val(u_education);
                    } if(holiday1 != null){
                        js('input[name="holiday1"]').val(holiday1);
                    } if(holiday2 != null){
                        js('input[name="holiday2"]').val(holiday2);
                    } if(holiday3 != null){
                        js('input[name="holiday3"]').val(holiday3);
                    } if(holiday4 != null){
                        js('input[name="holiday4"]').val(holiday4);
                    } if(holiday5 != null){
                        js('input[name="holiday5"]').val(holiday5);
                    } if(value_step1 != null){
                        js('input[name="value_step1"]').val(value_step1);
                    } if(value_step2 != null){
                        js('input[name="value_step2"]').val(value_step2);
                    } if(value_step3 != null){
                        js('input[name="value_step3"]').val(value_step3);
                    } if(ch != null){
                        js('input[name="ch"]').val(ch);
                    } if(td_self != null){
                        js('input[name="td_self"]').val(td_self);
                    } if(td_spouse != null){
                        js('input[name="td_spouse"]').val(td_spouse);
                    } if(td_unused != null){
                        js('input[name="td_unused"]').val(td_unused);
                    } if(td_unused_spouse != null){
                        js('input[name="td_unused_spouse"]').val(td_unused_spouse);
                    } 
                    //
                    if(v_night != null){
                        js('input[name="v_night"]').val(v_night);
                    } if(unit_shift1 != null){
                        js('input[name="unit_shift1"]').val(unit_shift1);
                    } if(unit_shift2 != null){
                        js('input[name="unit_shift2"]').val(unit_shift2);
                    } if(unit_shift3 != null){
                        js('input[name="unit_shift3"]').val(unit_shift3);
                    } if(shift_work != null){
                        js('input[name="shift_work"]').val(shift_work);
                    } if(proc_shift1 != null){
                        js('input[name="proc_shift1"]').val(proc_shift1);
                    } if(proc_shift2 != null){
                        js('input[name="proc_shift2"]').val(proc_shift2);
                    } if(v_daytime != null){
                        js('input[name="v_daytime"]').val(v_daytime);
                    } if(other_salary1 != null){
                        js('input[name="other_salary1"]').val(other_salary1);
                    } if(other_salary2 != null){
                        js('input[name="other_salary2"]').val(other_salary2);
                    } if(other_salary3 != null){
                        js('input[name="other_salary3"]').val(other_salary3);
                    } if(other_salary4 != null){
                        js('input[name="other_salary4"]').val(other_salary4);
                    }
                   
                   
                    js('.cbsr[data-val="'+red_checkboxes+'"]').trigger('click');
                    my_calc();//external func
                    //alert(red_checkboxes);
                   
                    
                    console.log('overwork'+overwork.length);
                    if(
                            (overwork == null || overwork.length == 0) && 
                            (holidays == null || holidays.length == 0) && 
                            (daytime == null || daytime.length == 0)
                    ){
                        js('#add_total').trigger('click');
                    }
                    }, 1000);
                    
                    
                    
                   
                
               
                }, error: function(xhr, status) {
                    // check if xhr.status is defined in $.ajax.statusCode
                    // if true, return false to stop this function
                    if (typeof this.statusCode[xhr.status] != 'undefined') {
                        return false;
                    }
                    // else continue
                    console.log(xhr);
                    alert('Error in server with code '+xhr.status+' and text: '+xhr.statusText);
                }, statusCode: {
                    /*404: function(response) {
                        console.log('ajax.statusCode: 404');
                    }*/
                }          
            });
        }
    });
    
    js('#li_clear_open_earning_income').live('click', function(e){
        //alert('click');
        
        let 
            item = js(this),
            url = new Url(),
            u_id = url.query.u_id,
            show = String(url.query.show),
            path=url.path.split('/'),
            lang,
            //calc_params=getCalcParams(),
            from_arr,
            to_arr,
            from_to={
               
            };
            
            if(path[1]=='is'){
                lang='is';
            } else{
                lang='en';
            }
            
            let clear_url_path;
            if(lang == 'is'){
                
                if(show === 'true'){
                   //clear_url_path =  '/'+path[2];
                    clear_url_path =  '/'+path[1]+'/'+path[2];
                } else{
                    clear_url_path =  '/'+path[1]+'/'+path[2];
                }

            } else{
                clear_url_path =  '/'+path[1];
            }
            console.log(path);
           
            let
                new_url = clear_url_path+'?u_id='+url.query.u_id,//build clear url
                state = {},
                title = ''; 
                
        //alert(new_url);
        
        if(js('#from') != null && js('#from').length>0 && js('#to') != null && js('#to').length>0){
            from_arr = js('#from').val().split('.');
            to_arr = js('#to').val().split('.');
            
            from_to['from'] = from_arr[2]+'-'+from_arr[1]+'-'+from_arr[0];
            from_to['to'] = to_arr[2]+'-'+to_arr[1]+'-'+to_arr[0];
            
        } else{
            from_arr = js('#def_from').val().split('.');
            to_arr = js('#def_to').val().split('.');
            
            from_to['from'] = from_arr[2]+'-'+from_arr[1]+'-'+from_arr[0];
            from_to['to'] = to_arr[2]+'-'+to_arr[1]+'-'+to_arr[0];
        }
        
        //return false;
        item.attr('disabled', 'disabled');
       
        
        
        //u_id='';
        //lang='';
        console.log(from_to);
        
                
        js('.js_event_load_earned_income').load('/index.php?task=viewEarnedIncomeNewPsd', {
            "u_id": u_id,
            "lang": lang,
            "pay_period": from_to
        }, function(){
            js('#right-body').addClass('earned_income');   
            //item.removeAttr('disabled');
            history.pushState(state, title, '');
            history.pushState(state, title, new_url);
            js('body').addClass('view-earned_income');
            js('.item-page-body.calc_new .container:eq(0), .item-page-calc_new').removeClass('container').addClass('container-fluid');
            js('.table_earned_income').addClass('table');
            js('#css_style-1').remove();
            
            js('#load_calc_tab').removeAttr('id').addClass('js_event_close_earned_income');
            js('#li_clear_open_earning_income').remove();
            
            //add event about loading earned income page completed
            document.dispatchEvent(new CustomEvent("earned_income_draw_complete", {
                detail: { 
                                       
                }
            }));
        }); 

        return false;
    });
    
    js('#js_event_create_csv_current_user').live('click', function(){
        console.log('saving csv current user...');
        
        let 
            item = js(this),
            get_all_mode = js('#csv_all_mode').val(),
            url = new Url(),
            u_id = url.query.u_id,
            path=url.path.split('/'),
            lang,
            from_to={
                'from': js('#from_e').val(),
                'to':   js('#to_e').val()
            };
            
       
        //alert(get_all_mode);
        
               
        
        if(path[1]=='is'){
           lang='is';
        } else{
            lang='en';
        }
            
        //u_id='';
        //lang='';
        //from_to='';
            
        js.ajax({
            type: "POST",
            url: '/index.php?task=createCsvEarnedIncome',
            async: true,
            data: ({"u_id": u_id, "lang": lang, "period": from_to, "get_all_mode": get_all_mode}), 
            dataType: "json",
            beforeSend: function(){
                item.hide();
                js('.csv_loader.loader-current_user_csv_wr').addClass('csv_loader_visible');
            },
            success: function(data){
                console.log(data);
                       
                item.show();
                js('.csv_loader.loader-current_user_csv_wr').removeClass('csv_loader_visible');
                      
                if(data.errors != null && data.errors.length>0){
                    alert(data.errors);
                    return false;
                } 
                
                if(data.res != null && data.res.length>0){
                    //window.location.href = data.res;
                    window.location.href = '/system_addons/download_csv_earned_income.php?filename='+data.res+'&typefile=ind'; 
                }
                
   
            }, error: function(xhr, status) {
                item.show();
                js('.csv_loader.loader-current_user_csv_wr').removeClass('csv_loader_visible');
                
                // check if xhr.status is defined in $.ajax.statusCode
                // if true, return false to stop this function
                if (typeof this.statusCode[xhr.status] != 'undefined') {
                    return false;
                }
                
                // else continue
                console.log(xhr);
                alert('save csv: Error in server with code '+xhr.status+' and text: '+xhr.statusText);
            }, statusCode: {
                /*404: function(response) {
                    console.log('ajax.statusCode: 404');
                }*/
            } 
        });
    });
    
    js('#js_event_create_csv_company').live('click', function(){
        console.log('saving csv company...');

        let 
            item = js(this),
            get_all_mode = js('#csv_all_mode').val(),
            url = new Url(),
            u_id = url.query.u_id,
            path=url.path.split('/'),
            lang,
            from_to={
                'from': js('#from_e').val(),
                'to':   js('#to_e').val()
            };
            
       
        //alert(get_all_mode);
        
               
        
        if(path[1]=='is'){
           lang='is';
        } else{
            lang='en';
        }
            
        //u_id='';
        //lang='';
        //from_to='';
            
        js.ajax({
            type: "POST",
            url: '/index.php?task=createCsvAllUsersEarnedIncome',
            async: true,
            data: ({"u_id": u_id, "lang": lang, "period": from_to, "get_all_mode": get_all_mode}), 
            dataType: "json",
            beforeSend: function(){
                item.hide();
                js('.csv_loader.loader-company_csv_wr').addClass('csv_loader_visible');
            },
            success: function(data){
                console.log(data);
                       
                item.show();
                js('.csv_loader.loader-company_csv_wr').removeClass('csv_loader_visible');
                      
                if(data.errors != null && data.errors.length>0){
                    alert(data.errors);
                    return false;
                } 
                
                if(data.res != null && data.res.length>0){
                    //window.location.href = data.res;
                    window.location.href = '/system_addons/download_csv_earned_income.php?filename='+data.res+'&typefile=company';
                }
                
   
            }, error: function(xhr, status) {
                item.show();
                js('.csv_loader.loader-company_csv_wr').removeClass('csv_loader_visible');
                
                // check if xhr.status is defined in $.ajax.statusCode
                // if true, return false to stop this function
                if (typeof this.statusCode[xhr.status] != 'undefined') {
                    return false;
                }
                
                // else continue
                console.log(xhr);
                alert('save csv: Error in server with code '+xhr.status+' and text: '+xhr.statusText);
            }, statusCode: {
                /*404: function(response) {
                    console.log('ajax.statusCode: 404');
                }*/
            } 
        });
    });
    
    js('#js_event_create_excel_company').live('click', function(){
        console.log('saving excel company...');

        let 
            item = js(this),
            get_all_mode = js('#csv_all_mode').val(),
            url = new Url(),
            u_id = url.query.u_id,
            path=url.path.split('/'),
            lang,
            from_to={
                'from': js('#from_e').val(),
                'to':   js('#to_e').val()
            },
            loader = js('.csv_loader.loader-company_excel_wr');
            
       
        //alert(get_all_mode);
        
               
        
        if(path[1]=='is'){
           lang='is';
        } else{
            lang='en';
        }
            
        //u_id='';
        //lang='';
        //from_to='';
            
        js.ajax({
            type: "POST",
            url: '/index.php?task=createCsvAllUsersEarnedIncomeExcel',
            async: true,
            data: ({"u_id": u_id, "lang": lang, "period": from_to, "get_all_mode": get_all_mode}), 
            dataType: "json",
            beforeSend: function(){
                item.hide();
                loader.addClass('csv_loader_visible');
            },
            success: function(data){
                console.log(data);
                       
                item.show();
                loader.removeClass('csv_loader_visible');
                      
                if(data.errors != null && data.errors.length>0){
                    alert(data.errors);
                    return false;
                } 
                
                if(data.res != null && data.res.length>0){
                    //window.location.href = data.res;
                    window.location.href = '/system_addons/download_excel_earned_income.php?filename='+data.res+'&typefile=company';
                }
                
   
            }, error: function(xhr, status) {
                item.show();
                loader.removeClass('csv_loader_visible');
                
                // check if xhr.status is defined in $.ajax.statusCode
                // if true, return false to stop this function
                if (typeof this.statusCode[xhr.status] != 'undefined') {
                    return false;
                }
                
                // else continue
                console.log(xhr);
                alert('save excel: Error in server with code '+xhr.status+' and text: '+xhr.statusText);
            }, statusCode: {
                /*404: function(response) {
                    console.log('ajax.statusCode: 404');
                }*/
            } 
        });
    });
    
    momentaryShowEIListener();
    
    /*  
       * Global function momentary show earned income page if in url query params show === 'true'.
       * 
       * @param {undefined}
       * @returns {undefined}
    */
    function momentaryShowEIListener(){
        let 
            url = new Url(),
            show = String(url.query.show),
            path=url.path.split('/'),
            lang;
        
        if(path[1]=='is'){
            lang='is';
        } else{
            lang='en';
        }
        
        if(show === 'true'){
            js('#li_clear_open_earning_income').trigger('click');
        }
    }
    
    /*  
       * Global function for set pay period .tr_bottom values to calc cells.
       * 
       * @param {object} data
       * @returns {undefined}
    */
    function setNewValuesToCalc(data){
        let 
            results = data.final_res,
            //total = results.total,
            daytime = results.daytime,
            overwork = results.overwork,
            holidays = results.holidays;
        
        if(overwork != null){
            js('input[name="c_owerwork"]').val(overwork);
        } if(holidays != null){
            js('input[name="c_holidays"]').val(holidays);
        } if(daytime != null){
            js('input[name="c_daytime"]').val(daytime);
        }
        
        my_calc();//external func
    }
    
    /*  
       * Global function for set pay period .tr_bottom values to calc cells.
       * 
       * @param {object} data
       * @returns {undefined}
    */
    function getCalcParams(){
        let 
            //pension_val_arr=js('.js-calc-set-value-p_l:eq(0)').text().split(','),
            params={
                'statutory_pension_employed': StrToFloatCalc(js('.for_addons_statutory_pension:eq(0)').text()),
                'private_pension_employed': StrToFloatCalc(js('.for_addons_private_pension:eq(0)').text()),
                'statutory_pension_employer': StrToFloatCalc(js('.for_addons_statutory_pension_employer:eq(0)').text()),
                'private_pension_employer': StrToFloatCalc(js('.for_addons_private_pension_employer:eq(0)').text()),
                'insurance_fee_employer': StrToFloatCalc(js('.for_addons_insurance_fee_employer:eq(0)').text()),
                'union_employed': StrToFloatCalc(js('.for_addons_union_employed:eq(0)').text()),
                'union_employer': StrToFloatCalc(js('.for_addons_union_employer:eq(0)').text()),
                'holiday_employer': StrToFloatCalc(js('.for_addons_holiday_employer:eq(0)').text()),
                'income_tax_employed': StrToFloatCalc(js('.for_addons_income_tax_employed:eq(0)').text()),
                'personal_tax': StrToFloatCalc(js('.for_addons_personal_tax:eq(0)').text()),
                'salaries': StrToFloatCalc(js('.for_addons_salaries:eq(0)').val()),
                'take_home_pay': StrToFloatCalc(js('.for_addons_take_home_pay:eq(0)').val()),
                'total_cost': StrToFloatCalc(js('.for_addons_total_cost:eq(0)').val()),
                'c_owerwork': js('input[name="c_owerwork"]').val(),
                'c_holidays': js('input[name="c_holidays"]').val(),
                'c_daytime': js('input[name="c_daytime"]').val(),
                
                'p_lif': js('input[name="p_lif"]').val(),
                'p_lif_match': js('input[name="p_lif_match"]').val(),
                'p_lif_r': js('input[name="p_lif_r"]').val(),
                'p_ser': js('input[name="p_ser"]').val(),
                'p_ser_match': js('input[name="p_ser_match"]').val(),
                'in_g': js('input[name="in_g"]').val(),
                'u_membership': js('input[name="u_membership"]').val(),
                'u_healthcare': js('input[name="u_healthcare"]').val(),
                'u_vacation': js('input[name="u_vacation"]').val(),
                'u_education': js('input[name="u_education"]').val(),
                
                'holiday1': js('input[name="holiday1"]').val(),
                'holiday2': js('input[name="holiday2"]').val(),
                'holiday3': js('input[name="holiday3"]').val(),
                'holiday4': js('input[name="holiday4"]').val(),
                'holiday5': js('input[name="holiday5"]').val(),
                
                'value_step1': js('input[name="value_step1"]').val(),
                'value_step2': js('input[name="value_step2"]').val(),
                'value_step3': js('input[name="value_step3"]').val(),
                'ch': js('input[name="ch"]').val(),
                'td_self': js('input[name="td_self"]').val(),
                'td_spouse': js('input[name="td_spouse"]').val(),
                'td_unused': js('input[name="td_unused"]').val(),
                'td_unused_spouse': js('input[name="td_unused_spouse"]').val(),
                
                //
                'v_night': StrToFloatCalc(js('input[name="v_night"]').val()),
                'unit_shift1': StrToFloatCalc(js('input[name="unit_shift1"]').val()),
                'unit_shift2': StrToFloatCalc(js('input[name="unit_shift2"]').val()),
                'unit_shift3': StrToFloatCalc(js('input[name="unit_shift3"]').val()),
                'shift_work': StrToFloatCalc(js('input[name="shift_work"]').val()),
                'proc_shift1': StrToFloatCalc(js('input[name="proc_shift1"]').val()),
                'proc_shift2': StrToFloatCalc(js('input[name="proc_shift2"]').val()),
                'v_daytime': StrToFloatCalc(js('input[name="v_daytime"]').val()),
                'other_salary1': StrToFloatCalc(js('input[name="other_salary1"]').val()),
                'other_salary2': StrToFloatCalc(js('input[name="other_salary2"]').val()),
                'other_salary3': StrToFloatCalc(js('input[name="other_salary3"]').val()),
                'other_salary4': StrToFloatCalc(js('input[name="other_salary4"]').val()),
                'red_checkboxes': js('#red_checkboxes').val()
            };
        
        /*if(js('#red_checkboxes').val()){
            
        }*/
       // alert(js('#red_checkboxes').val());
        //return false;
        return params;
    }
    
   js('.cbsr').live('click', function(){
        let 
            item = js(this),
            val = item.attr('data-val');
        
        js('#red_checkboxes').val(val);
        
   });
    
    /*  
       * Global function for convert string to float
       * 
       * @param {string} a
       * @returns {float} a
    */
    function StrToFloatCalc( a ){ if(a==""||a=="0") return parseFloat(0); if((a+"").indexOf(",")>0) return parseFloat((a+"").replace(".","").replace(",",".")); else return parseFloat(a); }
   
   /*  
       * Global function for convert float to string
       * 
       * @param {float} a
       * @returns {string} a
    */
    function FloatToStrCalc( a ){ 
	var b = parseFloat(a).toFixed(2);
	var result = new Array(); var j = 0;
	if(b.length>0) for(var i=0; i<b.length; i++) { 
		if(( (b.length - i ) % 3)==0&&(b.length - i)>5&&i>0) result.push('.');
		if(b[i]=='.') result.push(','); else result.push(b[i]); 
	}  
	return result.join(""); 
    } 
    
    /*  
       * Global function for convert float to string
       *  
       * @param {float} a
       * @returns {string} a
    */
    function FloatToStrCalc2( a ){
	var b = parseFloat(a).toFixed();
	var result = new Array(); var j = 0;
	if(b.length>0) for(var i=0; i<b.length; i++) {
		if(( (b.length - i ) % 3)==0&&(b.length - i)>2&&i>0) result.push('.');
		if(b[i]=='.') break; else result.push(b[i]);
    }
    return result.join("");
}
});
