<?php
// Set flag that this is a parent file.
const _JEXEC = 1;
/*error_reporting(E_ALL | E_NOTICE);
ini_set('display_errors', 1);*/
// Load system defines
if (file_exists(dirname(__DIR__) . '/defines.php')){
    require_once dirname(__DIR__) . '/defines.php';
}
if (!defined('_JDEFINES'))  {
    define('JPATH_BASE', dirname(__DIR__));
    require_once JPATH_BASE . '/includes/defines.php';
}
require_once JPATH_LIBRARIES . '/import.legacy.php';
require_once JPATH_LIBRARIES . '/cms.php';
// Load the configuration
require_once JPATH_CONFIGURATION . '/configuration.php';

JFactory::getApplication('site');

class SyncUnicontaTasksCli extends JApplicationCli   {
    
    public $model;
    public $db;
    
    public function __construct() 
    {
        parent::__construct();
        
        $this->table_name = '#__uniconta_tasks';
        $this->db = JFactory::getDBO();
        $this->config = JFactory::getConfig();
        $this->enable_uniconta_tasks = $this->config->get('enable_uniconta_tasks');
        JLoader::register('AuditModelUniconta', JPATH_BASE . '/components/com_audit/models/uniconta.php');
        $this->model = JModelLegacy::getInstance('Uniconta', 'AuditModel');
        $this->subtask_table_name = '#__uniconta_subtasks';
    }
    
    private function getAllManagers()
    {
        $query = "SELECT `company`, `id`, `username0`, `username`, `name`, `owner_id`, `dk_token`, `sync_dk_tasks`, `uniconta_uname`, `uniconta_upassw`, `sync_uniconta_tasks` FROM #__users ORDER BY `id` ASC";
        $this->db->setQuery($query);
        return $this->db->loadAssocList();
    }
    
    private function superUnique($array, $key)
    {
        $temp_array = [];
        foreach ($array as &$v) {
            if (!isset($temp_array[$v[$key]]))
                $temp_array[$v[$key]] =& $v;
        }
        $array = array_values($temp_array);
        return $array;
    }

    public function doExecute() 
    {
        if($this->enable_uniconta_tasks == '1'){
            $this->out('Start working...');
            
            $all_managers = $this->getAllManagers();
            $prepared_manager_list = $this->superUnique($all_managers, 'company');
            
            
            foreach($prepared_manager_list as $one_company){
                if($this->enable_uniconta_tasks == '1' && !empty($one_company['uniconta_uname']) && !empty($one_company['uniconta_upassw']) && $one_company['sync_uniconta_tasks'] == 1){ 
                   
                    $task_list_from_api = $this->getTaskListFromApi($one_company)['tasks'];
                    
                    foreach($task_list_from_api as $one_task_in_api){
                        if(!empty($one_task_in_api->Number)){
                            $this->updateTaskInfo($one_task_in_api, $one_company['owner_id']);//update or insert
                        }
                    }
                    //$this->out(print_r($task_list_from_api, true));
                    $subtask_list_from_api = $this->getTaskListFromApi($one_company)['subtasks'];
                    $this->out('$subtask_list_from_api')->out(print_r($subtask_list_from_api, true));
                    foreach($subtask_list_from_api as $one_subtask_in_api){
                        if(!empty($one_subtask_in_api->Number)){
                            $this->updateSubtaskInfo($one_subtask_in_api, $one_company['owner_id']);//update or insert
                        }
                    }
                }
            }
            $this->out('Stop');
        }
       
        
    }  
    
    private function updateTaskInfo($api_task_obj, $owner_id)
    {

        $query = "SELECT * FROM $this->table_name WHERE `number0` = '".$api_task_obj->Number."' AND `id_user` = '".$owner_id."' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $saved_task = $this->db->loadObjectList()[0];
        //$this->out($query);

        if(!empty($saved_task) && ($saved_task->name !== $api_task_obj->Name || $saved_task->account !== $api_task_obj->DebtorName)){
            //$query = "UPDATE $this->table_name SET `text`='".$this->db->escape($api_task_obj->Name)."-updated on:".date('d.m.Y H:i:s')."' WHERE `original_id` = '".$api_task_obj->Number."'";     
            $query = "UPDATE $this->table_name SET `name` = '".$this->db->escape($api_task_obj->Name)."', `account` = '".$this->db->escape($api_task_obj->DebtorName)."' WHERE `number0` = '".$api_task_obj->Number."'";       
            $this->db->setQuery($query);
            $this->db->query();
            
            $mode_for_log = 'update';
            $info_for_log = [
                'mode_for_log' => $mode_for_log,
                //'query' => $query,
                'owner_id' => $owner_id, 
                'logic $saved_task->name !== $api_task_obj->Name' => $saved_task->name !== $api_task_obj->Name,
                'logic $saved_task->account !== $api_task_obj->DebtorName' => $saved_task->account !== $api_task_obj->DebtorName,
                'set name' => $api_task_obj->Name,
                'account' => $api_task_obj->DebtorName,
                'where number0=' => $api_task_obj->Number
            ];
            $this->addLogRecord($owner_id, $info_for_log);
        } elseif(empty($saved_task)){//point
            $item = new stdClass();
            
            $item->id = null;
            $item->number0 = $this->db->escape($api_task_obj->Number);
            $item->name = $this->db->escape($api_task_obj->Name);
            $item->id_user = (int)$owner_id;
            $item->account = $this->db->escape($api_task_obj->DebtorName);
            
            $this->db->insertObject($this->table_name, $item, 'id');
            
            $mode_for_log = 'insert';
            $info_for_log = [
                'mode_for_log' => $mode_for_log,
                'info' => $item,
                'owner_id' => $owner_id,
            ];
            $this->addLogRecord($owner_id, $info_for_log);
        }
       
   }
   
    private function getParentIdByApiMasterProject(string $number, int $owner_id)
    {
        $query = "SELECT `id` FROM $this->table_name WHERE `number0` = '".$number."' AND `id_user` = '".$owner_id."'";
        $this->db->setQuery($query);
        return $this->db->loadResult();
    }
    
    private function updateSubTaskInfo($api_task_obj, $owner_id)
    {

        $query = "SELECT * FROM $this->subtask_table_name WHERE `number0` = '".$api_task_obj->Number."' AND `id_user` = '".$owner_id."' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $saved_task = $this->db->loadObjectList()[0];
        //$this->out($query);
        $parent_id = $this->getParentIdByApiMasterProject($api_task_obj->MasterProject, $owner_id);
        
        if(!empty($saved_task) && ($saved_task->name !== $api_task_obj->Name || $saved_task->account !== $api_task_obj->DebtorName)){
            $query = "UPDATE $this->subtask_table_name SET `name` = '".$this->db->escape($api_task_obj->Name)."', `account` = '".$this->db->escape($api_task_obj->DebtorName)."', `parent_id` = '$parent_id' WHERE `number0` = '".$api_task_obj->Number."'";       
            $this->db->setQuery($query);
            $this->db->query();
            
            $mode_for_log = 'update_subtask';
            $info_for_log = [
                'mode_for_log' => $mode_for_log,
                //'query' => $query,
                'owner_id' => $owner_id, 
                'logic $saved_task->name !== $api_task_obj->Name' => $saved_task->name !== $api_task_obj->Name,
                'logic $saved_task->account !== $api_task_obj->DebtorName' => $saved_task->account !== $api_task_obj->DebtorName,
                'set name' => $api_task_obj->Name,
                'account' => $api_task_obj->DebtorName,
                'parent_id' => $parent_id,
                'where number0=' => $api_task_obj->Number
            ];
            $this->addLogRecord($owner_id, $info_for_log);
        } elseif(empty($saved_task)){//point
            $item = new stdClass();
            
            $item->id = null;
            $item->number0 = $this->db->escape($api_task_obj->Number);
            $item->name = $this->db->escape($api_task_obj->Name);
            $item->id_user = (int)$owner_id;
            $item->account = $this->db->escape($api_task_obj->DebtorName);
            $item->parent_id = $parent_id;
            $this->db->insertObject($this->subtask_table_name, $item, 'id');
            
            $mode_for_log = 'insert_subtask';
            $info_for_log = [
                'mode_for_log' => $mode_for_log,
                'info' => $item,
                'owner_id' => $owner_id,
            ];
            $this->addLogRecord($owner_id, $info_for_log);
        }
   }
    
   private function addLogRecord($owner_id, $info_for_log)
   {
        $item = new stdClass();
            
        $item->id = null;
        $item->owner_id = (int)$owner_id;    
        $item->info = json_encode($info_for_log);
        $item->timestamp_creat = time();
        $item->date_create = date('d.m.Y H:i:s');
            
        $this->db->insertObject('#__uniconta_tasks_cron_log', $item, 'id');
   }
   
    private function getTaskListFromApi($one_company)
    {
        $data = [
           'username' => $one_company['uniconta_uname'],
           'password' => $one_company['uniconta_upassw']
        ];
       
        $responses = $this->model->curlCall($this->model->uniconta_tasks_path, $data, 1);
        //$responses['curl_response'][88]->Name = 'nytt verk TEST';
        //$responses['curl_response'][88]->DebtorName = '007';
        
        $final =[]; 
        if (!empty($responses['curl_response'])) {
            foreach ($responses['curl_response'] as $one_item) {
                if (!property_exists($one_item, 'MasterProject')){
                    $final['tasks'][] = $one_item;
                } else{
                    $final['subtasks'][] = $one_item;
                }
            }  
        }
        
        return $final;
    }
}

JApplicationCli::getInstance('SyncUnicontaTasksCli')->execute();