<?php
// Set flag that this is a parent file.
const _JEXEC = 1;
error_reporting(E_ALL | E_NOTICE);
ini_set('display_errors', 1);
// Load system defines
if (file_exists(dirname(__DIR__) . '/defines.php')){
    require_once dirname(__DIR__) . '/defines.php';
}
if (!defined('_JDEFINES'))  {
    define('JPATH_BASE', dirname(__DIR__));
    require_once JPATH_BASE . '/includes/defines.php';
}
require_once JPATH_LIBRARIES . '/import.legacy.php';
require_once JPATH_LIBRARIES . '/cms.php';
// Load the configuration
require_once JPATH_CONFIGURATION . '/configuration.php';


class SyncDkUsersCli extends JApplicationCli   {
    
    public $syncModel;
    public $db;
    
    public function __construct() {
        parent::__construct();
        
        $this->db = JFactory::getDBO();
        $this->config = JFactory::getConfig();
        
        $this->enable_saving_users_from_dk_api = $this->config->get('enable_saving_users_from_dk_api');
        $this->dk_api_url = 'https://api.dkplus.is/api/v1/general/employee';
        $this->demo_token = '3541031f-baf2-4737-a7e8-c66396e5a5e3';
    }
    
    private function getAllManagers()
    {
        $query = "SELECT `company`, `id`, `username0`, `username`, `name`, `owner_id`, `dk_token`, `sync_dk_users` FROM #__users ORDER BY `id` ASC";
        $this->db->setQuery($query);
        return $this->db->loadAssocList();
    }
    
    private function superUnique($array, $key)
    {
        $temp_array = [];
        foreach ($array as &$v) {
            if (!isset($temp_array[$v[$key]]))
                $temp_array[$v[$key]] =& $v;
        }
        $array = array_values($temp_array);
        return $array;
    }
    
   
    
    public function doExecute() {
        if($this->enable_saving_users_from_dk_api == '1'){
            $this->out('Start working...');
            
           
            
            $all_managers = $this->getAllManagers();
            $prepared_manager_list = $this->superUnique($all_managers, 'company');
            
            
            foreach($prepared_manager_list as $one_company){
               /*if($one_company['owner_id'] != 2863) {
                   continue;
               }*/
                
                if(!empty($one_company['dk_token'] && $one_company['sync_dk_users'] == 1)){ 
                   
                    
                    $users_list_from_dk = $this->loadUsersFromDk($one_company['owner_id']);
                    //$dk_task_list_from_api = $this->getDkTaskListFromApi($one_company['owner_id']);
                    
                    if (!empty($users_list_from_dk)) {
                        $this->out(print_r($one_company, true));
                         
                        if (!empty($users_list_from_dk->Message)) {
                            $this->out($users_list_from_dk->Message);
                            
                            continue;
                        } else {
                            $this->out(print_r($this->addUser($users_list_from_dk, $one_company['owner_id']), true));
                          
                            //$this->out(print_r($users_list_from_dk, true));
                        }
                    } else{ 
                        $this->out(print_r($one_company, true));
                        $this->out('No users from DK');
                    }
                }
            }
           

            $this->out('Stop working...');
        }
       
        
    }  
    
    private function checkUsername($id, $company)
    {
	/*$query = "SELECT `id` FROM #__users WHERE `username0` = '".$id."' AND `company`= '".$company."'";  
        $this->out(print_r($query, true));
        
	$this->db->setQuery($query);
	$users = $this->db->loadObjectList();
        $this->out(print_r($users, true));
        
        $count = count($users);
        $res = 0;
        
        if($count == 0){
            $res = 1;
        }
      
       */
        return 1;
    }
    
    private function checkId($id, $company)
    {
	$query = "SELECT `id` FROM #__users WHERE `username` = '".$id."' AND `company`= '".$company."'";  
        $this->out(print_r($query, true));
        
	$this->db->setQuery($query);
	$users = $this->db->loadObjectList();
        $this->out(print_r($users, true));
        
        $count = count($users);
        $res = 0;
        
        if($count == 0){
            $res = 1;
        }
      
       
        return $res;
    }
    
    private function setFromTo($id_user, $company, $owner_id)
    {
        $query = "SELECT `from_date`, `to_date` FROM #__pay_period_preserved WHERE `id_user` = '$owner_id'";
        $this->db->setQuery($query);
        $res = $this->db->loadObjectList();

        if (!empty($res)) {
            $from_date = $res[0]->from_date;
            $to_date = $res[0]->to_date;
        } else {
            $from_date = '25.'.date('m.Y', strtotime('-1 month'));
            $to_date = '24.'.date('m.Y', strtotime('+0 month'));  
        }
        
        $item = new stdClass();
        $item->id_user = $id_user;
        $item->from_date = $from_date;
        $item->to_date = $to_date;
        
        $this->db->insertObject('#__pay_period_preserved', $item);
    }
    
    private function addUser($dk_user_obj, $owner_id)
    {
        $db = JFactory::getDbo();
        $user = & JFactory::getUser($owner_id);
        
        $this->out(print_r($dk_user_obj, true));
        $final_returned_ids = [];
        
        foreach($dk_user_obj as $one_dk_user){
            if($one_dk_user->Status != 0){
                continue;
            }
            /*if($one_dk_user->Number != '0812993829'){
                continue;
            }*/
            
            $name = strip_tags($db->escape(trim($one_dk_user->Number)));
            $username = strip_tags(trim($one_dk_user->Number));
            $password = $this->generateRandomString(6);
            //$email = strip_tags(trim($one_dk_user->ContactDetail->Email)); 
            $email = strip_tags(trim($one_dk_user->Email)); 
            $unical_id = strip_tags(trim($one_dk_user->Name));              
            //$group_user = strip_tags($db->escape(trim($one_dk_user->group_user)));
            
            $check_username = $this->checkUsername($unical_id, $user->company);
            $check_id = $this->checkId($name, $user->company);
            
            $this->out('$unical_id')->out($unical_id);
            $this->out('$username')->out($username);
            $this->out('$name')->out($name);
            //return '';
            
            if($check_username == 0 || $check_id == 0){
                continue;
            }
            
            $group_user = 'DK';
            
            $item = new stdClass;
            $item->id = NULL;
            $item->name = $name;
            $item->username = $username;
            $item->email = $email;
            $item->password = md5($password);
            $item->password2 = $password;
            $item->registerDate = date('Y-m-d H:i:s');
            $item->activation = 0;
            $item->start_time = 0;               
            $item->unical_id = $unical_id;
            $item->username0 = $unical_id;
            $item->group_user = $group_user;                
            //$item->qty_unit=1;                
            //$item->count_sms_call_in_unit=1000;
                
            if (in_array(6, $user->groups)) {
                $item->owner_id = $owner_id;
            } 
            if (in_array(8, $user->groups)) {
                $item->owner_id = 0;
            }

            $item->company = $user->company;
            $item->subscription = $user->subscription;
            //$item->tel=$tel;
            $item->tel = '+3540000000';
            $item->api_token = hash('sha512', $this->generateRandomString());
                
            $input_date_obj = DateTime::createFromFormat('d.m.Y', date('d.m.Y'));
            $item->work_start_timestamp = $input_date_obj->format('U');
            $item->work_start_date = $input_date_obj->format('d.m.Y');

                
            $db->insertObject('#__users', $item, 'id');           
            $id_user = $db->insertid();
            
            $this->setFromTo($id_user, $user->company, $owner_id);
            $final_returned_ids[] = $id_user;
            
            $item2 = new stdClass;
            $item->id = NULL; 
            $item2->user_id = $id_user;

            $item2->group_id = 9;
            

            $db->insertObject('#__user_usergroup_map', $item2, 'id');

            if (!empty($email)) {
                //$this->sendNotification($email, $username, $password, $id_user);
            }
        }

        return $final_returned_ids;
    }
    
    private function generateRandomString($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyz';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
    
   
    
   /*private function addLogRecord($owner_id, $info_for_log)
   {
        $item = new stdClass();
            
        $item->id = null;
        $item->owner_id = (int)$owner_id;    
        $item->info = json_encode($info_for_log);
        $item->timestamp_creat = time();
        $item->date_create = date('d.m.Y H:i:s');
            
        $this->db->insertObject('#__dk_tasks_cron_log', $item, 'id');
   }*/
   
    
    
    private function loadUsersFromDk($manager_id)
    {
        $url = $this->dk_api_url;
        $manager_obj = JFactory::getUser($manager_id);
        $company_token = $manager_obj->dk_token;
        //$company_token = $this->demo_token; 
        
        $ch = curl_init();
        $authorization = "Authorization: Bearer ".$company_token; // Prepare the authorisation token
        
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            
           
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json',
                $authorization
            ]
        ]);
 
        $result = curl_exec($ch);
        curl_close($ch);
        
       
        $dk_users = json_decode($result);
        
        
        return $dk_users;
    }
}
JApplicationCli::getInstance('SyncDkUsersCli')->execute();
