<?php
// Set flag that this is a parent file.
const _JEXEC = 1;
error_reporting(E_ALL | E_NOTICE);
ini_set('display_errors', 1);
// Load system defines
if (file_exists(dirname(__DIR__) . '/defines.php')){
    require_once dirname(__DIR__) . '/defines.php';
}
if (!defined('_JDEFINES'))  {
    define('JPATH_BASE', dirname(__DIR__));
    require_once JPATH_BASE . '/includes/defines.php';
}
require_once JPATH_LIBRARIES . '/import.legacy.php';
require_once JPATH_LIBRARIES . '/cms.php';
// Load the configuration
require_once JPATH_CONFIGURATION . '/configuration.php';


class SyncUsersCli extends JApplicationCli   {
    
    public $syncModel;
    private $db;
    
    public $options = array(
        'http' => array(
            'method'=>"GET",
            'max_redirects' => 3,            
            'follow_location' => true,
            'timeout' => 30,
        ),
        'ssl'   => array (
            'verify_peer'       => false,
            'verify_peer_name'  => false,
            'allow_self_signed' => true,
        )
    );
    
    public function doExecute() {
        
        $this->out('Fetching api info...');
        $config =   JFactory::getConfig();        
        $url    =   $config->get('current_url');
        $context            =   stream_context_create($this->options);
        
        
        
        $callUrl  = $url."index.php?option=com_ctapi&task=cron.clear";
        echo $callUrl."\r\n";
        echo  @file_get_contents($callUrl, false, $context, 0);
        
        
        for($start  = 0; $start < 1000000; $start += 5) {            
            $callUrl  = $url."index.php?option=com_ctapi&task=cron.index&start=".intval($start);            
            echo $callUrl."\r\n";            
            $content    =   @file_get_contents($callUrl, false, $context, 0);
            $content    =   trim($content);
            if($content == "ok")
                continue;
            
            break;
        }        
        $this->out('Finished fetching api information');
    }    
}
JApplicationCli::getInstance('SyncUsersCli')->execute();
