<?php

// We are a valid entry point.
const _JEXEC = 1;

// Load system defines
if (file_exists(dirname(__DIR__) . '/defines.php')) {
    require_once dirname(__DIR__) . '/defines.php';
}

if (!defined('_JDEFINES')) {
    define('JPATH_BASE', dirname(__DIR__));
    require_once JPATH_BASE . '/includes/defines.php';
}

//define('JPATH_COMPONENT_ADMINISTRATOR', JPATH_ADMINISTRATOR . '/components/com_finder');
// Get the framework.
require_once JPATH_LIBRARIES . '/import.legacy.php';

// Bootstrap the CMS libraries.
require_once JPATH_LIBRARIES . '/cms.php';

// Import the configuration.
require_once JPATH_CONFIGURATION . '/configuration.php';

// System configuration.
$config = new JConfig;
define('JDEBUG', $config->debug);

// Configure error reporting to maximum for CLI output.
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Load Library language
$lang = JFactory::getLanguage();

// Try the finder_cli file in the current language (without allowing the loading of the file in the default language)
$lang->load('com_audit', JPATH_SITE, null, false, false)
// Fallback to the finder_cli file in the default language
        || $lang->load('com_audit', JPATH_SITE, null, true);

//JFactory::getApplication('site');

class SubsctiptionCli extends JApplicationCli {

   
    public $db;

    public function __construct() {
        parent::__construct();

        $this->db = JFactory::getDBO();
        $this->config = JFactory::getConfig();
        $this->enable_settings_subscription_tab = $this->config->get('enable_settings_subscription_tab');
        $this->enable_api_blocking_by_option_from_admin_panel = $this->config->get('enable_api_blocking_by_option_from_admin_panel');
        $this->mod_table = '#__api_company_mods';
        $this->current_url = $this->config->get('current_url');
    }

    private function getAllManagers() {
        $query = "SELECT `company`, `id`, `username0`, `username`, `name`, `owner_id`, `disable_subscription`, `registerDate` FROM #__users WHERE `disable_subscription` = '1' AND `block` = '0' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        return $this->db->loadAssocList();
    }

    private function superUnique($array, $key) {
        $temp_array = [];
        foreach ($array as &$v) {
            if (!isset($temp_array[$v[$key]]))
                $temp_array[$v[$key]] = & $v;
        }
        $array = array_values($temp_array);
        return $array;
    }

    public function doExecute() {
        if ($this->enable_settings_subscription_tab == '1') {
            $this->out('Start working...');

            $all_managers = $this->getAllManagers();
            $prepared_manager_list = $this->superUnique($all_managers, 'company');

            foreach ($prepared_manager_list as $one_company) {
                $this->out('disable subscription for manager id ' . $one_company['id']);
                $this->disableSubscription($one_company);
            }
            $this->out('Stop working.');
        } else {
            $this->out('Enable $enable_settings_subscription_tab in configuration.php for start this script');
        }
    }

    private function disableSubscription(array $one_company) {

        $register_date_string = $one_company['registerDate'];
        
        $register_date_obj = DateTime::createFromFormat('Y-m-d H:i:s', $register_date_string);
        $register_date_obj_final = DateTime::createFromFormat('Y-m-d H:i:s',   date('Y-m-') . $register_date_obj->format('d H:i:s'));
      
        
        //$this->out('registerDate')->out($register_date_obj->format('d.m.Y H:i:s'));
        $this->out('registerDate final')->out($register_date_obj_final->format('d.m.Y H:i:s'));
        $current_time_obj = DateTime::createFromFormat('U', time());
        
        $paid_period_end_obj = clone $register_date_obj_final;
        if(($register_date_obj->format('d') >= $current_time_obj->format('d')) === false){
             $paid_period_end_obj->modify('+1 month');
        }
       
        $current_time = time();
        $this->out('$paid_period_end_obj')->out($paid_period_end_obj->format('d.m.Y H:i:s'));

        if ($current_time > $paid_period_end_obj->format('U')) {
            $this->clearCompanyMods($one_company);
            $this->disableStateInAdministrator($one_company);
            $this->sendEmail($one_company);
        }
    }

    private function clearCompanyMods(array $one_company) {
       
        if ($this->enable_api_blocking_by_option_from_admin_panel == '1') {
            $mods['enable_app'] = 0;
        }
        $mods['confirmation'] = 0;
        $mods['holiday'] = 0;
        $mods['pay_period'] = 0;
        $mods['camera_kiost'] = 0;
        $mods['enable_calculator'] = 0;
        $mods['enable_co'] = 0;
        $mods['enable_app_camera'] = 0;
        $mods['enable_task_manager'] = 0;
        $mods['enable_rules'] = 0;
        $mods['enable_dk_save'] = 0;
        $mods['user_limit'] = 1; //0 is equal to unlimited
        $mods['shifts'] = 0;
        $mods['maximum_limited_company'] = 0;
        $mods['editable_login_and_exit_h'] = 0;

        foreach ($mods as $k => $one_mod) {
            $query = "";
            $query .= "UPDATE $this->mod_table SET ";
            $query .= "`enabled` = '$one_mod' WHERE `company` = '".$one_company['company']."' AND `mod` = '$k'; ";
            //$this->out($query);
            $this->db->setQuery($query);
            $this->db->query();
        }
    }
    
    private function disableStateInAdministrator(array $one_company) {
        $item = new stdClass;
        $item->owner_id = $one_company['id'];
        $item->block = 1;
        
        $this->db->updateObject('#__users', $item, 'owner_id');
    }
    
    private function sendEmail(array $one_company) {
        $config = $this->config;
        $sender = array($config->get('mailfrom'), $config->get('fromname'));
        $user_sended = & JFactory::getUser($one_company['id']);
        $subject = "Suspend your subscription.";
        
        $message = "<p><strong>Company:</strong> $user_sended->company</p>";
        $message .= "<p><strong>Url:</strong> $this->current_url</p>";
        $message .= "<p><strong>Date:</strong> " . date('d.m.Y H:i:s') . "</p>";
        $message .= "<p>Please contact <a href=\"mailto:info@curiotime.com\">info@curiotime.com</a> if this was a mistake. </p>";
        $message .= "<p>Do not reply to this automated message.</p>";
        
        $mailer = JFactory::getMailer();
        $mailer->setSender($sender);
        $mailer->addRecipient($user_sended->email);
        $mailer->addBcc('developer3452@gmail.com', 'developer3452');
        $mailer->addBcc('info@uxdesign.is');
                      
        $mailer->setSubject($subject);
        $mailer->isHTML(TRUE);
        $mailer->setBody($message);
        $mailer->send();
        $this->out('email has sended');
    }
 
}

JApplicationCli::getInstance('SubsctiptionCli')->execute();
