<?php

// We are a valid entry point.
const _JEXEC = 1;

// Load system defines
if (file_exists(dirname(__DIR__) . '/defines.php')) {
    require_once dirname(__DIR__) . '/defines.php';
}

if (!defined('_JDEFINES')) {
    define('JPATH_BASE', dirname(__DIR__));
    require_once JPATH_BASE . '/includes/defines.php';
}

//define('JPATH_COMPONENT_ADMINISTRATOR', JPATH_ADMINISTRATOR . '/components/com_finder');
// Get the framework.
require_once JPATH_LIBRARIES . '/import.legacy.php';

// Bootstrap the CMS libraries.
require_once JPATH_LIBRARIES . '/cms.php';

// Import the configuration.
require_once JPATH_CONFIGURATION . '/configuration.php';

// System configuration.
$config = new JConfig;
define('JDEBUG', $config->debug);

// Configure error reporting to maximum for CLI output.
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Load Library language
$lang = JFactory::getLanguage();

// Try the finder_cli file in the current language (without allowing the loading of the file in the default language)
$lang->load('com_audit', JPATH_SITE, null, false, false)
// Fallback to the finder_cli file in the default language
        || $lang->load('com_audit', JPATH_SITE, null, true);

//JFactory::getApplication('site');

class StoreUserLimitsCli extends JApplicationCli {

   
    public $db;

    public function __construct() {
        parent::__construct();

        $this->db = JFactory::getDBO();
        $this->config = JFactory::getConfig();
       
        $this->table = '#__users_limit_record';
        $this->current_url = $this->config->get('current_url');
        
        $this->enable_default_rules = $this->config->get('enable_default_rules');
        $this->default_rules_base_company = $this->config->get('default_rules_base_company');
      
    }

    private function getAllManagers() {
        $query = "SELECT `company`, `id`, `username0`, `username`, `name`, `owner_id` FROM #__users ORDER BY `id` ASC";
        $this->db->setQuery($query);
        return $this->db->loadAssocList();
    }

    private function superUnique($array, $key) {
        $temp_array = [];
        foreach ($array as &$v) {
            if (!isset($temp_array[$v[$key]]))
                $temp_array[$v[$key]] = & $v;
        }
        $array = array_values($temp_array);
        return $array;
    }

    public function doExecute() {
        $this->out('Start working...');

        $this->addUsersLimitRecord();
        
        $this->out('Stop working.');
        
    }

    private function addUsersLimitRecord() { 
        $item = new stdClass;
        
        $item->id = null;
        $item->total = $this->getTotal();
        $item->date = date('Y-m-d H:i:s');
        $item->created_at = date('Y-m-d H:i:s');
        $item->created_timestamp = time();
        
        $this->db->insertObject($this->table, $item);
    }
   
    private function getTotal() {
        JLoader::register('CtapiModelApi', JPATH_ADMINISTRATOR . '/components/com_ctapi/models/api.php');
        $this->model = JModelLegacy::getInstance('Api', 'CtapiModel');
        $this->companies = $this->model->getCompanies(1);
        $this->mods = $this->model->allMods();
        $calculated_total = 0;
        
        //calc total users limit
        foreach ($this->companies as $company => $mods){
            if(($this->enable_default_rules == '1' && !empty($this->default_rules_base_company) && in_array($company, $this->default_rules_base_company)) || $company == 'Sample Company') continue;
            foreach ($this->mods as $mod => $modLabel){
                if (in_array($mod, ["user_limit"])){
                    if (!empty($mods[$mod])) {
                        $calculated_total += intval($mods[$mod]);
                    } else {
                        $res_check = $this->model->checkCompanyIsNew($company);
                        if ($res_check->company_is_new == 1) {
                            $calculated_total += $this->model->saveNewCompany($company);
                        } 
                    }   
               }
            }
        }
        
        return $calculated_total;
    }
}

JApplicationCli::getInstance('StoreUserLimitsCli')->execute();
