<?php

// Set flag that this is a parent file.
const _JEXEC = 1;
  /*error_reporting(E_ALL | E_NOTICE);
  ini_set('display_errors', 1); */

// Load system defines
if (file_exists(dirname(__DIR__) . '/defines.php')) {
    require_once dirname(__DIR__) . '/defines.php';
}
if (!defined('_JDEFINES')) {
    define('JPATH_BASE', dirname(__DIR__));
    require_once JPATH_BASE . '/includes/defines.php';
}
require_once JPATH_LIBRARIES . '/import.legacy.php';
require_once JPATH_LIBRARIES . '/cms.php';
// Load the configuration
require_once JPATH_CONFIGURATION . '/configuration.php';

class sendToFirebaseCtCli extends JApplicationCli {

    public $syncModel;
    public $db;

    public function __construct() {
        parent::__construct();

        $this->db = JFactory::getDBO();
        $this->config = JFactory::getConfig();

        $this->enable_settings_notifications_tab = $this->config->get('enable_settings_notifications_tab');
        date_default_timezone_set($this->config->get('domain_timezone')); //set correct timezone. it's important!
    
        $this->server_key = 'AAAA8uprK_U:APA91bHVkdWyzApYugBARq2jFS1iZojYPLmFelemNPqU7LzuACC_Ja0Sg9ilI1VVsoIUcvSVNG8WLHZCz69oVaCVVbwoEbbnTcx60WCuGbO66q-9uSZRJPNpKiv_1I4BYTUsarWaFhP_';
        $this->firebase_url = 'https://fcm.googleapis.com/fcm/send';
    }

    private function getAllManagers() {
        $query = "SELECT `company`, `id`, `username0`, `username`, `name`, `owner_id`, `email`, "
                . "`send_mobile_ct`, "
                . "`send_auto_to_selected_ct`, "
                . "`send_to_all_ct`, "
                . "`send_one_hour_before_ct`, "
                . "`send_forgot_to_click_start_ct`, "
                . "`send_forgot_to_clock_ct`, "
                . "`send_if_empl_hasnt_clocked_ct`"
                . "FROM #__users ORDER BY `id` ASC";

        $this->db->setQuery($query);
        return $this->db->loadAssocList();
    }

    private function superUnique($array, $key) {
        $temp_array = [];
        foreach ($array as &$v) {
            if (!isset($temp_array[$v[$key]]))
                $temp_array[$v[$key]] = & $v;
        }
        $array = array_values($temp_array);
        return $array;
    }

    private function storeToFirebase(array $messages) {

        $url = $this->firebase_url;
        $YOUR_API_KEY = $this->server_key; // Server key
        $not_perm_users = [
            -1
        ];
        
        
        foreach($messages as $one_message){
            $user_obj = & JFactory::getUser($one_message->user_id);
          
            //$this->out('$user_obj->app_client_enable_push:')->out($user_obj->app_client_enable_push);
            /*if($user_obj->id != 3844){
                continue;
            }*/
            //$this->out('$user:')->out(print_r($user_obj, true));
            if(in_array($user_obj->id, $not_perm_users)){
                continue;
            } /*if($user_obj->app_client_enable_push == 0){
                continue; 
            }*/
            
            $YOUR_TOKEN_IDS = json_decode($user_obj->firebase_device_ids, true); // Client token id
            $devices_push_status = json_decode($user_obj->app_client_enable_push, true);//clien push status from devices
            $this->out('$devices_push_status:')->out(print_r($devices_push_status));
                    
            $count_user_devices = count($YOUR_TOKEN_IDS);
            
            if ($count_user_devices === 1) { 
                if($devices_push_status[$YOUR_TOKEN_IDS[0]] == 0){
                    continue;
                }
                $request_body = [
                    'to' => $YOUR_TOKEN_IDS[0],
                    'notification' => [
                        'title' => $one_message->subject_en,
                        'body' => $one_message->text_en,
                        'icon' => 'https://newdev.curiotime.com/templates/curiotimenew/favicon.ico',
                        'click_action' => 'https://curiotime.com',
                    ],
                ];      
            } elseif($count_user_devices > 1){
                $request_body = [
                    'notification' => [
                        'title' => $one_message->subject_en,
                        'body' => $one_message->text_en,
                        'icon' => 'https://newdev.curiotime.com/templates/curiotimenew/favicon.ico',
                        'click_action' => 'https://curiotime.com',
                    ]
                ];
            
                $request_body['registration_ids'] = [];
                    
                foreach($YOUR_TOKEN_IDS as $one_user_device){
                    $this->out('$devices_push_status:')->out($devices_push_status[$one_user_device]);
                    
                    if($devices_push_status[$one_user_device] == 0){
                        //$this->out('pp');
                        continue;
                    } else{
                   
                        $request_body['registration_ids'][] = $one_user_device;
                    }
                }
            }
            $this->out(print_r($request_body, true)); 
        
        
            $fields = json_encode($request_body);

            $request_headers = [
                'Content-Type: application/json',
                'Authorization: key=' . $YOUR_API_KEY,
            ];
            //sleep(1);
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url); 
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
            curl_setopt($ch, CURLOPT_HTTPHEADER, $request_headers);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            $response = json_decode(curl_exec($ch));
            curl_close($ch);
            
            $this->out('firebase response:');
            $this->out(print_r($response, true));
            
            $this->updateScheduleStatus($one_message, $user_obj->id);
            $this->addLogRow($response, $user_obj->id);
             
            //return $response;
        }
    }
    
    private function updateScheduleStatus($schedule, int $user_id)
    {
       $query = "UPDATE  #__app_api_messages SET `is_read` = '1' WHERE `id` = '".$schedule->id."' AND `user_id` = '".$user_id."'";
       //$this->out($query);
       $this->db->setQuery($query);
       $this->db->query();
    }
    
    private function addLogRow($response, int $user_id): void
    {
        $item = new stdClass();
        $item->id = null;
        $item->user_id = $user_id;
        $item->timestamp_create = time();
        $item->date_create = date('d.m.Y H:i:s');
        $item->response = json_encode($response);
        
        $this->db->insertObject('#__firebase_logs', $item);
    }

    public function doExecute() 
    {
        if ($this->enable_settings_notifications_tab == '1') {
            $this->out('Start working...');

            $all_managers = $this->getAllManagers();
            $prepared_manager_list = $this->superUnique($all_managers, 'company');


            foreach ($prepared_manager_list as $one_company) {

                if ($one_company['send_mobile_ct'] == 1) {
                    $availableUsers = array(-1);
                    $manager = & JFactory::getUser($one_company['owner_id']);

                    $rms = $this->loadRooms($manager);
                    if (!empty($rms)) {
                        foreach ($rms as $r) {
                            $availableUsers[] = intval($r->id);
                        }
                    }
                    
                    //load company messages
                    $query = "SELECT * FROM  #__app_api_messages WHERE `user_id` in (" . join(",", $availableUsers) . ") AND `is_read` = '0' AND `status` = '1' AND `message_type` = 'сt_notifications'";
                    //$this->out($query);
                    $this->db->setQuery($query);
                    $messages_object = $this->db->loadObjectList();
                    
                    if(!empty($messages_object)){
                        //$this->out(print_r($messages_object, true));
                        $res = $this->storeToFirebase($messages_object);
                       
                        
                        //$this->out('firebase response:')->out(print_r($res, true));
                    }
                }
            }


            $this->out('Stop working...');
        } else {
            $this->out('Enable $enable_settings_notifications_tab in /configuration.php for working this script!');
        }
    }


    private function loadRooms($manager_obj) {
        $department_obj = $_REQUEST['dep'];
        $department_arr = isset($department_obj) ? $department_obj : '';

        $owner_id = $manager_obj->owner_id;


        $visible_manager = false;
        if (in_array(6, $manager_obj->groups)) {
            if ($visible_manager == true) {
                $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0' ORDER BY `username0` ASC";
            } else {
                $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0' AND `id` != '" . $owner_id . "' ORDER BY `username0` ASC";
            }

            $this->db->setQuery($query);
            $rooms = $this->db->loadAssocList();
        }


        $result = array();

        foreach ($rooms as $room) {
            if (!empty($department_arr) && !in_array($room['group_user'], $department_arr)) {
                continue;
            }

            $r = new stdClass();
            $r->id = $room['id'];

            if (!empty($room['username0'])) {
                $final_username = $room['username0'];
            } elseif (!empty($room['username'])) {
                $final_username = $room['username'];
            } elseif (!empty($room['name'])) {
                $final_username = $room['name'];
            }

            $r->name = $final_username;
            $r->capacity = 1;
            $r->status = 2;
            $result[] = $r;
        }


        return $result;
    }

    private function checkSended($shift_id, $user_id) {
        $query = "SELECT `id`, `forgot_click_status` FROM #__app_api_messages WHERE `shift_id` ='" . (int) $shift_id . "' AND `user_id` = '$user_id' AND `timestamp` >= '" . strtotime('today') . "' AND `forgot_click_status`='1'";
        $this->db->setQuery($query);
        $result = $this->db->loadObjectList();

        $this->out('checkSended():')->out(print_r($result, true))->out('count:')->out(count($result));
        if (count($result) > 0) {
            $res = 1;
        } else {
            $res = 0;
        }

        return $res;
    }

    private function loadEvents() {
        //$start = isset($_POST['start']) ? $_POST['start'] : $_GET['start'];
        //$end = isset($_POST['end']) ? $_POST['end'] : $_GET['end'];

        $availableUsers = array(-1);
        $rms = $this->loadRooms();
        if (!empty($rms)) {
            foreach ($rms as $r) {
                $availableUsers[] = intval($r->id);
            }
        }

        //$query = "SELECT * FROM #__com_shifts_reservations WHERE room_id in (".join(",",$availableUsers).") AND   NOT ((end <= '".$start."') OR (start >= '".$end."'))";
        $query = "SELECT * FROM #__com_shifts_reservations WHERE room_id in (" . join(",", $availableUsers) . ")";
        $this->db->setQuery($query);
        $result = $this->db->loadAssocList();

        $events = array();

        date_default_timezone_set("UTC");
        $now = new DateTime("now");
        $today = $now->setTime(0, 0, 0);

        foreach ($result as $row) {
            $e = new stdClass();
            $e->id = $row['id'];
            //$e->text = $row['name'];
            $e->text = '';
            $e->start = $row['start'];
            $e->end = $row['end'];
            $e->resource = $row['room_id'];
            $e->bubbleHtml = ''; //"Reservation details: <br/>".$e->text;
            // additional properties
            $e->status = $row['status'];
            $e->paid = $row['paid'];
            $e->shift_color = $row['shift_color'];
            $e->shift_name = $row['shift_name'];
            $e->shift_message = $row['shift_message'];
            $e->icon_date = json_decode($row['icon_date'], true);
            $e->tasks_ids = $row['tasks_ids'];
            $e->standart_tasks_ids = $row['standart_tasks_ids'];

            if (empty($e->icon_date))
                $e->icon_date = array();

            $days = array();
            $start = strtotime(date("Y-m-d 00:00:00", strtotime($e->start)));
            $end = strtotime(date("Y-m-d 00:00:00", strtotime($e->end)));
            $day = $start;
            if ($start <= $end) {

                for (; $day <= $end;) {

                    $cd = date("Y-m-d", $day);
                    $days[$cd] = 0;
                    foreach ($e->icon_date as $dateKey => $di) {
                        if ($di['date'] == $cd) {
                            $days[$cd] = array('id' => $e->id, "date" => $dateKey, 'isodate' => $cd);
                        }
                    }
                    $day = strtotime("+1 day", $day);
                    if ($day > $end)
                        break;
                }
            }
            $e->days = $days;
            $events[] = $e;
        }


        return $events;
    }

    private function generateRandomString($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyz';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

}

JApplicationCli::getInstance('sendToFirebaseCtCli')->execute();
