<?php

// Set flag that this is a parent file.
const _JEXEC = 1;
error_reporting(E_ALL | E_NOTICE);
ini_set('display_errors', 1);
// Load system defines
if (file_exists(dirname(__DIR__) . '/defines.php')) {
    require_once dirname(__DIR__) . '/defines.php';
}
if (!defined('_JDEFINES')) {
    define('JPATH_BASE', dirname(__DIR__));
    require_once JPATH_BASE . '/includes/defines.php';
}
require_once JPATH_LIBRARIES . '/import.legacy.php';
require_once JPATH_LIBRARIES . '/cms.php';
// Load the configuration
require_once JPATH_CONFIGURATION . '/configuration.php';

class RemoveTrashCli extends JApplicationCli {

    private $dirs_for_trash = [
        "/tmp_csv_task_manager",
        "/tmp_csv_collect",
        "/tmp_ei_csv/company",
        "/tmp_ei_csv/individual",
        "/tmp_ei_excel",
        "/tmp_test_import",
        "/tmp_upload_excel_import",
        "/tmp_xls_collect",
        "/tpm_csv_report",
        "/tpm_csv_report_managers"
    ];
    private $days = 1;

    private function deleteOldFile($path, $name) {
        $this->out("File: {$path}");

        //@unlink($path);
        JFile::delete($path);
    }

    private function checkDirectory($path) {

        $minTime = strtotime("-" . $this->days . "day");

        foreach (new DirectoryIterator($path) as $fileInfo) {
            if ($fileInfo->isDot()){
                continue;
            }
            $time = $fileInfo->getMTime();
            if ($time < $minTime) {
                $fullPath = $fileInfo->getPath() . DIRECTORY_SEPARATOR . $fileInfo->getFilename();
                $this->deleteOldFile($fullPath, $fileInfo->getFilename());
            }
        }
    }

    public function doExecute() {
        $this->out('Clear old files start...');
        //$this->db =  JFactory::getDBO();

        foreach ($this->dirs_for_trash as $dir) {
            $path = JPATH_BASE . $dir;
            $this->out('Check: ' . $path);
            $this->checkDirectory($path);
        }
        //$this->clearTables();        
        $this->out('Done');
    }

}

JApplicationCli::getInstance('RemoveTrashCli')->execute();
