<?php
// Set flag that this is a parent file.
const _JEXEC = 1;
error_reporting(E_ALL | E_NOTICE);
ini_set('display_errors', 1);
// Load system defines
if (file_exists(dirname(__DIR__) . '/defines.php')){
    require_once dirname(__DIR__) . '/defines.php';
}
if (!defined('_JDEFINES'))  {
    define('JPATH_BASE', dirname(__DIR__));
    require_once JPATH_BASE . '/includes/defines.php';
}
require_once JPATH_LIBRARIES . '/import.legacy.php';
require_once JPATH_LIBRARIES . '/cms.php';
// Load the configuration
require_once JPATH_CONFIGURATION . '/configuration.php';


class RemoveOldImagesCli extends JApplicationCli   {
    
    private $imagesDirs  = array(
        "/images/confirm_start_images",
        "/images/confirm_stop_images",
        "/images/pay_period_start_images",
        "/images/pay_period_stop_images",
    );
    private $db;    
    
    private $months  = 12;
    
    
    private function deleteOldImage($path,$name) {
        $this->out("File: {$path}");        
        $query  =   "SELECT * FROM #__audit_time_confirm WHERE img_start = ".$this->db->quote($path)." LIMIT 1";
        $this->db->setQuery($query);
        $obj    =   $this->db->loadObject();
        if(!empty($obj)) {
            $obj->img_start  = "";
            $this->db->updateObject('#__audit_time_confirm',$obj, 'id');
            $this->out("Clear [img_start] #__audit_time_confirm id: ".$obj->id);  
        }
        $query  =   "SELECT * FROM #__audit_time_confirm WHERE img_stop = ".$this->db->quote($path)." LIMIT 1";
        $this->db->setQuery($query);
        $obj    =   $this->db->loadObject();
        if(!empty($obj)) {
            $obj->img_stop  = "";
            $this->db->updateObject('#__audit_time_confirm',$obj, 'id');
            $this->out("Clear [img_stop] #__audit_time_confirm id: ".$obj->id);  
        }
        $query  =   "SELECT * FROM #__audit_time WHERE img_start = ".$this->db->quote($path)." LIMIT 1";
        $this->db->setQuery($query);
        $obj    =   $this->db->loadObject();
        if(!empty($obj)) {
            $obj->img_start  = "";
            $this->db->updateObject('#__audit_time',$obj, 'id');
            $this->out("Clear [img_start] #__audit_time id: ".$obj->id);  
        }
        
        $query  =   "SELECT * FROM #__audit_time WHERE img_stop = ".$this->db->quote($path)." LIMIT 1";
        $this->db->setQuery($query);
        $obj    =   $this->db->loadObject();
        if(!empty($obj)) {
            $obj->img_stop  = "";
            $this->db->updateObject('#__audit_time',$obj, 'id');
            $this->out("Clear [img_stop] #__audit_time id: ".$obj->id);  
            
        }        
        @unlink($path);
    }
    
    private function checkDirectory($path) {
        
        $minTime  = strtotime("-".$this->months."month");
        
        foreach (new DirectoryIterator($path) as $fileInfo) {
            if($fileInfo->isDot()) continue;            
            $time  =  $fileInfo->getMTime();            
            if($time < $minTime) {
                $fullPath  =  $fileInfo->getPath().DIRECTORY_SEPARATOR.$fileInfo->getFilename();
                $this->deleteOldImage($fullPath,$fileInfo->getFilename());
            }
        }
    }
    
    private function clearTables() {
        
        $minTime    =   strtotime("-".$this->months."month");
        $date       =   date("Y-m-d",$minTime);
        
        $query  =   "SELECT * FROM #__audit_time WHERE date < ".$this->db->quote($date)." AND ( (img_start IS NOT NULL AND img_start <> '') OR (img_stop IS NOT NULL AND img_stop <> '') ) ORDER BY id ASC";
        $this->db->setQuery($query);
        $results = $this->db->loadObjectList(); 
        foreach ($results as $obj) {
            $obj->img_start     =  "";
            $obj->img_stop      =  "";            
            $this->db->updateObject('#__audit_time',$obj, 'id');
        }
        
        $query  =   "SELECT * FROM #__audit_time_confirm WHERE date < ".$this->db->quote($date)." AND ( (img_start IS NOT NULL AND img_start <> '') OR (img_stop IS NOT NULL AND img_stop <> '') ) ORDER BY id ASC";
        $this->db->setQuery($query);
        $results = $this->db->loadObjectList();
        foreach ($results as $obj) {
            $obj->img_start     =  "";
            $obj->img_stop      =  "";            
            $this->db->updateObject('#__audit_time_confirm',$obj, 'id');
        }
    }
    
    public function doExecute() {        
        $this->out('Clear old images start...');
        $this->db =  JFactory::getDBO();
        
        foreach ($this->imagesDirs as $dir) {
            $path  =  JPATH_BASE.$dir;
            $this->out('Check: '.$path);
            $this->checkDirectory($path);
        }
        //$this->clearTables();        
        $this->out('Done.');
    }    
}
JApplicationCli::getInstance('RemoveOldImagesCli')->execute();
