<?php


// Set flag that this is a parent file.
const _JEXEC = 1;
/*error_reporting(E_ALL | E_NOTICE);
ini_set('display_errors', 1);*/

// Load system defines
if (file_exists(dirname(__DIR__) . '/defines.php')){
    require_once dirname(__DIR__) . '/defines.php';
}
if (!defined('_JDEFINES'))  {
    define('JPATH_BASE', dirname(__DIR__));
    require_once JPATH_BASE . '/includes/defines.php';
}
require_once JPATH_LIBRARIES . '/import.legacy.php';
require_once JPATH_LIBRARIES . '/cms.php';
// Load the configuration
require_once JPATH_CONFIGURATION . '/configuration.php';


class NormalizeScheduleIconsCli extends JApplicationCli   {
    
    public $syncModel;
    public $db;
    
    public function __construct() {
        parent::__construct();
        
        $this->db = JFactory::getDBO();
        $this->config = JFactory::getConfig();
        
        //$this->enable_settings_notifications_tab = $this->config->get('enable_settings_notifications_tab');
        date_default_timezone_set($this->config->get('domain_timezone'));//set correct timezone. it's important!
        
     
    }
    
    private function getAllManagers()
    {
        $query = "SELECT `company`, `id`, `username0`, `username`, `name`, `owner_id`, `email` "
               
                . "FROM #__users ORDER BY `id` ASC";
        
        $this->db->setQuery($query);
        return $this->db->loadAssocList();
    }
    
    private function superUnique($array, $key)
    {
        $temp_array = [];
        foreach ($array as &$v) {
            if (!isset($temp_array[$v[$key]]))
                $temp_array[$v[$key]] =& $v;
        }
        $array = array_values($temp_array);
        return $array;
    }
    
    private function getCurrentIcons()
    {
         $arr = [
           /* 'doctor',
            'medical-sign-alt',
            'live-support',
            'hotel-boy-alt',
            'man-in-glasses',
            //'icon',
            'business-man',
            'boy',
            'chef',
            'auto-mobile',
            'anchor',
            'bag-alt',
            'automation',
            'beaker',
            'binoculars',
            'bullhorn',
            'clock-time',
            'crown',
            'data',
            'dashboard-web',
            'excavator',
            'eye-alt',
            'film',
            'fire-burn',
            'hanger',
            'home',
            'graffiti',
            'institution',
            'info',
            'layout',
            'license',
            'learn',
            'long-drive',
            'map',
            'measure',
            'military',
            'money',
            'mop',
            'not-allowed',
            'print',
            'road',
            'server',
            'shield',
            'shopping-cart',
            'spanner',
            'key',
            'unique-idea',
            'restaurant-menu',
            'ui-camera'*/
            'pizza-slice',
            'cocktail',
            'restaurant',
            'spoon-and-fork',
            'aim',
            'like',
            'male',
            'telephone',
            'tea',
            'bar-code',
            'briefcase',
            'bucket1',
            'cart-alt',
            'eye',
            'favourite',
            'invisible',
            'info',
            'learn',
            'light-bulb',
            'listening',
            'live-support',
            'money',
            'moon',
            'mop',
            'mustache',
            'tools-alt-2',
            'doctor',
            'nurse',
            'car-alt-3',
            'rocket-alt-1',
            'student',
            'teacher',
            'woman-in-glasses',
            'users',
            'girl',
            'funky-man',
            'waiter',
            'boy',
            'business-man-alt-1',
            'man-in-glasses',
            'support',
            'id-card',
            'laughing',
            'smirk',
            'wink-smile',
            'confounded',
            'cycling',
            'racing-flag-alt'
         
        ];
         
        $final_arr = [];
        foreach($arr as $one_icon){
            $final_arr[] = 'icofont-'.$one_icon;
        }
        
        return $final_arr;
    }
    
    public function doExecute() 
    {
     
        $this->out('Start working...');
  
        $all_managers = $this->getAllManagers();
        $prepared_manager_list = $this->superUnique($all_managers, 'company');
        $icons = $this->getCurrentIcons(); 
            
        foreach($prepared_manager_list as $one_company){
            $this->out(print_r($one_company, true));
            $company_users = $this->getCompanyUsers($one_company);
           // $this->out('$company_users:')->out(print_r($company_users, true)); 
            
            foreach($company_users as $one_user){
                $current_user_icon = $one_user->user_position_icon;
                $user_id = $one_user->id;
                
                if(!in_array($current_user_icon, $icons) && !empty($current_user_icon)){
                    $this->saveUserIcon($user_id, "");
                    $this->out("zeroing schedule icon from user with id:", $user_id);
                }
            }
        }
           

        $this->out('Stop working...');
      
    }  
    
    private function getCompanyUsers(array $one_company)
    {
        $query = "SELECT `id`, `user_position_icon` "
               
                . "FROM #__users WHERE `owner_id` = '".$one_company['owner_id']."' ORDER BY `id` ASC";
        
        $this->db->setQuery($query);
        return $this->db->loadObjectList();
    }
  
    private function saveUserIcon(int $user_id, string $selected_icon)
    {
        $item = new stdClass();
        $item->id = $user_id;
        $item->user_position_icon = $this->db->escape($selected_icon);
            
        if($this->db->updateObject('#__users', $item, 'id')){
            return $item->user_position_icon;
        }
    }
    
}
JApplicationCli::getInstance('NormalizeScheduleIconsCli')->execute();
