<?php
// Set flag that this is a parent file.
const _JEXEC = 1;
error_reporting(E_ALL | E_NOTICE);
ini_set('display_errors', 1);
// Load system defines
if (file_exists(dirname(__DIR__) . '/defines.php')){
    require_once dirname(__DIR__) . '/defines.php';
}
if (!defined('_JDEFINES'))  {
    define('JPATH_BASE', dirname(__DIR__));
    require_once JPATH_BASE . '/includes/defines.php';
}
require_once JPATH_LIBRARIES . '/import.legacy.php';
require_once JPATH_LIBRARIES . '/cms.php';
// Load the configuration
require_once JPATH_CONFIGURATION . '/configuration.php';


class SyncDkTasksCli extends JApplicationCli   {
    
    public $syncModel;
    public $db;
    
    public function __construct() {
        parent::__construct();
        
        $this->db = JFactory::getDBO();
        $this->config = JFactory::getConfig();
        $this->enable_task_manager_dk_api = $this->config->get('enable_task_manager_dk_api');
        $this->dk_api_company_tasks_url = 'https://api.dkplus.is/api/v1/project/';
        $this->dk_api_company_subtasks_url = 'https://api.dkplus.is/api/v1/general/table/PJPHASES/records?fields=DESCRIPTION';
        
    }
    
    private function getAllManagers()
    {
        $query = "SELECT `company`, `id`, `username0`, `username`, `name`, `owner_id`, `dk_token`, `sync_dk_tasks` FROM #__users ORDER BY `id` ASC";
        $this->db->setQuery($query);
        return $this->db->loadAssocList();
    }
    
    private function superUnique($array, $key)
    {
        $temp_array = [];
        foreach ($array as &$v) {
            if (!isset($temp_array[$v[$key]]))
                $temp_array[$v[$key]] =& $v;
        }
        $array = array_values($temp_array);
        return $array;
    }
    
    private function checkDkTasksInDb($owner_id)
    {
        $query = "SELECT * FROM #__audit_dk_task_list WHERE `id_user` = '".$owner_id."' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        return $this->db->loadObjectList();
    }
    
    public function doExecute() {
        if($this->enable_task_manager_dk_api == '1'){
            $this->out('Start');
            
           // JLoader::register('AuditModelDk', JPATH_ROOT . '/components/com_audit/models/dk.php');
           // $this->model_dk = JModelLegacy::getInstance('Dk', 'AuditModel');
            //$this->out(JPATH_ROOT);
            
            $all_managers = $this->getAllManagers();
            $prepared_manager_list = $this->superUnique($all_managers, 'company');
            
            
            foreach($prepared_manager_list as $one_company){
                if(!empty($one_company['dk_token']) && $one_company['sync_dk_tasks'] == '1'){ 
                    $dk_task_list_from_db = $this->checkDkTasksInDb($one_company['owner_id']);
                    $dk_task_list_from_api = $this->getDkTaskListFromApi($one_company['owner_id']);
                    
                    //if (!empty($dk_task_list_from_db)) {
                        if (!empty($dk_task_list_from_api->Message)) {
                            $this->out($dk_task_list_from_api->Message);
                            
                            continue;
                        } else {
                            //$this->out(print_r($one_company, true));
                            //$this->out(print_r($dk_task_list_from_db, true));
                            foreach($dk_task_list_from_api as $one_task_in_api){
                                $this->updateDkTaskInfo($one_task_in_api, $one_company['owner_id']);
                            }
                            $this->out(print_r($dk_task_list_from_api, true));
                        }
                    //}
                       
                }
            }
            /*echo '<pre>';
            print_r($unicals);
            echo '</pre>';*/

            $this->out('Stop');
        }
       
        
    }  
    
    //point
   private function updateDkTaskInfo($api_task_obj, $owner_id)
   {
        $query = "SELECT * FROM #__audit_dk_task_list WHERE `original_id` = '".$api_task_obj->Number."' AND `id_user` = '".$owner_id."' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $saved_task = $this->db->loadObjectList()[0];
        /*echo '<pre>';
        print_r($saved_task);
        echo '</pre>';*/
        
        if(!empty($saved_task) && ($saved_task->text !== $api_task_obj->Name || $saved_task->JobStatus !== $api_task_obj->JobStatus)){
            //$query = "UPDATE #__audit_dk_task_list SET `text`='".$this->db->escape($api_task_obj->Name)."-updated on:".date('d.m.Y H:i:s')."' WHERE `original_id` = '".$api_task_obj->Number."'";     
            $query = "UPDATE #__audit_dk_task_list SET `text`='".$this->db->escape($api_task_obj->Name)."', `JobStatus` = '".$this->db->escape($api_task_obj->JobStatus)."' WHERE `original_id` = '".$api_task_obj->Number."'";       
            $this->db->setQuery($query);
            $this->db->query();
            
            $mode_for_log = 'update';
            $info_for_log = [
                'mode_for_log' => $mode_for_log,
                'query' => $query,
                'owner_id' => $owner_id, 
            ];
            $this->addLogRecord($owner_id, $info_for_log);
        } elseif(empty($saved_task)){//point
            $item = new stdClass();
            
            $item->id = null;
            //$item->text = $this->db->escape($api_task_obj->Name).' inserted on: '.date('d.m.Y H:i:s');
            $item->text = $this->db->escape($api_task_obj->Name);
            $item->id_user = (int)$owner_id;
            $item->original_id = $this->db->escape($api_task_obj->Number);
            $item->JobStatus = $this->db->escape($api_task_obj->JobStatus);
            
            //point
            $this->db->insertObject('#__audit_dk_task_list', $item, 'id');
            
            $mode_for_log = 'insert';
            $info_for_log = [
                'mode_for_log' => $mode_for_log,
                'info' => $item,
                'owner_id' => $owner_id,
            ];
            $this->addLogRecord($owner_id, $info_for_log);
        }
       
        
        
   }
    
   private function addLogRecord($owner_id, $info_for_log)
   {
        $item = new stdClass();
            
        $item->id = null;
        $item->owner_id = (int)$owner_id;    
        $item->info = json_encode($info_for_log);
        $item->timestamp_creat = time();
        $item->date_create = date('d.m.Y H:i:s');
            
        $this->db->insertObject('#__dk_tasks_cron_log', $item, 'id');
   }
   
    private function getDkTaskListFromApi($manager_id)
    {
        
        $url = $this->dk_api_company_tasks_url;
        $manager_obj = JFactory::getUser($manager_id);
        $company_token = $manager_obj->dk_token;
        
        $ch = curl_init();
        $authorization = "Authorization: Bearer ".$company_token; // Prepare the authorisation token
        
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            
           // CURLOPT_USERPWD => "$this->dk_api_login:$this->dk_api_password",
            /*CURLOPT_POSTFIELDS => [
                'token'=>$this->dk_company_token
            ]*/
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json',
                $authorization
            ]
        ]);
 
        $result = curl_exec($ch);
        curl_close($ch);
        
       
        //$dk_tasks = json_decode($result);
        $res = json_decode($result);
        $this->out(print_r($res,true));
        /*echo '<pre>';
        print_r($res);
        echo '</pre>';*/
        $final = [];
        
        foreach($res as $one_task){
            if($one_task->JobStatus == 1){
                $final[] = $one_task;
            }
        }
        
        return $final;
       
    }
}
JApplicationCli::getInstance('SyncDkTasksCli')->execute();