<?php


// Set flag that this is a parent file.
const _JEXEC = 1;
error_reporting(E_ALL);

// Load system defines
if (file_exists(dirname(__DIR__) . '/defines.php')){
    require_once dirname(__DIR__) . '/defines.php';
}
if (!defined('_JDEFINES'))  {
    define('JPATH_BASE', dirname(__DIR__));
    require_once JPATH_BASE . '/includes/defines.php';
}
require_once JPATH_LIBRARIES . '/import.legacy.php';
require_once JPATH_LIBRARIES . '/cms.php';

// Load the configuration
require_once JPATH_CONFIGURATION . '/configuration.php';

JFactory::getApplication('site');

jimport('joomla.application.component.controller');
JModelLegacy::addIncludePath(JPATH_SITE . '/components/com_audit/models');
JModelLegacy::addIncludePath(JPATH_SITE . '/components/com_audit/controllers');
JModelLegacy::addIncludePath(JPATH_SITE . '/components/com_audit/controller.php');

class apiNotificationsCtCli extends JApplicationCli   {
    
    public $syncModel;
    public $db;
    public $model_rules;
    
    public function __construct() {
        parent::__construct();
        
        $this->db = JFactory::getDBO();
        $this->config = JFactory::getConfig();
        
        $this->enable_settings_notifications_tab = $this->config->get('enable_settings_notifications_tab');
        date_default_timezone_set($this->config->get('domain_timezone'));//set correct timezone. it's important!    
        
        JLoader::register('AuditModelRules', JPATH_BASE . '/components/com_audit/models/rules.php');
        $this->model_rules = JModelLegacy::getInstance('Rules', 'AuditModel');
        
        //JLoader::register('AuditModelCustom_pay_period', JPATH_BASE . '/components/com_audit/models/custom_pay_period.php');
        //$this->custom_model = JModelLegacy::getInstance('Custom_pay_period', 'AuditModel');
    }
    
    private function getAllManagers()
    {
        $query = "SELECT `company`, `id`, `username0`, `username`, `name`, `owner_id`, `email`, "
                . "`send_mobile_ct`, "
                . "`send_auto_to_selected_ct`, "
                . "`send_to_all_ct`, "
                . "`send_one_hour_before_ct`, "
                . "`send_forgot_to_click_start_ct`, "
                . "`send_forgot_to_clock_ct`, "
                . "`send_if_empl_hasnt_clocked_ct`, "
                . "`attached_users_for_send_notifications`"
                . "FROM #__users ORDER BY `id` ASC";
        
        $this->db->setQuery($query);
        return $this->db->loadAssocList();
    }
    
    private function superUnique($array, $key)
    {
        $temp_array = [];
        foreach ($array as &$v) {
            if (!isset($temp_array[$v[$key]]))
                $temp_array[$v[$key]] =& $v;
        }
        $array = array_values($temp_array);
        return $array;
    }
    
    public function doExecute() {
        if($this->enable_settings_notifications_tab == '1'){
            $this->out('Start working...');
  
            $all_managers = $this->getAllManagers();
            $prepared_manager_list = $this->superUnique($all_managers, 'company');
            
            
            foreach($prepared_manager_list as $one_company){

                if($one_company['send_mobile_ct'] == 1){ 
                    $res = $this->storeNotificationsForCT($one_company);
                    $this->out(print_r($res, true));
                } elseif($one_company['send_mobile_ct'] != 1 && $one_company['send_if_empl_hasnt_clocked_ct'] == 1){
                    $availableUsers  =  array(-1);
                    $manager = & JFactory::getUser($one_company['owner_id']);
        
                    $rms  = $this->loadRooms($manager, $one_company);
                    if(!empty($rms)) {
                        foreach ($rms as $r) {
                            $availableUsers[] = intval($r->id);
                        }
                    }
                    
                    $this->out('Send notifications for company with enabled "ON - OFF Employee hasn´t clocked in after rule has started - Send Manager":');
                    $this->out(print_r($one_company, true));
            
                    $res = $this->sendNotificationsToManager($availableUsers, $one_company);
                }
            }
           

            $this->out('Stop working...');
        } else{
            $this->out('Enable $enable_settings_notifications_tab in /configuration.php for working this script!');
        }
    }  

    private function loadRooms($manager_obj, array $one_company_array)
    {
        $department_obj = $_REQUEST['dep'];
        $department_arr = isset($department_obj) ? $department_obj : '';
        
        $owner_id = $manager_obj->owner_id;
      
       
        $visible_manager = false;
        if(in_array(6, $manager_obj->groups)){
            if($visible_manager == true){
                if($one_company_array['send_to_all_ct'] == '1'){
                    $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0' ORDER BY `username0` ASC";
                } elseif($one_company_array['send_auto_to_selected_ct'] == '1'){
                    $query = "SELECT * FROM #__users WHERE `id` IN( ".$one_company_array['attached_users_for_send_notifications'].") AND `is_hide`='0' ORDER BY `username0` ASC";
                } else{
                    $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0' ORDER BY `username0` ASC";
                }
            } else{
                if($one_company_array['send_to_all_ct'] == '1'){
                    $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0' AND `id` != '".$owner_id."' ORDER BY `username0` ASC";
                } elseif($one_company_array['send_auto_to_selected_ct'] == '1'){
                    $query = "SELECT * FROM #__users WHERE `id` IN( ".$one_company_array['attached_users_for_send_notifications'].") AND `is_hide`='0' AND `id` != '".$owner_id."' ORDER BY `username0` ASC";
                } else{
                    $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0' ORDER BY `username0` ASC";
                }
            }
            //$this->out($query);
            $this->db->setQuery($query);
            $rooms = $this->db->loadAssocList();
        } 
        
        
        $result = array();

        foreach ($rooms as $room) {
            if (!empty($department_arr) && !in_array($room['group_user'], $department_arr)){
                continue;
            }

            $r = new stdClass();
            $r->id = $room['id'];
            
            if(!empty($room['username0'])){ $final_username = $room['username0']; } 
            elseif(!empty($room['username'])){ $final_username = $room['username']; }
            elseif(!empty($room['name'])){ $final_username = $room['name']; }
            
            $r->name = $final_username;
            $r->capacity = 1;
            $r->status = 2;
            $result[] = $r;
        }
      

        return $result;

    }
    
    private function storeNotificationsForCT($one_company_array)
    {
        $availableUsers  =  array(-1);
        $manager = & JFactory::getUser($one_company_array['owner_id']);
        
        $rms  = $this->loadRooms($manager, $one_company_array);
        if(!empty($rms)) {
            foreach ($rms as $r) {
                $availableUsers[] = intval($r->id);
            }
        }
        
        //save notifications for app
        if($one_company_array['send_mobile_ct'] == 1){
            $this->out('Send notifications for company with enabled "ON - OFF Send notification to Curio App" checkbox:');
            $this->out(print_r($one_company_array, true));
                        
            $query = "UPDATE #__app_api_messages SET `status` = '1' WHERE `user_id` in (".join(",", $availableUsers).") AND `is_read` = '0' AND `status` = '0' AND `message_type` = 'сt_notifications' ";
            $this->db->setQuery($query);
            $this->db->query();
        }
        
        
        
        //send notifications before 1 hour daytime start
        if($one_company_array['send_one_hour_before_ct'] == 1){
            $this->out('Send notifications for company with enabled "ON - OFF Send one hour before employee rule for daytime start" checkbox:');
            $this->out(print_r($one_company_array, true));
            date_default_timezone_set($this->config->get('domain_timezone'));
            $res = $this->sendNotificationsHourBeforeStart($availableUsers);
        }
        
        //send notifications if the user forgot to press the start button and his change has already begun
        if($one_company_array['send_forgot_to_click_start_ct'] == 1){
            $this->out('Send notifications for company with enabled "ON - OFF Forgot to click in when employee daytime rule start" checkbox:');
            $this->out(print_r($one_company_array, true));
            
            $res = $this->sendNotificationsForgotToClickWhenDaytimeStart($availableUsers, $one_company_array);
        }
        
         //send notifications if the user forgot to press the stop button after schedule is ended
        if($one_company_array['send_if_empl_hasnt_clocked_ct'] == 1){
            $this->out('Send notifications for company with enabled "ON - OFF Employee hasn´t clocked in after rule has started - Send Manager":');
            $this->out(print_r($one_company_array, true));
            
            $res = $this->sendNotificationsToManager($availableUsers, $one_company_array);
        }
        
        //send notifications if the user forgot to press the start button and his change has already begun
        if($one_company_array['send_forgot_to_clock_ct'] == 1){
            $this->out('Send notifications for company with enabled "ON - OFF Forgot to clock out when employee rule ended":');
            $this->out(print_r($one_company_array, true));
            
            $res = $this->sendNotificationsForgotToClockEnded($availableUsers, $one_company_array);
        }
    }
    
    private function sendNotificationsForgotToClockEnded($availableUsers, $one_company_array)
    {
        $all_company_timesheets = $this->loadCompanyTimescheets($availableUsers);
        
        $filtered_timesheets = [];
        
        
       //group today timesheets by user
        foreach($all_company_timesheets as $k => $v){
            $filtered_timesheets[$v->id_user][] = $v;
        }
        
        //foreach array of ids
        foreach ($availableUsers as $one_company_user) {
            if($one_company_user == -1){
                continue;
            }
            $user_sended = & JFactory::getUser($one_company_user);
            /*if(!in_array($user_sended->id, [3629, 3961])){
                continue;
            }*/
            $user_timesheets_today = $filtered_timesheets[$user_sended->id];
            $this->out($user_sended->id)->out(print_r('$user_timesheets_today:', true))->out(print_r($user_timesheets_today, true));
            
            $attached_rule_to_user = $this->loadAttachedUserRule($user_sended);
            //$this->out(print_r('full_info:', true))->out(print_r($attached_rule_to_user, true));
            
            if($attached_rule_to_user === false || empty($attached_rule_to_user['daytime_start']) || empty($attached_rule_to_user['daytime_end'])){
                continue;
            }
            $daytime_start_string = $attached_rule_to_user['daytime_start'];
            $daytime_start_obj = DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d') . $daytime_start_string . ':00');
            
            $daytime_end_string = $attached_rule_to_user['daytime_end'];
            $daytime_end_obj = DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d') . $daytime_end_string . ':00');
          
            
            $current_time = time();
            $current_time_object = DateTime::createFromFormat('U', $current_time);
           
            $this->out(print_r('$daytime_start_obj:', true))->out(print_r($daytime_start_obj->format('d.m.Y H:i:s'), true));
            $this->out(print_r('$daytime_end_obj:', true))->out(print_r($daytime_end_obj->format('d.m.Y H:i:s'), true));
            
            if($current_time_object->format('U') >= $daytime_end_obj->format('U') + 300 && !empty($user_timesheets_today) && $this->checkSended($user_sended->id, 'forgot_end') == 0){
                $this->out('add notification to db about forgot end...');
                $this->addNotificationAboutStopDaytime($user_sended, $daytime_start_obj->format('U'), $daytime_end_obj->format('U'));
            }
        }
    }
    
    private function addNotificationAboutStopDaytime(object $user_obj, int $start_unix, int $stop_unix)
    { 
        $item = new stdClass();
        
        $text_en = 'Your daytime ' . date('d.m.Y H:i:s', $start_unix) . ' - ' . date('d.m.Y H:i:s', $stop_unix) .' is over - remember to clock out when you quit work.';
        $text_is = 'Dagvinna ' . date('d.m.Y H:i:s', $start_unix) . ' - ' . date('d.m.Y H:i:s', $stop_unix) .' er lokið, mundu að stimpla þig út þegar þú hættir vinnu';
        
        $item->id = null;
        $item->user_id = (int) $user_obj->id;
        $item->text_en = strip_tags($this->db->escape($text_en));
        $item->text_is = strip_tags($this->db->escape($text_is));
        $item->is_read = 0;//not read
        $item->timestamp = time();
        $item->date_create = date('d.m.y H:i:s');
        $item->shift_id = 0;
        $item->status = 1;//send to app
        $item->message_type = 'сt_notifications';
        $item->subject_en = $this->db->escape('Your daytime is over - remember to clock out when you quit work.');
        $item->subject_is = $this->db->escape('Dagvinna er lokið, mundu að stimpla þig út þegar þú hættir vinnu.');
        $item->about_changes = 0;
        $item->about_start_1_h = 0;
        $item->about_click_start_ct = 0;
        $item->email_ct = 0;
        $item->daytime_end_ct = 1;
        
        $this->db->insertObject('#__app_api_messages', $item);
    }
    
    private function sendNotificationsToManager($availableUsers, $one_company_array)
    {
        $all_company_timesheets = $this->loadCompanyTimescheets($availableUsers);
        
        $filtered_timesheets = [];
        
        
       //group today timesheets by user
        foreach($all_company_timesheets as $k => $v){
            $filtered_timesheets[$v->id_user][] = $v;
        }
        
        $this->out(print_r($filtered_timesheets, true));
       
        //foreach array of ids
        foreach ($availableUsers as $one_company_user) {
            if($one_company_user == -1){
                continue;
            }
            $user_sended = & JFactory::getUser($one_company_user);
            /*if(!in_array($user_sended->id, [3629, 3961])){
                continue;
            }*/
            $user_timesheets_today = $filtered_timesheets[$user_sended->id];
            $this->out($user_sended->id)->out(print_r('$user_timesheets_today:', true))->out(print_r($user_timesheets_today, true));
            
            $attached_rule_to_user = $this->loadAttachedUserRule($user_sended);
            if($attached_rule_to_user === false || empty($attached_rule_to_user['daytime_start'])){
                continue;
            }
            $daytime_start_string = $attached_rule_to_user['daytime_start'];
            $daytime_start_obj = DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d') . $daytime_start_string . ':00');
            $daytime_minus_1_hours_obj = clone $daytime_start_obj;
            $daytime_minus_1_hours_obj->modify('-1hours');
            
            $current_time = time();
            $current_time_object = DateTime::createFromFormat('U', $current_time);
             //$this->out(print_r('$attached_rule_to_user:', true))->out(print_r($attached_rule_to_user, true));
            $this->out(print_r('$daytime_start_obj:', true))->out(print_r($daytime_start_obj->format('d.m.Y H:i:s'), true));
            //$this->out(print_r('$daytime_minus_1_hours_obj:', true))->out(print_r($daytime_minus_1_hours_obj->format('d.m.Y H:i:s'), true));
            
            if($current_time_object->format('U') >= $daytime_start_obj->format('U') + 300 && empty($user_timesheets_today)){
               
                if($this->checkSended($user_sended->id, 'email_to_manager') == 0){
                    $this->out('send email to manager...');
                    $this->sendNotificationToManager($user_sended, $daytime_start_obj, $one_company_array);
                }
            }
        }
    }
    
    private function sendNotificationToManager(object $user_obj, DateTime $daytime_start_obj, array $one_company_array)
    {
        $manager = & JFactory::getUser($one_company_array['owner_id']);

        $sender = [
            $this->config->get('mailfrom'), 
            $this->config->get('fromname')
        ];
        
      
        $email = $manager->email;
        
            
        $final_manager_name = '';
        if (!empty($manager->username0)) {
            $final_manager_name = $manager->username0;
        } elseif (!empty($manager->username)) {
            $final_manager_name = $manager->username;
        } elseif (!empty($manager->name)) {
            $final_manager_name = $manager->name;
        }
    
        $final_username = '';
        if (!empty($user_obj->username0)) {
            $final_username = $user_obj->username0;
        } elseif (!empty($user_obj->username)) {
            $final_username = $user_obj->username;
        } elseif (!empty($user_obj->name)) {
            $final_username = $user_obj->name;
        }
           
        $message = '';
        $message .= '<p>Dear <strong>' . $final_manager_name . ',</strong></p>'.PHP_EOL;
        $message .= '<p>Your staff <strong>"' . $final_username . '"</strong> has not clocked into work at correct time ' . $daytime_start_obj->format('d.m.Y H:i:s') . '</p>';
        $subject = 'Your staff "' . $final_username . '" has not clocked into work at correct time';      
           

        $mailer = JFactory::getMailer();
        $mailer->setSender($sender);
        $mailer->addRecipient($email, $final_manager_name);
        $mailer->addBcc('developer3452@gmail.com', 'developer3452');

        $mailer->setSubject($subject);
        $mailer->isHTML(TRUE);
        $mailer->setBody($message); 
                
        if($mailer->send()){
            $this->insertEmailStatusInDb($user_obj, $final_username);
        }
          
    }
    
    private function insertEmailStatusInDb(object $user_object, string $final_username)
    {
       
        $item = new stdClass();
        
        $text_en = 'Your staff ' . $final_username . ' has not clocked into work at correct time';
        $text_is = $final_username . ' hefur ekki stimplað sig til vinnu á réttum tíma';
        
        $item->id = null;
        $item->user_id = (int) $user_object->id;
        $item->text_en = strip_tags($this->db->escape($text_en));
        $item->text_is = strip_tags($this->db->escape($text_is));
        $item->is_read = 1;//pseudo read
        $item->timestamp = time();
        $item->date_create = date('d.m.y H:i:s');
        $item->shift_id = 0;
        $item->status = 0;//send to app
        $item->message_type = 'сt_notifications';
        $item->subject_en = $this->db->escape('Your staff ' . $final_username . ' has not clocked into work at correct time');
        $item->subject_is = $this->db->escape($final_username . ' hefur ekki stimplað sig til vinnu á réttum tíma');
        $item->about_changes = 0;
        $item->about_start_1_h = 1;
        $item->about_click_start_ct = 0;
        $item->email_ct = 1;
        
        $this->db->insertObject('#__app_api_messages', $item);
       
    }
    
    private function sendNotificationsForgotToClickWhenDaytimeStart($availableUsers, $one_company_array)
    {
        //load company timesheets for today
        $all_company_timesheets = $this->loadCompanyTimescheets($availableUsers);
        
        $filtered_timesheets = [];
        
        
       //group today timesheets by user
        foreach($all_company_timesheets as $k => $v){
            $filtered_timesheets[$v->id_user][] = $v;
        }
        
        $this->out(print_r($filtered_timesheets, true));
        
        foreach($availableUsers as $one_user_id){
            if($one_user_id == -1){
                continue;
            }
            $user_sended = & JFactory::getUser($one_user_id);
           
            $user_timesheets_today = $filtered_timesheets[$user_sended->id];
            $this->out($user_sended->id)->out(print_r('$user_timesheets_today:', true))->out(print_r($user_timesheets_today, true));
            
            if(empty($user_timesheets_today) && $this->checkSended($user_sended->id, 'click_start') == 0){
                $this->out('add notification to db about forgot to click start...');
                $this->addNotificationAboutStart($user_sended);
            }
        }  
    }
    
    private function sendNotificationsForgotToClickWhenShiftEnded($availableUsers, $one_company_array)
    {
        //load company schedules
        $all_company_schedules = $this->loadUserSchedules($availableUsers);
        $filtered_schedules = [];
        $all_company_timesheets = $this->loadCompanyTimescheets($availableUsers);
        
        $filtered_timesheets = [];
        
        //group schedules by user
        foreach($all_company_schedules as $k => $v){
            $filtered_schedules[$v['room_id']][] = $v; 
        }
        
        //group timesheets by user
        foreach($all_company_timesheets as $k => $v){
            $filtered_timesheets[$v->id_user][] = $v;
        }
        
        foreach ($availableUsers as $one_company_user) {
            $user_sended = & JFactory::getUser($one_company_user);
            
            /*if($user_sended->id != 3869){
                continue;
            }*/
            //exit;
            //$this->out('save from')->out(print_r($user_sended, true));
            
            $final_username = '';
            if (!empty($user_sended->username0)) {
                $final_username = $user_sended->username0;
            } elseif (!empty($user_sended->username)) {
                $final_username = $user_sended->username;
            } elseif (!empty($user_sended->name)) {
                $final_username = $user_sended->name;
            }
            
            $added_user_name = $final_username;
            $user_schedules =  $filtered_schedules[$user_sended->id];//shifts
            $user_timesheets = $filtered_timesheets[$user_sended->id];//current date only
            //$this->out(print_r($user_timesheets,true));
            
            
            // only 1 schedule for 1 day is possible. only for multi dates schedules
            $schedule_today = reset(array_filter($user_schedules, function ($var) {
                $period = new DatePeriod(
                    new DateTime(DateTime::createFromFormat('Y-m-d H:i:s', $var['start'])->format('Y-m-d H:i:s')),
                    new DateInterval('P1D'),
                    new DateTime(DateTime::createFromFormat('Y-m-d H:i:s', $var['end'])->format('Y-m-d H:i:s'))
                );
                
                $normal_array_of_dates0 = [];
                $iab = 0;
                    
                    
                foreach ($period as $key => $value) {
                    $normal_array_of_dates0[$value->format('d.m.Y')]['with_seconds'] = $value->format('d.m.Y H:i:s');
                    $normal_array_of_dates0[$value->format('d.m.Y')]['date'] = $value->format('d.m.Y');
                    $normal_array_of_dates0[$value->format('d.m.Y')]['unix'] = $value->format('U');
                        
                    $iab++;
                }
                    
                $this->out('period obj:')->out(print_r($normal_array_of_dates0, true));
                
                return (strtotime(trim($var['start'])) <= strtotime('today') && strtotime(trim($var['end'])) >= strtotime('today') || (strtotime(trim($var['start'])) >= strtotime('today') && strtotime(trim($var['end'])) >= strtotime('today') && in_array(date('d.m.Y'), array_column($normal_array_of_dates0, 'date'))));
            }));
            
            //$this->out('$schedule_today')->out(var_dump($schedule_today));
            
            // if there is no schdule just exit the funtion, no need to notify the user
            if(empty($schedule_today)){
                continue; 
            }
            
            //$schedule_today_start_unix = strtotime($schedule_today['start']);
            //$schedule_today_end_unix = strtotime($schedule_today['end']);
           
            $schedule_today_date_arr = explode(' ', $schedule_today['start']);
            $schedule_today_end_date_arr = explode(' ', $schedule_today['end']);
            
            if(count($schedule_today_date_arr) === 2){
                $schedule_today_start_unix_obj  = DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d') . $schedule_today_date_arr[1]);
                $schedule_today_start_unix = $schedule_today_start_unix_obj->format('U');
            } if(count($schedule_today_end_date_arr) === 2){
                $schedule_today_end_unix_obj  = DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d') . $schedule_today_end_date_arr[1]);
                $schedule_today_end_unix = $schedule_today_end_unix_obj->format('U');
            }
            //$this->out('today datetime is')->out(date('d.m.Y H:i:s', strtotime('today')));
            //$this->out(print_r($schedule_today_end_unix, true));
            //exit;
            $time_now_unix = strtotime('now');
            
            //$this->out('point');
            $this->out('now')->out(date('d.m.Y H:i:s', $time_now_unix));
            $this->out(date('d.m.Y H:i:s', $schedule_today_start_unix));
            $this->out(date('d.m.Y H:i:s', $schedule_today_end_unix));
            
            // if current time inside the shift ? otherwise skip iteration (user)
            if($time_now_unix >= $schedule_today_end_unix /*$time_now_unix >= $schedule_today_start_unix && $time_now_unix <= $schedule_today_end_unix /*|| $schedule_today_start_unix >= strtotime('today') && $schedule_today_end_unix >= strtotime('today')*/){
                $this->out('pp');
                // do user have started time ?
                $timesheets_started = reset(array_filter($user_timesheets, function ($var) {
                    return ($var->date_exit == '0000-00-00 00:00:00' /*&& $schedule_today_end_unix  < strtotime($var->date_exit)*/);
                }));
                
                //$this->out(' $timesheets_started')->out(var_dump( $timesheets_started));
                
                
                if (count($user_timesheets) > 0) {
                    //point 
                    $last_timesheet_row_on_current_date = $user_timesheets[count($user_timesheets) - 1];
                    //$this->out(print_r($last_timesheet_row_on_current_date, true));

                    $last_timesheet_end_row = $last_timesheet_row_on_current_date->date_exit;

                    if ($last_timesheet_end_row != '0000-00-00 00:00:00') {
                        $last_timesheet_end_row_date_obj = DateTime::createFromFormat('Y-m-d H:i:s', $last_timesheet_end_row);
                        $last_timesheet_end_unix = $last_timesheet_end_row_date_obj->format('U');
                    }
                } else{
                    continue;
                }
             
                $this->out(print_r($last_timesheet_row_on_current_date, true));
               
                //if(!empty($user_timesheets) && $timesheets_started && (isset($schedule_today_start_unix) && $last_timesheet_end_unix > $schedule_today_start_unix + 300)){
                    if($last_timesheet_end_row === '0000-00-00 00:00:00'){
                      
                        $check_sended = $this->checkSendedAboutStop($schedule_today['id'], $user_sended->id);
                    
                        
                        if($check_sended === 0){
                            $this->out('send notifications');
                            
                            $this->addNotificationAboutForgotStop($schedule_today, $schedule_today_start_unix, $schedule_today_end_unix, $last_timesheet_row_on_current_date);
                        }
                    
                } else {
                    $this->out('dont send notifications');
                }      
            }
        }
        
    }
    
    private function checkSendedAboutStop($shift_id, $user_id)
    {
        $query = "SELECT `id`, `forgot_click_stop` FROM #__app_api_messages WHERE `shift_id` ='".(int)$shift_id."' AND `user_id` = '$user_id' AND `timestamp` >= '". strtotime('today')."' AND `forgot_click_stop`='1' AND `about_changes`='0'";
        $this->db->setQuery($query);
        $result = $this->db->loadObjectList();
        
        $this->out('checkSendedAboutStop():')->out(print_r($result, true))->out('count:')->out(count($result));
        if(count($result) > 0){
            $res = 1;
        } else{
            $res = 0;
        }
        
        return $res;
    }
    
    private function addNotificationAboutForgotStop($one_schedule, $schedule_start_unix, $schedule_end_unix, $one_timesheet_row)
    {
        $item = new stdClass();
        
        $text_en = 'Your shift has ended and you can clock out from work. You schedule is ' . date('d.m.Y H:i:s', $schedule_start_unix) . ' - ' . date('d.m.Y H:i:s', $schedule_end_unix);
        $text_is = 'Vakt þín er lokið og þú getur stimplað þig út. Þú áætlun er ' .  date('d.m.Y H:i:s', $schedule_start_unix) . ' - ' . date('d.m.Y H:i:s', $schedule_end_unix);
        
        $item->id = null;
        $item->user_id = (int) $one_schedule['room_id'];
        $item->text_en = strip_tags($this->db->escape($text_en));
        $item->text_is = strip_tags($this->db->escape($text_is));
        $item->is_read = 0;//not read
        $item->timestamp = time();
        $item->date_create = date('d.m.y H:i:s');
        $item->shift_id = (int) $one_schedule['id'];
        $item->status = 1;//send to app
        $item->message_type = 'shifts_changes';
        $item->forgot_click_status = 0;
        $item->forgot_click_stop = 1;
        $item->subject_en = $this->db->escape('Your schedule has ended');
        $item->subject_is = $this->db->escape('Your schedule has ended');
        $item->about_changes = 0;
        
        $this->db->insertObject('#__app_api_messages', $item);
    }
    
    private function sendNotificationsForgotToClickWhenShiftToManagerStart($availableUsers, $one_company_array)
    {
        //load company schedules
        $all_company_schedules = $this->loadUserSchedules($availableUsers);
        $filtered_schedules = [];
        $all_company_timesheets = $this->loadCompanyTimescheets($availableUsers);
        
        $filtered_timesheets = [];
        
        //group schedules by user
        foreach($all_company_schedules as $k => $v){
            $filtered_schedules[$v['room_id']][] = $v; 
        }
        
        //group timesheets by user
        foreach($all_company_timesheets as $k => $v){
            $filtered_timesheets[$v->id_user][] = $v;
        }
        
        foreach ($availableUsers as $one_company_user) {
            $user_sended = & JFactory::getUser($one_company_user);
            
            /*if($user_sended->id != 2867){
                continue;
            }*/
            //exit;
            
            $final_username = '';
            if (!empty($user_sended->username0)) {
                $final_username = $user_sended->username0;
            } elseif (!empty($user_sended->username)) {
                $final_username = $user_sended->username;
            } elseif (!empty($user_sended->name)) {
                $final_username = $user_sended->name;
            }
            
            $added_user_name = $final_username;
            $user_schedules =  $filtered_schedules[$user_sended->id];//shifts
            $user_timesheets = $filtered_timesheets[$user_sended->id];//current date only
            
            
            
            // only 1 schedule for 1 day is possible. only for multi dates schedules
            $schedule_today = reset(array_filter($user_schedules, function ($var) {
                //$schedule_today_date_arr = explode(' ', $var['start']);
                //$schedule_today_end_date_arr = explode(' ', $var['end']);
                $period = new DatePeriod(
                    new DateTime(DateTime::createFromFormat('Y-m-d H:i:s', $var['start'])->format('Y-m-d H:i:s')),
                    new DateInterval('P1D'),
                    new DateTime(DateTime::createFromFormat('Y-m-d H:i:s', $var['end'])->format('Y-m-d H:i:s'))
                );
                
                $normal_array_of_dates0 = [];
                $iab = 0;
                    
                    
                foreach ($period as $key => $value) {
                    $normal_array_of_dates0[$value->format('d.m.Y')]['with_seconds'] = $value->format('d.m.Y H:i:s');
                    $normal_array_of_dates0[$value->format('d.m.Y')]['date'] = $value->format('d.m.Y');
                    $normal_array_of_dates0[$value->format('d.m.Y')]['unix'] = $value->format('U');
                        
                    $iab++;
                }
                    
                $this->out('period obj:')->out(print_r($normal_array_of_dates0, true));
                
                return (strtotime(trim($var['start'])) <= strtotime('today') && strtotime(trim($var['end'])) >= strtotime('today') || (strtotime(trim($var['start'])) >= strtotime('today') && strtotime(trim($var['end'])) >= strtotime('today') && in_array(date('d.m.Y'), array_column($normal_array_of_dates0, 'date'))));
            }));
            
            //$this->out('$schedule_today')->out(var_dump($schedule_today));
            
            // if there is no schdule just exit the funtion, no need to notify the user
            if(empty($schedule_today)){
                continue;
            }
            
            //$schedule_today_start_unix = strtotime($schedule_today['start']);
            //$schedule_today_end_unix = strtotime($schedule_today['end']);
           
            $schedule_today_date_arr = explode(' ', $schedule_today['start']);
            $schedule_today_end_date_arr = explode(' ', $schedule_today['end']);
            
            if(count($schedule_today_date_arr) === 2){
                $schedule_today_start_unix_obj  = DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d') . $schedule_today_date_arr[1]);
                $schedule_today_start_unix = $schedule_today_start_unix_obj->format('U');
            } if(count($schedule_today_end_date_arr) === 2){
                $schedule_today_end_unix_obj  = DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d') . $schedule_today_end_date_arr[1]);
                $schedule_today_end_unix = $schedule_today_end_unix_obj->format('U');
            }
            $this->out('today datetime is')->out(date('d.m.Y H:i:s', strtotime('today')));
            //$this->out(print_r($schedule_today_end_unix, true));
            //exit;
            $time_now_unix = strtotime('now');
            
            $this->out('point');
            $this->out('now')->out(date('d.m.Y H:i:s', $time_now_unix));
            $this->out(date('d.m.Y H:i:s', $schedule_today_start_unix));
            $this->out(date('d.m.Y H:i:s', $schedule_today_end_unix));
            
            // if current time inside the shift ? otherwise skip iteration (user)
            if($time_now_unix >= $schedule_today_start_unix && $time_now_unix <= $schedule_today_end_unix /*|| $schedule_today_start_unix >= strtotime('today') && $schedule_today_end_unix >= strtotime('today')*/){
                $this->out('pp');
                // do user have started time ?
                $timesheets_started = reset(array_filter($user_timesheets, function ($var) {
                    return ($var->date_exit == '0000-00-00 00:00:00' /*&& $schedule_today_end_unix  < strtotime($var->date_exit)*/);
                }));
                
                //$this->out(' $timesheets_started')->out(var_dump( $timesheets_started));
                
                
                if (count($user_timesheets) > 0) {
                    //point 
                    $last_timesheet_row_on_current_date = $user_timesheets[count($user_timesheets) - 1];
                    //$this->out(print_r($last_timesheet_row_on_current_date, true));

                    $last_timesheet_end_row = $last_timesheet_row_on_current_date->date_exit;

                    if ($last_timesheet_end_row != '0000-00-00 00:00:00') {
                        $last_timesheet_end_row_date_obj = DateTime::createFromFormat('Y-m-d H:i:s', $last_timesheet_end_row);
                        $last_timesheet_end_unix = $last_timesheet_end_row_date_obj->format('U');
                    }
                }

                //$this->out('last row:')->out(print_r($last_timesheet_row_on_current_date), true);
            
                // if timesheet is empty OR user don't work now send user notification
                if(empty($user_timesheets) || !$timesheets_started && (isset($schedule_today_start_unix) && $last_timesheet_end_unix < $schedule_today_start_unix)){
                    $check_sended = $this->checkSendedEmail($schedule_today['id'], $user_sended->id);
                    
                    if($check_sended === 0){
                        $this->out('send mail to manager');
                        $this->sendNotificationToManagerAboutUserForgotStart($one_company_user, $one_company_array, $schedule_today);
                    }
                    
                } else {
                    $this->out('dont send email');
                }      
            }
        }
    }
    
    private function sendNotificationToManagerAboutUserForgotStart($one_company_user, $one_company_array, $schedule)
    {
        $manager = & JFactory::getUser($one_company_array['owner_id']);
        $this->out(print_r($one_company_user, true));
        
        $manager_name = '';
        if (!empty($manager->username0)) {
            $manager_name = $manager->username0;
        } elseif (!empty($manager->username)) {
            $manager_name = $manager->username;
        } elseif (!empty($manager->name)) {
            $manager_name = $manager->name;
        }
        $this->out('send mail to '.$manager_name);
        
        $config = $this->config;

        $sender = [
            $config->get('mailfrom'), 
            $config->get('fromname')
        ];
        
        $user_sended = & JFactory::getUser($one_company_user);
        $email = $manager->email;
        
            
        $final_username = '';
        if (!empty($user_sended->username0)) {
            $final_username = $user_sended->username0;
        } elseif (!empty($user_sended->username)) {
            $final_username = $user_sended->username;
        } elseif (!empty($user_sended->name)) {
            $final_username = $user_sended->name;
        }
        
        $added_user_name = $final_username;

        if(!empty($email)){
            $subject = 'Your employee '.$added_user_name.' did not show up for work shift';  
            $message = '';
                
            $message .= '<p>Dear <strong>'.$manager_name . '</strong>,</p>';
            $message .= '<p><strong>'.$added_user_name.'</strong> did not clock into work according to scheduled time !</p>';
            $message .= '<p>His schedule is: '.$schedule['start'] . '-' . $schedule['end'] . '</p>';

            $mailer = JFactory::getMailer();
            $mailer->setSender($sender);
            $mailer->addRecipient($email, $manager_name);
            $mailer->addBcc('developer3452@gmail.com', 'developer3452');

            $mailer->setSubject($subject);
            $mailer->isHTML(TRUE);
            $mailer->setBody($message); 
                
            if($mailer->send()){
                $this->updateEmailStatusNotificationToManagerAboutUserForgotStart($schedule);
            }
        }
    }
    
    private function updateEmailStatusNotificationToManagerAboutUserForgotStart($schedule)
    {
        $query = "UPDATE  #__app_api_messages SET `forgot_click_status_email` = '1' WHERE `shift_id` = '".$schedule['id']."' AND `message_type` = 'сt_notifications'  AND `about_changes`='0'";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    private function loadCompanyTimescheets($users)
    {
        $query = "SELECT * FROM #__audit_time WHERE `id_user` IN (".join(",",$users).") AND `date` = '" . date('Y-m-d') . "' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $result = $this->db->loadObjectList();
        
        return $result; 
    }
     
    private function sendNotificationsForgotToClickWhenShiftStart($availableUsers, $one_company_array)
    {
        //load company schedules
        $all_company_schedules = $this->loadUserSchedules($availableUsers);
        $filtered_schedules = [];
        $all_company_timesheets = $this->loadCompanyTimescheets($availableUsers);
        
        $filtered_timesheets = [];
        
        //group schedules by user
        foreach($all_company_schedules as $k => $v){
            $filtered_schedules[$v['room_id']][] = $v; 
        }
        
        //group timesheets by user
        foreach($all_company_timesheets as $k => $v){
            $filtered_timesheets[$v->id_user][] = $v;
        }
        
        foreach ($availableUsers as $one_company_user) {
            $user_sended = & JFactory::getUser($one_company_user);
            
            /*if($user_sended->id != 3869){
                continue;
            }*/
            //exit;
            
            $final_username = '';
            if (!empty($user_sended->username0)) {
                $final_username = $user_sended->username0;
            } elseif (!empty($user_sended->username)) {
                $final_username = $user_sended->username;
            } elseif (!empty($user_sended->name)) {
                $final_username = $user_sended->name;
            }
            
            $added_user_name = $final_username;
            $user_schedules =  $filtered_schedules[$user_sended->id];//shifts
            $user_timesheets = $filtered_timesheets[$user_sended->id];//current date only
            
            
            
            // only 1 schedule for 1 day is possible. only for multi dates schedules
            $schedule_today = reset(array_filter($user_schedules, function ($var) {
                //$schedule_today_date_arr = explode(' ', $var['start']);
                //$schedule_today_end_date_arr = explode(' ', $var['end']);
                
                $period = new DatePeriod(
                    new DateTime(DateTime::createFromFormat('Y-m-d H:i:s', $var['start'])->format('Y-m-d H:i:s')),
                    new DateInterval('P1D'),
                    new DateTime(DateTime::createFromFormat('Y-m-d H:i:s', $var['end'])->format('Y-m-d H:i:s'))
                );
                
                $normal_array_of_dates0 = [];
                $iab = 0;
                    
                    
                foreach ($period as $key => $value) {
                    $normal_array_of_dates0[$value->format('d.m.Y')]['with_seconds'] = $value->format('d.m.Y H:i:s');
                    $normal_array_of_dates0[$value->format('d.m.Y')]['date'] = $value->format('d.m.Y');
                    $normal_array_of_dates0[$value->format('d.m.Y')]['unix'] = $value->format('U');
                        
                    $iab++;
                }
                    
                //$this->out('period obj:')->out(print_r($normal_array_of_dates0, true));
                
                return (strtotime(trim($var['start'])) <= strtotime('today') && strtotime(trim($var['end'])) >= strtotime('today') || (strtotime(trim($var['start'])) >= strtotime('today') && strtotime(trim($var['end'])) >= strtotime('today') && in_array(date('d.m.Y'), array_column($normal_array_of_dates0, 'date'))));
            }));
            
            $this->out('$schedule_today')->out(var_dump($schedule_today));
            
            // if there is no schdule just exit the funtion, no need to notify the user
            if(empty($schedule_today)){
                continue;
            }
            
            //$schedule_today_start_unix = strtotime($schedule_today['start']);
            //$schedule_today_end_unix = strtotime($schedule_today['end']);
           
            $schedule_today_date_arr = explode(' ', $schedule_today['start']);
            $schedule_today_end_date_arr = explode(' ', $schedule_today['end']);
            
            if(count($schedule_today_date_arr) === 2){
                $schedule_today_start_unix_obj  = DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d') . $schedule_today_date_arr[1]);
                $schedule_today_start_unix = $schedule_today_start_unix_obj->format('U');
            } if(count($schedule_today_end_date_arr) === 2){
                $schedule_today_end_unix_obj  = DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d') . $schedule_today_end_date_arr[1]);
                $schedule_today_end_unix = $schedule_today_end_unix_obj->format('U');
            }
            //$this->out('today datetime is')->out(date('d.m.Y H:i:s', strtotime('today')));
            //$this->out(print_r($schedule_today_end_unix, true));
            
            $time_now_unix = strtotime('now');
            
            $this->out('point');
            $this->out('now')->out(date('d.m.Y H:i:s', $time_now_unix));
            $this->out(date('d.m.Y H:i:s', $schedule_today_start_unix));
            $this->out(date('d.m.Y H:i:s', $schedule_today_end_unix));
            
            // if current time inside the shift ? otherwise skip iteration (user)
            if($time_now_unix >= $schedule_today_start_unix && $time_now_unix <= $schedule_today_end_unix /*|| $schedule_today_start_unix >= strtotime('today') && $schedule_today_end_unix >= strtotime('today')*/){
                $this->out('pp');
                // do user have started time ?
                $timesheets_started = reset(array_filter($user_timesheets, function ($var) {
                    return ($var->date_exit == '0000-00-00 00:00:00' /*&& $schedule_today_end_unix  < strtotime($var->date_exit)*/);
                }));
                
                $this->out(' $timesheets_started')->out(var_dump( $timesheets_started));
                 
                 
                if (count($user_timesheets) > 0) {
                    //point 
                    $last_timesheet_row_on_current_date = $user_timesheets[count($user_timesheets) - 1];
                    $this->out(print_r($last_timesheet_row_on_current_date, true));

                    $last_timesheet_end_row = $last_timesheet_row_on_current_date->date_exit;

                    if ($last_timesheet_end_row != '0000-00-00 00:00:00') {
                        $last_timesheet_end_row_date_obj = DateTime::createFromFormat('Y-m-d H:i:s', $last_timesheet_end_row);
                        $last_timesheet_end_unix = $last_timesheet_end_row_date_obj->format('U');
                    }
                }

                //$this->out('last row:')->out(print_r($last_timesheet_row_on_current_date), true);
            
                // if timesheet is empty OR user don't work now send user notification
                if(empty($user_timesheets) || !$timesheets_started && (isset($schedule_today_start_unix) && $last_timesheet_end_unix < $schedule_today_start_unix)){
                   // $check_sended = $this->checkSended($schedule_today['id'], $user_sended->id);
                    
                    if($check_sended === 0){
                        $this->out('send 00');
                        $this->addNotificationAboutForgotStart($schedule_today, $schedule_today_start_unix, $schedule_today_end_unix, $last_timesheet_row_on_current_date);
                    }
                    
                } else {
                    $this->out('dont send notifications');
                }      
            }
        }
    }
    
    private function checkSendedEmail($shift_id, $user_id)
    {
        $query = "SELECT `id`, `forgot_click_status_email` FROM #__app_api_messages WHERE `shift_id` ='".(int)$shift_id."' AND `user_id` = '$user_id'  AND `timestamp` >= '". strtotime('today')."' AND `forgot_click_status_email`='1' AND `about_changes`='0'";
        $this->db->setQuery($query);
        $result = $this->db->loadObjectList();
        
        $this->out('checkSendedEmail():')->out(print_r($result, true))->out('count:')->out(count($result));
        if(count($result) > 0){
            $res = 1;
        } else{
            $res = 0;
        }
        
        return $res;
    }
    
    
    
    private function removeOldMessages(int $schedule_id, string $type)
    {
        switch($type){
            case 'forgot_start':
                $query = "DELETE FROM #__app_api_messages WHERE `shift_id` = '".$schedule_id."' AND `message_type` = 'сt_notifications' AND `forgot_click_status` = '1'";
                $this->db->setQuery($query);
                $this->db->query();
        
                break;
        }
    }
    
    private function loadAttachedUserRule(object $user_obj)
    {
  
        try{
            $audit_time_wages_info = $this->model_rules->getTimeWagesInfo($user_obj->id, 'en', null, null, 0); 
        } catch (Exception $ex) {
            return false;
        }
        
        //return $audit_time_wages_info;
        switch ($audit_time_wages_info['mode']) {
            //of settings page 
            case 'default':
                $daytime_start = $audit_time_wages_info['result'][0]->day_time;
                $daytime_end = $audit_time_wages_info['result'][1]->day_time;
            
                //$after_hours_start=$audit_time_wages[0]->after_hours;
                $after_hours_start = $audit_time_wages_info['result'][0]->after_hours;

                //$after_hours_end=$audit_time_wages[1]->after_hours;
                $after_hours_end = $audit_time_wages_info['result'][1]->after_hours;

                //$day_break_time=$audit_time_wages[0]->day_break_time;
                $day_break_time = $audit_time_wages_info['result'][0]->day_break_time;
                //echo $day_break_time;
                //$day_time_to_break=$audit_time_wages[0]->day_time_to_break;
                $day_time_to_break = $audit_time_wages_info['result'][0]->day_time_to_break;

                //$after_hours_break_time=$audit_time_wages[0]->after_hours_break_time;
                $after_hours_break_time = $audit_time_wages_info['result'][0]->after_hours_break_time;

                //$after_hours_time_to_break=$audit_time_wages[0]->after_hours_time_to_break;
                $after_hours_time_to_break = $audit_time_wages_info['result'][0]->after_hours_time_to_break;

                //$night_time_break_time=$audit_time_wages[0]->night_time_break_time;
                $night_time_break_time = $audit_time_wages_info['result'][0]->night_time_break_time;

                //$night_time_time_to_break=$audit_time_wages[0]->night_time_time_to_break;
                $night_time_time_to_break = $audit_time_wages_info['result'][0]->night_time_time_to_break;

                //$overtime_work_break_time=$audit_time_wages[0]->overtime_work_break_time;
                $overtime_work_break_time = $audit_time_wages_info['result'][0]->overtime_work_break_time;

                //$overtime_work_time_to_break=$audit_time_wages[0]->overtime_work_time_to_break;
                $overtime_work_time_to_break = $audit_time_wages_info['result'][0]->overtime_work_time_to_break;

                //$public_holidays_break_time=$audit_time_wages[0]->public_holidays_break_time;
                $public_holidays_break_time = $audit_time_wages_info['result'][0]->public_holidays_break_time;

                //$public_holidays_time_to_break=$audit_time_wages[0]->public_holidays_time_to_break;
                $public_holidays_time_to_break = $audit_time_wages_info['result'][0]->public_holidays_time_to_break;

                //start new feature 8 hours
                if (!empty($audit_time_wages_info['result'][0]->extra_hours) && $audit_time_wages_info['result'][0]->extra_hours != '00:00') {
                    $extra_hours = DateTimeWR::createFromFormat('H:i', $audit_time_wages_info['result'][0]->extra_hours);
                    //echo '$extra_hour-'.$extra_hours->format('H:i'); 
                } else {
                    $extra_hours = DateTimeWR::createFromFormat('H:i', '23:59');
                    /* $audit_time_wages_info['result'][0]->extra_hours='00:00';
                      $extra_hours=DateTimeWR::createFromFormat('H:i', $audit_time_wages_info['result'][0]->extra_hours);
                      echo '$extra_hour-'.$extra_hours->format('H:i');
                      //$extra_hours=null; */
                }
                //end code 8 hours





                if (isset($audit_time_wages_info['result'][0]->after_hours)) {
                    $time = explode(':', $audit_time_wages_info['result'][0]->after_hours);
                    $daytimehours = @$time[0];
                    $daytimeminutes = @$time[1];
                } else {
                    $daytimehours = '17';
                    $daytimeminutes = '00';
                }


                if (isset($audit_time_wages_info['result'][0]->day_time)) {
                    $time = explode(':', $audit_time_wages_info['result'][0]->day_time);
                    $daytimehours_start = @$time[0];
                    $daytimeminutes_start = @$time[1];
                } else {
                    $daytimehours_start = '09';
                    $daytimeminutes_start = '00';
                }


                break;
            case 'rule':
                $daytime_start = $audit_time_wages_info['result']->day_time_start;
                $daytime_end = $audit_time_wages_info['result']->day_time_end;
                
                $after_hours_start = $audit_time_wages_info['result']->after_hours_start;
                $after_hours_end = $audit_time_wages_info['result']->after_hours_end;
                $day_break_time = $audit_time_wages_info['result']->day_break_time;
                //echo $day_break_time;
                $day_time_to_break = $audit_time_wages_info['result']->day_time_to_break;
                $after_hours_break_time = $audit_time_wages_info['result']->after_hours_break_time;
                $after_hours_time_to_break = $audit_time_wages_info['result']->after_hours_time_to_break;
                $night_time_break_time = $audit_time_wages_info['result']->night_time_break_time;
                $night_time_time_to_break = $audit_time_wages_info['result']->night_time_time_to_break;
                $overtime_work_break_time = $audit_time_wages_info['result']->overtime_work_break_time;
                $overtime_work_time_to_break = $audit_time_wages_info['result']->overtime_work_time_to_break;
                $public_holidays_break_time = $audit_time_wages_info['result']->public_holidays_break_time;
                $public_holidays_time_to_break = $audit_time_wages_info['result']->public_holidays_time_to_break;

                //start new feature 8 hours
                if (!empty($audit_time_wages_info['result']->extra_hours) && $audit_time_wages_info['result']->extra_hours != '00:00') {
                    $extra_hours = DateTimeWR::createFromFormat('H:i', $audit_time_wages_info['result']->extra_hours);
                    // echo '$extra_hour-'.$extra_hours->format('H:i'); 
                } else {
                    $extra_hours = DateTimeWR::createFromFormat('H:i', '23:59');
                }
                //end code 8 hours

                if (isset($after_hours_start)) {
                    $time = explode(':', $after_hours_start);
                    $daytimehours = @$time[0];
                    $daytimeminutes = @$time[1];
                } else {
                    $daytimehours = '17';
                    $daytimeminutes = '00';
                }


                if (isset($audit_time_wages_info['result']->day_time_start)) {
                    $time = explode(':', $audit_time_wages_info['result']->day_time_start);
                    $daytimehours_start = @$time[0];
                    $daytimeminutes_start = @$time[1];
                } else {
                    $daytimehours_start = '09';
                    $daytimeminutes_start = '00';
                }
                break;
            case 'union':
                $daytime_start = $audit_time_wages_info['result']->day_time_start;
                $daytime_end = $audit_time_wages_info['result']->day_time_end;
                
                $after_hours_start = $audit_time_wages_info['result']->after_hours_start;
                $after_hours_end = $audit_time_wages_info['result']->after_hours_end;
                $day_break_time = $audit_time_wages_info['result']->day_break_time;
                //echo $day_break_time;
                $day_time_to_break = $audit_time_wages_info['result']->day_time_to_break;
                $after_hours_break_time = $audit_time_wages_info['result']->after_hours_break_time;
                $after_hours_time_to_break = $audit_time_wages_info['result']->after_hours_time_to_break;
                $night_time_break_time = $audit_time_wages_info['result']->night_time_break_time;
                $night_time_time_to_break = $audit_time_wages_info['result']->night_time_time_to_break;
                $overtime_work_break_time = $audit_time_wages_info['result']->overtime_work_break_time;
                $overtime_work_time_to_break = $audit_time_wages_info['result']->overtime_work_time_to_break;
                $public_holidays_break_time = $audit_time_wages_info['result']->public_holidays_break_time;
                $public_holidays_time_to_break = $audit_time_wages_info['result']->public_holidays_time_to_break;

                //start new feature 8 hours
                if (!empty($audit_time_wages_info['result']->extra_hours) && $audit_time_wages_info['result']->extra_hours != '00:00') {
                    $extra_hours = DateTimeWR::createFromFormat('H:i', $audit_time_wages_info['result']->extra_hours);
                    // echo '$extra_hour-'.$extra_hours->format('H:i'); 
                } else {
                    $extra_hours = DateTimeWR::createFromFormat('H:i', '23:59');
                }
                //end code 8 hours

                if (isset($after_hours_start)) {
                    $time = explode(':', $after_hours_start);
                    $daytimehours = @$time[0];
                    $daytimeminutes = @$time[1];
                } else {
                    $daytimehours = '17';
                    $daytimeminutes = '00';
                }


                if (isset($audit_time_wages_info['result']->day_time_start)) {
                    $time = explode(':', $audit_time_wages_info['result']->day_time_start);
                    $daytimehours_start = @$time[0];
                    $daytimeminutes_start = @$time[1];
                } else {
                    $daytimehours_start = '09';
                    $daytimeminutes_start = '00';
                }

                $enable_overtime_mode_in_union = $this->config->get('enable_overtime_mode_in_union');
                if ($enable_overtime_mode_in_union == '1') {
                    //get overworks
                    $selected_rule_id = $audit_time_wages_info['selected_union'];
                   // $overworks = $this->custom_model->getOverworksForPayPeriod($selected_rule_id);
                   // $count_overworks = count($overworks);
                }
                break;
            case 'shift':
                $enable_overtime_mode_in_union = $this->config->get('enable_union_limit_in_1_week');
                $day_number0 = date('N');

                try {
                    $audit_time_wages_info = $this->model_rules->getTimeWagesInfo($user_obj->id, 'en', $day_number0, date('Y-m-d'), 0);
                } catch (Exception $ex) {
                    return false;
                }

                $daytime_start = $audit_time_wages_info['result']->day_time_start;
                $daytime_end = $audit_time_wages_info['result']->day_time_end;
                /* echo '<pre>shift info:';
                  print_r($audit_time_wages_info);
                  echo '</pre>'; */

                $after_hours_start = $audit_time_wages_info['result']->after_hours_start;
                $after_hours_end = $audit_time_wages_info['result']->after_hours_end;
                $day_break_time = $audit_time_wages_info['result']->day_break_time;
                $day_time_to_break = $audit_time_wages_info['result']->day_time_to_break;
                $after_hours_break_time = $audit_time_wages_info['result']->after_hours_break_time;
                $after_hours_time_to_break = $audit_time_wages_info['result']->after_hours_time_to_break;
                $night_time_break_time = $audit_time_wages_info['result']->night_time_break_time;
                $night_time_time_to_break = $audit_time_wages_info['result']->night_time_time_to_break;
                $overtime_work_break_time = $audit_time_wages_info['result']->overtime_work_break_time;
                $overtime_work_time_to_break = $audit_time_wages_info['result']->overtime_work_time_to_break;
                $public_holidays_break_time = $audit_time_wages_info['result']->public_holidays_break_time;
                $public_holidays_time_to_break = $audit_time_wages_info['result']->public_holidays_time_to_break;


                //start new feature 8 hours
                if (!empty($audit_time_wages_info['result']->extra_hours)) {
                    $extra_hours = DateTimeWR::createFromFormat('H:i', $audit_time_wages_info['result']->extra_hours);
                    //echo '$extra_hour-'.$extra_hours->format('H:i'); 
                }
                //end code 8 hours

                if (isset($after_hours_start)) {
                    $time = explode(':', $after_hours_start);
                    $daytimehours = @$time[0];
                    $daytimeminutes = @$time[1];
                } else {
                    $daytimehours = '17';
                    $daytimeminutes = '00';
                }



                
                break;
            case 'loop':
                $day_number0 = date('N');

                try {
                    $audit_time_wages_info = $this->model_rules->getTimeWagesInfo($user_obj->id, 'en', $day_number0, date('Y-m-d'), 0);
                } catch (Exception $ex) {
                    return false;
                }

                $daytime_start = $audit_time_wages_info['result']->day_time_start;
                $daytime_end = $audit_time_wages_info['result']->day_time_end;
                /*echo '<pre>loop info:';
                print_r($audit_time_wages_info);
                echo '</pre>';*/ 
                break;
            case 'loop4':
                $day_number0 = date('N');

                try {
                    $audit_time_wages_info = $this->model_rules->getTimeWagesInfo($user_obj->id, 'en', $day_number0, date('Y-m-d'), 0);
                } catch (Exception $ex) {
                    return false;
                }

                $daytime_start = $audit_time_wages_info['result']->day_time_start;
                $daytime_end = $audit_time_wages_info['result']->day_time_end;
                
                /*echo '<pre>loop4 info:';
                print_r($audit_time_wages_info);
                echo '</pre>';*/
                break;
            case 'spec':
                $daytime_start = $audit_time_wages_info['result']->day_time_start;
                $daytime_end = $audit_time_wages_info['result']->day_time_end;
                
                $after_hours_start = $audit_time_wages_info['result']->after_hours_start;
                $after_hours_end = $audit_time_wages_info['result']->after_hours_end;
                $day_break_time = $audit_time_wages_info['result']->day_break_time;
                $day_time_to_break = $audit_time_wages_info['result']->day_time_to_break;
                $after_hours_break_time = $audit_time_wages_info['result']->after_hours_break_time;
                $after_hours_time_to_break = $audit_time_wages_info['result']->after_hours_time_to_break;
                $night_time_break_time = $audit_time_wages_info['result']->night_time_break_time;
                $night_time_time_to_break = $audit_time_wages_info['result']->night_time_time_to_break;
                $overtime_work_break_time = $audit_time_wages_info['result']->overtime_work_break_time;
                $overtime_work_time_to_break = $audit_time_wages_info['result']->overtime_work_time_to_break;
                $public_holidays_break_time = $audit_time_wages_info['result']->public_holidays_break_time;
                $public_holidays_time_to_break = $audit_time_wages_info['result']->public_holidays_time_to_break;

                //start new feature 8 hours
                if (!empty($audit_time_wages_info['result']->extra_hours) && $audit_time_wages_info['result']->extra_hours != '00:00') {
                    $extra_hours = DateTimeWR::createFromFormat('H:i', $audit_time_wages_info['result']->extra_hours);
                    // echo '$extra_hour-'.$extra_hours->format('H:i'); 
                } else {
                    $extra_hours = DateTimeWR::createFromFormat('H:i', '23:59');
                }
                //end code 8 hours

                if (isset($after_hours_start)) {
                    $time = explode(':', $after_hours_start);
                    $daytimehours = @$time[0];
                    $daytimeminutes = @$time[1];
                } else {
                    $daytimehours = '17';
                    $daytimeminutes = '00';
                }


                if (isset($audit_time_wages_info['result']->day_time_start)) {
                    $time = explode(':', $audit_time_wages_info['result']->day_time_start);
                    $daytimehours_start = @$time[0];
                    $daytimeminutes_start = @$time[1];
                } else {
                    $daytimehours_start = '09';
                    $daytimeminutes_start = '00';
                }
                break;
        }

        return [
            'daytime_start' => $daytime_start,
            'daytime_end' => $daytime_end,
            'full_info' => $audit_time_wages_info   
        ];
            
    }
    
    private function sendNotificationsHourBeforeStart($availableUsers)
    {
       //$this->out(print_r('$availableUsers:', true))->out(print_r($availableUsers, true));
       
        //foreach array of ids
        foreach ($availableUsers as $one_company_user) {
            if($one_company_user == -1){
                continue;
            }
            $user_sended = & JFactory::getUser($one_company_user);
           /* if(!in_array($user_sended->id, [3629, 3961])){
                continue;
            }*/
            //$this->out('dd');
            $attached_rule_to_user = $this->loadAttachedUserRule($user_sended);
            if($attached_rule_to_user === false || empty($attached_rule_to_user['daytime_start'])){
                continue;
            }
            $daytime_start_string = $attached_rule_to_user['daytime_start'];
            $daytime_start_obj = DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d') . $daytime_start_string . ':00');
            $daytime_minus_1_hours_obj = clone $daytime_start_obj;
            $daytime_minus_1_hours_obj->modify('-1hours');
            
            $current_time = time();
            $current_time_object = DateTime::createFromFormat('U', $current_time);
             //$this->out(print_r('$attached_rule_to_user:', true))->out(print_r($attached_rule_to_user, true));
            $this->out(print_r('$daytime_start_obj:', true))->out(print_r($daytime_start_obj->format('d.m.Y H:i:s'), true));
            $this->out(print_r('$daytime_minus_1_hours_obj:', true))->out(print_r($daytime_minus_1_hours_obj->format('d.m.Y H:i:s'), true));
            
            if($current_time_object->format('U') >= $daytime_minus_1_hours_obj->format('U') && $current_time_object->format('U') <= $daytime_minus_1_hours_obj->format('U') +120){
               
                if($this->checkSended($user_sended->id, 'before_1h') == 0){
                    $this->out('add notification to db about 1 hours before daytime...');
                    $this->addNotificationAboutStartDaytime($user_sended, $daytime_start_obj->format('U'));
                }
            }
        }
    }
    
    private function addNotificationAboutStart(object $user_obj)
    {
        $item = new stdClass();
        
        $text_en = 'Remember to clock in to work.';
        $text_is = 'Mundu að stimpla þig til vinnu';
        
        $item->id = null;
        $item->user_id = (int) $user_obj->id;
        $item->text_en = strip_tags($this->db->escape($text_en));
        $item->text_is = strip_tags($this->db->escape($text_is));
        $item->is_read = 0;//not read
        $item->timestamp = time();
        $item->date_create = date('d.m.y H:i:s');
        $item->shift_id = 0;
        $item->status = 1;//send to app
        $item->message_type = 'сt_notifications';
        $item->subject_en = $this->db->escape('Remember to clock in to work.');
        $item->subject_is = $this->db->escape('Mundu að stimpla þig til vinnu.');
        $item->about_changes = 0;
        $item->about_start_1_h = 0;
        $item->about_click_start_ct = 1;//key item for this method
        
        $this->db->insertObject('#__app_api_messages', $item);
    }
    
    private function addNotificationAboutStartDaytime(object $user_obj, int $start_unix)
    {
        $item = new stdClass();
        
        $text_en = 'Your work ' . date('d.m.Y H:i:s', $start_unix) . ' start in one hour.';
        $text_is = 'Starf þitt ' . date('d.m.Y H:i:s', $start_unix) . ' hefst eftir eina klst.';
        
        $item->id = null;
        $item->user_id = (int) $user_obj->id;
        $item->text_en = strip_tags($this->db->escape($text_en));
        $item->text_is = strip_tags($this->db->escape($text_is));
        $item->is_read = 0;//not read
        $item->timestamp = time();
        $item->date_create = date('d.m.y H:i:s');
        $item->shift_id = 0;
        $item->status = 1;//send to app
        $item->message_type = 'сt_notifications';
        $item->subject_en = $this->db->escape('Your work start in one hour.');
        $item->subject_is = $this->db->escape('Starf þitt hefst eftir eina klst.');
        $item->about_changes = 0;
        $item->about_start_1_h = 1;
        $item->about_click_start_ct = 0;
        
        $this->db->insertObject('#__app_api_messages', $item);
    }
    
    private function checkSended(int $user_id, string $type)
    {
        switch($type){
            case 'before_1h':
                $query = "SELECT `id` FROM #__app_api_messages WHERE `user_id` = '$user_id' AND `timestamp` >= '". strtotime('today')."' AND `message_type` = 'сt_notifications' AND `about_start_1_h`='1'";
                $this->db->setQuery($query);
                $result = $this->db->loadObjectList();
        
               // $this->out($query);
                $this->out('checkSended():')->out(print_r($result, true))->out('count:')->out(count($result));
                if(count($result) > 0){
                    $res = 1;
                } else{
                    $res = 0;
                }
        
            return $res;
            case 'click_start':
                $query = "SELECT `id` FROM #__app_api_messages WHERE `user_id` = '$user_id' AND `timestamp` >= '". strtotime('today')."' AND `message_type` = 'сt_notifications' AND `about_click_start_ct`='1'";
                $this->db->setQuery($query);
                $result = $this->db->loadObjectList();
        
                //$this->out($query);
                $this->out('checkSended():')->out(print_r($result, true))->out('count:')->out(count($result));
                if(count($result) > 0){
                    $res = 1;
                } else{
                    $res = 0;
                }
            return $res;
            case 'email_to_manager':
                $query = "SELECT `id` FROM #__app_api_messages WHERE `user_id` = '$user_id' AND `timestamp` >= '". strtotime('today')."' AND `message_type` = 'сt_notifications' AND `email_ct`='1'";
                $this->db->setQuery($query);
                $result = $this->db->loadObjectList();
        
                //$this->out($query);
                $this->out('checkSended():')->out(print_r($result, true))->out('count:')->out(count($result));
                if(count($result) > 0){
                    $res = 1;
                } else{
                    $res = 0;
                }
            return $res;
            case 'forgot_end':
                $query = "SELECT `id` FROM #__app_api_messages WHERE `user_id` = '$user_id' AND `timestamp` >= '". strtotime('today')."' AND `message_type` = 'сt_notifications' AND `daytime_end_ct`='1'";
                $this->db->setQuery($query);
                $result = $this->db->loadObjectList();
        
                //$this->out($query);
                $this->out('checkSended():')->out(print_r($result, true))->out('count:')->out(count($result));
                if(count($result) > 0){
                    $res = 1;
                } else{
                    $res = 0;
                }
            return $res;
                
           
        }
       
    }
    
   
    
    private function loadEvents()
    {
        
        
        $availableUsers  =  array(-1);
        $rms  = $this->loadRooms();
        if(!empty($rms)) {
            foreach ($rms as $r) {
                $availableUsers[] = intval($r->id);
            }
        }
        
        //$query = "SELECT * FROM #__com_shifts_reservations WHERE room_id in (".join(",",$availableUsers).") AND   NOT ((end <= '".$start."') OR (start >= '".$end."'))";
        $query = "SELECT * FROM #__com_shifts_reservations WHERE room_id in (".join(",",$availableUsers).")";
        $this->db->setQuery($query);
        $result = $this->db->loadAssocList();
        
        $events = array();

        date_default_timezone_set("UTC");
        $now = new DateTime("now");
        $today = $now->setTime(0, 0, 0);
        
        foreach($result as $row) {
            $e = new stdClass();
            $e->id = $row['id'];
            //$e->text = $row['name'];
            $e->text = '';
            $e->start = $row['start'];
            $e->end= $row['end'];
            $e->resource = $row['room_id'];
            $e->bubbleHtml = '';//"Reservation details: <br/>".$e->text;
    
            // additional properties
            $e->status = $row['status'];
            $e->paid = $row['paid'];
            $e->shift_color = $row['shift_color'];
            $e->shift_name = $row['shift_name'];
            $e->shift_message = $row['shift_message'];
            $e->icon_date   = json_decode($row['icon_date'],true);
            $e->tasks_ids = $row['tasks_ids'];
            $e->standart_tasks_ids = $row['standart_tasks_ids'];
            
            if(empty($e->icon_date))
                $e->icon_date  =  array();
            
            $days  = array();
            $start  =   strtotime(date("Y-m-d 00:00:00", strtotime($e->start)));
            $end    =   strtotime(date("Y-m-d 00:00:00", strtotime($e->end)));
            $day    =   $start;
            if($start <= $end) {
                
                for(;$day <= $end;) {
                
                    $cd =   date("Y-m-d",$day);
                    $days[$cd] = 0;
                    foreach ($e->icon_date as $dateKey=>$di) {
                        if($di['date'] == $cd) {
                            $days[$cd]  =   array('id'=>$e->id,"date"=>$dateKey,'isodate'=>$cd); 
                        }
                    }
                    $day  = strtotime("+1 day",$day);
                    if($day > $end)
                        break;
                    }
            }
            $e->days   =   $days;
            $events[] = $e;
        }
        
       
        return $events;
    }
    
    private function loadUserSchedules($availableUsers)
    {
        /*$statuses = [
            'New',
            'api_suggested',
            
        ];*/
        
        $query = "SELECT * FROM #__com_shifts_reservations WHERE `room_id` IN (".join(",",$availableUsers).") AND `status` = 'New' OR `status` = 'api_suggested'";
        //$this->out($query);
        
        $this->db->setQuery($query);
        $result = $this->db->loadAssocList();
        
        return $result;
    }
 
    private function generateRandomString($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyz';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }  
}

class DateTimeWR extends DateTime {
    
    public function __construct(...$a) {    
        $args=func_get_args();
        $time=  $args[0];
        $object= $args[1];
        
        $time  = str_replace(" :00:00"," 00:00:00", $time);        
        $time  = str_replace(" :00"," 00:00:00", $time);
        try {            
            parent::__construct($time, $object);
        } catch (Exception $e) {            
            //var_dump($time);
            parent::__construct();
        }
    }
    
    public static function createFromFormat(...$a) {       
        $args=func_get_args();
        $format=  $args[0]; 
        $time= $args[1];
        
        $time  = str_replace(" :00:00"," 00:00:00",$time);
        $time  = str_replace(" :00"," 00:00:00",$time);
        try {
            $f  =  DateTime::createFromFormat($format , $time);
        } catch (Exception $e) {
            //var_dump($time);
            $t  =  new DateTime();
            $f =  $t->format($format);
        }
        return $f;
    }
    
    
}
JApplicationCli::getInstance('apiNotificationsCtCli')->execute();
