<?php


// Set flag that this is a parent file.
const _JEXEC = 1;
/*error_reporting(E_ALL | E_NOTICE);
ini_set('display_errors', 1);*/

// Load system defines
if (file_exists(dirname(__DIR__) . '/defines.php')){
    require_once dirname(__DIR__) . '/defines.php';
}
if (!defined('_JDEFINES'))  {
    define('JPATH_BASE', dirname(__DIR__));
    require_once JPATH_BASE . '/includes/defines.php';
}
require_once JPATH_LIBRARIES . '/import.legacy.php';
require_once JPATH_LIBRARIES . '/cms.php';
// Load the configuration
require_once JPATH_CONFIGURATION . '/configuration.php';


class apiNotificationsCli extends JApplicationCli   {
    
    public $syncModel;
    public $db;
    
    public function __construct() {
        parent::__construct();
        
        $this->db = JFactory::getDBO();
        $this->config = JFactory::getConfig();
        
        $this->enable_settings_notifications_tab = $this->config->get('enable_settings_notifications_tab');
        date_default_timezone_set($this->config->get('domain_timezone'));//set correct timezone. it's important!
        
        //$this->dk_api_url = 'https://api.dkplus.is/api/v1/member/1/3';
        //$this->demo_token = '3541031f-baf2-4737-a7e8-c66396e5a5e3';
    }
    
    private function getAllManagers()
    {
        $query = "SELECT `company`, `id`, `username0`, `username`, `name`, `owner_id`, `email`, "
                . "`shifts_send_mobile`, "
                . "`shifts_send_email`, "
                . "`shifts_send_never`, "
                . "`shifts_send_hour_before_start`, "
                . "`shifts_send_if_forgot_click`, "
                . "`shifts_send_if_forgot_to_clock`, "
                . "`shifts_send_if_empl_hasnt_clocked`"
                . "FROM #__users ORDER BY `id` ASC";
        
        $this->db->setQuery($query);
        return $this->db->loadAssocList();
    }
    
    private function superUnique($array, $key)
    {
        $temp_array = [];
        foreach ($array as &$v) {
            if (!isset($temp_array[$v[$key]]))
                $temp_array[$v[$key]] =& $v;
        }
        $array = array_values($temp_array);
        return $array;
    }
    
    public function doExecute() {
        if($this->enable_settings_notifications_tab == '1'){
            $this->out('Start working...');
  
            $all_managers = $this->getAllManagers();
            $prepared_manager_list = $this->superUnique($all_managers, 'company');
            
            
            foreach($prepared_manager_list as $one_company){

                if($one_company['shifts_send_never'] == 0){ 
                    $res = $this->storeNotificationsForChangesInSchedules($one_company);
                    $this->out(print_r($res, true));
                }
            }
           

            $this->out('Stop working...');
        } else{
            $this->out('Enable $enable_settings_notifications_tab in /configuration.php for working this script!');
        }
    }  
    
    private function loadUserSchedulesNotificationsForEmail($user_id)
    {
        $query = "SELECT * FROM  #__app_api_messages WHERE `user_id` ='".(int)$user_id."' AND `email_status` = '0' AND `message_type` = 'shifts_changes' AND `about_changes`='0'";
        $this->db->setQuery($query);
        $res = $this->db->loadObjectList();
        
        return $res;
    }
    
    private function sendEmailNotifications($users, $one_company_array)
    {
        $manager = & JFactory::getUser($one_company_array['owner_id']);
        $this->out(print_r($users, true));
        
      
        
        $config = $this->config;

        $sender = [
            $config->get('mailfrom'), 
            $config->get('fromname')
        ];
        
        foreach ($users as $one_company_user) {
            $user_sended = & JFactory::getUser($one_company_user);
            $email = $user_sended->email;
            $subject = 'You have changes on your schedules';
            
            $final_username = '';
            if (!empty($user_sended->username0)) {
                $final_username = $user_sended->username0;
            } elseif (!empty($user_sended->username)) {
                $final_username = $user_sended->username;
            } elseif (!empty($user_sended->name)) {
                $final_username = $user_sended->name;
            }
            $added_user_name = $final_username;
            
            $one_user_schedules_notifications = $this->loadUserSchedulesNotificationsForEmail($one_company_user);
            
            $this->out('$one_user_schedules_notifications:');
            $this->out(print_r($one_user_schedules_notifications, true));
            
            if(!empty($one_user_schedules_notifications) && !empty($email)){
                $message = '';
                $message .= '<p>Dear <strong>'. $added_user_name.',</strong></p>'.PHP_EOL;
                
                foreach($one_user_schedules_notifications as $one_notification){
                    $message .= '<p>'.$one_notification->text_en.'</p>'.PHP_EOL;
                }
                $this->out(print_r($message, true));
           

                $mailer = JFactory::getMailer();
                $mailer->setSender($sender);
                $mailer->addRecipient($email, $added_user_name);
                $mailer->addBcc('developer3452@gmail.com', 'developer3452');




                $mailer->setSubject($subject);
                $mailer->isHTML(TRUE);
                $mailer->setBody($message); 
                
                if($mailer->send()){
                    $this->updateEmailStatusInDb($one_user_schedules_notifications);
                }
            }
           
        }
    }
    
    private function updateEmailStatusInDb($user_notifications_obj)
    {
        foreach($user_notifications_obj as $one_notification){
            $query = "UPDATE  #__app_api_messages SET `email_status` = '1' WHERE `id` = '".$one_notification->id."' AND `message_type` = 'shifts_changes'";
            $this->db->setQuery($query);
            $this->db->query();
        }
    }
    
    private function loadRooms($manager_obj)
    {
        $department_obj = $_REQUEST['dep'];
        $department_arr = isset($department_obj) ? $department_obj : '';
        
        $owner_id = $manager_obj->owner_id;
      
       
        $visible_manager = false;
        if(in_array(6, $manager_obj->groups)){
            if($visible_manager == true){
                $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0' ORDER BY `username0` ASC";
            } else{
                $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0' AND `id` != '".$owner_id."' ORDER BY `username0` ASC";
            }
            
            $this->db->setQuery($query);
            $rooms = $this->db->loadAssocList();
        } 
        
        
        $result = array();

        foreach ($rooms as $room) {
            if (!empty($department_arr) && !in_array($room['group_user'], $department_arr)){
                continue;
            }

            $r = new stdClass();
            $r->id = $room['id'];
            
            if(!empty($room['username0'])){ $final_username = $room['username0']; } 
            elseif(!empty($room['username'])){ $final_username = $room['username']; }
            elseif(!empty($room['name'])){ $final_username = $room['name']; }
            
            $r->name = $final_username;
            $r->capacity = 1;
            $r->status = 2;
            $result[] = $r;
        }
      

        return $result;

    }
    
    private function storeNotificationsForChangesInSchedules($one_company_array)
    {
        $availableUsers  =  array(-1);
        $manager = & JFactory::getUser($one_company_array['owner_id']);
        
        $rms  = $this->loadRooms($manager);
        if(!empty($rms)) {
            foreach ($rms as $r) {
                $availableUsers[] = intval($r->id);
            }
        }
        
        //save notifications for app
        if($one_company_array['shifts_send_mobile'] == 1){
            $this->out('Send notifications for company with enabled "Send to mobile" checkbox:');
            $this->out(print_r($one_company_array, true));
                        
            $query = "UPDATE #__app_api_messages SET `status` = '1' WHERE `user_id` in (".join(",", $availableUsers).") AND `is_read` = '0' AND `status` = '0' AND `message_type` = 'shifts_changes' AND `about_changes` = '0'";
            $this->db->setQuery($query);
            $this->db->query();
        }
        
        //send notifications with emails
        if($one_company_array['shifts_send_email'] == 1){
            $this->out('Send notifications for company with enabled "Send as e-mail" checkbox:');
            $this->out(print_r($one_company_array, true));
                        
            $res = $this->sendEmailNotifications($availableUsers, $one_company_array);
            $this->out(print_r($res, true));
        }
        
        //send notifications before 1 hour schedule start
        if($one_company_array['shifts_send_hour_before_start'] == 1){
            $this->out('Send notifications for company with enabled "Send hour before shift start" checkbox:');
            $this->out(print_r($one_company_array, true));
            date_default_timezone_set($this->config->get('domain_timezone'));
            $res = $this->sendNotificationsHourBeforeStart($availableUsers, $one_company_array);
        }
        
        //send notifications if the user forgot to press the start button and his change has already begun
        if($one_company_array['shifts_send_if_forgot_click'] == 1){
            $this->out('Send notifications for company with enabled "Forgot to click in when shift start" checkbox:');
            $this->out(print_r($one_company_array, true));
            
            $res = $this->sendNotificationsForgotToClickWhenShiftStart($availableUsers, $one_company_array);
        }
        
         //send notifications if the user forgot to press the stop button after schedule is ended
        if($one_company_array['shifts_send_if_forgot_to_clock'] == 1){
            $this->out('Send notifications for company with enabled "Forgot to clock out when shift ended" checkbox:');
            $this->out(print_r($one_company_array, true));
            
            $res = $this->sendNotificationsForgotToClickWhenShiftEnded($availableUsers, $one_company_array);
        }
        
        //send notifications if the user forgot to press the start button and his change has already begun
        if($one_company_array['shifts_send_if_empl_hasnt_clocked'] == 1){
            $this->out('Send notifications for company with enabled "Employee hasn´t clocked in after shift has started - Send Manager":');
            $this->out(print_r($one_company_array, true));
            
            $res = $this->sendNotificationsForgotToClickWhenShiftToManagerStart($availableUsers, $one_company_array);
        }
    }
    
    private function sendNotificationsForgotToClickWhenShiftEnded($availableUsers, $one_company_array)
    {
       //load company schedules
        $all_company_schedules = $this->loadUserSchedules($availableUsers);
        $filtered_schedules = [];
        $all_company_timesheets = $this->loadCompanyTimescheets($availableUsers);
        
        $filtered_timesheets = [];
        
        //group schedules by user
        foreach($all_company_schedules as $k => $v){
            $filtered_schedules[$v['room_id']][] = $v; 
        }
        
        //group timesheets by user
        foreach($all_company_timesheets as $k => $v){
            $filtered_timesheets[$v->id_user][] = $v;
        }
        
        foreach ($availableUsers as $one_company_user) {
            $user_sended = & JFactory::getUser($one_company_user);
            
            /*if($user_sended->id != 3869){
                continue;
            }*/
            //exit;
            //$this->out('save from')->out(print_r($user_sended, true));
            
            $final_username = '';
            if (!empty($user_sended->username0)) {
                $final_username = $user_sended->username0;
            } elseif (!empty($user_sended->username)) {
                $final_username = $user_sended->username;
            } elseif (!empty($user_sended->name)) {
                $final_username = $user_sended->name;
            }
            
            $added_user_name = $final_username;
            $user_schedules =  $filtered_schedules[$user_sended->id];//shifts
            $user_timesheets = $filtered_timesheets[$user_sended->id];//current date only
            //$this->out(print_r($user_timesheets,true));
            
            
            // only 1 schedule for 1 day is possible. only for multi dates schedules
            $schedule_today = reset(array_filter($user_schedules, function ($var) {
                $period = new DatePeriod(
                    new DateTime(DateTime::createFromFormat('Y-m-d H:i:s', $var['start'])->format('Y-m-d H:i:s')),
                    new DateInterval('P1D'),
                    new DateTime(DateTime::createFromFormat('Y-m-d H:i:s', $var['end'])->format('Y-m-d H:i:s'))
                );
                
                $normal_array_of_dates0 = [];
                $iab = 0;
                    
                    
                foreach ($period as $key => $value) {
                    $normal_array_of_dates0[$value->format('d.m.Y')]['with_seconds'] = $value->format('d.m.Y H:i:s');
                    $normal_array_of_dates0[$value->format('d.m.Y')]['date'] = $value->format('d.m.Y');
                    $normal_array_of_dates0[$value->format('d.m.Y')]['unix'] = $value->format('U');
                        
                    $iab++;
                }
                    
                $this->out('period obj:')->out(print_r($normal_array_of_dates0, true));
                
                return (strtotime(trim($var['start'])) <= strtotime('today') && strtotime(trim($var['end'])) >= strtotime('today') || (strtotime(trim($var['start'])) >= strtotime('today') && strtotime(trim($var['end'])) >= strtotime('today') && in_array(date('d.m.Y'), array_column($normal_array_of_dates0, 'date'))));
            }));
            
            //$this->out('$schedule_today')->out(var_dump($schedule_today));
            
            // if there is no schdule just exit the funtion, no need to notify the user
            if(empty($schedule_today)){
                continue; 
            }
            
            //$schedule_today_start_unix = strtotime($schedule_today['start']);
            //$schedule_today_end_unix = strtotime($schedule_today['end']);
           
            $schedule_today_date_arr = explode(' ', $schedule_today['start']);
            $schedule_today_end_date_arr = explode(' ', $schedule_today['end']);
            
            if(count($schedule_today_date_arr) === 2){
                $schedule_today_start_unix_obj  = DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d') . $schedule_today_date_arr[1]);
                $schedule_today_start_unix = $schedule_today_start_unix_obj->format('U');
            } if(count($schedule_today_end_date_arr) === 2){
                $schedule_today_end_unix_obj  = DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d') . $schedule_today_end_date_arr[1]);
                $schedule_today_end_unix = $schedule_today_end_unix_obj->format('U');
            }
            //$this->out('today datetime is')->out(date('d.m.Y H:i:s', strtotime('today')));
            //$this->out(print_r($schedule_today_end_unix, true));
            //exit;
            $time_now_unix = strtotime('now');
            
            //$this->out('point');
            $this->out('now')->out(date('d.m.Y H:i:s', $time_now_unix));
            $this->out(date('d.m.Y H:i:s', $schedule_today_start_unix));
            $this->out(date('d.m.Y H:i:s', $schedule_today_end_unix));
            
            // if current time inside the shift ? otherwise skip iteration (user)
            if($time_now_unix >= $schedule_today_end_unix /*$time_now_unix >= $schedule_today_start_unix && $time_now_unix <= $schedule_today_end_unix /*|| $schedule_today_start_unix >= strtotime('today') && $schedule_today_end_unix >= strtotime('today')*/){
                $this->out('pp');
                // do user have started time ?
                $timesheets_started = reset(array_filter($user_timesheets, function ($var) {
                    return ($var->date_exit == '0000-00-00 00:00:00' /*&& $schedule_today_end_unix  < strtotime($var->date_exit)*/);
                }));
                
                //$this->out(' $timesheets_started')->out(var_dump( $timesheets_started));
                
                
                if (count($user_timesheets) > 0) {
                    //point 
                    $last_timesheet_row_on_current_date = $user_timesheets[count($user_timesheets) - 1];
                    //$this->out(print_r($last_timesheet_row_on_current_date, true));

                    $last_timesheet_end_row = $last_timesheet_row_on_current_date->date_exit;

                    if ($last_timesheet_end_row != '0000-00-00 00:00:00') {
                        $last_timesheet_end_row_date_obj = DateTime::createFromFormat('Y-m-d H:i:s', $last_timesheet_end_row);
                        $last_timesheet_end_unix = $last_timesheet_end_row_date_obj->format('U');
                    }
                } else{
                    continue;
                }
             
                $this->out(print_r($last_timesheet_row_on_current_date, true));
               
                //if(!empty($user_timesheets) && $timesheets_started && (isset($schedule_today_start_unix) && $last_timesheet_end_unix > $schedule_today_start_unix + 300)){
                    if($last_timesheet_end_row === '0000-00-00 00:00:00'){
                      
                        $check_sended = $this->checkSendedAboutStop($schedule_today['id'], $user_sended->id);
                    
                        
                        if($check_sended === 0){
                            $this->out('send notifications');
                            
                            $this->addNotificationAboutForgotStop($schedule_today, $schedule_today_start_unix, $schedule_today_end_unix, $last_timesheet_row_on_current_date);
                        }
                    
                } else {
                    $this->out('dont send notifications');
                }      
            }
        }
        
    }
    
    private function checkSendedAboutStop($shift_id, $user_id)
    {
        $query = "SELECT `id`, `forgot_click_stop` FROM #__app_api_messages WHERE `shift_id` ='".(int)$shift_id."' AND `user_id` = '$user_id' AND `timestamp` >= '". strtotime('today')."' AND `forgot_click_stop`='1' AND `about_changes`='0'";
        $this->db->setQuery($query);
        $result = $this->db->loadObjectList();
        
        $this->out('checkSendedAboutStop():')->out(print_r($result, true))->out('count:')->out(count($result));
        if(count($result) > 0){
            $res = 1;
        } else{
            $res = 0;
        }
        
        return $res;
    }
    
    private function addNotificationAboutForgotStop($one_schedule, $schedule_start_unix, $schedule_end_unix, $one_timesheet_row)
    {
        $item = new stdClass();
        
        $text_en = 'Your shift has ended and you can clock out from work. You schedule is ' . date('d.m.Y H:i:s', $schedule_start_unix) . ' - ' . date('d.m.Y H:i:s', $schedule_end_unix);
        $text_is = 'Vakt þín er lokið og þú getur stimplað þig út. Þú áætlun er ' .  date('d.m.Y H:i:s', $schedule_start_unix) . ' - ' . date('d.m.Y H:i:s', $schedule_end_unix);
        
        $item->id = null;
        $item->user_id = (int) $one_schedule['room_id'];
        $item->text_en = strip_tags($this->db->escape($text_en));
        $item->text_is = strip_tags($this->db->escape($text_is));
        $item->is_read = 0;//not read
        $item->timestamp = time();
        $item->date_create = date('d.m.y H:i:s');
        $item->shift_id = (int) $one_schedule['id'];
        $item->status = 1;//send to app
        $item->message_type = 'shifts_changes';
        $item->forgot_click_status = 0;
        $item->forgot_click_stop = 1;
        $item->subject_en = $this->db->escape('Your schedule has ended');
        $item->subject_is = $this->db->escape('Your schedule has ended');
        $item->about_changes = 0;
        
        $this->db->insertObject('#__app_api_messages', $item);
    }
    
    private function sendNotificationsForgotToClickWhenShiftToManagerStart($availableUsers, $one_company_array)
    {
        //load company schedules
        $all_company_schedules = $this->loadUserSchedules($availableUsers);
        $filtered_schedules = [];
        $all_company_timesheets = $this->loadCompanyTimescheets($availableUsers);
        
        $filtered_timesheets = [];
        
        //group schedules by user
        foreach($all_company_schedules as $k => $v){
            $filtered_schedules[$v['room_id']][] = $v; 
        }
        
        //group timesheets by user
        foreach($all_company_timesheets as $k => $v){
            $filtered_timesheets[$v->id_user][] = $v;
        }
        
        foreach ($availableUsers as $one_company_user) {
            $user_sended = & JFactory::getUser($one_company_user);
            
            /*if($user_sended->id != 2867){
                continue;
            }*/
            //exit;
            
            $final_username = '';
            if (!empty($user_sended->username0)) {
                $final_username = $user_sended->username0;
            } elseif (!empty($user_sended->username)) {
                $final_username = $user_sended->username;
            } elseif (!empty($user_sended->name)) {
                $final_username = $user_sended->name;
            }
            
            $added_user_name = $final_username;
            $user_schedules =  $filtered_schedules[$user_sended->id];//shifts
            $user_timesheets = $filtered_timesheets[$user_sended->id];//current date only
            
            
            
            // only 1 schedule for 1 day is possible. only for multi dates schedules
            $schedule_today = reset(array_filter($user_schedules, function ($var) {
                //$schedule_today_date_arr = explode(' ', $var['start']);
                //$schedule_today_end_date_arr = explode(' ', $var['end']);
                $period = new DatePeriod(
                    new DateTime(DateTime::createFromFormat('Y-m-d H:i:s', $var['start'])->format('Y-m-d H:i:s')),
                    new DateInterval('P1D'),
                    new DateTime(DateTime::createFromFormat('Y-m-d H:i:s', $var['end'])->format('Y-m-d H:i:s'))
                );
                
                $normal_array_of_dates0 = [];
                $iab = 0;
                    
                    
                foreach ($period as $key => $value) {
                    $normal_array_of_dates0[$value->format('d.m.Y')]['with_seconds'] = $value->format('d.m.Y H:i:s');
                    $normal_array_of_dates0[$value->format('d.m.Y')]['date'] = $value->format('d.m.Y');
                    $normal_array_of_dates0[$value->format('d.m.Y')]['unix'] = $value->format('U');
                        
                    $iab++;
                }
                    
                $this->out('period obj:')->out(print_r($normal_array_of_dates0, true));
                
                return (strtotime(trim($var['start'])) <= strtotime('today') && strtotime(trim($var['end'])) >= strtotime('today') || (strtotime(trim($var['start'])) >= strtotime('today') && strtotime(trim($var['end'])) >= strtotime('today') && in_array(date('d.m.Y'), array_column($normal_array_of_dates0, 'date'))));
            }));
            
            //$this->out('$schedule_today')->out(var_dump($schedule_today));
            
            // if there is no schdule just exit the funtion, no need to notify the user
            if(empty($schedule_today)){
                continue;
            }
            
            //$schedule_today_start_unix = strtotime($schedule_today['start']);
            //$schedule_today_end_unix = strtotime($schedule_today['end']);
           
            $schedule_today_date_arr = explode(' ', $schedule_today['start']);
            $schedule_today_end_date_arr = explode(' ', $schedule_today['end']);
            
            if(count($schedule_today_date_arr) === 2){
                $schedule_today_start_unix_obj  = DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d') . $schedule_today_date_arr[1]);
                $schedule_today_start_unix = $schedule_today_start_unix_obj->format('U');
            } if(count($schedule_today_end_date_arr) === 2){
                $schedule_today_end_unix_obj  = DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d') . $schedule_today_end_date_arr[1]);
                $schedule_today_end_unix = $schedule_today_end_unix_obj->format('U');
            }
            $this->out('today datetime is')->out(date('d.m.Y H:i:s', strtotime('today')));
            //$this->out(print_r($schedule_today_end_unix, true));
            //exit;
            $time_now_unix = strtotime('now');
            
            $this->out('point');
            $this->out('now')->out(date('d.m.Y H:i:s', $time_now_unix));
            $this->out(date('d.m.Y H:i:s', $schedule_today_start_unix));
            $this->out(date('d.m.Y H:i:s', $schedule_today_end_unix));
            
            // if current time inside the shift ? otherwise skip iteration (user)
            if($time_now_unix >= $schedule_today_start_unix && $time_now_unix <= $schedule_today_end_unix /*|| $schedule_today_start_unix >= strtotime('today') && $schedule_today_end_unix >= strtotime('today')*/){
                $this->out('pp');
                // do user have started time ?
                $timesheets_started = reset(array_filter($user_timesheets, function ($var) {
                    return ($var->date_exit == '0000-00-00 00:00:00' /*&& $schedule_today_end_unix  < strtotime($var->date_exit)*/);
                }));
                
                //$this->out(' $timesheets_started')->out(var_dump( $timesheets_started));
                
                
                if (count($user_timesheets) > 0) {
                    //point 
                    $last_timesheet_row_on_current_date = $user_timesheets[count($user_timesheets) - 1];
                    //$this->out(print_r($last_timesheet_row_on_current_date, true));

                    $last_timesheet_end_row = $last_timesheet_row_on_current_date->date_exit;

                    if ($last_timesheet_end_row != '0000-00-00 00:00:00') {
                        $last_timesheet_end_row_date_obj = DateTime::createFromFormat('Y-m-d H:i:s', $last_timesheet_end_row);
                        $last_timesheet_end_unix = $last_timesheet_end_row_date_obj->format('U');
                    }
                }

                //$this->out('last row:')->out(print_r($last_timesheet_row_on_current_date), true);
            
                // if timesheet is empty OR user don't work now send user notification
                if(empty($user_timesheets) || !$timesheets_started && (isset($schedule_today_start_unix) && $last_timesheet_end_unix < $schedule_today_start_unix)){
                    $check_sended = $this->checkSendedEmail($schedule_today['id'], $user_sended->id);
                    
                    if($check_sended === 0){
                        $this->out('send mail to manager');
                        $this->sendNotificationToManagerAboutUserForgotStart($one_company_user, $one_company_array, $schedule_today);
                    }
                    
                } else {
                    $this->out('dont send email');
                }      
            }
        }
    }
    
    private function sendNotificationToManagerAboutUserForgotStart($one_company_user, $one_company_array, $schedule)
    {
        $manager = & JFactory::getUser($one_company_array['owner_id']);
        $this->out(print_r($one_company_user, true));
        
        $manager_name = '';
        if (!empty($manager->username0)) {
            $manager_name = $manager->username0;
        } elseif (!empty($manager->username)) {
            $manager_name = $manager->username;
        } elseif (!empty($manager->name)) {
            $manager_name = $manager->name;
        }
        $this->out('send mail to '.$manager_name);
        
        $config = $this->config;

        $sender = [
            $config->get('mailfrom'), 
            $config->get('fromname')
        ];
        
        $user_sended = & JFactory::getUser($one_company_user);
        $email = $manager->email;
        
            
        $final_username = '';
        if (!empty($user_sended->username0)) {
            $final_username = $user_sended->username0;
        } elseif (!empty($user_sended->username)) {
            $final_username = $user_sended->username;
        } elseif (!empty($user_sended->name)) {
            $final_username = $user_sended->name;
        }
        
        $added_user_name = $final_username;

        if(!empty($email)){
            $subject = 'Your employee '.$added_user_name.' did not show up for work shift';  
            $message = '';
                
            $message .= '<p>Dear <strong>'.$manager_name . '</strong>,</p>';
            $message .= '<p><strong>'.$added_user_name.'</strong> did not clock into work according to scheduled time !</p>';
            $message .= '<p>His schedule is: '.$schedule['start'] . '-' . $schedule['end'] . '</p>';

            $mailer = JFactory::getMailer();
            $mailer->setSender($sender);
            $mailer->addRecipient($email, $manager_name);
            $mailer->addBcc('developer3452@gmail.com', 'developer3452');

            $mailer->setSubject($subject);
            $mailer->isHTML(TRUE);
            $mailer->setBody($message); 
                
            if($mailer->send()){
                $this->updateEmailStatusNotificationToManagerAboutUserForgotStart($schedule);
            }
        }
    }
    
    private function updateEmailStatusNotificationToManagerAboutUserForgotStart($schedule)
    {
        $query = "UPDATE  #__app_api_messages SET `forgot_click_status_email` = '1' WHERE `shift_id` = '".$schedule['id']."' AND `message_type` = 'shifts_changes'  AND `about_changes`='0'";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    private function loadCompanyTimescheets($users)
    {
        $query = "SELECT * FROM #__audit_time WHERE `id_user` IN (".join(",",$users).") AND `date` = '" . date('Y-m-d') . "' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $result = $this->db->loadObjectList();
        
        return $result; 
    }
     
    private function sendNotificationsForgotToClickWhenShiftStart($availableUsers, $one_company_array)
    {
        //load company schedules
        $all_company_schedules = $this->loadUserSchedules($availableUsers);
        $filtered_schedules = [];
        $all_company_timesheets = $this->loadCompanyTimescheets($availableUsers);
        
        $filtered_timesheets = [];
        
        //group schedules by user
        foreach($all_company_schedules as $k => $v){
            $filtered_schedules[$v['room_id']][] = $v; 
        }
        
        //group timesheets by user
        foreach($all_company_timesheets as $k => $v){
            $filtered_timesheets[$v->id_user][] = $v;
        }
        
        foreach ($availableUsers as $one_company_user) {
            $user_sended = & JFactory::getUser($one_company_user);
            
            /*if($user_sended->id != 3869){
                continue;
            }*/
            //exit;
            
            $final_username = '';
            if (!empty($user_sended->username0)) {
                $final_username = $user_sended->username0;
            } elseif (!empty($user_sended->username)) {
                $final_username = $user_sended->username;
            } elseif (!empty($user_sended->name)) {
                $final_username = $user_sended->name;
            }
            
            $added_user_name = $final_username;
            $user_schedules =  $filtered_schedules[$user_sended->id];//shifts
            $user_timesheets = $filtered_timesheets[$user_sended->id];//current date only
            
            
            
            // only 1 schedule for 1 day is possible. only for multi dates schedules
            $schedule_today = reset(array_filter($user_schedules, function ($var) {
                //$schedule_today_date_arr = explode(' ', $var['start']);
                //$schedule_today_end_date_arr = explode(' ', $var['end']);
                
                $period = new DatePeriod(
                    new DateTime(DateTime::createFromFormat('Y-m-d H:i:s', $var['start'])->format('Y-m-d H:i:s')),
                    new DateInterval('P1D'),
                    new DateTime(DateTime::createFromFormat('Y-m-d H:i:s', $var['end'])->format('Y-m-d H:i:s'))
                );
                
                $normal_array_of_dates0 = [];
                $iab = 0;
                    
                    
                foreach ($period as $key => $value) {
                    $normal_array_of_dates0[$value->format('d.m.Y')]['with_seconds'] = $value->format('d.m.Y H:i:s');
                    $normal_array_of_dates0[$value->format('d.m.Y')]['date'] = $value->format('d.m.Y');
                    $normal_array_of_dates0[$value->format('d.m.Y')]['unix'] = $value->format('U');
                        
                    $iab++;
                }
                    
                //$this->out('period obj:')->out(print_r($normal_array_of_dates0, true));
                
                return (strtotime(trim($var['start'])) <= strtotime('today') && strtotime(trim($var['end'])) >= strtotime('today') || (strtotime(trim($var['start'])) >= strtotime('today') && strtotime(trim($var['end'])) >= strtotime('today') && in_array(date('d.m.Y'), array_column($normal_array_of_dates0, 'date'))));
            }));
            
            $this->out('$schedule_today')->out(var_dump($schedule_today));
            
            // if there is no schdule just exit the funtion, no need to notify the user
            if(empty($schedule_today)){
                continue;
            }
            
            //$schedule_today_start_unix = strtotime($schedule_today['start']);
            //$schedule_today_end_unix = strtotime($schedule_today['end']);
           
            $schedule_today_date_arr = explode(' ', $schedule_today['start']);
            $schedule_today_end_date_arr = explode(' ', $schedule_today['end']);
            
            if(count($schedule_today_date_arr) === 2){
                $schedule_today_start_unix_obj  = DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d') . $schedule_today_date_arr[1]);
                $schedule_today_start_unix = $schedule_today_start_unix_obj->format('U');
            } if(count($schedule_today_end_date_arr) === 2){
                $schedule_today_end_unix_obj  = DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d') . $schedule_today_end_date_arr[1]);
                $schedule_today_end_unix = $schedule_today_end_unix_obj->format('U');
            }
            //$this->out('today datetime is')->out(date('d.m.Y H:i:s', strtotime('today')));
            //$this->out(print_r($schedule_today_end_unix, true));
            
            $time_now_unix = strtotime('now');
            
            $this->out('point');
            $this->out('now')->out(date('d.m.Y H:i:s', $time_now_unix));
            $this->out(date('d.m.Y H:i:s', $schedule_today_start_unix));
            $this->out(date('d.m.Y H:i:s', $schedule_today_end_unix));
            
            // if current time inside the shift ? otherwise skip iteration (user)
            if($time_now_unix >= $schedule_today_start_unix && $time_now_unix <= $schedule_today_end_unix /*|| $schedule_today_start_unix >= strtotime('today') && $schedule_today_end_unix >= strtotime('today')*/){
                $this->out('pp');
                // do user have started time ?
                $timesheets_started = reset(array_filter($user_timesheets, function ($var) {
                    return ($var->date_exit == '0000-00-00 00:00:00' /*&& $schedule_today_end_unix  < strtotime($var->date_exit)*/);
                }));
                
                $this->out(' $timesheets_started')->out(var_dump( $timesheets_started));
                 
                 
                if (count($user_timesheets) > 0) {
                    //point 
                    $last_timesheet_row_on_current_date = $user_timesheets[count($user_timesheets) - 1];
                    $this->out(print_r($last_timesheet_row_on_current_date, true));

                    $last_timesheet_end_row = $last_timesheet_row_on_current_date->date_exit;

                    if ($last_timesheet_end_row != '0000-00-00 00:00:00') {
                        $last_timesheet_end_row_date_obj = DateTime::createFromFormat('Y-m-d H:i:s', $last_timesheet_end_row);
                        $last_timesheet_end_unix = $last_timesheet_end_row_date_obj->format('U');
                    }
                }

                //$this->out('last row:')->out(print_r($last_timesheet_row_on_current_date), true);
            
                // if timesheet is empty OR user don't work now send user notification
                if(empty($user_timesheets) || !$timesheets_started && (isset($schedule_today_start_unix) && $last_timesheet_end_unix < $schedule_today_start_unix)){
                    $check_sended = $this->checkSended($schedule_today['id'], $user_sended->id);
                    
                    if($check_sended === 0){
                        $this->out('send 00');
                        $this->addNotificationAboutForgotStart($schedule_today, $schedule_today_start_unix, $schedule_today_end_unix, $last_timesheet_row_on_current_date);
                    }
                    
                } else {
                    $this->out('dont send notifications');
                }      
            }
        }
    }
    
    private function checkSendedEmail($shift_id, $user_id)
    {
        $query = "SELECT `id`, `forgot_click_status_email` FROM #__app_api_messages WHERE `shift_id` ='".(int)$shift_id."' AND `user_id` = '$user_id'  AND `timestamp` >= '". strtotime('today')."' AND `forgot_click_status_email`='1' AND `about_changes`='0'";
        $this->db->setQuery($query);
        $result = $this->db->loadObjectList();
        
        $this->out('checkSendedEmail():')->out(print_r($result, true))->out('count:')->out(count($result));
        if(count($result) > 0){
            $res = 1;
        } else{
            $res = 0;
        }
        
        return $res;
    }
    
    private function checkSended($shift_id, $user_id)
    {
        //here
        $query = "SELECT `id`, `forgot_click_status` FROM #__app_api_messages WHERE `shift_id` ='".(int)$shift_id."' AND `user_id` = '$user_id' AND `timestamp` >= '". strtotime('today')."' AND `forgot_click_status`='1' AND `about_changes`='0'";
        $this->db->setQuery($query);
        $result = $this->db->loadObjectList();
        
        $this->out($query);
        $this->out('checkSended():')->out(print_r($result, true))->out('count:')->out(count($result));
        if(count($result) > 0){
            $res = 1;
        } else{
            $res = 0;
        }
        
        return $res;
    }
    
    private function removeOldMessages(int $schedule_id, string $type)
    {
        switch($type){
            case 'forgot_start':
                $query = "DELETE FROM #__app_api_messages WHERE `shift_id` = '".$schedule_id."' AND `message_type` = 'shifts_changes' AND `forgot_click_status` = '1'";
                $this->db->setQuery($query);
                $this->db->query();
        
                break;
        }
    }
    
    private function addNotificationAboutForgotStart($one_schedule, $schedule_start_unix, $schedule_end_unix, $one_timesheet_row)
    {
        $this->removeOldMessages($one_schedule['id'], 'forgot_start');
        
        
        $item = new stdClass();
        
        //$text_en = 'You have not clocked into work. You schedule is ' . date('d.m.Y H:i:s', $schedule_start_unix) . ' - ' . date('d.m.Y H:i:s', $schedule_end_unix); //print_r($one_timesheet_row, true);
        //$text_is = 'Þú ert ekki ennþá innskráð/ur. Þú áætlun er ' .  date('d.m.Y H:i:s', $schedule_start_unix) . ' - ' . date('d.m.Y H:i:s', $schedule_end_unix); //print_r($one_timesheet_row, true);
        $text_en = date('d.m.Y', $schedule_start_unix) . ': Schedule / start ' . date('H:i', $schedule_start_unix) . ' end: ' . date('H:i', $schedule_end_unix);
        $text_is = date('d.m.Y', $schedule_start_unix) . ': Schedule / start ' . date('H:i', $schedule_start_unix) . ' end: ' . date('H:i', $schedule_end_unix);
        
        $item->id = null;
        $item->user_id = (int) $one_schedule['room_id'];
        $item->text_en = strip_tags($this->db->escape($text_en));
        $item->text_is = strip_tags($this->db->escape($text_is));
        $item->is_read = 0;//not read
        $item->timestamp = time();
        $item->date_create = date('d.m.y H:i:s');
        $item->shift_id = (int) $one_schedule['id'];
        $item->status = 1;//send to app
        $item->message_type = 'shifts_changes';
        $item->forgot_click_status = 1;
        $item->subject_en = $this->db->escape('You have not clocked into work');
        $item->subject_is = $this->db->escape('You have not clocked into work');
        $item->about_changes = 0;
        
        $this->db->insertObject('#__app_api_messages', $item);
    }
    
    private function sendNotificationsHourBeforeStart($availableUsers, $one_company_array)
    {
      
        //$this->out('timezone')->out(date_default_timezone_get());
        //setlocale(LC_TIME, 'ua_UA','ukr');
        
        //load company schedules
        $all_company_schedules = $this->loadUserSchedules($availableUsers);
        $filtered_schedules = [];
        
        //group schedules by user
        foreach($all_company_schedules as $k => $v){
            $filtered_schedules[$v['room_id']][] = $v;
        }

        foreach ($availableUsers as $one_company_user) {
            
            $user_sended = & JFactory::getUser($one_company_user);
            
            /*if($user_sended->id != 2867){
                continue;
            }*/
            
            $final_username = '';
            if (!empty($user_sended->username0)) {
                $final_username = $user_sended->username0;
            } elseif (!empty($user_sended->username)) {
                $final_username = $user_sended->username;
            } elseif (!empty($user_sended->name)) {
                $final_username = $user_sended->name;
            }
            
            //$added_user_name = $final_username;
            $user_schedules =  $filtered_schedules[$user_sended->id];

            $current_time = time();
            $current_time_object = DateTime::createFromFormat('U', $current_time);
            
            
            if(!empty($user_schedules)){
                foreach($user_schedules as $one_schedule){
                    /*if($one_schedule['id'] != 1268){
                        continue;
                    }*/
                    $this->out(print_r($one_schedule, true));
                    
                    $schedule_start_unix = strtotime($one_schedule['start'] . ' '. date_default_timezone_get());
                    $schedule_end_unix = strtotime($one_schedule['end'] . ' ' . date_default_timezone_get());
                    
                    $schedule_start_obj = DateTime::createFromFormat('U', $schedule_start_unix);
                    $schedule_start_obj->setTimeZone(new DateTimeZone(date_default_timezone_get()));
                    
                    $schedule_end_obj = DateTime::createFromFormat('U', $schedule_end_unix);
                    $schedule_end_obj->setTimeZone(new DateTimeZone(date_default_timezone_get()));
                    
                    $this->out('not modifyed')->out($schedule_start_obj->format('Y-m-d H:i:s'));
                    $schedule_start_time = $schedule_start_obj->format('H:i');
                    $schedule_end_time = $schedule_end_obj->format('H:i');
                    
                    $start_minus_hour = $schedule_start_unix - 3600;
                    $start_minus_hour_time_obj = DateTime::createFromFormat('U', $start_minus_hour);
                    $start_minus_hour_time = $start_minus_hour_time_obj->format('H:i');
                    $cloned_start =  clone $schedule_start_obj;
                    
                    //$this->out('modifyed')->out($cloned_start->modify('-1hour')->format('Y-m-d H:i:s'));
                    $this->out('modifyed')->out($cloned_start->format('Y-m-d H:i:s'));
                    
                    $period = new DatePeriod(
                        new DateTime($cloned_start->modify('-1hour')->format('Y-m-d H:i:s')),
                        new DateInterval('P1D'),
                        new DateTime($schedule_end_obj->format('Y-m-d H:i:s'))
                    );
                    
                  
                    $normal_array_of_dates = [];
                    $i = 0; 
                     
                    
                    foreach ($period as $key => $value) {
                        $normal_array_of_dates[$value->format('d.m.Y')]['with_seconds'] = $value->format('d.m.Y H:i:s');
                        $normal_array_of_dates[$value->format('d.m.Y')]['date'] = $value->format('d.m.Y');
                        $normal_array_of_dates[$value->format('d.m.Y')]['unix'] = $value->format('U');
                        
                        $i++;
                    }
                     $this->out(print_r( $normal_array_of_dates, true));
                     
                    if(count(array_column($normal_array_of_dates, 'date')) == 1){
                        //if schedule start on current date
                        if($current_time >= $start_minus_hour && $current_time <= $start_minus_hour + 60){
                            //$this->out('ppa');
                            //add notification to db
                            $res = $this->addNotificationAboutStartUserShedule($one_schedule, $schedule_start_unix, $schedule_end_unix);
                        
                            $this->out(print_r($res, true));
                        }
                    } else{ //if schedule start on not current date
                        if(in_array($current_time_object->format('d.m.Y'), array_column($normal_array_of_dates, 'date')) && ($current_time >= $normal_array_of_dates[$current_time_object->format('d.m.Y')]['unix'] && $current_time <= $normal_array_of_dates[$current_time_object->format('d.m.Y')]['unix'] + 60)){
                            //$this->out('ppb');
                            $res = $this->addNotificationAboutStartUserShedule($one_schedule, $schedule_start_unix, $schedule_end_unix);
                            
                        }
                    }
                }
            }
           
        }
    }
    
    private function addNotificationAboutStartUserShedule($one_schedule_arr, $start_unix, $end_unix)
    {
        $item = new stdClass();
        
        $text_en = 'Your shift ' . date('d.m.Y H:i:s', $start_unix) . ' - ' . date('d.m.Y H:i:s', $end_unix) . ' is starting after one hour';
        $text_is = 'Vinna þín ' . date('d.m.Y H:i:s', $start_unix) . ' - ' . date('d.m.Y H:i:s', $end_unix) . ' hefst eftir eina klst.';
        
        $item->id = null;
        $item->user_id = (int) $one_schedule_arr['room_id'];
        $item->text_en = strip_tags($this->db->escape($text_en));
        $item->text_is = strip_tags($this->db->escape($text_is));
        $item->is_read = 0;//not read
        $item->timestamp = time();
        $item->date_create = date('d.m.y H:i:s');
        $item->shift_id = (int) $one_schedule_arr['id'];
        $item->status = 1;//send to app
        $item->message_type = 'shifts_changes';
        $item->subject_en = $this->db->escape('Your shift is starting after one hour');
        $item->subject_is = $this->db->escape('Your shift is starting after one hour');
        $item->about_changes = 0;
        
        $this->db->insertObject('#__app_api_messages', $item);
    }
    
    private function loadEvents()
    {
        //$start = isset($_POST['start']) ? $_POST['start'] : $_GET['start'];
        //$end = isset($_POST['end']) ? $_POST['end'] : $_GET['end'];
        
        $availableUsers  =  array(-1);
        $rms  = $this->loadRooms();
        if(!empty($rms)) {
            foreach ($rms as $r) {
                $availableUsers[] = intval($r->id);
            }
        }
        
        //$query = "SELECT * FROM #__com_shifts_reservations WHERE room_id in (".join(",",$availableUsers).") AND   NOT ((end <= '".$start."') OR (start >= '".$end."'))";
        $query = "SELECT * FROM #__com_shifts_reservations WHERE room_id in (".join(",",$availableUsers).")";
        $this->db->setQuery($query);
        $result = $this->db->loadAssocList();
        
        $events = array();

        date_default_timezone_set("UTC");
        $now = new DateTime("now");
        $today = $now->setTime(0, 0, 0);
        
        foreach($result as $row) {
            $e = new stdClass();
            $e->id = $row['id'];
            //$e->text = $row['name'];
            $e->text = '';
            $e->start = $row['start'];
            $e->end= $row['end'];
            $e->resource = $row['room_id'];
            $e->bubbleHtml = '';//"Reservation details: <br/>".$e->text;
    
            // additional properties
            $e->status = $row['status'];
            $e->paid = $row['paid'];
            $e->shift_color = $row['shift_color'];
            $e->shift_name = $row['shift_name'];
            $e->shift_message = $row['shift_message'];
            $e->icon_date   = json_decode($row['icon_date'],true);
            $e->tasks_ids = $row['tasks_ids'];
            $e->standart_tasks_ids = $row['standart_tasks_ids'];
            
            if(empty($e->icon_date))
                $e->icon_date  =  array();
            
            $days  = array();
            $start  =   strtotime(date("Y-m-d 00:00:00", strtotime($e->start)));
            $end    =   strtotime(date("Y-m-d 00:00:00", strtotime($e->end)));
            $day    =   $start;
            if($start <= $end) {
                
                for(;$day <= $end;) {
                
                    $cd =   date("Y-m-d",$day);
                    $days[$cd] = 0;
                    foreach ($e->icon_date as $dateKey=>$di) {
                        if($di['date'] == $cd) {
                            $days[$cd]  =   array('id'=>$e->id,"date"=>$dateKey,'isodate'=>$cd); 
                        }
                    }
                    $day  = strtotime("+1 day",$day);
                    if($day > $end)
                        break;
                    }
            }
            $e->days   =   $days;
            $events[] = $e;
        }
        
       
        return $events;
    }
    
    private function loadUserSchedules($availableUsers)
    {
        /*$statuses = [
            'New',
            'api_suggested',
            
        ];*/
        
        $query = "SELECT * FROM #__com_shifts_reservations WHERE `room_id` IN (".join(",",$availableUsers).") AND `status` = 'New' OR `status` = 'api_suggested'";
        //$this->out($query);
        
        $this->db->setQuery($query);
        $result = $this->db->loadAssocList();
        
        return $result;
    }
 
    private function generateRandomString($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyz';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }  
}
JApplicationCli::getInstance('apiNotificationsCli')->execute();
