<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Initialize Joomla framework
const _JEXEC = 1;

// Load system defines
if (file_exists(dirname(__DIR__) . '/defines.php')) {
    require_once dirname(__DIR__) . '/defines.php';
}

if (!defined('_JDEFINES')) {
    $document_root=dirname(__FILE__);
    $server_name=explode('/', $document_root)[3];
    
    define('JPATH_BASE', $document_root);
    require_once JPATH_BASE . '/includes/defines.php';
}

// Get the framework.
require_once JPATH_LIBRARIES . '/import.legacy.php';

// Bootstrap the CMS libraries.
require_once JPATH_LIBRARIES . '/cms.php';

// Load the configuration
require_once JPATH_CONFIGURATION . '/configuration.php';

require_once JPATH_BASE . '/includes/framework.php';

//jimport('joomla.application.component.controller');
$mainframe = & JFactory::getApplication('site');


/**
 * Cron job 
 *
 */
class myCron extends JApplicationCli {
     public function __construct() {
       
        $this->db = &JFactory::getDBO();
        $this->app = JFactory::getApplication();
        $this->doc = JFactory::getDocument();
        $this->server_path = JPATH_BASE;
        $this->user = & JFactory::getUser();
        $this->lang = & JFactory::getLanguage();
       
        //parent::__construct($config);
    }
    

    /**
     * Entry point for the script
     *
     * @return  void
     *
     * @since   2.5
     */
    public function doExecute() {

        // YOUR CODE HERE    
        echo "CRON TASK START ";
        echo "\n"; // Use \n is you are executing the cron from the terminal.
        
        $this->compareAndSetTrueColors();
       
        
        //file_put_contents(JPATH_BASE . '/logs/cleaning_cron.html', print_r('cron start success', true), FILE_APPEND | LOCK_EX);
        
        echo "CRON TASK END ";
        echo "\n";
    }
    
    private function compareAndSetTrueColors() {
        $query = "SELECT `id`, `status_user` FROM #__users";     
        $this->db->setQuery($query);
        $all_users=$this->db->loadObjectList();
        
        
        foreach($all_users as $one_user) {
            $mode='real';//test or real
            
            if($mode==='test'){
                $query = "SELECT * FROM #__user_report_items WHERE `id_user`='".$one_user->id."' AND `year`='2019' AND `month`='7' AND `day`='24'";     
            } elseif($mode==='real'){
                $query = "SELECT * FROM #__user_report_items WHERE `id_user`='".$one_user->id."' AND `year`='".date('Y')."' AND `month`='".date('n')."' AND `day`='".date('d')."'";
            }
           
            $this->db->setQuery($query);
            $calendar_color_item=$this->db->loadObject();
           /* echo '<pre>';
            print_r($calendar_color_item);
            echo '</pre>';*/
            //if day in calendar==user status color-continue
            if($one_user->status_user==$calendar_color_item->status){
               
            } else{
                if(!empty($calendar_color_item->status)){
                    //if day in calendar have different color user status color
                    $query = "UPDATE #__users SET `status_user`='".$calendar_color_item->status."' WHERE `id`='".$one_user->id."'";       
                } else{
                    //if day not have color in calendar-set transparent status in user
                    $query = "UPDATE #__users SET `status_user`='' WHERE `id`='".$one_user->id."'";       
                }
                
                $this->db->setQuery($query);
                $this->db->query();
                
                //$this->addLogRow($one_user->id, $one_user->status_user, $calendar_color_item->status);
            }
        }
        //file_put_contents(JPATH_BASE . '/logs/cleaning_cron.html', print_r($all_users, true), FILE_APPEND | LOCK_EX);
    }
    
    private function addLogRow($user_id, $old_status, $new_status) {
        $item = new stdClass();
        $item->id =null;
        $item->user_id = $user_id;
        $item->date=date('d.m.Y H:i:s');
        $item->unix_timestamp=time();
        $item->old_color=$old_status;
        $item->new_color=$new_status;
        $this->db->insertObject('#__cron_user_status_log', $item);
    }

}

JApplicationCli::getInstance('myCron')->execute();
