'use strict';

(function (global) {
    'use strict';

    var notInBrowser = !global.HTMLElement || !HTMLElement.prototype;
    var alreadyDefined = ('hidden' in HTMLElement.prototype);
    var notPossibleToImplement = typeof Object.defineProperty === 'undefined';

    if (notInBrowser || alreadyDefined || notPossibleToImplement) {
        return;
    }

    Object.defineProperty(HTMLElement.prototype, 'hidden', {
        get: function () {
            return this.hasAttribute('hidden');
        },
        set: function (value) {
            if (value) {
                this.setAttribute('hidden', '');
            } else {
                this.removeAttribute('hidden');
            }

            return value;
        }
    });
})(typeof window === 'undefined' ? this : window);

jQuery(document).ready(function ($) {
    let 
        js = $,
        
        work_type_json_input = js('.js_event_work_type_json').val(),
        work_type_json1 = JSON.parse(work_type_json_input),
        work_type_select = js('.js_event_work_type'),
        
        job_description_gov_input = js('.js_event_job_description_gov_json').val(),
        job_description_gov_json = JSON.parse(job_description_gov_input),
        
        job_description_municipality_input = js('.js_event_job_description_municipality_json').text(),
        job_description_municipality_json = JSON.parse(job_description_municipality_input),
        
        job_description_municipality_input1 = js('.js_event_job_description_municipality_json1').text(),
        job_description_municipality_json1 = JSON.parse(job_description_municipality_input1),
        
        job_description_rey_city_input = js('.js_event_job_description_rey_city_json').text(),
        job_description_rey_city_json = JSON.parse(job_description_rey_city_input),
        
        job_description_general_labour_market_input = js('.js_event_job_description_general_labour_market_json').text(),
        job_description_general_labour_market_json = JSON.parse(job_description_general_labour_market_input),
        
        select_job_description = js('.js_event_job_description'),
        
        gov_expirence_json_input = js('.js_event_gov_expirence_json').text(),
        gov_expirence_json = JSON.parse(gov_expirence_json_input),
        
        municipal_expirence_input = js('.js_event_municipal_expirence_json').text(),
        municipal_expirence_json = JSON.parse(municipal_expirence_input),
        
        rey_city_expirence_input = js('.js_event_rey_city_expirence_json').text(),
        rey_city_expirence_json = JSON.parse(rey_city_expirence_input),
        
        general_labour_market_expirence_input = js('.js_event_general_labour_market_expirence_json').text(),
        general_labour_market_expirence_json = JSON.parse(general_labour_market_expirence_input),
        
        last_selelect_calc_type_input = js('.js_event_last_selelect_calc_type_json').text(),
        last_selelect_calc_type_json = JSON.parse(last_selelect_calc_type_input),
        
        widget_lang = js('.widget-lang').val().trim(),
        translates_input = js('.translates_input').text().trim(),
        translates_json = JSON.parse(translates_input)
    ; 
    
    js('.js_event_widget_close').on('click', function(){
                        
        try{
            js('.js_event_iframe_trigger', parent.document).trigger('click');
        } catch(e){
            console.log(e.message);
            
            window.parent.postMessage('need_close_iframe', '*');
        }
    });


    js('.js_event_union').on('change', function(){
        let 
            this0 = js(this),
            selected_union_val = this0.find('option:selected').val(),
            text = this0.find('option:selected').text(),
            custom_select = js('#union_custom_select');
        
        if(selected_union_val != '-1'){
            js('.js_event_toggle_block-0').removeClass('d-none');
            normalizeWorkType(selected_union_val);
            normalizeCustomSelectWorkType(selected_union_val);
            addChatMessageAfterCustomSelect(text, custom_select);
            scrollToBlock('union_custom_select'); 
        } else{ 
            js('.js_event_toggle_block-0').addClass('d-none');
        }
        js('.js_event_work_type').trigger('change');//?not sure
    });
    
    js('.js_event_work_type').on('change', function(){
        js('.js_event_toggle_block-1, .js_event_toggle_block-4, .js_event_toggle_block-2, .js_event_toggle_block-5, .js_event_toggle_block-6, .js_event_link_block_visible').addClass('d-none');
        
        let 
            this0 = js(this),
            selected_work_val = this0.find('option:selected').val(),
            text = this0.find('option:selected').text(),
            custom_select = js('#work_type_custom_select');
            
        if(selected_work_val != '-1'){
            if(selected_work_val == '4'){
                console.log('rio tinto show get link button...');
                js('.js_event_toggle_block-6').removeClass('d-none');
                
            } else{
                loadJobTypeSelect(selected_work_val);
                loadJobTypeCustomSelect(selected_work_val);
                js('.js_event_expirence_load').empty();
                //addChatMessage(text, this0);
                addChatMessageAfterCustomSelect(text, custom_select);
                
            }
        } 
    });
    
    js('.js_event_job_description').on('change', function(){
        let 
            this0 = js(this),
            text = this0.find('option:selected').text(),
            custom_select = js('#job_descr_custom_select');
            
        js('.js_event_toggle_block-2').addClass('d-none');
        if(js('.js_event_work_type option:selected').val() == '2'){
            js('.js_event_toggle_block-2').removeClass('d-none');
            //addChatMessage(text, this0);
            addChatMessageAfterCustomSelect(text, custom_select);
        } else{
            loadExpirenceSelect();
            loadExpirenceCustomSelect();
            js('.js_event_toggle_block-4').removeClass('d-none');
            //addChatMessage(text, this0);
            addChatMessageAfterCustomSelect(text, custom_select);
        }
    });
    
    /*js('.js_event_validate_number').on('keyup', function(){
        let 
            this0 = js(this),
            val = Number(this0.val().trim());
            
        console.log(val.toString().length);
        
        if (val.toString().length >= 2) {
            if (Number.isInteger(val) === false) {
                alert(translates_json.ALERT_ICNORRECT_AGE[widget_lang]);
                return false;
            }
            js('.js_event_toggle_block-3').addClass('d-none');
            js('.js_event_toggle_block-4').addClass('d-none');
            js('.js_event_toggle_block-5').addClass('d-none');
            if (val < 14) {
                alert(translates_json.ALERT_SMALL_AGE[widget_lang]);
            }
            if (val == 18) {
                js('.js_event_toggle_block-3').removeClass('d-none');
                js('.js_event_toggle_block-4').removeClass('d-none');
                loadExpirenceSelect();
                loadExpirenceCustomSelect();
                addChatMessage(val, this0);
                //addChatMessageAfterCustomSelect(text, custom_select);
                scrollToBlock('expirence_custom_select');
            }
            if (val >= 14) {
                js('.js_event_toggle_block-4').removeClass('d-none');
                loadExpirenceSelect();
                loadExpirenceCustomSelect();
                addChatMessage(val, this0);
                //addChatMessageAfterCustomSelect(text, custom_select);
                scrollToBlock('expirence_custom_select');
            }
        }
    });*/
    
    js('.js_event_expirence_load').on('change', function(){
        let 
            this0 = js(this),
            selected_val = this0.find('option:selected').val().trim(),
            text = this0.find('option:selected').text(),
            custom_select = js('#expirence_custom_select');
        
        if(selected_val != '-1'){
            loadLastStepSelect();
            loadLastStepCustomSelect();
            js('.js_event_toggle_block-5').removeClass('d-none');
            //addChatMessage(text, this0);
            addChatMessageAfterCustomSelect(text, custom_select); 
            scrollToBlock('custom_select_last_step'); 
        } 
    }); 
    //console.log('general_labour_market_expirence_json', general_labour_market_expirence_json); 
    
    js('.js_event_last_step').on('change', function(){
         let 
            this0 = js(this),
            selected_val = this0.find('option:selected').val().trim(),
            text = this0.find('option:selected').text(),
            custom_select = js('#custom_select_last_step');
            
        if(selected_val != '-1'){
            generateLink();
           // js('.js_event_toggle_block-6').removeClass('d-none');//hh
           
            //addChatMessage(text, this0);
            addChatMessageAfterCustomSelect(text, custom_select);
            scrollToBlock('button_block'); 
            setTimeout(function(){
                js('.js_event_generate_link').trigger('click');
            }, 1500);
        }    
        
    });
    
    js('.js_event_generate_link').on('click', function(){
       generateLink();
    });
    
   
    
    
    customSelectOptionWorking('#union_custom_select');
    customSelectOptionWorking('#work_type_custom_select');
    customSelectOptionWorking('#job_descr_custom_select');
    customSelectOptionWorking('#expirence_custom_select');
    customSelectOptionWorking('#custom_select_last_step');
    
    js(document).on("change", ".input-calc-page3pselect-day-month-year select", function () {
        let allSelected = true;
        
        js(".input-calc-page3pselect-day-month-year select").each(function (index, select) {
            let value = js(select).val();
            
            if (value.length < 1) {
                allSelected = false;
            }
        });

        if (allSelected) {
            js(".input-calc-page3pselect").show();
            js(".input-calc-page3pselect select").prop("disabled", false);
            
            if(js('.js_event_age').val() > 0){
                console.log('reset questions after birthday...');
                js('#expirence_custom_select').trigger('click');
                setTimeout(function(){
                    js('#expirence_custom_select .data_option_wrapper .one_option:eq(0):visible').trigger('click');
                    js('#expirence_custom_select .first_custom_select_str').text(js('#expirence_custom_select .data_option_wrapper .one_option.selected_option_active').text().trim());
                },100);
               
                //js('#expirence_custom_select .data_option_wrapper .one_option:eq(0)').trigger('click');
                
                js('#expirence_custom_select, #custom_select_last_step').next().remove();
                js('.js_event_toggle_block-6').addClass('d-none');
            }
            
            let 
                year = js('select[name="calc[year]"]').val(),
                month = js('select[name="calc[month]"]').val(),
                day = js('select[name="calc[day]"]').val(),
                fulldate = day + '-' + month + '-' + year;


            console.log("dd-mm-YYYY:", fulldate);

            let 
                date1 = new Date(year, month - 1, day),
                now = new Date(),
                age = now.getFullYear() - date1.getFullYear();
   
            now.setFullYear(date1.getFullYear());
            if (now < date1)
                age--;

            //js('input[name="calc[age]"]').val(age);
            js('.js_event_age').val(age);
            js('.js_event_fulldate').val(fulldate);
            
            /////////////////////////
            let 
                this0 = js('.js_event_add_message_after'),
                val = Number(age);
            
            console.log(val.toString().length);
        
            //if (val.toString().length >= 2) {
                if (Number.isInteger(val) === false) {
                    alert(translates_json.ALERT_ICNORRECT_AGE[widget_lang]);
                    return false;
                }
                js('.js_event_toggle_block-3').addClass('d-none');
                js('.js_event_toggle_block-4').addClass('d-none');
                js('.js_event_toggle_block-5').addClass('d-none');
                
                if (val < 14) {
                    alert(translates_json.ALERT_SMALL_AGE[widget_lang]);
                    addChatMessage(val, this0);
                }
                if (val === 18) {
                    js('.js_event_toggle_block-3').removeClass('d-none');
                    js('.js_event_toggle_block-4').removeClass('d-none');
                    loadExpirenceSelect();
                    loadExpirenceCustomSelect();
                    addChatMessage(val, this0);
                    //addChatMessageAfterCustomSelect(text, custom_select);
                    scrollToBlock('expirence_custom_select');
                }
                if (val >= 14) {
                    js('.js_event_toggle_block-4').removeClass('d-none');
                    loadExpirenceSelect();
                    loadExpirenceCustomSelect();
                    addChatMessage(val, this0);
                    //addChatMessageAfterCustomSelect(text, custom_select);
                    scrollToBlock('expirence_custom_select');
                }
           // }
            ///////////////////////////////////
            
            /*let 
                salaries = js('input[name="calc[salaries]"]').val(),
                age1 = js('input[name="calc[age]"]').val();


            salaries = StrToFloat(salaries);
            let proc = 100;
            if (age1 == 14) {
                proc = 62;
                salaries = salaries * 0.62;
            }
            if (age1 == 15) {
                proc = 71;
                salaries = salaries * 0.71;
            }
            if (age1 == 16) {
                proc = 84;
                salaries = salaries * 0.84;
            }
            if (age1 == 17) {
                proc = 89;
                salaries = salaries * 0.89;
            }
            if (age1 == 18 && js("input[name='hours300']").val() != "1") {
                proc = 95;
                salaries = salaries * 0.95;
            }


            js('input[name="calc[salaries]"]').val(salaries);*/
        } else {
            js(".input-calc-page3pselect").hide();
            js(".input-calc-page3pselect select").prop("disabled", false);
            
        }
    });
    
    //temp commented
    js(document).mouseup(function (e) {  
        let container = js(".change_task_wrapper");
        if (container.has(js(e.target)).length === 0){
            container.hide();    
        } 
    });
    
    ///library
    function normalizeWorkType(union_val){
        console.log('js fn normalizeWorkType(union_val)');
       
        switch(union_val){ 
            case '5':
                defaultState(work_type_select);
               
                work_type_select.find('option[value="1a"]').removeAttr('hidden');
                //work_type_select.showHideDropdownOptions('1a', true);
                
                work_type_select.find('option[value="3"]').removeAttr('hidden');
                //work_type_select.showHideDropdownOptions('3', true);
                
                work_type_select.find('option[value="1"]').attr('hidden', true);
                //work_type_select.showHideDropdownOptions('1', true);
                break;
            case '12':
                defaultState(work_type_select);
                
                work_type_select.find('option[value="1a"]').attr('hidden', true);
                //work_type_select.showHideDropdownOptions('1a', false);
                
                work_type_select.find('option[value="4"]').removeAttr('hidden');
                //work_type_select.showHideDropdownOptions('4', true);
                break;
            default:
                defaultState(work_type_select);
                break;
        }
    }
    
    function normalizeCustomSelectWorkType(union_val){
        console.log('js fn normalizeCustomSelectWorkType(union_val)');
        let work_type_custom_select = js('#work_type_custom_select .change_task_wrapper');
       
        switch(union_val){ 
            case '5':
                defaultStateCustomSelect(work_type_custom_select);
               
                work_type_custom_select.find('.data_option_wrapper .one_option[data-option-value="1a"]').show();
                work_type_custom_select.find('.data_option_wrapper .one_option[data-option-value="3"]').show();  
                work_type_custom_select.find('.data_option_wrapper .one_option[data-option-value="1"]').hide();

                break;
            case '12':
                defaultStateCustomSelect(work_type_custom_select);
                
                work_type_custom_select.find('.data_option_wrapper .one_option[data-option-value="1a"]').hide();
                work_type_custom_select.find('.data_option_wrapper .one_option[data-option-value="4"]').show();
                
                break;
            default:
                defaultStateCustomSelect(work_type_custom_select);
                
                break;
        }
        
    }
    
    function defaultStateCustomSelect(select_jq_obj1){
        console.log('js fn defaultState()');
        
        let 
            states = work_type_json1,
            html = '<div class="data_option_wrapper">';
 
        js.each(states, function(i, e){
            html += '<div class="one_option" data-option-value="' + e.code + '"'; 
            if(e.is_hidden === 1){
                html += ' style="display:none;"';
                
            }
            html += '><span class="wrap"><span>' + e.name + '</span></span></div>';
        });
        html += '</div>';
        
        select_jq_obj1.empty().html(html);
        
        return states;
    }
    
    function defaultState(select_jq_obj){
        console.log('js fn defaultState()');
        
        let 
            states = work_type_json1,
            html = '';
 
        js.each(states, function(i, e){
            html += '<option value="' + e.code + '"'; 
            if(e.is_hidden === 1){
                html += ' hidden';
                
            }
            html += '>' + e.name + '</option>';
        });
        
        select_jq_obj.empty().html(html);
        
        return states;
    }
   
    function loadJobTypeSelect(val){
        console.log('js fn loadJobTypeSelect()');
        
        let 
            html = '',
            json;
    
        console.log(val);
        switch(val){
            case '0':
                json = job_description_gov_json;
            break;
            case '1':
                let selected_union = js('.js_event_union option:selected').val();
                
                //alert('union:' + selected_union);
                
                if(selected_union != 6){
                   // alert('!=6');
                    json = job_description_municipality_json;
                } else if(selected_union == 6){
                   // alert('=6');
                    json = job_description_municipality_json1;
                }
               
            break;
            case '1a':
                let selected_union1 = js('.js_event_union option:selected').val();
                
                //alert('union:' + selected_union);
                
                if(selected_union1 != 6){
                   // alert('!=6');
                    json = job_description_municipality_json;
                } else if(selected_union == 6){
                   // alert('=6');
                    json = job_description_municipality_json1;
                }
               
            break;
            case '2':
                json = job_description_general_labour_market_json;
            break;
            case '3':
                json = job_description_rey_city_json;
            break;
            default:
                //js('.js_event_job_description').trigger('change');
            break;
        }
       
        js.each(json, function(i, e){
            html += '<option value="' + e.name + '"'; 
           
            html += '>' + e.name + '</option>';
        });
        select_job_description.empty().html(html);
        js('.js_event_toggle_block-1').removeClass('d-none');
        
        //hh8
        scrollToBlock('expirence_custom_select');
        
        //js('.js_event_job_description').trigger('change');
    }
    
    function loadJobTypeCustomSelect(val){
        console.log('js fn loadJobTypeCustomSelect()');
        
        let 
            html = '<div class="data_option_wrapper">',
            json,
            job_type_custom_select = js('#job_descr_custom_select .change_task_wrapper'),
            custom_select_header = js('#job_descr_custom_select .first_custom_select_str');
    
        console.log(val);
        switch(val){
            case '0':
                json = job_description_gov_json;
                custom_select_header.text(translates_json.SELECT_YOUR_JOB_DESCR[widget_lang]);
            break;
            case '1':
                let selected_union = js('.js_event_union option:selected').val();
                
                //alert('union:' + selected_union);
                
                if(selected_union != 6){
                   // alert('!=6');
                    json = job_description_municipality_json;
                } else if(selected_union == 6){
                   // alert('=6');
                    json = job_description_municipality_json1;
                }
                custom_select_header.text(translates_json.SELECT_YOUR_JOB_DESCR_MUNI[widget_lang]);
            break;
            case '1a':
                let selected_union1 = js('.js_event_union option:selected').val();
                
                //alert('union:' + selected_union);
                
                if(selected_union1 != 6){
                   // alert('!=6');
                    json = job_description_municipality_json;
                    
                } else if(selected_union == 6){
                   // alert('=6');
                    json = job_description_municipality_json1;
                   
                }
                custom_select_header.text(translates_json.SELECT_YOUR_JOB_DESCR_MUNI[widget_lang]);
               
            break;
            case '2':
                json = job_description_general_labour_market_json;
                custom_select_header.text(translates_json.SELECT_YOUR_JOB_DESCR_GEN_LABOUR[widget_lang]);
            break;
            case '3':
                json = job_description_rey_city_json;
                custom_select_header.text(translates_json.SELECT_YOUR_JOB_DESCR_REY_CITY[widget_lang]);
            break;
            default:
                //js('.js_event_job_description').trigger('change');
            break;
        }
       
        js.each(json, function(i, e){
            html += '<div class="one_option" data-option-value="' + e.name + '"'; 
           
            html += '><span class="wrap"><span>' + e.name + '</span></span></div>';
        });
        html += '</div>';
        
        job_type_custom_select.empty().html(html);
        js('.js_event_toggle_block-1').removeClass('d-none');
        //js('.js_event_job_description').trigger('change');
    }
   
    function loadExpirenceSelect(){
        console.log('js fn loadExpirenceSelect()');
        
        let 
            selected_union = js('.js_event_work_type option:selected').val(),
            header = js('.js_event_set_expirence_text'),
            expirence_select = js('.js_event_expirence_load'),
            age = js('.js_event_validate_number').val().trim(),
            json,
            html = '';
        
        switch(selected_union){
            case '0':
                header.text(translates_json.HEADER_SELECT_YOUR_WAGE[widget_lang]);
                
                json = gov_expirence_json;
                
                js.each(json, function(i, e){
                    html += '<option value="' + e.code + '"'; 
                    let name;
                    
                    if(widget_lang == 'is'){
                        name = e.name_is;
                    } else{
                        name = e.name;
                    }
                    html += '>' + name + '</option>';
                });
                expirence_select.empty().html(html);
            break;
            case '1':
            case '1a':
                header.text(translates_json.HEADER_SELECT_PERSONAL_STRAIN[widget_lang]);
                
                json = municipal_expirence_json;
                
                js.each(json, function(i, e){
                    html += '<option value="' + e.code + '"'; 
                    let name;
                    
                    if(widget_lang == 'is'){
                        name = e.name_is;
                    } else{
                        name = e.name;
                    }
                    html += '>' + name + '</option>';
                });
                expirence_select.empty().html(html);
            break;
            case '2':
                header.text(translates_json.HEADER_SELECT_WHEN_DID_YOU_START_TO_WORK[widget_lang]);
                
                json = general_labour_market_expirence_json;
                
                js.each(json, function(i, e){
                    html += '<option value="' + e.code + '"'; 
                    if(e.is_hidden === 1){
                        html += ' hidden';
                    }
                    let name;
                    
                    if(widget_lang == 'is'){
                        name = e.name_is;
                    } else{
                        name = e.name;
                    }
                    html += '>' + name + '</option>';
                });
               
                expirence_select.empty().html(html);
                expirence_select.find('option[value="1"]:eq(0)').attr('hidden', true);
                if(age >= 14 && age <= 21){
                    expirence_select.find('option[value="1"]:eq(0)').removeAttr('hidden');
                }
            break;
            case '3':
                header.text(translates_json.HEADER_SELECT_WHEN_DID_YOU_START_TO_WORK1[widget_lang]); 
                
                json = rey_city_expirence_json;
                //hh
                js.each(json, function(i, e){
                    html += '<option value="' + e.code + '"'; 
                    let name;
                    
                    if(widget_lang == 'is'){
                        name = e.name_is;
                    } else{
                        name = e.name;
                    }
                    html += '>' + name + '</option>';
                });
                expirence_select.empty().html(html);
            break;
            default:
                header.text('');
                expirence_select.empty();
            break;
        }
        
    }
    
    function loadExpirenceCustomSelect(){
        console.log('js fn loadExpirenceCustomSelect()');
        
        let 
            selected_union = js('.js_event_work_type option:selected').val(),
            header = js('.js_event_set_expirence_text'),
            expirence_select = js('#expirence_custom_select .change_task_wrapper'),
            age = js('.js_event_validate_number').val().trim(),
            json,
            html = '<div class="data_option_wrapper">',
            select_header = js('#expirence_custom_select .first_custom_select_str');
        
        switch(selected_union){
            case '0':
                header.text(translates_json.HEADER_SELECT_YOUR_WAGE[widget_lang]);
                
                json = gov_expirence_json;
                
                /*js.each(json, function(i, e){
                    html += '<option value="' + e.code + '"'; 
                    let name;
                    
                    if(widget_lang == 'is'){
                        name = e.name_is;
                    } else{
                        name = e.name;
                    }
                    html += '>' + name + '</option>';
                });*/
                
                js.each(json, function(i, e){
                    let name;
                    html += '<div class="one_option" data-option-value="' + e.code + '"'; 
                    
                    if(widget_lang == 'is'){
                        name = e.name_is;
                    } else{
                        name = e.name;
                    }
                    html += '><span class="wrap"><span>' + name + '</span></span></div>';
                });
                html += '</div>';
                
                select_header.text(translates_json.EXPERIENCE[widget_lang]);
                expirence_select.empty().html(html);
                scrollToBlock('expirence_custom_select'); 
            break;
            case '1':
            case '1a':
                header.text(translates_json.HEADER_SELECT_PERSONAL_STRAIN[widget_lang]);
                
                json = municipal_expirence_json;
                
                /*js.each(json, function(i, e){
                    html += '<option value="' + e.code + '"'; 
                    let name;
                    
                    if(widget_lang == 'is'){
                        name = e.name_is;
                    } else{
                        name = e.name;
                    }
                    html += '>' + name + '</option>';
                });*/
                
                js.each(json, function(i, e){
                    let name;
                    html += '<div class="one_option" data-option-value="' + e.code + '"'; 
                    
                    if(widget_lang == 'is'){
                        name = e.name_is;
                    } else{
                        name = e.name;
                    }
                    html += '><span class="wrap"><span>' + name + '</span></span></div>';
                });
                html += '</div>';
                
                select_header.text(translates_json.EXPERIENCE_MUNI[widget_lang]);
                expirence_select.empty().html(html);
                scrollToBlock('expirence_custom_select'); 
            break;
            case '2':
                header.text(translates_json.HEADER_SELECT_WHEN_DID_YOU_START_TO_WORK[widget_lang]);
                
                json = general_labour_market_expirence_json;
                
                /*js.each(json, function(i, e){
                    html += '<option value="' + e.code + '"'; 
                    if(e.is_hidden === 1){
                        html += ' hidden';
                    }
                    let name;
                    
                    if(widget_lang == 'is'){
                        name = e.name_is;
                    } else{
                        name = e.name;
                    }
                    html += '>' + name + '</option>';
                });*/
                        
                js.each(json, function(i, e){
                    let name;
                    html += '<div class="one_option" data-option-value="' + e.code + '"'; 
                    
                    if(widget_lang == 'is'){
                        name = e.name_is;
                    } else{
                        name = e.name;
                    }
                    html += '><span class="wrap"><span>' + name + '</span></span></div>';
                });
                html += '</div>';        
               
               
                expirence_select.empty().html(html);
                expirence_select.find('.one_option[data-option-value="1"]:eq(0)').hide();
                if(age >= 14 && age <= 21){
                    expirence_select.find('.one_option[data-option-value="1"]:eq(0)').show();
                }
                scrollToBlock('user_age'); 
            break;
            case '3':
                header.text(translates_json.HEADER_SELECT_WHEN_DID_YOU_START_TO_WORK1[widget_lang]); 
                
                json = rey_city_expirence_json;
               
                /*js.each(json, function(i, e){
                    html += '<option value="' + e.code + '"'; 
                    let name;
                    
                    if(widget_lang == 'is'){
                        name = e.name_is;
                    } else{
                        name = e.name;
                    }
                    html += '>' + name + '</option>';
                });*/
                js.each(json, function(i, e){
                    let name;
                    html += '<div class="one_option" data-option-value="' + e.code + '"'; 
                    
                    if(widget_lang == 'is'){
                        name = e.name_is;
                    } else{
                        name = e.name;
                    }
                    html += '><span class="wrap"><span>' + name + '</span></span></div>';
                });            
                
                select_header.text(translates_json.EXPERIENCE_REY[widget_lang]);
                expirence_select.empty().html(html);
                scrollToBlock('expirence_custom_select'); 
            break;
            default:
                header.text('');
                expirence_select.empty();
            break;
        }
    }
    
    function loadLastStepSelect(){
        console.log('js fn loadLastStepSelect()');
        
        let 
            json = last_selelect_calc_type_json,
            html = '',
            last_select = js('.js_event_last_step'),
            selected_work_type = js('.js_event_work_type option:selected').val()
        ;
        
        js.each(json, function(i, e){
            html += '<option value="' + e.code + '"'; 
            if(e.is_hidden === 1){
                html += ' hidden';
            }
            let name;
                    
            if(widget_lang == 'is'){
                name = e.name_is;
            } else{
                name = e.name;
            }
                    
            html += '>' + name + '</option>';
        });
        last_select.empty().html(html);
        
        last_select.find('option[value="customcalc6"]').attr('hidden', true);
        if(selected_work_type == '1' || selected_work_type == '1a'){
            last_select.find('option[value="customcalc6"]').removeAttr('hidden');
        }
    }
    
    function loadLastStepCustomSelect(){
        console.log('js fn loadLastStepCustomSelect()');
        
        let 
            json = last_selelect_calc_type_json,
            html = '<div class="data_option_wrapper">',
            last_select = js('#custom_select_last_step .change_task_wrapper'),
            selected_work_type = js('.js_event_work_type option:selected').val()
        ;
        
        /*js.each(json, function(i, e){
            html += '<option value="' + e.code + '"'; 
            if(e.is_hidden === 1){
                html += ' hidden';
            }
            let name;
                    
            if(widget_lang == 'is'){
                name = e.name_is;
            } else{
                name = e.name;
            }
                    
            html += '>' + name + '</option>';
        });*/
        
        js.each(json, function(i, e){
            html += '<div class="one_option" data-option-value="' + e.code + '"'; 
            let name;
                    
            if(widget_lang == 'is'){
                name = e.name_is;
            } else{
                name = e.name;
            }
            if(e.is_hidden === 1){
                html += ' style="display:none;"';
            }
            html += '><span class="wrap"><span>' + name + '</span></span></div>';
        });
        html += '</div>';
        last_select.empty().html(html);
        
        last_select.find('.one_option[data-option-value="customcalc6"]').hide();
        if(selected_work_type == '1' || selected_work_type == '1a'){
            last_select.find('.one_option[data-option-value="customcalc6"]').show();
        }
    }
    
    function generateLink(){
        console.log('js fn generateLink()');
        
        let 
            selected_page1 = js('.js_event_union option:selected').val(),//union
            selected_page2 = js('.js_event_work_type option:selected').val(),//work type
            selected_page3 = js('.js_event_job_description option:selected').val(),//job description
            //age = js('.js_event_validate_number').val(),//age
            
            age = js('.js_event_age').val(),
            birthday = js('.js_event_fulldate').val(),
            more_than_300h_expirence = js('#expirence_more_them_300').prop('checked'),//18 years checkbox
            selected_page4 = js('.js_event_expirence_load').val(),//expirence
            selected_page4_text = js('.js_event_expirence_load option:selected').text(),
            selected_page5 = js('.js_event_last_step').val(),//calculator type
            
            link_input_block = js('.js_event_link_block_visible'),
            link_input = js('.js_event_load_link'),
          
            url = widget_lang + '/',
            no_compensation = 0
        ;
        
        console.log('selected_page1', selected_page1, 
        'selected_page2', selected_page2, 'selected_page3', 
        selected_page3, 'age', age, 'more_than_300h_expirence', 
        more_than_300h_expirence, 'selected_page4', selected_page4, 
        'selected_page5', selected_page5);
        
        if(age >= 14 && age <= 21 && selected_page4 == '1' && (selected_page4_text == 'Less than 6 months' || selected_page4_text == 'Minna en 6 mánuðir')){
            no_compensation = 1; 
        }
        if(more_than_300h_expirence === true){
            more_than_300h_expirence = '1';
        }
        if(selected_page2 == '1a'){
            selected_page2 = '1';
        }
        
        url += '?page1=' + selected_page1 + '&page2=' + selected_page2 + '&page3=' + selected_page3 + '&page4=' + selected_page4 + '&age=' + age + '&hours300=' + more_than_300h_expirence + '&no-compensation=' + no_compensation + '&page5=' + selected_page5 + '&birthday=' + birthday;
        
        
       // window.open(url, "_blank");
       console.log(url);
       js('#generated_link').val(url);
    }
    
    function scrollToBlock(id){
        console.log('js fn scrollToBlock()');
        
        document.getElementById(id).scrollIntoView();
    }
    
    js.fn.showHideDropdownOptions = function(value, canShowOption) { 
         
             $(this).find('option[value="' + value + '"]').map(function () {
                return $(this).parent('span').length === 0 ? this : null;
            }).wrap('<span>').hide();
            
            if (canShowOption) 
                $(this).find('option[value="' + value + '"]').unwrap().show();
            else 
                $(this).find('option[value="' + value + '"]').hide();
        
    };
    
    function addChatMessage(value, preview_el){
        /*let 
            message_html = '<div class="one_message_wrapper d-flex justify-content-end"><div class="one_message">' + value + '</div></div>',
            old_messages_without_new = preview_el.parent().find('.one_message_wrapper'),
            count_old_messages = old_messages_without_new.length;

        console.log('messages count:' + count_old_messages);
        if(count_old_messages >= 1){
            preview_el.parent().find('.one_message_wrapper:not(:first-child)').remove();
        }
        
        preview_el.after(message_html);*/
    }
    
    function addChatMessageAfterCustomSelect(value, preview_el){
         /*let 
            message_html = '<div class="one_message_wrapper d-flex justify-content-end"><div class="one_message">' + value + '</div></div>',
            old_messages_without_new = preview_el.parent().find('.one_message_wrapper'),
            count_old_messages = old_messages_without_new.length;

        console.log('messages count:' + count_old_messages);
        if(count_old_messages >= 1){
            preview_el.parent().find('.one_message_wrapper:not(:first-child)').remove();
        }
        
        preview_el.after(message_html);*/
        preview_el.find('.first_custom_select_str').text(value);
    }
    
    function customSelectOptionWorking(select_id) {
        var
            selected_option_users = js(select_id + ' .one_option:not(.one_option_header)'),
            connected_select_string = js(select_id).attr('data-connected-select'),
            connected_select_node = js(connected_select_string);
    
        js(select_id + '.js_event_one_custom_select').live('click', function(){
            if(js(select_id + '.js_event_one_custom_select .change_task_wrapper').is(':visible')){
                js(select_id + '.js_event_one_custom_select .change_task_wrapper').hide();
            } else{
                js(select_id + '.js_event_one_custom_select .change_task_wrapper').show();
            }
        });
        console.log(selected_option_users); 
        selected_option_users = js(select_id + ' .one_option:not(.one_option_header)');
        
        selected_option_users.live('click', function () {
            console.log('custom select option click');
            let
                this0 = js(this),
                selected_option_val = this0.attr('data-option-value');
                    
            js(select_id + ' .one_option:not(.one_option_header)').removeClass('selected_option_active');
            
            this0.addClass('selected_option_active');
            connected_select_node.val(selected_option_val).trigger('change');
        });
    }
    ///end library
});
