<?php
$language = trim(filter_input(INPUT_GET, 'lang', FILTER_SANITIZE_STRING));
if(!in_array( $language, ['is', 'en'])){
    exit('Failed load calculator widget: Enter correct language');
}
$required_path = $_SERVER['DOCUMENT_ROOT'] . '/calculator_widget/calculator_widget.class.php';
if (file_exists($required_path)) {
    require_once $required_path;
} else{
    exit('Error. No nessesary class file.');
}


$obj = new CalcWidget($language);
$unions = $obj->union_list;
$work_type = $obj->work_type;

$job_description_gov = $obj->job_description_gov;
$job_description_municipality = $obj->job_description_municipality;
$job_description_municipality1 = $obj->job_description_municipality1;
$rey_city = $obj->rey_city;
$general_labour_market = $obj->general_labour_market;

$goverment_expirence = $obj->goverment_expirence;
$municipal_expirence = $obj->municipal_expirence;
$rey_city_expirence = $obj->rey_city_expirence;
$general_labour_market_expirence = $obj->general_labour_market_expirence;
$last_selelect_calc_type = $obj->last_selelect_calc_type;
$translates = $obj->translates;

$selected_union_id = '3';

?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <!-- Bootstrap CSS -->
        <link href="https://<?=$_SERVER['SERVER_NAME']?>/calculator_widget/bootstrap-5.1.3-dist/css/bootstrap.min.css" rel="stylesheet">
        
        <link href="https://<?=$_SERVER['SERVER_NAME']?>/calculator_widget/font-awesome-4.7.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
        <link href="https://<?=$_SERVER['SERVER_NAME']?>/calculator_widget/styles/calc_widget.css?time=<?= time() ?>" rel="stylesheet">
        
        <title>Curiotime calculator widget</title>
    </head>
    <body>
        <div class="container-fluid p-0">
            <div class="row g-0">
                <div class="col-12">
                    <div class="widget_header_sub d-flex align-items-center">
                        <div>
                            <img src="/calculator_widget/img/calc_icon_compressed.png" alt="" class="small_calc_widget_icon"/>
                        </div>
                        <h2 class="top_header d-flex flex-column"><?=$translates['HEADER_TOP'][$language]?></h2>
                        <div class="top_icons_wrapper d-flex flex-column">
                            <!--<i class="fa fa-square" aria-hidden="true"></i>
                            <i class="fa fa-square" aria-hidden="true"></i>
                            <i class="fa fa-square" aria-hidden="true"></i>-->
                            <img src="/calculator_widget/img/squares.png" alt="" class="squares"/>
                        </div>
                        <div class="close_widget_wrapper js_event_widget_close">
                            <img src="/calculator_widget/img/arrow_compressed.png" alt="" class="arrow"/>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row g-0">
                <div class="col-12">
                    <div class="gray_wave"><?=$translates['GRAY_WAVE_HEADER'][$language]?></div>
                </div>
            </div>
        </div> 
        <div class="container content">
            <div class="row">
                <div class="col-12">
                    <h3 class="text-center select_unions_header d-none"><?=$translates['HEADER_SELECT_UNION'][$language]?></h3>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    
                    <select class="form-select js_event_union one_select d-none" aria-label="<?=$translates['HEADER_SELECT_UNION1'][$language]?>" id="union_select">
                        <option selected value="-1"><?=$translates['HEADER_SELECT_UNION1'][$language]?></option>
                        <?php foreach ($unions as $k => $one_union) {
                            $selected = '';
                            //echo $k.PHP_EOL;
                            if($k == $selected_union_id){
                                $selected = 'selected';
                            }?>
                            <option value="<?= $k ?>" <?=$selected?>><?= $one_union ?></option>
                        <?php } ?>
                    </select>
                    <!--d-grid gap-2-->
                    <div class="dropdown_users_wrapper button_wrapper js_event_one_custom_selec d-none" data-connected-select="#union_select" id="union_custom_select">
                        <button class="btn btn-outline-info button_style_custom_select d-flex justify-content-between align-items-center" type="button">
                                <span class="first_custom_select_str"><?=$translates['HEADER_SELECT_UNION1'][$language]?></span>
                                <div class="change_task_wrapper" style="display: none;">
                                    <div class="data_option_wrapper">
                                        <div class="one_option" data-option-value="-1"><span class="wrap"><span><?= $translates['HEADER_SELECT_UNION1'][$language] ?></span></span></div>
                                            <?php foreach ($unions as $k => $one_union) { 
                                                $selected1 = '';
                                                                        
                                                if($k == $selected_union_id){
                                                    $selected1 = ' selected_option_active';
                                                }
                                            ?>
                                                <div class="one_option<?=$selected1?>" data-option-value="<?= $k ?>"> 
                                                    <span class="wrap">
                                                         <span><?= $one_union ?></span>
                                                    </span>
                                                </div>
                                            <?php } ?> 
                                    </div>
                                </div>
                                <span class="custom_select_str d-flex">
                                    <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'><path fill='none' stroke='#b21e2c' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/></svg>
                                </span>
                        </button>
                    </div>
                </div>
            </div>
            <div class="row d-none js_event_toggle_block-0">
                <div class="col-12">
                    <h3 class="text-center work_type_header d-none"><?=$translates['HEADER_WHERE_DO_YOU_WORK'][$language]?></h3>
                    <select class="form-select work_type_select js_event_work_type d-none" aria-label="<?=$translates['HEADER_WHERE_DO_YOU_WORK'][$language]?>" id="work_type">
                        <option selected value="-1"><?=$translates['HEADER_WHERE_DO_YOU_WORK'][$language]?></option>
                        <?php foreach ($work_type as $one_union) { ?>
                            <option value="<?= $one_union['code'] ?>" <?php if($one_union['is_hidden'] === 1 ){?> hidden<?php } ?>><?= $one_union['name'] ?></option>
                        <?php } ?>
                    </select> 
                    <!--d-grid gap-2-->
                    <div class="dropdown_users_wrapper button_wrapper js_event_one_custom_select" data-connected-select="#work_type" id="work_type_custom_select">
                        <button class="btn btn-outline-info button_style_custom_select d-flex justify-content-between align-items-center" type="button">
                                <span class="first_custom_select_str"><?=$translates['HEADER_WHERE_DO_YOU_WORK'][$language]?></span>
                                <div class="change_task_wrapper" style="display: none;">
                                    <div class="data_option_wrapper">
                                        <!--<div class="one_option selected_option_active" data-option-value="-1"><span class="wrap"><span><?=$translates['HEADER_WHERE_DO_YOU_WORK'][$language]?></span></span></div>-->
                                        <?php foreach ($work_type as $one_union) { ?>
                                            <div class="one_option" <?php if($one_union['is_hidden'] === 1 ){?> style="display:none"<?php } ?> data-option-value="<?= $one_union['code'] ?>"> 
                                                <span class="wrap">
                                                    <span><?= $one_union['name'] ?></span>
                                                </span>
                                            </div>
                                        <?php } ?>   
                                    </div>
                                </div>
                                <span class="custom_select_str d-flex">
                                    <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'><path fill='none' stroke='#b21e2c' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/></svg>
                                </span>
                        </button>
                    </div>
                </div>
            </div>
            <div class="row d-none js_event_toggle_block-1">
                <div class="col-12">
                    <h3 class="text-center work_type_header d-none"><?=$translates['HEADER_JOB_DESCR'][$language]?></h3>
                    <select class="form-select work_type_select js_event_job_description d-none" aria-label="<?=$translates['HEADER_JOB_DESCR'][$language]?>" id="job_description">
                        <option selected value="-1"><?=$translates['HEADER_JOB_DESCR'][$language]?></option>
                    </select>
                    <!--d-grid gap-2-->
                    <div class="dropdown_users_wrapper button_wrapper js_event_one_custom_select" data-connected-select="#job_description" id="job_descr_custom_select">
                        <button class="btn btn-outline-info button_style_custom_select d-flex justify-content-between align-items-center" type="button">
                                <span class="first_custom_select_str"><?=$translates['HEADER_JOB_DESCR'][$language]?></span>
                                <div class="change_task_wrapper" style="display: none;">
                                    <div class="data_option_wrapper"></div>
                                </div>
                                <span class="custom_select_str d-flex">
                                    <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'><path fill='none' stroke='#b21e2c' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/></svg>
                                </span>
                        </button>
                    </div>
                </div>
            </div>
            <div class="row d-none js_event_toggle_block-2">
                <div class="col-12">
                    <h3 class="text-center work_type_header age_header"><?=$translates['WRITE_YOUR_AGE'][$language]?></h3>
                    <input type="number" placeholder="<?=$translates['WRITE_YOUR_AGE'][$language]?>" class="form-control one_input input_age js_event_validate_number d-none" id="user_age"/>
                   
                    <div class="input-calc-page3pselect-day-month-year birthday_selects_wrapper d-flex js_event_add_message_after" id="birthday_block">
                        <select name="calc[day]" class="form-select input-reset-empty select_calc_page3pselect_day form-auto-scroll-down" aria-label="<?= $translates['BIRTHDAY_DAY'][$language] ?>" autocomplete="off"  >
                            <option value=""><?= $translates['BIRTHDAY_DAY'][$language] ?></option>
                            <?php for ($i = 1; $i < 32; $i++)
                                echo '<option value="' . sprintf("%02d", $i) . '">' . sprintf("%02d", $i) . '</option>'; 
                            ?>
                        </select>
                        <select name="calc[month]" class="form-select input-reset-empty select_calc_page3pselect_month form-auto-scroll-down" aria-label="<?= $translates['BIRTHDAY_MONTH'][$language] ?>" autocomplete="off"  >
                            <option value=""><?= $translates['BIRTHDAY_MONTH'][$language] ?></option>
                            <?php for ($i = 1; $i < 13; $i++)
                                echo '<option value="' . sprintf("%02d", $i) . '">' . sprintf("%02d", $i) . '</option>'; ?>
                        </select>
                        <select name="calc[year]" id="registerUserCalcFormYear" class="form-select select_calc_page3pselect_year form-auto-scroll-down" aria-label="<?= $translates['BIRTHDAY_YEAR'][$language] ?>" autocomplete="off"  >
                            <option value=""><?= $translates['BIRTHDAY_YEAR'][$language] ?></option>
                            <?php for ($i = 1920; $i < date('Y') + 1; $i++)
                                echo '<option ' . ($i == 2005 ? ' selected="selected" ' : '') . ' value="' . sprintf("%04d", $i) . '">' . sprintf("%04d", $i) . '</option>'; ?>
                        </select>
                    </div>                        
                    <div class="filter_state_wrapper d-none js_event_toggle_block-3">
                        <div class="one_item_page_rules_item">
                            <input type="checkbox" class="custom_checkbox" id="expirence_more_them_300">
                            <label for="expirence_more_them_300" class="label_rule_item"><?=$translates['H_300'][$language]?></label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row d-none js_event_toggle_block-4">
                <div class="col-12">
                    <h3 class="text-center work_type_header js_event_set_expirence_text d-none"></h3>
                    <select class="form-select work_type_select js_event_expirence_load d-none" aria-label="<?=$translates['EXPERIENCE'][$language]?>" id="expirence_select"></select> 
                    <!--d-grid gap-2-->
                    <div class="dropdown_users_wrapper button_wrapper js_event_one_custom_select revert_select" data-connected-select="#expirence_select" id="expirence_custom_select">
                        <button class="btn btn-outline-info button_style_custom_select d-flex justify-content-between align-items-center" type="button">
                                <span class="first_custom_select_str"><?=$translates['EXPERIENCE'][$language]?></span>
                                <div class="change_task_wrapper" style="display: none;">
                                    <div class="data_option_wrapper"></div>
                                </div>
                                <span class="custom_select_str d-flex">
                                    <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'><path fill='none' stroke='#b21e2c' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/></svg>
                                </span>
                        </button>
                    </div>
                </div>
            </div>
            <div class="row d-none js_event_toggle_block-5">
                <div class="col-12">
                    <h3 class="text-center work_type_header d-none"><?=$translates['WORK_DESCRIPTION'][$language]?></h3>
                    <select class="form-select work_type_select js_event_last_step d-none" aria-label="<?=$translates['SELECT_WORK_DESCRIPTION'][$language]?>" id="select_last_step">
                        <option selected value="-1"><?=$translates['SELECT_WORK_DESCRIPTION'][$language]?></option>
                    </select> 
                    <!--d-grid gap-2-->
                    <div class="dropdown_users_wrapper button_wrapper js_event_one_custom_select revert_select" data-connected-select="#select_last_step" id="custom_select_last_step">
                        <button class="btn btn-outline-info button_style_custom_select d-flex justify-content-between align-items-center" type="button">
                                <span class="first_custom_select_str"><?=$translates['SELECT_WORK_DESCRIPTION'][$language]?></span>
                                <div class="change_task_wrapper" style="display: none;">
                                    <div class="data_option_wrapper"></div>
                                </div>
                                <span class="custom_select_str d-flex">
                                    <svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'><path fill='none' stroke='#b21e2c' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/></svg>
                                </span>
                        </button>
                    </div>
                </div>
            </div>
            <div class="row d-none js_event_toggle_block-6" id="button_block">
                <div class="col-12">
                    <div class="d-grid gap-2 button_wrapper">
                        <button class="btn btn-success generate_button js_event_generate_link" type="button"><?=$translates['GET_YOUR_LINK'][$language]?></button>
                    </div>
                    <div class="d-none js_event_link_block_visible">
                        <div>
                            <h3 class="text-center work_type_header"><?=$translates['YOUR_LINK'][$language]?></h3>
                        </div>
                        <div>
                            <textarea type="text" rows="12" disabled class="form-control one_input textarea_link js_event_load_link"></textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <input type="hidden" class="js_event_url"/>
        <button class='d-none js_event_window' onclick=''></button>
        <input type="hidden" class="js_event_age"/>
        <input type="hidden" class="js_event_fulldate"/>
        
        <input type="hidden" class="js_event_work_type_json" value='<?=json_encode($work_type)?>'/>
        <input type="hidden" class="js_event_job_description_gov_json" value='<?=json_encode($job_description_gov)?>'/>
        <div class="js_event_job_description_municipality_json" style="display: none"><?=json_encode($job_description_municipality)?></div>
        <div class="js_event_job_description_municipality_json1" style="display: none"><?=json_encode($job_description_municipality1)?></div>
        <div class="js_event_job_description_rey_city_json" style="display: none"><?=json_encode($rey_city)?></div>
        <div class="js_event_job_description_general_labour_market_json" style="display: none"><?=json_encode($general_labour_market)?></div>
        
        <div class="js_event_gov_expirence_json" style="display: none"><?=json_encode($goverment_expirence)?></div>
        <div class="js_event_municipal_expirence_json" style="display: none"><?=json_encode($municipal_expirence)?></div>
        <div class="js_event_rey_city_expirence_json" style="display: none"><?=json_encode($rey_city_expirence)?></div>
        <div class="js_event_general_labour_market_expirence_json" style="display: none"><?=json_encode($general_labour_market_expirence)?></div>
        
        <div class="js_event_last_selelect_calc_type_json" style="display: none"><?=json_encode($last_selelect_calc_type)?></div>
        <input type="hidden" class="widget-lang" value="<?=$language?>"/> 
        <div class="translates_input" style="display: none"><?=json_encode($translates)?></div>
        
        <script src="//code.jquery.com/jquery-3.5.1.min.js" type="text/javascript"></script>
	<script src="//code.jquery.com/jquery-migrate-1.4.1.min.js" type="text/javascript"></script>
        <script src="https://<?=$_SERVER['SERVER_NAME']?>/calculator_widget/bootstrap-5.1.3-dist/js/bootstrap.bundle.min.js"></script>
        <script>jQuery.noConflict(); </script>
        <script src="https://<?=$_SERVER['SERVER_NAME']?>/calculator_widget/jquery-mask/jquery.mask.min.js"></script>
        <script src="https://<?=$_SERVER['SERVER_NAME']?>/calculator_widget_bar/js/calc_widget.js?time=<?= time() ?>"></script>
        <script>
            'use strict';
    
            jQuery(document).ready(function($){
                let js = $; 
        
                <?php if(!empty($selected_union_id)){?>
           
                    setTimeout(function(){
                        js('#union_custom_select .selected_option_active').trigger('click');
                    }, 400);
           
                <?php } ?>
            });
        </script>
    </body>
</html>
