<?php
class CalcWidget {

    public 
        $union_list,
        $work_type,
        $job_description,
        $job_description_municipality,
        $job_description_municipality1,
        $rey_city,
        $general_labour_market,
        $goverment_expirence,
        $municipal_expirence,
        $rey_city_expirence,
        $general_labour_market_expirence,
        $last_selelect_calc_type,
        $translates;
    
    public function __construct($language) {
        $this->lang = $language;
        
        $this->translates = [
            'ALERT_ICNORRECT_AGE' => [
                'is' => 'Sláðu inn númer!',
                'en' => 'Enter number!'
            ],
            'ALERT_SMALL_AGE' => [
                'is' => 'Reiknivél er aðeins virk fyrir notendur sem eru 14 ára og eldri. - Vinsamlega veldu nýtt fæðingaráar.',
                'en' => 'Calculator is only active for users with age from 14 years and up - pls. select new year of birth.'
            ],
            'HEADER_SELECT_YOUR_WAGE' => [
                'is' => 'Starfsaldur',
                'en' => 'Select your wage'
            ],
            'HEADER_SELECT_PERSONAL_STRAIN' => [
                'is' => 'Veldu persónuálag',
                'en' => 'Select personal strain'
            ],
            'HEADER_SELECT_WHEN_DID_YOU_START_TO_WORK' => [
                'is' => 'Starfsaldur',
                'en' => 'When did you start to work?'
            ],
            'HEADER_SELECT_WHEN_DID_YOU_START_TO_WORK1' => [
                'is' => 'Starfsaldur',
                'en' => 'When did you start to work?'
            ],
            'HEADER_SELECT_UNION' => [
                'is' => 'Veldu þitt stéttarfélag',
                'en' => 'Select unions'
            ],
            'HEADER_SELECT_UNION1' => [
                'is' => 'Veldu þitt stéttarfélag',
                'en' => 'Select unions'
            ],
            'HEADER_WHERE_DO_YOU_WORK' => [
                'is' => 'Launagreiðandi',
                'en' => 'Where do you work ?'
            ],
            'GOVERMENT' => [
                'is' => 'Ríki',
                'en' => 'Goverment'
            ],
            'MUNICIPALITY' => [
                'is' => 'Sveitarfélag',
                'en' => 'Municipality'
            ],
            'MUNICIPALITY_IN_ICELAND' => [
                'is' => 'Sveitarfélög á Íslandi',
                'en' => 'Municipality in Iceland'
            ],
            'REY_CITY' => [
                'is' => 'Reykjavíkurborg',
                'en' => 'Reykjavikur city'
            ],
            'GEN_L_MARKET' => [
                'is' => 'Almennur vinnumarkaður', 
                'en' => 'General labour market'
            ],
            'RIO' => [
                'is' => 'Rio Tinto Ísland',
                'en' => 'Rio Tinto Iceland'
            ],
            'SELECT_YOUR_JOB_DESCR' => [
                'is' => 'Veldu launaflokk',
                'en' => 'Select your salaries wage number'
            ],
            'SELECT_YOUR_JOB_DESCR_MUNI' => [
                'is' => 'Starfsheiti',
                'en' => 'Job description'
            ],
            'SELECT_YOUR_JOB_DESCR_GEN_LABOUR' => [
                'is' => 'Starfsheiti',
                'en' => 'Job description'
            ],
            'SELECT_YOUR_JOB_DESCR_REY_CITY' => [
                'is' => 'Starfsheiti',
                'en' => 'Select your job description to continue'
            ],
            'HEADER_JOB_DESCR' => [
                'is' => 'Skrifaðu númer launaflokks',
                'en' => 'Select your salaries wage number'
            ],
            'WRITE_YOUR_AGE' => [
                'is' => 'Skrifaðu aldur þinn',
                'en' => 'Your birthday'
            ],
            'H_300' => [
                'is' => 'Meira en 300 tímar á sama starfsstað?',
                'en' => 'More than 300 hours in same workplace?'
            ],
            'EXPERIENCE' => [//gov
                'is' => 'Starfsaldur',
                'en' => 'Select your Wage'
            ], 
            'EXPERIENCE_MUNI' => [
                'is' => 'Veldu persónuálag',
                'en' => 'Select personal strain'
            ],
            'EXPERIENCE_ZERO_ELEMENT' => [
                'is' => 'Grunnlaun',
                'en' => 'Basic wages'
            ],
            'EXPERIENCE_REY' => [
                'is' => 'Starfsaldur',
                'en' => 'When did you start to work?'
            ],
            'WORK_DESCRIPTION' => [
                'is' => 'Vinnulýsing',
                'en' => 'Work description'
            ],
            'SELECT_WORK_DESCRIPTION' => [
                'is' => 'Vinnufyrirkomulag',
                'en' => 'Work Description'
            ],
            'GET_YOUR_LINK' => [
                'is' => 'Skoða útreikning!',
                'en' => 'Review salary!'
            ],
            'YOUR_LINK' => [
                'is' => 'Linkurinn þinn:',
                'en' => 'Your link:' 
            ],
            'HEADER_TOP' => [
                'is' => '<span>Reiknivél launa</span><small>Athuga hvort launaseðlar eru réttir!</small>',
                'en' => '<span>Calculate wages</span><small>You can check if your salary is correct here!</small>'
            ],
            'GRAY_WAVE_HEADER' => [
                'is' => 'Svaraðu spurningum', 
                'en' => 'Answer these questions!'
            ],
            'BIRTHDAY_DAY' => [
                'is' => 'Dagur',
                'en' => 'Day'
            ],
            'BIRTHDAY_MONTH' => [
                'is' => 'Mánuður',
                'en' => 'Month'
            ],
            'BIRTHDAY_YEAR' => [
                'is' => 'Ár',
                'en' => 'Year'
            ]
        ];
        
        $this->union_list = [
            '1' => 'AFL Starfsgreinafélag',
            '4' => 'Drífandi stéttarfélag',
            '7' => 'Framsýn stéttarfélag',
            '10' => 'Verkalýðsfélag Akraness',
            '13' => 'Verkalýðs- og sjómannafélag Bolungarvíkur',
            '16' => 'Verkalýðsfélag Snæfellinga',
            '19' => 'Verkalýðsfélag Þórshafnar',
            '2' => 'Aldan stéttarfélag',
            '5' => 'Efling stéttarfélag',
            '8' => 'Stéttarfélagið Samstaða',
            '11' => 'Verkalýðsfélag Grindavíkur',
            '14' => 'Verkalýðs- og sjómannafél. Keflavíkur og nágr.',
            '17' => 'Verkalýðsfélag Suðurlands',
            '3' => 'Báran stéttarfélag',
            '6' => 'Eining-Iðja',
            '9' => 'Stéttarfélag Vesturlands',
            '12' => 'Verkalýðsfélagið Hlíf',
            '15' => 'Verkalýðs- og sjómannafélag Sandgerðis',
            '18' => 'Verkalýðsfélag Vestfirðinga'
        ];
        
        $this->work_type = [
            [
                'name' => $this->translates['HEADER_WHERE_DO_YOU_WORK'][$this->lang],
                'code' => '-1',
                'is_hidden' => 0
            ],
            [
                'name' => $this->translates['GOVERMENT'][$this->lang],
                'code' => '0',
                'is_hidden' => 0
            ],
            [
                'name' => $this->translates['MUNICIPALITY'][$this->lang],
                'code' => '1',
                'is_hidden' => 0
            ],
             [
                'name' => $this->translates['MUNICIPALITY_IN_ICELAND'][$this->lang],
                'code' => '1a',
                'is_hidden' => 1
            ],
            [
                'name' => $this->translates['REY_CITY'][$this->lang],
                'code' => '3',
                'is_hidden' => 1
            ],
            [
                'name' => $this->translates['GEN_L_MARKET'][$this->lang],
                'code' => '2',
                'is_hidden' => 0
            ],
            [
                'name' => $this->translates['RIO'][$this->lang],
                'code' => '4',
                'is_hidden' => 1
            ] 
        ];
        
        $this->job_description_gov = [
            [
                'name' => $this->translates['SELECT_YOUR_JOB_DESCR'][$this->lang],
            ],
            [
                'name' => 'Launaflokkur nr. 1'
            ],
            [
                'name' => 'Launaflokkur nr. 10'
            ],
            [
                'name' => 'Launaflokkur nr. 11'
            ],
            [
                'name' => 'Launaflokkur nr. 13'
            ],
            [
                'name' => 'Launaflokkur nr. 14'
            ],
            [
                'name' => 'Launaflokkur nr. 15'
            ],
            [
                'name' => 'Launaflokkur nr. 16'
            ],
            [
                'name' => 'Launaflokkur nr. 17'
            ],
            [
                'name' => 'Launaflokkur nr. 18'
            ],
            [
                'name' => 'Launaflokkur nr. 19'
            ],
            [
                'name' => 'Launaflokkur nr. 2'
            ],
            [
                'name' => 'Launaflokkur nr. 20'
            ],
            [
                'name' => 'Launaflokkur nr. 21'
            ],
            [
                'name' => 'Launaflokkur nr. 22'
            ],
            [
                'name' => 'Launaflokkur nr. 23'
            ],
            [
                'name' => 'Launaflokkur nr. 24'
            ],
            [
                'name' => 'Launaflokkur nr. 25'
            ],
            [
                'name' => 'Launaflokkur nr. 26'
            ],
            [
                'name' => 'Launaflokkur nr. 27'
            ],
            [
                'name' => 'Launaflokkur nr. 28'
            ],
            [
                'name' => 'Launaflokkur nr. 29'
            ],
            [
                'name' => 'Launaflokkur nr. 3'
            ],
            [
                'name' => 'Launaflokkur nr. 30'
            ],
            [
                'name' => 'Launaflokkur nr. 31'
            ],
            [
                'name' => 'Launaflokkur nr. 32'
            ],
            [
                'name' => 'Launaflokkur nr. 33'
            ],
            [
                'name' => 'Launaflokkur nr. 34'
            ]
            ,
            [
                'name' => 'Launaflokkur nr. 35'
            ]
            ,
            [
                'name' => 'Launaflokkur nr. 36'
            ]
            ,
            [
                'name' => 'Launaflokkur nr. 37'
            ]
            ,
            [
                'name' => 'Launaflokkur nr. 38'
            ]
            ,
            [
                'name' => 'Launaflokkur nr. 39'
            ]
            ,
            [
                'name' => 'Launaflokkur nr. 4'
            ]
            ,
            [
                'name' => 'Launaflokkur nr. 40'
            ]
            ,
            [
                'name' => 'Launaflokkur nr. 41'
            ]
            ,
            [
                'name' => 'Launaflokkur nr. 42'
            ]
            ,
            [
                'name' => 'Launaflokkur nr. 43'
            ]
            ,
            [
                'name' => 'Launaflokkur nr. 44'
            ]
            ,
            [
                'name' => 'Launaflokkur nr. 45'
            ]
             ,
            [
                'name' => 'Launaflokkur nr. 5'
            ]
             ,
            [
                'name' => 'Launaflokkur nr. 6'
            ]
             ,
            [
                'name' => 'Launaflokkur nr. 7'
            ]
            ,
            [
                'name' => 'Launaflokkur nr. 8'
            ]
            ,
            [
                'name' => 'Launaflokkur nr. 9'
            ]
        ]; 
        usort($this->job_description_gov, [$this, 'compare']);
        
        $this->job_description_municipality = [
            [
                'name' => $this->translates['SELECT_YOUR_JOB_DESCR_MUNI'][$this->lang],
            ],
            [
                'name' => "Akstur fatlaðra/aldraðra / Launaflokkur 126"
            ],
            [
                'name' => "Aðstoð í eldhúsi/mötuneyti / Launaflokkur 117"
            ],
            [
                'name' => "Aðstoðarmatráður / Launaflokkur 123"
            ],
            [
                'name' => "Baðvörður í íþróttamannvirki / Launaflokkur 121"
            ],
            [
                'name' => "Birgðavörður / áhaldahús / Launaflokkur 119"
            ],
            [
                'name' => "Bókavörður I / Launaflokkur 124"
            ],
            [
                'name' => "Bókavörður II / Launaflokkur 130"
            ],
            [
                'name' => "Deildarstjóri heimaþjónustu / Félagaþjónusta / Launaflokkur 138"
            ],
            [
                'name' => "Deildarstjóri í leikskóla / Launaflokkur 136"
            ],
            [
                'name' => "Deildarstjóri í leikskóla / Launaflokkur 142"
            ],
            [
                'name' => "Félagsleg liðveisla I / Félagaþjónusta / Launaflokkur 124"
            ],
            [
                'name' => "Félagsleg liðveisla II / Félagaþjónusta / Launaflokkur 127"
            ],
            [
                'name' => "Félagsliði á dvalarheimili I / Félagaþjónusta / Launaflokkur 126"
            ],
            [
                'name' => "Félagsliði á dvalarheimili II / Félagaþjónusta / Launaflokkur 128"
            ],
            [
                'name' => "Félagsliði á heimili fyrir fatlað fólk / Félagaþjónusta / Launaflokkur 131"
            ],
            [
                'name' => "Félagsliði á hjúkrunaheimili I / Félagaþjónusta / Launaflokkur 130"
            ],
            [
                'name' => "Félagsliði á hjúkrunaheimili II / Félagaþjónusta / Launaflokkur 132"
            ],
            [
                'name' => "Félagsliði á hæfingastöð / Félagaþjónusta / Launaflokkur 131"
            ],
            [
                'name' => "Félagsliði í heimaþjónustu / Félagaþjónusta / Launaflokkur 130"
            ],
            [
                'name' => "Félagsliði í heimaþjónustu II (með flokkstjórn) / Félagaþjónusta / Launaflokkur 131"
            ],
            [
                'name' => "Félagsliði við dagvist aldraðra (aðhlynning og félagsstarf) / Félagaþjónusta / Launaflokkur 127"
            ],
            [
                'name' => "Félagsliði við félagsstarf aldraða  / Félagaþjónusta / Launaflokkur 127"
            ],
            [
                'name' => "Flokkstjóri á leikjanámskeiði / Launaflokkur 126"
            ],
            [
                'name' => "Floksstjóri vinnuskóla / Launaflokkur 126"
            ],
            [
                'name' => "Forstaða f.  dagvist aldraðra / Félagaþjónusta / Launaflokkur 133"
            ],
            [
                'name' => "Forstaða fyrir félagsstarf aldraða / Félagaþjónusta / Launaflokkur 133"
            ],
            [
                'name' => "Forstaða þvottahús  / Félagaþjónusta / Launaflokkur 130"
            ],
            [
                'name' => "Forstaða þvottahús (einyrki) / Félagaþjónusta / Launaflokkur 127"
            ],
            [
                'name' => "Forstöðumaður á gæsluvelli / Launaflokkur 136"
            ],
            [
                'name' => "Forstöðumaður íþróttamannvirkis I / Launaflokkur 130"
            ],
            [
                'name' => "Forstöðumaður íþróttamannvirkis II / Launaflokkur 132"
            ],
            [
                'name' => "Forstöðumaður æskulýðsmiðstöðvar I / Launaflokkur 139"
            ],
            [
                'name' => "Frístundaleiðbeinandi I / Launaflokkur 125"
            ],
            [
                'name' => "Gæslumaður á safni / Launaflokkur 117"
            ],
            [
                'name' => "Hafnarverkamaður / Launaflokkur 121"
            ],
            [
                'name' => "Heimaþjónusta I / Félagaþjónusta / Launaflokkur 118"
            ],
            [
                'name' => "Heimaþjónusta II / Félagaþjónusta / Launaflokkur 126"
            ],
            [
                'name' => "Heimaþjónusta III / Félagaþjónusta / Launaflokkur 128"
            ],
            [
                'name' => "Húsvörður I /  í grunnskóla / Launaflokkur 122"
            ],
            [
                'name' => "Húsvörður II /  í grunnskóla  / Launaflokkur 128"
            ],
            [
                'name' => "Húsvörður III /  í grunnskóla  / Launaflokkur 130"
            ],
            [
                'name' => "Húsvörður IV í grunnskóla / Launaflokkur 134"
            ],
            [
                'name' => "Jaðrlagnatæknir / áhaldahús / Launaflokkur 126"
            ],
            [
                'name' => "Leikskólaliði / Leikskóli / Launaflokkur 127"
            ],
            [
                'name' => "Lyftuvörður stólalyftu / áhaldahús / Launaflokkur 122"
            ],
            [
                'name' => "Matráður I / Launaflokkur 122"
            ],
            [
                'name' => "Matráður II / Launaflokkur 124"
            ],
            [
                'name' => "Matráður III / Launaflokkur 133"
            ],
            [
                'name' => "Matráður IV / Launaflokkur 136"
            ],
            [
                'name' => "Ræsting í grunnskóla / Launaflokkur 117"
            ],
            [
                'name' => "Safnvörður I / Launaflokkur 123"
            ],
            [
                'name' => "Safnvörður II / Launaflokkur 132"
            ],
            [
                'name' => "Sendill á bíl / Launaflokkur 120"
            ],
            [
                'name' => "Skólaliði (með ræstingu) /  í grunnskóla / Launaflokkur 124"
            ],
            [
                'name' => "Skólaliði /  í grunnskóla / Launaflokkur 124"
            ],
            [
                'name' => "Starfsmaður á gæsluvelli / Leikskóli / Launaflokkur 123"
            ],
            [
                'name' => "Starfsmaður á hafnarvog / Launaflokkur 118"
            ],
            [
                'name' => "Starfsmaður á heimili fyrir fatlað fólk I / Félagaþjónusta / Launaflokkur 122"
            ],
            [
                'name' => "Starfsmaður á heimili fyrir fatlað fólk II / Félagaþjónusta / Launaflokkur 128"
            ],
            [
                'name' => "Starfsmaður á heimili fyrir fatlað fólk III / Félagaþjónusta / Launaflokkur 133"
            ],
            [
                'name' => "Starfsmaður á hæfingarstöð / Félagaþjónusta / Launaflokkur 130"
            ],
            [
                'name' => "Starfsmaður á leikjanámskeiði / Launaflokkur 119"
            ],
            [
                'name' => "Starfsmaður á vinnustofu / Félagaþjónusta / Launaflokkur 125"
            ],
            [
                'name' => "Starfsmaður í býtibúri / Launaflokkur 117"
            ],
            [
                'name' => "Starfsmaður í skóla m. Stuðning /  í grunnskóla  / Launaflokkur 131"
            ],
            [
                'name' => "Starfsmaður í þvottahúsi / Félagaþjónusta / Launaflokkur 121"
            ],
            [
                'name' => "Starfsmaður íþróttamannvirkis / Launaflokkur 121"
            ],
            [
                'name' => "Starfsmaður við dagvist aldraðra (aðhlynning og félagsstarf) / Félagaþjónusta / Launaflokkur 124"
            ],
            [
                'name' => "Starfsmaður við félagsstarf aldraða / Félagaþjónusta / Launaflokkur 124"
            ],
            [
                'name' => "Starfsmaður/Leiðbeiandi í leikskóla / Launaflokkur 125"
            ],
            [
                'name' => "Stm. í leiksk. með stuðning I / Leikskóli / Launaflokkur 126"
            ],
            [
                'name' => "Stm. í leiksk. með stuðning II / Leikskóli / Launaflokkur 129"
            ],
            [
                'name' => "Stöðumælavörður / áhaldahús / Launaflokkur 122"
            ],
            [
                'name' => "Stuðningsfulltrúi í skóla / í grunnskóla / Launaflokkur 134"
            ],
            [
                'name' => "Sumarstarfsmaður / Launaflokkur 116"
            ],
            [
                'name' => "Sumarstarfsmaður-vélamaður / Launaflokkur 122"
            ],
            [
                'name' => "Sundlaugarvörður / Launaflokkur 126"
            ],
            [
                'name' => "Sundlaugarvörður með vakstjórn / Launaflokkur 128"
            ],
            [
                'name' => "Tækjamaður I / Launaflokkur 122"
            ],
            [
                'name' => "Tækjamaður II / Akstur / Launaflokkur 127"
            ],
            [
                'name' => "Umönnun á dvalarheimili I / Félagaþjónusta / Launaflokkur 125"
            ],
            [
                'name' => "Umönnun á dvalarheimili II / Félagaþjónusta / Launaflokkur 126"
            ],
            [
                'name' => "Umönnun á hjúkrunarheimili I / Félagaþjónusta / Launaflokkur 128"
            ],
            [
                'name' => "Umönnun á hjúkrunarheimili II / Félagaþjónusta / Launaflokkur 130"
            ],
            [
                'name' => "Vagnstjóri / Launaflokkur 126"
            ],
            [
                'name' => "Vélamaður skíðasvæðis / áhaldahús / Launaflokkur 127"
            ],
            [
                'name' => "Verkamaður I / áhaldahús / Launaflokkur 117"
            ],
            [
                'name' => "Verkamaður II / áhaldahús / Launaflokkur 121"
            ],
            [
                'name' => "Verkamaður III (með flokksstjórn) / áhaldahús / Launaflokkur 127"
            ],
            [
                'name' => "Verkamaður við sorphirðu / áhaldahús / Launaflokkur 119"
            ],
            [
                'name' => "Verkamaður við sorpmóttöku / áhaldahús / Launaflokkur 122"
            ],
            [
                'name' => "Verkstjóri í áhaldahúsi / áhaldahús / Launaflokkur 135"
            ],
            [
                'name' => "Verkstjóri í vinnuskóla / Launaflokkur 129"
            ],
            [
                'name' => "Yfirumsjón með lengdri viðveru I / í grunnskóla / Launaflokkur 133"
            ],
            [
                'name' => "Yfirumsjón með lengdri viðveru II / í grunnskóla / Launaflokkur 149"
            ]
        ];
        usort($this->job_description_municipality, [$this, 'compare']);
         
        $this->job_description_municipality1 = [
            [
                'name' => $this->translates['SELECT_YOUR_JOB_DESCR_MUNI'][$this->lang],
            ],
            [
                'name' => "Akstur fatlaðra/aldraðra / Stig 355 / Launaflokkur 126"
            ],
            [
                'name' => "Aðstoð í eldhúsi/mötuneyti / Stig 269 / Launaflokkur 117"
            ],
            [
                'name' => "Aðstoðarmatráður / Stig 325 / Launaflokkur 123"
            ],
            [
                'name' => "Aðstoðarmatráður í grunnskóla / Stig 338 / Launaflokkur 124"
            ],
            [
                'name' => "Aðstoðarmaður á vinnustofu (Bjarg-Iðjul.) / Stig 351 / Launaflokkur 125"
            ],
            [
                'name' => "Baðvörður í íþróttamannvirki / Stig 312 / Launaflokkur 121"
            ],
            [
                'name' => "Birgðavörður / Stig 292 / Launaflokkur 119"
            ],
            [
                'name' => "Bókavörður 1 / Stig 344 / Launaflokkur 124"
            ],
            [
                'name' => "Deildarstjóri í leikskóla I / Stig 443 / Launaflokkur 136"
            ],
            [
                'name' => "Deildarstjóri í leikskóla II / Stig 483 / Launaflokkur 142"
            ],
            [
                'name' => "Félagsleg liðveisla / Stig 338 / Launaflokkur 124"
            ],
            [
                'name' => "Félagsleg liðveisla II / Stig 371 / Launaflokkur 127"
            ],
            [
                'name' => "Félagsliði á dvalarheimili I / Stig 355 / Launaflokkur 126"
            ],
            [
                'name' => "Félagsliði á dvalarheimili II / Stig 378 / Launaflokkur 128"
            ],
            [
                'name' => "Félagsliði á hjúkrunarheimili / Stig 424 / Launaflokkur 133"
            ],
            [
                'name' => "Félagsliði á hjúkrunarheimili I / Stig 398 / Launaflokkur 130"
            ],
            [
                'name' => "Félagsliði á hjúkrunarheimili II / Stig 411 / Launaflokkur 132"
            ],
            [
                'name' => "Félagsliði á hæfingarstöð / Stig 414 / Launaflokkur 132"
            ],
            [
                'name' => "Félagsliði á sambýli aldraðra / Stig 401 / Launaflokkur 131"
            ],
            [
                'name' => "Félagsliði á sambýli II / Stig 401 / Launaflokkur 131"
            ],
            [
                'name' => "Félagsliði deild með heilabiluðum (hjúkrh.) / Stig 401 / Launaflokkur 131"
            ],
            [
                'name' => "Félagsliði í heimaþj. III (með flokkstjórn) / Stig 404 / Launaflokkur 131"
            ],
            [
                'name' => "Félagsliði í heimaþjónustu B / Stig 401 / Launaflokkur 131"
            ],
            [
                'name' => "Félagsliði í heimaþjónustu II / Stig 391 / Launaflokkur 130"
            ],
            [
                'name' => "Félagsliði í iðju og félagsstarfi aldraðra ÖA / Stig 384 / Launaflokkur 129"
            ],
            [
                'name' => "Félagsliði í þyngri þjónustu / Stig 447 / Launaflokkur 136"
            ],
            [
                'name' => "Félagsliði við dagvist aldraðra ÖA / Stig 381 / Launaflokkur 128"
            ],
            [
                'name' => "Félagsliði við félagsstarf aldraðra ÖA / Stig 384 / Launaflokkur 129"
            ],
            [
                'name' => "Flokksstjóri við félagsstarf aldraðra / Stig 423 / Launaflokkur 133"
            ],
            [
                'name' => "Flokkstjóri á leikjanámskeiði / Stig 361 / Launaflokkur 126"
            ],
            [
                'name' => "Forstaða fyrir dagvist aldraða / Stig 423 / Launaflokkur 133"
            ],
            [
                'name' => "Forstaða gæsluvalla / Stig 443 / Launaflokkur 136"
            ],
            [
                'name' => "Forstaða þvottahúss (einyrki) / Stig 368 / Launaflokkur 127"
            ],
            [
                'name' => "Forstaða þvottahúss / Stig 397 / Launaflokkur 130"
            ],
            [
                'name' => "Forstöðumaður á minni söfnun I / Stig 478 / Launaflokkur 141"
            ],
            [
                'name' => "Forstöðumaður íþróttamannvirkis 1 / Stig 396 / Launaflokkur 130"
            ],
            [
                'name' => "Forstöðumaður íþróttamannvirkis 2 / Stig 412 / Launaflokkur 132"
            ],
            [
                'name' => "Frekari liðveisla í heimaþjónustu B / Stig 384 / Launaflokkur 129"
            ],
            [
                'name' => "Frístundaleiðbeinandi 1 / Stig 348 / Launaflokkur 125"
            ],
            [
                'name' => "Frístundaleiðbeinandi 2 / Stig 424 / Launaflokkur 133"
            ],
            [
                'name' => "Gæsluaðili á safni / Stig 272 / Launaflokkur 117"
            ],
            [
                'name' => "Hafnarverkamaður / Stig 306 / Launaflokkur 121"
            ],
            [
                'name' => "Heimaþjónusta I / Stig 279 / Launaflokkur 118"
            ],
            [
                'name' => "Heimaþjónusta II Akureyri / Stig 381 / Launaflokkur 128"
            ],
            [
                'name' => "Heimaþjónusta III / Stig 374 / Launaflokkur 128"
            ],
            [
                'name' => "Húsvörður III (krafa um iðnmenntun) / Stig 391 / Launaflokkur 130"
            ],
            [
                'name' => "Húsvörður IV (iðnm./umsjón með ræstingum) / Stig 430 / Launaflokkur 134"
            ],
            [
                'name' => "Jarðlagnatæknir / Stig 355 / Launaflokkur 126"
            ],
            [
                'name' => "Leikskólaliði frá 1. maí 2015 / Stig 365 / Launaflokkur 127"
            ],
            [
                'name' => "Leiðbeinandi í vinnuskóla / Stig 358 / Launaflokkur 126"
            ],
            [
                'name' => "Matráður I / Stig 321 / Launaflokkur 122"
            ],
            [
                'name' => "Matráður í Grunnskóla / Stig 459 / Launaflokkur 138"
            ],
            [
                'name' => "Matráður II / Stig 344 / Launaflokkur 124"
            ],
            [
                'name' => "Matráður III / Stig 420 / Launaflokkur 133"
            ],
            [
                'name' => "Matráður IV / Stig 446 / Launaflokkur 136"
            ],
            [
                'name' => "Matreiðslumaður / Stig 492 / Launaflokkur 143"
            ],
            [
                'name' => "Ræsting / Stig 266 / Launaflokkur 117"
            ],
            [
                'name' => "Sendill á bíl / Stig 302 / Launaflokkur 120"
            ],
            [
                'name' => "Skólaliði (með ræstingu) / Stig 335 / Launaflokkur 124"
            ],
            [
                'name' => "Skólaliði / Stig 335 / Launaflokkur 124"
            ],
            [
                'name' => "Starfmaður á gæsluvelli / Stig 332 / Launaflokkur 123"
            ],
            [
                'name' => "Starfsm. á vinnustofu/iðnv.verkam./saumak. / Stig 391 / Launaflokkur 130"
            ],
            [
                'name' => "Starfsmaður á hafnarvog / Stig 282 / Launaflokkur 118"
            ],
            [
                'name' => "Starfsmaður á Hæfingarstöð / Stig 394 / Launaflokkur 130"
            ],
            [
                'name' => "Starfsmaður á leikjanámskeiði / Stig 289 / Launaflokkur 119"
            ],
            [
                'name' => "Starfsmaður á leikskóla / Stig 345 / Launaflokkur 125"
            ],
            [
                'name' => "Starfsmaður á sambýli aldraðra / Stig 381 / Launaflokkur 128"
            ],
            [
                'name' => "Starfsmaður á sambýli fatlaðra I / Stig 315 / Launaflokkur 122"
            ],
            [
                'name' => "Starfsmaður á sambýli fatlaðra II / Stig 381 / Launaflokkur 128"
            ],
            [
                'name' => "Starfsmaður á sambýli fatlaðra III / Stig 421 / Launaflokkur 133"
            ],
            [
                'name' => "Starfsmaður á vinnustofu / Stig 351 / Launaflokkur 125"
            ],
            [
                'name' => "Starfsmaður Gránufélagsteymis / Stig 394 / Launaflokkur 130"
            ],
            [
                'name' => "Starfsmaður í býtibúri / Stig 272 / Launaflokkur 117"
            ],
            [
                'name' => "Starfsmaður í dagvist og félagsstarfi aldraðra / Stig 338 / Launaflokkur 124"
            ],
            [
                'name' => "Starfsmaður í iðju og félagsstarfi aldraðra ÖA / Stig 364 / Launaflokkur 127"
            ],
            [
                'name' => "Starfsmaður í leikskóla / Stig 345 / Launaflokkur 125"
            ],
            [
                'name' => "Starfsmaður í leikskóla með stuðning I / Stig 355 / Launaflokkur 126"
            ],
            [
                'name' => "Starfsmaður í leikskóla með stuðning II / Stig 388 / Launaflokkur 129"
            ],
            [
                'name' => "Starfsmaður í sérskóla með stuðning / Stig 417 / Launaflokkur 132"
            ],
            [
                'name' => "Starfsmaður í skammtímavistun / Stig 394 / Launaflokkur 130"
            ],
            [
                'name' => "Starfsmaður í skóla með stuðning / Stig 407 / Launaflokkur 131"
            ],
            [
                'name' => "Starfsmaður í þvottahúsi / Stig 312 / Launaflokkur 121"
            ],
            [
                'name' => "Starfsmaður íþróttamannvirkis / Stig 312 / Launaflokkur 121"
            ],
            [
                'name' => "Starfsmaður við dagvist aldraðra ÖA / Stig 351 / Launaflokkur 125"
            ],
            [
                'name' => "Starfsmaður við félagsstarf aldraðra ÖA / Stig 364 / Launaflokkur 127"
            ],
            [
                'name' => "Stjórn vinnuvéla og Malbikunarst. hjá FRA / Stig 407 / Launaflokkur 131"
            ],
            [
                'name' => "Stöðumælavörður / Stig 318 / Launaflokkur 122"
            ],
            [
                'name' => "Stuðningsfulltrúi í sérskóla / Stig 437 / Launaflokkur 135"
            ],
            [
                'name' => "Stuðningsfulltrúi í skóla / Stig 427 / Launaflokkur 134"
            ],
            [
                'name' => "Sumarstarfsmaður - vélamaður / Stig 316 / Launaflokkur 122"
            ],
            [
                'name' => "Sumarstarfsmaður / Stig 260 / Launaflokkur 117"
            ],
            [
                'name' => "Sundlaugarvörður (með vaktstjórn) / Stig 374 / Launaflokkur 129"
            ],
            [
                'name' => "Sundlaugarvörður / Stig 361 / Launaflokkur 128"
            ],
            [
                'name' => "Tækjamaður I / Stig 319 / Launaflokkur 122"
            ],
            [
                'name' => "Tækjamaður II / Stig 371 / Launaflokkur 127"
            ],
            [
                'name' => "Umönnun á dvalarheimili I / Stig 345 / Launaflokkur 125"
            ],
            [
                'name' => "Umönnun á dvalarheimili II / Stig 358 / Launaflokkur 126"
            ],
            [
                'name' => "Umönnun á hjúkrunarheimili I / Stig 378 / Launaflokkur 128"
            ],
            [
                'name' => "Umönnun á hjúkrunarheimili I/flakkari / Stig 391 / Launaflokkur 130"
            ],
            [
                'name' => "Vaktstjóri á sambýli / Stig 394 / Launaflokkur 130"
            ],
            [
                'name' => "Vélamaður skíðasvæði / Stig 371 / Launaflokkur 127"
            ],
            [
                'name' => "Verkamaður I / Stig 270 / Launaflokkur 117"
            ],
            [
                'name' => "Verkamaður II / Stig 309 / Launaflokkur 121"
            ],
            [
                'name' => "Verkamaður III (með flokkstjórn) / Stig 368 / Launaflokkur 127"
            ],
            [
                'name' => "Verkamaður við sorphirðu / Stig 293 / Launaflokkur 119"
            ],
            [
                'name' => "Verkamaður við sorpmóttöku / Stig 319 / Launaflokkur 122"
            ],
            [
                'name' => "Verkstjóri í áhaldahúsi / Stig 436 / Launaflokkur 135"
            ],
            [
                'name' => "Verkstjóri í vinnuskóla / Stig 390 / Launaflokkur 129"
            ],
            [
                'name' => "Yfirumsjón með lengri viðveru I / Stig 420 / Launaflokkur 133"
            ],
            [
                'name' => "Yfirumsjón með lengri viðveru II / Stig 533 / Launaflokkur 149"
            ]
        ];
        usort($this->job_description_municipality1, [$this, 'compare']);
       
        $this->rey_city = [
            [
                'name' => $this->translates['SELECT_YOUR_JOB_DESCR_REY_CITY'][$this->lang],
            ],
            [
                'name' => "ÍTR - Næturvörður - 325"
            ],
            [
                'name' => "MOF - Dagræsting - 266"
            ],
            [
                'name' => "SBB - Ræstitæknir dagvinna - 266"
            ],
            [
                'name' => "SFS - Aðstoðarmaður í eldhúsi - 325"
            ],
            [
                'name' => "SFS - Deildarstjóri C - 489"
            ],
            [
                'name' => "SFS - Leikskólaliði - 378"
            ],
            [
                'name' => "SFS - Leikskólaliði með stuðning - 391"
            ],
            [
                'name' => "SFS - Leiðbeinandi 1 - 335"
            ],
            [
                'name' => "SFS - Leiðbeinandi 1 með stuðning - 371"
            ],
            [
                'name' => "SFS - Leiðbeinandi 2 - 365"
            ],
            [
                'name' => "SFS - Leiðbeinandi 2 með stuðning - 391"
            ],
            [
                'name' => "SFS - Skólaliði í eldhús - 348"
            ],
            [
                'name' => "SFS - Starfsmaður 2 - 322"
            ],
            [
                'name' => "SFS - Starfsmaður 2 með stuðning - 358"
            ],
            [
                'name' => "SFS - Yfirmaður mötuneytis leikskóla.- 453"
            ],
            [
                'name' => "SÞR - Aðstoðarmaður í mötuneyti - 302"
            ],
            [
                'name' => "SÞR - Umsjónarmaður matstofu - 302"
            ],
            [
                'name' => "USK - Afleysingaflokkstjóri - 392"
            ],
            [
                'name' => "USK - Dráttarvélarstjóri - 355"
            ],
            [
                'name' => "USK - Flokkstjóri II - 450"
            ],
            [
                'name' => "USK - Flokkstjóri við sorphirðu - 433"
            ],
            [
                'name' => "USK - Kaffiumsjónarmaður - 302"
            ],
            [
                'name' => "USK - Sérhæfður verkamaður - 342"
            ],
            [
                'name' => "USK - Verkamaður við bæjarframkvæmdir - 309"
            ],
            [
                'name' => "USK - Verkamaður við garðyrkju - 309"
            ],
            [
                'name' => "USK - Verkamaður við sorphirðu - 306"
            ],
            [
                'name' => "VEL - Aðstoðar matreiðslumaður - 342"
            ],
            [
                'name' => "VEL - Félagsliði í búsetuþjónustu - 414"
            ],
            [
                'name' => "VEL - Félagsliði í Gistiskýli - 444"
            ],
            [
                'name' => "VEL - Félagsliði í heimaþjónustu - 391"
            ],
            [
                'name' => "VEL - Félagsliði í umönnun - 411"
            ],
            [
                'name' => "VEL - Félagsliði þjónustukjarna"
            ],
            [
                'name' => "VEL - Flokkstjóri félagsleg heimaþjónusta - 459"
            ],
            [
                'name' => "VEL - Matráður - vistheimili barna - 391"
            ],
            [
                'name' => "VEL - Ræstitæknir dagvinna - 266"
            ],
            [
                'name' => "VEL - Starfsmaður búsetuþjónustu - 381)"
            ],
            [
                'name' => "VEL - Starfsmaður framreiðslueldhúss - 299"
            ],
            [
                'name' => "VEL - Starfsmaður heimaþjónustu  - 361"
            ],
            [
                'name' => "VEL - Starfsmaður málefni utangarðsfólks - 411"
            ],
            [
                'name' => "VEL - Starfsmaður móttökueldhúss - 282"
            ],
            [
                'name' => "VEL - Starfsmaður umönnun  - 368"
            ],
            [
                'name' => "VEL - Starfsmaður umsjón í eldhús - 397"
            ],
            [
                'name' => "VEL - Starfsmaður vistheimilis - 401"
            ],
            [
                'name' => "VEL - Starfsmaður viðbragðsteymis - 447"
            ],
            [
                'name' => "VEL - Starfsmaður þjónustukjarna - 407"
            ],
            [
                'name' => "VEL - Starfsmaður þvottahúss - 266"
            ]
        ];
        usort($this->rey_city, [$this, 'compare']);
        
        
        $this->general_labour_market = [
            [
                'name' => $this->translates['SELECT_YOUR_JOB_DESCR_GEN_LABOUR'][$this->lang],
            ],
            [
                'name' => "Bílstjórar á ökutækjum sem krefjast aukinna ökuréttinda. / Launaflokkur 13"
            ],
            [
                'name' => "Bor og hleðslumenn í jarðgöngum ( borflokkur). / Launaflokkur 13"
            ],
            [
                'name' => "Fiskeldisfræðingar frá Hólaskóla / Launaflokkur 17"
            ],
            [
                'name' => "Fisktæknar sem lokið hafa námi frá Fisktækniskóla Íslands í Grindavík. / Launaflokkur 13"
            ],
            [
                'name' => "Hópferðabílstjórar. / Launaflokkur 17"
            ],
            [
                'name' => "Matráðar sem stjórna einum eða fleiri aðstoðarmönnum. / Launaflokkur 10"
            ],
            [
                'name' => "Mjólkurbílstjórar. / Launaflokkur 11"
            ],
            [
                'name' => "Sérhæft fiskvinslufólk eftir námskeið 2 og búin að starfa 7 ár hjá sama fyrirtæki. / Launaflokkur 11"
            ],
            [
                'name' => "Tamningamaður með tveggja ára nám frá Háskólanum á Hólum eða sambærilegt nám. / Launaflokkur 17"
            ],
            [
                'name' => "Tamningamenn með reynslu. / Launaflokkur 10"
            ],
            [
                'name' => "Tækjastjórnandi I: Tækjamenn á tækjum sem krefjast frumnámskeiðs samkvæmt reglum um réttindi til að stjórna vinnuvélum. / Launaflokkur 10"
            ],
            [
                'name' => "Tækjastjórnandi II: Tækjamenn á tækjum sem krefjast grunnnámskeiðs eða framhaldsnámskeiðs samkvæmt reglum um réttindi til að stjórna vinnuvélum."
            ],
            [
                'name' => "Almenn vinna þ.m.t. pakkhúsvinna, vinna í frystigeymslu, vinna í frystilestum skipa, vindu- og lúgumenn, hliðverðir, gámatæming, gámafylling og gámahreinsun. / Launaflokkur 6"
            ],
            [
                'name' => "Almennir byggingaverkamenn. / Launaflokkur 6"
            ],
            [
                'name' => "Almennir sorphirðumenn. / Launaflokkur 6"
            ],
            [
                'name' => "Almennir starfsmenn afurðastöðva. / Launaflokkur 9"
            ],
            [
                'name' => "Almennt fiskvinnslufólk. / Launaflokkur 5"
            ],
            [
                'name' => "Almennt iðnverkafólk. / Launaflokkur 4"
            ],
            [
                'name' => "Almennt starfsfólk veitinga- og gistihúsa. / Launaflokkur 5"
            ],
            [
                'name' => "Almennt starfsfólk við fiskeldi. / Launaflokkur 5"
            ],
            [
                'name' => "Almennt verkafólk. / Launaflokkur 4"
            ],
            [
                'name' => "Aðstoðarfólk án reynslu við tamningar. / Launaflokkur 4"
            ],
            [
                'name' => "Aðstoðarfólk í mötuneytum. / Launaflokkur 4"
            ],
            [
                'name' => "Iðnverkafólk 2: Sérhæft iðnverkafólk sem unnið getur sjálfstætt og fela má tímabundna verkefnastjórnun. / Launaflokkur 6"
            ],
            [
                'name' => "Kjarasamningur SGS og SA vegna veitinga-, gisti-, þjónustu- og greiðasölustaða, afþreyingarfyrirtækja og hliðstæðrar starfsemi"
            ],
            [
                'name' => "Matráðar. / Launaflokkur 6"
            ],
            [
                'name' => "Móttökustjórar og flokksstjórar. / Launaflokkur 9"
            ],
            [
                'name' => "Ræsting. / Launaflokkur 6"
            ],
            [
                'name' => "Ræstingafólk í vaktavinnu. / Launaflokkur 6"
            ],
            [
                'name' => "Sauðfjárslátrun S1: (Almennir starfsmenn í sláturhúsum). / Launaflokkur 4"
            ],
            [
                'name' => "Sauðfjárslátrun S2: (Vinna slátrara, skotmanna, skurðarborðsmanna, fyrirristumanna, fláningsmanna, innanúrtökumanna og vinna við gortæmingu ávömbum, vinna í frystiklefum og við flutning á kjöti úr eða í frystiklefa). / Launaflokkur 4"
            ],
            [
                'name' => "Sauðfjárslátrun S3: (Starfsmenn með mikla starfsreynslu við slátrun,sem lokið hafa sérstöku 6 vikna námskeiði, þar af að hluta bóklegu námi í iðnskóla og verklegri þjálfun í svína- og nautgripaslátrun í Hróarskeldu eða sambærilegu námi innanlands að mati samningsaðila). / Launaflokkur 4"
            ],
            [
                'name' => "Sérhæft fiskvinnslufólk eftir námskeið 2. / Launaflokkur 9"
            ],
            [
                'name' => "Sérhæft fiskvinnslufólk. / Launaflokkur 7"
            ],
            [
                'name' => "Sérhæft starfsfólk í kjötvinnslum með námskeiði. / Launaflokkur 6"
            ],
            [
                'name' => "Sérhæft starfsfólk við fiskeldi. / Launaflokkur 7"
            ],
            [
                'name' => "Sérhæfðir aðstoðarmenn iðnaðarmanna með mikla faglega reynslu þ.m.t. á járn- og vélaverkstæðum. / Launaflokkur 9"
            ],
            [
                'name' => "Sérhæfðir sorphirðumenn. / Launaflokkur 8"
            ],
            [
                'name' => "Sérþjálfaðir byggingaverkamenn. / Launaflokkur 8"
            ],
            [
                'name' => "Sérþjálfaðir starfsmenn hótela og veitingahúsa sem geta unnið sjálfstætt,sýna frumkvæði og fela má tímabundna verkefnaumsjón. / Launaflokkur 6"
            ],
            [
                'name' => "Starfsfólk í alifuglaslátrun. / Launaflokkur 4"
            ],
            [
                'name' => "Starfsfólk í stórgripaslátrun. / Launaflokkur 4"
            ],
            [
                'name' => "Starfsmenn á bensínafgreiðslustöðum sem jafnhliða sinna úti- og kassastörfum og vinna að staðaldri hluta hverrar vaktar við afgreiðslustörf í verslun og á kassa. / Launaflokkur 7"
            ],
            [
                'name' => "Starfsmenn sem sinna afgreiðslustörfum á bensínafgreiðslustöðum ásamt öðrum störfum / Launaflokkur 7"
            ],
            [
                'name' => "Starfsmenn sem sinna útistörfum og afgreiðslu á bensínafgreiðslustöðum. / Launaflokkur 6"
            ],
            [
                'name' => "Tímakaupsfólk í tilfallandi vinnu á veitinga- og gistihúsum (ekki vinnuskylda). Ekki vaktavinna. / Launaflokkur 4"
            ],
            [
                'name' => "Vaktmenn. / Launaflokkur 4"
            ],
            [
                'name' => "Vaktstjórar (kassamenn) sem sérstaklega eru ráðnir sem umsjónarmenn á vakt auk þess að sinna sölu og kassastörfum. / Launaflokkur 9"
            ],
            [
                'name' => "Verkamenn á smurstöðvum, ryðvarnarskálum og dekkja-, bifreiða-, járn-og vélaverkstæðum. / Launaflokkur 6"
            ]
        ];
        usort($this->general_labour_market, [$this, 'compare']);
        $this->goverment_expirence = [
            [
                'name' => 'Basic wages',
                'name_is' => 'Grunnlaun',
                'code' => '1'
            ],
            [
                'name' => '(Step 1)',
                'name_is' => 'Þrep 1',
                'code' => '2'
            ],
            [
                'name' => '(Step 2)',
                'name_is' => 'Þrep 2',
                'code' => '3'
            ],
            [
                'name' => '(Step 3)',
                'name_is' => 'Þrep 3',
                'code' => '4'
            ],
            [
                'name' => '(Step 4)',
                'name_is' => 'Þrep 4',
                'code' => '5'
            ],
            [
                'name' => '(Step 5)',
                'name_is' => 'Þrep 5',
                'code' => '6'
            ],
            [
                'name' => '(Step 6)',
                'name_is' => 'Þrep 6',
                'code' => '7'
            ],
            [
                'name' => '(Step 7)',
                'name_is' => 'Þrep 7',
                'code' => '8'
            ]
        ];
        
        $this->municipal_expirence = [
            [
                'name' => 'Basic salary',
                'name_is' => 'Grunnlaun',
                'code' => '1'
            ],
            [
                'name' => 'Personal Strain 2%',
                'name_is' => 'Persónuálag 2%',
                'code' => '2'
            ],
            [
                'name' => 'Personal Strain 4%',
                'name_is' => 'Persónuálag 4%',
                'code' => '3'
            ],
            [
                'name' => 'Personal Strain 6%',
                'name_is' => 'Persónuálag 6%',
                'code' => '4'
            ],
            [
                'name' => 'Personal Strain 8%',
                'name_is' => 'Persónuálag 8%',
                'code' => '5'
            ],
            [
                'name' => 'Personal Strain 10%',
                'name_is' => 'Persónuálag 10%',
                'code' => '6'
            ],
            [
                'name' => 'Personal Strain 12%',
                'name_is' => 'Persónuálag 12%',
                'code' => '7'
            ],
            [
                'name' => 'Personal Strain 14%',
                'name_is' => 'Persónuálag 14%',
                'code' => '8'
            ]
        ];
        
        $this->rey_city_expirence = [
            [
                'name' => 'Less than one year',
                'name_is' => 'Styttra en 1 ár',
                'code' => '1'
            ],
            [
                'name' => 'Between 1-3 years',
                'name_is' => 'Milli 1-3 ár',
                'code' => '2'
            ],
            [
                'name' => 'Between 3-5 years',
                'name_is' => 'Milli 3-5 ár',
                'code' => '3'
            ],
            [
                'name' => 'Between 5-7 years',
                'name_is' => 'Milli 5-7 ár',
                'code' => '4'
            ],
            [
                'name' => 'Between 7-9 years',
                'name_is' => 'Milli 7-9 ár',
                'code' => '5'
            ]
        ];
        
        $this->general_labour_market_expirence = [
             [
                'name' => 'When did you start to work',
                'name_is' => 'Starfsaldur',
                'code' => '-1',
                'is_hidden' => 0
            ],
            [
                'name' => 'Less than 6 months',
                'name_is' => 'Minna en 6 mánuðir',
                'code' => '1',
                'is_hidden' => 1
            ],
            [
                'name' => 'Less than one year',
                'name_is' => 'Styttri en 1 ár.',
                'code' => '1',
                'is_hidden' => 0
            ],
            [
                'name' => 'Between 1-3 years',
                'name_is' => '1-3 ár',
                'code' => '2',
                'is_hidden' => 0
            ],
            [
                'name' => 'Between 3-5 years',
                'name_is' => '3-5 ár',
                'code' => '3',
                'is_hidden' => 0
            ],
            [
                'name' => 'Longer than 5 years',
                'name_is' => 'Meira en 5 ár',
                'code' => '4',
                'is_hidden' => 0
            ]
        ];
        
        $this->last_selelect_calc_type = [      
            /* [
                'name' => 'Work Description',
                'name_is' => 'Veldu verklýsingu', 
                'code' => '-1',
                'is_hidden' => 0
            ],*/
            [
                'name' => 'Hourly salary',
                'name_is' => 'Tímavinna',
                'code' => 'customcalc6',
                'is_hidden' => 1
            ],
            [
                'name' => 'Daytime',
                'name_is' => 'Dagvinna',
                'code' => 'customcalc4',
                'is_hidden' => 0
            ],
            [
                'name' => 'Shifts',
                'name_is' => 'Vaktavinna',
                'code' => 'customcalc5',
                'is_hidden' => 0
            ]
        ];
    }

    private function compare($a, $b)
    {
        //$alphabet = 'aąbcćdeęfghijklłmnnoóqprstuvwxyzźż'; 
        $alphabet =  'aábcdðeéfghiíjklmnoópqrstuúvwxyýzþæö';
        
        $a = mb_strtolower($a['name']);
        $b = mb_strtolower($b['name']);

        for ($i = 0; $i < mb_strlen($a); $i++) {
            if (mb_substr($a, $i, 1) == mb_substr($b, $i, 1)) {
                continue;
            }
            if ($i > mb_strlen($b)) {
                return 1;
            }
            if (mb_strpos($alphabet, mb_substr($a, $i, 1)) > mb_strpos($alphabet, mb_substr($b, $i, 1))) {
                return 1;
            } else {
                return -1;
            }
        }
    }
    
    
}