'use strict';

let 
    curiotimeReg = {
        "class": "curiotime-calc-widget",
        "name": "curiotime-calc-widget"
    },
    red_addon_node = document.createElement('div'),
    image_block = document.createElement('div'),
    
    domain = 'https://uxd.curiotime.com',
    widget_path = '/calculator_widget_verkos',
    path = domain + widget_path
;
red_addon_node.classList.add('right_widget_addon');

//adding css
let cssId = 'curiotime-calc-widget-style';  
if (!document.getElementById(cssId))
{ 
    let 
        head = document.getElementsByTagName('head')[0],
        link = document.createElement('link');

    link.id = cssId; 
    link.rel = 'stylesheet';
    link.type = 'text/css';
    link.href = path + '/styles/calc_widget_load.css';
    link.media = 'all';
    head.appendChild(link);
}

let 
    jquery = document.createElement('script'),
    migrate = document.createElement('script'),
    trigger_script = document.createElement('script');
    
jquery.setAttribute('src', 'https://code.jquery.com/jquery-3.5.1.min.js');
document.head.appendChild(jquery);



setTimeout(function(){
    migrate.setAttribute('src', 'https://code.jquery.com/jquery-migrate-1.4.1.min.js');
    document.head.appendChild(migrate);

    trigger_script.setAttribute('src', path + '/js/calc_widget_trigger.js');
    document.head.appendChild(trigger_script);
}, 1000);





//adding icon for trigger widget
image_block.classList.add('curiotime-calc-widget-wrapper');


document.body.appendChild(image_block);

curiotimeReg.script = document.currentScript || Array.prototype.slice.call(document.getElementsByTagName('script')).pop();
curiotimeReg.boxId = curiotimeReg.script.getAttribute('data-boxid');
curiotimeReg.lang = curiotimeReg.script.getAttribute('data-lang');
if (curiotimeReg.lang == 'is') {
    image_block.innerHTML = '<img src="' + path + '/img/full_icon.png" alt="" class="img_widget_trigger calc_icon js_event_iframe_trigger"/>';
} else{
    image_block.innerHTML = '<img src="' + path + '/img/full_icon_en_compressed.png" alt="" class="img_widget_trigger calc_icon js_event_iframe_trigger"/>';
}

if (curiotimeReg.lang == 'is') {
    curiotimeReg.url = path + "/calculator_widget.php?lang=is";

    red_addon_node.innerHTML = '<div class="chat_msg js_event_link is_msg">Skoða reiknivél</div>';
} else {
    curiotimeReg.url = path + "/calculator_widget.php?lang=en";

    red_addon_node.innerHTML = '<div class="chat_msg js_event_link en_msg">Forward to calculator</div>';
}

curiotimeReg.init = function () {
    window.addEventListener("message", curiotimeReg.receiveMessage, false);
    curiotimeReg.cereateIframe();
};
curiotimeReg.receiveMessage = function (event) {
    try {
        let h = event.data.height;
        curiotimeReg.iframe.style.height = h + "px";
    } catch (e) {
        
    }
};
curiotimeReg.cereateIframe = function () {
    curiotimeReg.iframe = document.createElement("iframe");
    curiotimeReg.iframe.src = curiotimeReg.url;
    curiotimeReg.iframe.name = curiotimeReg.name;
    curiotimeReg.iframe.classList.add(curiotimeReg.class);
    curiotimeReg.iframe.style.height = "100%";
    curiotimeReg.iframe.style.width = "100%";
    curiotimeReg.iframe.frameBorder = "0";
    curiotimeReg.iframe.id = "widget-iframe";
    //curiotimeReg.iframe.scrolling = "no";
    curiotimeReg.box = document.getElementById(curiotimeReg.boxId);
    document.getElementById(curiotimeReg.boxId).classList.add('iframe_wrapper');
    curiotimeReg.box.appendChild(curiotimeReg.iframe); 
    curiotimeReg.box.appendChild(red_addon_node);//adding red addon
    
   
};
curiotimeReg.init();

