<?php
define( '_JEXEC', 1 );
define('JPATH_BASE', dirname(__FILE__));
define('DS', DIRECTORY_SEPARATOR);
$path = JPATH_BASE . DS . 'includes' . DS;

require($path . 'defines.php');
require($path . 'framework.php');
$app = JFactory::getApplication('site');
$app->initialise();


class AutoLogout {

    public function __construct($db) 
    {
        $this->db = $db;
        $this->time = time();
    }

    public function getPrepareUserList()
    {
        $date=date('Y-m-d', $this->time);
        
        /////////////////////////////////////////////////////////////////////////////////////////
        $text_log='script: \auto_logout\auto_logout.class.php';
        $text_log.=' method getPrepareUserList';
        $text_log.=' date: '.$date;
        file_put_contents(JPATH_BASE.DS.'auto_logout_log.txt', "\r\n".$text_log, FILE_APPEND);
        /////////////////////////////////////////////////////////////////////////////////////////
        
        $query = "SELECT * FROM #__audit_time_confirm WHERE `date`='$date' AND `date_exit`='0000-00-00 00:00:00' ORDER BY `id_user` DESC";
        $this->db->setQuery($query);
        $res = $this->db->loadObjectList();
        return $res;
    }
    
    public function logoutUsers()
    {
       $users_list=$this->getPrepareUserList();
       
       /////////////////////////////////////////////////////////////////////////////////////////
       $text_log='script: \auto_logout\auto_logout.class.php';
       $text_log.=' method logoutUsers';
       $text_log.=' $users_list: '.print_r($users_list, true);
       file_put_contents(JPATH_BASE.DS.'auto_logout_log.txt', "\r\n".$text_log, FILE_APPEND);
       /////////////////////////////////////////////////////////////////////////////////////////
       
       foreach($users_list as $user){
           $password=$this->getPassword($user->id_user);
           $this->stopTime($password);
       }
    }
    
    public function createLogRecord($u_id, $date_exit)
    {
        $item = new stdClass;
        $item->id = null;
        $item->id_user = (int)$u_id;
        $item->time = time();//time=date_triggered. date_triggered added for convenience
        $item->date_exit=$date_exit;
        $item->date_triggered=date('Y-m-d H:i:s');//time=date_triggered. date_triggered added for convenience
        
        $this->db->insertObject( '#__auto_logout_log', $item, 'id' );
    }
    
    private function getPassword($user_id)
    {
        $query = "SELECT `password2` FROM #__users WHERE `id` = '$user_id' ";
        $this->db->setQuery($query);
        $res = $this->db->loadResult();
        
        /////////////////////////////////////////////////////////////////////////////////////////
        $text_log='script: \auto_logout\auto_logout.class.php';
        $text_log.=' method getPassword';
    
        file_put_contents(JPATH_BASE.DS.'auto_logout_log.txt', "\r\n".$text_log, FILE_APPEND);
       /////////////////////////////////////////////////////////////////////////////////////////
       
        return $res;
    }
    
    private function stopTime($password)
    {       
        $current_date = date('Y-m-d');
        $date_exit = date('Y-m-d H:i:s');

        $query = "SELECT `id` FROM #__users WHERE `password2` = '$password'";
        $this->db->setQuery($query);
        $u_id = $this->db->loadResult();
        //print_r($query);
        
        $itemU = new stdClass;
        $itemU->id = $u_id;
        $itemU->start_time = 0;
        $itemU->status_user = 3;
        $this->db->updateObject( '#__users', $itemU, 'id' );

        // Check If user is stamped in
        $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$u_id' AND `date` = '$current_date' ORDER BY `id` DESC";
        $this->db->setQuery( $query );
        $data = $this->db->loadObject();
        
        /////////////////////////////////////////////////////////////////////////////////////////
        $text_log='script: \auto_logout\auto_logout.class.php';
        $text_log.=' method stopTime';
        $text_log.=' $current_date: '.$current_date.' $u_id: '.$u_id.' $data: '.print_r($data, true);
        
        /////////////////////////////////////////////////////////////////////////////////////////
       
        // Check if stamped in
        if(!empty($data->id) && !empty($data->date))
        {
            // Check if not stamped out
            if ($data->date_exit == 0){        
                // Find latest date and updat exit date           
                $query = "UPDATE #__audit_time_confirm SET `date_exit` = '$date_exit' WHERE `id_user` = '$u_id' AND `date` = '$current_date' AND `id` = '$data->id'";
                $this->db->setQuery($query);
                              
                if($this->db->query() && !empty($u_id)){
                    //echo $u_id;
                    $this->createLogRecord($u_id, $date_exit);
                    //start time in cron start time(23:59)
                    $res_check=$this->checkTotalWorkHours($data);
                    $this->check14Hours($data);
                    
                    $text_log.=' $res_chec='.print_r($res_check, true);
                    file_put_contents(JPATH_BASE.DS.'auto_logout_log.txt', "\r\n".$text_log, FILE_APPEND);
                    
                    if($res_check['res']=='success'){
                        $this->reLogin($u_id, $password);
                    }
                  

                } else{
                    echo 'not';
                }
            }
        }
    }
    
    public function checkTotalWorkHours($data)
    {
        $date_logged_obj=DateTime::createFromFormat('Y-m-d H:i:s', $data->date_logged);
        
        if($date_logged_obj->format('H:i') > '01:00'){
            $res='success';
        } else{
            $res='none';
            
            $query = "UPDATE #__audit_time_confirm SET `is_auto_logout` = '1' WHERE `id` = '$data->id'";
            $this->db->setQuery($query);                      
            $this->db->query();
        }
        
        $final_array=[
            'res'=>$res,
            'query'=>$query,
            'date_logged'=>$date_logged_obj->format('H:i')
        ];
        
        return $final_array;
    }
    
    public function check14Hours($data)
    {
        $date_logged_obj=DateTime::createFromFormat('Y-m-d H:i:s', $data->date_logged);
        
        if($date_logged_obj->format('H:i') < '08:00'){
            $res='success';
        } else{
            $res='none';
            
            $query = "UPDATE #__audit_time_confirm SET `border_14_hours` = '1' WHERE `id` = '$data->id'";
            $this->db->setQuery($query);                      
            $this->db->query();
        }
        
        $final_array=[
            'res'=>$res,
            'query'=>$query,
            'date_logged'=>$date_logged_obj->format('H:i')
        ];
        
        return $final_array;
    }
    
    public function reLogin($u_id, $password)
    {
        $info=$this->getUserInfo($u_id);
        $company=$info->company;
        $owner_id=$info->owner_id;
        
        $this->startTime($company, $owner_id, $password);
        
        echo '<pre>';
        print_r($info);
        echo '</pre>';
    }
    
    private function getUserInfo($u_id)
    {
        //echo 'getCompany';
        $query = "SELECT `company`, `owner_id` FROM #__users WHERE `id` = '$u_id'";
        $this->db->setQuery( $query );
        $data = $this->db->loadObjectList();
        
        return $data;
    }
    
    private function startTime($company, $owner_id, $password) {  
       // exit;
        // Get User By Password
        //$company = "";
        //$ownerID = "";
        
        //$password = $_POST['password'];
        $ids = $this->getUser($company, $owner_id, $password);
        /*echo '<pre>';
        print_r($ids);
        echo '</pre>';*/
               
        $u_id = $ids->id;
        $owner_id = $ids->owner_id;
        
        $lat='0';
        $lng='0';
        $note='';
      
        if(!empty($u_id)){           
            // Start Time
            if($this->setTimeTopLevel($u_id, $lat, $lng, $note)){
                // Update User Status to Green (1)
                $this->updateUserStatusToGreen($u_id);               
            }
        }
        //JFactory::getApplication()->close();
    }
    
    public function updateUserStatusToGreen($u_id)
    {
       /* $db = $this->db;       
        $item = new stdClass;
        $item->id = $u_id;
        $item->status_user = 1;

        $db->updateObject( '#__users', $item, 'id' );*/
    }
    
    public function getUser($company, $ownerID, $password){
        $db = $this->db;
        if(!empty($company)){
            $companyF = " AND company = '$company'";
        }
        if(!empty($ownerID)){
            $ownerIDF = " AND owner_id = '$ownerID'";
        }

        $query = "SELECT id, owner_id FROM #__users WHERE password2 = '$password' $companyF $ownerIDF";
        $db->setQuery( $query );
        $user = $db->loadObject();

        return $user;
    }
    
    private function setTimeTopLevel($u_id = null, $lat, $lng, $note) {
       
        if ($this->setTime($u_id, $lat, $lng, $note)) {
            return true;
        } else {
            return false;
        }
    }
    
    public static function setTime($u_id = null, $lat, $lng, $note)
    {
        // Set User Start Time
        self::setUserStartTime($u_id);

        $db = & JFactory::getDBO();

        // Check If user is stamped in
        $current_date = date('Y-m-d');
        $query = "SELECT * FROM #__audit_time_confirm WHERE id_user = '$u_id' AND date = '$current_date' order by ID desc";
        $db->setQuery( $query );
        $data = $db->loadObject();

        // Check if stamped in
        if(!empty($data->id) && !empty($data->date))
        {
            // Check if not stamped out
            if ($data->date_exit == 0){
                // Not stamped out today.                
                // Already stamped in. return
            } else{
                // Stamped out today Create new record
                self::createNewAuditRecord($u_id, $current_date, $lat, $lng, $note);
            }
        }
        else{
            //echo('create new record not stamped in'.$u_id.' '.$current_date);
            // Not stamped in today. Create new record
            self::createNewAuditRecord($u_id, $current_date, $lat, $lng, $note);
        }
        return true;
   }
   
   private static function setUserStartTime($u_id)
   {
        // SET Status globally to USER to 1 if User Status is 0
        $db = & JFactory::getDBO();

        $query = "SELECT `start_time` FROM #__users WHERE `id` = '$u_id'";
        $db->setQuery($query);
        $start_time = $db->loadResult();
        
        //print_r('Start time id_user '.$u_id.' ='.$start_time);
        
        if($start_time == 0){
            $itemU = new stdClass;
            $itemU->id = $u_id;
            $itemU->start_time = 1;

            $db->updateObject( '#__users', $itemU, 'id' );
        }
   }

   
    
    private static function createNewAuditRecord($u_id, $current_date, $lat, $lng, $note)
    {
        if($u_id > 0){
            $current_time=time();
            $date_logged=date('Y-m-d H:i:s', strtotime('now +1min'));
            //date('H:i', $current_time)
            $a='1';
            $b='1';
            
            if($a===$b){
                $date_logged=date('Y-m-d H:i:s', strtotime('now +1min'));
                $date0=date('Y-m-d', strtotime('tomorrow'));

            } elseif(date('H:i', $current_time)==='00:00'){
                $date_logged=date('Y-m-d H:i:s', strtotime('now'));

                $date0=date('Y-m-d', strtotime('now'));
            } else{
                //$date_logged=date('Y-m-d H:i:s', strtotime('now -1min'));
                $date0=date('Y-m-d', strtotime('now'));

                $minutes=intval(date('i', $current_time));
                if($minutes<10 && date('H:i', $current_time)==='00:0'.intval(date('i', $current_time))){
                    $date_logged=date('Y-m-d H:i:s', strtotime('now -'.$minutes.'min'));
                }
                if($minutes>=10 && date('H:i', $current_time)==='00:'.intval(date('i', $current_time))){
                    $date_logged=date('Y-m-d H:i:s', strtotime('now -'.$minutes.'min'));
                }

            } 

            
            $ip=$_SERVER["REMOTE_ADDR"];

            $db = & JFactory::getDBO();
            $item = new stdClass;
            $item->id = NULL;
            $item->id_user = $u_id;
            $item->date_logged = $date_logged;
            $item->date_exit = null;
            $item->date=$date0;
            $item->asked_gps=0;
            $item->lat=$lat;
            $item->lng=$lng;
            $item->note=$note;

            $item->ip=$ip;
            $res=$db->insertObject( '#__audit_time_confirm', $item, 'id' );

            /////////////////////////////////////////////////////////////////////////////////////////
            $text_log='script: \auto_logout\auto_logout.class.php';
            $text_log.=' method createNewAuditRecord';
            $text_log.=' $res: '.$res.' $minutes: '.$minutes.' $current_date:'.$current_date.' $item: '.print_r($item, true).'---------------end one item';
            file_put_contents(JPATH_BASE.DS.'auto_logout_log.txt', "\r\n".$text_log, FILE_APPEND);
            /////////////////////////////////////////////////////////////////////////////////////////

            self::createAutologinLogRecord($u_id, $date_logged);

            if (!$res) {
                echo $db->stderr();
                return false;
            }
            else{
                return true;
            }
        }  
    }
    
    public static function createAutologinLogRecord($u_id, $date_logged)
    {
        $db = & JFactory::getDBO();
        
        $item = new stdClass;
        $item->id = null;
        $item->id_user = (int)$u_id;
        $item->time = time();//time=date_triggered. date_triggered added for convenience
        $item->date_start=$date_logged;
        $item->date_triggered=date('Y-m-d H:i:s');//time=date_triggered. date_triggered added for convenience
        
        $db->insertObject( '#__auto_relogin_log', $item, 'id' );
    }

}
