<?php
/*ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);*/

set_time_limit(0);

define('_JEXEC', 1);

define('JPATH_BASE', $_SERVER['DOCUMENT_ROOT']);


define('DS', DIRECTORY_SEPARATOR);
require_once( JPATH_BASE . DS . 'includes' . DS . 'defines.php' );
require_once( JPATH_BASE . DS . 'includes' . DS . 'framework.php' );

jimport('joomla.application.component.controller');
$mainframe = & JFactory::getApplication('site');
$session = & JFactory::getSession();

$config = JFactory::getConfig();
$encryption_key = $config->get('encryption_key');
$enable_no_time_limit_in_api = $config->get('enable_no_time_limit_in_api');
//$enable_api_blocking_by_option_from_admin_panel = $config->get('enable_api_blocking_by_option_from_admin_panel');
 
define('ENCRYPTION_KEY', $encryption_key);


JModelLegacy::addIncludePath(JPATH_SITE . '/components/com_audit/models');
JModelLegacy::addIncludePath(JPATH_SITE . '/components/com_audit/controllers');
JModelLegacy::addIncludePath(JPATH_SITE . '/components/com_audit/controller.php');
//require JPATH_SITE . '/components/com_audit/controller.php';

class api {

    //public $pp_lock_time_in_seconds;
    public static $dev_n_tools_table;
    // public $db;
    // public static $db_static;
    public static $enable_gps_task_changes;
    
    public function __construct($db) {
        //self::$db_static = $db;
        $this->db = $db;

        $this->server_name = $_SERVER['SERVER_NAME'];
        $this->site_fullname = empty($_SERVER['HTTPS']) ? 'http://' : 'https://' . $this->server_name;
        $this->password_api_old = 'KIis3223*>XNWIUe8329od';
        $this->lang = & JFactory::getLanguage();
        
        $config = JFactory::getConfig();
        $enable_api_blocking_by_option_from_admin_panel = $config->get('enable_api_blocking_by_option_from_admin_panel');
        $this->enable_api_blocking_by_option_from_admin_panel = $enable_api_blocking_by_option_from_admin_panel;
        $this->enable_totals_in_check_online_app_api = $config->get('enable_totals_in_check_online_app_api');
        $this->disable_start_time_with_no_task = $config->get('disable_start_time_with_no_task');
        
        $this->api_not_enable_txt = 'Api is not enabled for this company or manager have suspend subscription';
        $this->user_is_hidden_txt = 'The user has been hidden. Functionality not available';
        $this->user_is_manager_txt = 'The user is manager. Functionality not available';
        $this->shifts_notification_disabled = 'Schedules notifications for user company is disabled';
        
        $this->enable_task_manager_dk_api = $config->get('enable_task_manager_dk_api');
        $this->enable_jokes_module = $config->get('enable_jokes_module');
        $this->enable_login_and_exit_hours_editable_in_app = $config->get('enable_login_and_exit_hours_editable_in_app');
        $this->enable_adding_default_tasks = $config->get('enable_adding_default_tasks');
        $this->enable_uniconta_tasks = $config->get('enable_uniconta_tasks');
        $this->uniconta_table_name = '#__uniconta_tasks';
        $this->subtask_table_name = '#__uniconta_subtasks';
        
        $this->dev_n_tools_table = '#__devices_n_tools';
        self::$dev_n_tools_table = '#__devices_n_tools';
        $this->enable_gps_task_changes = $config->get('enable_gps_task_changes');
        self::$enable_gps_task_changes = $config->get('enable_gps_task_changes');
        $this->enable_gps_type_of_tasks = $config->get('enable_gps_type_of_tasks');
        $this->radius_table_name = '#__gps_radius';
        $this->enable_automatick_clock_icon_in_task_manager = $config->get('enable_automatick_clock_icon_in_task_manager');
        
        include $_SERVER['DOCUMENT_ROOT'].'/app_api/php-image-resize-master/lib/ImageResize.php';
    }

    public function auth($password_original_hash, $password_request) {
        $to1 = 'developer3452@gmail.com';
        $subject = 'APP API ultima';

        $headers = "From: info@curiotime.com\r\n";

        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
        $message = '<pre>' . password_verify($password_original_hash, $password_request) . '</pre>';
        //mail($to1, $subject, $message, $headers);

        return password_verify($password_original_hash, $password_request);
    }

    public function getAllUsers($action) {
        $query = 'SELECT `id`, `username0`, `password2`, `name`, `email`, `tel`, `company`, `username`, `api_token` FROM #__users ORDER BY `id` ASC';
        $this->db->setQuery($query);
        $items = $this->db->loadObjectList();


        return $items;
    }

    /**
     * Get user by token
     * @param string $token
     * @return object 
     */
    private function getUserByToken($token) {
        $query  =   "SELECT * FROM #__users WHERE api_token = ".$this->db->quote($token)." limit 1";
        $this->db->setQuery($query);
        return $this->db->loadObject();
    }
    
    public function preparePassw($passw) {
        return password_hash($passw, PASSWORD_BCRYPT);
    }

    public function addLogRow(...$a) {
        //$action, $type, $auth_res, $response, $client_info, $select_mode
        $args=func_get_args();
        $action=  $args[0];
        $type= $args[1];
        $auth_res= $args[2];
        $response= $args[3];
        $client_info=$args[4];
        $select_mode=$args[5];
        
        switch ($type) {
            case 'global':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = '';
                $item->type = 'global';


                break;
            case 'checkPassword':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'checkPassword';

                break;
            case 'getCompanyImages':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getCompanyImages';

                break;
            case 'getOwnerID':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getOwnerID';

                break;
            case 'checkSpecCompanies':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'checkSpecCompanies';

                break;
            case 'getGroupArray':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getGroupArray';

                break;
            case 'getListUsers':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getListUsers';

                break;
            case 'askedGps':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'askedGps';

                break;
            case 'startTime':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'startTime';

                break;
            case 'stopTime':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'stopTime';

                break;
            case 'getLayoutTaskSelect':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getLayoutTaskSelect';
                $item->select_mode = $select_mode;

                break;
            case 'getLayoutSpecificTaskAPISelect':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getLayoutSpecificTaskAPISelect';
                $item->select_mode = $select_mode;

                break;
            case 'getUserMode':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getUserMode';
                $item->select_mode = $select_mode;

                break;
            case 'startCOTaskAPI':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'startCOTaskAPI';
                $item->select_mode = $select_mode;

                break;
            case 'saveState':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'saveState';
                $item->select_mode = $select_mode;

                break;
            case 'saveSessionImages':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'saveSessionImages';
                $item->select_mode = $select_mode;

                break;
            case 'checkOnline':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'checkOnline';
                $item->select_mode = $select_mode;

                break;
            case 'getPayPeriod4':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getPayPeriod4';
                $item->select_mode = $select_mode;

                break;
            case 'getOneDatePP4':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getOneDatePP4';
                $item->select_mode = $select_mode;

                break;
            case 'setOneDatePP4':
            case 'setOneDatePP4_2':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'setOneDatePP4';
                $item->select_mode = $select_mode;

                break;
            case 'sendPdf':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'sendPdf';
                $item->select_mode = $select_mode;
                break;
            case 'setHoliday':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'setHoliday';
                $item->select_mode = $select_mode;
                break;
            case 'getHoliday':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getHoliday';
                $item->select_mode = $select_mode;
                break;
            
            case 'getHolidays':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getHolidays';
                $item->select_mode = $select_mode;
                break;
            case 'getQuotes':
            
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getQuotes';
                $item->select_mode = $select_mode;
                break;
            case 'getQuotesWithLang':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getQuotesWithLang';
                $item->select_mode = $select_mode;
                break;
            case 'getAvailableMudules':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getAvailableMudules';
                $item->select_mode = $select_mode;
                break;
            case 'attachUsersToTask':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'attachUsersToTask';
                $item->select_mode = $select_mode;
                break;
            case 'getFromTo':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getFromTo';
                $item->select_mode = $select_mode;
                break;
            case 'getTimesheetHeaders':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getTimesheetHeaders';
                $item->select_mode = $select_mode;
                break;
            case 'getOneDateWithTextPP4':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getOneDateWithTextPP4';
                $item->select_mode = $select_mode;

                break;
            case 'getPayPeriod4WithTexts':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getPayPeriod4WithTexts';
                $item->select_mode = $select_mode;

                break;
            case 'getUserHolidaysRequests':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getUserHolidaysRequests';
                $item->select_mode = $select_mode;
                break;
            case 'getCalcLink':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getCalcLink';
                $item->select_mode = $select_mode;
            break;
            case 'getUserShifts':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getUserShifts';
                $item->select_mode = $select_mode;
            break;
            case 'setShift':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'setShift';
                $item->select_mode = $select_mode;
            break;
            case 'getShift':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getShift';
                $item->select_mode = $select_mode;
            break;
            case 'setShiftMessage':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'setShiftMessage';
                $item->select_mode = $select_mode;
            break;
            case 'getMessages':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getMessages';
                $item->select_mode = $select_mode;
            break;
            case 'registration3rd':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'registration3rd';
                $item->select_mode = $select_mode;
            break;
            case 'getCompanySchedulesAsDate':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getCompanySchedulesAsDate';
                $item->select_mode = $select_mode;
            break;
            case 'isNotificationDisabledOnUserCompany':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'isNotificationDisabledOnUserCompany';
                $item->select_mode = $select_mode;
            break;
            case 'addScheduleMessage':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'addScheduleMessage';
                $item->select_mode = $select_mode;
            break;
            case 'getCalcWidgetLink':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getCalcWidgetLink';
                $item->select_mode = $select_mode;
            break;
            case 'setRoutePoint':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'setRoutePoint';
                $item->select_mode = $select_mode;
            break;
            case 'getRoutes':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getRoutes';
                $item->select_mode = $select_mode;
            break;
            case 'setRoute':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'setRoute';
                $item->select_mode = $select_mode;
            break;
            case 'startRoute':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'startRoute';
                $item->select_mode = $select_mode;
            break;
            case 'stopRoute':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'stopRoute';
                $item->select_mode = $select_mode;
            break;
        }

        $item->client_info = trim($client_info);
        
        
        $this->db->setQuery("delete from #__app_api_global_log where timestamp < ".$this->db->quote(strtotime("-30 day")));
        $this->db->query();
        $this->db->insertObject('#__app_api_global_log', $item);
        
    }

    public function getDevice() {
        $tablet_browser = 0;
        $mobile_browser = 0;

        if (preg_match('/(tablet|ipad|playbook)|(android(?!.*(mobi|opera mini)))/i', strtolower($_SERVER['HTTP_USER_AGENT']))) {
            $tablet_browser++;
        }

        if (preg_match('/(up.browser|up.link|mmp|symbian|smartphone|midp|wap|phone|android|iemobile)/i', strtolower($_SERVER['HTTP_USER_AGENT']))) {
            $mobile_browser++;
        }

        if ((strpos(strtolower($_SERVER['HTTP_ACCEPT']), 'application/vnd.wap.xhtml+xml') > 0) or ( (isset($_SERVER['HTTP_X_WAP_PROFILE']) or isset($_SERVER['HTTP_PROFILE'])))) {
            $mobile_browser++;
        }

        $mobile_ua = strtolower(substr($_SERVER['HTTP_USER_AGENT'], 0, 4));
        $mobile_agents = array(
            'w3c ', 'acs-', 'alav', 'alca', 'amoi', 'audi', 'avan', 'benq', 'bird', 'blac',
            'blaz', 'brew', 'cell', 'cldc', 'cmd-', 'dang', 'doco', 'eric', 'hipt', 'inno',
            'ipaq', 'java', 'jigs', 'kddi', 'keji', 'leno', 'lg-c', 'lg-d', 'lg-g', 'lge-',
            'maui', 'maxo', 'midp', 'mits', 'mmef', 'mobi', 'mot-', 'moto', 'mwbp', 'nec-',
            'newt', 'noki', 'palm', 'pana', 'pant', 'phil', 'play', 'port', 'prox',
            'qwap', 'sage', 'sams', 'sany', 'sch-', 'sec-', 'send', 'seri', 'sgh-', 'shar',
            'sie-', 'siem', 'smal', 'smar', 'sony', 'sph-', 'symb', 't-mo', 'teli', 'tim-',
            'tosh', 'tsm-', 'upg1', 'upsi', 'vk-v', 'voda', 'wap-', 'wapa', 'wapi', 'wapp',
            'wapr', 'webc', 'winw', 'winw', 'xda ', 'xda-');

        if (in_array($mobile_ua, $mobile_agents)) {
            $mobile_browser++;
        }

        if (strpos(strtolower($_SERVER['HTTP_USER_AGENT']), 'opera mini') > 0) {
            $mobile_browser++;
            //Check for tablets on opera mini alternative headers
            $stock_ua = strtolower(isset($_SERVER['HTTP_X_OPERAMINI_PHONE_UA']) ? $_SERVER['HTTP_X_OPERAMINI_PHONE_UA'] : (isset($_SERVER['HTTP_DEVICE_STOCK_UA']) ? $_SERVER['HTTP_DEVICE_STOCK_UA'] : ''));
            if (preg_match('/(tablet|ipad|playbook)|(android(?!.*mobile))/i', $stock_ua)) {
                $tablet_browser++;
            }
        }

        if ($tablet_browser > 0) {
            // do something for tablet devices
            $browser = 'tablet';
        } else if ($mobile_browser > 0) {
            // do something for mobile devices
            $browser = 'mobile';
        } else {
            // do something for everything else
            $browser = 'desctop';
        }

        return $browser;
    }

    private function checkSystemMode($user_id) {
        $user_obj = & JFactory::getUser($user_id);

        return $this->getSystemMode($user_obj->company);
    }

    private function getSystemMode($company) {
        $path = JPATH_BASE . DS . 'global_functions' . DS . 'global_functions.class.php';
        require_once($path);
       
        $system_mode_raw = globalFunctions::globalGetCompanyMods($company, 'confirmation');

        if ($system_mode_raw == '1') {
            $system_mode = 'confirm';
        } elseif ($system_mode_raw == '0') {
            $system_mode = 'pay_period';
        }
        //echo $system_mode.'<br/>';
        return $system_mode;
    }
    
    private function checkGlobalApiPermission($user_id){
        $user_obj = & JFactory::getUser($user_id);
        $manage_obj = & JFactory::getUser($user_obj->owner_id);
        
        $user_token = $user_obj->api_token;
        $res = $this->getAvailableMudules2($user_token);
        $admin_panel_selection = $res['data']['enable_app'];
        $final = 0;
     
        if($admin_panel_selection == '1' && $manager->block != 1){
            $final = 1;
        }
        
        return $final;
    }
    
    public function checkPassword() {
        //return 'checkPassword model';
        //exit;
        $password_raw = $this->db->escape(trim($_REQUEST['password_for_verify']));
        $password = $this->decrypt($password_raw);

        $company_raw = $this->db->escape(trim($_REQUEST['company_for_verify']));
        $company = $this->decrypt($company_raw);

        $query = "SELECT * FROM #__users WHERE BINARY `password2` = '$password' AND BINARY `company`='$company'";
        $this->db->setQuery($query);
        $user = $this->db->loadObject();
        
        if($user->is_hide == 1){
            return $this->user_is_hidden_txt;
        }
        $u_id = $user->id;
        
        if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
            $perm = $this->checkGlobalApiPermission($u_id);
            if($perm === 0){
                return $this->api_not_enable_txt;
            }
        }
        return empty($u_id) ? '0' : $u_id;
    }

    //open ssl
    private function decrypt($ciphertext) {
        $c = base64_decode($ciphertext);
        $ivlen = openssl_cipher_iv_length($cipher = "AES-128-CBC");
        $iv = substr($c, 0, $ivlen);
        $hmac = substr($c, $ivlen, $sha2len = 32);
        $ciphertext_raw = substr($c, $ivlen + $sha2len);
        $plaintext = openssl_decrypt($ciphertext_raw, $cipher, ENCRYPTION_KEY, $options = OPENSSL_RAW_DATA, $iv);
        $calcmac = hash_hmac('sha256', $ciphertext_raw, ENCRYPTION_KEY, $as_binary = true);
        if (hash_equals($hmac, $calcmac)) {
            return $plaintext;
        }
    }
    
    //open ssl
    private static function decryptStatic($ciphertext) {
        $c = base64_decode($ciphertext);
        $ivlen = openssl_cipher_iv_length($cipher = "AES-128-CBC");
        $iv = substr($c, 0, $ivlen);
        $hmac = substr($c, $ivlen, $sha2len = 32);
        $ciphertext_raw = substr($c, $ivlen + $sha2len);
        $plaintext = openssl_decrypt($ciphertext_raw, $cipher, ENCRYPTION_KEY, $options = OPENSSL_RAW_DATA, $iv);
        $calcmac = hash_hmac('sha256', $ciphertext_raw, ENCRYPTION_KEY, $as_binary = true);
        if (hash_equals($hmac, $calcmac)) {
            return $plaintext;
        }
    }

    public function getCompanyImages() {
        $companyName_raw = $this->db->escape(trim($_REQUEST['company_for_verify']));
        $companyName = $this->decrypt($companyName_raw);
        
        if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
            $query = "SELECT `id` FROM #__users WHERE BINARY `company`='$companyName'";
            $this->db->setQuery($query);
            $u_id = $this->db->loadObjectList()[0]->id;
        
            $perm = $this->checkGlobalApiPermission($u_id);
            if($perm === 0){
                return $this->api_not_enable_txt;
            }
        } 
        
        if (!empty($companyName)) {

            $query = "SELECT * FROM #__company_media WHERE company = '$companyName'";
            $this->db->setQuery($query);
            $company = $this->db->loadObject();

            if ($company) {
                $company->logo = $this->site_fullname . '/images/company_images/' . $company->logo;
                $company->bg = $this->site_fullname . '/images/company_images/' . $company->bg;

                return $company;
            }
        }
    }

    public function getOwnerID() {
        $user_id = (int) $_REQUEST['user_id'];
        
        if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
            $perm = $this->checkGlobalApiPermission($user_id);
            if($perm === 0){
                return $this->api_not_enable_txt;
            }
        }
        
        $query = "SELECT * FROM #__users WHERE `id` = '$user_id'";
        $this->db->setQuery($query);
        $user = $this->db->loadObject();
        
        
        
        if($user->is_hide == 1){
            $res = $this->user_is_hidden_txt;
        } else{
            $res = new stdClass();
            $res->id = $user->id;
            $res->owner_id = $user->owner_id;
        }
        
        return $res;
        
    }

    public function checkSpecCompanies() {
        $company_raw = $this->db->escape(trim($_REQUEST['company']));
        $company = $this->decrypt($company_raw);

        //$model = JModelLegacy::getInstance('Registered_Users', 'AuditModel');

        if (empty($company)) {
            $company = filter_input(INPUT_COOKIE, 'company');
        } else {
            $company = $company;
        } if (empty($_REQUEST['user_id'])) {
            $user_id = filter_input(INPUT_COOKIE, 'lastUserLogin', FILTER_VALIDATE_INT);
        } else {
            $user_id = $_REQUEST['user_id'];
        }
        
        $query = "SELECT * FROM #__users WHERE `id` = '$user_id'";
        $this->db->setQuery($query);
        $user = $this->db->loadObject();
        
        if($user->is_hide == 1){
            return $this->user_is_hidden_txt;
        } 
        
        if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
            $perm = $this->checkGlobalApiPermission($user_id);
            if($perm === 0){
                return $this->api_not_enable_txt;
            }
        }
        $companies_array = [
            'Frostverk',
                //'demo'
        ];

        if (in_array($company, $companies_array)) {
            $permission_user = $this->checkPermission($user_id);
            if ($permission_user === '2' || $permission_user === '6') {
                $res = 'https://frostverk.ns3.kreativ.is/innskraning';
            }
        }
        // $res=$model->setSyncStatus($status);

        return [
            'user_id' => $user_id,
            'company' => $company,
            'res' => $res,
            'perm' => $permission_user
        ];
    }

    private function checkPermission($user_id) {
        $user = JFactory::getUser($user_id);
        $current_group = implode($user->get('groups'));

        return $current_group;
    }

    public function getGroupArray() {
        $token_raw = trim($_REQUEST['user_token']);
        $user_token = $this->decrypt($token_raw);  
        $user_obj = $this->getUserByToken($user_token);
        
        if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
            $perm = $this->checkGlobalApiPermission($user_obj->id);
            if($perm === 0){
                return $this->api_not_enable_txt;
            }
        }
        
        if($user_obj->is_hide == 1){
            return $this->user_is_hidden_txt;
        }
        
        $current_user =  $user_obj;
        $owner_id = $current_user->owner_id;

        $query = "SELECT `id`, `group_user` FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0' ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $res = $this->db->loadAssocList();

        $count = count($res);
        $final = $this->super_unique($res, 'group_user');

        $html = [];
        $i = 0;
        foreach ($final as $group) {
            if (!empty($group['group_user'])) {
                if ($group['group_user'] === $current_user->group_user) {
                    $html[$i]['department'] = $group['group_user'];
                    //$html[$i]['is_selected'] = '1';
                    //$html[$i]['id_user'] = $group['id'];
                } else {
                    $html[$i]['department'] = $group['group_user'];
                    //$html[$i]['is_selected'] = '0';
                    //$html[$i]['id_user'] = $group['id'];
                }
                $i++;
            }
        }
        return [
            'departments' => $html,
        ];
    }

    private function super_unique($array, $key) {
        $temp_array = [];
        foreach ($array as &$v) {
            if (!isset($temp_array[$v[$key]]))
                $temp_array[$v[$key]] = & $v;
        }
        $array = array_values($temp_array);
        return $array;
    }

    public function getListUsers() {
        $user_id = (int) $_REQUEST['user_id'];
        
        if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
            $perm = $this->checkGlobalApiPermission($user_id);
            if($perm === 0){
                return $this->api_not_enable_txt;
            }
        }
        
        $dep_string = trim($_REQUEST['dep_string']);

        /*$query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user_id'";
        $this->db->setQuery($query);
        $owner_id = $this->db->loadResult();*/
        
        $query = "SELECT * FROM #__users WHERE `id` = '$user_id'";
        $this->db->setQuery($query);
        $user = $this->db->loadObject();
        
        if($user->is_hide == 1){
            return $this->user_is_hidden_txt;
        }
        
        $owner_id = $user->owner_id;
        $users_list = $this->getUsersOnline($owner_id, $dep_string);

        return $users_list;
    }
    
    private function compare($a, $b)
    {
        //$alphabet = 'aąbcćdeęfghijklłmnnoóqprstuvwxyzźż'; // i used polish letters
        $alphabet =  'aábcdðeéfghiíjklmnoópqrstuúvwxyýzþæö';
        
        $a = mb_strtolower($a->username0);
        $b = mb_strtolower($b->username0);

        for ($i = 0; $i < mb_strlen($a); $i++) {
            if (mb_substr($a, $i, 1) == mb_substr($b, $i, 1)) {
                continue;
            }
            if ($i > mb_strlen($b)) {
                return 1;
            }
            if (mb_strpos($alphabet, mb_substr($a, $i, 1)) > mb_strpos($alphabet, mb_substr($b, $i, 1))) {
                return 1;
            } else {
                return -1;
            }
        }
    }
    
    private function getUsersOnline($owner_id, $dep_string) {
        if(empty($dep_string)){
            $query = "SELECT `id`,`username`,`username0`, `company` FROM #__users WHERE `owner_id` = '" . $owner_id . "' ORDER BY `username0` ASC";
            $this->db->setQuery($query);
            $users = $this->db->loadObjectList();
        } else{
            $group_arr=explode(',', $dep_string);
            $in='';
            
            foreach($group_arr as $department){
                $in.="'".$department."',";
            }
            $in=rtrim($in,',');
            
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/get_online_users_api.html', print_r($in, true), FILE_APPEND | LOCK_EX);
            
            $query = "SELECT `id`,`username`,`username0`,`group_user`, `company` FROM #__users WHERE `owner_id` = '" . $owner_id . "' AND `group_user` IN (".$in.") ORDER BY `username0` ASC";
            $this->db->setQuery($query);
            $users = $this->db->loadObjectList();
        }

        $final_arr = [];
        usort($users, [$this, 'compare']);
        ksort($users);

        foreach ($users as $user) {
            $system_mode=$this->getSystemMode($user->company);
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/get_online_users_api00.html', print_r($system_mode, true), FILE_APPEND | LOCK_EX);
            /*echo '<pre>';
            print_r($system_mode);
            echo '</pre>'; */
            
            if($system_mode=='confirm'){
                $res = $this->checkOnlineUserConfirm($user->id);
            } elseif($system_mode=='pay_period'){
                $res = $this->checkOnlineUser($user->id);
            }
            //$res=array_merge($res_confirm, $res_pay_period);
            /*if($res_confirm=='1' || $res_pay_period=='1'){
                $res='1';
            }*/
            
            if ($res == '1') {
                $user->additionally_is_online = '1';
                $user->company_mode=$system_mode;
               // $user->department=$user->group_user;
                $final_arr[] = $user;
            } else {
                //$user->additionally_is_online = '0';
            }
        }


        return $final_arr;
    }

    private function checkOnlineUserConfirm($user_id) {
        $current_date = date('Y-m-d');
        $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$user_id' AND `date`='" . $current_date . "' AND `date_exit`='0000-00-00 00:00:00' ORDER BY `id` DESC LIMIT 0, 1";
        $this->db->setQuery($query);
        $rez = $this->db->loadObjectList();

        if (!empty($rez)) {
            $res = '1';
        } else {
            $res = '0';
        }
        return $res;
    }
    
    private function checkOnlineUser($user_id) {
        $current_date = date('Y-m-d');
        $query = "SELECT * FROM #__audit_time WHERE `id_user` = '$user_id' AND `date`='" . $current_date . "' AND `date_exit`='0000-00-00 00:00:00' ORDER BY `id` DESC LIMIT 0, 1";
        $this->db->setQuery($query);
        $rez = $this->db->loadObjectList();

        if (!empty($rez)) {
            $res = '1';
        } else {
            $res = '0';
        }
        return $res;
    }

    public function askedGps() {
        //$user_id = (int) $_REQUEST['user_id'];
        
        $app = JFactory::getApplication();
        $token_raw = $app->input->getString('token');
        
        
        $user_token = $this->decrypt($token_raw);
        $user_obj = $this->getUserByToken($user_token);
        
        if($user_obj->is_hide == 1){
            return $this->user_is_hidden_txt;
        }
        if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
            $perm = $this->checkGlobalApiPermission($user_obj->id);
            if($perm === 0){
                return $this->api_not_enable_txt;
            }
        }
        
        
        $gps_mode = $user_obj->gps_mode;
        
        return $gps_mode;
    }
    
    
    public function startTime($token) {
        $user_obj = $this->getUserByToken($token);
        $password =$user_obj->password2;
        $company = $user_obj->company;        
        $lat_raw = $this->db->escape(trim($_REQUEST['lat']));
        $lat = $this->decrypt($lat_raw);
        $lng_raw = $this->db->escape(trim($_REQUEST['lng']));
        $lng = $this->decrypt($lng_raw);
        $client_ip_raw = $this->db->escape(trim($_REQUEST['client_ip']));
        $client_ip = $this->decrypt($client_ip_raw);
        $ownerID = $user_obj->owner_id;
        $row_hash = $this->db->escape(trim($_REQUEST['row_hash']));
        if($user_obj->gps_mode == '0'){
            $lat = '';
            $lng = '';
        }
        $app = JFactory::getApplication();
        $is_pressed_big_green_button = $app->input->getInt('is_pressed_big_green_button');
        $ignore_empty_task = $app->input->getInt('ignore_empty_task');
        
        $ids = $this->getUser1($company, $ownerID, $password);
        $u_id = $ids->id;
        
        if($ids->is_hide == 1){
            return $this->user_is_hidden_txt;
        }
        
        if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
            $perm = $this->checkGlobalApiPermission($u_id);
            if($perm === 0){
                return $this->api_not_enable_txt;
            }
        }
        
        $note1 = $this->db->escape(trim($_REQUEST['note']));
        $note = strip_tags($note1);

        if($this->disable_start_time_with_no_task == 1){
            if($ids->SDSTWNTS == 1 && empty($note) && $ignore_empty_task != 1){
                return JText::_('Start time error: Please, enter work description!'); 
            }
        }
        
        if (!empty($u_id)) {
           
            //$system_mode=$this->getSystemMode();
            $system_mode=$this->checkSystemMode($u_id);
          
           
            if($system_mode=='confirm'){
                if ($this->setConfirmTime($u_id, $lat, $lng, $note, $client_ip, $row_hash)) {
                    //echo $system_mode;
                    // Update User Status to Green (1)
                    $this->updateUserStatusToGreen($u_id);
                    //set button status
                    $this->setGreenButtonPressedStatus($is_pressed_big_green_button, $system_mode, $u_id);
                    
                    return 'ok';
                }
            } elseif($system_mode=='pay_period'){
                if ($this->setTimeWrapper($u_id, $lat, $lng, $note, $client_ip, $row_hash)) {
                    // Update User Status to Green (1)
                    $this->updateUserStatusToGreen($u_id);
                    //set button status
                    $this->setGreenButtonPressedStatus($is_pressed_big_green_button, $system_mode, $u_id);
                    
                    return 'ok';
                }
            }
            
        }
    }

    private function clearBigGreenButtonPressed($u_id, $system_mode)
    {
        switch($system_mode){
            case 'confirm':
                $table_name = '#__audit_time_confirm';
                break;
            case 'pay_period':
                $table_name = '#__audit_time';
                break;
        }
        
        $current_date = date('Y-m-d');
        /*$query = "SELECT * FROM $table_name WHERE `id_user` = '$u_id' AND `date` = '$current_date' ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList()[0];
        
        // Check if stamped in
        if (!empty($data->id) && !empty($data->date)) {*/
            $query = "UPDATE $table_name SET `is_pressed_big_green_button`='0', `big_green_button_start_time`='' WHERE `id_user` = '$u_id' AND `date`='".$current_date."'";
            $this->db->setQuery($query);
            $this->db->query();
       // }  
    }
    
    private function setGreenButtonPressedStatus($is_pressed_big_green_button, $system_mode, $u_id)
    {
        switch($system_mode){
            case 'confirm':
                $table_name = '#__audit_time_confirm';
                break;
            case 'pay_period':
                $table_name = '#__audit_time';
                break;
        }
        
        $current_date = date('Y-m-d');
        $query = "SELECT * FROM $table_name WHERE `id_user` = '$u_id' AND `date` = '$current_date' ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList()[0];
        
        // Check if stamped in
        if (!empty($data->id) && !empty($data->date)) {
            $query = "UPDATE $table_name SET `is_pressed_big_green_button`='".(int)$is_pressed_big_green_button."', `big_green_button_start_time`='".$data->date_logged."' WHERE `id`='".$data->id."'";
            $this->db->setQuery($query);
            $this->db->query();
        }   
    }
    
    /*private function getSystemMode() {
        $config = JFactory::getConfig();
        $system_mode_raw= $config->get('system_mode');

        if($system_mode_raw==='0'){
            $system_mode='confirm';
        } elseif($system_mode_raw==='1'){
            $system_mode='pay_period';
        }
        
        return $system_mode;
    }*/
    
    private function getUser($company, $ownerID, $password) {
        if (!empty($company)) {
            $companyF = " AND company = '$company'";
        }
        if (!empty($ownerID)) {
            $ownerIDF = " AND owner_id = '$ownerID'";
        }

        $query = "SELECT `id`, `owner_id` FROM #__users WHERE `password2` = '$password' $companyF $ownerIDF";
        $this->db->setQuery($query);
        $user = $this->db->loadObject();

        return $user;
    }
    
    private function getUser1($company, $ownerID, $password) {
        if (!empty($company)) {
            $companyF = " AND company = '$company'";
        }
        if (!empty($ownerID)) {
            $ownerIDF = " AND owner_id = '$ownerID'";
        }

        $query = "SELECT `id`, `owner_id`, `SDSTWNTS`, `is_hide` FROM #__users WHERE `password2` = '$password' $companyF $ownerIDF";
        $this->db->setQuery($query);
        $user = $this->db->loadObject();

        return $user;
    }
    
    private function setTimeWrapper($u_id, $lat, $lng, $note, $client_ip, $row_hash, $route_id = null) {
        //$model = JModelLegacy::getInstance('overview', 'AuditModel');
        if (self::setTime($u_id, $lat, $lng, $note, $client_ip, $row_hash, $route_id)) {
            return true;
        } else {
            return false;
        }
    }
    
   
    private function setConfirmTime($u_id, $lat, $lng, $note, $client_ip, $row_hash, $route_id = null) {
        //$model = JModelLegacy::getInstance('overview', 'AuditModel');
        if (self::setConfirmTime0($u_id, $lat, $lng, $note, $client_ip, $row_hash, $route_id)) {
            return true;
        } else {
            return false;
        }
    }

    private static function setUserStartTime($u_id) {
        // SET Status globally to USER to 1 if User Status is 0
        $db = & JFactory::getDBO();
        //$user = & JFactory::getUser();

        if (!empty($u_id)) {
            $id_user = $u_id;
        } else {
            //$id_user = $user->id;
        }

        $query = "SELECT start_time FROM #__users WHERE id = '$id_user'";
        $db->setQuery($query);
        $start_time = $db->loadResult();

        if ($start_time == 0) {
            $itemU = new stdClass;
            $itemU->id = $id_user;
            $itemU->start_time = 1;
            $db->updateObject('#__users', $itemU, 'id');
        }
    }
    

    private static function setTime($u_id = null, $lat, $lng, $note, $client_ip, $row_hash, $route_id = null) {
        // Set User Start Time
        //self::setUserStartTime($u_id);

        //return 'dd';
        $db = & JFactory::getDBO();

        // Check If user is stamped in
        $current_date = date('Y-m-d');
        $query = "SELECT * FROM #__audit_time WHERE id_user = '$u_id' AND date = '$current_date' order by ID desc";
        $db->setQuery($query);
        $data = $db->loadObject();

        // Check if stamped in
        if (!empty($data->id) && !empty($data->date)) {
            $user_object=& JFactory::getUser($u_id);
                $data_stop=[
                    'lat_end' =>$lat,
                    'lng_end'=>$lng,
                    'description_logout'=>'',
                    'client_ip'=>$client_ip
                ];
                
            // Check if not stamped out
            if ($data->date_exit == 0) {
                // Not stamped out today.
                //add description if user press start and not logout today
                if (empty($data->note)) {
                    /*$query = "UPDATE #__audit_time SET `note`='" . $db->escape($note) . "' WHERE `id`='" . $data->id . "'";
                    $db->setQuery($query);
                    $db->query();*/
                    
                    self::stopTimeStatic($user_object, $data_stop);
                    self::setUserStartTime($u_id);
                    self::createNewAuditRecord($u_id, $current_date, $lat, $lng, $note, $client_ip, $row_hash, $route_id);      
                } else {
                   /* $note_current_session = $data->note;
                    $note_final = $note_current_session . '-' . $db->escape($note);

                    $query = "UPDATE #__audit_time SET `note`=' $note_final' WHERE `id`='" . $data->id . "'";
                    $db->setQuery($query);
                    $db->query();*/
                    
                    self::stopTimeStatic($user_object, $data_stop);
                    self::setUserStartTime($u_id);
                    self::createNewAuditRecord($u_id, $current_date, $lat, $lng, $note, $client_ip, $row_hash, $route_id);        
                }

                // Already stamped in. return
            } else {
                self::setUserStartTime($u_id);
                // Stamped out today Create new record
                self::createNewAuditRecord($u_id, $current_date, $lat, $lng, $note, $client_ip, $row_hash, $route_id);
            }
        } else {
            self::setUserStartTime($u_id);
            // Not stamped in today. Create new record
            self::createNewAuditRecord($u_id, $current_date, $lat, $lng, $note, $client_ip, $row_hash, $route_id);
        }
        return true;
    }
    
    private function checkDataInCurrentMinute($data) {
        $current_time_obj = DateTime::createFromFormat('U', time());
        $old_start_obj = DateTime::createFromFormat('Y-m-d H:i:s', $data->date_logged);
        $config = JFactory::getConfig();
        $pp_lock_time_in_seconds = $config->get('pp_lock_time_in_seconds');
         
      
        //if(($old_start_obj->format('i') === $current_time_obj->format('i') && $old_start_obj->format('s') <= $current_time_obj->format('s') - $pp_lock_time_in_seconds) || ($old_start_obj->format('i') !== $current_time_obj->format('i') && $old_start_obj->format('s') >= $current_time_obj->format('s') - $pp_lock_time_in_seconds)){
        if(($current_time_obj->format('U') - $pp_lock_time_in_seconds) > $old_start_obj->format('U')){
            $res = 1;
        } else{
            $res = 0;
        }
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/try_to_fix_start_time.html', print_r($_REQUEST, true), FILE_APPEND | LOCK_EX); 
        return $res;
        
        
    }
    
    private static function setConfirmTime0($u_id = null, $lat, $lng, $note, $client_ip, $row_hash, $route_id = null) {
        // Set User Start Time
        //self::setUserStartTime($u_id);

        //return 'dd';
        $db = & JFactory::getDBO();

        // Check If user is stamped in
        $current_date = date('Y-m-d');
        $query = "SELECT * FROM #__audit_time_confirm WHERE id_user = '$u_id' AND date = '$current_date' order by ID desc";
        $db->setQuery($query);
        $data = $db->loadObject();
        /*echo '<pre>';
        print_r($data);
        echo '</pre>';*/
        
        /*$query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$u_id' AND `date` = '$current_date' order by ID desc";
        $db->setQuery($query);
        $data1 = $db->loadObjectList();*/
       
        // Check if stamped in
        if (!empty($data->id) && !empty($data->date)) {
            $user_object = & JFactory::getUser($u_id);
            $data_stop = [
                'lat_end' => $lat,
                'lng_end' => $lng,
                'description_logout' => '',
                'client_ip' => $client_ip
            ];

            // Check if not stamped out
            if ($data->date_exit == 0) {
                // Not stamped out today.
                //add description if user press start and not logout today
                if (empty($data->note)) {
                    /*$query = "UPDATE #__audit_time_confirm SET `note`='" . $db->escape($note) . "' WHERE `id`='" . $data->id . "'";
                    $db->setQuery($query);
                    $db->query();*/ 
                    //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/pp_lock_start.html', print_r($data, true), FILE_APPEND | LOCK_EX);
                    $res_check = self::checkDataInCurrentMinute($data);
                   // file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/pp_lock_start.html', print_r('$res_check:'.$res_check, true), FILE_APPEND | LOCK_EX);
                    
                    if($res_check === 1){
                        self::stopTimeConfirmStatic($user_object, $data_stop);
                        self::setUserStartTime($u_id);
                        self::createConfirmTimeRecordNoPayPeriod($u_id, $current_date, $lat, $lng, $note, $client_ip, $row_hash, $route_id);
                    }
                } else {
                   /* $note_current_session = $data->note;
                    $note_final = $note_current_session . '-' . $db->escape($note);

                    $query = "UPDATE #__audit_time_confirm SET `note`=' $note_final' WHERE `id`='" . $data->id . "'";
                    $db->setQuery($query);
                    $db->query();*/
                    $res_check = self::checkDataInCurrentMinute($data);
                    
                    if($res_check === 1){
                        self::stopTimeConfirmStatic($user_object, $data_stop);
                        self::setUserStartTime($u_id);
                        self::createConfirmTimeRecordNoPayPeriod($u_id, $current_date, $lat, $lng, $note, $client_ip, $row_hash, $route_id);
                    }
                }

                // Already stamped in. return
            } else {
                self::setUserStartTime($u_id);
                // Stamped out today Create new record
                self::createConfirmTimeRecordNoPayPeriod($u_id, $current_date, $lat, $lng, $note, $client_ip, $row_hash, $route_id);
            }
        } else {
             self::setUserStartTime($u_id);
            // Not stamped in today. Create new record
            self::createConfirmTimeRecordNoPayPeriod($u_id, $current_date, $lat, $lng, $note, $client_ip, $row_hash, $route_id);
        }
        return true;
    }

    private static function createNewAuditRecord($u_id, $current_date, $lat, $lng, $note, $client_ip, $row_hash, $route_id = null) {
        if ($u_id > 0) {
            $db = & JFactory::getDBO();
            $item = new stdClass;
            $item->id = NULL;
            $item->id_user = $u_id;
            $item->date_logged = date('Y-m-d H:i:s');
            $item->date_exit = null;
            $item->date = $current_date;

            $item->asked_gps = 0;
            $item->lat = $lat;
            $item->lng = $lng;
            $item->note = $note;
            $ip = $client_ip;
            $item->ip = $ip;
            $item->row_hash=$row_hash;
            
            $res = $db->insertObject('#__audit_time', $item, 'id');
          

            if (!$res) {
                echo $db->stderr();
                return false;
            } else {
                if(self::$enable_gps_task_changes == '1' && !empty($route_id)){
                    $pp_id = $db->insertid(); //get pay period id
                    self::connectRouteWithTimeshetAndConfirm(0, $pp_id, $u_id, $route_id, $db);
                }
                    
                return true;
            }
        }
    }
    
    private function getCombineConfirmAndPpStatusByCompany($company)
    {
        //$company = JFactory::getApplication()->input->cookie->getString( 'company' );
        //echo $company;
        
        if(empty($company)){
            return 0;
        }
        
        $query='SELECT `id`, `combine_confirm_and_pp` FROM #__users WHERE `company`="'.$company.'"';
        $this->db->setQuery( $query );
        $userlist = $this->db->loadObjectList()[0]; 
            
        $u = $userlist;
        return $u->combine_confirm_and_pp;
    }
    
    private static function getSystemModeStatic($company) {
        $path = JPATH_BASE . DS . 'global_functions' . DS . 'global_functions.class.php';
        require_once($path);
        // echo $path;
        //$company= JFactory::getApplication()->input->cookie->getString( 'company' );
        //if(empty($company))
        $system_mode_raw = globalFunctions::globalGetCompanyMods($company, 'confirmation');

        if ($system_mode_raw == '1') {
            $system_mode = 'confirm';
        } elseif ($system_mode_raw == '0') {
            $system_mode = 'pay_period';
        }
        //echo $system_mode.'<br/>';
        return $system_mode;
    }
    
    private static function getManagerObj($owner_id)
    {
        $db = & JFactory::getDBO();
         
        $query='SELECT * FROM #__users WHERE `id`="'.$owner_id.'"';
        $db->setQuery( $query );
        $managerObj = $db->loadObject();
        
        return $managerObj;
    }
    
    private function getConfirmIdByPpId($pp_id)
    {
        $query = "SELECT `id`, `confirm_id` FROM #__pp_confirm_connector WHERE `pp_id` = '".(int)$pp_id."'";
        $this->db->setQuery( $query );
        return (int)$this->db->loadObject()->confirm_id;
    }
    
    private static function getFinalCombineConfirmAndPpStatus($u_id)
    {
        $config = JFactory::getConfig();
        $db = & JFactory::getDBO();
         
        $query='SELECT `id`,`owner_id` FROM #__users WHERE `id`="'.$u_id.'"';
        $db->setQuery( $query );
        $userObj = $db->loadObject();
        
        if(empty($userObj->id)){
            return 0;
        }
        $managerObj = self::getManagerObj($userObj->owner_id);
        
        /*echo '<pre>';
        print_r($managerObj);
        echo '</pre>';*/
        
        if(empty($managerObj)){
            return 0;
        }

        $combine_confirm_and_pp = $managerObj->combine_confirm_and_pp;
        
        $enable_combine_option_for_confirm_and_pay_period = $config->get('enable_combine_option_for_confirm_and_pay_period');
        $system_mode = self::getSystemModeStatic($userObj->id);
        
        $is_enable_confirm_pp = 0;

        if($system_mode == 'confirm' && $combine_confirm_and_pp == 1 && $enable_combine_option_for_confirm_and_pay_period == '1'){
            $is_enable_confirm_pp = 1;
        }
        //echo '$is_enable_confirm_pp:'.$is_enable_confirm_pp.' $system_mode:'.$system_mode.' $combine_confirm_and_pp:'.$combine_confirm_and_pp.' $enable_combine_option_for_confirm_and_pay_period:'.$enable_combine_option_for_confirm_and_pay_period;
        return $is_enable_confirm_pp;
    }
    
    private static function createConfirmTimeRecordNoPayPeriod($u_id, $current_date, $lat, $lng, $note, $client_ip, $row_hash, $route_id = null) {
       
        if ($u_id > 0) {
             
            $db = & JFactory::getDBO();
            $item = new stdClass;
            $item->id = NULL;
            $item->id_user = $u_id;
            $item->date_logged = date('Y-m-d H:i:s');
            $item->date_exit = null;
            $item->date = $current_date;

            $item->asked_gps = 0;
            $item->lat = $lat;
            $item->lng = $lng;
            $item->note = $note;
            $ip = $client_ip;
            $item->ip = $ip;
            $item->row_hash=$row_hash;
            
            $res = $db->insertObject('#__audit_time_confirm', $item, 'id');

            
           
            if (!$res) {
                echo $db->stderr();
                return false;
            } else {
                $last_id = $db->insertid();
             
                $is_enable_confirm_pp = self::getFinalCombineConfirmAndPpStatus($u_id);    
                //echo $is_enable_confirm_pp;
                
                if($is_enable_confirm_pp === 1){
                    //add pay period row
                    self::setTimeWrapper($u_id, $lat, $lng, $note, $client_ip, $row_hash);
                    
                    $pp_id = $db->insertid(); //get pay period id
            
                    //connect confirm row and pay period row by id
                    self::createPpConfirmConnector($last_id, $pp_id, $u_id);
                    if(self::$enable_gps_task_changes == '1' && !empty($route_id)){
                        self::connectRouteWithTimeshetAndConfirm($last_id, $pp_id, $u_id, $route_id, $db);
                    }
                } else{
                    if(self::$enable_gps_task_changes == '1' && !empty($route_id)){
                        self::connectRouteWithTimeshetAndConfirm($last_id, 0, $u_id, $route_id, $db);
                    }
                }
                
                return true;
            }
        }
    }

    //hh4
    private static function connectRouteWithTimeshetAndConfirm($confirm_id, $pp_id, $u_id, $route_id, object $db)
    {
        $user_obj = JFactory::getUser($u_id);
        $manager_obj = JFactory::getUser($user_obj->owner_id);
        
        $item->id = $route_id;
        $item->pp_id = $pp_id;
        if($manager_obj->combine_confirm_and_pp == 0){
            $item->confirm_id = $confirm_id;
        }
        $item->updated_at = date('Y-m-d H:i:s');
        $item->updated_timestamp = time();
            
        $db->updateObject(self::$dev_n_tools_table, $item, 'id');
    }
    
    private static function createPpConfirmConnector($confirm_id, $pay_period_id, $user_id)
    {
        $db = & JFactory::getDBO();
        $item = new stdClass;
        $item->id = null;
        $item->user_id = (int)$user_id;
        $item->confirm_id = (int)$confirm_id;
        $item->pp_id = (int)$pay_period_id; 
        $item->timestamp_create = time();
        $item->date_create = date('d.m.Y H:i:s');
        
        $db->insertObject( '#__pp_confirm_connector', $item, 'id' );
    }
   
    private function updateUserStatusToGreen($u_id) {
        /*$item = new stdClass;
        $item->id = $u_id;
        $item->status_user = 1;
        $this->db->updateObject('#__users', $item, 'id');*/

        return 'ok';
    }

    /*
     * For stopTime api method
     */
    public function stopTimeWrapper() {
        
        $token = trim($_REQUEST['token']);
        $user_obj = $this->getUserByToken($token);
        if($user_obj->gps_mode == '0'){
            $_REQUEST['lat_end']= '';
            $_REQUEST['lng_end'] = '';
        }
        if($user_obj->is_hide == 1){
            return $this->user_is_hidden_txt;
        }
        if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
            $perm = $this->checkGlobalApiPermission($user_obj->id);
            if($perm === 0){
                return $this->api_not_enable_txt;
            }
        }
        
        $system_mode=$this->getSystemMode($user_obj->company);
        
        if($system_mode=='confirm'){
            $this->stopTimeConfirm($user_obj);
        } elseif($system_mode=='pay_period'){
            $this->stopTime($user_obj);
        }
        
        $this->clearBigGreenButtonPressed($user_obj->id, $system_mode);
    }
    
    public function stopTime($user_obj) {
        $db = $this->db;

        if ($_REQUEST['sessionUs'] == 0) {
            /* setcookie('lastUserLogin', null,  -1);
              setcookie('company', null,  -1);
              setcookie('managerID', null,  -1);
              setcookie('ownerID', null,  -1); */
        }
        
       
        //$password_raw = $this->db->escape(trim($_REQUEST['password_for_verify']));
       // $password = $this->decrypt($password_raw);
        $password=$user_obj->password2;
        
        $lat_raw = $this->db->escape(trim($_REQUEST['lat_end']));
        $lat_end = $this->decrypt($lat_raw);

        $lng_raw = $this->db->escape(trim($_REQUEST['lng_end']));
        $lng_end = $this->decrypt($lng_raw);

        $description_logout_raw = $this->db->escape(trim($_REQUEST['description_logout']));
        $description_logout = $this->decrypt($description_logout_raw);

        $client_ip_raw = $this->db->escape(trim($_REQUEST['client_ip']));
        $client_ip = $this->decrypt($client_ip_raw);



        $current_date = date('Y-m-d');
        $date_exit = date('Y-m-d H:i:s');

        $query = "SELECT id FROM #__users WHERE password2 = '$password' ";
        $db->setQuery($query);
        $u_id = $db->loadResult();

        $itemU = new stdClass;
        $itemU->id = $u_id;
        $itemU->start_time = 0;
        $itemU->status_user = 3;
        $db->updateObject('#__users', $itemU, 'id');

        // Check If user is stamped in
        $query = "SELECT * FROM #__audit_time WHERE id_user = '$u_id' AND date = '$current_date' order by ID desc";
        $db->setQuery($query);
        $data = $db->loadObject();

        // Check if stamped in
        if (!empty($data->id) && !empty($data->date)) {
            // Check if not stamped out
            if ($data->date_exit == 0) {
                // Find latest date and updat exit date      
                $ip2 = $client_ip;


                //$description_logout=filter_input(INPUT_COOKIE, 'temp_logout_desciption', FILTER_SANITIZE_STRING);
                if (!empty($description_logout)) {
                    $description_login = $data->note;
                    $description_logout = $description_login . '-' . $description_logout;
                    $query = "UPDATE #__audit_time SET `date_exit` = '$date_exit', `lat_end`='$lat_end', `lng_end`='$lng_end', `ip_stop`='$ip2', `note`='$description_logout' WHERE `id_user` = '$u_id' AND `date` = '$current_date' AND `id` = '$data->id'";
                } else {
                    $query = "UPDATE #__audit_time SET `date_exit` = '$date_exit', `lat_end`='$lat_end', `lng_end`='$lng_end', `ip_stop`='$ip2' WHERE `id_user` = '$u_id' AND `date` = '$current_date' AND `id` = '$data->id'";
                }

                $db->setQuery($query);
                //setcookie('temp_logout_desciption', null,  -1);

                if ($db->query() && !empty($u_id)) {
                    return $u_id;
                    //setcookie('first_logout', '1',  time()+3600 * 24 * 365);
                } else {
                    return 'not';
                }
            }
        }
    }
    
    private static function stopTimeStatic($user_obj, $data) {
        $db = &JFactory::getDBO();
        //hha
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/end_coordinates1.html', print_r($data, true), FILE_APPEND | LOCK_EX);
        $password=$user_obj->password2;
        
        if(empty($data)){
            $data=$_REQUEST;
        }
        //if(!empty($data)){
            $lat_raw = $db->escape(trim($data['lat_end']));
            //$lat_end = self::decrypt($lat_raw);
            $lat_end = $lat_raw;
            
            $lng_raw = $db->escape(trim($data['lng_end']));
            //$lng_end = self::decrypt($lng_raw);
            $lng_end = $lng_raw;
           
            $description_logout_raw = $db->escape(trim($data['description_logout']));
            //$description_logout =self::decrypt($description_logout_raw);
            $description_logout = $description_logout_raw;
            
            $client_ip_raw = $db->escape(trim($data['client_ip']));
            //$client_ip = self::decrypt($client_ip_raw);
            $client_ip = $client_ip_raw;
        //}


        $current_date = date('Y-m-d');
        $date_exit = date('Y-m-d H:i:s');

        $query = "SELECT id FROM #__users WHERE password2 = '$password' ";
        $db->setQuery($query);
        $u_id = $db->loadResult();

        $itemU = new stdClass;
        $itemU->id = $u_id;
        $itemU->start_time = 0;
        $itemU->status_user = 3;
        $db->updateObject('#__users', $itemU, 'id');

        // Check If user is stamped in
        $query = "SELECT * FROM #__audit_time WHERE id_user = '$u_id' AND date = '$current_date' order by ID desc";
        $db->setQuery($query);
        $data = $db->loadObject();

        // Check if stamped in
        if (!empty($data->id) && !empty($data->date)) {
            // Check if not stamped out
            if ($data->date_exit == 0) {
                // Find latest date and updat exit date      
                $ip2 = $client_ip;


                //$description_logout=filter_input(INPUT_COOKIE, 'temp_logout_desciption', FILTER_SANITIZE_STRING);
                if (!empty($description_logout)) {
                    $description_login = $data->note;
                    $description_logout = $description_login . '-' . $description_logout;
                    $query = "UPDATE #__audit_time SET `date_exit` = '$date_exit', `lat_end`='$lat_end', `lng_end`='$lng_end', `ip_stop`='$ip2', `note`='$description_logout' WHERE `id_user` = '$u_id' AND `date` = '$current_date' AND `id` = '$data->id'";
                } else {
                    $query = "UPDATE #__audit_time SET `date_exit` = '$date_exit', `lat_end`='$lat_end', `lng_end`='$lng_end', `ip_stop`='$ip2' WHERE `id_user` = '$u_id' AND `date` = '$current_date' AND `id` = '$data->id'";
                }

                $db->setQuery($query);
               

                if ($db->query() && !empty($u_id)) {
                    return $u_id;
                    
                } else {
                    return 'not';
                }
            }
        }
    }
    
    public function stopTimeConfirm(...$a) {
        //$user_obj, $data
        $args=func_get_args();
        $user_obj=  $args[0];
        $data0 = $args[1];
        
        $db = $this->db;

        $password=$user_obj->password2;
        
        if(empty($data0)){
            $data0 = $_REQUEST;
        }
        //if(!empty($data)){
            $lat_raw = $this->db->escape(trim($data0['lat_end']));
            $lat_end = $this->decrypt($lat_raw);

            $lng_raw = $this->db->escape(trim($data0['lng_end']));
            $lng_end = $this->decrypt($lng_raw);

            $description_logout_raw = $this->db->escape(trim($data0['description_logout']));
            $description_logout = $this->decrypt($description_logout_raw);

            $client_ip_raw = $this->db->escape(trim($data0['client_ip']));
            $client_ip = $this->decrypt($client_ip_raw);
        //}


        $current_date = date('Y-m-d');
        $date_exit = date('Y-m-d H:i:s');

        $query = "SELECT id FROM #__users WHERE password2 = '$password' ";
        $db->setQuery($query);
        $u_id = $db->loadResult();

        $itemU = new stdClass;
        $itemU->id = $u_id;
        $itemU->start_time = 0;
        $itemU->status_user = 3;
        $db->updateObject('#__users', $itemU, 'id');

        // Check If user is stamped in
        $query = "SELECT * FROM #__audit_time_confirm WHERE id_user = '$u_id' AND date = '$current_date' order by ID desc";
        $db->setQuery($query);
        $data = $db->loadObject();

        // Check if stamped in
        if (!empty($data->id) && !empty($data->date)) {
            // Check if not stamped out
            if ($data->date_exit == 0) {
                // Find latest date and updat exit date      
                $ip2 = $client_ip;


                //$description_logout=filter_input(INPUT_COOKIE, 'temp_logout_desciption', FILTER_SANITIZE_STRING);
                if (!empty($description_logout)) {
                    $description_login = $data->note;
                    $description_logout = $description_login . '-' . $description_logout;
                    $query = "UPDATE #__audit_time_confirm SET `date_exit` = '$date_exit', `lat_end`='$lat_end', `lng_end`='$lng_end', `ip_stop`='$ip2', `note`='$description_logout' WHERE `id_user` = '$u_id' AND `date` = '$current_date' AND `id` = '$data->id'";
                } else {
                    $description_logout = $data->note;
                    $query = "UPDATE #__audit_time_confirm SET `date_exit` = '$date_exit', `lat_end`='$lat_end', `lng_end`='$lng_end', `ip_stop`='$ip2' WHERE `id_user` = '$u_id' AND `date` = '$current_date' AND `id` = '$data->id'";
                }
            
                $db->setQuery($query);
               

                if ($db->query() && !empty($u_id)) {
                    //here0
                    $is_enable_confirm_pp = self::getFinalCombineConfirmAndPpStatus($u_id);
                    if($is_enable_confirm_pp === 1){ 
                        //collect data for pay period stop
                        $stop_pp_data = [
                            'date_exit'=>$date_exit,
                            'lat_end'=>$lat_end,
                            'lng_end'=>$lng_end,
                            'ip_stop'=>$ip2,
                            'note'=>$description_logout,
                            'id_user'=>$u_id, 
                            'date'=>$current_date,
                            'id'=>$data->id
                        ];
                        $this->setStopInPayPeriod($stop_pp_data);
                    }
                    return $u_id;
                    
                } else {
                    return 'not';
                }
            }
        }
    }
    
    private function setStopInPayPeriod($data)
    {
        $db = & JFactory::getDBO();
        //if(!empty($data['note'])){
           $query = "UPDATE #__audit_time SET `date_exit` = '".$data['date_exit']."', "
                   . "`lat_end`='".$data['lat_end']."', "
                   . "`lng_end`='".$data['lng_end']."', "
                   . "`ip_stop`='".$data['ip_stop']."', "
                   . "`note`='".$data['note']."' "
                   . "WHERE `id_user` = '".$data['id_user']."' "
                   . "AND `date` = '".$data['date']."' "
                   . "AND `id` = '".$this->getPpIdByConfirmId($data['id'])."'";
           
           $db->setQuery($query);
           $db->query();
        //}
    }
    
    private function getPpIdByConfirmId($confirm_id)
    {
        $db = & JFactory::getDBO();
        
        $query = "SELECT `id`, `pp_id` FROM #__pp_confirm_connector WHERE `confirm_id` = '".(int)$confirm_id."'";
        $db->setQuery( $query );
        return $db->loadObject()->pp_id;
    }
    
    private static function stopTimeConfirmStatic($user_obj, $data) {
        $db = &JFactory::getDBO();
        /*echo '<pre>';
        print_r($data);
        echo '</pre>';*/
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/end_coordinates.html', print_r($data, true), FILE_APPEND | LOCK_EX);

        $password = $user_obj->password2;
        
                
        if(empty($data)){
            $data=$_REQUEST;
        }
        //if(!empty($data)){
            $lat_raw = $db->escape(trim($data['lat_end']));
            //$lat_end = self::decrypt($lat_raw);
            $lat_end = $lat_raw;
            
            $lng_raw = $db->escape(trim($data['lng_end']));
            //$lng_end = self::decrypt($lng_raw);
            $lng_end = $lng_raw;

            $description_logout_raw = $db->escape(trim($data['description_logout']));
            $description_logout = self::decrypt($description_logout_raw);

            $client_ip_raw = $db->escape(trim($data['client_ip']));
            //$client_ip = self::decrypt($client_ip_raw);
            $client_ip = $client_ip_raw;
        //}


        $current_date = date('Y-m-d');
        $date_exit = date('Y-m-d H:i:s');

        $query = "SELECT id FROM #__users WHERE password2 = '$password' ";
        $db->setQuery($query);
        $u_id = $db->loadResult();

        $itemU = new stdClass;
        $itemU->id = $u_id;
        $itemU->start_time = 0;
        $itemU->status_user = 3;
        $db->updateObject('#__users', $itemU, 'id');

        // Check If user is stamped in
        $query = "SELECT * FROM #__audit_time_confirm WHERE id_user = '$u_id' AND date = '$current_date' order by ID desc";
        $db->setQuery($query);
        $data = $db->loadObject();

        // Check if stamped in
        if (!empty($data->id) && !empty($data->date)) {
            // Check if not stamped out
            if ($data->date_exit == 0) {
                // Find latest date and updat exit date      
                $ip2 = $client_ip;


                //$description_logout=filter_input(INPUT_COOKIE, 'temp_logout_desciption', FILTER_SANITIZE_STRING);
                if (!empty($description_logout)) {
                    $description_login = $data->note;
                    $description_logout = $description_login . '-' . $description_logout;
                    $query = "UPDATE #__audit_time_confirm SET `date_exit` = '$date_exit', `lat_end`='$lat_end', `lng_end`='$lng_end', `ip_stop`='$ip2', `note`='$description_logout' WHERE `id_user` = '$u_id' AND `date` = '$current_date' AND `id` = '$data->id'";
                } else {
                    $query = "UPDATE #__audit_time_confirm SET `date_exit` = '$date_exit', `lat_end`='$lat_end', `lng_end`='$lng_end', `ip_stop`='$ip2' WHERE `id_user` = '$u_id' AND `date` = '$current_date' AND `id` = '$data->id'";
                }

                $db->setQuery($query);
               

                if ($db->query() && !empty($u_id)) {
                    return $u_id;
                    
                } else {
                    return 'not';
                }
            }
        }
    }

    
    public function getLayoutTaskSelect() {
        
        $app = JFactory::getApplication();
        $mode = $this->db->escape(trim($_REQUEST['mode']));
        
        $token = $this->decrypt($_REQUEST['token']);
        $user_obj = $this->getUserByToken($token);
        $dev_n_tools_only = $app->input->get('dev_n_tools_only');
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/getLayoutTaskSelect01.html', print_r($dev_n_tools_only .PHP_EOL, true), FILE_APPEND | LOCK_EX); 
        
        $password = $user_obj->password2;
        $user_id = $user_obj->id;
        
        if($user_obj->is_hide == 1){
            return $this->user_is_hidden_txt;
        }
        
        if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
            $perm = $this->checkGlobalApiPermission( $user_id);
            if($perm === 0){
                return $this->api_not_enable_txt;
            }
        }
        JLoader::register('AuditModelTask_manager', JPATH_ROOT . '/components/com_audit/models/task_manager.php');
        $model_task_manager = JModelLegacy::getInstance('Task_manager', 'AuditModel');
        $sync_with_main_tasks_state = $model_task_manager->getSyncWithMainTasksStateApi($user_obj->owner_id);
        //return $sync_with_main_tasks_state;
        $all_submenu_tasks = $model_task_manager->getSubmenuTaskListApi($user_obj->owner_id);
        
        //return $all_submenu_tasks;
        if ($mode === 'password') {
            $pass = $password;

            $query = "SELECT * FROM #__users WHERE `password2` = '" . $pass . "'";
            $this->db->setQuery($query);
            $select_user_by_password = $this->db->loadObject();

            $user_by_password = JFactory::getUser((int) $select_user_by_password->id);
            $user = JFactory::getUser((int) $user_id);
            $manager_obj = JFactory::getUser($user->owner_id);
            
            $query = "SELECT * FROM #__users WHERE `owner_id` = '" . $user->owner_id . "' AND password2 = '" . $pass . "'";
            $this->db->setQuery($query);
            $userlist = $this->db->loadAssoc();


            if (is_array($userlist)) {
                $userlist = $userlist['id'];
            } else {
                $userlist = '';
            }

           
            $query = "SELECT * FROM #__audit_task_list WHERE `id_user` = '" . $user->owner_id . "'";
            if( $dev_n_tools_only == 1){ 
                $query .= " AND `is_for_devices_n_tools` = '1'";
            }
            $query .= " ORDER BY `id` DESC";
            $this->db->setQuery($query);
            $task_list = $this->db->loadObjectList();
            
            if(empty($task_list) && $this->enable_adding_default_tasks == '1'){
                $model_task_manager->addDefaultTasks($user_obj->owner_id);
                
                $query = "SELECT * FROM #__audit_task_list WHERE `id_user` = '" . $user->owner_id . "'";
                if( $dev_n_tools_only == 1){ 
                    $query .= " AND `is_for_devices_n_tools` = '1'";
                }
                $query .= " ORDER BY `id` DESC";
                $this->db->setQuery($query);
                $task_list = $this->db->loadObjectList();
            }
            
            if($this->enable_task_manager_dk_api == '1' && !empty($manager_obj->dk_token) && $manager_obj->sync_dk_tasks == 1){
                $query = "SELECT * FROM #__audit_dk_task_list WHERE `id_user` = '".$user->owner_id."' ORDER BY `id` DESC";
                $this->db->setQuery($query);
                $dk_task_list = $this->db->loadObjectList();
                
                $subtasks_dk_list = json_decode($model_task_manager->getDkSubtasksForApi($user->owner_id));
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/dk_tasks.html', print_r($subtasks_dk_list, true), FILE_APPEND | LOCK_EX);
            }
            
            $prepare_task_list_array = [];
            $i = 0;
            if($this->enable_gps_type_of_tasks == '1'){
                $prepare_task_list_array['gps_radius'] = $this->getGpsRadiusObj($manager_obj)->radius;
            }
            foreach ($task_list as $one_task) {
                if (!empty($one_task->text) && !empty($select_user_by_password) && in_array($user_by_password->id, explode(',', $one_task->attached_users)) && in_array($userlist, explode(',', $one_task->attached_users))) {
                    if($sync_with_main_tasks_state == 1 || $one_task->sync_with_submenu == 1){
                        $subtask_list = $all_submenu_tasks;
                    } else{
                        $subtask_list = $this->getSubtasks($one_task->id);
                    }
                    

                    $prepare_task_list_array[$i]['task_id'] = $one_task->id;
                    $prepare_task_list_array[$i]['task_text'] = $one_task->text;
                    $prepare_task_list_array[$i]['subtasks'] = $subtask_list;
                    if($this->enable_gps_type_of_tasks == '1'){
                        $prepare_task_list_array[$i]['is_gps_task'] = $one_task->is_gps_task;
                        if($one_task->is_gps_task == 1){
                            $prepare_task_list_array[$i]['task_text'] = $one_task->task_address;
                            $prepare_task_list_array[$i]['task_coordinates'] = json_decode($one_task->task_coordinates);
                            
                        }
                    }
                    if($this->enable_automatick_clock_icon_in_task_manager == '1'){
                        $prepare_task_list_array[$i]['auto_clock_in'] = $one_task->is_auto;
                    }
                    $i++;
                }
            } 
            if ($this->enable_task_manager_dk_api == '1' && !empty($manager_obj->dk_token) && $manager_obj->sync_dk_tasks == 1 && $manager_obj->sync_uniconta_tasks != '1') {
                foreach ($dk_task_list as $one_task) {
                    if (!empty($one_task->text) && !empty($select_user_by_password) && in_array($user_by_password->id, explode(',', $one_task->attached_users)) && in_array($userlist, explode(',', $one_task->attached_users))) {
                        //$subtask_list = $this->getSubtasks($one_task->id);

                        $prepare_task_list_array[$i]['task_id'] = $one_task->id;
                        $prepare_task_list_array[$i]['task_dk_id'] = $one_task->original_id;
                        $prepare_task_list_array[$i]['task_text'] = $one_task->original_id . ' | ' . $one_task->text;

                        $j = 0;
                        foreach ($subtasks_dk_list as $one_dk_subtask) {
                            $prepare_task_list_array[$i]['subtasks'][$j]['text'] = $one_task->original_id . ' | ' . $one_task->text . ' | ' . $one_dk_subtask->text;
                            $prepare_task_list_array[$i]['subtasks'][$j]['id_user'] = $one_dk_subtask->id_user;

                            $j++;
                        }

                        $prepare_task_list_array[$i]['is_dk_task'] = 1;

                        $i++;
                    }
                }
            }
            
            //uniconta attached
            if ($this->enable_uniconta_tasks == '1' && $manager_obj->sync_uniconta_tasks == '1' && !empty($manager_obj->uniconta_uname) && !empty($manager_obj->uniconta_upassw)) {
                $query = "SELECT * FROM $this->uniconta_table_name WHERE `id_user` = '" . $user->owner_id . "' ORDER BY `id` DESC";
                $this->db->setQuery($query);
                $uniconta_task_list = $this->db->loadObjectList(); 
                
                if(!empty($uniconta_task_list)){
                    $subtasks_uniconta_list = $model_task_manager->getUnicontaSubtasksForApi($user->owner_id);
                }

                foreach ($uniconta_task_list as $one_task) {
                    if (!empty($one_task->number0) && !empty($select_user_by_password) && in_array($user_by_password->id, explode(',', $one_task->attached_users)) && in_array($userlist, explode(',', $one_task->attached_users))) {
                        $prepare_task_list_array[$i]['task_id'] = $one_task->id;
                        $prepare_task_list_array[$i]['task_uniconta_id'] = $one_task->number0;
                        $prepare_task_list_array[$i]['task_text'] = $one_task->number0 . ' | ' . $one_task->account . ' | ' . $one_task->name;

                        $j = 0;
                        $prepare_task_list_array[$i]['subtasks'] = [];
                        foreach ($subtasks_uniconta_list as $one_subtask) {
                            if($one_subtask->parent_id === $one_task->id){
                                $prepare_task_list_array[$i]['subtasks'][$j]['text'] =  $one_subtask->name;
                                $prepare_task_list_array[$i]['subtasks'][$j]['id_user'] = $one_subtask->id_user;

                                $j++;
                            }
                        }

                        $prepare_task_list_array[$i]['is_uniconta_task'] = 1;

                        $i++;
                    }
                }
            }
            
                
            $password_correct = '0';
            if (!empty($select_user_by_password)) {
                $password_correct = '1';
            }


            return $prepare_task_list_array;
        } elseif ($mode === 'not_password') {
            $user = JFactory::getUser((int) $user_id);
            $manager_obj = JFactory::getUser($user->owner_id);
            
            $config = &JFactory::getConfig();  
            //$enable_subtask_delete = $config->get('enable_subtask_delete');
            $enable_sortable_in_task_manager_and_api = $config->get('enable_sortable_in_task_manager_and_api');
        
            if ($enable_sortable_in_task_manager_and_api == '1') {
                $order_by = '`ordering`';
            } else {
                $order_by = '`id` DESC';
            }

            $query = "SELECT * FROM #__audit_task_list WHERE `id_user` = '" . $user->owner_id . "' AND `attached_users`=''";
            if( $dev_n_tools_only == 1){ 
                $query .= " AND `is_for_devices_n_tools` = '1'";
            }
            $query .= " ORDER BY $order_by";
            $this->db->setQuery($query);
            $task_list = $this->db->loadObjectList();
            
            if(empty($task_list) && $this->enable_adding_default_tasks == '1'){
                $model_task_manager->addDefaultTasks($user_obj->owner_id);
                
                $query = "SELECT * FROM #__audit_task_list WHERE `id_user` = '" . $user->owner_id . "' AND `attached_users`=''";
                if( $dev_n_tools_only == 1){ 
                    $query .= " AND `is_for_devices_n_tools` = '1'";
                }
                $query .= " ORDER BY $order_by";
                $this->db->setQuery($query);
                $task_list = $this->db->loadObjectList();
            }
            if ($this->enable_task_manager_dk_api == '1' && !empty($manager_obj->dk_token) && $manager_obj->sync_dk_tasks == 1 && $manager_obj->sync_uniconta_tasks != '1') {
                $query = "SELECT * FROM #__audit_dk_task_list WHERE `id_user` = '" . $user->owner_id . "' AND `attached_users`='' ORDER BY $order_by";
                $this->db->setQuery($query);
                $dk_task_list = $this->db->loadObjectList();
                
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/dk_tasks.html', print_r($dk_task_list, true), FILE_APPEND | LOCK_EX);
                    
                //$subtasks_dk_list = json_decode($model_task_manager->getDkSubtasksForApi());
                
               
                //load task from DK api
                if(empty($dk_task_list)){   
                     $dk_task_list_for_api = json_decode($model_task_manager->getDkTaskListAppApi($user->owner_id));
                    //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/dk_tasks.html', print_r($dk_task_list_for_api, true), FILE_APPEND | LOCK_EX);
                }
                $subtasks_dk_list = json_decode($model_task_manager->getDkSubtasksForApi($user->owner_id));
            }
            if ($this->enable_uniconta_tasks == '1' && $manager_obj->sync_uniconta_tasks == '1' && !empty($manager_obj->uniconta_uname) && !empty($manager_obj->uniconta_upassw)) {
                $query = "SELECT * FROM $this->uniconta_table_name WHERE `id_user` = '" . $user->owner_id . "' AND `attached_users`='' ORDER BY $order_by";
                $this->db->setQuery($query);
                $uniconta_task_list = $this->db->loadObjectList(); 
                
                if(!empty($uniconta_task_list)){
                    $subtasks_uniconta_list = $model_task_manager->getUnicontaSubtasksForApi($user->owner_id);
                }
            }

            $prepare_task_list_array = [];
            $ij = 0;
            if($this->enable_gps_type_of_tasks == '1'){
                $prepare_task_list_array['gps_radius'] = $this->getGpsRadiusObj($manager_obj)->radius;
            }
            foreach ($task_list as $one_task) {
                if ($one_task->text != '') {
                    //$subtask_list = $this->getSubtasks($one_task->id);
                    
                    if($sync_with_main_tasks_state == 1 || $one_task->sync_with_submenu == 1){
                        $subtask_list = $all_submenu_tasks;
                    } else{
                        $subtask_list = $this->getSubtasks($one_task->id);
                    }
                    
                    $prepare_task_list_array[$ij]['task_id'] = $one_task->id;
                    $prepare_task_list_array[$ij]['task_text'] = $one_task->text;
                    $prepare_task_list_array[$ij]['subtasks'] = $subtask_list;
                    if($this->enable_gps_type_of_tasks == '1'){
                        $prepare_task_list_array[$ij]['is_gps_task'] = $one_task->is_gps_task;
                        if($one_task->is_gps_task == 1){
                            $prepare_task_list_array[$ij]['task_text'] = $one_task->task_address;
                            $prepare_task_list_array[$ij]['task_coordinates'] = json_decode($one_task->task_coordinates);
                            
                        }
                    }
                    if($this->enable_automatick_clock_icon_in_task_manager == '1'){
                        $prepare_task_list_array[$ij]['auto_clock_in'] = $one_task->is_auto;
                    }
                    $ij++;
                }
            } 
        
            //DK:
            if($this->enable_task_manager_dk_api == '1' && empty($dk_task_list) && !empty($manager_obj->dk_token) && $manager_obj->sync_dk_tasks == 1){
                foreach ($dk_task_list_for_api as $one_task) {
                   
                    $prepare_task_list_array[$ij]['task_id'] = $one_task->Number;
                    $prepare_task_list_array[$ij]['task_dk_id'] = $one_task->Number;
                    $prepare_task_list_array[$ij]['task_text'] = $one_task->Number.' | '.$one_task->Name;
                    //$prepare_task_list_array[$ij]['subtasks'] = $subtasks_dk_list;
                    
                    $ja = 0;
                    foreach($subtasks_dk_list as $one_dk_subtask){
                        $prepare_task_list_array[$ij]['subtasks'][$ja]['text'] = $one_task->Number.' | '.$one_task->Name.' | '.$one_dk_subtask->text;
                        $prepare_task_list_array[$ij]['subtasks'][$ja]['id_user'] = $one_dk_subtask->id_user;
                        
                        $ja++;
                    }
                    
                    $prepare_task_list_array[$ij]['is_dk_task'] = 1;

                    $ij++;
                   
                } 
            } elseif(!empty($dk_task_list) && !empty($manager_obj->dk_token) && $manager_obj->sync_dk_tasks == 1) {
                foreach ($dk_task_list as $one_task) {
                    /*if(!in_array($one_task->original_id, array_column((array)$dk_task_list_for_api, 'Number'))){//this code actualize task list(if delete on DK server-delete here)
                        continue; 
                    }*/
                    if($one_task->JobStatus != 1){
                        continue;
                    }
                    //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/dk_tasks.html', print_r(array_column($dk_task_list_for_api, 'Number'), true), FILE_APPEND | LOCK_EX); 
                    //if ($one_task->text != '') {
                    //$subtask_list = $this->getSubtasks($one_task->id);
                    
                    $prepare_task_list_array[$ij]['task_id'] = $one_task->id;
                    $prepare_task_list_array[$ij]['task_dk_id'] = $one_task->original_id;
                    $prepare_task_list_array[$ij]['task_text'] = $one_task->original_id.' | '.$one_task->text;
                    //$prepare_task_list_array[$ij]['subtasks'] = $subtasks_dk_list;
                    
                    $jb = 0;
                    foreach($subtasks_dk_list as $one_dk_subtask){
                        $prepare_task_list_array[$ij]['subtasks'][$jb]['text'] = $one_task->original_id.' | '.$one_task->text.' | '.$one_dk_subtask->text;
                        $prepare_task_list_array[$ij]['subtasks'][$jb]['id_user'] = $one_dk_subtask->id_user;
                        
                        $jb++;
                    }
                    $prepare_task_list_array[$ij]['is_dk_task'] = 1;

                    $ij++;
                    // }
                }
            }
            
            //uniconta
            if (!empty($uniconta_task_list) && $this->enable_uniconta_tasks == '1' && $manager_obj->sync_uniconta_tasks == '1' && !empty($manager_obj->uniconta_uname) && !empty($manager_obj->uniconta_upassw)) {
                
                foreach ($uniconta_task_list as $one_task) {  
                    $prepare_task_list_array[$ij]['task_id'] = $one_task->id;
                    $prepare_task_list_array[$ij]['task_uniconta_id'] = $one_task->number0;
                    $prepare_task_list_array[$ij]['task_text'] = $one_task->number0 . ' | ' . $one_task->account . ' | ' . $one_task->name;
                  
                    
                    $jb = 0;
                    $prepare_task_list_array[$ij]['subtasks'] = [];
                    foreach ($subtasks_uniconta_list as $one_subtask) {
                        if($one_subtask->parent_id === $one_task->id){
                            $prepare_task_list_array[$ij]['subtasks'][$jb]['text'] =  $one_subtask->name;
                            $prepare_task_list_array[$ij]['subtasks'][$jb]['id_user'] = $one_subtask->id_user;

                            $jb++;
                        }
                    }
                    $prepare_task_list_array[$ij]['is_uniconta_task'] = 1;

                    $ij++;
                    // }
                }
            }

            return $prepare_task_list_array;
        }
    }
    
    private function getGpsRadiusObj(object $manager) {
        $query = "SELECT * FROM " . $this->db->quoteName($this->radius_table_name) . " WHERE `manager_id` = '$manager->id'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        return $data;
    }
    
    private function getSubtasks($parent_id) {
        $parent_id = (int) $parent_id;
        $query = "SELECT * FROM #__audit_subtasks_list WHERE `parent_id` = '" . $parent_id . "' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $list = $this->db->loadObjectList();

        return $list;
    }

    public function getLayoutSpecificTaskAPISelect() {
        $lang = $_REQUEST['lang'];

        if ($lang == 'is') {
            $this->lang->setLanguage('is-IS');
            $this->lang->load();
        }

        $user_id = (int) $_REQUEST['user_id'];
        
        $password_raw = $this->db->escape(trim($_REQUEST['password_for_verify']));
        $password = $this->decrypt($password_raw);

        $pass = $password;

        $user = JFactory::getUser((int) $user_id);
        
        if($user->is_hide == 1){
            return $this->user_is_hidden_txt;
        }
        
        if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
            $perm = $this->checkGlobalApiPermission($user->id);
            if($perm === 0){
                return $this->api_not_enable_txt;
            }
        }
        
        $query = "SELECT * FROM #__users WHERE `password2` = '" . $pass . "' AND `owner_id` = '" . $user->owner_id . "'";
        $this->db->setQuery($query);
        $select_user_by_password = $this->db->loadObject();

        $user_by_password = JFactory::getUser((int) $select_user_by_password->id);

        $query = "SELECT * FROM #__users WHERE `owner_id` = '" . $user->owner_id . "' AND password2 = '" . $pass . "'";
        $this->db->setQuery($query);
        $userlist = $this->db->loadAssoc();

        if (is_array($userlist)) {
            $userlist = $userlist['id'];
        } else {
            $userlist = '';
        }

        $password_correct = '0';
        if (!empty($select_user_by_password)) {
            $password_correct = '1';
        }

        $token = $user_by_password->api_token;
        $result = $this->apiGetTaskList($token);
        //return $result;

        if (!empty($result->result)) {
            $prepare_task_list_array = [];
            $i = 0;
            foreach ($result->result as $one_task) {
                if (!empty($one_task->field4)) {
                    if ($one_task->start == '0') {
                        $start_stop_mode = 'start_co';
                    } elseif ($one_task->start == '1') {
                        $start_stop_mode = 'stop_co';
                    }

                    $prepare_task_list_array[$i]['task_id'] = $one_task->id;
                    $prepare_task_list_array[$i]['task_text'] = $one_task->field4;
                    $prepare_task_list_array[$i]['task_field2'] = $one_task->field2;
                    $prepare_task_list_array[$i]['task_unit'] = $one_task->unit;
                    $prepare_task_list_array[$i]['task_field3'] = $one_task->field3;
                    $prepare_task_list_array[$i]['task_start'] = $one_task->start;
                }

                $i++;
            }
        }


        return [
            'result' => $prepare_task_list_array,
            'response' => $result->result
        ];
    }

    private function apiGetTaskList($token) {
        if ($curl = curl_init()) {
            //prepare password from api
            $prepare_passw = $this->preparePassw($this->password_api_old);

            $options = [
                CURLOPT_URL => empty($_SERVER['HTTPS']) ? 'http://' : 'https://' . $_SERVER['SERVER_NAME'] . '/api/api.php',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => [
                    'passw' => $prepare_passw,
                    'action' => 'getTaskList',
                    'token' => $token
                ],
            ];

            curl_setopt_array($curl, $options);
            $out = curl_exec($curl);

            curl_close($curl);

            return json_decode($out);
        } else {
            exit('Curl not init');
        }
    }

    public function getUserMode() {
        $user_id = (int) $_REQUEST['user_id'];
        
        $query = "SELECT * FROM #__users WHERE `id` = '" . $user_id . "'";
        $this->db->setQuery($query);
        $user_obj = $this->db->loadObject();
        
        if($user_obj->is_hide == 1){
            return $this->user_is_hidden_txt;
        }
        
        if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
            $perm = $this->checkGlobalApiPermission($user_id);
            if($perm === 0){
                return $this->api_not_enable_txt;
            }
        }

        $current_date = date('Y-m-d');
        $query = "SELECT * FROM #__audit_time WHERE `id_user` = '$user_id' AND `date`='" . $current_date . "' AND `date_exit`='0000-00-00 00:00:00' ORDER BY `id` DESC LIMIT 0, 1";
        $this->db->setQuery($query);
        $rez = $this->db->loadObjectList();
        //print_r($res);

        if (!empty($rez)) {
            $res = '1';
        } else {
            $res = '0';
        }
        return $res;
    }

    

    public function startCOTaskAPI() {
        $user_id = (int) $_REQUEST['user_id'];
        
        $query = "SELECT * FROM #__users WHERE `id` = '" . $user_id . "'";
        $this->db->setQuery($query);
        $user_obj = $this->db->loadObject();
        
        if($user_obj->is_hide == 1){
            return $this->user_is_hidden_txt;
        }
        
        if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
            $perm = $this->checkGlobalApiPermission($user_id);
            if($perm === 0){
                return $this->api_not_enable_txt;
            }
        }
        
        $lang = $this->db->escape(trim($_REQUEST['lang']));

        $password_raw = $this->db->escape(trim($_REQUEST['password_for_verify']));
        $password = $this->decrypt($password_raw);

        $task_id = (int) $_REQUEST['task_id'];
        $hours = $this->db->escape(trim($_REQUEST['hours']));
        $unit = $this->db->escape(trim($_REQUEST['unit']));
        $item = $this->db->escape(trim($_REQUEST['item']));
        $mode = $this->db->escape(trim($_REQUEST['mode']));
        $lat = $this->db->escape(trim($_REQUEST['lat']));
        $lng = $this->db->escape(trim($_REQUEST['lng']));

        //$res=$model->startCOTaskAPI($password, $user_id, $task_id, $hours, $unit, $item, $mode, $lat, $lng);

        if ($lang == 'is') {
            $this->lang->setLanguage('is-IS');
            $this->lang->load();
        }

        $pass = $password;

        $user = JFactory::getUser((int) $user_id);

        $query = "SELECT * FROM #__users WHERE `password2` = '" . $pass . "' AND `owner_id` = '" . $user->owner_id . "'";
        $this->db->setQuery($query);
        $select_user_by_password = $this->db->loadObject();

        $user_by_password = JFactory::getUser((int) $select_user_by_password->id);
        $token = $user_by_password->api_token;


        if (!empty($select_user_by_password)) {
            if ($curl = curl_init()) {
                //prepare password from api
                $prepare_passw = $this->preparePassw($this->password_api_old);

                $options = [
                    CURLOPT_URL => empty($_SERVER['HTTPS']) ? 'http://' : 'https://' . $_SERVER['SERVER_NAME'] . '/api/api.php',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_POST => true,
                    CURLOPT_POSTFIELDS => [
                        'passw' => $prepare_passw,
                        'action' => 'startCOTime',
                        'token' => $token,
                        'id' => $task_id,
                        'hours' => $hours,
                        'unit' => $unit,
                        'item' => $item,
                        'mode' => $mode,
                        'lat' => $lat,
                        'lng' => $lng
                    ]
                ];

                curl_setopt_array($curl, $options);
                $out = curl_exec($curl);

                curl_close($curl);
            } else {
                exit('Curl not init');
            }
        }

        return [
            'res' => $out,
            'lang' => $lang,
            'task_id' => $task_id,
            'mode' => $mode,
            'lat' => $lat,
            'lng' => $lng
        ];

      
    }
    
    public function saveState() {
        $user_id = (int) $_REQUEST['user_id'];
        
        if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
            $perm = $this->checkGlobalApiPermission($user_id);
            if($perm === 0){
                return $this->api_not_enable_txt;
            }
        }
        
        $lang = $this->db->escape(trim($_REQUEST['lang']));

        $password_raw = $this->db->escape(trim($_REQUEST['password_for_verify']));
        $password = $this->decrypt($password_raw);

        $task_id = (int) $_REQUEST['task_id'];
        $hours = $this->db->escape(trim($_REQUEST['hours']));
        $unit = $this->db->escape(trim($_REQUEST['unit']));
        $item = $this->db->escape(trim($_REQUEST['item']));

        if ($lang == 'is') {
            $this->lang->setLanguage('is-IS');
            $this->lang->load();
        }

        $pass = $password;

        $user = JFactory::getUser((int) $user_id);
        if($user->is_hide == 1){
            return $this->user_is_hidden_txt;
        }
        $query = "SELECT * FROM #__users WHERE `password2` = '" . $pass . "' AND `owner_id` = '" . $user->owner_id . "'";
        $this->db->setQuery($query);
        $select_user_by_password = $this->db->loadObject();

        $user_by_password = JFactory::getUser((int) $select_user_by_password->id);
        $token = $user_by_password->api_token;
        
 

        if (!empty($select_user_by_password)) {
            if ($curl = curl_init()) {
                //prepare password from api
                $prepare_passw = $this->preparePassw($this->password_api_old);

                $options = [
                    CURLOPT_URL => empty($_SERVER['HTTPS']) ? 'http://' : 'https://' . $_SERVER['SERVER_NAME'] . '/api/api.php',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_POST => true,
                    CURLOPT_POSTFIELDS => [
                        'passw' => $prepare_passw,
                        'action' => 'addFieldToTask',
                        'token' => $token,
                        'id' => $task_id,
                        'hours' => $hours,
                        'unit' => $unit,
                        'item' => $item,
                       
                    ]
                ];

                curl_setopt_array($curl, $options);
                $out = curl_exec($curl);

                curl_close($curl);
            } else {
                exit('Curl not init');
            }
        }

       return [
            'res' =>  $out,
            'lang' => $lang,
            'task_id' => $task_id,
           
        ];
  
    }
    
    public function saveSessionImages()
    {
        $jinput = JFactory::getApplication()->input;
        
        $token_raw = trim($_REQUEST['user_token']);
        $user_token = $this->decrypt($token_raw);     
        
        $user_obj = $this->getUserByToken($user_token);
        if($user_obj->is_hide == 1){
            return $this->user_is_hidden_txt;
        }
        if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
            $perm = $this->checkGlobalApiPermission($user_obj->id);
            if($perm === 0){
                return $this->api_not_enable_txt;
            }
        }
        
        $system_mode = $this->getSystemMode($user_obj->company);
        $session_date = $jinput->get('session_date', '', 'STRING');
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/api0az.html', print_r($system_mode.PHP_EOL, true), FILE_APPEND | LOCK_EX);
                
        // $system_mode;
        if($system_mode == 'confirm'){
           $res = $this->checkAndUploadFilesConfirm($_FILES, $user_obj, $session_date);
        } elseif($system_mode == 'pay_period'){
            $res = $this->checkAndUploadFilesPayPeriod($_FILES, $user_obj, $session_date);
        }
        
        return $res;
    }
    
    private function checkAndUploadFilesConfirm($files, $user_obj, $session_date)
    {
        if(!empty($files['file_start']) || !empty($files['file_stop'])){
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/api0az.html', print_r('step 0', true), FILE_APPEND | LOCK_EX);
            $res = $this->uploadImg($files, 8000000, $user_obj, $session_date);
            //return 'success, uploading';
        } else{
            $res='upload one file';
        }
        
        return $res;
    }
    
    private function checkAndUploadFilesPayPeriod($files, $user_obj, $session_date)
    {
        if(!empty($files['file_start']) || !empty($files['file_stop'])){
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/api0az.html', print_r('step one'.PHP_EOL, true), FILE_APPEND | LOCK_EX);
            $res = $this->uploadImgPayPeriod($files, 8000000, $user_obj, $session_date);
            //return 'success, uploading';
        } else{
            $res='upload one file';
        }
        
        return $res;
    }
    
    public function uploadImgPayPeriod($files_array, $max_img_size, $user_obj, $session_date)
    {
       $rezult=false;
            $array_normal_uploadfiles=[];
            $i=0;
            
            foreach($files_array as $k=>$v)
            {
                $one_file_start_or_stop=(array)$v;
                
                $tmp_name=$one_file_start_or_stop['tmp_name'];
                $unikal_hash=md5(uniqid(rand(), true));
                $info = new SplFileInfo($one_file_start_or_stop['name']);
                $file_ext=$info->getExtension();
                
                //filename= start--userToken_sessionDate_hash_.extension
                if($k==='file_start'){
                    $uploadfile_art=$_SERVER['DOCUMENT_ROOT']."/images/pay_period_start_images/start--".$user_obj->api_token.'_'.$session_date.'_'.$unikal_hash."_.".$file_ext;
                }
                //filename= stop--userToken_sessionDate_hash_.extension
                if($k==='file_stop'){
                    $uploadfile_art=$_SERVER['DOCUMENT_ROOT']."/images/pay_period_stop_images/stop--".$user_obj->api_token.'_'.$session_date.'_'.$unikal_hash."_.".$file_ext;
                }
               
                $file_type=$one_file_start_or_stop['type'];
                $real_img_size=$one_file_start_or_stop['size'];
                
                if($k==='file_start' || $k==='file_stop'){
                    if($this->checkFileType($tmp_name)==true){//open file and check signature
                        if(($file_type == "image/jpg") || ($file_type  == "image/jpeg") || ($file_type  == "image/png") || ($file_type  == "image/gif")){//check mime types
                            if($real_img_size <= $max_img_size){//check img size
                                if(move_uploaded_file($tmp_name, $uploadfile_art)){//upload img
                                    //resize and replace file in server
                                    $this->resizeImage($uploadfile_art, '');
                                    
                                    $this->recordImageInDBPayPeriod($uploadfile_art, $k, $user_obj, $session_date);
                                }
                                $array_normal_uploadfiles[$i]=$uploadfile_art;//add uploaded files for response array
                            }
                        }
                    }
                }
                $i++;
            }
          
            return $array_normal_uploadfiles;
    }
    
    public function uploadImg($files_array, $max_img_size, $user_obj, $session_date)
    {
       $rezult=false;
            $array_normal_uploadfiles=[];
            $i=0;
            
            foreach($files_array as $k=>$v)
            {
                $one_file_start_or_stop=(array)$v;
                
                $tmp_name=$one_file_start_or_stop['tmp_name'];
                $unikal_hash=md5(uniqid(rand(), true));
                $info = new SplFileInfo($one_file_start_or_stop['name']);
                $file_ext=$info->getExtension();
                $upload_filename='';
                
                //filename= start--userToken_sessionDate_hash_.extension
                if($k==='file_start'){
                    $upload_filename="start--".$user_obj->api_token.'_'.$session_date.'_'.$unikal_hash."_.".$file_ext;
                    $uploadfile_art=$_SERVER['DOCUMENT_ROOT']."/images/confirm_start_images/".$upload_filename;
                }
                //filename= stop--userToken_sessionDate_hash_.extension
                if($k==='file_stop'){
                    $upload_filename="stop--".$user_obj->api_token.'_'.$session_date.'_'.$unikal_hash."_.".$file_ext;
                    $uploadfile_art=$_SERVER['DOCUMENT_ROOT']."/images/confirm_stop_images/".$upload_filename;
                }
               
                $file_type=$one_file_start_or_stop['type'];
                $real_img_size=$one_file_start_or_stop['size'];
                
                if($k==='file_start' || $k==='file_stop'){
                    if($this->checkFileType($tmp_name)==true){//open file and check signature
                        if(($file_type == "image/jpg") || ($file_type  == "image/jpeg") || ($file_type  == "image/png") || ($file_type  == "image/gif")){//check mime types
                            if($real_img_size <= $max_img_size){//check img size
                                if(move_uploaded_file($tmp_name, $uploadfile_art)){//upload img
                                    //resize and replace file in server
                                    $this->resizeImage($uploadfile_art, $upload_filename);
                                    
                                    //save changes in db
                                    $this->recordImageInDBConfirm($uploadfile_art, $k, $user_obj, $session_date);
                                }
                                $array_normal_uploadfiles[$i]=$uploadfile_art;//add uploaded files for response array
                            }
                        }
                    }
                }
                $i++;
            }
          
            return $array_normal_uploadfiles;
    }
        
    private function checkFileType($file)
    {
            if (!$f = fopen($file, 'rb')) {
                return false;
            }

            $data = fread($f, 8);
            fclose($f);

            if (
                @array_pop(unpack('H12', $data)) == '474946383961' ||
                @array_pop(unpack('H12', $data)) == '474946383761'
            ) {
                return 'GIF';
            } else if (
                @array_pop(unpack('H4', $data)) == 'ffd8'
            ) {
                return 'JPEG';
            } else if (
                @array_pop(unpack('H16', $data)) == '89504e470d0a1a0a'
            ) {
                return 'PNG';
            }

            return false;
    }
        
    private function recordImageInDBConfirm($uploadfile_art, $k, $user_obj, $session_date)
    {
        $mysql_date=DateTime::createFromFormat('d.m.Y', $session_date)->format('Y-m-d');
        
        
        $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '" . $user_obj->id . "' AND `date` = '" . $mysql_date . "' ORDER BY `id` DESC LIMIT 0,1";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/api0az.html', print_r($data, true), FILE_APPEND | LOCK_EX);
        
        if($data[0]->is_confirm == 0){
            if($k==='file_start'){
                $query = "UPDATE #__audit_time_confirm SET `img_start`='$uploadfile_art' WHERE `id`= '".$data[0]->id."'";
                $this->db->setQuery($query);
                $this->db->query();
            }
            if($k==='file_stop'){ 
                $query = "UPDATE #__audit_time_confirm SET `img_stop`='$uploadfile_art' WHERE `id`= '".$data[0]->id."'";
                $this->db->setQuery($query);
                $this->db->query();
            }
        } else{
            $query = "SELECT * FROM #__audit_time WHERE `id_user` = '" . $user_obj->id . "' AND `date` = '" . $mysql_date . "' ORDER BY `id` DESC LIMIT 0,1";
            $this->db->setQuery($query);
            $data = $this->db->loadObjectList();
            
            if($k==='file_start'){
                $query = "UPDATE #__audit_time SET `img_start`='$uploadfile_art' WHERE `id`= '".$data[0]->id."'";
                $this->db->setQuery($query);
                $this->db->query();
            }
            if($k==='file_stop'){ 
                $query = "UPDATE #__audit_time SET `img_stop`='$uploadfile_art' WHERE `id`= '".$data[0]->id."'";
                $this->db->setQuery($query);
                $this->db->query();
            }
        }
        
        $is_enable_confirm_pp = self::getFinalCombineConfirmAndPpStatus($user_obj->id);
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/api0az.html', print_r('$is_enable_confirm_pp'. $is_enable_confirm_pp, true), FILE_APPEND | LOCK_EX);   

        if ($is_enable_confirm_pp === 1) {
            $query = "SELECT * FROM #__audit_time WHERE `id_user` = '" . $user_obj->id . "' AND `date` = '" . $mysql_date . "' ORDER BY `id` DESC LIMIT 0,1";
            $this->db->setQuery($query);
            $data = $this->db->loadObjectList();

            if ($k === 'file_start') {
                $query = "UPDATE #__audit_time SET `img_start`='$uploadfile_art' WHERE `id`= '" . $data[0]->id . "'";
                $this->db->setQuery($query);
                $this->db->query();
            }
            if ($k === 'file_stop') {
                $query = "UPDATE #__audit_time SET `img_stop`='$uploadfile_art' WHERE `id`= '" . $data[0]->id . "'";
                $this->db->setQuery($query);
                $this->db->query();
            }
        }
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/api0z.html', print_r($data, true), FILE_APPEND | LOCK_EX);
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/api0z.html', print_r($query, true), FILE_APPEND | LOCK_EX);
    }
    
    private function recordImageInDBPayPeriod($uploadfile_art, $k, $user_obj, $session_date)
    {
        $mysql_date = DateTime::createFromFormat('d.m.Y', $session_date)->format('Y-m-d');
        
        
            $query = "SELECT * FROM #__audit_time WHERE `id_user` = '" . $user_obj->id . "' AND `date` = '" . $mysql_date . "' ORDER BY `id` DESC LIMIT 0,1";
            $this->db->setQuery($query);
            $data = $this->db->loadObjectList();
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/api0az.html', print_r($data, true), FILE_APPEND | LOCK_EX);
            if($k==='file_start'){
                $query = "UPDATE #__audit_time SET `img_start`='$uploadfile_art' WHERE `id`= '".$data[0]->id."'";
                $this->db->setQuery($query);
                $this->db->query();
            }
            if($k==='file_stop'){ 
                $query = "UPDATE #__audit_time SET `img_stop`='$uploadfile_art' WHERE `id`= '".$data[0]->id."'";
                $this->db->setQuery($query);
                $this->db->query();
            }
        
        
        
    }
    
    private function resizeImage($path, $name) {
        $image = new Gumlet\ImageResize($path);
        $image->resizeToWidth(250);
        
        jimport( 'joomla.filesystem.file' );
            
        if (JFile::exists($path)) {
            JFile::delete($path);
        }
           
            
        $image->save($path);
    }
    
    public function checkOnlineWrapper() {
        $token_raw = trim($_REQUEST['user_token']);
        $user_token = $this->decrypt($token_raw);     
        
        $user_obj = $this->getUserByToken($user_token);
        /*$user_joomla_obj = JFactory::getUser($user_obj->id);
        if(in_array(6, $user_joomla_obj->groups)){
            return $this->user_is_manager_txt;
        }*/
   
        
        if($user_obj->is_hide == 1){
            return $this->user_is_hidden_txt;
        }
        if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
            $perm = $this->checkGlobalApiPermission($user_obj->id);
            if($perm === 0){
                return $this->api_not_enable_txt;
            }
        }
        
        $system_mode = $this->getSystemMode($user_obj->company);
        
        if($system_mode == 'confirm'){
            $res = $this->checkOnlineUserConfirmAndText($user_obj->id);
        } elseif($system_mode == 'pay_period'){
            $res = $this->checkOnlineUserAndText($user_obj->id);
        }
        
        $final_res=[
            'system_mode'=>$system_mode,
            'user_token'=>$user_token,
            'result'=>$res['online'],
            'row_hash'=>$res['row_hash'],
            'start_time'=>$res['start_time'],
            'task'=>$res['task'],
            'timezone'=>date('c', time())   
        ];
        
        if($this->enable_totals_in_check_online_app_api == '1'){
            $final_res['first_start_obj'] = $this->getFirstStart($system_mode, $user_obj->id);
            $final_res['total'] = $this->getTotals($system_mode, $user_obj->id);
        }
        $final_res['big_green_button_start_time'] = $this->getGreenButtonPressedStatus($system_mode, $user_obj->id);
        
        return $final_res;
    }

    private function getGreenButtonPressedStatus($system_mode, $u_id)
    {
        switch($system_mode){
            case 'confirm':
                $table_name = '#__audit_time_confirm';
                break;
            case 'pay_period':
                $table_name = '#__audit_time';
                break;
        }
        
        $current_date = date('Y-m-d');
        $query = "SELECT * FROM $table_name WHERE `id_user` = '$u_id' AND `date` = '$current_date' AND `is_pressed_big_green_button`='1' ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList()[0];
        
        // Check if stamped in
        if (!empty($data->id) && !empty($data->date)) {
            return $data->big_green_button_start_time;
           
        }   
    }
    
    private function getTotals($system_mode, $user_id) {
        switch($system_mode){
            case 'confirm':
                $table_name = '#__audit_time_confirm';
                break;
            case 'pay_period':
                $table_name = '#__audit_time';
                break;
        }
        
        $current_date = date('Y-m-d');
        $query = "SELECT * FROM $table_name WHERE `id_user` = '$user_id' AND `date`='" . $current_date . "' AND `date_exit` != '0000-00-00 00:00:00' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $res = $this->db->loadObjectList();
                
        $totals = '';
        foreach($res as $one_row){
            $start_raw = $one_row->date_logged;
            $stop_raw = $one_row->date_exit;
                    
            $start_arr = explode(' ', $start_raw);
            $start_time_arr = explode(':', $start_arr[1]);
            $start_time = $start_time_arr[0].':'.$start_time_arr[1];
            $start_time_unix = strtotime($start_time);
                    
            $stop_arr = explode(' ', $stop_raw);
            $stop_time_arr = explode(':', $stop_arr[1]);
            $stop_time = $stop_time_arr[0].':'.$stop_time_arr[1];
            $stop_time_unix = strtotime($stop_time);
                    
            $totals += $stop_time_unix - $start_time_unix;
        }
        
        return date('H:i', $totals);
    }
    
    private function getFirstStart($system_mode, $user_id) {
        switch($system_mode){
            case 'confirm':
                $current_date = date('Y-m-d');
                $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$user_id' AND `date`='" . $current_date . "' ORDER BY `id` ASC";
                $this->db->setQuery($query);
                $res = $this->db->loadObjectList();
                
                return [
                    'start_time'=>$res[0]->date_logged,
                    'end_time'=>$res[0]->date_exit
                ];
            case 'pay_period':
                $current_date = date('Y-m-d');
                $query = "SELECT * FROM #__audit_time WHERE `id_user` = '$user_id' AND `date`='" . $current_date . "' ORDER BY `id` ASC";
                $this->db->setQuery($query);
                $res = $this->db->loadObjectList();
                
                return [
                    'start_time'=>$res[0]->date_logged,
                    'end_time'=>$res[0]->date_exit
                ];
        }
        
       
    }
    
    private function checkOnlineUserConfirmAndText($user_id) {
        $current_date = date('Y-m-d');
        $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$user_id' AND `date`='" . $current_date . "' AND `date_exit`='0000-00-00 00:00:00' ORDER BY `id` DESC LIMIT 0, 1";
        $this->db->setQuery($query);
        $rez = $this->db->loadObjectList();

        if (!empty($rez)) {
            $res = '1';
        } else {
            $res = '0';
        }
        
        return [
            'row_hash'=>$rez[0]->row_hash,
            'online'=>$res,
            'start_time'=>$rez[0]->date_logged,
            'task'=>$rez[0]->note,
            
        ];
    }
    
    private function checkOnlineUserAndText($user_id) {
        $current_date = date('Y-m-d');
        $query = "SELECT * FROM #__audit_time WHERE `id_user` = '$user_id' AND `date`='" . $current_date . "' AND `date_exit`='0000-00-00 00:00:00' ORDER BY `id` DESC LIMIT 0, 1";
        $this->db->setQuery($query);
        $rez = $this->db->loadObjectList();

        if (!empty($rez)) {
            $res = '1';
        } else {
            $res = '0';
        }
        
        return [
            'row_hash'=>$rez[0]->row_hash,
            'online'=>$res,
            'start_time'=>$rez[0]->date_logged,
            'task'=>$rez[0]->note
        ];
    }
    
    /*public function getPayPeriod4() {
        $token_raw = trim($_REQUEST['user_token']);
        $user_token = $this->decrypt($token_raw);   
        $from=trim($_REQUEST['from']);
        $to=trim($_REQUEST['to']);
        $lang=trim($_REQUEST['lang']);

        $respData  =  array();
        $respData['status']  =  1;
        $respData['message']  =  "";
        $respData['data']  =  array();
        
        $user_obj = $this->getUserByToken($user_token);
        if($user_obj->is_hide == 1){
            return $this->user_is_hidden_txt;
        }
        if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
            $perm = $this->checkGlobalApiPermission($user_obj->id);
            if($perm === 0){
                return $this->api_not_enable_txt;
            }
        }
        
        if(!empty($user_obj)){           
            if( $curl = curl_init() ) {
                curl_setopt($curl, CURLOPT_URL, 'https://'.$_SERVER['SERVER_NAME'].'/index.php?task=loadPP4');
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_POST, true);
                curl_setopt($curl, CURLOPT_POSTFIELDS, 'lang='.$lang.'&u_id='.$user_obj->id.'&from='.$from.'&to='.$to);
                $out = curl_exec($curl);
                curl_close($curl);
            }
            $data  = json_decode(trim($out),true);
            if(empty($data))
                $data  =  array();
            
            $respData['status'] =  1;
            $respData['message']    =  '';
            $respData['data']   =  $data;            
            $respData['out']   =  $out;
            return $respData;
        } else{            
            $respData['status']  =  0;
            $respData['message']  =  'Enter correct user token!';
            $respData['data']  =  array();            
            return $respData;
        }        
    }*/
    
    public function getPayPeriod4() {
        $app = JFactory::getApplication();
        $token_raw = $app->input->getString('user_token');
        $user_token = $this->decrypt($token_raw); 
        $from = $app->input->getString('from');
        $to = $app->input->getString('to');
        $lang = $app->input->getString('lang');
        
        $respData = [];
        $respData['status'] = 1;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {         
            if(empty($user_token)){                
                throw new Exception('Enter correct user token!');
            } 
            $user_obj = $this->getUserByToken($user_token);
            if(empty($user_obj)){
                throw new Exception('Enter correct user token!');
            } if($user_obj->is_hide == 1){
                return $this->user_is_hidden_txt;
            } if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    return $this->api_not_enable_txt;
                }
            }
            
            if(empty($from) || $this->validateDate($from, 'd.m.Y') === false){
                throw new Exception('Incorrect from! Enter date with format dd.mm.YYYY');
            } if(empty($to) || $this->validateDate($to, 'd.m.Y') === false){
                throw new Exception('Incorrect to! Enter date with format dd.mm.YYYY');
            } if(empty($lang) || !in_array($lang, ['is', 'en'])){
                throw new Exception('Incorrect lang!');
            }
            
            $config = JFactory::getConfig();
            $enable_no_time_limit_in_api = $config->get('enable_no_time_limit_in_api');

            if ($enable_no_time_limit_in_api == '1') {
                //$url = 'https://' . $_SERVER['SERVER_NAME'] . '/system_addons/app_api_console_load_pay_period.php';
            } else {
                $url = 'https://' . $_SERVER['SERVER_NAME'] . '/index.php?task=loadPP4';
            }

            if( $curl = curl_init() ) {
                curl_setopt($curl, CURLOPT_URL, $url);
                curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 0);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_POST, true);
                curl_setopt($curl, CURLOPT_POSTFIELDS, 'lang=' . $lang . '&u_id=' . $user_obj->id . '&from=' . $from . '&to=' . $to);
                $out = curl_exec($curl);
                curl_close($curl);
            }
            $data  = json_decode(trim($out),true);
            if(empty($data))
                $data  =  [];
            
           
            $respData['data']   =  $data;            
            $respData['out']   =  $out;
            return $respData;
           
        }  catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }  
        
        return $respData;
    }
    
    public function getOneDatePP4() {
        $token_raw = trim($_REQUEST['user_token']);
        $user_token = $this->decrypt($token_raw);   
        $date=trim($_REQUEST['date']);
        //$to=trim($_REQUEST['to']);
        $lang=trim($_REQUEST['lang']);
        $row_id=(int)$_REQUEST['row_id'];
        //return $user_token;
        //exit;
        
        $user_obj = $this->getUserByToken($user_token);
        if($user_obj->is_hide == 1){
            return $this->user_is_hidden_txt;
        }
        if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
            $perm = $this->checkGlobalApiPermission($user_obj->id);
            if($perm === 0){
                return $this->api_not_enable_txt;
            }
        }
        
        if(!empty($user_obj)){
            
            if( $curl = curl_init() ) {
                if($_SERVER['SERVER_NAME']=='localhost'){
                    $protocol='http://';
                } else{
                    $protocol='https://';
                }
                curl_setopt($curl, CURLOPT_URL, $protocol.$_SERVER['SERVER_NAME'].'/index.php?task=loadOneDatePP4');
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_POST, true);
                curl_setopt($curl, CURLOPT_POSTFIELDS, 'lang='.$lang.'&u_id='.$user_obj->id.'&date='.$date.'&row_id='.$row_id);
                $out = curl_exec($curl);
                curl_close($curl);
            }
            $data  = json_decode(trim($out),true);
            if(empty($data))
                $data  =  array();
            
            $respData['status'] =  1;
            $respData['message']    =  '';
            //$data=$_REQUEST;
            $respData['data']   =  $data;            
            return $respData;
        } else{
            //return 'Enter correct user token!';
            $respData['status']  =  0;
            $respData['message']  =  'Enter correct user token!';
            $respData['data']  =  array();            
            return $respData;
        }
        
    }
    
    
    
    public function setOneDatePP4_2() {

        $token_raw = trim(JRequest::getVar('user_token',""));
        $user_token = $this->decrypt($token_raw);   
        $date   =   trim(JRequest::getVar('date',""));
        $lang   =   trim(JRequest::getVar('lang',""));
        $client_ip  =   trim(JRequest::getVar('client_ip',""));
        $row_id =   intval(JRequest::getVar('row_id',0));
        $post   =   JRequest::getVar('post',array());
        
        
        
        $respData  =  array();
        $respData['status']     =   0;
        $respData['message']    =   "";
        $respData['data']       =   array();   
        
        try {                    
            $user_obj   =   $this->getUserByToken($user_token);
            
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    throw new Exception($this->api_not_enable_txt);
                }
            }
            
            if(empty($user_token) || empty($user_obj))    {                
                throw new Exception('Enter correct token!');
            }            
            if(empty($date))    {
                throw new Exception('Enter correct date!');
            }
            JLoader::register('AuditModelCustom_pay_period', JPATH_ROOT . '/components/com_audit/models/custom_pay_period.php');
            $model = JModelLegacy::getInstance('Custom_pay_period', 'AuditModel');            
            if($row_id > 0) {
                if($model->checkID($row_id, $user_obj->id) !== 1)
                        throw new Exception("Access Denied. Not Owner.");
            }
            if($this->enable_login_and_exit_hours_editable_in_app != '1'){
                unset($post['login_hours']);
                unset($post['exit_hours']);
            }
            if(!empty($post['login_hours']) && !empty($post['exit_hours'])){
                $login_hours_obj = DateTime::createFromFormat('d.m.Y H:i:s', $date . $post['login_hours'] . ':00');
                $exit_hours_obj = DateTime::createFromFormat('d.m.Y H:i:s', $date . $post['exit_hours'] . ':00');
                
                if($login_hours_obj->format('U') > $exit_hours_obj->format('U')){
                    throw new Exception('Date login must be < date exit');
                }
            }
            $data  = $model->setOneDatePP4_2($date, $row_id, $post, $user_obj->id, $client_ip);
            $respData['data'] = $data;
            //$respData['post'] = $post;
            
            /*if(!empty($post['login_hours']) && !empty($post['exit_hours'])){
                $respData['login_hours'] = $login_hours_obj->format('d.m.Y H:i:s');
                $respData['exit_hours'] = $exit_hours_obj->format('d.m.Y H:i:s');
            }*/
        } catch (Exception $e) {
            $respData['status']     =   0;
            $respData['message']    =   $e->getMessage();
        }        
        return $respData;
    }
    
    
    public function setOneDatePP4() {
        $token_raw = trim($_REQUEST['user_token']);
        $user_token = $this->decrypt($token_raw);   
        $date=trim($_REQUEST['date']);
        $lang=trim($_REQUEST['lang']);
        $row_id=(int)$_REQUEST['row_id'];
        $cell_name=trim($this->db->escape($_REQUEST['cell_name']));
        $new_value=trim($this->db->escape($_REQUEST['new_value']));
        $client_ip=trim($this->db->escape($_REQUEST['client_ip']));
        
        
        $user_obj = $this->getUserByToken($user_token);
        if($user_obj->is_hide == 1){
            return $this->user_is_hidden_txt;
        }
        if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
            $perm = $this->checkGlobalApiPermission($user_obj->id);
            if($perm === 0){
                return $this->api_not_enable_txt;
            }
        }
        
        //return $_REQUEST;
        if(!empty($user_obj)){
            $curl = curl_init();
                $options=[  
                    CURLOPT_URL=>'https://'.$_SERVER['SERVER_NAME'].'/index.php?task=setOneDatePP4',
                    CURLOPT_RETURNTRANSFER=>true,
                    CURLOPT_POST=>true,
                    CURLOPT_POSTFIELDS=>[
                        'u_id'=>$user_obj->id,
                        'lang'=>$lang,
                        'date'=>$date,
                        'row_id'=>$row_id,
                        'cell_name'=>$cell_name,
                        'new_value'=>$new_value,
                        'client_ip'=>$client_ip
                    ],   
                ];

                curl_setopt_array($curl, $options);
                $out = curl_exec($curl);
         
                curl_close($curl);
                
                $data = json_decode(trim($out), true);
                if(empty($data)){
                    $data  =  [];
                }
                
                return [
                    'status'=>1,
                    'message'=>'',
                    'data'=>$data
                ];
        } else{      
            return [
                'status'=>0,
                'message'=>'Enter correct user token!',
                'data'=>$data
            ];
        }
    }
    
    public function sendPdf() {
        $token_raw = trim($_REQUEST['user_token']);
        $user_token = $this->decrypt($token_raw);   
   
        $lang=trim($_REQUEST['lang']);
        $from=trim($this->db->escape($_REQUEST['from']));
        $to=trim($this->db->escape($_REQUEST['to']));
       
        
        
        $user_obj = $this->getUserByToken($user_token);
        if($user_obj->is_hide == 1){
            return $this->user_is_hidden_txt;
        }
        if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
            $perm = $this->checkGlobalApiPermission($user_obj->id);
            
            if($perm === 0){
                return $this->api_not_enable_txt;
            }
        }
        if(!empty($user_obj)){
            $curl = curl_init();
                $options=[  
                    CURLOPT_URL=>'https://'.$_SERVER['SERVER_NAME'].'/index.php?task=sendPdfApi',
                    CURLOPT_RETURNTRANSFER=>true,
                    CURLOPT_POST=>true,
                    CURLOPT_POSTFIELDS=>[
                        'u_id'=>$user_obj->id,
                        'lang'=>$lang,
                        'from'=>$from,
                        'to'=>$to
                    ],   
                ];

                curl_setopt_array($curl, $options);
                $out = curl_exec($curl);
         
                curl_close($curl);
                
                $data = json_decode(trim($out), true);
                if(empty($data)){
                    $data  =  [];
                }
                
                return [
                    'status'=>1,
                    'message'=>'',
                    'data'=>$data
                ];
        } else{      
            return [
                'status'=>0,
                'message'=>'Enter correct user token!',
                'data'=>$data
            ];
        }
    }
    
    public function setHoliday2() {
        $token_raw = trim($_REQUEST['user_token']);
        $user_token = $this->decrypt($token_raw);   
        $from=trim($this->db->escape($_REQUEST['from']));
        $to=trim($this->db->escape($_REQUEST['to']));
        
        $user_obj=$this->getUserByToken($user_token);
        //return $_REQUEST;
        if(!empty($user_obj)){
            $curl = curl_init();
                $options=[  
                    CURLOPT_URL=>'https://'.$_SERVER['SERVER_NAME'].'/index.php?option=com_spec_holiday2&task=setHolidayApi',
                    CURLOPT_RETURNTRANSFER=>true,
                    CURLOPT_POST=>true,
                    CURLOPT_POSTFIELDS=>[
                        'u_id'=>$user_obj->id,
                        'from'=>$from,
                        'to'=>$to
                    ],   
                ];

                curl_setopt_array($curl, $options);
                $out = curl_exec($curl);
         
                curl_close($curl);
                
                $data = json_decode(trim($out), true);
                file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/api_holidays.html', print_r($data, true), FILE_APPEND | LOCK_EX);
                if(empty($data)){
                    $data  =  [];
                }
                
                if($data=='error-0'){
                    return [
                        'status'=>0,
                        'message'=>'Dates overlap an existing period!',
                        'data'=>''
                    ];
                } else{
                    return [
                        'status'=>1,
                        'message'=>'',
                        'data'=>$data
                    ];
                }
                
        }  else{      
            return [
                'status'=>0,
                'message'=>'Enter correct user token!',
                'data'=>$data
            ];
        }
    }
    
    public function setHoliday() {
        
        $token_raw = trim(JRequest::getVar('user_token', ""));
        $user_token = $this->decrypt($token_raw);   
        $from   =   trim(JRequest::getVar('from', ""));
        $to     =   trim(JRequest::getVar('to', ""));
        
        $app = JFactory::getApplication();
        $lang = $app->input->getString('lang');
        //return $lang;
        
        $respData  =  array();
        $respData['status']     =   0;
        $respData['message']    =   "";
        $respData['data']       =   array();
        try {
            $user_obj   =   $this->getUserByToken($user_token);
            
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    throw new Exception($this->api_not_enable_txt);
                }
            }
        
            if(empty($user_token) || empty($user_token))    {                
                throw new Exception('Incorrect token!');
            }            
            if(empty($from))    throw new Exception('Incorrect from!');
            if(empty($to))      throw new Exception('Incorrect to!');
            JLoader::register('Spec_holiday2ModelApp_api', JPATH_ROOT . '/components/com_spec_holiday2/models/app_api.php');
            $model = JModelLegacy::getInstance('App_api', 'Spec_holiday2Model');
            $res    =   $model->setHolidayApi($user_obj->id, $from, $to, $lang);
            
            if(empty($res) || $res == 'error-0') {
                throw new Exception("Dates overlap an existing period!");
            }
            $this->sendEmailToManager($user_obj, $from, $to, $lang, 'holiday');
            
            $respData['status']     =   1;
            $respData['data']       =   $res;
            
        } catch (Exception $e) {
            $respData['status']     =   0;
            $respData['message']    =   $e->getMessage();
        }        
        return $respData;
    }
    
    private function sendEmailToManager($user_obj, $from_period, $to_period, $lang, $type)
    {
        /*echo '<pre>';
        print_r($user_obj);
        echo '</pre>';*/
        $manager_obj = & JFactory::getUser($user_obj->owner_id);
        
        $config = & JFactory::getConfig();
        $sender = array($config->get('mailfrom'), $config->get('fromname'));
        $email = $manager_obj->email;
        
        //$user_sended = $user_obj;
        $site_url = 'https://'.$_SERVER['SERVER_NAME'];
        
    
        
        //if(empty($added_user_name)){
            $final_username = '';
            if (!empty($user_obj->username0)) {
                $final_username = $user_obj->username0;
            } elseif (!empty($user_obj->username)) {
                $final_username = $user_obj->username;
            } elseif (!empty($user_obj->name)) {
                $final_username = $user_obj->name;
            }
            //$added_user_name=$final_username;
        //}
            
        $message = '';
        switch($type){
            case 'holiday':
                if ($lang == 'is') {
                    $subject = "You have a new holidays request";
            
                    $message .= '<p>You have a new holidays request from <strong>'.$final_username.'</strong> and with period '.$from_period.' - '.$to_period.'</p>';
                    $message .= '<p>Go to <a href="'.$site_url.'/new-holidays2'.'" target="_blank" rel="noopener noreferrer">Holidays page</a> and check it please.</p>';
                } else{
                    $subject = "You have a new holidays request";
            
                    $message .= '<p>You have a new holidays request from <strong>'.$final_username.'</strong> and with period '.$from_period.' - '.$to_period.'</p>';
                    $message .= '<p>Go to <a href="'.$site_url.'/new-holidays2'.'" target="_blank" rel="noopener noreferrer">Holidays page</a> and check it please.</p>';
                }
            break;
            case 'shift':
                if ($lang == 'is') {
                    $subject = "You have a new shift request";
            
                    $message .= '<p>You have a new holidays request from <strong>'.$final_username.'</strong> and with period '.$from_period.' - '.$to_period.'</p>';
                    $message .= '<p>Go to <a href="'.$site_url.'/shifts'.'" target="_blank" rel="noopener noreferrer">Shifts page</a> and check it please.</p>';
                } else{
                    $subject = "You have a new shift request";
            
                    $message .= '<p>You have a new holidays request from <strong>'.$final_username.'</strong> and with period '.$from_period.' - '.$to_period.'</p>';
                    $message .= '<p>Go to <a href="'.$site_url.'/shifts'.'" target="_blank" rel="noopener noreferrer">Shifts page</a> and check it please.</p>';
                }
            break;
        }
        
        
        $mailer = &JFactory::getMailer();
        $mailer->setSender($sender);
        $mailer->addRecipient($email);
        $mailer->setSubject($subject);
        $mailer->isHTML(TRUE);
        $mailer->setBody($message);
        $mailer->send();
    }
    
    public function getHoliday() {
        $token_raw = trim(JRequest::getVar('user_token',""));
        $user_token = $this->decrypt($token_raw);   
        $id = (int) JRequest::getVar('id',0);
        
        $respData  =  array();
        $respData['status']     =   0;
        $respData['message']    =   "";
        $respData['data']       =   array();
        
        try {        
            if(empty($user_token))    {                
                throw new Exception('Enter correct token!');
            }            
            if($id < 1) {                
                throw new Exception('Enter correct id!');
            }
            $user_obj   =   $this->getUserByToken($user_token);
            JLoader::register('Spec_holiday2ModelApp_api', JPATH_ROOT . '/components/com_spec_holiday2/models/app_api.php');
            $model = JModelLegacy::getInstance('App_api', 'Spec_holiday2Model');
            $respData['status']     =   1;
            $res    =   $model->getHolidayApi($user_obj->id, $id);
            if(empty($res))
                throw new Exception('Dates overlap an existing period!');
            $respData['data'] = $res;
        } catch (Exception $e) {
            $respData['status']     =   0;
            $respData['message']    =   $e->getMessage();
        }        
        return $respData;        
    }
    
    public function getHolidays() {
        $token_raw = trim(JRequest::getVar('user_token', ""));
        $user_token = $this->decrypt($token_raw);   
        
        $respData  =  array();
        $respData['status']     =   0;
        $respData['message']    =   "";
        $respData['data']       =   array();
        
        try {        
            if(empty($user_token)){                
                throw new Exception('Enter correct token!');
            }
            
            $user_obj = $this->getUserByToken($user_token);
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    throw new Exception($this->api_not_enable_txt);
                }
            }
        
            JLoader::register('Spec_holiday2ModelApp_api', JPATH_ROOT . '/components/com_spec_holiday2/models/app_api.php');            
            $model = JModelLegacy::getInstance('App_api', 'Spec_holiday2Model');
            $respData['status']     =   1;            
            $res    =   $model->getHolidaysApi($user_obj->id);
            $respData['data'] = $res;
        } catch (Exception $e) {
            $respData['status']     =   0;
            $respData['message']    =   $e->getMessage();
        }        
        return $respData;        
    }
    
    public function getQuotes() {
        $token_raw = trim(JRequest::getVar('user_token',""));
        $user_token = $this->decrypt($token_raw);   
        
        $respData  =  array();
        $respData['status']     =   0;
        $respData['message']    =   "";
        $respData['data']       =   array();  
        
        try {        
            if(empty($user_token))    {                
                throw new Exception('Enter correct token!');
            }            
            
            
            $user_obj = $this->getUserByToken($user_token);
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    throw new Exception($this->api_not_enable_txt);
                }
            }
            
            $manager_obj=  JFactory::getUser($user_obj->owner_id);
            if($this->enable_jokes_module == '1'){
                 if ($manager_obj->jokes_home_status == 1) {
                    $respData['status'] = 1;
                    jimport('joomla.application.module.helper');
                    $mods = JModuleHelper::getModules('random_jokes_home');
                    //$res    =   trim(addslashes((JModuleHelper::renderModule($mods[0]))));
                    $res = JModuleHelper::renderModule($mods[0]);
                    if (is_array($res)) {
                        foreach ($res as $k => $v) {
                            $res[$k] = trim($v);
                        }
                    }
                    $res = json_decode($res);
                    $respData['data'] = $res;
                } elseif($manager_obj->quote_home_status == 1){
                    $respData['status'] = 1;
                    jimport('joomla.application.module.helper');
                    $mods = JModuleHelper::getModules('random_quotes_home');
                    //$res    =   trim(addslashes((JModuleHelper::renderModule($mods[0]))));
                    $res = JModuleHelper::renderModule($mods[0]);
                    if (is_array($res)) {
                        foreach ($res as $k => $v) {
                           $res[$k] = trim($v);
                        }
                    }
                    $res = json_decode($res);
                    $respData['data'] = $res;
                } else{
                    throw new Exception('The manager of the current company did not include quotes or jokes.');
                }
            }  else {
                if ($manager_obj->quote_home_status == 1) {
                    $respData['status'] = 1;
                    jimport('joomla.application.module.helper');
                    $mods = JModuleHelper::getModules('random_quotes_home');
                    //$res    =   trim(addslashes((JModuleHelper::renderModule($mods[0]))));
                    $res = JModuleHelper::renderModule($mods[0]);
                    if (is_array($res)) {
                        foreach ($res as $k => $v) {
                            $res[$k] = trim($v);
                        }
                    }
                    $res = json_decode($res);
                    $respData['data'] = $res;
                } else {
                    throw new Exception('The manager of the current company did not include quotes.');
                }
            }
        } catch (Exception $e) {
            $respData['status']     =   0;
            $respData['message']    =   $e->getMessage();
        }        
        return $respData;        
    }
    
    
    public function getAvailableMudules() {
        $token_raw = trim(JRequest::getVar('user_token',""));
        $user_token = $this->decrypt($token_raw);   
        
        $respData  =  array();
        $respData['status']     =   0;
        $respData['message']    =   "";
        $respData['data']       =   array();
        
        try {        
            if(empty($user_token))    {                
                throw new Exception('Enter correct token!');
            }
            if(!is_file(JPATH_ROOT . '/administrator/components/com_ctapi/models/api.php'))
                throw new Exception('Mod Manager Not Available!');     
            
            $user   =   $this->getUserByToken($user_token);
            $user_joomla_obj = JFactory::getUser($user->id);
            if(in_array(6, $user_joomla_obj->groups)){
                 throw new Exception($this->user_is_manager_txt);
            }
            if($user->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            
            JLoader::register('CtapiModelApi', JPATH_ROOT . '/administrator/components/com_ctapi/models/api.php');
            $model = JModelLegacy::getInstance('Api', 'CtapiModel');
            $respData['status']     =   1;            
            $respData['data']   =   $model->getCompanyMods($user->company,1);
        } catch (Exception $e) {
            $respData['status']     =   0;
            $respData['message']    =   $e->getMessage();
        }        
        return $respData;        
    }
    
    public function getAvailableMudules2($user_token) {
        $token_raw = trim($token);
        //$user_token = $this->decrypt($token_raw);   
        
        $respData  =  array();
        $respData['status']     =   0;
        $respData['message']    =   "";
        $respData['data']       =   array();
        
        try {        
            if(empty($user_token))    {                
                throw new Exception('Enter correct token!');
            }
            if(!is_file(JPATH_ROOT . '/administrator/components/com_ctapi/models/api.php'))
                throw new Exception('Mod Manager Not Available!');            
            $user   =   $this->getUserByToken($user_token);
            JLoader::register('CtapiModelApi', JPATH_ROOT . '/administrator/components/com_ctapi/models/api.php');
            $model = JModelLegacy::getInstance('Api', 'CtapiModel');
            $respData['status']     =   1;            
            $respData['data']   =   $model->getCompanyMods($user->company,1);
        } catch (Exception $e) {
            $respData['status']     =   0;
            $respData['message']    =   $e->getMessage();
        }        
        return $respData;        
    }
    
    public function attachUsersToTask() {
        $token_raw = trim(JRequest::getVar('user_token',""));
        $user_token = $this->decrypt($token_raw);  
        $task_id=trim(JRequest::getVar('task_id', '', 'post', 'INT'));
        $attached_users=(array)$_REQUEST['attached_users_ids'];
        $mode=JRequest::getVar('mode', '', 'post', 'STRING');
        
        $respData  =  array();
        $respData['status']     =   0;
        $respData['message']    =   "";
        $respData['data']       =   array();  
        
        try {        
            if(empty($user_token))    {                
                throw new Exception('Enter correct token!');
            } if(empty($task_id)){
                throw new Exception('Enter task id!');
            } if(empty($attached_users)){
                throw new Exception('Enter attached_users_ids!');
            } if(empty($mode)){
                throw new Exception('Enter mode!');
            } if($mode!='add' && $mode!='remove'){
                throw new Exception('Enter correct mode!');
            }    
            
            
            $user_obj = $this->getUserByToken($user_token);
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    throw new Exception($this->api_not_enable_txt);
                }
            }
            $manager_obj=JFactory::getUser($user_obj->owner_id);
            JLoader::register('AuditModelTask_manager', JPATH_ROOT . '/components/com_audit/models/task_manager.php');
            $model = JModelLegacy::getInstance('Task_manager', 'AuditModel');
            //$mode='remove';
            
            foreach($attached_users as $k=>$v){
                $model->updateAttachedTask($v, $mode, $task_id);
            }
            
            $res='successfully processed';
            $respData['status']     =   1;
            $respData['data'] = $res;
            $respData['message'] = $res;
            
        } catch (Exception $e) {
            $respData['status']     =   0;
            $respData['message']    =   $e->getMessage();
        }        
        return $respData;
        //return 'hello from api';
    }
    
    public function getFromTo() {

        $token_raw = trim(JRequest::getVar('user_token', ""));

        $user_token = $this->decrypt($token_raw);
        $user_obj = $this->getUserByToken($user_token);

        if ($user_obj->is_hide == 1) {
            return $this->user_is_hidden_txt;
        }

        if ($this->enable_api_blocking_by_option_from_admin_panel == '1') {
            $perm = $this->checkGlobalApiPermission($user_obj->id);
            if ($perm === 0) {
                return $this->api_not_enable_txt;
            }
        }

        $manager_obj = JFactory::getUser($user_obj->owner_id);
        JLoader::register('AuditModelCustom_pay_period', JPATH_ROOT . '/components/com_audit/models/custom_pay_period.php');

        $model_pay_period = JModelLegacy::getInstance('Custom_pay_period', 'AuditModel');
        $from_to = json_decode($model_pay_period->getInputsPayPeriod($manager_obj->id));
        // $current_date = date('d.m.Y');
        $current_date = DateTime::createFromFormat('d.m.Y H:i:s', date('d.m.Y') . ' 00:00:00')->format('U');
        $from_date1 = DateTime::createFromFormat('d.m.Y', $from_to->from_date);
        $from_date2 = $from_date1->format('d');

        $from_date = $from_date2 . date('.m.Y');
        $from_date_unix = DateTime::createFromFormat('d.m.Y', $from_date)->format('U');

        $to_date1 = DateTime::createFromFormat('d.m.Y', $from_to->to_date);
        $to_date2 = $to_date1->format('d');
        $to_date1_clone = clone $to_date1;
        
        if ($from_date2 == '01') {
            
            //$to_date = $to_date1_clone->modify('last day of this month')->format('d.m.Y');
            $to_date = DateTime::createFromFormat('d.m.Y H:i:s', date('d.m.Y H:i:s', strtotime('last day of this month')))->format('d.m.Y');
            //$to_date = $to_date2 . date('.m.Y');
        } else {
           
            $to_date = $to_date2 . date('.m.Y', strtotime('+1month'));
        }
        //return $to_date;
            
        //echo '<br/>'.$from_date;

        if ($current_date < $from_date_unix) {
            //echo 'попали';

            $from_date_row = DateTime::createFromFormat('d.m.Y', $from_date)->format('Y-m-d');

            $from_date_strtotime = strtotime($from_date_row . '-1months');
            //$from_date_strtotime1=strtotime("$from_date_strtotime -1 month");
            $from_date = date('d.m.Y', $from_date_strtotime);
            $from_date00 = date('Y-m-d', $from_date_strtotime);
            $count_days_in_month = date('t', strtotime($from_date00));


            if ($count_days_in_month == 31) {
                $from_date_strtotime = strtotime($from_date_row . '-1months');
                $from_date = date('d.m.Y', $from_date_strtotime);
            }


            $to_date_row = DateTime::createFromFormat('d.m.Y', $from_date)->format('Y-m-d');
            $to_date_strtotime = strtotime($to_date_row . '+1months -1days');
            $to_date = date('d.m.Y', $to_date_strtotime);
        }

        if (empty($from_date) && empty($to_date)) {
            $final_res = [
                'from' => '25.' . date('m.Y', strtotime('-1 month')),
                'to' => '24.' . date('m.Y', strtotime('+0 month'))
            ];
        } else {
            $final_res = [
                'from' => $from_date,
                'to' => $to_date
            ];
        }

        return $final_res;
    }

    public function getTimesheetHeaders()
    {
        $app = JFactory::getApplication();
        $token_raw = $app->input->getString('user_token');
        $lang = $app->input->getString('lang');
        
        $user_token = $this->decrypt($token_raw);
        $user_obj = $this->getUserByToken($user_token);
        if($user_obj->is_hide == 1){
            return $this->user_is_hidden_txt;
        }
        if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
            $perm = $this->checkGlobalApiPermission($user_obj->id);
            if($perm === 0){
                return $this->api_not_enable_txt;
            }
        }
        //$manager_obj = JFactory::getUser($user_obj->owner_id);
        
        JLoader::register('AuditModelRules', JPATH_ROOT . '/components/com_audit/models/rules.php');

        $model_rules = JModelLegacy::getInstance('Rules', 'AuditModel');
        $rule_mode=$model_rules->getUserRuleForText($user_obj->id);
        $header_texts_obj=$model_rules->getTexts($rule_mode['mode'], $rule_mode['rule_id'], $lang);
                    
        return $header_texts_obj;
    }
    
    public function getOneDateWithTextPP4() {
        $token_raw = trim($_REQUEST['user_token']);
        $user_token = $this->decrypt($token_raw);   
        $date=trim($_REQUEST['date']);
        //$to=trim($_REQUEST['to']);
        $lang=trim($_REQUEST['lang']);
        $row_id=(int)$_REQUEST['row_id'];
        //return $user_token;
        //exit;
        
        $user_obj = $this->getUserByToken($user_token);
        
        if($user_obj->is_hide == 1){
            return $this->user_is_hidden_txt;
        }
        if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
            $perm = $this->checkGlobalApiPermission($user_obj->id);
            if($perm === 0){
                return $this->api_not_enable_txt;
            }
        }
        if(!empty($user_obj)){
            
            if( $curl = curl_init() ) {
                if($_SERVER['SERVER_NAME']=='localhost'){
                    $protocol='http://';
                } else{
                    $protocol='https://';
                }
                curl_setopt($curl, CURLOPT_URL, $protocol.$_SERVER['SERVER_NAME'].'/index.php?task=getOneDateWithTextPP4');
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_POST, true);
                curl_setopt($curl, CURLOPT_POSTFIELDS, 'lang='.$lang.'&u_id='.$user_obj->id.'&date='.$date.'&row_id='.$row_id);
                $out = curl_exec($curl);
                curl_close($curl);
            }
            $data  = json_decode(trim($out),true);
            if(empty($data))
                $data  =  array();
            
            $respData['status'] =  1;
            $respData['message']    =  '';
            //$data=$_REQUEST;
            $respData['data']   =  $data;            
            return $respData;
        } else{
            //return 'Enter correct user token!';
            $respData['status']  =  0;
            $respData['message']  =  'Enter correct user token!';
            $respData['data']  =  array();            
            return $respData;
        }
        
    }
    
    public function getPayPeriod4WithTexts() {
        $app = JFactory::getApplication();
        $token_raw = $app->input->getString('user_token');
        $user_token = $this->decrypt($token_raw); 
        $from = $app->input->getString('from');
        $to = $app->input->getString('to');
        $lang = $app->input->getString('lang');
        
        $respData = [];
        $respData['status'] = 1;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {         
            if(empty($user_token)){                
                throw new Exception('Enter correct user token!');
            } 
            $user_obj = $this->getUserByToken($user_token);
            if(empty($user_obj)){
                throw new Exception('Enter correct user token!');
            } if($user_obj->is_hide == 1){
                return $this->user_is_hidden_txt;
            } if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    return $this->api_not_enable_txt;
                }
            }
            
            if(empty($from) || $this->validateDate($from, 'd.m.Y') === false){
                throw new Exception('Incorrect from! Enter date with format dd.mm.YYYY');
            } if(empty($to) || $this->validateDate($to, 'd.m.Y') === false){
                throw new Exception('Incorrect to! Enter date with format dd.mm.YYYY');
            } if(empty($lang) || !in_array($lang, ['is', 'en'])){
                throw new Exception('Incorrect lang!');
            }
            
            $config = JFactory::getConfig();
            $enable_no_time_limit_in_api = $config->get('enable_no_time_limit_in_api');

            if ($enable_no_time_limit_in_api == '1') {
                $url = 'https://' . $_SERVER['SERVER_NAME'] . '/system_addons/app_api_console_load_pay_period.php';
            } else {
                $url = 'https://' . $_SERVER['SERVER_NAME'] . '/index.php?task=getPayPeriod4WithTexts';
            }

            if( $curl = curl_init() ) {
                curl_setopt($curl, CURLOPT_URL, $url);
                curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 0);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_POST, true);
                curl_setopt($curl, CURLOPT_POSTFIELDS, 'lang=' . $lang . '&u_id=' . $user_obj->id . '&from=' . $from . '&to=' . $to);
                $out = curl_exec($curl);
                curl_close($curl);
            }
            $data  = json_decode(trim($out),true);
            if(empty($data))
                $data  =  [];
            
           
            $respData['data']   =  $data;            
            $respData['out']   =  $out;
            return $respData;
           
        }  catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }  
        
        return $respData;
    }
    
    
    public function getUserHolidaysRequests() {
        $app = JFactory::getApplication();
        $token_raw = $app->input->getString('user_token');
        $user_token = $this->decrypt($token_raw);   
        
        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {        
            if(empty($user_token)){                
                throw new Exception('Enter token!');
            }
            
            $user_obj = $this->getUserByToken($user_token);
            if(empty($user_obj)){                
                throw new Exception('Enter correct token!');
            }
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    throw new Exception($this->api_not_enable_txt);
                }
            }
            
            JLoader::register('Spec_holiday2ModelApp_api', JPATH_ROOT . '/components/com_spec_holiday2/models/app_api.php');            
            $model = JModelLegacy::getInstance('App_api', 'Spec_holiday2Model');
            
            
            $res = $model->getUserHolidaysRequestsApi($user_obj->id);
            if(empty($res)){                
                throw new Exception('No data found!');
            }
            
            $respData['status'] = 1;           
            $respData['data'] = $res;
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }  
        
        return $respData;        
    }
    
    public function getCalcLink()
    { 
        $app = JFactory::getApplication();
        $token_raw = $app->input->getString('user_token');
        $user_token = $this->decrypt($token_raw);   
        $lang = $app->input->getString('lang');
        
        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {         
            if(empty($user_token)){                
                throw new Exception('Enter token!');
            }
            
            $user_obj = $this->getUserByToken($user_token);
            if(empty($user_obj)){                
                throw new Exception('Enter correct token!');
            }
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    return $this->api_not_enable_txt;
                }
            }
            JLoader::register('AuditModelCalc', JPATH_ROOT . '/components/com_audit/models/calc.php');
            $model = JModelLegacy::getInstance('Calc', 'AuditModel');
            JLoader::register('AuditController', JPATH_ROOT . '/components/com_audit/controller.php');
            
            if($user_obj->reg_type == 'new_form'){
                $save_user = $model->loadUserCalcNewSave($user_obj);  
                $pay_period_data = AuditController::loadBottomTotalsApiNewCalc([
                            'u_id' => $user_obj->id,
                            'lang' => 'en',
                            'from_to' => ''
                ]);
                
                $link = $this->prepareCalcLinkNew($save_user, $user_obj, $pay_period_data, $lang);
                
                
            } else {
                $save_user = $model->loadCurrentUserSaveApi($user_obj);
                if (empty($save_user)) {
                    throw new Exception('No data found!');
                }

               
                $pay_period_data = AuditController::loadBottomTotalsApi([
                            'u_id' => $user_obj->id,
                            'lang' => 'en',
                            'from_to' => ''
                ]);
                $link = $this->prepareCalcLink($save_user, $user_obj, $pay_period_data);
            }
            
            $respData['status'] = 1;      
            $respData['reg_type'] = $user_obj->reg_type;
            $respData['data'] = $link;
            $respData['raw_data'] = $save_user;
            $respData['pay_period_data'] = $pay_period_data;
            
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }  
        
        return $respData; 
    }
    
    private function prepareCalcLinkNew($save_user, object $user_obj, $pay_period_data, $lang)
    {
        $final_link = 'https://laun.taxti.is/index.php/' . $lang . '/?step2=';
        
        switch($save_user->union0){
            case 'hourly':
                $final_link .= $save_user->union0 .'&rate=' . $save_user->hourly_rate;
                $final_link .= '&work_hours=' . $save_user->count_hours_pr_month . '&checkbox1=' . $save_user->shorter_week;
                break;
            case 'monthly':
                $final_link .= $save_user->union0 .'&rate=' . $save_user->monthly_wage;
                $final_link .= '&work_hours=' . $save_user->count_hours_pr_month . '&extra=' .$save_user->extra_h . '&checkbox1=' . $save_user->shorter_week;
                break;
            case 'self_empl':
                $final_link .= $save_user->union0 .'&rate=' . $save_user->monthly_wage;
                $final_link .= '&work_hours=' . $save_user->count_hours_pr_month . '&extra=' .$save_user->extra_h . '&checkbox1=' . $save_user->shorter_week;
                break;
        }
        $final_link .= '&checkbox2=' . $save_user->tool_fee_el;
        
        $not_permitted_items_pp = [
            'not_converted',
            'total'
        ];
         
        $j = 0;
        foreach($pay_period_data['final_res'] as $k => $v){
            if(!in_array($k, $not_permitted_items_pp)){
                $final_link .= '&'.$k.'='.$v;
                    
                $j++;
            }
        }
       
        
        return $final_link;
    }
    
    private function prepareCalcLink($save_user, $user_obj, $pay_period_data)
    {
        $final_link = 'https://sgs.taxti.is/?';
        $i = 0;
        $not_permitted_items = [
            'id',
            'timestamp_create',
            'date_create',
            'last_revision_timestamp',
            'last_revision_date',
            
        ];
        
        foreach($save_user as $k=>$v){
            if($i == 0){
                if(!in_array($k, $not_permitted_items)){
                    $final_link .= $k.'='.$v;
                    
                    $i++;
                }
            } else{
                if(!in_array($k, $not_permitted_items)){
                    $final_link .= '&'.$k.'='.$v;
                    
                    $i++;
                }
            }
        }
        
        $not_permitted_items_pp = [
            'not_converted'
        ];
        
        $j = 0;
        foreach($pay_period_data['final_res'] as $k=>$v){
            if(!in_array($k, $not_permitted_items_pp)){
                $final_link .= '&'.$k.'_pp='.$v;
                    
                $j++;
            }
        }
        
        return urlencode($final_link);
    }
    
    private static function checkDateFormatWithFormatArg($date, $format){
        $dt = DateTime::createFromFormat($format, $date);
        return $dt !== false && !array_sum($dt::getLastErrors());
    }
    
    
    public function getUserShifts() {
        
        $app = JFactory::getApplication();
        $token_raw = $app->input->getString('user_token');
        $user_token = $this->decrypt($token_raw);   
        $from = $app->input->getString('from');
        $to = $app->input->getString('to');
        
        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {        
            if(empty($user_token)){                
                throw new Exception('Enter token!');
            }
            
            $user_obj = $this->getUserByToken($user_token); 
            if(empty($user_obj)){                
                throw new Exception('Enter correct token!');
            }
            $result_check_date_from_format = self::checkDateFormatWithFormatArg($from, 'd.m.Y');
            if(empty($from) || $result_check_date_from_format != 1){
                throw new Exception('Enter correct from date format: d.m.Y');
            } 
            $result_check_date_to_format = self::checkDateFormatWithFormatArg($to, 'd.m.Y');
            if(empty($to) || $result_check_date_to_format != 1){
                throw new Exception('Enter correct to date format: d.m.Y');
            } 
            
            /*$user_joomla_obj = JFactory::getUser($user_obj->id);
            if(in_array(6, $user_joomla_obj->groups)){
                throw new Exception($this->user_is_manager_txt);
            }*/
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    throw new Exception($this->api_not_enable_txt);
                }
            }
            
            JLoader::register('Spec_holiday2ModelApp_api', JPATH_ROOT . DS . 'components' . DS . 'com_shifts' . DS . 'models' . DS . 'app_api.php');            
            $model = JModelLegacy::getInstance('App_api', 'Spec_holiday2Model');
            
            
            $res = $model->getUserShiftsApi($user_obj->id, $from, $to);
            if(empty($res)){     
                $respData['status'] = 0;  
                throw new Exception('No data found!');
                
            }
            
            $respData['status'] = 1;  
            $respData['data'] = $res;
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }  
        
        return $respData;        
    }
    
    private function checkColors($color) {
        $perm_colors_arr = [
           '#009cdd',
           '#8bc2ae',
           '#ffed3b',
           '#77c0d2',
           '#d3277c',
           '#9b9b9a', 
           '#ac2c3c'
        ];
        
        if(!in_array($color, $perm_colors_arr)){
            return false;
        }
    }
    
    private function validateDate($date, $format = 'Y-m-d H:i:s') {
        $d = DateTime::createFromFormat($format, $date);
        return $d && $d->format($format) == $date;
    }
    
    public function setShift() {
        $app = JFactory::getApplication();
        
        $token_raw = $app->input->getString('user_token');
        $from = $app->input->getString('from');
        $to = $app->input->getString('to');
        $lang = $app->input->getString('lang');
        $shift_color = $app->input->getString('shift_color');
        //$shift_color = '#d3277c';
        
        //$shift_name = $app->input->getString('shift_name');
        $shift_name = 'Shift name';
        
        $status = $app->input->getString('status');
        $date = $app->input->getString('date');
        $message    = $app->input->getString('message');
        $icon_date  = $app->input->getString('icon_date');
        
        $user_token = $this->decrypt($token_raw);   

        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {
            $user_obj = $this->getUserByToken($user_token); 
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                
                if($perm === 0){
                    throw new Exception($this->api_not_enable_txt);
                }
            }
            if(empty($user_token)) {                
                throw new Exception('Incorrect token!');
            } if(empty($status) && (empty($from) || $this->validateDate($from, 'd.m.Y H:i') === false)){
                throw new Exception('Incorrect from! Enter date with format dd.mm.YYYY HH:II');
            } if(empty($status) && (empty($to) || $this->validateDate($to, 'd.m.Y H:i') === false)){
                throw new Exception('Incorrect to! Enter date with format dd.mm.YYYY HH:II');
            } if(empty($lang) || !in_array($lang, ['is', 'en'])){
                throw new Exception('Incorrect lang!');
            } if(empty($shift_color)){
                //throw new Exception('Enter shift color!');
                $shift_color = '#d3277c';
            } if($this->checkColors($shift_color) === false){
                throw new Exception('Enter correct shift color!');
            } if(empty($shift_name)){
                throw new Exception('Enter shift name!');
            } if(!empty($status) && !in_array($status, ['pending_available','pending_work'])){
                throw new Exception('Enter pending_available in "status" or empty, but then enter from and to!');
            } if(empty($date) && empty($status) == false && empty($icon_date)){
                throw new Exception('Enter "date"!');
            } if(!empty($date) && $this->validateDate($date, 'd.m.Y') === false){
                throw new Exception('Enter "date" in format dd.mm.YYYY!');
            }
            JLoader::register('Spec_holiday2ModelApp_api', JPATH_ROOT . DS . 'components' . DS . 'com_shifts' . DS . 'models' . DS . 'app_api.php');
            $model = JModelLegacy::getInstance('App_api', 'Spec_holiday2Model');
            $res = $model->setShiftForApi($user_obj->id, $from, $to, $lang, $shift_color, $shift_name, $date, $status, $message,$icon_date);
            
            if(empty($res) || $res == 'error-0') {
                throw new Exception("Dates overlap an existing period!");
            }
            $this->sendEmailToManager($user_obj, $from, $to, $lang, 'shift');
            
            $respData['status'] = 1;
            $respData['data'] = $res;
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }      
        
        return $respData;
    }
    
    public function getShift() {
        $app = JFactory::getApplication();
        
        $token_raw = $app->input->getString('user_token');
        $id = $app->input->getInt('id');
        
        $user_token = $this->decrypt($token_raw);   
        
        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {        
            if(empty($user_token)){                
                throw new Exception('Enter correct token!');
            } if(empty($id)){
                throw new Exception('Enter id!');
            }
            $user_obj = $this->getUserByToken($user_token);
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    throw new Exception($this->api_not_enable_txt);
                }
            }
        
            JLoader::register('Spec_holiday2ModelApp_api', JPATH_ROOT . DS . 'components' . DS . 'com_shifts' . DS . 'models' . DS . 'app_api.php');            
            $model = JModelLegacy::getInstance('App_api', 'Spec_holiday2Model');
                      
            $res = $model->getShiftApi($user_obj->id, $id);
            
            
            $respData['status'] = 1; 
            $respData['data'] = $res;
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }        
        return $respData;        
    }
    
    public function setShiftMessage()
    {
        $app = JFactory::getApplication();
        
        $token_raw = $app->input->getString('user_token');
        $date_raw = $app->input->getString('date');
        $type_raw = $app->input->getString('type'); 
        $lang_raw = $app->input->getString('lang');
        $message_raw = $app->input->getString('message');
        //$shift_color = $app->input->getString('shift_color');
        //$shift_name = $app->input->getString('shift_name');
        
        $user_token = $this->decrypt($token_raw);   
        $date = $this->decrypt($date_raw); 
        $type = $this->decrypt($type_raw); 
        $lang = $this->decrypt($lang_raw); 
        $message = $this->decrypt($message_raw); 
        
        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {
            $user_obj = $this->getUserByToken($user_token);
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                
                if($perm === 0){
                    throw new Exception($this->api_not_enable_txt);
                }
            }
        
            if(empty($user_token)) {                
                throw new Exception('Incorrect token!');
            } if(empty($date) || $this->validateDate($date, 'd.m.Y') === false){
                throw new Exception('Incorrect from! Enter date with format dd.mm.YYYY');
            } if(empty($type)){
                throw new Exception('Enter type!');
            } if(empty($lang) || !in_array($lang, ['is', 'en'])){
                throw new Exception('Incorrect lang!');
            } 
            
            JLoader::register('Spec_holiday2ModelApp_api', JPATH_ROOT . DS . 'components' . DS . 'com_shifts' . DS . 'models' . DS . 'app_api.php');
            $model = JModelLegacy::getInstance('App_api', 'Spec_holiday2Model');
            $res = $model->setShiftMessage($user_obj->id, $date, $type, $lang, $message);
            
            if(empty($res) || $res == 'error-0') {
                throw new Exception("The date is already part of the period.");
            }
            //$this->sendEmailToManager($user_obj, $from, $to, $lang, 'shift');
            
            $respData['status'] = 1;
            $respData['data'] = $res;
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }      
        
        return $respData;
    }
    
    public function getMessages()
    {
        $app = JFactory::getApplication();
        
        $token_raw = $app->input->getString('user_token');
        //$id = $app->input->getInt('id');
        
        $user_token = $this->decrypt($token_raw);   
        
        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {        
            if(empty($user_token)){                
                throw new Exception('Enter correct token!');
            } 
            
            $user_obj = $this->getUserByToken($user_token);
            if(empty($user_obj)){                
                throw new Exception('Enter correct token!');
            }
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    throw new Exception($this->api_not_enable_txt);
                }
            }
            $manager_joomla_obj = JFactory::getUser($user_obj->owner_id);
            if($manager_joomla_obj->shifts_send_mobile == 0){
                throw new Exception($this->shifts_notification_disabled);
            }
            JLoader::register('AuditModelCtapi', JPATH_ROOT . '/components/com_audit/models/ctapi.php');            
            $model = JModelLegacy::getInstance('Ctapi', 'AuditModel');
                      
            $res = $model->getMessages($user_obj);
            
            
            $respData['status'] = 1; 
            $respData['data'] = $res;
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }     
        
        return $respData;  
    }
    
    public function markMessagesAsRead()
    {
        $app = JFactory::getApplication();
        
        $token_raw = $app->input->getString('user_token');
        $marked_messages_arr = $app->input->getString('marked_messages_arr');
        
        $user_token = $this->decrypt($token_raw);   
        //return $marked_messages_arr;
        
        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {        
            if(empty($user_token)){                
                throw new Exception('Enter correct token!');
            } 
            
            $user_obj = $this->getUserByToken($user_token);
            if(empty($user_obj)){                
                throw new Exception('Enter correct token!');
            }
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if(empty($marked_messages_arr)){                
                throw new Exception('Enter array of messages id!');
            }
            
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    throw new Exception($this->api_not_enable_txt);
                }
            }
        
            JLoader::register('AuditModelCtapi', JPATH_ROOT . '/components/com_audit/models/calc.php');            
            $model = JModelLegacy::getInstance('Ctapi', 'AuditModel');
                      
            $res = $model->markMessagesAsRead($user_obj, $marked_messages_arr);
            if($res != 1){
                throw new Exception('Error while executing a database query');
            }
            
            $respData['status'] = 1; 
            $respData['data'] = $res;
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }     
        
        return $respData; 
    }
    
    private static function checkDateFormat($date){
        $dt = DateTime::createFromFormat("d.m.Y", $date);
        return $dt !== false && !array_sum($dt::getLastErrors());
    }
    
    public function registration3rd()
    { 
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/api_reg.html', print_r($_REQUEST, true), FILE_APPEND | LOCK_EX);
        $app = JFactory::getApplication();
        $config = JFactory::getConfig();
        
        $enable_default_rules = '0';
        $enable_pp_inputs_in_home_reg_company_form = $config->get('enable_pp_inputs_in_home_reg_company_form');
        
        JLoader::register('AuditModelregistered_users', JPATH_ROOT . '/components/com_audit/models/registered_users.php');     
        $model = JModelLegacy::getInstance('registered_users', 'AuditModel');
        
        $manager_company = strip_tags($app->input->getString('company'));//company
        $manager_username = strip_tags($app->input->getString('company'));//equal company
        $regUserName = strip_tags($app->input->getUsername('manager_name'));//manager name
        $regIDManager = strip_tags($app->input->getUsername('company'));//equal company
        $regIDUser = strip_tags($app->input->getUsername('manager_id'));//manager id
        $regPasswordManager = '';//must be empty
        $regPasswordUser = strip_tags($app->input->getString('password'));//manager password
        $regEmailCommon = strip_tags($app->input->getString('email'));//manager email
        $regUserLimit3rd = strip_tags($app->input->getInt('user_limit'));//company user limit
        $regUserPhone3rd = strip_tags($app->input->getString('phone'));//manager phone
        $regCompanyTimezone = strip_tags($app->input->getString('timezone'));//timezone
        $l = strip_tags($app->input->getString('lang'));
        $enable_ct_iframe = strip_tags($app->input->getString('enable_ct_iframe'));
        $enable_app_iframe = strip_tags($app->input->getString('enable_app_iframe'));
        $enable_kiosk_iframe = strip_tags($app->input->getString('enable_kiosk_iframe'));
        $enable_curio_schedules = strip_tags($app->input->getString('enable_curio_schedules'));
        
        $lang = & JFactory::getLanguage();
        
        if ($l == 'is') {
            $lang->setLanguage('is-IS');
            $lang->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        } else {
            $lang->setLanguage('en-GB');
            $lang->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'en-GB';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        
        if($enable_default_rules == '1'){
            $regCompanyRule = strip_tags($app->input->getInt('regCompanyRule3rd'));
            $rule_type = strip_tags($app->input->getString('regCompanyRuleType3rd'));
        } if($enable_pp_inputs_in_home_reg_company_form == '1'){
            $regCompanyFrom = strip_tags($app->input->getString('from'));//from
            $regCompanyTo = strip_tags($app->input->getString('to'));//to
        }
        
        
        
        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {        
            
            if(empty($manager_company)){
                $input_name = '#regCompanyName3rd';
                throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_EMPTY_COMPANY_IFRAME_API'));
            } 
            $company_exising = $model->checkCompany($manager_company);
            if($company_exising == '0'){
                $input_name = '#regCompanyName3rd';
                throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_COMPANY_EXIST_IFRAME_API'));
            }
            if($enable_default_rules == '1' && empty($regCompanyRule)){
                throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_EPTY_RULE_ID_IFRAME_API'));
            }
            if($enable_default_rules == '1' && empty($rule_type)){
                $input_name = '#regCompanyRule3rd';
                throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_EPTY_RULE_TYPE_IFRAME_API'));
            }
            
            if($enable_pp_inputs_in_home_reg_company_form == '1'){
                if(empty($regCompanyFrom)){
                    $input_name = '#regCompanyFrom3rd';
                    throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_EPTY_FROM_IFRAME_API'));
                }
                if(empty($regCompanyTo)){
                    $input_name = '#regCompanyTo13rd';
                    throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_EPTY_TO_IFRAME_API'));
                }

                $result_check_date_from_format = self::checkDateFormat($regCompanyFrom);
                if($result_check_date_from_format != 1){
                    $input_name = '#regCompanyFrom3rd';
                    throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_INCORRECT_DATE_FROM_FORMAT_IFRAME_API'));
                }
                
                $result_check_date_to_format = self::checkDateFormat($regCompanyTo);
                if($result_check_date_to_format != 1){
                    $input_name = '#regCompanyTo13rd';
                    throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_INCORRECT_DATE_TO_FORMAT_IFRAME_API'));
                }
            }
            
            if(empty($manager_username)){
                throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_EPTY_MANAGER_NAME_IFRAME_API'));
            }
            $manager_existing = $model->checkTrueUsernameUsers($manager_username);
            if ($manager_existing > 0) {
                $input_name = '#regCompanyName3rd';
                throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_MANAGER_EXIST_IFRAME_API'));
            } 
            if(empty($regUserName)){
                $input_name = '#regUserName13rd';
                throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_EPTY_USER_NAME_IFRAME_API'));
            }
            $username_existing = $model->checkTrueUsernameUsers($regUserName);
            if ($username_existing > 0) {
                $input_name = '#regUserName13rd';
                throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_USER_EXIST_IFRAME_API'));
            } 
            if(empty($regIDManager)){
                throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_EPTY_MANAGER_ID_IFRAME_API'));
            }
            $id_existing = $model->checkIDUsers($regIDUser);
            if ($id_existing > 0) {
                $input_name = '#regIDUser3rd';
                throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_MANAGER_ID_EXIST_IFRAME_API'));
            } 
            if(empty($regIDUser)){
                $input_name = '#regIDUser3rd';
                throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_EPTY_USER_ID_IFRAME_API'));
            } 
            $id_existing_user = $model->checkIDUsers($regIDUser);
            if ($id_existing_user > 0) {
                $input_name = '#regIDUser3rd';
                throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_USER_ID_EXIST_IFRAME_API'));
            } 
            //exit;
            if(empty($regPasswordManager)){
                $input_name = '#regPasswordManager';
                //throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY_POPUP_ERROR_EPTY_MANAGER_PASSWORD'));
                $regPasswordManager = $model->generateManagerPassword();
            }
            
            $global_api_model = JModelLegacy::getInstance('Ctapi', 'AuditModel');
            $external_check = $global_api_model->checkData('password', [
                'company' => $manager_company,
                'password' => $regPasswordManager
            ]);
            if($external_check == '0'){
                $input_name = '#regPasswordManager3rd';
                throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_EXTERNAL_IFRAME_API'));
            }
            
            $password_existing = $model->checkPasswordUsers($regPasswordManager);
            if ($password_existing > 0) {//user with password2 is exist
                $input_name = '#regPasswordManager3rd';
                throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_MANAGER_PASSW_EXIST_IFRAME_API'));
            } 
            if(empty($regPasswordUser)){
                $input_name = '#regPasswordUser3rd';
                throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_EPTY_USER_PASSWORD_IFRAME_API'));
            }
            $external_check_user = $global_api_model->checkData('password', [
                'company' => $manager_company,
                'password' => $regPasswordUser
            ]);
            if($external_check_user == '0'){
                $input_name = '#regPasswordUser3rd';
                throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_EXTERNAL_USER_IFRAME_API'));
            }
            
            $password_existing_user = $model->checkPasswordUsers($regPasswordUser);
            if ($password_existing_user > 0) {//user with password2 is exist
                $input_name = '#regPasswordUser3rd';
                throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_USER_PASSWORD_EXIST_IFRAME_API'));
            } 
            if($regPasswordManager == $regPasswordUser){
                throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_PASSWORD_MATCH_IFRAME_API'));
            }
            if(empty($regEmailCommon)){
                $input_name = '#regEmailCommon3rd';
                throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_EPTY_EMAIL_IFRAME_API'));
            }
            if(empty($regUserLimit3rd)){
                $input_name = '#regUserLimit3rd';
                throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_EPTY_USER_LIMIT_IFRAME_API'));
            }
            if(empty($regUserPhone3rd)){
                $input_name = '#regUserPhone3rd';
                throw new Exception(JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_ERROR_EPTY_USER_PHONE_IFRAME_API'));
            }
            if(empty($l)){
                $input_name = '#regCompanyName3rd';
                throw new Exception(JText::_('COM_AUDIT_REGISTRATION_COMPANY3RD_API_ERROR_EMPTY_LANG')); 
            }

            $enable_default_rules = '1';
            
           
           
            
            $_REQUEST['enable_ct_iframe'] = $enable_ct_iframe;
            $_REQUEST['enable_app_iframe'] = $enable_app_iframe;
            $_REQUEST['enable_kiosk_iframe'] = $enable_kiosk_iframe;
            $_REQUEST['enable_curio_schedules'] = $enable_curio_schedules;
            
            if($enable_default_rules == '1'){
                $res = $model->registerNewCompany3rdApi([
                    'manager_company'=>$manager_company,
                    'manager_username'=>$manager_username, 
                    'regUserName'=>$regUserName,
                    'regIDManager'=>$regIDManager,
                    'regIDUser'=>$regIDUser,
                    'regPasswordManager'=>$regPasswordManager,
                    'regPasswordUser'=>$regPasswordUser,
                    'regEmailCommon'=>$regEmailCommon,
                    'regCompanyRule' => $regCompanyRule,
                    'rule_type' => $rule_type,
                    'lang' => $l,
                    'regCompanyFrom' => $regCompanyFrom,
                    'regCompanyTo' => $regCompanyTo,
                    'regUserLimit3rd' => $regUserLimit3rd,
                    'regUserPhone3rd' => $regUserPhone3rd,
                    'log' => '1',
                    'regCompanyTimezone' => $regCompanyTimezone,
                    
                    'enable_ct_iframe' => $enable_ct_iframe,
                    'enable_app_iframe' => $enable_app_iframe,
                    'enable_kiosk_iframe' => $enable_kiosk_iframe,
                    'enable_curio_schedules' => $enable_curio_schedules
                ]);
            } else{
                $res = $model->registerNewCompany3rdApi([
                    'manager_company'=>$manager_company,
                    'manager_username'=>$manager_username,
                    'regUserName'=>$regUserName,
                    'regIDManager'=>$regIDManager,
                    'regIDUser'=>$regIDUser,
                    'regPasswordManager'=>$regPasswordManager,
                    'regPasswordUser'=>$regPasswordUser, 
                    'regEmailCommon'=>$regEmailCommon,
                    'regCompanyRule' => 0,
                    'rule_type' => 0,
                    'lang' => $l,
                    'regCompanyFrom' => '',
                    'regCompanyTo' => '',
                    'regUserLimit3rd' => $regUserLimit3rd,
                    'regUserPhone3rd' => $regUserPhone3rd,
                    'log' => '1',
                    'regCompanyTimezone' => $regCompanyTimezone,
                    
                    'enable_ct_iframe' => $enable_ct_iframe,
                    'enable_app_iframe' => $enable_app_iframe,
                    'enable_kiosk_iframe' => $enable_kiosk_iframe,
                    'enable_curio_schedules' => $enable_curio_schedules
                ]);
            }
            
       
            
            $respData['res'] = [
               'regUserName'=> $regUserName,    
               'insert_id' => $res,
               'lang' => $l
            ];
            $respData['status'] = 1;
            $respData['message'] = JText::_('COM_AUDIT_HOME_REGISTRATION_COMPANY3RD_POPUP_USER_SUCCESS_IFRAME_API');
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
            $respData['input_name'] = $input_name;
        }     
        
        return $respData;
    }
    
    public function getCompanySchedulesAsDate()
    {
        $app = JFactory::getApplication();
        $token_raw = $app->input->getString('user_token');
        $user_token = $this->decrypt($token_raw);   
        $date = $app->input->getString('date');
       
        
        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {     
            $respData['status'] = 1;
            
            if(empty($user_token)){                
                throw new Exception('Enter token!');
            }
            
            $user_obj = $this->getUserByToken($user_token); 
            if(empty($user_obj)){                
                throw new Exception('Enter correct token!');
            }
            $result_check_date_from_format = self::checkDateFormatWithFormatArg($date, 'd.m.Y');
            if(empty($date) || $result_check_date_from_format != 1){
                throw new Exception('Enter correct from date format: d.m.Y');
            } 
            /*$result_check_date_to_format = self::checkDateFormatWithFormatArg($to, 'd.m.Y');
            if(empty($to) || $result_check_date_to_format != 1){
                throw new Exception('Enter correct to date format: d.m.Y');
            } */
            
            $user_joomla_obj = JFactory::getUser($user_obj->id);
            if(in_array(6, $user_joomla_obj->groups)){
                throw new Exception($this->user_is_manager_txt);
            }
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    throw new Exception($this->api_not_enable_txt);
                }
            }
            
            JLoader::register('Spec_holiday2ModelApp_api', JPATH_ROOT . DS . 'components' . DS . 'com_shifts' . DS . 'models' . DS . 'app_api.php');            
            $model = JModelLegacy::getInstance('App_api', 'Spec_holiday2Model');
            
            //$res = ['response from ct'];
            $res = $model->getCompanySchedulesAsDate($user_obj->owner_id, $date);
            if(empty($res)){                
                throw new Exception('No data found!');
            }
            
             
            $respData['data'] = $res;
            //respData['request'] = $_REQUEST;
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }  
        
        return $respData; 
    }
    
    public function isNotificationDisabledOnUserCompany()
    {
        $app = JFactory::getApplication();
        $token_raw = $app->input->getString('user_token');
        $user_token = $this->decrypt($token_raw);   

        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {     
            $respData['status'] = 1;
            
            if(empty($user_token)){                
                throw new Exception('Enter token!');
            }
            
            $user_obj = $this->getUserByToken($user_token); 
            if(empty($user_obj)){                
                throw new Exception('Enter correct token!');
            }
            
            
            $user_joomla_obj = JFactory::getUser($user_obj->id);
            $manager_joomla_obj = JFactory::getUser($user_joomla_obj->owner_id);
            
            if(in_array(6, $user_joomla_obj->groups)){
                throw new Exception($this->user_is_manager_txt);
            }
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    throw new Exception($this->api_not_enable_txt);
                }
            }

            if($manager_joomla_obj->shifts_send_never == 1){
                $res = 1;
            } else{
                $res = 0;
            }

            $respData['data'] = $res;
           
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }  
        
        return $respData; 
    }
    
    public function addScheduleMessage()
    {
        $app = JFactory::getApplication();
        $token_raw = $app->input->getString('user_token');
        $user_token = $this->decrypt($token_raw);   
        $date = $app->input->getString('date');
        $message = $app->input->getString('message');
        
        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {     
            $respData['status'] = 1;
            
            if(empty($user_token)){                
                throw new Exception('Enter user token!');
            } 

            $user_obj = $this->getUserByToken($user_token); 
            if(empty($user_obj)){                
                throw new Exception('Enter correct token!');
            }
            $result_check_date_from_format = self::checkDateFormatWithFormatArg($date, 'd.m.Y');
            if(empty($date) || $result_check_date_from_format != 1){
                throw new Exception('Enter correct date format: d.m.Y');
            } if(empty($message)){                
                throw new Exception('Enter message!');
            }
            
            $user_joomla_obj = JFactory::getUser($user_obj->id);
            $manager_joomla_obj = JFactory::getUser($user_joomla_obj->owner_id);
            
            if(in_array(6, $user_joomla_obj->groups)){
                throw new Exception($this->user_is_manager_txt);
            }
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    throw new Exception($this->api_not_enable_txt);
                }
            }
            JLoader::register('Spec_holiday2ModelApp_api', JPATH_ROOT . DS . 'components' . DS . 'com_shifts' . DS . 'models' . DS . 'app_api.php');
            $model = JModelLegacy::getInstance('App_api', 'Spec_holiday2Model');
            
            /*$from_obj =   DateTime::createFromFormat('d.m.Y H:i:s', $date . '00:00:00');
            if($from !== false && !array_sum($from::getLastErrors())){
                $to_obj = clone $from;
               // $to_obj->modify('+1 second');
            } */
            
            $lang = 'en';
            $shift_color = '#d3277c';
            $shift_name = 'Shift name';
           // $status = 'pending_available';
            $icon_date = $date;
            
          
            $res = $model->addScheduleMessageForApi($user_obj->id, $lang, $shift_color, $shift_name, $date, $message, $icon_date);
            
           
            
            /*if(empty($res) || $res == 'error-0') {
                throw new Exception("Dates overlap an existing period!");
            }*/ 
            
            $respData['data']['res'] = $res;
           // $respData['data']['from'] = $from->format('d.m.Y H:i:s');
           // $respData['data']['to'] = $to->format('d.m.Y H:i:s');
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }  
        
        return $respData; 
    }
    
    public function setDeviceId()
    {
        $app = JFactory::getApplication();
        $token_raw = $app->input->getString('user_token');
        $user_token = $this->decrypt($token_raw);   
        $device_id = $app->input->getString('device_id');
        $enable_push_for_this_device = $app->input->getInt('enable_push_for_this_device');
        
        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {     
            $respData['status'] = 1;
            
            if(empty($user_token)){                
                throw new Exception('Enter user token!');
            } 

            $user_obj = $this->getUserByToken($user_token); 
            if(empty($user_obj)){                
                throw new Exception('Enter correct token!');
            }
           
            
            $user_joomla_obj = JFactory::getUser($user_obj->id);
            $manager_joomla_obj = JFactory::getUser($user_joomla_obj->owner_id);
            
            if(in_array(6, $user_joomla_obj->groups)){
                throw new Exception($this->user_is_manager_txt);
            }
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    throw new Exception($this->api_not_enable_txt);
                }
            }
            if(empty($device_id)){
                throw new Exception('Enter device id!');
            }
            JLoader::register('AuditModelRegistered_Users', JPATH_ROOT . DS . 'components' . DS . 'com_audit' . DS . 'models' . DS . 'registered_users.php');
            $model = JModelLegacy::getInstance('Registered_Users', 'AuditModel');
            
            if(!isset($enable_push_for_this_device)){
                $enable_push_for_this_device = 1;
            }
            $res = $model->setDeviceId($user_obj, $device_id, $enable_push_for_this_device);

            $respData['data']['res'] = $res;
           
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }  
        
        return $respData; 
    }
    
    public function removeDeviceId()
    {
        $app = JFactory::getApplication();
        $token_raw = $app->input->getString('user_token');
        $user_token = $this->decrypt($token_raw);   
        $device_id = $app->input->getString('device_id');
    
        
        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {     
            $respData['status'] = 1;
            
            if(empty($user_token)){                
                throw new Exception('Enter user token!');
            } 

            $user_obj = $this->getUserByToken($user_token); 
            if(empty($user_obj)){                
                throw new Exception('Enter correct token!');
            }
           
            
            $user_joomla_obj = JFactory::getUser($user_obj->id);
            $manager_joomla_obj = JFactory::getUser($user_joomla_obj->owner_id);
            
            if(in_array(6, $user_joomla_obj->groups)){
                throw new Exception($this->user_is_manager_txt);
            }
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    throw new Exception($this->api_not_enable_txt);
                }
            }
            if(empty($device_id)){
                throw new Exception('Enter device id!');
            }
            JLoader::register('AuditModelRegistered_Users', JPATH_ROOT . DS . 'components' . DS . 'com_audit' . DS . 'models' . DS . 'registered_users.php');
            $model = JModelLegacy::getInstance('Registered_Users', 'AuditModel');
            
           
            $res = $model->removeDeviceId($user_obj, $device_id);

            $respData['data']['res'] = $res;
           
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }  
        
        return $respData;
    }
    
    public function getAvailableSchedulesAsDate()
    {
        $app = JFactory::getApplication();
        $token_raw = strip_tags($app->input->getString('user_token'));
        $user_token = $this->decrypt($token_raw);   
        $date = strip_tags($app->input->getString('date'));
    
        
        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {     
            $respData['status'] = 1;
            
            if(empty($user_token)){                
                throw new Exception('Enter user token!');
            } 

            $user_obj = $this->getUserByToken($user_token); 
            if(empty($user_obj)){                
                throw new Exception('Enter correct token!');
            }
           
            
            $user_joomla_obj = JFactory::getUser($user_obj->id);
            $manager_joomla_obj = JFactory::getUser($user_joomla_obj->owner_id);
            
            if(in_array(6, $user_joomla_obj->groups)){
                throw new Exception($this->user_is_manager_txt);
            }
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    throw new Exception($this->api_not_enable_txt);
                }
            }
           
            $result_check_date_from_format = self::checkDateFormatWithFormatArg($date, 'Y-m-d');
            if(empty($date) || $result_check_date_from_format != 1){
                throw new Exception('Enter correct date format: Y-m-d');
            } 
            JLoader::register('Spec_holiday2ModelApp_api', JPATH_ROOT . DS . 'components' . DS . 'com_shifts' . DS . 'models' . DS . 'app_api.php');
            $model = JModelLegacy::getInstance('App_api', 'Spec_holiday2Model');
            
           
            $res = $model->getAvailableSchedulesAsDate($user_obj, $date);

            $respData['data']['res'] = $res;
           
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }  
        
        return $respData;
    }
    
    public function getQuotesWithLang() {
        $app = JFactory::getApplication();
        $token_raw = $app->input->getString('user_token');
        $lang = $app->input->getString('lang');
        
        $user_token = $this->decrypt($token_raw);   
        
        $respData  =  [];
        $respData['status']     =   0;
        $respData['message']    =   "";
        $respData['data']       =   [];  
        
        try {        
            if(empty($user_token))    {                
                throw new Exception('Enter correct token!');
            }            
            if(!in_array($lang, ['en', 'is'])){
                throw new Exception('Enter correct lang - en or is!');
            }
            
            $user_obj = $this->getUserByToken($user_token);
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    throw new Exception($this->api_not_enable_txt);
                }
            }
            
            $manager_obj=  JFactory::getUser($user_obj->owner_id);
            if($this->enable_jokes_module == '1'){
                if ($manager_obj->jokes_home_status == 1) { 
                  
                    jimport('joomla.application.module.helper');
                    $respData['status'] = 1;
                    
                    if ($lang === 'is') {
                        $mods = JModuleHelper::getModules('random_jokes_home');
                        $res = JModuleHelper::renderModule($mods[1]);
                    } else {
                        $mods = JModuleHelper::getModules('random_jokes_home');
                        $res = JModuleHelper::renderModule($mods[0]);
                    }

                    if (is_array($res)) {
                        foreach ($res as $k => $v) {
                            $res[$k] = trim($v);
                        }
                    }
                    
                    $res = json_decode($res);
                    $respData['data'] = $res;
                      
                 } elseif($manager_obj->quote_home_status == 1){
                  
                    $respData['status'] = 1;
                    jimport('joomla.application.module.helper');
                    $mods = JModuleHelper::getModules('random_quotes_home');
                    //$res    =   trim(addslashes((JModuleHelper::renderModule($mods[0]))));
                    $res = JModuleHelper::renderModule($mods[0]);
                    if (is_array($res)) {
                        foreach ($res as $k => $v) {
                            $res[$k] = trim($v);
                        }
                    }
                    $res = json_decode($res);
                    $respData['data'] = $res;
                } else{
                    throw new Exception('The manager of the current company did not include quotes or jokes.');
                }
            } else {
                if ($manager_obj->quote_home_status == 1) {
                    $respData['status'] = 1;
                    jimport('joomla.application.module.helper');
                    $mods = JModuleHelper::getModules('random_quotes_home');
                    //$res    =   trim(addslashes((JModuleHelper::renderModule($mods[0]))));
                    $res = JModuleHelper::renderModule($mods[0]);
                    if (is_array($res)) {
                        foreach ($res as $k => $v) {
                            $res[$k] = trim($v);
                        }
                    }
                    $res = json_decode($res);
                    $respData['data'] = $res;
                } else {
                    throw new Exception('The manager of the current company did not include quotes.');
                }
            }
        } catch (Exception $e) {
            $respData['status']     =   0;
            $respData['message']    =   $e->getMessage();
        }        
        return $respData;        
    }
    
    public function getCalcWidgetLink()
    { 
        $app = JFactory::getApplication();
        $token_raw = $app->input->getString('user_token');
        $user_token = $this->decrypt($token_raw);   
        $lang = $app->input->getString('lang');
        
        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {         
            if(empty($user_token)){                
                throw new Exception('Enter token!');
            }
            
            $user_obj = $this->getUserByToken($user_token);
            if(empty($user_obj) || $user_obj->id == 0){                
                throw new Exception('Enter correct token!');
            }
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    return $this->api_not_enable_txt;
                }
            }
            JLoader::register('AuditModelCalc', JPATH_ROOT . '/components/com_audit/models/calc.php');
            $model = JModelLegacy::getInstance('Calc', 'AuditModel');
            JLoader::register('AuditController', JPATH_ROOT . '/components/com_audit/controller.php');
            
            if($user_obj->from_widget_form != 1){
                throw new Exception('Use correct method for get calculation link. Try getCalcUrl(). This user is not supported in current method.');
            } else{
                $save_user = $model->loadWidgetLink($user_obj); 
                
                if(empty($save_user->link)) {
                    throw new Exception('No calculation link found!');
                }
                /*$pay_period_data = AuditController::loadBottomTotalsApiNewCalc([
                            'u_id' => $user_obj->id,
                            'lang' => 'en',
                            'from_to' => ''
                ]);*/
                $pay_period_data = AuditController::loadBottomTotalsApi([
                    'u_id' => $user_obj->id,
                    'lang' => 'en',
                    'from_to' => ''
                ]);
                
                $link = $this->addPayPeriodDataToLink($save_user, $user_obj, $pay_period_data, $lang);
            }
           
            
            $respData['status'] = 1;      
            $respData['reg_type'] = $user_obj->reg_type;
            $respData['data'] = $link;
            $respData['raw_data'] = $save_user;
            $respData['pay_period_data'] = $pay_period_data;
            
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }  
        
        return $respData; 
    }
    
    private function addPayPeriodDataToLink(object $save_user, object $user_obj, $pay_period_data, $lang)
    {
        $final_link = 'https://sgs.taxti.is/index.php/' . $lang . '/?' . $save_user->link;
        //$final_link = 'https://dev2-sgs.taxti.is/' . $save_user->link;
        /*$final_link = 'https://laun.taxti.is/index.php/' . $lang . '/?step2=';*/
        
        $not_permitted_items_pp = [
            'not_converted',
            'total'
        ];
         
        $j = 0;
        foreach($pay_period_data['final_res'] as $k => $v){
            if(!in_array($k, $not_permitted_items_pp)){
                $final_link .= '&' . $k . '=' . $v;
                    
                $j++;
            }
        }
       
        
        return $final_link;
    }
    
    public function getUserTypeRegistration()
    {
        $app = JFactory::getApplication();
        $token_raw = $app->input->getString('user_token');
        $user_token = $this->decrypt($token_raw);   
        $lang = $app->input->getString('lang');
        
        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {         
            if(empty($user_token)){                
                throw new Exception('Enter token!');
            }
            
            $user_obj = $this->getUserByToken($user_token);
            if(empty($user_obj)){                
                throw new Exception('Enter correct token!');
            }
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    return $this->api_not_enable_txt;
                }
            }
            //JLoader::register('AuditModelCalc', JPATH_ROOT . '/components/com_audit/models/calc.php');
            //$model = JModelLegacy::getInstance('Calc', 'AuditModel');
            JLoader::register('AuditController', JPATH_ROOT . '/components/com_audit/controller.php');
            
            $reg_type = 'default';
            if($user_obj->from_widget_form == '1'){
                $reg_type = 'widget';
            }

            $respData['status'] = 1;      
            $respData['reg_type'] = $reg_type;
           
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }  
        
        return $respData;
    }
    
    public function softDeleteHolidays()
    {
        $app = JFactory::getApplication();
        $token_raw = $app->input->getString('user_token');
        $user_token = $this->decrypt($token_raw);   
        $lang = $app->input->getString('lang');
        $delete = $app->input->getObject('delete');
        
        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {         
            if(empty($user_token)){                
                throw new Exception('Enter token!');
            }
            
            $user_obj = $this->getUserByToken($user_token);
            if(empty($user_obj)){                
                throw new Exception('Enter correct token!');
            }
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                   throw new Exception($this->api_not_enable_txt);
                }
            } if(!is_array($delete)){
                 throw new Exception('Enter correct type of delete!');
            }
            JLoader::register('Spec_holiday2ModelApp_api', JPATH_ROOT . '/components/com_spec_holiday2/models/app_api.php');
            $model = JModelLegacy::getInstance('App_api', 'Spec_holiday2Model');
            $res = $model->softDeleteHolidays($user_obj->id, $delete);
            
            $respData['status'] = 1;  
            $respData['data']['deleted'] = $delete;
            //$respData['res'] = $res; 
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }  
        
        return $respData;
    }
    
    public function setRoutePoint()
    {
        $app = JFactory::getApplication();
        $user_token = $this->decrypt($app->input->getString('user_token')); 
        $points = $app->input->getObject('points');
        $route_id = $this->decrypt($app->input->getString('route_id'));
        $lang = $this->decrypt($app->input->getString('lang'));
        
        /*echo '<pre>$route_id';
        print_r($route_id);
        echo '</pre>';*/
        
        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {         
            if(empty($user_token)){                
                throw new Exception('Enter token!');
            }
            
            $user_obj = $this->getUserByToken($user_token);
            if(empty($user_obj)){                
                throw new Exception('Enter correct token!');
            }
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                   throw new Exception($this->api_not_enable_txt);
                }
            } 
            JLoader::register('AuditModelGps', JPATH_ROOT . '/components/com_audit/models/gps.php');
            $model = JModelLegacy::getInstance('Gps', 'AuditModel');
            $res = $model->setRoutePointForApi($user_obj, $lang, $route_id, $points);
            
            $respData['status'] = 1;  
            $respData['data']['points'] = $points;
            //$respData['res'] = $res; 
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }  
        
        return $respData;
    }
    
    public function getRoutes()
    {
        $app = JFactory::getApplication();
        $user_token = $this->decrypt($app->input->getString('user_token')); 
        $date = $this->decrypt($app->input->getString('date'));
        $lang = $this->decrypt($app->input->getString('lang'));
        //echo '$date:'.$date;
        
        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {         
            if(empty($user_token)){                
                throw new Exception('Enter token!');
            }
            
            $user_obj = $this->getUserByToken($user_token);
            if(empty($user_obj)){                
                throw new Exception('Enter correct token!');
            }
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                   throw new Exception($this->api_not_enable_txt);
                }
            } 
            if(!empty($date) && $this->validateDate($date, 'Y-m-d') === false){
                throw new Exception('Enter date in correct format(Y-m-d)!');
            }
            JLoader::register('AuditModelGps', JPATH_ROOT . '/components/com_audit/models/gps.php');
            $model = JModelLegacy::getInstance('Gps', 'AuditModel');
            $res = $model->getRoutesForApi($user_obj, $lang, $date);
            
            $respData['status'] = 1;  
            $respData['data'] = $res;
            //$respData['res'] = $res; 
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }  
        
        return $respData;
    }
    
    public function setRoute()
    {
        $app = JFactory::getApplication();
        $user_token = $this->decrypt($app->input->getString('user_token')); 
        $route_id = $this->decrypt($app->input->getString('route_id'));
        $lang = $this->decrypt($app->input->getString('lang'));
        $date = $this->decrypt($app->input->getString('date'));
        $clock_in = $this->decrypt($app->input->getString('clock_in'));
        $clock_out = $this->decrypt($app->input->getString('clock_out'));
        $total = $this->decrypt($app->input->getString('total'));
        $task_manager = strip_tags($this->decrypt($app->input->getString('task_manager')));
        $from = strip_tags($this->decrypt($app->input->getString('from')));
        $to = strip_tags($this->decrypt($app->input->getString('to')));
        $from_coordinates = $app->input->getObject('from_coordinates');
        $to_coordinates = $app->input->getObject('to_coordinates');
        $message = strip_tags($this->decrypt($app->input->getString('message')));
        $custom = $app->input->getObject('custom');
        
        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = []; 
        
        try {         
            if(empty($user_token)){                
                throw new Exception('Enter token!');
            }
            
            $user_obj = $this->getUserByToken($user_token);
            if(empty($user_obj)){                
                throw new Exception('Enter correct token!');
            }
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                   throw new Exception($this->api_not_enable_txt);
                }
            } 
            if(!empty($date) && $this->validateDate($date, 'Y-m-d') === false){
                throw new Exception('Enter date in correct format(Y-m-d)!');
            } if(!empty($clock_in) && $this->validateDate($clock_in, 'H:i') === false){
                throw new Exception('Enter clock_in in correct format(H:i)!');
            } if(!empty($clock_out) && $this->validateDate($clock_out, 'H:i') === false){
                throw new Exception('Enter clock_out in correct format(H:i)!');
            } if(!empty($total) && $this->validateDate($total, 'H:i') === false){
                throw new Exception('Enter total in correct format(H:i)!');
            }
            
            $from_coordinates_decoded = json_decode($from_coordinates);
          
            
            switch (json_last_error()) {
                case JSON_ERROR_NONE:
                    //throw new Exception('Decoding ' . $to_coordinates . ' No errors');
                break;
                case JSON_ERROR_DEPTH:
                    throw new Exception('Decoding from_coordinates ' . $from_coordinates . ' error: Maximum stack depth exceeded');
                break;
                case JSON_ERROR_STATE_MISMATCH:
                   throw new Exception('Decoding from_coordinates ' . $from_coordinates . ' error: - Underflow or the modes mismatch');
                break;
                case JSON_ERROR_CTRL_CHAR:
                    throw new Exception('Decoding from_coordinates ' . $from_coordinates . ' error: - Unexpected control character found');
                break;
                case JSON_ERROR_SYNTAX:
                    throw new Exception('Decoding from_coordinates ' . $from_coordinates . ' error: - Syntax error, malformed JSON');
                break;
                case JSON_ERROR_UTF8:
                    throw new Exception('Decoding from_coordinates ' . $from_coordinates . ' error: - Malformed UTF-8 characters, possibly incorrectly encoded');
                break;
                default:
                    throw new Exception('Decoding from_coordinates ' . $from_coordinates . ' error: - Unknown error');
                break;
            }
            
            $to_coordinates_decoded = json_decode($to_coordinates);
          
            
            switch (json_last_error()) {
                case JSON_ERROR_NONE:
                    //throw new Exception('Decoding ' . $to_coordinates . ' No errors');
                break;
                case JSON_ERROR_DEPTH:
                    throw new Exception('Decoding to_coordinates ' . $to_coordinates . ' error: Maximum stack depth exceeded');
                break;
                case JSON_ERROR_STATE_MISMATCH:
                   throw new Exception('Decoding to_coordinates ' . $to_coordinates . ' error: - Underflow or the modes mismatch');
                break;
                case JSON_ERROR_CTRL_CHAR:
                    throw new Exception('Decoding to_coordinates ' . $to_coordinates . ' error: - Unexpected control character found');
                break;
                case JSON_ERROR_SYNTAX:
                    throw new Exception('Decoding to_coordinates ' . $to_coordinates . ' error: - Syntax error, malformed JSON');
                break;
                case JSON_ERROR_UTF8:
                    throw new Exception('Decoding to_coordinates ' . $to_coordinates . ' error: - Malformed UTF-8 characters, possibly incorrectly encoded');
                break;
                default:
                    throw new Exception('Decoding to_coordinates ' . $to_coordinates . ' error: - Unknown error');
                break;
            }
            
            if(!empty($custom) /*&& !empty($route_id)*/){
                foreach($custom as $row){
                    if(!array_key_exists('cell_name', $row) || !array_key_exists('value', $row)){
                        throw new Exception('Array struct must contain "cell_name" and "cell_value" keys!');
                    }
                }
            }
            
            JLoader::register('AuditModelGps', JPATH_ROOT . '/components/com_audit/models/gps.php');
            $model = JModelLegacy::getInstance('Gps', 'AuditModel');
            
            $is_enable_confirm_pp = self::getFinalCombineConfirmAndPpStatus($user_obj->id);   
            
            if ($is_enable_confirm_pp == '1') {
                JLoader::register('AuditModelConfirm_time', JPATH_ROOT . '/components/com_audit/models/confirm_time.php');
                $model_confirm = JModelLegacy::getInstance('Confirm_time', 'AuditModel');
                
                $query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` = '".$user_obj->id."' AND `id` = '$route_id'";
                $this->db->setQuery($query);
                $route = $this->db->loadObject();
                $pp_id = $route->pp_id;
                //hh4
                $confirm_id = $this->getConfirmIdByPpId($pp_id);
            } else{
                $query = "SELECT * FROM $this->dev_n_tools_table WHERE `user_id` = '".$user_obj->id."' AND `id` = '$route_id'";
                $this->db->setQuery($query);
                $route = $this->db->loadObject();
                
                $confirm_id = $route->confirm_id;
            }
            
            $res = $model->setRouteForApi($user_obj, $route_id, $date, $clock_in, $clock_out, $total, $task_manager, $from, $to, $from_coordinates_decoded, $to_coordinates_decoded, $message, $lang, $custom, $is_enable_confirm_pp, $confirm_id, $route);
            
            $respData['status'] = 1;  
            $respData['is_enable_confirm_pp'] = $is_enable_confirm_pp;
            //$respData['from_coordinates'] = $from_coordinates_decoded;
            //$respData['to_coordinates'] = $to_coordinates_decoded;
            //$respData['json_error'] = json_last_error();
            //$respData['json_last_error_msg'] = json_last_error_msg();
            //$respData['data'] = ['res' => $res];
            //$respData['res'] = $res; 
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }  
        
        return $respData;
    }
    
    public function startRoute()
    {
        $app = JFactory::getApplication();
        $user_token = $this->decrypt($app->input->getString('user_token'));
        
        $route_id = $this->decrypt($app->input->getString('route_id'));
        $lat = $this->decrypt($app->input->getString('lat'));
        $lng = $this->decrypt($app->input->getString('lng'));
        $row_hash = $this->decrypt($app->input->getString('row_hash'));
        $is_pressed_big_green_button = $this->decrypt($app->input->getInt('is_pressed_big_green_button'));
        $ignore_empty_task = $this->decrypt($app->input->getInt('ignore_empty_task'));
        $message = strip_tags($this->decrypt($app->input->getString('message')));
        $lang = $this->decrypt($app->input->getString('lang'));
        $client_ip = $app->input->getString('client_ip');
        
        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = []; 
        
        try {         
            if(empty($user_token)){                
                throw new Exception('Enter token!');
            }
            $user_obj = $this->getUserByToken($user_token);
            if(empty($user_obj)){                
                throw new Exception('Enter correct token!');
            }
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                   throw new Exception($this->api_not_enable_txt);
                }
            } 
          
            if(empty($route_id)){
                throw new Exception('Enter route id!');
            } if(empty($lang)){
                throw new Exception('Enter lang!');
            }

            //startTime part
            $password = $user_obj->password2;
            $company = $user_obj->company;        
            $client_ip_raw = $this->db->escape($app->input->getString('client_ip'));
            $client_ip = $this->decrypt($client_ip_raw);
            $ownerID = $user_obj->owner_id;
            
            if($user_obj->gps_mode == '0'){
                $lat = '';
                $lng = '';
            }
            $app = JFactory::getApplication();
            $is_pressed_big_green_button = $app->input->getInt('is_pressed_big_green_button');
            $ignore_empty_task = $app->input->getInt('ignore_empty_task');
        
            $ids = $this->getUser1($company, $ownerID, $password);
            $u_id = $ids->id;
        
           
        
            $note = $message;

            if($this->disable_start_time_with_no_task == 1){
                if($ids->SDSTWNTS == 1 && empty($note) && $ignore_empty_task != 1){
                    throw new Exception(JText::_('Start time error: Please, enter work description!')); 
                }
            }
        
            if (!empty($u_id)) {
                $system_mode = $this->checkSystemMode($u_id);
          
           
                if($system_mode == 'confirm'){
                    if ($this->setConfirmTime($u_id, $lat, $lng, $note, $client_ip, $row_hash, $route_id)) {
                   
                        // Update User Status to Green (1)
                        $this->updateUserStatusToGreen($u_id);
                        //set button status
                        $this->setGreenButtonPressedStatus($is_pressed_big_green_button, $system_mode, $u_id);
                    
                        $res = 'ok';
                    }
                } elseif($system_mode=='pay_period'){//hh4
                    if ($this->setTimeWrapper($u_id, $lat, $lng, $note, $client_ip, $row_hash, $route_id)) {
                        // Update User Status to Green (1)
                        $this->updateUserStatusToGreen($u_id);
                        //set button status
                        $this->setGreenButtonPressedStatus($is_pressed_big_green_button, $system_mode, $u_id);
                    
                        $res = 'ok';
                    }
                }
            
            }    
            //end startTime part
            
            //start route part
            JLoader::register('AuditModelGps', JPATH_ROOT . '/components/com_audit/models/gps.php');
            $model = JModelLegacy::getInstance('Gps', 'AuditModel');
            $model->startRoute($user_obj, $route_id, $message);
            //end start route part
            
            $respData['status'] = 1;  
            $respData['data'] = [
                //'res' => $res,
                //'$user_obj' => $user_obj,
                //'request' => $_REQUEST,
                //'$message' => $message
            ];
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }  
        
        return $respData;
    }
    
    public function stopRoute()
    {
        $app = JFactory::getApplication();
        $user_token = $this->decrypt($app->input->getString('user_token'));
        
        $route_id = $this->decrypt($app->input->getString('route_id'));
        $lat = $app->input->getString('lat');
        $lng = $app->input->getString('lng');
        $message = strip_tags($this->decrypt($app->input->getString('message')));
        $lang = $this->decrypt($app->input->getString('lang'));
        
        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = []; 
        
        try {         
            if(empty($user_token)){                
                throw new Exception('Enter token!');
            }
            $user_obj = $this->getUserByToken($user_token);
            if(empty($user_obj)){                
                throw new Exception('Enter correct token!');
            }
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                   throw new Exception($this->api_not_enable_txt);
                }
            } 
          
            if(empty($route_id)){
                throw new Exception('Enter route id!');
            } if(empty($lang)){
                throw new Exception('Enter lang!');
            }

            //stopTimeWrapper part
            //$token = trim($_REQUEST['token']);
            // $user_obj = $this->getUserByToken($token);
            
            $_REQUEST['lat_end'] = $lat;//need send encoded 
            $_REQUEST['lng_end'] = $lng;
            $_REQUEST['description_logout'] = $app->input->getString('message');
            
            if($user_obj->gps_mode == '0'){
                $_REQUEST['lat_end']= '';
                $_REQUEST['lng_end'] = '';
            }
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                    throw new Exception($this->api_not_enable_txt);
                }
            }
        
            $system_mode = $this->getSystemMode($user_obj->company);
        
            if($system_mode == 'confirm'){
                $this->stopTimeConfirm($user_obj);
            } elseif($system_mode == 'pay_period'){
                $this->stopTime($user_obj); 
            }
        
            $this->clearBigGreenButtonPressed($user_obj->id, $system_mode); 
            //end stopTimeWrapper part
            
            //start route part
            JLoader::register('AuditModelGps', JPATH_ROOT . '/components/com_audit/models/gps.php');
            $model = JModelLegacy::getInstance('Gps', 'AuditModel');
            $model->stopRoute($user_obj, $route_id, $message);
            //end start route part
            
            $respData['status'] = 1;  
            $respData['data'] = [
                //'res' => $res,
                //'$user_obj' => $user_obj,
                //'request' => $_REQUEST,
                //'$message' => $message
            ];
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }  
        
        return $respData;
    }
    
    public function getAutoCollectTexts()
    {
        $app = JFactory::getApplication();
        $user_token = $this->decrypt($app->input->getString('user_token')); 
        $lang = $this->decrypt($app->input->getString('lang'));
      
        
        $respData = [];
        $respData['status'] = 0;
        $respData['message'] = "";
        $respData['data'] = [];
        
        try {         
            if(empty($user_token)){                
                throw new Exception('Enter token!');
            }
            
            $user_obj = $this->getUserByToken($user_token);
            if(empty($user_obj)){                
                throw new Exception('Enter correct token!');
            }
            if($user_obj->is_hide == 1){
                throw new Exception($this->user_is_hidden_txt);
            }
            if($this->enable_api_blocking_by_option_from_admin_panel == '1'){
                $perm = $this->checkGlobalApiPermission($user_obj->id);
                if($perm === 0){
                   throw new Exception($this->api_not_enable_txt);
                }
            } 
            if(!empty($date) && $this->validateDate($date, 'Y-m-d') === false){
                throw new Exception('Enter date in correct format(Y-m-d)!');
            }
            JLoader::register('AuditModelGps', JPATH_ROOT . '/components/com_audit/models/gps.php');
            $model = JModelLegacy::getInstance('Gps', 'AuditModel');
            $res = $model->getAutoCollectTextsApi($user_obj, $lang);
            
            $respData['status'] = 1;  
            $respData['data'] = $res;
            //$respData['res'] = $res; 
        } catch (Exception $e) {
            $respData['status'] = 0;
            $respData['message'] = $e->getMessage();
        }  
        
        return $respData;
    }
}
