<?php

/*ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);*/

class TestingAppApi {

    public function __construct() {
        // parent::__construct();

        $this->db = &JFactory::getDBO();
        $this->app = JFactory::getApplication();
        $this->doc = JFactory::getDocument();
        $this->server_path = JPATH_BASE;
        $this->user = & JFactory::getUser();
        $this->lang = & JFactory::getLanguage();

        $this->password_current_api = PASSWORD_ULTIMA;
        $this->server_name = $_SERVER['SERVER_NAME'];

        if ($this->server_name == 'localhost') {
            $this->ultima_api_path = 'http://' . $this->server_name . '/app_api/api.php';
        } else {
            $this->ultima_api_path = 'https://' . $this->server_name . '/app_api/api.php';
        }

        $this->client_info = $_SERVER['HTTP_USER_AGENT'];
        $this->client_ip = $_SERVER['REMOTE_ADDR'];
    }

    public function preparePassw($passw) {
        return password_hash($passw, PASSWORD_BCRYPT);
    }
    
    /**
        * The method delete holidays by ids in app only 
        * Response https://screenrec.com/share/cmnbCFIUTE .
        * Please, checking 'status'. This must be equal 1 otherwise see the message field in response.
        *   
        * array['fields']              array Defines the fields to be shown by scaffolding.
        *              ['user_token']  string user_token
        *              ['lang']        string lang
        *              ['delete']      array delete
        * 
        * @param array $config (See above)
        * @return Object std.
    */
    public function softDeleteHolidaysTest(array $config) {
        echo 'softDeleteHolidays';

        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $post = http_build_query([
            'passw' => $prepare_passw_auth,
            'action' => 'softDeleteHolidays',
            'client_info' => $this->client_info,
            'user_token' => $prepare_user_token,
            'lang' => $config['lang'],
            'delete' => $config['delete']
        ]);
        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }
    
    
    public function checkPasswordTEST($password_for_verify, $company) {
        echo 'checkPassword';
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_password_for_verify = $this->encrypt($password_for_verify);
        $prepare_company_for_verify = $this->encrypt($company);

        //echo $prepare_password_for_verify;
        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'checkPassword',
                'client_info' => $this->client_info,
                'password_for_verify' => $prepare_password_for_verify,
                'company_for_verify' => $prepare_company_for_verify
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    public function getCompanyImagesTEST($company) {
        echo 'getCompanyImages';

        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_company_for_verify = $this->encrypt($company);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'getCompanyImages',
                'client_info' => $this->client_info,
                'company_for_verify' => $prepare_company_for_verify
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    public function getOwnerIDTEST($user_id) {
        echo 'getOwnerID';
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);


        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'getOwnerID',
                'client_info' => $this->client_info,
                'user_id' => $user_id
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    public function checkSpecCompaniesTEST($user_id, $company) {

        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_company_for_verify = $this->encrypt($company);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'checkSpecCompanies',
                'client_info' => $this->client_info,
                'company' => $prepare_company_for_verify,
                'user_id' => $user_id
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * Get company departments object.
     *
     * @param  string  $user_token
     * @return std object
     */
    public function getGroupArrayTEST($user_token) {
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($user_token);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'getGroupArray',
                'client_info' => $this->client_info,
                'user_token' => $prepare_user_token,
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * Get users online. 
     *
     * @param  string  $user_id
     * @param  string  $dep_string
     * @return array of stdClass Objects
     */
    public function getListUsersTEST($user_id, $dep_string) {
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);


        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'getListUsers',
                'client_info' => $this->client_info,
                'user_id' => $user_id,
                'dep_string' => $dep_string
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    public function askedGpsTEST($token) {
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepared_token = $this->encrypt($token);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'askedGps',
                'client_info' => $this->client_info,
                'token' => $prepared_token
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * The method add record to Confirm/Pay period(or Confirm and pay period)
     * Response "ok" or "Start time error: Please, enter work description!".
     *   
     * @param string $token
     * @param string $lat
     * @param string $lng
     * @param string $note
     * @param int $is_pressed_big_green_button
     * @param int $ignore_empty_task
     * @return Object std.
     */
    public function startTimeTEST($token, $lat, $lng, $note, $row_hash, $is_pressed_big_green_button, $ignore_empty_task = null) {

        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        //$prepare_password_for_verify=$this->encrypt($password_for_verify);
        //$prepare_company_for_verify=$this->encrypt($company);

        $lat_encr = $this->encrypt($lat);
        $lng_encr = $this->encrypt($lng);
        $ip_encrypt = $this->encrypt($this->client_ip);

        //echo $prepare_password_for_verify;
        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'startTime',
                'client_info' => $this->client_info,
                'token' => $token,
                'lat' => $lat_encr,
                'lng' => $lng_encr,
                'note' => $note,
                'row_hash' => $row_hash,
                'client_ip' => $ip_encrypt,
                'is_pressed_big_green_button' => $is_pressed_big_green_button,
                'ignore_empty_task' => (int) $ignore_empty_task
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return $out;
    }

    public function stopTimeTEST($token, $lat, $lng, $note) {

        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        // $prepare_password_for_verify=$this->encrypt($password_for_verify);

        $lat_encr = $this->encrypt($lat);
        $lng_encr = $this->encrypt($lng);
        $descr_logout_encrypt = $this->encrypt($note);
        $ip_encrypt = $this->encrypt($this->client_ip);

        //echo $prepare_password_for_verify;
        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'stopTime',
                'client_info' => $this->client_info,
                // 'password_for_verify'=>$prepare_password_for_verify,
                'token' => $token,
                'lat_end' => $lat_encr,
                'lng_end' => $lng_encr,
                'description_logout' => $descr_logout_encrypt,
                'client_ip' => $ip_encrypt
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    public function getLayoutTaskSelectTEST($token_input, $mode, $dev_n_tools_only = null) {
        echo 'getLayoutTaskSelectTEST';
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        
        $token = $this->encrypt($token_input);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'getLayoutTaskSelect',
                'client_info' => $this->client_info,
               
                'token' => $token,
                'mode' => $mode,
                'dev_n_tools_only' => $dev_n_tools_only
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    public function getLayoutSpecificTaskAPISelectTEST($password_for_verify, $user_id, $lang) {
        echo 'getLayoutSpecificTaskAPISelectTEST';
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_password_for_verify = $this->encrypt($password_for_verify);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'getLayoutSpecificTaskAPISelect',
                'client_info' => $this->client_info,
                'password_for_verify' => $prepare_password_for_verify,
                'user_id' => $user_id,
                'lang' => $lang,
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    public function getUserModeTEST($user_id) {

        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);


        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'getUserMode',
                'client_info' => $this->client_info,
                'user_id' => $user_id,
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    public function startCOTaskAPITEST($user_id, $lang, $password_for_verify, $task_id, $hours, $unit, $item, $mode, $lat, $lng) {

        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_password_for_verify = $this->encrypt($password_for_verify);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'startCOTaskAPI',
                'client_info' => $this->client_info,
                'user_id' => $user_id,
                'lang' => $lang,
                'password_for_verify' => $prepare_password_for_verify,
                'task_id' => $task_id,
                'hours' => $hours,
                'unit' => $unit,
                'item' => $item,
                'mode' => $mode,
                'lat' => $lat,
                'lng' => $lng
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    public function saveStateTEST($lang, $password_for_verify, $task_id, $hours, $unit, $item, $user_id) {
        //echo  $_SERVER['HTTPS'];
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_password_for_verify = $this->encrypt($password_for_verify);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'saveState',
                'client_info' => $this->client_info,
                'lang' => $lang,
                'password_for_verify' => $prepare_password_for_verify,
                'task_id' => $task_id,
                'hours' => $hours,
                'unit' => $unit,
                'item' => $item,
                'user_id' => $user_id
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    public function saveSessionImagesTEST($token, $date, $files) {
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($token);

        /* if(empty($files['file_start'])){
          $files['file_start']['path']='';
          $files['file_start']['filename']='';
          } */

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'saveSessionImages',
                'client_info' => $this->client_info,
                'user_token' => $prepare_user_token,
                'session_date' => $date,
                //'file_start'=>'',//if empty
                'file_start' => new CURLFile($files['file_start']['path'], mime_content_type($files['file_start']['path']), $files['file_start']['filename']),
                'file_stop'=>new CURLFile($files['file_stop']['path'], mime_content_type($files['file_stop']['path']), $files['file_stop']['filename'])
                //'file_stop' => '', //if empty
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * Get user status.
     *
     * @param  string  $user_token
     * @return std object
     */
    public function checkOnlineTest($user_token) {
        // echo 'dd';
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($user_token);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'checkOnline',
                'client_info' => $this->client_info,
                'user_token' => $prepare_user_token,
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * Get pay period style 4 https://frost.curiotime.com/pp-api.
     *
     * @param  array  $config[
     *  'user_token'=>@string,
      'from'=>@string,
      'to'=>@string,
      'lang'=>@string
     * ]
     * @return std object
     */
    public function getPayPeriod4Test($config) {
        echo 'getPayPeriod4';
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'getPayPeriod4',
                'client_info' => $this->client_info,
                'user_token' => $prepare_user_token,
                'from' => $config['from'],
                'to' => $config['to'],
                'lang' => $config['lang']
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * Get pay period one date, see this layout in app 
     * https://gyazo.com/432833b0a5fca2d47dd57683c8490037. Is exist two mode ['global_totals']:
     * http://prntscr.com/pdwmnd - in standart companies and this:
     * http://prntscr.com/pdwnas - in special companies.
     * Add array item with company name in here /components/com_audit/controller.php getSpecialCompanies()
     * if need enable special mode for company.
     *
     * @param  array  $config[
     *  'user_token'=>@string,
      'date'=>@string,
      'row_id'=>@integer,
      'lang'=>@string
     * ]
     * @return std object
     */
    public function getOneDatePP4Test($config) {
        echo 'getOneDatePP4';
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'getOneDatePP4',
                'client_info' => $this->client_info,
                'user_token' => $prepare_user_token,
                'date' => $config['date'],
                'lang' => $config['lang'],
                'row_id' => $config['row_id']
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * Get pay period one date, see this layout in app 
     * https://gyazo.com/432833b0a5fca2d47dd57683c8490037. Is exist two mode ['global_totals']:
     * http://prntscr.com/rj37uv - in standart companies and this:
     * http://prntscr.com/rj3893 - in special companies.
     * Add array item with company name in here /components/com_audit/controller.php getSpecialCompanies()
     * if need enable special mode for company.
     *
     * @param  array  $config[
     *  'user_token'=>@string,
      'date'=>@string,
      'row_id'=>@integer,
      'lang'=>@string
     * ] 
     * @return std object
     */
    public function getOneDateWithTextPP4Test($config) {
        echo 'getOneDateWithTextPP4';
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'getOneDateWithTextPP4',
                'client_info' => $this->client_info,
                'user_token' => $prepare_user_token,
                'date' => $config['date'],
                'lang' => $config['lang'],
                'row_id' => $config['row_id']
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * Set hours in pay period date, see this layout in app 
     * https://gyazo.com/432833b0a5fca2d47dd57683c8490037. If row_id is empty, system add 
     * new record in db. In cell_name exist next fields:
     * total, daytime, afterwork, night_time, weekend, holidays.
     *
     * @param  array  $config[
     *  'user_token'=>@string,
      'date'=>@string,
      'row_id'=>@integer/empty @string,
      'lang'=>@string,
      'cell_name'=>@string,
      'new_value'=>@string,
      'client_ip'=>@string
     * ]
     * @return std object
     */
    public function setOneDatePP4Test($config) {
        echo 'setOneDatePP4Test';
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'setOneDatePP4',
                'client_info' => $this->client_info,
                'user_token' => $prepare_user_token,
                'date' => $config['date'],
                'lang' => $config['lang'],
                'row_id' => $config['row_id'],
                'cell_name' => $config['cell_name'],
                'new_value' => $config['new_value'],
                'client_ip' => $config['client_ip']
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * Set hours in pay period date, see this layout in app 
     * https://gyazo.com/432833b0a5fca2d47dd57683c8490037. If row_id is empty, system add 
     * new record in db. In post exist next fields:
     * total, daytime, afterwork, night_time, weekend, holidays.
     *
     * @param  array  $config[
     *  'user_token'=>@string,
      'date'=>@string,
      'row_id'=>@integer/empty @string,
      'lang'=>@string,
      'post'=>@array,
      'client_ip'=>@string
     * ]
     * @return std object
     */
    public function setOneDatePP4_2Test($config) {
        echo 'setOneDatePP4_2Test';
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);


        $post = [
            'passw' => $prepare_passw_auth,
            'action' => 'setOneDatePP4_2',
            'client_info' => $this->client_info,
            'user_token' => $prepare_user_token,
            'date' => $config['date'],
            'lang' => $config['lang'],
            'row_id' => $config['row_id'],
            'post' => $config['post'],
            'client_ip' => $config['client_ip']
        ];
        $post = http_build_query($post);
        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post,
        ];




        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        $err = curl_error($curl);
        /* var_dump($this->ultima_api_path);
          var_dump($err);
          var_dump($out) ; */

        /* echo "<hr>";
          echo "<pre>";
          var_dump(json_decode($out)) ;
          exit; */
        curl_close($curl);

        return json_decode($out);
    }

    /**
     *  Generate and send pdf http://prntscr.com/peer24 .
     *  Enable emailing before test https://prnt.sc/peesst !
     * 
     * @param  @array $config[
     *  'user_token'=>@string,
      'from'=>@string,
      'to'=>@string,
      'lang'=>@string,
     * ]
     * @return std object
     */
    public function sendPdfTest($config) {
        echo 'sendPdfTest';
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'sendPdf',
                'client_info' => $this->client_info,
                'user_token' => $prepare_user_token,
                'from' => $config['from'],
                'to' => $config['to'],
                'lang' => $config['lang']
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * Add new holiday to https://frost.curiotime.com/new-holidays2 .
     * If from/to overlapping with existing period, returning error 
     * 'Dates overlap an existing period!'.
     *
     * @param  @array $config[
     *  'user_token'=>@string,
      'from'=>@string,
      'to'=>@string,
     * 'lang'=>@string
     * ]
     * @return std object
     */
    public function setHolidayTest($config) {
        echo 'setHolidayTest';
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'setHoliday',
                'client_info' => $this->client_info,
                'user_token' => $prepare_user_token,
                'from' => $config['from'],
                'to' => $config['to'],
                'lang' => $config['lang']
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * Get holiday object by id and token.
     * Response http://prntscr.com/phaqws .
     * status='Confirmed' or 'Pending'.
     *   
     * array['fields']              array Defines the fields to be shown by scaffolding.
     *              ['user_token']        string user_token
     *              ['id']                int  user id
     * @param array $config (See above)
     * @return Object std.
     */
    public function getHolidaysTest($config) {
        echo 'getHolidaysTest';
        //echo $this->ultima_api_path;
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'getHolidays',
                'client_info' => $this->client_info,
                'user_token' => $prepare_user_token,
                'id' => $config['id'],
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }
    
   /**
        * Get holiday object by id and token.
        * Response http://prntscr.com/phaqws .
        * status='Confirmed' or 'Pending'.
        *   
        * array['fields']              array Defines the fields to be shown by scaffolding.
        *              ['user_token']        string user_token
        *              ['id']                int  user id
        * @param array $config (See above)
        * @return Object std.
    */
    public function getHolidayTest($config) {
        echo 'getHolidayTest';
        //echo $this->ultima_api_path;
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'getHoliday',
                'client_info' => $this->client_info,
                'user_token' => $prepare_user_token,
                'id' => $config['id'],
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * Get shuffle array quotes.
     * @param  string  $user_token
     * @return Object std.
     */
    public function getQuotesTest($user_token) {
        echo 'getQuotesTest';
        //echo $this->ultima_api_path;
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($user_token);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'getQuotes',
                'client_info' => $this->client_info,
                'user_token' => $prepare_user_token,
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * Get shuffle array quotes.
     *   
     * array['fields']              array Defines the fields to be shown by scaffolding.
     *              ['user_token']        string user_token
     *              ['lang']                string lang . must be en/is value
     * @param array $config (See above)
     * @return Object std.
     */
    public function getQuotesWithLangTest($config) {
        echo 'getQuotesWithLangTest';

        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $post = http_build_query(
                [
                    'passw' => $prepare_passw_auth,
                    'action' => 'getQuotesWithLang',
                    'client_info' => $this->client_info,
                    'user_token' => $prepare_user_token,
                    'lang' => $config['lang']
                ]
        );

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post,
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * Set/unset attached users to task in this page https://prnt.sc/po3e8f.
     * Response https://prnt.sc/po3ch5 or throw new Exception in message object if error.
     *   
     * array['fields']                    array Defines the fields to be shown by scaffolding.
     *              ['user_token']        string user_token
     *              ['task_id']           int task
     *              array['attached_users_ids'] array users ids
     *              ['mode']              string add/remove(attach or delete)
     * @param array $config (See above)
     * @return Object std.
     */
    public function attachUsersToTaskTest($config) {
        echo 'attachUsersToTaskTest';
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $post = [
            'passw' => $prepare_passw_auth,
            'action' => 'attachUsersToTask',
            'client_info' => $this->client_info,
            'user_token' => $prepare_user_token,
            'task_id' => $config['task_id'],
            'attached_users_ids' => $config['attached_users_ids'],
            'mode' => $config['mode']
        ];
        $post = http_build_query($post);
        /* echo '<pre>';
          print_r($post);
          echo '</pre>'; */

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * Get from to dates https://prnt.sc/q71q92.
     * Response https://prnt.sc/q71qr2 .
     *   
     * array['fields']                    array Defines the fields to be shown by scaffolding.
     *              ['user_token']        string user_token
     *             
     * @param array $config (See above)
     * @return Object std.
     */
    public function getFromToTest($config) {
        echo 'getFromToTest';
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $post = [
            'passw' => $prepare_passw_auth,
            'action' => 'getFromTo',
            'client_info' => $this->client_info,
            'user_token' => $prepare_user_token,
        ];
        $post = http_build_query($post);
        /* echo '<pre>';
          print_r($post);
          echo '</pre>'; */

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * Get timesheet headers.
     * Response http://prntscr.com/r15icg .
     *   
     * array['fields']                    array Defines the fields to be shown by scaffolding.
     *              ['user_token']        string user_token
     *             ['lang']               string lang(en/is)
     *             
     * @param array $config (See above)
     * @return Object std.
     */
    public function getTimesheetHeadersTest($config) {
        echo 'getTimesheetHeadersTest';
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $post = [
            'passw' => $prepare_passw_auth,
            'action' => 'getTimesheetHeaders',
            'client_info' => $this->client_info,
            'user_token' => $prepare_user_token,
            'lang' => $config['lang']
        ];
        $post = http_build_query($post);
        /* echo '<pre>';
          print_r($post);
          echo '</pre>'; */

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * Get pay period style 4 https://frost.curiotime.com/pp-api with texts.
     *
     * @param  array  $config[
     *  'user_token'=>@string,
      'from'=>@string,
      'to'=>@string,
      'lang'=>@string
     * ]
     * @return std object
     */
    public function getPayPeriod4WithTextsTest($config) {
        echo 'getPayPeriod4WithTexts';
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'getPayPeriod4WithTexts',
                'client_info' => $this->client_info,
                'user_token' => $prepare_user_token,
                'from' => $config['from'],
                'to' => $config['to'],
                'lang' => $config['lang']
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * Get holiday object by id and token.
     * Response http://prntscr.com/ssbyci.
     * status='Confirmed' or 'Pending'.
     *   
     * array['fields']              array Defines the fields to be shown by scaffolding.
     *              ['user_token']        string user_token
     *             
     * @param array $config (See above)
     * @return Object std.
     */
    public function getUserHolidaysRequestsTest($config) {
        echo 'getUserHolidaysRequests';
        //echo $this->ultima_api_path;
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'getUserHolidaysRequests',
                'client_info' => $this->client_info,
                'user_token' => $prepare_user_token,
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * Get available modules in user company.
     * Response http://prntscr.com/sstwo5.
     *   
     * array['fields']              array Defines the fields to be shown by scaffolding.
     *              ['user_token']        string user_token
     *             
     * @param array $config (See above)
     * @return Object std.
     */
    public function getAvailableMudulesTest($config) {
        echo 'getAvailableMudules';
        //echo $this->ultima_api_path;
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'getAvailableMudules',
                'client_info' => $this->client_info,
                'user_token' => $prepare_user_token,
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * Get link for calc.
     * Response http://prntscr.com/tfe9t4 or http://prntscr.com/tfea74
     *   
     * array['fields']              array Defines the fields to be shown by scaffolding.
     *              ['user_token']        string user_token
     *             
     * @param array $config (See above)
     * @return Object std.
     */
    public function getCalcLinkTest($config) {
        echo 'getCalcLink';
        //echo $this->ultima_api_path;
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'getCalcLink',
                'client_info' => $this->client_info,
                'user_token' => $prepare_user_token,
                'lang' => $config['lang']
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * Get user shifts requests by token.
     * Response http://prntscr.com/128mg5x.
     *   
     * array['fields']              array Defines the fields to be shown by scaffolding.
     *              ['user_token']        string user_token
     *              ['from']        string from
     *              ['to']        string to
     * @param array $config (See above)
     * @return Object std.
     */
    public function getUserShiftsTest($config) {
        echo 'getUserShiftsTest';
        //echo $this->ultima_api_path;
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'getUserShifts',
                'client_info' => $this->client_info,
                'user_token' => $prepare_user_token,
                'from' => $config['from'],
                'to' => $config['to']
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        //return $out;
        return json_decode($out, true);
    }

    /**
     * Set user schedule requests to shift page
     * Response if error(if status=0, see message) http://prntscr.com/unmhx8.
     * Response if shift added successfully http://prntscr.com/unminf . 
     * .
     *   
     * array['fields']              array Defines the fields to be shown by scaffolding.
     *              ['user_token']        string user_token
     *              ['from']        string from (d.m.Y H:i) format
     *              ['to']        string to (d.m.Y H:i) format
     *              ['lang']        string lang
     *             
     *             
     *              ['status']        string status (if you write 'pending_available' here then 'from' and 'to' has been ignored, but 'date' and 'message' are on). 
     * 				If you write 'pending_work' here then ct system search shift as from and to or create new shift if he is not existing and is not overlapping with others shifts and then created orange (!) icon in shift. Use  'icon_date' field and 'message' if you set 'pending_work' in 'status'. 
     * 				These icons will gouing to getUserShifts() methond in 'icons_date'
     *              ['date']        string date(d.m.Y) format. Worked if 'status' is 'pending_available'
     *              ['message']     string message . Worked if 'status' is 'pending_available'/'pending_work'
     *              ['icon_date']   string icon_date . Worked if 'status' == 'pending_work'. Sets orange (!) icon on shift. Format is 'd.m.Y'
     * 
     * @param array $config (See above)
     * @return Object std.
     */
    public function setShiftTest($config) {
        echo 'setShiftTest';
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);


        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'setShift',
                'client_info' => $this->client_info,
                'user_token' => $prepare_user_token,
                'from' => $config['from'],
                'to' => $config['to'],
                'lang' => $config['lang'],
                'shift_color' => $config['shift_color'],
                'shift_name' => $config['shift_name'],
                'status' => $config['status'],
                'date' => $config['date'],
                'message' => $config['message'],
                'icon_date' => isset($config['icon_date']) ? $config['icon_date'] : ""
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * Get one shift object by id and token.
     * Response http://prntscr.com/unpi0z .
     * status='Confirmed' or 'Pending'.
     *   
     * array['fields']              array Defines the fields to be shown by scaffolding.
     *              ['user_token']        string user_token
     *              ['id']                int user id
     * @param array $config (See above)
     * @return Object std.
     */
    public function getShiftTest($config) {
        echo 'getShift';
        //echo $this->ultima_api_path;
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'getShift',
                'client_info' => $this->client_info,
                'user_token' => $prepare_user_token,
                'id' => $config['id'],
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * Set user shift requests to shift page https://newdev.curiotime.com/shifts.
     * Response if error(if status=0, see message) http://prntscr.com/unmhx8.
     * Response if shift added successfully http://prntscr.com/unminf . 
     * .
     *   
     * array['fields']              array Defines the fields to be shown by scaffolding.
     *              ['user_token']        string user_token
     *              ['from']        string from (d.m.Y H:i) format
     *              ['to']        string to (d.m.Y H:i) format
     *              ['lang']        string lang
     *              ['shift_color']        string shift_color (css hex format, permitted colors is next: '#009cdd', '#8bc2ae', '#ffed3b', '#77c0d2', '#d3277c', '#9b9b9a', '#ac2c3c')
     *              ['shift_name']        string shift_name
     *              ['status']        string status (if you write 'pending_available' here then 'from' and 'to' has been ignored, but 'date' and 'message' are on)
     *              ['date']        string date(d.m.Y) format. Worked if 'status' is 'pending_available'
     *              ['message']        string message . Worked if 'status' is 'pending_available'
     * 
     * @param array $config (See above)
     * @return Object std.
     */
    public function setShiftMessageTest($config) {
        echo 'setShiftMessageTest';
        $curl = curl_init();

        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);
        $prepare_date = $this->encrypt($config['date']);
        $prepare_lang = $this->encrypt($config['lang']);
        $prepare_type = $this->encrypt($config['type']);
        $prepare_message = $this->encrypt($config['message']);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'setShiftMessage',
                'client_info' => $this->client_info,
                'user_token' => $prepare_user_token,
                'date' => $prepare_date,
                'lang' => $prepare_lang,
                'type' => $prepare_type,
                'message' => $prepare_message
            ],
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * The method gets all unread messages.
     * Response http://prntscr.com/vjwjn8 .
     *   
     * array['fields']              array Defines the fields to be shown by scaffolding.
     *              ['user_token']        string user_token
     * @param array $config (See above)
     * @return Object std.
     */
    public function getMessagesTest($config) {
        echo 'getMessages';
        //echo $this->ultima_api_path;
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => [
                'passw' => $prepare_passw_auth,
                'action' => 'getMessages',
                'client_info' => $this->client_info,
                'user_token' => $prepare_user_token
            ]
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * The method marks the message array as read
     * Response http://prntscr.com/vjxwys .
     *   
     * array['fields']              array Defines the fields to be shown by scaffolding.
     *              ['user_token']        string user_token
     *              ['marked_messages_arr'] array marked_messages_arr
     * @param array $config (See above)
     * @return Object std.
     */
    public function markMessagesAsReadTest($config) {
        echo 'markMessagesAsRead';
        //echo $this->ultima_api_path;
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);
        //$prepare_marked_messages_arr = $this->encrypt($config['marked_messages_arr']);

        $post = http_build_query([
            'passw' => $prepare_passw_auth,
            'action' => 'markMessagesAsRead',
            'client_info' => $this->client_info,
            'user_token' => $prepare_user_token,
            'marked_messages_arr' => $config['marked_messages_arr']
        ]);

        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * The method performs user registration. 
     * The answer, if successful, would be http://prntscr.com/w3smbd .
     * The answer, if error, would be http://prntscr.com/w3snf1 .
     *   
     * array['fields']              array Defines the fields to be shown by scaffolding.
     *              ['company']        string company
     *              ['manager_name'] string manager_name
     *              ['manager_id'] string manager_id
     *              ['password'] string password
     *              ['email'] string email
     *              ['user_limit'] string user_limit
     *              ['phone'] string phone
     *              ['from'] string from
     *              ['to'] string to
     *              ['timezone'] string timezone
     * 
     * @param array $config (See above)
     * @return Object std.
     */
    public function registration3rdTest($config) {
        echo 'registration3rd';
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);

        $post = http_build_query([
            'passw' => $prepare_passw_auth,
            'action' => 'registration3rd',
            'client_info' => $this->client_info,
            'company' => $config['company'],
            'manager_name' => $config['manager_name'],
            'manager_id' => $config['manager_id'],
            'password' => $config['password'],
            'email' => $config['email'],
            'user_limit' => $config['user_limit'],
            'phone' => $config['phone'],
            'from' => $config['from'],
            'to' => $config['to'],
            'timezone' => $config['timezone'],
            'lang' => $config['lang']
        ]);


        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * The method gets the schedules of the company's users included on the specified date 
     * using the user's token from the current company.
     * Response http://prntscr.com/12mavrp.
     *   
     * array['fields']              array Defines the fields to be shown by scaffolding.
     *              ['user_token']        string user_token
     *              ['date']        string date with format of date dd.mm.YYYY
     * @param array $config (See above)
     * @return Object std.
     */
    public function getCompanySchedulesAsDateTest($config) {
        echo 'getCompanySchedulesAsDateTest';
        //echo $this->ultima_api_path;
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $post = http_build_query([
            'passw' => $prepare_passw_auth,
            'action' => 'getCompanySchedulesAsDate',
            'client_info' => $this->client_info,
            'user_token' => $prepare_user_token,
            'date' => $config['date']
        ]);
        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post,
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
        //return $out;
    }

    /**
     * The method is check disabled notifications status for schedules in user company.
     * Response http://prntscr.com/13c49d6.
     *   
     * array['fields']              array Defines the fields to be shown by scaffolding.
     *              ['user_token']        string user_token
     * @param array $config (See above)
     * @return Object std.
     */
    public function isNotificationDisabledOnUserCompany($config) {
        echo 'isNotificationDisabledOnUserCompany';
        //echo $this->ultima_api_path;
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $post = http_build_query([
            'passw' => $prepare_passw_auth,
            'action' => 'isNotificationDisabledOnUserCompany',
            'client_info' => $this->client_info,
            'user_token' => $prepare_user_token,
        ]);
        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post,
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * The method will add the user's message on the specified date, regardless of whether there is a change of user or not.
     * Response https://screenrec.com/share/HsrR3vXClG.
     * Please, checking 'status'. This must be equal 1 otherwise see the message field in response.
     *   
     * array['fields']              array Defines the fields to be shown by scaffolding.
     *              ['user_token']        string user_token
     *              ['date']        string date in format dd.mm.YYYY
     *              ['message']        string message
     * @param array $config (See above)
     * @return Object std.
     */
    public function addScheduleMessageTest($config) {
        echo 'addScheduleMessage';
        //echo $this->ultima_api_path;
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $post = http_build_query([
            'passw' => $prepare_passw_auth,
            'action' => 'addScheduleMessage',
            'client_info' => $this->client_info,
            'user_token' => $prepare_user_token,
            'date' => $config['date'],
            'message' => $config['message']
        ]);
        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post,
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
        //return $out;
    }

    /**
     * The method will add device id for firebase to user
     * Response https://screenrec.com/share/87sQnq3VNk.
     * Please, checking 'status'. This must be equal 1 otherwise see the message field in response.
     *   
     * array['fields']              array Defines the fields to be shown by scaffolding.
     *              ['user_token']        string user_token
     *              ['device_id']        string device_id
     *              ['enable_push_for_this_device']  int enable_push_for_this_device
     * @param array $config (See above)
     * @return Object std.
     */
    public function setDeviceIdTest($config) {
        echo 'setDeviceIdTest';
        //echo $this->ultima_api_path;
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $post = http_build_query([
            'passw' => $prepare_passw_auth,
            'action' => 'setDeviceId',
            'client_info' => $this->client_info,
            'user_token' => $prepare_user_token,
            'device_id' => $config['device_id'],
            'enable_push_for_this_device' => $config['enable_push_for_this_device']
        ]);
        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post,
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
        //return $out;
    }

    /**
     * The method will delete device id in user
     * Response https://screenrec.com/share/0lYgin9vzL .
     * Please, checking 'status'. This must be equal 1 otherwise see the message field in response.
     *   
     * array['fields']              array Defines the fields to be shown by scaffolding.
     *              ['user_token']        string user_token
     *              ['device_id']        string device_id
     * @param array $config (See above)
     * @return Object std.
     */
    public function removeDeviceIdTest(array $config) {
        echo 'removeDeviceIdTest';
        //echo $this->ultima_api_path;
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $post = http_build_query([
            'passw' => $prepare_passw_auth,
            'action' => 'removeDeviceId',
            'client_info' => $this->client_info,
            'user_token' => $prepare_user_token,
            'device_id' => $config['device_id'],
        ]);
        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post,
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
        //return $out;
    }

    /**
     * The method get available schedules as selected date
     * Response https://screenrec.com/share/Tfj2Xna5ki .
     * Please, checking 'status'. This must be equal 1 otherwise see the message field in response.
     *   
     * array['fields']              array Defines the fields to be shown by scaffolding.
     *              ['user_token']        string user_token
     *              ['date']        string date
     * @param array $config (See above)
     * @return Object std.
     */
    public function getAvailableSchedulesAsDateTest($config) {
        echo 'getAvailableSchedulesAsDateTest';
        //echo $this->ultima_api_path;
        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $post = http_build_query([
            'passw' => $prepare_passw_auth,
            'action' => 'getAvailableSchedulesAsDate',
            'client_info' => $this->client_info,
            'user_token' => $prepare_user_token,
            'date' => $config['date'],
        ]);
        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post,
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    /**
     * The method get salary calculation link
     * Response https://screenrec.com/share/YS1PZjs842 .
     * Please, checking 'status'. This must be equal 1 otherwise see the message field in response.
     *   
     * array['fields']              array Defines the fields to be shown by scaffolding.
     *              ['user_token']        string user_token
     *              ['lang']        string lang
     * @param array $config (See above)
     * @return Object std.
     */
    public function getCalcWidgetLinkTest(array $config) {
        echo 'getCalcWidgetLink';

        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepare_user_token = $this->encrypt($config['user_token']);

        $post = http_build_query([
            'passw' => $prepare_passw_auth,
            'action' => 'getCalcWidgetLink',
            'client_info' => $this->client_info,
            'user_token' => $prepare_user_token,
            'lang' => $config['lang']
        ]);
        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }
    
    /**
        * Add route point/points to existing route.
        * Response https://screenrec.com/share/bEMVkDO0W6 .
        *   
        * array['fields']              array Defines the fields to be shown by scaffolding.
        *              ['user_token']        string user_token
        *              ['points']        array points
        *              ['route_id']        int route_id
        *              ['lang']        string lang
        *             
        * @param array $config (See above)
        * @return Object std.
    */
    public function setRoutePointTest(array $config) {
        echo 'setRoutePoint';

        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepared_user_token = $this->encrypt($config['user_token']);
        $prepared_points = $config['points'];
        $prepared_route_id = $this->encrypt($config['route_id']);
        $prepared_lang = $this->encrypt($config['lang']);
        
        $post = http_build_query([
            'passw' => $prepare_passw_auth,
            'action' => 'setRoutePoint',
            'client_info' => $this->client_info,
            
            'user_token' => $prepared_user_token,
            'points' => $prepared_points,
            'route_id' => $prepared_route_id,
            'lang' => $prepared_lang
        ]);
        
        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }
    
     /**
        * Add route point/points to existing route.
        * Response https://screenrec.com/share/oEaudjcZlI .
        *   
        * array['fields']              array Defines the fields to be shown by scaffolding.
        *              ['user_token']  string user_token
        *              ['date']        string or null date
        *              ['lang']        string lang
        *             
        * @param array $config (See above)
        * @return Object std.
    */
    public function getRoutesTest(array $config) {
        echo 'getRoutes';

        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepared_user_token = $this->encrypt($config['user_token']);
        $prepared_date = $this->encrypt($config['date']);
        $prepared_lang = $this->encrypt($config['lang']);
        
        $post = http_build_query([
            'passw' => $prepare_passw_auth,
            'action' => 'getRoutes',
            'client_info' => $this->client_info,
            
            'user_token' => $prepared_user_token,
            'date' => $prepared_date,
            'lang' => $prepared_lang
        ]);
        
        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }
    
    /**
        * Add/edit route.
        * Response if ok https://screenrec.com/share/UAQf9Ykhjz .
        *   
        * array['fields']              array Defines the fields to be shown by scaffolding.
        *              ['user_token']  string user_token
        *              ['route_id']    int | null route_id
        *              ['date']        string date
        *              ['clock_in']    string clock_in
        *              ['clock_out']   string clock_out
        *              ['total']       string total
        *              ['task_manager'] string task_manager
        *              ['from']        string from
        *              ['to']        string to
        *              ['from_coordinates']        json from_coordinates
        *              ['to_coordinates']       json to_coordinates
        *              ['message']        string message
        *              ['lang']        string lang
        *             
        * @param array $config (See above)
        * @return Object std.
    */
    public function setRouteTest(array $config) {
        echo 'setRoute';

        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepared_user_token = $this->encrypt($config['user_token']);
        $prepared_route_id = $this->encrypt($config['route_id']);
        $prepared_lang = $this->encrypt($config['lang']);
        $prepared_date = $this->encrypt($config['date']);
        $prepared_clock_in = $this->encrypt($config['clock_in']);
        $prepared_clock_out = $this->encrypt($config['clock_out']);
        $prepared_total = $this->encrypt($config['total']);
        $prepared_task_manager = $this->encrypt($config['task_manager']);
        $prepared_from = $this->encrypt($config['from']);
        $prepared_to = $this->encrypt($config['to']);
        $prepared_message = $this->encrypt($config['message']);
       
        $post = http_build_query([
            'passw' => $prepare_passw_auth,
            'action' => 'setRoute',
            'client_info' => $this->client_info,
            
            'user_token' => $prepared_user_token,
            'route_id' => $prepared_route_id,
            'date' => $prepared_date,
            'clock_in' => $prepared_clock_in,
            'clock_out' => $prepared_clock_out,
            'total' => $prepared_total,
            'task_manager' => $prepared_task_manager,
            'from' => $prepared_from,
            'to' => $prepared_to,
            'from_coordinates' => $config['from_coordinates'],//json
            'to_coordinates' => $config['to_coordinates'],//json
            'message' => $prepared_message,
            'custom' => $config['custom'],
            'lang' => $prepared_lang
        ]);
        
        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }
    
    public function startRouteTest(array $config) {
        echo 'startRoute';

        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepared_user_token = $this->encrypt($config['user_token']);
        $prepared_route_id = $this->encrypt($config['route_id']);
        $prepared_lang = $this->encrypt($config['lang']);
        $prepared_lat = $this->encrypt($config['lat']);
        $prepared_lng = $this->encrypt($config['lng']);
        $prepared_message = $this->encrypt($config['message']);
        $prepared_row_hash = $this->encrypt($config['row_hash']);
        $prepared_is_pressed_big_green_button = $this->encrypt($config['is_pressed_big_green_button']);
        $prepared_ignore_empty_task = $this->encrypt($config['ignore_empty_task']);
        $ip_encrypt = $this->encrypt($this->client_ip);
        
        $post = http_build_query([
            'passw' => $prepare_passw_auth,
            'action' => 'startRoute', 
            'client_info' => $this->client_info,
            
            'user_token' => $prepared_user_token,
            'route_id' => $prepared_route_id,
            'message' => $prepared_message,
            'row_hash' => $prepared_row_hash,
            'is_pressed_big_green_button' => $prepared_is_pressed_big_green_button,
            'ignore_empty_task' => $prepared_ignore_empty_task,
            'lang' => $prepared_lang,
            'lat' => $prepared_lat,
            'lng' => $prepared_lng,
            'client_ip' => $ip_encrypt 
        ]);
        
        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }
    
    public function stopRouteTest(array $config) {
        echo 'stopRoute';

        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepared_user_token = $this->encrypt($config['user_token']);
        $prepared_route_id = $this->encrypt($config['route_id']);
        $prepared_lang = $this->encrypt($config['lang']);
        $prepared_lat = $this->encrypt($config['lat']);
        $prepared_lng = $this->encrypt($config['lng']);
        $prepared_message = $this->encrypt($config['message']);
        $ip_encrypt = $this->encrypt($this->client_ip);

        $post = http_build_query([
            'passw' => $prepare_passw_auth,
            'action' => 'stopRoute',
            'client_info' => $this->client_info,
            
            'user_token' => $prepared_user_token,
            'route_id' => $prepared_route_id,
            'message' => $prepared_message,
            'row_hash' => $prepared_row_hash,
            'lang' => $prepared_lang,
            'lat' => $prepared_lat,
            'lng' => $prepared_lng,
            'client_ip' => $ip_encrypt
        ]);
        
        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }
    
    public function getAutoCollectTextsTest(array $config) {
         echo 'getAutoCollectTexts';

        $curl = curl_init();
        $prepare_passw_auth = $this->preparePassw($this->password_current_api);
        $prepared_user_token = $this->encrypt($config['user_token']);
        $prepared_date = $this->encrypt($config['date']);
        $prepared_lang = $this->encrypt($config['lang']);
        
        $post = http_build_query([
            'passw' => $prepare_passw_auth,
            'action' => 'getAutoCollectTexts',
            'client_info' => $this->client_info,
            
            'user_token' => $prepared_user_token,
            'lang' => $prepared_lang
        ]);
        
        $options = [
            CURLOPT_URL => $this->ultima_api_path,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);

        curl_close($curl);

        return json_decode($out);
    }

    private function encrypt($plaintext) {
       /* if(is_array($plaintext)){
            $plaintext = json_encode($plaintext);
        }*/
        $ivlen = openssl_cipher_iv_length($cipher = "AES-128-CBC");
        $iv = openssl_random_pseudo_bytes($ivlen);
        $ciphertext_raw = openssl_encrypt($plaintext, $cipher, ENCRYPTION_KEY, $options = OPENSSL_RAW_DATA, $iv);
        $hmac = hash_hmac('sha256', $ciphertext_raw, ENCRYPTION_KEY, $as_binary = true);
        $ciphertext = base64_encode($iv . $hmac . $ciphertext_raw);
        return $ciphertext;
    }

}
