<?php
set_time_limit(0);

define( '_JEXEC', 1 );

define('JPATH_BASE', $_SERVER['DOCUMENT_ROOT']);


define('DS', '/');
require_once( JPATH_BASE .DS.'includes'.DS.'defines.php' );

require_once( JPATH_BASE .DS.'includes'.DS.'framework.php' );

jimport('joomla.application.component.controller');
$mainframe =& JFactory::getApplication('site');
$session =& JFactory::getSession();


class api {
    public function __construct($db) {
        $this->db=$db;
        $this->checkPermissionSync();
        
        $this->server_name = $_SERVER['SERVER_NAME'];
        $this->site_fullname = 'https://' . $this->server_name;
    }

    public function auth($password_original_hash, $password_request)
    {
        $to1 = 'developer3452@gmail.com';
        $subject = 'API ultima';

        $headers = "From: info@curiotime.com\r\n";

        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
        $message = '<pre>'.password_verify($password_original_hash, $password_request).'</pre>';
        //mail($to1, $subject, $message, $headers);

        return password_verify($password_original_hash, $password_request);
    }

    /*
     *  deprecated.not used
     */
    public function getAllUsers($action)
    {
        $to1 = 'developer3452@gmail.com';
        $subject = 'API ultima';

        $headers = "From: info@curiotime.com\r\n";

        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=UTF-8\r\n";



        $query='SELECT `id`, `username0`, `password2`, `name`, `email`, `tel`, `company`, `username`, `api_token` FROM #__users ORDER BY `id` ASC';
        $this->db->setQuery( $query );
        $items = $this->db->loadObjectList();



        foreach($items as $one_user){
            $one_user->group_custom=$this->getUserGroup($one_user->id);
        }
        $message = '<pre>'.print_r($items, true).'</pre>';
        //mail($to1, $subject, $message, $headers);


        return $items;
    }

    public function getUserGroup($user_id)
    {
        $user   = JFactory::getUser((int)$user_id);
        $groups = JAccess::getGroupsByUser($user->id);

        if(in_array(2, $groups) && !in_array(9, $groups)){
            $group='user_standart';
        } elseif(in_array(6, $groups)){
            $group='manager';
        } elseif(in_array(8, $groups)){
            $group='admin';
        } elseif(in_array(9, $groups)){
            $group='user_mm';
        } else{
            $group='undefined';
        }
        return $group;
    }

    public function checkPermissionSync()
    {
        $config = JFactory::getConfig();
        $status = $config->get('sync');
        //file_put_contents($_SERVER['DOCUMENT_ROOT'].'/logs/sync.html', print_r($status.'<br/>', true), FILE_APPEND | LOCK_EX);

        if($status==='0'){
            exit(json_encode('Curiotime turned off sync'));
        }
    }
    
    public function preparePassw($passw)
    {
        return password_hash($passw, PASSWORD_BCRYPT);
    }
    
    public function addLogRow($action, $type, $auth_res, $response)
    {
        switch($type){
            case 'global':
                $item=new stdClass();
                $item->id=null;
                $item->ip=$_SERVER['REMOTE_ADDR'];  
                $device=$this->getDevice();
                $item->device=$device;
                $item->user_agent=$this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date=date('d.m.Y H:i:s');
                $item->timestamp=time();
                $item->action=$this->db->escape($action);
                $item->auth_res=$auth_res;
                $item->response='';
                $item->type='global';
        
                break;
            case 'getTaskList':
                $item=new stdClass();
                $item->id=null;
                $item->ip=$_SERVER['REMOTE_ADDR'];  
                $device=$this->getDevice();
                $item->device=$device;
                $item->user_agent=$this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date=date('d.m.Y H:i:s');
                $item->timestamp=time();
                $item->action=$this->db->escape($action);
                $item->auth_res=$auth_res;
                $item->response=$response;
                $item->type='getTaskList';
       
                break;
            case 'getAllUsers':
                $item=new stdClass();
                $item->id=null;
                $item->ip=$_SERVER['REMOTE_ADDR'];  
                $device=$this->getDevice();
                $item->device=$device;
                $item->user_agent=$this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date=date('d.m.Y H:i:s');
                $item->timestamp=time();
                $item->action=$this->db->escape($action);
                $item->auth_res=$auth_res;
                $item->response=$response;
                $item->type='getAllUsers';
       
                break;
            case 'startCOTime':
                $item=new stdClass();
                $item->id=null;
                $item->ip=$_SERVER['REMOTE_ADDR'];  
                $device=$this->getDevice();
                $item->device=$device;
                $item->user_agent=$this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date=date('d.m.Y H:i:s');
                $item->timestamp=time();
                $item->action=$this->db->escape($action);
                $item->auth_res=$auth_res;
                $item->response=$response;
                $item->type='startCOTime';
       
                break;
            case 'syncUser':
                $item=new stdClass();
                $item->id=null;
                $item->ip=$_SERVER['REMOTE_ADDR'];  
                $device=$this->getDevice();
                $item->device=$device;
                $item->user_agent=$this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date=date('d.m.Y H:i:s');
                $item->timestamp=time();
                $item->action=$this->db->escape($action);
                $item->auth_res=$auth_res;
                $item->response=$response;
                $item->type='syncUser';
                break;
             case 'addFieldToTask':
                $item=new stdClass();
                $item->id=null;
                $item->ip=$_SERVER['REMOTE_ADDR'];  
                $device=$this->getDevice();
                $item->device=$device;
                $item->user_agent=$this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date=date('d.m.Y H:i:s');
                $item->timestamp=time();
                $item->action=$this->db->escape($action);
                $item->auth_res=$auth_res;
                $item->response=$response;
                $item->type='addFieldToTask';
                break;
            case 'getConfirmPageData':
                $item=new stdClass();
                $item->id=null;
                $item->ip=$_SERVER['REMOTE_ADDR'];  
                $device=$this->getDevice();
                $item->device=$device;
                $item->user_agent=$this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date=date('d.m.Y H:i:s');
                $item->timestamp=time();
                $item->action=$this->db->escape($action);
                $item->auth_res=$auth_res;
                $item->response=$response;
                $item->type='getConfirmPageData';
                break;
            case 'getConfirmPageHtml':
                $item=new stdClass();
                $item->id=null;
                $item->ip=$_SERVER['REMOTE_ADDR'];  
                $device=$this->getDevice();
                $item->device=$device;
                $item->user_agent=$this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date=date('d.m.Y H:i:s');
                $item->timestamp=time();
                $item->action=$this->db->escape($action);
                $item->auth_res=$auth_res;
                $item->response=$response;
                $item->type='getConfirmPageHtml';
                break;
            case 'checkConfirmPageReady':
                $item=new stdClass();
                $item->id=null;
                $item->ip=$_SERVER['REMOTE_ADDR'];  
                $device=$this->getDevice();
                $item->device=$device;
                $item->user_agent=$this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date=date('d.m.Y H:i:s');
                $item->timestamp=time();
                $item->action=$this->db->escape($action);
                $item->auth_res=$auth_res;
                $item->response=$response;
                $item->type='checkConfirmPageReady';
                break;
            case 'deleteTempDataConfirm':
                $item=new stdClass();
                $item->id=null;
                $item->ip=$_SERVER['REMOTE_ADDR'];  
                $device=$this->getDevice();
                $item->device=$device;
                $item->user_agent=$this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date=date('d.m.Y H:i:s');
                $item->timestamp=time();
                $item->action=$this->db->escape($action);
                $item->auth_res=$auth_res;
                $item->response=$response;
                $item->type='deleteTempDataConfirm';
                break;
            case 'confirmRow':
                $item=new stdClass();
                $item->id=null;
                $item->ip=$_SERVER['REMOTE_ADDR'];  
                $device=$this->getDevice();
                $item->device=$device;
                $item->user_agent=$this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date=date('d.m.Y H:i:s');
                $item->timestamp=time();
                $item->action=$this->db->escape($action);
                $item->auth_res=$auth_res;
                $item->response=$response;
                $item->type='confirmRow';
                break;
            case 'getWorksheetList':
                $item=new stdClass();
                $item->id=null;
                $item->ip=$_SERVER['REMOTE_ADDR'];  
                $device=$this->getDevice();
                $item->device=$device;
                $item->user_agent=$this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date=date('d.m.Y H:i:s');
                $item->timestamp=time();
                $item->action=$this->db->escape($action);
                $item->auth_res=$auth_res;
                $item->response=$response;
                $item->type='getWorksheetList';
                break;
            case 'editCell':
                $item=new stdClass();
                $item->id=null;
                $item->ip=$_SERVER['REMOTE_ADDR'];  
                $device=$this->getDevice();
                $item->device=$device;
                $item->user_agent=$this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date=date('d.m.Y H:i:s');
                $item->timestamp=time();
                $item->action=$this->db->escape($action);
                $item->auth_res=$auth_res;
                $item->response=$response;
                $item->type='editCell';
                break;
        }
      
        $this->db->setQuery("delete from #__api_global_log where timestamp < ".$this->db->quote(strtotime("-30 day")));
        $this->db->query();
        $this->db->insertObject('#__api_global_log', $item);
        
    }
   
    public function getDevice()
    {
        $tablet_browser = 0;
        $mobile_browser = 0;

        if (preg_match('/(tablet|ipad|playbook)|(android(?!.*(mobi|opera mini)))/i', strtolower($_SERVER['HTTP_USER_AGENT']))) {
            $tablet_browser++;
        }

        if (preg_match('/(up.browser|up.link|mmp|symbian|smartphone|midp|wap|phone|android|iemobile)/i', strtolower($_SERVER['HTTP_USER_AGENT']))) {
            $mobile_browser++;
        }

        if ((strpos(strtolower($_SERVER['HTTP_ACCEPT']),'application/vnd.wap.xhtml+xml') > 0) or ((isset($_SERVER['HTTP_X_WAP_PROFILE']) or isset($_SERVER['HTTP_PROFILE'])))) {
            $mobile_browser++;
        }

        $mobile_ua = strtolower(substr($_SERVER['HTTP_USER_AGENT'], 0, 4));
        $mobile_agents = array(
            'w3c ','acs-','alav','alca','amoi','audi','avan','benq','bird','blac',
            'blaz','brew','cell','cldc','cmd-','dang','doco','eric','hipt','inno',
            'ipaq','java','jigs','kddi','keji','leno','lg-c','lg-d','lg-g','lge-',
            'maui','maxo','midp','mits','mmef','mobi','mot-','moto','mwbp','nec-',
            'newt','noki','palm','pana','pant','phil','play','port','prox',
            'qwap','sage','sams','sany','sch-','sec-','send','seri','sgh-','shar',
            'sie-','siem','smal','smar','sony','sph-','symb','t-mo','teli','tim-',
            'tosh','tsm-','upg1','upsi','vk-v','voda','wap-','wapa','wapi','wapp',
            'wapr','webc','winw','winw','xda ','xda-');

        if (in_array($mobile_ua,$mobile_agents)) {
            $mobile_browser++;
        }

        if (strpos(strtolower($_SERVER['HTTP_USER_AGENT']),'opera mini') > 0) {
            $mobile_browser++;
            //Check for tablets on opera mini alternative headers
            $stock_ua = strtolower(isset($_SERVER['HTTP_X_OPERAMINI_PHONE_UA'])?$_SERVER['HTTP_X_OPERAMINI_PHONE_UA']:(isset($_SERVER['HTTP_DEVICE_STOCK_UA'])?$_SERVER['HTTP_DEVICE_STOCK_UA']:''));
            if (preg_match('/(tablet|ipad|playbook)|(android(?!.*mobile))/i', $stock_ua)) {
                $tablet_browser++;
            }
        }

        if ($tablet_browser > 0) {
            // do something for tablet devices
            $browser='tablet';

        }
        else if ($mobile_browser > 0) {
            // do something for mobile devices
            $browser='mobile';
        }
        else {
            // do something for everything else
            $browser='desctop';
        }
        
        return $browser;
    }
    
    public function getListManager($owner_id)
    {
        $query='SELECT `id`, `username0`, `password2`, `name`, `email`, `tel`, `company`, `username`, `api_token`, `group_user`, `rule_text`, `rule_text_is` FROM #__users WHERE `owner_id`="'.$owner_id.'" ORDER BY `id` DESC';
        $this->db->setQuery( $query );
        $items = $this->db->loadObjectList();
        //file_put_contents( '/home/curiotime/thingvangur.curiotime.com/logs/confirm_time.html', print_r('nohup', true), FILE_APPEND | LOCK_EX);
        
        foreach($items as $one_user){
            $one_user->group_custom=$this->getUserGroup($one_user->id);
            $one_user->rule=$this->getUserRule($one_user->id);
        }
        
        return $items;
    }
    
    /*public function getUserRule($user_id)
    {
        include_once($_SERVER['DOCUMENT_ROOT'].'/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
        
        $link='https://ultima.curiotime.com/employers-staff';
        $html1 = file_get_html($link);//simple html
        
        $output_array=[];
        $i=0;
        //table[class="login-user-list reg-user"] tr td[class="rule_number-user"]
        
        foreach($html1->find('form[id="member-registration > table[class="login-user-list reg-user"] > tr > td[class="rule_number-user"]') as $e){
            //$output_array[]=$e->plaintext;
            foreach($e->find('select[class="select_employers_staff select_user_rule"]') as $v){
                $selected_val =  $v->find('option[selected]', 0)->value;
                $output_array[$i]=$selected_val; 
            }
        
            //file_put_contents('/home/curiotime/ultima.curiotime.com/logs/collect.html', print_r($output_array[$i].'<br/>', true), FILE_APPEND | LOCK_EX); 
        
            $i++;
        }
        
       /* $to1 = 'developer3452@gmail.com';
        $subject = 'CSV API getUserRule';
        $headers = "From: info@curiotime.com\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=UTF-8\r\n"; 
 
        $message='<pre>'.print_r($output_array, true).'</pre>';
        //mail($to1, $subject, $message, $headers);*/
 
        //file_put_contents($_SERVER['DOCUMENT_ROOT'].'/logs/api_get_rule_num.html', print_r($output_array, true), FILE_APPEND | LOCK_EX); 
    //}
    
    
    public function getUserRule($user_id)
    {
        
    }
    
    
    
    public function getConfirmPageData($token, $date)
    {
        $user_obj=$this->getUserByToken($token);
        $id_user=$user_obj->id;
        
        $user_joomla_obj=JFactory::getUser($id_user);
        if(in_array(6, $user_joomla_obj->groups)){
            $owner_id=$user_obj->owner_id;
            $manager_users=$this->getManagerUsers($owner_id);
            $final_confirm_arr=[];
            
            if(!empty($manager_users)){
                foreach($manager_users as $k=>$v){
                    $confirm_arr=self::getTimeByPeriodOneDate($v->id, $date)['dayNumber'];
                    if(!empty($confirm_arr)){
                        $final_confirm_arr[$v->api_token]=$confirm_arr;
                    }
                }
            }
            //return self::getTimeByPeriodOneDate($id_user, $date)['dayNumber'];
            return $final_confirm_arr;
        } else{
            return 'user is not manager. Enter manager token';
        }
        
       
        
    }
    
    //here
    public function getConfirmPageHtml($token, $date, $mode, $unical_string, $dep_arr)
    {
        $user_obj=$this->getUserByToken($token);
        $id_user=$user_obj->id;
        
        $user_joomla_obj=JFactory::getUser($id_user);
        if(in_array(6, $user_joomla_obj->groups)){
            $owner_id=$user_obj->owner_id;
            $manager_users=$this->getManagerUsers($owner_id);
            $final_confirm_arr=[];
            
            if(!empty($manager_users)){
                if( $curl = curl_init() ) {
                    
                        $options=[
                            CURLOPT_URL=>$this->site_fullname.'/system_addons/console_load_confirm_page.php',
                            CURLOPT_RETURNTRANSFER=>true,
                            CURLOPT_POST=>true,
                            CURLOPT_POSTFIELDS=>[
                                'date1'=>$date,
                                'lang'=>'en',
                                'u_id'=>$id_user,
                                'from'=>'',
                                'to'=>'',
                                'mode'=>$mode,
                                'unical_string'=>$unical_string,
                                'dep_arr'=>$dep_arr
                            ],
                        ];
           
            
                        curl_setopt_array($curl, $options);
                        $out = curl_exec($curl);
                        curl_close($curl);

                        //$api_obj->addLogRow($action, 'getConfirmPageHtml', $auth_res, $out);
                       
                        return $out;
                    }
            }
         
           
        } else{
            return 'user is not manager. Enter manager token';
        }
        
       
        
    }
    
    private function getManagerUsers($owner_id)
    {
        $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        return $this->db->loadObjectList();
    }
    
    private static function getTimeByPeriodOneDate($id_user, $date) {
        //$start = date('Y-m-d');
        //$end = date('Y-m-d', strtotime($_REQUEST['to']));
        $current_date=date('Y-m-d');
        $db = & JFactory::getDBO();
        
        $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$id_user' AND `date` = '".$date."' ORDER BY `date_logged` ASC";
        $db->setQuery($query);
        $data = $db->loadObjectList();

        // Load period
        $from = new DateTime($date);
        $dayN = date('t', strtotime($date));
        $to = new DateTime(date('Y-m-d', strtotime($current_date . ' +' . $dayN . 'day')));
        $period = new DatePeriod($from, new DateInterval('P1D'), $to);
        
        return self::mapToDatesConfirmTime($period, $data);
    }
    
    private static function mapToDatesConfirmTime($period, $data) {
        // Load audits
        $audits = array();
        foreach ($data as $val) {
            $d = date('Y-m-d', strtotime($val->date));
            $audits[$d][] = $val;
        }

        // Merge audits and period. Days with no audits will have empty array
        $result = array();
        $arrayOfDates = array();
        foreach ($period as $val) {
            $daykey = $val->format('Y-m-d');
            $result[$daykey] = array(); // Default empty
            if (isset($audits[$daykey])) {
                // Audit exits for day
                $result[$daykey] = $audits[$daykey];
                foreach ($audits[$daykey] as $val) {
                    //file_put_contents('/home/curiotime/ultima.curiotime.com/logs/collect.html', print_r($val, true), FILE_APPEND | LOCK_EX); 
                    if (!empty($val->note) || !empty($val->date_logged)) {
                        $arrayOfDates[] = array(
                            'date' => $val->date,
                            'data' => $val
                        );
                    }
                }
            } else {
                // One day
                /* $arrayOfDates[] = array(
                  'date' => $val->format('Y-m-d'),
                  'data' => null
                  ); */
            }
        }
        //krsort($arrayOfDates);  
       
        return array('dayNumber' => $arrayOfDates);
    }
    
    private function getUserByToken($token)
    {
        $query = "SELECT * FROM #__users WHERE `api_token` = '$token'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        return $data;
    }
    
    public function getStatus($token)
    {
        $query = "SELECT * FROM #__temp_cofirm_page_api_html WHERE `unical_key` = '$token'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        if(!empty($data)){
            return $data->html;
        } else{
            return '0';
        }
    }
    
    public function getStatus2($token)
    {
        $query = "SELECT * FROM #__temp_cofirm_page_api_html WHERE `unical_key` = '$token'";
        $this->db->setQuery($query);
        return $this->db->loadObject();
    }
    
    public function deleteTempDataConfirm($token)
    {
        $query = "DELETE FROM `#__temp_cofirm_page_api_html` WHERE `unical_key` = '$token';";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function confirmRow($token, $row_id)
    {
        //$row_date=filter_input(INPUT_POST, 'row_date', FILTER_SANITIZE_STRING);
        //$id_user=filter_input(INPUT_POST, 'id_user', FILTER_VALIDATE_INT);
        $id=$row_id;
        //$user_obj=$this->getUserByToken($token);
        
        //$res=$model->confirmPayPeriodRow($row_date, $id_user, $id);
       // if(!empty($row_date) && !empty($id_user) && !empty($id)){
            $query = 'SELECT * FROM #__audit_time_confirm WHERE `id`="'.$id.'"';
            $this->db->setQuery($query);
            $item = $this->db->loadObject();
            
            if(!empty($item)){
                $res=$this->addOneRowPayPeriod($item);
                
                if(!empty($res)){
                    $item = new stdClass;
                    $item->id=$id;
                    $item->is_confirm='1';
                    
                    $this->db->updateObject( '#__audit_time_confirm', $item, 'id' );  
                }
                //file_put_contents('/home/curiotime/ultima.curiotime.com/logs/confirm_time.html', print_r($item, true), FILE_APPEND | LOCK_EX);
            }
            
       // }
    }
    
    private function addOneRowPayPeriod($confirm_object)
    {
        $item = new stdClass;
        foreach($confirm_object as $k=>$v){
            $item->id=NULL;
            if($k!=is_confirm && $k!=audit_time_id && $k!=id){
                $item->$k=$v;
            }
            
        }
            
        $this->db->insertObject( '#__audit_time', $item, 'id' );      
        $insert_id=$this->db->insertid();
        if(!empty($insert_id)){
            return '1';
        }
        else{
            return '0';
        }
       // setcookie('insert_id_pay_period', $insert_id,  time()+3600 * 24 * 365);
    }
    
    //$user_token, $row_id, $type, $value, $year, $date
    public function editCell($user_token, $row_id, $type, $value0, $year, $date)
    {
        //$data_id=$_REQUEST['id'];
        //$id=explode('-', $data_id)[1];
        $data_value= $value0;
        $value=trim($data_value);
        $value= strip_tags($value);

        //$model = JModelLegacy::getInstance('Confirm_time', 'AuditModel');
        /*Array
            (
            [value] => 06:48
            [id] => date_logged-48
            [year] => 2019
            [date] => 05.06.2019
            [user_id] => 2545
   
        )*/
        $user_id=$this->getUserByToken($user_token)->id;
        
        if(empty($row_id) && !empty($user_id)){              
            $res0=$this->setConfirmRow([
                'id'=>$row_id,
                'value'=>$value,
                'year'=>$year,
                'date'=>$date,
                'user_id'=>$user_id,
                'user_token'=>$user_token
            ], $type, 'insert');        
        } else{
            $res0=$this->setConfirmRow([
                'id'=>$row_id,
                'value'=>$value,
                'year'=>$year,
                'date'=>$date,
                'user_id'=>$user_id,
                'user_token'=>$user_token
            ], $type, 'update');
        }
        
        switch($res0['code']){
            case '0':
                echo $res0['new_value'];
            break;
            case '1':
                echo '<span style="color:red">permission denied</span>';
            break;  
            case '3':
                echo '<span style="color:red">empty row</span>';
            break;
            case '4':
                echo '<span style="color:red">DB error</span>';
            break;
        }
    }
    
    private function setConfirmRow($param, $mode, $action)
    {        
       //file_put_contents('/home/curiotime/fagverk.curiotime.com/logs/api_viktor.html', print_r($param, true), FILE_APPEND | LOCK_EX);
       //file_put_contents('/home/curiotime/fagverk.curiotime.com/logs/api_viktor.html', print_r($mode, true), FILE_APPEND | LOCK_EX);
       //exit;
       $idField = $param['id'];
       
       $valueField = $param['value']; 
       $valueField=trim($valueField);
       $valueField= strip_tags($valueField);
       
       $yearField = $param['year']; 
       $dateField = $param['date']; 
       $id_user=$param['user_id'];
       $id_user=(int)$id_user;
      
       $dateField = explode('.', $dateField);
       $idField = explode('-', $idField);
       //$field = $idField[0];
       //$id = $idField[1];
       $id=(int)$param['id'];
        //if(!empty($valueField)){
            $db = $this->db;
            //$user_joomla = & JFactory::getUser(); 
            //$id_user0 = $user_joomla->id;  
            
            $item = new stdClass;
            if($action==='update'){
                $item->id = $id; 
            } if($action==='insert'){
                $item->id = NULL; 
            }
                  
            $item->id_user = $id_user;
            if( $action!=='update' && $mode!='login_hours' && $mode!='exit_hours'){
                $item->date_logged = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:00';
                $item->date_exit = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:01';
            }
            
            //$item->date_logged='';
            //$item->date_exit='';
            $item->date = $yearField.'-'.$dateField[1].'-'.$dateField[0];
            $item->ip=$_SERVER["REMOTE_ADDR"];
                
            if($mode!='description'){
                //7=>07:00, 07=>07:00, 07:=>07:00, 07:0=>07:00
                $valueField=$this->autocompletion($valueField);
            }
            
            switch($mode){
                case 'login_hours':
                    //date= date from client request plus new H:i
                    if($action!='update'){
                       // $item->date_exit = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 23:59:00';
                    }
                    $newValue = date('Y-m-d', strtotime($item->date)).' '.$valueField;
       
                    $item->date_logged = $newValue;
                    $item->date_logged_edit='1';                   
                break;
                case 'exit_hours':
                    if($action!='update'){
                        $item->date_logged = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:00';
                    }
                    $newValue = date('Y-m-d', strtotime($item->date)).' '.$valueField;
                     
                    $item->date_exit = $newValue;
                    $item->date_exit_edit='1';                   
                break;
                /*case 'total':
                    $item->new_hours = $valueField;               
                break;*/
                case 'daytime':
                    $item->new_daytime = $valueField;
                    $item->daytime_edit='1';
                    $item->daytime_edited_date=date('Y-m-d H:i:s');
                break;
                case 'afterwork':
                    $item->new_afterwork = $valueField;
                    $item->afterwork_edit='1';
                    $item->afterwork_edited_date=date('Y-m-d H:i:s');
                break;
                case 'night_time':
                    $item->new_night_time = $valueField;
                    $item->night_time_edit='1';
                    $item->night_time_edited_date=date('Y-m-d H:i:s');
                break;
                case 'weekend':
                    $item->new_weekend = $valueField;
                    $item->weekend_edit='1';
                    $item->weekend_edited_date=date('Y-m-d H:i:s');
                break;
                /*case 'holidays':
                    $item->new_holidays = $valueField;
                    $item->holidays_edit='1';
                    $item->holidays_edited_date=date('Y-m-d H:i:s');
                break;*/
                case 'description':
                    $item->note = $valueField;
                break;
            }
            
            if($action=='update'){
                $res=$this->db->updateObject('#__audit_time_confirm', $item, 'id');
            } if($action=='insert'){
                $res=$this->db->insertObject( '#__audit_time_confirm', $item, 'id' );
            }
                   
        //}  

       $code=0;
       
       //need optimized
        switch($mode){
            case 'login_hours':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'exit_hours':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'total':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'daytime':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;  
            case 'afterwork':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'night_time':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'weekend':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'holidays':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'description':
                $result=[
                    'new_note'=>$valueField,//
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid(),
                    'action'=>$action
                ];     
            break;
           
        }
       
        return $result;
        
    }
    
    
    
    private function autocompletion($valueField)
    {
        switch(strlen($valueField)){
            case 0:
                
                break;
            case 1:
                $valueField='0'.$valueField.':00';
                break;
            case 2:
                $valueField0=str_split($valueField, 1);
                
                if($valueField0[0]=='0'){
                   $valueField='0'.$valueField0[1].':00';
                } else{
                    $valueField=$valueField0[0].$valueField0[1].':00';
                }
                break;
            case 3:
                $valueField0=str_split($valueField, 1);
                $valueField=$valueField0[0].$valueField0[1].':00';
                break;
            case 4:
                $valueField0=str_split($valueField, 1);
                $valueField=$valueField0[0].$valueField0[1].':'.$valueField0[3].'0';
                break;
        }
        
        return $valueField;
    }
    
}
