<?php

set_time_limit(0);

define('_JEXEC', 1);

define('JPATH_BASE', $_SERVER['DOCUMENT_ROOT']);


define('DS', '/');
require_once( JPATH_BASE . DS . 'includes' . DS . 'defines.php' );

require_once( JPATH_BASE . DS . 'includes' . DS . 'framework.php' );

jimport('joomla.application.component.controller');
$mainframe = & JFactory::getApplication('site');
$session = & JFactory::getSession();

$config = JFactory::getConfig();
$encryption_key = $config->get('encryption_key');
define('ENCRYPTION_KEY', $encryption_key);

class api {

    public function __construct($db) {
        $this->db = $db;
        $this->server_name = $_SERVER['SERVER_NAME'];
        $this->site_fullname = empty($_SERVER['HTTPS']) ? 'http://' : 'https://' . $this->server_name;
        $this->password_api_old = 'KIis3223*>XNWIUe8329od';
        $this->lang = & JFactory::getLanguage();
    }

    public function auth($password_original_hash, $password_request) {
        $to1 = 'developer3452@gmail.com';
        $subject = 'APP API ultima';

        $headers = "From: info@curiotime.com\r\n";

        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
        $message = '<pre>' . password_verify($password_original_hash, $password_request) . '</pre>';
        //mail($to1, $subject, $message, $headers);

        return password_verify($password_original_hash, $password_request);
    }

    public function getAllUsers($action) {
        $query = 'SELECT `id`, `username0`, `password2`, `name`, `email`, `tel`, `company`, `username`, `api_token` FROM #__users ORDER BY `id` ASC';
        $this->db->setQuery($query);
        $items = $this->db->loadObjectList();


        return $items;
    }

    /**
     * Get user by token
     * @param string $token
     * @return object 
     */
    private function getUserByToken($token) {
        $query  =   "SELECT * FROM #__users WHERE api_token = ".$this->db->quote($token)." limit 1";
        $this->db->setQuery($query);
        return $this->db->loadObject();
    }
    
    public function preparePassw($passw) {
        return password_hash($passw, PASSWORD_BCRYPT);
    }

    public function addLogRow($action, $type, $auth_res, $response, $client_info, $select_mode) {
        switch ($type) {
            case 'global':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = '';
                $item->type = 'global';


                break;
            case 'checkPassword':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'checkPassword';

                break;
            case 'getCompanyImages':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getCompanyImages';

                break;
            case 'getOwnerID':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getOwnerID';

                break;
            case 'checkSpecCompanies':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'checkSpecCompanies';

                break;
            case 'getGroupArray':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getGroupArray';

                break;
            case 'getListUsers':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getListUsers';

                break;
            case 'askedGps':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'askedGps';

                break;
            case 'startTime':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'startTime';

                break;
            case 'stopTime':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'stopTime';

                break;
            case 'getLayoutTaskSelect':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getLayoutTaskSelect';
                $item->select_mode = $select_mode;

                break;
            case 'getLayoutSpecificTaskAPISelect':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getLayoutSpecificTaskAPISelect';
                $item->select_mode = $select_mode;

                break;
            case 'getUserMode':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'getUserMode';
                $item->select_mode = $select_mode;

                break;
            case 'startCOTaskAPI':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'startCOTaskAPI';
                $item->select_mode = $select_mode;

                break;
            case 'saveState':
                $item = new stdClass();
                $item->id = null;
                $item->ip = $_SERVER['REMOTE_ADDR'];
                $device = $this->getDevice();
                $item->device = $device;
                $item->user_agent = $this->db->escape($_SERVER['HTTP_USER_AGENT']);
                $item->date = date('d.m.Y H:i:s');
                $item->timestamp = time();
                $item->action = $this->db->escape($action);
                $item->auth_res = $auth_res;
                $item->response = $response;
                $item->type = 'saveState';
                $item->select_mode = $select_mode;

                break;
        }

        $item->client_info = trim($client_info);
        $this->db->insertObject('#__app_api_global_log', $item);
    }

    public function getDevice() {
        $tablet_browser = 0;
        $mobile_browser = 0;

        if (preg_match('/(tablet|ipad|playbook)|(android(?!.*(mobi|opera mini)))/i', strtolower($_SERVER['HTTP_USER_AGENT']))) {
            $tablet_browser++;
        }

        if (preg_match('/(up.browser|up.link|mmp|symbian|smartphone|midp|wap|phone|android|iemobile)/i', strtolower($_SERVER['HTTP_USER_AGENT']))) {
            $mobile_browser++;
        }

        if ((strpos(strtolower($_SERVER['HTTP_ACCEPT']), 'application/vnd.wap.xhtml+xml') > 0) or ( (isset($_SERVER['HTTP_X_WAP_PROFILE']) or isset($_SERVER['HTTP_PROFILE'])))) {
            $mobile_browser++;
        }

        $mobile_ua = strtolower(substr($_SERVER['HTTP_USER_AGENT'], 0, 4));
        $mobile_agents = array(
            'w3c ', 'acs-', 'alav', 'alca', 'amoi', 'audi', 'avan', 'benq', 'bird', 'blac',
            'blaz', 'brew', 'cell', 'cldc', 'cmd-', 'dang', 'doco', 'eric', 'hipt', 'inno',
            'ipaq', 'java', 'jigs', 'kddi', 'keji', 'leno', 'lg-c', 'lg-d', 'lg-g', 'lge-',
            'maui', 'maxo', 'midp', 'mits', 'mmef', 'mobi', 'mot-', 'moto', 'mwbp', 'nec-',
            'newt', 'noki', 'palm', 'pana', 'pant', 'phil', 'play', 'port', 'prox',
            'qwap', 'sage', 'sams', 'sany', 'sch-', 'sec-', 'send', 'seri', 'sgh-', 'shar',
            'sie-', 'siem', 'smal', 'smar', 'sony', 'sph-', 'symb', 't-mo', 'teli', 'tim-',
            'tosh', 'tsm-', 'upg1', 'upsi', 'vk-v', 'voda', 'wap-', 'wapa', 'wapi', 'wapp',
            'wapr', 'webc', 'winw', 'winw', 'xda ', 'xda-');

        if (in_array($mobile_ua, $mobile_agents)) {
            $mobile_browser++;
        }

        if (strpos(strtolower($_SERVER['HTTP_USER_AGENT']), 'opera mini') > 0) {
            $mobile_browser++;
            //Check for tablets on opera mini alternative headers
            $stock_ua = strtolower(isset($_SERVER['HTTP_X_OPERAMINI_PHONE_UA']) ? $_SERVER['HTTP_X_OPERAMINI_PHONE_UA'] : (isset($_SERVER['HTTP_DEVICE_STOCK_UA']) ? $_SERVER['HTTP_DEVICE_STOCK_UA'] : ''));
            if (preg_match('/(tablet|ipad|playbook)|(android(?!.*mobile))/i', $stock_ua)) {
                $tablet_browser++;
            }
        }

        if ($tablet_browser > 0) {
            // do something for tablet devices
            $browser = 'tablet';
        } else if ($mobile_browser > 0) {
            // do something for mobile devices
            $browser = 'mobile';
        } else {
            // do something for everything else
            $browser = 'desctop';
        }

        return $browser;
    }

    public function checkPassword() {

        $password_raw = $this->db->escape(trim($_REQUEST['password_for_verify']));
        $password = $this->decrypt($password_raw);

        $company_raw = $this->db->escape(trim($_REQUEST['company_for_verify']));
        $company = $this->decrypt($company_raw);

        $query = "SELECT `id` FROM #__users WHERE BINARY `password2` = '$password' AND BINARY `company`='$company'";
        $this->db->setQuery($query);
        $u_id = $this->db->loadResult();

        return empty($u_id) ? '0' : $u_id;
    }

    //open ssl
    private function decrypt($ciphertext) {
        $c = base64_decode($ciphertext);
        $ivlen = openssl_cipher_iv_length($cipher = "AES-128-CBC");
        $iv = substr($c, 0, $ivlen);
        $hmac = substr($c, $ivlen, $sha2len = 32);
        $ciphertext_raw = substr($c, $ivlen + $sha2len);
        $plaintext = openssl_decrypt($ciphertext_raw, $cipher, ENCRYPTION_KEY, $options = OPENSSL_RAW_DATA, $iv);
        $calcmac = hash_hmac('sha256', $ciphertext_raw, ENCRYPTION_KEY, $as_binary = true);
        if (hash_equals($hmac, $calcmac)) {
            return $plaintext;
        }
    }

    public function getCompanyImages() {
        $companyName_raw = $this->db->escape(trim($_REQUEST['company_for_verify']));
        $companyName = $this->decrypt($companyName_raw);

        if (!empty($companyName)) {

            $query = "SELECT * FROM #__company_media WHERE company = '$companyName'";
            $this->db->setQuery($query);
            $company = $this->db->loadObject();

            if ($company) {
                $company->logo = $this->site_fullname . '/images/company_images/' . $company->logo;
                $company->bg = $this->site_fullname . '/images/company_images/' . $company->bg;

                return $company;
            }
        }
    }

    public function getOwnerID() {
        $user_id = (int) $_REQUEST['user_id'];

        $query = "SELECT `owner_id`, `id` FROM #__users WHERE `id` = '$user_id'";
        $this->db->setQuery($query);
        return $this->db->loadObject();
    }

    public function checkSpecCompanies() {
        $company_raw = $this->db->escape(trim($_REQUEST['company']));
        $company = $this->decrypt($company_raw);

        //$model = JModelLegacy::getInstance('Registered_Users', 'AuditModel');

        if (empty($company)) {
            $company = filter_input(INPUT_COOKIE, 'company');
        } else {
            $company = $company;
        } if (empty($_REQUEST['user_id'])) {
            $user_id = filter_input(INPUT_COOKIE, 'lastUserLogin', FILTER_VALIDATE_INT);
        } else {
            $user_id = $_REQUEST['user_id'];
        }

        $companies_array = [
            'Frostverk',
                //'demo'
        ];

        if (in_array($company, $companies_array)) {
            $permission_user = $this->checkPermission($user_id);
            if ($permission_user === '2' || $permission_user === '6') {
                $res = 'https://frostverk.ns3.kreativ.is/innskraning';
            }
        }
        // $res=$model->setSyncStatus($status);

        return [
            'user_id' => $user_id,
            'company' => $company,
            'res' => $res,
            'perm' => $permission_user
        ];
    }

    private function checkPermission($user_id) {
        $user = JFactory::getUser($user_id);
        $current_group = implode($user->get('groups'));

        return $current_group;
    }

    public function getGroupArray() {
        $user_id = (int) $_REQUEST['user_id'];
        $current_user = & JFactory::getUser($user_id);
        $owner_id = $current_user->owner_id;

        $query = "SELECT `id`, `group_user` FROM #__users WHERE `owner_id` = '$owner_id'  ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $res = $this->db->loadAssocList();

        $count = count($res);
        $final = $this->super_unique($res, 'group_user');

        $html = [];
        $i = 0;
        foreach ($final as $group) {
            if (!empty($group['group_user'])) {
                if ($group['group_user'] === $current_user->group_user) {
                    $html[$i]['department'] = $group['group_user'];
                    $html[$i]['is_selected'] = '1';
                    $html[$i]['id_user'] = $group['id'];
                } else {
                    $html[$i]['department'] = $group['group_user'];
                    $html[$i]['is_selected'] = '0';
                    $html[$i]['id_user'] = $group['id'];
                }
                $i++;
            }
        }
        return [
            'departments' => $html,
        ];
    }

    private function super_unique($array, $key) {
        $temp_array = [];
        foreach ($array as &$v) {
            if (!isset($temp_array[$v[$key]]))
                $temp_array[$v[$key]] = & $v;
        }
        $array = array_values($temp_array);
        return $array;
    }

    public function getListUsers() {
        $user_id = (int) $_REQUEST['user_id'];

        $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user_id'";
        $this->db->setQuery($query);
        $owner_id = $this->db->loadResult();

        $users_list = $this->getUsersOnline($owner_id);

        return $users_list;
    }
    
    //here
    private function getUsersOnline($owner_id) {
        $query = "SELECT `id`,`username`,`username0` FROM #__users WHERE `owner_id` = '" . $owner_id . "' ORDER BY `username0` ASC";
        $this->db->setQuery($query);
        $users = $this->db->loadObjectList();


        $final_arr = [];
        ksort($users);

        foreach ($users as $user) {
            $system_mode=$this->getSystemMode();
            if($system_mode=='confirm'){
                $res = $this->checkOnlineUserConfirm($user->id);
            } elseif($system_mode=='pay_period'){
                $res = $this->checkOnlineUser($user->id);
            }
            
          
            
            if ($res == '1') {
                $user->additionally_is_online = '1';
                $final_arr[] = $user;
            } else {
                //$user->additionally_is_online = '0';
            }
        }


        return $final_arr;
    }

    private function checkOnlineUserConfirm($user_id) {
        $current_date = date('Y-m-d');
        $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '$user_id' AND `date`='" . $current_date . "' AND `date_exit`='0000-00-00 00:00:00' ORDER BY `id` DESC LIMIT 0, 1";
        $this->db->setQuery($query);
        $rez = $this->db->loadObjectList();

        if (!empty($rez)) {
            $res = '1';
        } else {
            $res = '0';
        }
        return $res;
    }
    
    private function checkOnlineUser($user_id) {
        $current_date = date('Y-m-d');
        $query = "SELECT * FROM #__audit_time WHERE `id_user` = '$user_id' AND `date`='" . $current_date . "' AND `date_exit`='0000-00-00 00:00:00' ORDER BY `id` DESC LIMIT 0, 1";
        $this->db->setQuery($query);
        $rez = $this->db->loadObjectList();

        if (!empty($rez)) {
            $res = '1';
        } else {
            $res = '0';
        }
        return $res;
    }

    public function askedGps() {
        $user_id = (int) $_REQUEST['user_id'];

        $query = "SELECT `gps_mode` FROM #__users WHERE `id` = '$user_id'";
        $this->db->setQuery($query);
        $gps_mode = $this->db->loadResult();

        return $gps_mode;
    }
    
    
    public function startTime($token) {
        $user_obj=$this->getUserByToken($token);
       // file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/api_start_time.html', print_r($user_obj, true), FILE_APPEND | LOCK_EX);
        //exit;
        
       // $password_raw = $this->db->escape(trim($_REQUEST['password_for_verify']));
        //$password = $this->decrypt($password_raw);
        $password =$user_obj->password2;
        
        //$company_raw = $this->db->escape(trim($_REQUEST['company_for_verify']));
        //$company = $this->decrypt($company_raw);
        $company = $user_obj->company;
        
        $lat_raw = $this->db->escape(trim($_REQUEST['lat']));
        $lat = $this->decrypt($lat_raw);

        $lng_raw = $this->db->escape(trim($_REQUEST['lng']));
        $lng = $this->decrypt($lng_raw);

        $client_ip_raw = $this->db->escape(trim($_REQUEST['client_ip']));
        $client_ip = $this->decrypt($client_ip_raw);

        $ownerID = $user_obj->owner_id;


        $ids = $this->getUser($company, $ownerID, $password);
        $u_id = $ids->id;
       

        $note1 = $this->db->escape(trim($_REQUEST['note']));
        $note = strip_tags($note1);

        if (!empty($u_id)) {
           
            $system_mode=$this->getSystemMode();
            
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/api_system_mode.html', print_r($system_mode, true), FILE_APPEND | LOCK_EX);
            if($system_mode=='confirm'){
                if ($this->setConfirmTime($u_id, $lat, $lng, $note, $client_ip)) {
                    // Update User Status to Green (1)
                    $this->updateUserStatusToGreen($u_id);
                    return 'ok';
                }
            } elseif($system_mode=='pay_period'){
                if ($this->setTimeWrapper($u_id, $lat, $lng, $note, $client_ip)) {
                    // Update User Status to Green (1)
                    $this->updateUserStatusToGreen($u_id);
                    return 'ok';
                }
            }
            
        }
    }

    private function getSystemMode() {
        $config = JFactory::getConfig();
        $system_mode_raw= $config->get('system_mode');

        if($system_mode_raw==='0'){
            $system_mode='confirm';
        } elseif($system_mode_raw==='1'){
            $system_mode='pay_period';
        }
        
        return $system_mode;
    }
    
    private function getUser($company, $ownerID, $password) {
        if (!empty($company)) {
            $companyF = " AND company = '$company'";
        }
        if (!empty($ownerID)) {
            $ownerIDF = " AND owner_id = '$ownerID'";
        }

        $query = "SELECT `id`, `owner_id` FROM #__users WHERE `password2` = '$password' $companyF $ownerIDF";
        $this->db->setQuery($query);
        $user = $this->db->loadObject();

        return $user;
    }

    private function setTimeWrapper($u_id, $lat, $lng, $note, $client_ip) {
        //$model = JModelLegacy::getInstance('overview', 'AuditModel');
        if (self::setTime($u_id, $lat, $lng, $note, $client_ip)) {
            return true;
        } else {
            return false;
        }
    }
    
   
    private function setConfirmTime($u_id, $lat, $lng, $note, $client_ip) {
        //$model = JModelLegacy::getInstance('overview', 'AuditModel');
        if (self::setConfirmTime0($u_id, $lat, $lng, $note, $client_ip)) {
            return true;
        } else {
            return false;
        }
    }

    private static function setUserStartTime($u_id) {
        // SET Status globally to USER to 1 if User Status is 0
        $db = & JFactory::getDBO();
        //$user = & JFactory::getUser();

        if (!empty($u_id)) {
            $id_user = $u_id;
        } else {
            //$id_user = $user->id;
        }

        $query = "SELECT start_time FROM #__users WHERE id = '$id_user'";
        $db->setQuery($query);
        $start_time = $db->loadResult();

        if ($start_time == 0) {
            $itemU = new stdClass;
            $itemU->id = $id_user;
            $itemU->start_time = 1;
            $db->updateObject('#__users', $itemU, 'id');
        }
    }

    private static function setTime($u_id = null, $lat, $lng, $note, $client_ip) {
        // Set User Start Time
        self::setUserStartTime($u_id);

        //return 'dd';
        $db = & JFactory::getDBO();

        // Check If user is stamped in
        $current_date = date('Y-m-d');
        $query = "SELECT * FROM #__audit_time WHERE id_user = '$u_id' AND date = '$current_date' order by ID desc";
        $db->setQuery($query);
        $data = $db->loadObject();

        // Check if stamped in
        if (!empty($data->id) && !empty($data->date)) {
            // Check if not stamped out
            if ($data->date_exit == 0) {
                // Not stamped out today.
                //add description if user press start and not logout today
                if (empty($data->note)) {
                    $query = "UPDATE #__audit_time SET `note`='" . $db->escape($note) . "' WHERE `id`='" . $data->id . "'";
                    $db->setQuery($query);
                    $db->query();
                } else {
                    $note_current_session = $data->note;
                    $note_final = $note_current_session . '-' . $db->escape($note);

                    $query = "UPDATE #__audit_time SET `note`=' $note_final' WHERE `id`='" . $data->id . "'";
                    $db->setQuery($query);
                    $db->query();
                }

                // Already stamped in. return
            } else {
                // Stamped out today Create new record
                self::createNewAuditRecord($u_id, $current_date, $lat, $lng, $note, $client_ip);
            }
        } else {
            // Not stamped in today. Create new record
            self::createNewAuditRecord($u_id, $current_date, $lat, $lng, $note, $client_ip);
        }
        return true;
    }
    
    private static function setConfirmTime0($u_id = null, $lat, $lng, $note, $client_ip) {
        // Set User Start Time
        self::setUserStartTime($u_id);

        //return 'dd';
        $db = & JFactory::getDBO();

        // Check If user is stamped in
        $current_date = date('Y-m-d');
        $query = "SELECT * FROM #__audit_time_confirm WHERE id_user = '$u_id' AND date = '$current_date' order by ID desc";
        $db->setQuery($query);
        $data = $db->loadObject();

        // Check if stamped in
        if (!empty($data->id) && !empty($data->date)) {
            // Check if not stamped out
            if ($data->date_exit == 0) {
                // Not stamped out today.
                //add description if user press start and not logout today
                if (empty($data->note)) {
                    $query = "UPDATE #__audit_time_confirm SET `note`='" . $db->escape($note) . "' WHERE `id`='" . $data->id . "'";
                    $db->setQuery($query);
                    $db->query();
                } else {
                    $note_current_session = $data->note;
                    $note_final = $note_current_session . '-' . $db->escape($note);

                    $query = "UPDATE #__audit_time_confirm SET `note`=' $note_final' WHERE `id`='" . $data->id . "'";
                    $db->setQuery($query);
                    $db->query();
                }

                // Already stamped in. return
            } else {
                // Stamped out today Create new record
                self::createConfirmTimeRecordNoPayPeriod($u_id, $current_date, $lat, $lng, $note, $client_ip);
            }
        } else {
            // Not stamped in today. Create new record
            self::createConfirmTimeRecordNoPayPeriod($u_id, $current_date, $lat, $lng, $note, $client_ip);
        }
        return true;
    }

    private static function createNewAuditRecord($u_id, $current_date, $lat, $lng, $note, $client_ip) {
        if ($u_id > 0) {
            $db = & JFactory::getDBO();
            $item = new stdClass;
            $item->id = NULL;
            $item->id_user = $u_id;
            $item->date_logged = date('Y-m-d H:i:s');
            $item->date_exit = null;
            $item->date = $current_date;

            $item->asked_gps = 0;
            $item->lat = $lat;
            $item->lng = $lng;
            $item->note = $note;
            $ip = $client_ip;
            $item->ip = $ip;
            $res = $db->insertObject('#__audit_time', $item, 'id');
            $db->insertid();

            if (!$res) {
                echo $db->stderr();
                return false;
            } else {
                return true;
            }
        }
    }
    
    private static function createConfirmTimeRecordNoPayPeriod($u_id, $current_date, $lat, $lng, $note, $client_ip) {
        if ($u_id > 0) {
            $db = & JFactory::getDBO();
            $item = new stdClass;
            $item->id = NULL;
            $item->id_user = $u_id;
            $item->date_logged = date('Y-m-d H:i:s');
            $item->date_exit = null;
            $item->date = $current_date;

            $item->asked_gps = 0;
            $item->lat = $lat;
            $item->lng = $lng;
            $item->note = $note;
            $ip = $client_ip;
            $item->ip = $ip;
            $res = $db->insertObject('#__audit_time_confirm', $item, 'id');
            $db->insertid();

            if (!$res) {
                echo $db->stderr();
                return false;
            } else {
                return true;
            }
        }
    }

    private function updateUserStatusToGreen($u_id) {
        $item = new stdClass;
        $item->id = $u_id;
        $item->status_user = 1;
        $this->db->updateObject('#__users', $item, 'id');

        return 'ok';
    }

    public function stopTimeWrapper() {
        $system_mode=$this->getSystemMode();
        $token=trim($_REQUEST['token']);
        $user_obj=$this->getUserByToken($token);
        
        if($system_mode=='confirm'){
            $this->stopTimeConfirm($user_obj);
        } elseif($system_mode=='pay_period'){
            $this->stopTime($user_obj);
        }
    }
    
    public function stopTime($user_obj) {
        $db = $this->db;

        if ($_REQUEST['sessionUs'] == 0) {
            /* setcookie('lastUserLogin', null,  -1);
              setcookie('company', null,  -1);
              setcookie('managerID', null,  -1);
              setcookie('ownerID', null,  -1); */
        }
        
       
        //$password_raw = $this->db->escape(trim($_REQUEST['password_for_verify']));
       // $password = $this->decrypt($password_raw);
        $password=$user_obj->password2;
        
        $lat_raw = $this->db->escape(trim($_REQUEST['lat_end']));
        $lat_end = $this->decrypt($lat_raw);

        $lng_raw = $this->db->escape(trim($_REQUEST['lng_end']));
        $lng_end = $this->decrypt($lng_raw);

        $description_logout_raw = $this->db->escape(trim($_REQUEST['description_logout']));
        $description_logout = $this->decrypt($description_logout_raw);

        $client_ip_raw = $this->db->escape(trim($_REQUEST['client_ip']));
        $client_ip = $this->decrypt($client_ip_raw);



        $current_date = date('Y-m-d');
        $date_exit = date('Y-m-d H:i:s');

        $query = "SELECT id FROM #__users WHERE password2 = '$password' ";
        $db->setQuery($query);
        $u_id = $db->loadResult();

        $itemU = new stdClass;
        $itemU->id = $u_id;
        $itemU->start_time = 0;
        $itemU->status_user = 3;
        $db->updateObject('#__users', $itemU, 'id');

        // Check If user is stamped in
        $query = "SELECT * FROM #__audit_time WHERE id_user = '$u_id' AND date = '$current_date' order by ID desc";
        $db->setQuery($query);
        $data = $db->loadObject();

        // Check if stamped in
        if (!empty($data->id) && !empty($data->date)) {
            // Check if not stamped out
            if ($data->date_exit == 0) {
                // Find latest date and updat exit date      
                $ip2 = $client_ip;


                //$description_logout=filter_input(INPUT_COOKIE, 'temp_logout_desciption', FILTER_SANITIZE_STRING);
                if (!empty($description_logout)) {
                    $description_login = $data->note;
                    $description_logout = $description_login . '-' . $description_logout;
                    $query = "UPDATE #__audit_time SET `date_exit` = '$date_exit', `lat_end`='$lat_end', `lng_end`='$lng_end', `ip_stop`='$ip2', `note`='$description_logout' WHERE `id_user` = '$u_id' AND `date` = '$current_date' AND `id` = '$data->id'";
                } else {
                    $query = "UPDATE #__audit_time SET `date_exit` = '$date_exit', `lat_end`='$lat_end', `lng_end`='$lng_end', `ip_stop`='$ip2' WHERE `id_user` = '$u_id' AND `date` = '$current_date' AND `id` = '$data->id'";
                }

                $db->setQuery($query);
                //setcookie('temp_logout_desciption', null,  -1);

                if ($db->query() && !empty($u_id)) {
                    return $u_id;
                    //setcookie('first_logout', '1',  time()+3600 * 24 * 365);
                } else {
                    return 'not';
                }
            }
        }
    }
    
    public function stopTimeConfirm($user_obj) {
        $db = $this->db;

        if ($_REQUEST['sessionUs'] == 0) {
            /* setcookie('lastUserLogin', null,  -1);
              setcookie('company', null,  -1);
              setcookie('managerID', null,  -1);
              setcookie('ownerID', null,  -1); */
        }

        //$password_raw = $this->db->escape(trim($_REQUEST['password_for_verify']));
        //$password = $this->decrypt($password_raw);
        $password=$user_obj->password2;
        
        $lat_raw = $this->db->escape(trim($_REQUEST['lat_end']));
        $lat_end = $this->decrypt($lat_raw);

        $lng_raw = $this->db->escape(trim($_REQUEST['lng_end']));
        $lng_end = $this->decrypt($lng_raw);

        $description_logout_raw = $this->db->escape(trim($_REQUEST['description_logout']));
        $description_logout = $this->decrypt($description_logout_raw);

        $client_ip_raw = $this->db->escape(trim($_REQUEST['client_ip']));
        $client_ip = $this->decrypt($client_ip_raw);



        $current_date = date('Y-m-d');
        $date_exit = date('Y-m-d H:i:s');

        $query = "SELECT id FROM #__users WHERE password2 = '$password' ";
        $db->setQuery($query);
        $u_id = $db->loadResult();

        $itemU = new stdClass;
        $itemU->id = $u_id;
        $itemU->start_time = 0;
        $itemU->status_user = 3;
        $db->updateObject('#__users', $itemU, 'id');

        // Check If user is stamped in
        $query = "SELECT * FROM #__audit_time_confirm WHERE id_user = '$u_id' AND date = '$current_date' order by ID desc";
        $db->setQuery($query);
        $data = $db->loadObject();

        // Check if stamped in
        if (!empty($data->id) && !empty($data->date)) {
            // Check if not stamped out
            if ($data->date_exit == 0) {
                // Find latest date and updat exit date      
                $ip2 = $client_ip;


                //$description_logout=filter_input(INPUT_COOKIE, 'temp_logout_desciption', FILTER_SANITIZE_STRING);
                if (!empty($description_logout)) {
                    $description_login = $data->note;
                    $description_logout = $description_login . '-' . $description_logout;
                    $query = "UPDATE #__audit_time_confirm SET `date_exit` = '$date_exit', `lat_end`='$lat_end', `lng_end`='$lng_end', `ip_stop`='$ip2', `note`='$description_logout' WHERE `id_user` = '$u_id' AND `date` = '$current_date' AND `id` = '$data->id'";
                } else {
                    $query = "UPDATE #__audit_time_confirm SET `date_exit` = '$date_exit', `lat_end`='$lat_end', `lng_end`='$lng_end', `ip_stop`='$ip2' WHERE `id_user` = '$u_id' AND `date` = '$current_date' AND `id` = '$data->id'";
                }

                $db->setQuery($query);
               

                if ($db->query() && !empty($u_id)) {
                    return $u_id;
                    
                } else {
                    return 'not';
                }
            }
        }
    }

    //here
    public function getLayoutTaskSelect() {
        //$user_id = (int) $_REQUEST['user_id'];
        $mode = $this->db->escape(trim($_REQUEST['mode']));
        
        $token= $this->decrypt($_REQUEST['token']);
        $user_obj=$this->getUserByToken($token);
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/api11.html', print_r($user_obj, true), FILE_APPEND | LOCK_EX);
        //exit;
        
        //$password_raw = $this->db->escape(trim($_REQUEST['password_for_verify']));
        //$password = $this->decrypt($password_raw);
        $password=$user_obj->password2;
        $user_id=$user_obj->id;
        
        if ($mode === 'password') {
            $pass = $password;

            $query = "SELECT * FROM #__users WHERE `password2` = '" . $pass . "'";
            $this->db->setQuery($query);
            $select_user_by_password = $this->db->loadObject();

            $user_by_password = JFactory::getUser((int) $select_user_by_password->id);
            $user = JFactory::getUser((int) $user_id);

            $query = "SELECT * FROM #__users WHERE `owner_id` = '" . $user->owner_id . "' AND password2 = '" . $pass . "'";
            $this->db->setQuery($query);
            $userlist = $this->db->loadAssoc();


            if (is_array($userlist)) {
                $userlist = $userlist['id'];
            } else {
                $userlist = '';
            }

            $query = "SELECT * FROM #__audit_task_list WHERE `id_user` = '" . $user->owner_id . "' ORDER BY `id` DESC";
            $this->db->setQuery($query);
            $task_list = $this->db->loadObjectList();

            $prepare_task_list_array = [];
            $i = 0;
            foreach ($task_list as $one_task) {
                if (!empty($one_task->text) && !empty($select_user_by_password) && in_array($user_by_password->id, explode(',', $one_task->attached_users)) && in_array($userlist, explode(',', $one_task->attached_users))) {
                    $subtask_list = $this->getSubtasks($one_task->id);

                    $prepare_task_list_array[$i]['task_id'] = $one_task->id;
                    $prepare_task_list_array[$i]['task_text'] = $one_task->text;
                    $prepare_task_list_array[$i]['subtasks'] = $subtask_list;

                    $i++;
                }
            }
            $password_correct = '0';
            if (!empty($select_user_by_password)) {
                $password_correct = '1';
            }


            return $prepare_task_list_array;
        } elseif ($mode === 'not_password') {
            $user = JFactory::getUser((int) $user_id);
            $query = "SELECT * FROM #__audit_task_list WHERE `id_user` = '" . $user->owner_id . "' AND `attached_users`='' ORDER BY `id` DESC";
            $this->db->setQuery($query);
            $task_list = $this->db->loadObjectList();


            $prepare_task_list_array = [];
            $ij = 0;
            foreach ($task_list as $one_task) {
                if ($one_task->text != '') {
                    $subtask_list = $this->getSubtasks($one_task->id);

                    $prepare_task_list_array[$ij]['task_id'] = $one_task->id;
                    $prepare_task_list_array[$ij]['task_text'] = $one_task->text;
                    $prepare_task_list_array[$ij]['subtasks'] = $subtask_list;

                    $ij++;
                }
            }

            return $prepare_task_list_array;
        }
    }

    private function getSubtasks($parent_id) {
        $parent_id = (int) $parent_id;
        $query = "SELECT * FROM #__audit_subtasks_list WHERE `parent_id` = '" . $parent_id . "' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $list = $this->db->loadObjectList();

        return $list;
    }

    public function getLayoutSpecificTaskAPISelect() {
        $lang = $_REQUEST['lang'];

        if ($lang == 'is') {
            $this->lang->setLanguage('is-IS');
            $this->lang->load();
        }

        $user_id = (int) $_REQUEST['user_id'];

        $password_raw = $this->db->escape(trim($_REQUEST['password_for_verify']));
        $password = $this->decrypt($password_raw);

        $pass = $password;

        $user = JFactory::getUser((int) $user_id);
        $query = "SELECT * FROM #__users WHERE `password2` = '" . $pass . "' AND `owner_id` = '" . $user->owner_id . "'";
        $this->db->setQuery($query);
        $select_user_by_password = $this->db->loadObject();

        $user_by_password = JFactory::getUser((int) $select_user_by_password->id);

        $query = "SELECT * FROM #__users WHERE `owner_id` = '" . $user->owner_id . "' AND password2 = '" . $pass . "'";
        $this->db->setQuery($query);
        $userlist = $this->db->loadAssoc();

        if (is_array($userlist)) {
            $userlist = $userlist['id'];
        } else {
            $userlist = '';
        }

        $password_correct = '0';
        if (!empty($select_user_by_password)) {
            $password_correct = '1';
        }

        $token = $user_by_password->api_token;
        $result = $this->apiGetTaskList($token);
        //return $result;

        if (!empty($result->result)) {
            $prepare_task_list_array = [];
            $i = 0;
            foreach ($result->result as $one_task) {
                if (!empty($one_task->field4)) {
                    if ($one_task->start == '0') {
                        $start_stop_mode = 'start_co';
                    } elseif ($one_task->start == '1') {
                        $start_stop_mode = 'stop_co';
                    }

                    $prepare_task_list_array[$i]['task_id'] = $one_task->id;
                    $prepare_task_list_array[$i]['task_text'] = $one_task->field4;
                    $prepare_task_list_array[$i]['task_field2'] = $one_task->field2;
                    $prepare_task_list_array[$i]['task_unit'] = $one_task->unit;
                    $prepare_task_list_array[$i]['task_field3'] = $one_task->field3;
                    $prepare_task_list_array[$i]['task_start'] = $one_task->start;
                }

                $i++;
            }
        }


        return [
            'result' => $prepare_task_list_array,
            'response' => $result->result
        ];
    }

    private function apiGetTaskList($token) {
        if ($curl = curl_init()) {
            //prepare password from api
            $prepare_passw = $this->preparePassw($this->password_api_old);

            $options = [
                CURLOPT_URL => empty($_SERVER['HTTPS']) ? 'http://' : 'https://' . $_SERVER['SERVER_NAME'] . '/api/api.php',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => [
                    'passw' => $prepare_passw,
                    'action' => 'getTaskList',
                    'token' => $token
                ],
            ];

            curl_setopt_array($curl, $options);
            $out = curl_exec($curl);

            curl_close($curl);

            return json_decode($out);
        } else {
            exit('Curl not init');
        }
    }

    public function getUserMode() {
        $user_id = (int) $_REQUEST['user_id'];


        $current_date = date('Y-m-d');
        $query = "SELECT * FROM #__audit_time WHERE `id_user` = '$user_id' AND `date`='" . $current_date . "' AND `date_exit`='0000-00-00 00:00:00' ORDER BY `id` DESC LIMIT 0, 1";
        $this->db->setQuery($query);
        $rez = $this->db->loadObjectList();
        //print_r($res);

        if (!empty($rez)) {
            $res = '1';
        } else {
            $res = '0';
        }
        return $res;
    }

    /* public function logout() {

      } */

    public function startCOTaskAPI() {
        $user_id = (int) $_REQUEST['user_id'];
        $lang = $this->db->escape(trim($_REQUEST['lang']));

        $password_raw = $this->db->escape(trim($_REQUEST['password_for_verify']));
        $password = $this->decrypt($password_raw);

        $task_id = (int) $_REQUEST['task_id'];
        $hours = $this->db->escape(trim($_REQUEST['hours']));
        $unit = $this->db->escape(trim($_REQUEST['unit']));
        $item = $this->db->escape(trim($_REQUEST['item']));
        $mode = $this->db->escape(trim($_REQUEST['mode']));
        $lat = $this->db->escape(trim($_REQUEST['lat']));
        $lng = $this->db->escape(trim($_REQUEST['lng']));

        //$res=$model->startCOTaskAPI($password, $user_id, $task_id, $hours, $unit, $item, $mode, $lat, $lng);

        if ($lang == 'is') {
            $this->lang->setLanguage('is-IS');
            $this->lang->load();
        }

        $pass = $password;

        $user = JFactory::getUser((int) $user_id);

        $query = "SELECT * FROM #__users WHERE `password2` = '" . $pass . "' AND `owner_id` = '" . $user->owner_id . "'";
        $this->db->setQuery($query);
        $select_user_by_password = $this->db->loadObject();

        $user_by_password = JFactory::getUser((int) $select_user_by_password->id);
        $token = $user_by_password->api_token;


        if (!empty($select_user_by_password)) {
            if ($curl = curl_init()) {
                //prepare password from api
                $prepare_passw = $this->preparePassw($this->password_api_old);

                $options = [
                    CURLOPT_URL => empty($_SERVER['HTTPS']) ? 'http://' : 'https://' . $_SERVER['SERVER_NAME'] . '/api/api.php',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_POST => true,
                    CURLOPT_POSTFIELDS => [
                        'passw' => $prepare_passw,
                        'action' => 'startCOTime',
                        'token' => $token,
                        'id' => $task_id,
                        'hours' => $hours,
                        'unit' => $unit,
                        'item' => $item,
                        'mode' => $mode,
                        'lat' => $lat,
                        'lng' => $lng
                    ]
                ];

                curl_setopt_array($curl, $options);
                $out = curl_exec($curl);

                curl_close($curl);
            } else {
                exit('Curl not init');
            }
        }

        return [
            'res' => $out,
            'lang' => $lang,
            'task_id' => $task_id,
            'mode' => $mode,
            'lat' => $lat,
            'lng' => $lng
        ];

      
    }
    
    public function saveState() {
        $user_id = (int) $_REQUEST['user_id'];
        $lang = $this->db->escape(trim($_REQUEST['lang']));

        $password_raw = $this->db->escape(trim($_REQUEST['password_for_verify']));
        $password = $this->decrypt($password_raw);

        $task_id = (int) $_REQUEST['task_id'];
        $hours = $this->db->escape(trim($_REQUEST['hours']));
        $unit = $this->db->escape(trim($_REQUEST['unit']));
        $item = $this->db->escape(trim($_REQUEST['item']));

        if ($lang == 'is') {
            $this->lang->setLanguage('is-IS');
            $this->lang->load();
        }

        $pass = $password;

        $user = JFactory::getUser((int) $user_id);

        $query = "SELECT * FROM #__users WHERE `password2` = '" . $pass . "' AND `owner_id` = '" . $user->owner_id . "'";
        $this->db->setQuery($query);
        $select_user_by_password = $this->db->loadObject();

        $user_by_password = JFactory::getUser((int) $select_user_by_password->id);
        $token = $user_by_password->api_token;
        
 

        if (!empty($select_user_by_password)) {
            if ($curl = curl_init()) {
                //prepare password from api
                $prepare_passw = $this->preparePassw($this->password_api_old);

                $options = [
                    CURLOPT_URL => empty($_SERVER['HTTPS']) ? 'http://' : 'https://' . $_SERVER['SERVER_NAME'] . '/api/api.php',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_POST => true,
                    CURLOPT_POSTFIELDS => [
                        'passw' => $prepare_passw,
                        'action' => 'addFieldToTask',
                        'token' => $token,
                        'id' => $task_id,
                        'hours' => $hours,
                        'unit' => $unit,
                        'item' => $item,
                       
                    ]
                ];

                curl_setopt_array($curl, $options);
                $out = curl_exec($curl);

                curl_close($curl);
            } else {
                exit('Curl not init');
            }
        }

       return [
            'res' =>  $out,
            'lang' => $lang,
            'task_id' => $task_id,
           
        ];
  
    }
    
    public function saveSessionImages()
    {
        $jinput = JFactory::getApplication()->input;
		
		
        
        $token_raw = trim($_REQUEST['user_token']);
        $user_token = $this->decrypt($token_raw);     
        $system_mode=$this->getSystemMode();
        $user_obj=$this->getUserByToken($user_token);
        $session_date=$jinput->get('session_date', '', 'STRING');
        
        if($system_mode=='confirm'){
           $res=$this->checkAndUploadFilesConfirm($_FILES, $user_obj, $session_date);
        } elseif($system_mode=='pay_period'){
            $res=$this->checkAndUploadFilesPayPeriod($_FILES, $user_obj, $session_date);
        }
        
        return $res;
    }
    
    private function checkAndUploadFilesConfirm($files, $user_obj, $session_date)
    {
		
		
        if(!empty($files['file_start']) || !empty($files['file_stop'])){
            $res=$this->uploadImg($files, 8000000, $user_obj, $session_date);
            //return 'success, uploading';
        } else{
            $res='upload one file';
        }
        
        return $res;
    }
    
    private function checkAndUploadFilesPayPeriod($files, $user_obj, $session_date)
    {
        if(!empty($files['file_start']) || !empty($files['file_stop'])){
            $res=$this->uploadImgPayPeriod($files, 8000000, $user_obj, $session_date);
            //return 'success, uploading';
        } else{
            $res='upload one file';
        }
        
        return $res;
    }
    
    public function uploadImgPayPeriod($files_array, $max_img_size, $user_obj, $session_date)
    {
       $rezult=false;
            $array_normal_uploadfiles=[];
            $i=0;
            
            foreach($files_array as $k=>$v)
            {
                $one_file_start_or_stop=(array)$v;
                
                $tmp_name=$one_file_start_or_stop['tmp_name'];
                $unikal_hash=md5(uniqid(rand(), true));
                $info = new SplFileInfo($one_file_start_or_stop['name']);
                $file_ext=$info->getExtension();
                
                //filename= start--userToken_sessionDate_hash_.extension
                if($k==='file_start'){
                    $uploadfile_art=$_SERVER['DOCUMENT_ROOT']."/images/pay_period_start_images/start--".$user_obj->api_token.'_'.$session_date.'_'.$unikal_hash."_.".$file_ext;
                }
                //filename= stop--userToken_sessionDate_hash_.extension
                if($k==='file_stop'){
                    $uploadfile_art=$_SERVER['DOCUMENT_ROOT']."/images/pay_period_stop_images/stop--".$user_obj->api_token.'_'.$session_date.'_'.$unikal_hash."_.".$file_ext;
                }
               
                $file_type=$one_file_start_or_stop['type'];
                $real_img_size=$one_file_start_or_stop['size'];
                
                if($k==='file_start' || $k==='file_stop'){
                    if($this->checkFileType($tmp_name)==true){//open file and check signature
                        if(($file_type == "image/jpg") || ($file_type  == "image/jpeg") || ($file_type  == "image/png") || ($file_type  == "image/gif")){//check mime types
                            if($real_img_size <= $max_img_size){//check img size
                                if(move_uploaded_file($tmp_name, $uploadfile_art)){//upload img
                                    $this->recordImageInDBPayPeriod($uploadfile_art, $k, $user_obj, $session_date);
                                }
                                $array_normal_uploadfiles[$i]=$uploadfile_art;//add uploaded files for response array
                            }
                        }
                    }
                }
                $i++;
            }
          
            return $array_normal_uploadfiles;
    }
    
    public function uploadImg($files_array, $max_img_size, $user_obj, $session_date)
    {
       $rezult=false;
            $array_normal_uploadfiles=[];
            $i=0;
            
            foreach($files_array as $k=>$v)
            {
                $one_file_start_or_stop=(array)$v;
                
                $tmp_name=$one_file_start_or_stop['tmp_name'];
                $unikal_hash=md5(uniqid(rand(), true));
                $info = new SplFileInfo($one_file_start_or_stop['name']);
                $file_ext=$info->getExtension();
                
                //filename= start--userToken_sessionDate_hash_.extension
                if($k==='file_start'){
                    $uploadfile_art=$_SERVER['DOCUMENT_ROOT']."/images/confirm_start_images/start--".$user_obj->api_token.'_'.$session_date.'_'.$unikal_hash."_.".$file_ext;
                }
                //filename= stop--userToken_sessionDate_hash_.extension
                if($k==='file_stop'){
                    $uploadfile_art=$_SERVER['DOCUMENT_ROOT']."/images/confirm_stop_images/stop--".$user_obj->api_token.'_'.$session_date.'_'.$unikal_hash."_.".$file_ext;
                }
				
				
                $file_type=$one_file_start_or_stop['type'];
                $real_img_size=$one_file_start_or_stop['size'];
                
                if($k==='file_start' || $k==='file_stop'){
                    if($this->checkFileType($tmp_name)==true){//open file and check signature
                        if(($file_type == "image/jpg") || ($file_type  == "image/jpeg") || ($file_type  == "image/png") || ($file_type  == "image/gif")){//check mime types
                            if($real_img_size <= $max_img_size){//check img size
                                if(move_uploaded_file($tmp_name, $uploadfile_art)){//upload img
                                    $this->recordImageInDBConfirm($uploadfile_art, $k, $user_obj, $session_date);
                                }
                                $array_normal_uploadfiles[$i]=$uploadfile_art;//add uploaded files for response array
                            }
                        }
                    }
                }
                $i++;
            }
          
            return $array_normal_uploadfiles;
    }
        
    private function checkFileType($file)
    {
            if (!$f = fopen($file, 'rb')) {
                return false;
            }

            $data = fread($f, 8);
            fclose($f);

            if (
                @array_pop(unpack('H12', $data)) == '474946383961' ||
                @array_pop(unpack('H12', $data)) == '474946383761'
            ) {
                return 'GIF';
            } else if (
                @array_pop(unpack('H4', $data)) == 'ffd8'
            ) {
                return 'JPEG';
            } else if (
                @array_pop(unpack('H16', $data)) == '89504e470d0a1a0a'
            ) {
                return 'PNG';
            }

            return false;
    }
        
    private function recordImageInDBConfirm($uploadfile_art, $k, $user_obj, $session_date)
    {
        $mysql_date=DateTime::createFromFormat('d.m.Y', $session_date)->format('Y-m-d');
        
        $query = "SELECT * FROM #__audit_time_confirm WHERE `id_user` = '" . $user_obj->id . "' AND `date` = '" . $mysql_date . "' ORDER BY `id` DESC LIMIT 0,1";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        if($data[0]->is_confirm==0){
            if($k==='file_start'){
                $query = "UPDATE #__audit_time_confirm SET `img_start`='$uploadfile_art' WHERE `id`= '".$data[0]->id."'";
                $this->db->setQuery($query);
                $this->db->query();
            }
            if($k==='file_stop'){ 
                $query = "UPDATE #__audit_time_confirm SET `img_stop`='$uploadfile_art' WHERE `id`= '".$data[0]->id."'";
                $this->db->setQuery($query);
                $this->db->query();
            }
        } else{
            $query = "SELECT * FROM #__audit_time WHERE `id_user` = '" . $user_obj->id . "' AND `date` = '" . $mysql_date . "' ORDER BY `id` DESC LIMIT 0,1";
            $this->db->setQuery($query);
            $data = $this->db->loadObjectList();
            
            if($k==='file_start'){
                $query = "UPDATE #__audit_time SET `img_start`='$uploadfile_art' WHERE `id`= '".$data[0]->id."'";
                $this->db->setQuery($query);
                $this->db->query();
            }
            if($k==='file_stop'){ 
                $query = "UPDATE #__audit_time SET `img_stop`='$uploadfile_art' WHERE `id`= '".$data[0]->id."'";
                $this->db->setQuery($query);
                $this->db->query();
            }
        }
        
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/api0.html', print_r($data, true), FILE_APPEND | LOCK_EX);
    }
    
    private function recordImageInDBPayPeriod($uploadfile_art, $k, $user_obj, $session_date)
    {
        $mysql_date=DateTime::createFromFormat('d.m.Y', $session_date)->format('Y-m-d');
        
        
            $query = "SELECT * FROM #__audit_time WHERE `id_user` = '" . $user_obj->id . "' AND `date` = '" . $mysql_date . "' ORDER BY `id` DESC LIMIT 0,1";
            $this->db->setQuery($query);
            $data = $this->db->loadObjectList();
            
            if($k==='file_start'){
                $query = "UPDATE #__audit_time SET `img_start`='$uploadfile_art' WHERE `id`= '".$data[0]->id."'";
                $this->db->setQuery($query);
                $this->db->query();
            }
            if($k==='file_stop'){ 
                $query = "UPDATE #__audit_time SET `img_stop`='$uploadfile_art' WHERE `id`= '".$data[0]->id."'";
                $this->db->setQuery($query);
                $this->db->query();
            }
        
        
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/api0.html', print_r($data, true), FILE_APPEND | LOCK_EX);
    }

}
