<?php
/**
 * @version    1.0.0
 * @package    com_holidays_new
 * @author     SMG <developer3452@gmil.com>
 * @copyright  2019 SMG
 * @license    GNU General Public License >=2
 */

// No direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/');
JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

// Import CSS
$document = JFactory::getDocument();
$document->addStyleSheet(JUri::root() . 'administrator/components/com_holidays_new/assets/css/gmap.css');
$document->addStyleSheet(JUri::root() . 'media/com_holidays_new/css/list.css');

$user      = JFactory::getUser();
$userId    = $user->get('id');
$listOrder = $this->state->get('list.ordering');
$listDirn  = $this->state->get('list.direction');
$canOrder  = $user->authorise('core.edit.state', 'com_holidays_new');
$saveOrder = $listOrder == 'a.`ordering`';
$db = & JFactory::getDBO();
if ($saveOrder)
{
	$saveOrderingUrl = 'index.php?option=com_holidays_new&task=items.saveOrderAjax&tmpl=component';
	JHtml::_('sortablelist.sortable', 'itemList', 'adminForm', strtolower($listDirn), $saveOrderingUrl);
}

$sortFields = $this->getSortFields();



$folder1 = $_SERVER['DOCUMENT_ROOT'].'/images/gmap';
if(!is_dir($folder1)){
    mkdir($folder1, 0777);
}

$folder2 = $_SERVER['DOCUMENT_ROOT'].'/images/gmap/markers';
if(!is_dir($folder2)){
    mkdir($folder2, 0777);
}
    
$folder3 = $_SERVER['DOCUMENT_ROOT'].'/images/gmap/gmap_items';
if(!is_dir($folder3)){
    mkdir($folder3, 0777);
}

?>

<form action="<?php echo JRoute::_('index.php?option=com_holidays_new&view=items'); ?>" method="post"
	  name="adminForm" id="adminForm">
	<?php if (!empty($this->sidebar)): ?>
	<div id="j-sidebar-container" class="span2">
		<?php echo $this->sidebar; ?>
	</div>
	<div id="j-main-container" class="span10">
		<?php else : ?>
		<div id="j-main-container">
			<?php endif; ?>

            <?php echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>

			<div class="clearfix"></div>
			<table class="table table-striped" id="itemList">
				<thead>
				<tr>
					<?php if (isset($this->items[0]->ordering)): ?>
						<th width="1%" class="nowrap center hidden-phone">
							<?php echo JHtml::_('searchtools.sort', '#', 'a.`ordering`', $listDirn, $listOrder); ?>
						</th>
					<?php endif; ?>
					<th width="1%" class="hidden-phone">
						<input type="checkbox" name="checkall-toggle" value=""
							   title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)"/>
					</th>
					<?php if (isset($this->items[0]->state)): ?>
						<th width="1%" class="nowrap center">
								<?php echo JHtml::_('searchtools.sort', 'JSTATUS', 'a.`state`', $listDirn, $listOrder); ?>
</th>
					<?php endif; ?>

									<th class='left'>
				<?php echo JHtml::_('searchtools.sort',  'COM_GMAP_ITEMS_ID', 'a.`id`', $listDirn, $listOrder); ?>
				</th>
                                
				<th class='left'>
				<?php echo JHtml::_('searchtools.sort',  'COM_GMAP_ITEMS_NAME', 'a.`name`', $listDirn, $listOrder); ?>
				</th>
				<th class='left'>
				<?php echo JHtml::_('searchtools.sort',  'COM_GMAP_ITEMS_DESCRIPTION', 'a.`description`', $listDirn, $listOrder); ?>
				</th>
<!--				<th class='left'>
				<?php echo JHtml::_('searchtools.sort',  'COM_GMAP_ITEMS_IMAGE', 'a.`image`', $listDirn, $listOrder); ?>
				</th>-->
				<th class='left'>
				<?php echo JHtml::_('searchtools.sort',  'COM_GMAP_ITEMS_ADDRESS', 'a.`address`', $listDirn, $listOrder); ?>
				</th>
                                <th class='left'>
				<?php echo JHtml::_('searchtools.sort',  'COM_GMAP_ITEMS_LATITUDE', 'a.`latitude`', $listDirn, $listOrder); ?>
				</th>
				<th class='left'>
				<?php echo JHtml::_('searchtools.sort',  'COM_GMAP_ITEMS_LONGITUDE', 'a.`longitude`', $listDirn, $listOrder); ?>
				</th>
				<th class='left'>
                                <?php echo JHtml::_('searchtools.sort',  'Category', 'a.`catid`', $listDirn, $listOrder); ?>
                                </th>    
				<th class='left'>
				<?php echo JHtml::_('searchtools.sort',  'COM_GMAP_ITEMS_MARKER', 'a.`marker`', $listDirn, $listOrder); ?>
				</th>

					
				</tr>
				</thead>
				<tfoot>
				<tr>
					<td colspan="<?php echo isset($this->items[0]) ? count(get_object_vars($this->items[0])) : 10; ?>">
						<?php echo $this->pagination->getListFooter(); ?>
					</td>
				</tr>
				</tfoot>
				<tbody>
				<?php
				/*echo '<pre>';
				print_r($this->items);
				echo '</pre>';*/
				?>
				<?php foreach ($this->items as $i => $item) :
					$ordering   = ($listOrder == 'a.ordering');
					$canCreate  = $user->authorise('core.create', 'com_holidays_new');
					$canEdit    = $user->authorise('core.edit', 'com_holidays_new');
					$canCheckin = $user->authorise('core.manage', 'com_holidays_new');
					$canChange  = $user->authorise('core.edit.state', 'com_holidays_new');
					?>
					<tr class="row<?php echo $i % 2; ?>">

						<?php if (isset($this->items[0]->ordering)) : ?>
							<td class="order nowrap center hidden-phone">
								<?php if ($canChange) :
									$disableClassName = '';
									$disabledLabel    = '';

									if (!$saveOrder) :
										$disabledLabel    = JText::_('JORDERINGDISABLED');
										$disableClassName = 'inactive tip-top';
									endif; ?>
									<span class="sortable-handler hasTooltip <?php echo $disableClassName ?>"
										  title="<?php echo $disabledLabel ?>">
							<i class="icon-menu"></i>
						</span>
									<input type="text" style="display:none" name="order[]" size="5"
										   value="<?php echo $item->ordering; ?>" class="width-20 text-area-order "/>
								<?php else : ?>
									<span class="sortable-handler inactive">
							<i class="icon-menu"></i>
						</span>
								<?php endif; ?>
							</td>
						<?php endif; ?>
						<td class="hidden-phone">
							<?php echo JHtml::_('grid.id', $i, $item->id); ?>
						</td>
						<?php if (isset($this->items[0]->state)): ?>
							<td class="center">
								<?php echo JHtml::_('jgrid.published', $item->state, $i, 'items.', $canChange, 'cb'); ?>
</td>
						<?php endif; ?>

										<td>

					<?php echo $item->id; ?>
				</td>	
                               
                                <td>
				<?php if (isset($item->checked_out) && $item->checked_out && ($canEdit || $canChange)) : ?>
					<?php echo JHtml::_('jgrid.checkedout', $i, $item->uEditor, $item->checked_out_time, 'items.', $canCheckin); ?>
				<?php endif; ?>
				<?php if ($canEdit) : ?>
					<a href="<?php echo JRoute::_('index.php?option=com_holidays_new&task=item.edit&id='.(int) $item->id); ?>">
					<?php echo $this->escape($item->name); ?></a>
				<?php else : ?>
					<?php echo $this->escape($item->name); ?>
				<?php endif; ?>

				</td>				<td>

					<?php echo mb_substr($item->description, 0, 50) ; ?>
				</td>				
<!--                                <td>

					<?php echo $item->image; ?>
				</td>-->				
                                <td>

					<?php echo $item->address; ?>
				</td>	
                                <td>
                                <?php echo $item->latitude; ?>
				</td>				
                                
                                
                                <td>

					<?php echo $item->longitude; ?>
				</td>
                                 <td>
                                     <?php 
                                        $db->setQuery("SELECT * FROM #__categories WHERE id = '$item->catid' AND extension='com_holidays_new'");
                                        $db->query();
                                        $category = $db->loadObject();
										
                                       /*echo '<pre>';
				print_r($category);
				echo '</pre>';*/
                                     ?>
                                    <a href="index.php?option=com_categories&task=category.edit&id=<?=$category->id?>&extension=com_holidays_new"><?=$category->title?></a>
                                </td>
                                <td>
                                        <?php 
                                          $param = json_decode($category->params);
                                          if(!empty($param->image)){
                                             $item->marker = $param->image;
                                          }
                                        ?>
					<img style="width:15px;" src="/<?php echo $item->marker; ?>">
				</td>

					</tr>
				<?php endforeach; ?>
				</tbody>
			</table>

			<input type="hidden" name="task" value=""/>
			<input type="hidden" name="boxchecked" value="0"/>
            <input type="hidden" name="list[fullorder]" value="<?php echo $listOrder; ?> <?php echo $listDirn; ?>"/>
			<?php echo JHtml::_('form.token'); ?>
		</div>
</form>        
