<?php
/**
 * @version    1.0.0
 * @package    com_holidays_new
 * @author     SMG <developer3452@gmil.com>
 * @copyright  2019 SMG
 * @license    GNU General Public License >=2
 */
// No direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
JHtml::_('formbehavior.chosen', 'select');
JHtml::_('behavior.keepalive');

// Import CSS
$document = JFactory::getDocument();
$document->addStyleSheet(JUri::root() . 'media/com_holidays_new/css/form.css');
$app = &JFactory::getApplication();
$params = JComponentHelper::getParams('com_holidays_new');
$api_key = $params->get('key_map');


?>
<script type="text/javascript">
	js = jQuery.noConflict();
	js(document).ready(function () {
		
	});

	Joomla.submitbutton = function (task) {
		if (task == 'item.cancel') {
			Joomla.submitform(task, document.getElementById('item-form'));
		}
		else {
			
			if (task != 'item.cancel' && document.formvalidator.isValid(document.id('item-form'))) {
				
				Joomla.submitform(task, document.getElementById('item-form'));
			}
			else {
				alert('<?php echo $this->escape(JText::_('JGLOBAL_VALIDATION_FORM_FAILED')); ?>');
			}
		}
	}
</script>

<form
	action="<?php echo JRoute::_('index.php?option=com_holidays_new&layout=edit&id=' . (int) $this->item->id); ?>"
	method="post" enctype="multipart/form-data" name="adminForm" id="item-form" class="form-validate">

	<div class="form-horizontal">
		<?php echo JHtml::_('bootstrap.startTabSet', 'myTab', array('active' => 'general')); ?>

		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'general', JText::_('COM_GMAP_TITLE_ITEM', true)); ?>
		<div class="row-fluid">
			<div class="span10 form-horizontal">
				<fieldset class="adminform">

				<input type="hidden" name="jform[id]" value="<?php echo $this->item->id; ?>" />
				<input type="hidden" name="jform[ordering]" value="<?php echo $this->item->ordering; ?>" />
				<input type="hidden" name="jform[state]" value="<?php echo $this->item->state; ?>" />
				<input type="hidden" name="jform[checked_out]" value="<?php echo $this->item->checked_out; ?>" />
				<input type="hidden" name="jform[checked_out_time]" value="<?php echo $this->item->checked_out_time; ?>" />

				<?php echo $this->form->renderField('created_by'); ?>
				<?php echo $this->form->renderField('modified_by'); ?>				
                                <?php echo $this->form->renderField('name'); ?>
                                <?php echo $this->form->renderField('link'); ?>
				<?php echo $this->form->renderField('description'); ?>
                                <?php echo $this->form->renderField('catid'); ?>
				<?php echo $this->form->renderField('image'); ?>
				<?php echo $this->form->renderField('address'); ?>
                                <?php echo $this->form->renderField('latitude'); ?>
				<?php echo $this->form->renderField('longitude'); ?>
				
                                <?php echo $this->form->renderField('upload_marker'); ?>
				<?php echo $this->form->renderField('marker'); ?>


					<?php if ($this->state->params->get('save_history', 1)) : ?>
					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('version_note'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('version_note'); ?></div>
					</div>
					<?php endif; ?>
				</fieldset>
			</div>
		</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		

		<?php echo JHtml::_('bootstrap.endTabSet'); ?>

		<input type="hidden" name="task" value=""/>
		<?php echo JHtml::_('form.token'); ?>

	</div>
</form>
<?php if(!empty($api_key)): ?>
<script src="https://maps.googleapis.com/maps/api/js?key=<?=$api_key?>&signed_in=true&libraries=places&callback=initAutocomplete&language=en" async defer></script>
<?php endif; ?>
<script>
var placeSearch, autocomplete;
var componentForm = {
  street_number: 'short_name',
  route: 'long_name',
  locality: 'long_name',
  administrative_area_level_1: 'short_name',
  country: 'long_name',
  postal_code: 'short_name'
};

function initAutocomplete() {
 geocoder = new google.maps.Geocoder();
  autocomplete = new google.maps.places.Autocomplete(
      (document.getElementById('jform_address')),
      {types: ['geocode']});

  autocomplete.addListener('place_changed', fillInAddress);
  jQuery('#jform_address').keyup(function(){
      codeAddress();
  });

}

function codeAddress() {
    var address = document.getElementById("jform_address").value;
    geocoder.geocode( { 'address': address}, function(results, status) {
      if (status == google.maps.GeocoderStatus.OK) {
//        map.setCenter(results[0].geometry.location);
//        var marker = new google.maps.Marker({
//            map: map,
//            position: results[0].geometry.location
//        });
        if(address!=''){
            var lat = results[0].geometry.location.lat();
            var lng = results[0].geometry.location.lng();
            jQuery('#jform_latitude').val(lat);
            jQuery('#jform_longitude').val(lng);
        }
        

      } else {
        //alert("Geocode was not successful for the following reason.");
      }
    });
}

function fillInAddress() {

  var place = autocomplete.getPlace();
  var lat = place.geometry.location.lat();
  var lng = place.geometry.location.lng();
  
  jQuery('#jform_latitude').val(lat);
  jQuery('#jform_longitude').val(lng);
  
  //jQuery('#open-map').show();

  for (var component in componentForm) {
    document.getElementById(component).value = '';
    document.getElementById(component).disabled = false;
  }

  for (var i = 0; i < place.address_components.length; i++) {
    var addressType = place.address_components[i].types[0];
    if (componentForm[addressType]) {
      var val = place.address_components[i][componentForm[addressType]];
      document.getElementById(addressType).value = val;
    }
  }
}

function geolocate() {
  if (navigator.geolocation) {
    navigator.geolocation.getCurrentPosition(function(position) {
      var geolocation = {
        lat: position.coords.latitude,
        lng: position.coords.longitude
      };
      var circle = new google.maps.Circle({
        center: geolocation,
        radius: position.coords.accuracy
      });
      autocomplete.setBounds(circle.getBounds());
    });
  }
}
</script>  
