<?php
/**
 * @version    1.0.0
 * @package    com_holidays_new
 * @author     SMG <developer3452@gmil.com>
 * @copyright  2019 SMG
 * @license    GNU General Public License >=2
 */
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

jimport('joomla.form.formfield');

class JFormFieldMapkey extends JFormField {

    protected $type = 'mapkey';

    public function getInput() {
        $params = JComponentHelper::getParams('com_holidays_new');
        $api_key = $params->get('key_map');

        $script = "<script>
          
            var placeSearch, autocomplete;
            var componentForm = {
              street_number: 'short_name',
              route: 'long_name',
              locality: 'long_name',
              administrative_area_level_1: 'short_name',
              country: 'long_name',
              postal_code: 'short_name'
            };

            function initAutocomplete() {
             geocoder = new google.maps.Geocoder();
              autocomplete = new google.maps.places.Autocomplete(
                  (document.getElementById('jform_country')),
                  {types: ['geocode']});

              autocomplete.addListener('place_changed', fillInAddress);
              jQuery('#jform_country').keyup(function(){
                  codeAddress();
              });

            }

            function codeAddress() {
                var address = document.getElementById('jform_country').value;
                geocoder.geocode( { 'address': address}, function(results, status) {
                  if (status == google.maps.GeocoderStatus.OK) {
                    if(address!=''){
                        var lat = results[0].geometry.location.lat();
                        var lng = results[0].geometry.location.lng();
                        jQuery('#jform_country_lat').val(lat);
                        jQuery('#jform_country_lng').val(lng);
                    }


                  } else {
                    alert('Geocode was not successful for the following reason.');
                  }
                });
            }

            function fillInAddress() {

              var place = autocomplete.getPlace();
              var lat = place.geometry.location.lat();
              var lng = place.geometry.location.lng();

              jQuery('#jform_country_lat').val(lat);
              jQuery('#jform_country_lng').val(lng);

              //jQuery('#open-map').show();

              for (var component in componentForm) {
                document.getElementById(component).value = '';
                document.getElementById(component).disabled = false;
              }

              for (var i = 0; i < place.address_components.length; i++) {
                var addressType = place.address_components[i].types[0];
                if (componentForm[addressType]) {
                  var val = place.address_components[i][componentForm[addressType]];
                  document.getElementById(addressType).value = val;
                }
              }
            }

            function geolocate() {
              if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function(position) {
                  var geolocation = {
                    lat: position.coords.latitude,
                    lng: position.coords.longitude
                  };
                  var circle = new google.maps.Circle({
                    center: geolocation,
                    radius: position.coords.accuracy
                  });
                  autocomplete.setBounds(circle.getBounds());
                });
              }
            }
            </script>";

        return '<script src="https://maps.googleapis.com/maps/api/js?key=' . $api_key . '&signed_in=true&libraries=places&callback=initAutocomplete" async defer></script>' . $script;
    }

}
