<?php
/**
 * @version    1.0.0
 * @package    com_holidays_new
 * @author     SMG <developer3452@gmil.com>
 * @copyright  2019 SMG
 * @license    GNU General Public License >=2
 */
// No direct access
defined('_JEXEC') or die;

/**
 * Gmap helper.
 *
 * @since  1.6
 */
class com_holidays_newHelper
{
	/**
	 * Configure the Linkbar.
	 *
	 * @param   string  $vName  string
	 *
	 * @return void
	 */
	public static function addSubmenu($vName = '')
	{
		JHtmlSidebar::addEntry(
			JText::_('COM_GMAP_TITLE_ITEMS'),
			'index.php?option=com_gmap&view=items',
			$vName == 'items'
		);
                
                JHtmlSidebar::addEntry(
			JText::_('Categories'),
			'index.php?option=com_categories&view=categories&extension=com_gmap',
			$vName == 'categories'
		);
                JHtmlSidebar::addEntry(
			JText::_('Gmap Configuration'),
			'index.php?option=com_config&view=component&component=com_gmap',
			$vName == 'component'
		);

	}

	/**
	 * Gets the files attached to an item
	 *
	 * @param   int     $pk     The item's id
	 *
	 * @param   string  $table  The table's name
	 *
	 * @param   string  $field  The field's name
	 *
	 * @return  array  The files
	 */
	public static function getFiles($pk, $table, $field)
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query
			->select($field)
			->from($table)
			->where('id = ' . (int) $pk);

		$db->setQuery($query);

		return explode(',', $db->loadResult());
	}

	/**
	 * Gets a list of the actions that can be performed.
	 *
	 * @return    JObject
	 *
	 * @since    1.6
	 */
	public static function getActions()
	{
		$user   = JFactory::getUser();
		$result = new JObject;

		$assetName = 'com_gmap';

		$actions = array(
			'core.admin', 'core.manage', 'core.create', 'core.edit', 'core.edit.own', 'core.edit.state', 'core.delete'
		);

		foreach ($actions as $action)
		{
			$result->set($action, $user->authorise($action, $assetName));
		}

		return $result;
	}
}

