<?php

// No direct access
defined('_JEXEC') or die;

/**
 * @author 
 */
class HolidayModelHolidays extends JModelList {

    /**
     * Конструктор класса
     * @param Array $config
     */
    public function __construct($config = array()) {
        if (empty($config['filter_fields'])) {
            $config['filter_fields'] = array('title', 'state', 'ordering', 'created_by', 'created', 'id', 'author_id');
        }
        $this->db=&JFactory::getDBO();
        parent::__construct($config);
    }

    /**
     * @param String $ordering
     * @param String $direction
     */
    protected function populateState($ordering = null, $direction = null) {
        if ($layout = JFactory::getApplication()->input->get('layout')) {
            $this->context .= '.' . $layout;
        }
        $search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
        $this->setState('filter.search', $search);
        $published = $this->getUserStateFromRequest($this->context . '.filter.published', 'filter_published', '');
        $this->setState('filter.published', $published);
        $authorId = $this->getUserStateFromRequest($this->context . '.filter.author_id', 'filter_author_id');
        $this->setState('filter.author_id', $authorId);
        parent::populateState('id', 'asc');
    }

    /**
     * @param string $id
     * @return string
     */
    protected function getStoreId($id = '') {
        $id .= ':' . $this->getState('filter.search');
        $id .= ':' . $this->getState('filter.published');
        $id .= ':' . $this->getState('filter.author_id');
        return parent::getStoreId($id);
    }

    /**
     * Составление запроса для получения списка записей
     * @return JDatabaseQuery
     */
    protected function getListQuery() {
        $query = $this->getDbo()->getQuery(true);
        $query->select('t1.id, t1.title, t1.alias, t1.date, t1.date2, t1.start_time, t1.end_time, t1.published as state, t1.created, t1.ordering, t1.hits, t1.holidays_type_90, t1.holidays_type_45');
        $query->select('u.username as created_by, u.id as author_id');
        $query->join('LEFT', '#__users AS u ON u.id = t1.created_by');
        $query->from('#__holiday as t1');
        $published = $this->getState('filter.published');
        if (is_numeric($published)) {
            $query->where('t1.published=' . (int) $published);
        }
        $authorId = $this->getState('filter.author_id');
        if (is_numeric($authorId)) {
            $query->where('u.id=' . $authorId);
        }
        $search = $this->getState('filter.search');
        if (!empty($search)) {
            $search = $this->getDbo()->Quote('%' . $this->getDbo()->escape($search, true) . '%');
            $query->where('(t1.title LIKE ' . $search . ' OR t1.alias LIKE ' . $search . ')');
        }

        /* $to1 = 'developer3452@gmail.com';
          $subject = 'Ultima holidays';

          $headers = "From: info@curiotime.com\r\n";
          //$headers .= "Reply-To: ". strip_tags($_POST['req-email']) . "\r\n";
          //$headers .= "CC: susan@example.com\r\n";
          $headers .= "MIME-Version: 1.0\r\n";
          $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
          $message = '<pre>'.print_r('dd', true).'</pre>';
          mail($to1, $subject, $message, $headers); */

        $orderCol = $this->state->get('list.ordering');
        $orderDirn = $this->state->get('list.direction');
        $query->order($this->getDbo()->escape($orderCol . ' ' . $orderDirn));
        return $query;
    }

    /**
     * Авторы записей
     * @return    JDatabaseQuery
     */
    public function getAuthors() {
        $query = $this->getDbo()->getQuery(true);
        $query->select('u.id AS value, u.name AS text');
        $query->from('#__users AS u');
        $query->join('INNER', '#__holiday AS c ON c.created_by = u.id');
        $query->group('u.id, u.name');
        $query->order('u.name');
        return $this->getDbo()->setQuery($query)->loadObjectList();
    }

    public function saveHolidaysType($id, $mode) {
        $item = new stdClass;
        $item->id = (int)$id;
        
        if($mode=='45'){
            $item->holidays_type_90 = '0';
            $item->holidays_type_45 = '1';
        } elseif($mode=='90'){
            $item->holidays_type_45 = '0';
            $item->holidays_type_90 = '1';
        }

        return $this->db->updateObject('#__holiday', $item, 'id');
    }
    
    public function saveHolidaysDateTime($id, $val, $mode) {
        $item = new stdClass;
        $item->id = (int)$id;
        $val_arr=explode(' ', $val);
        
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/admin_com_holiday.html', print_r($val_arr, true), FILE_APPEND | LOCK_EX);
        
        /*try{
            $date=DateTime::createFromFormat('d.m.Y', $val_arr[0]);
            $item->date=$date->format('Y-m-d');
        } catch (Exception $ex) {
            return $item->date;
        }*/
        $final_date_arr=explode('.', $val_arr[0]);
        $final_date=trim($final_date_arr[2]).'-'.trim($final_date_arr[1]).'-'.trim($final_date_arr[0]);
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/admin_com_holiday.html', print_r($final_date, true), FILE_APPEND | LOCK_EX);
         
        if($mode=='end'){
           $item->end_time=trim($val_arr[1]);
           $item->date2=$final_date; 
        } else{
           $item->start_time=trim($val_arr[1]);
           $item->date=$final_date; 
        }
        
        
        

        $this->db->updateObject('#__holiday', $item, 'id');
        
       
        return [
            'res'=>$val
        ];
    }

}
