<?php
defined('_JEXEC') or die('Restricted access');
jimport('joomla.application.component.modelitem');

ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(0);

class CtapiModelApi extends JModelItem {
    private $db;
    
    public $companyModsTableName  =  "#__api_company_mods";
    
    public function __construct() {
        $this->db = JFactory::getDBO();
    }
    
    private $defaults  =  array(
        'user_limit' => 0
    );
    
    
    public function setDefaultModules(...$a) {
        $args = func_get_args();
        
        $company =  $args[0];
        $reg_type = $args[1];
        
       
        $mods   =  [];
        $config = JFactory::getConfig();
        $current_url_config = $config->get('current_url');
        $current_home_path = $config->get('current_home_path');
        
        $enable_api_blocking_by_option_from_admin_panel = $config->get('enable_api_blocking_by_option_from_admin_panel');
        $default_schedules_checkbox_in_company_mods_state = $config->get('default_schedules_checkbox_in_company_mods_state');
        if(is_null($default_schedules_checkbox_in_company_mods_state)){
            $default_schedules_checkbox_in_company_mods_state = 1;
        }
        //file_put_contents($current_home_path. '/logs/curio_schedules.html', print_r($_REQUEST, true), FILE_APPEND | LOCK_EX);
        
        $app = JFactory::getApplication();
        $task = $app->input->getString('task');
        $enable_curio_schedules = $app->input->getString('enable_curio_schedules');
        
       /*file_put_contents($current_home_path . '/logs/curio_schedules.html', print_r('$_REQUEST:', true), FILE_APPEND | LOCK_EX);
        file_put_contents($current_home_path . '/logs/curio_schedules.html', print_r($_REQUEST, true), FILE_APPEND | LOCK_EX);
        file_put_contents($current_home_path . '/logs/curio_schedules.html', print_r('$enable_curio_schedules:' . $enable_curio_schedules . PHP_EOL, true), FILE_APPEND | LOCK_EX);
       */
        /*if ($enable_curio_schedules == 'on') {
                    $mods['enable_app'] = 1;
                    $mods['confirmation'] = 0;
                    $mods['holiday'] = 0;
                    $mods['pay_period'] = 1;
                    $mods['camera_kiost'] = 0;
                    $mods['enable_calculator'] = 0;
                    $mods['enable_co'] = 0;
                    $mods['enable_app_camera'] = 0;
                    $mods['enable_task_manager'] = 1;
                    $mods['enable_rules'] = 1;
                    $mods['enable_dk_save'] = 1;
                    $mods['user_limit'] = 0;
                    $mods['shifts'] = (int) $default_schedules_checkbox_in_company_mods_state;
                    $mods['maximum_limited_company'] = 0;
                    $mods['editable_login_and_exit_h'] = 0;
                    
                    break;
                }*/
        switch($reg_type){
           
            default:
                 
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/on_user_after_save.html', print_r('default in switch', true), FILE_APPEND | LOCK_EX);
                if (in_array($current_url_config, [
                    'https://rafis.curiotime.com', 
                    'https://rafis.curiotime.com/', 
                    'https://hlif.curiotime.com/', 
                    'https://hlif.curiotime.com', 
                    
                    'https://www.vlfhlif.curiotime.com/', 
                    'https://www.vlfhlif.curiotime.com',
                    'https://vlfhlif.curiotime.com/', 
                    'https://vlfhlif.curiotime.com',
                    
                    'https://newdev.curiotime.com', 
                    'https://newdev.curiotime.com/'
                ])) {
                    if ($enable_api_blocking_by_option_from_admin_panel == '1') {
                        $mods['enable_app'] = 1;
                    }
                    $mods['confirmation'] = 1;
                    $mods['holiday'] = 0;
                    $mods['pay_period'] = 1;
                    $mods['camera_kiost'] = 0;
                    $mods['enable_calculator'] = 1;
                    $mods['enable_co'] = 0;
                    $mods['enable_app_camera'] = 0; 
                    $mods['enable_task_manager'] = 1;
                    $mods['enable_rules'] = 1;
                    $mods['enable_dk_save'] = 1;
                    $mods['user_limit'] = 0;

                    $mods['shifts'] = (int) $default_schedules_checkbox_in_company_mods_state;
                    $mods['maximum_limited_company'] = 0;
                    $mods['editable_login_and_exit_h'] = 1;
                    break;
                }

                if($enable_api_blocking_by_option_from_admin_panel == '1'){
                    $mods['enable_app'] =   1;
                }
                $mods['confirmation']       =   1;        
      
                $mods['pay_period']         =   1;
        
                if($task == 'registerNewCompanyHome3rd'){
                    $mods['camera_kiost'] = 1;
                    $mods['holiday'] = 1;
                } else{
                    $mods['camera_kiost'] = 1;
                    $mods['holiday'] = 1;
                }
      
                $mods['enable_calculator']  =   0;
                $mods['enable_co']          =   0;
        
                $mods['enable_app_camera']  =   1;
                $mods['enable_task_manager']=   1;
                $mods['enable_rules']       =   1;
                $mods['enable_dk_save']     =   1;
                $mods['user_limit']         =   0;
                
                $mods['shifts'] = (int)$default_schedules_checkbox_in_company_mods_state;
                $mods['maximum_limited_company'] = 0;
                $mods['editable_login_and_exit_h'] = 0;
                
               
               
            break;
        }
        
      
        
        foreach ($mods as $mod => $enabled) {
            $query  =   "SELECT * FROM {$this->companyModsTableName} WHERE `company` = ".$this->db->quote($company)." AND `mod`=".$this->db->quote($mod);
            $this->db->setQuery($query);
            $item =  $this->db->loadObject();
            if(empty($item)) {
                $item = new stdClass;
                $item->id = NULL;
                $item->company = $company;
                $item->mod = $mod;
                $item->enabled = $enabled;
                $this->db->insertObject($this->companyModsTableName, $item, 'id');
            }
        }
    }
    
    
    
    public function resetCompanies() {
        $sql  =  "truncate table ".$this->companyModsTableName;
        $this->db->setQuery($sql);
        $this->db->query();
    }
    
    public function resetCompany($company) {
        $company =  trim($company);
        $sql  =  "delete from ".$this->companyModsTableName." where company = ".$this->db->quote($company);
        $this->db->setQuery($sql);
        $this->db->query();
    }
    
    public function allMods2() {
        $cache = JFactory::getCache();
        $cache->setCaching( 1 );
        return $cache->call( array( 'CtapiModelApi', '_allMods' ) );
    }
    
    public function allMods() {        
        $mods  =  array();        
        /*
        $tmp  = json_decode(file_get_contents("https://api.curiooffice.com/index.php?option=com_coapi&task=system.modules"),true);
        if(is_array($tmp))
            $mods  = $tmp;
         * 
         */
        $config = &JFactory::getConfig();
        $enable_api_blocking_by_option_from_admin_panel = $config->get('enable_api_blocking_by_option_from_admin_panel');
        $enable_prices_in_reseller_page = $config->get('enable_prices_in_reseller_page');
        
        if($enable_api_blocking_by_option_from_admin_panel == '1'){
            $mods['enable_app'] = 'Enable app';
        } if($enable_prices_in_reseller_page == '1'){
             $mods['subs_price'] = 'Fee';
        }
        
        $mods['confirmation']   =   "Confirmation page";        
        $mods['holiday']        =   "Holiday page";
        $mods['pay_period']     =   "Timesheet / Pay Period";
        $mods['camera_kiost']   =   "Camera in Kiost for CT";
        $mods['enable_calculator'] = 'Calculator';
        $mods['enable_co'] = 'CO';
        $mods['enable_app_camera'] = 'App camera';
        $mods['enable_task_manager'] = "Task manager";
        $mods['enable_rules'] = "Rules menu";
        $mods['enable_dk_save'] = "Save DK";
        $mods['user_limit'] = "User limit";
        $mods['shifts'] = "Shedules";
        $mods['maximum_limited_company'] = "ONLY Schedules APP";
        $mods['editable_login_and_exit_h'] = "Editable login/exit hours";
        
        return $mods;
    }
    
    public function getUserMods($userId) {
        $user = & JFactory::getUser($userId); 
        if(empty($user) || $user->id < 1)
            return array();        
        $company = $user->company;
        return $this->getCompanyMods($company);
    }
    
    public function getCompanies($default = 1) {
        $query  =   "SELECT company FROM #__users WHERE company IS NOT NULL AND company  <> '' order by company ASC";
        $this->db->setQuery($query);
        $list =  $this->db->loadObjectList();
        
        $companies  =  array();
        foreach ($list as $obj) {
            
            $companies[$obj->company] = [
                //'company_is_new' => $obj->company_is_new
            ];
        }
        foreach ($companies as $company=>$mods) {
            $companies[$company] = 
                //'company_is_new' => $company['company_is_new'],
                $this->getCompanyMods($company, $default)
            ;
        }
        return $companies;
    }
    
    public function checkCompanyIsNew($company) {
        $query  =   "SELECT `id`, `company`, `company_is_new`  FROM #__users WHERE `company` = '$company' AND `from_iframe`!='1' ORDER BY `id` ASC LIMIT 0,1";
        $this->db->setQuery($query);
        $info =  $this->db->loadObject();
        
        return $info;
    }
    
    public function saveNewCompany($company) {
        $query = "SELECT * FROM {$this->companyModsTableName} WHERE `company` = '$company' AND `mod`='user_limit'";
        $this->db->setQuery($query);
        $limit_mod =  $this->db->loadObjectList();
        
        $limit_from_form = 1;
        
        $fields  =  array();
        $fields[]  =  "regUserLimit3rd";
        $fields[]  =  "user_limit";
        foreach ($fields  as  $f) {
            if(isset($_REQUEST[$f])) {
                $limit_from_form  = intval($_REQUEST[$f]);
            }
        }
        
        //$limit_from_form = $app->input->getInt('regUserLimit3rd');
        
        if(count($limit_mod) == 0){
            $app = JFactory::getApplication();
            
            
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/changeUserEditForm.html', print_r('$is_3rd_form_task'.$is_3rd_form_task, true), FILE_APPEND | LOCK_EX);
            
            $item = new stdClass;
            $item->id = NULL;
            $item->company = $this->db->escape($company);
            $item->mod = 'user_limit';
            $item->enabled = $limit_from_form;
            $this->db->insertObject($this->companyModsTableName, $item, 'id');
            return 1;
        } else{
            return $limit_mod[0]->enabled;
        }
    }
    
    public function setSubsPriceForNewCompany($company) {
        $query = "SELECT * FROM {$this->companyModsTableName} WHERE `company` = '$company' AND `mod`='subs_price'";
        $this->db->setQuery($query);
        $limit_mod =  $this->db->loadObjectList();
        
        $limit_from_form = 1;
        
        $fields  =  array();
        //$fields[]  =  "regUserLimit3rd";
        $fields[]  =  "subs_price";
        foreach ($fields  as  $f) {
            if(isset($_REQUEST[$f])) {
                $limit_from_form  = intval($_REQUEST[$f]);
            }
        }
        
        //$limit_from_form = $app->input->getInt('regUserLimit3rd');
        
        if(count($limit_mod) == 0){
            $app = JFactory::getApplication();
            
            
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/changeUserEditForm.html', print_r('$is_3rd_form_task'.$is_3rd_form_task, true), FILE_APPEND | LOCK_EX);
            
            $item = new stdClass;
            $item->id = NULL;
            $item->company = $this->db->escape($company);
            $item->mod = 'subs_price';
            $item->enabled = $limit_from_form;
            //$this->db->insertObject($this->companyModsTableName, $item, 'id');
            return "";
        } else{
            return $limit_mod[0]->enabled;
        }
    }
    
    public function getCompanyMods($company, $default  =  1) {
        $allMods  =  $this->allMods();
        $query  =   "SELECT * FROM {$this->companyModsTableName} WHERE company = ".$this->db->quote($company);
        $this->db->setQuery($query);
        $list =  $this->db->loadObjectList();
        
        $mods  =  array();
        foreach ($list as $item) {
            $mods[$item->mod] = intval($item->enabled);
        }
        
        
        foreach ($allMods as $m=>$label) {
            if(!isset($mods[$m])) {
                $def        =   intval($default);
                
                if(isset($this->defaults[$m])) {
                    $def    =   intval($this->defaults[$m]);
                }
                $mods[$m]   =    $def;
            }
        }
        return $mods;
    }
    
}